/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableRowSorter;
import org.jdesktop.layout.GroupLayout;
import serpro.ppgd.formatosexternos.txt.RegistroTxt;
import serpro.ppgd.formatosexternos.txt.excecao.GeracaoTxtException;
import serpro.ppgd.gui.filechooser.FileChooser;
import serpro.ppgd.gui.filechooser.FileChooserFactory;
import serpro.ppgd.gui.filechooser.FileChooserResponse;
import serpro.ppgd.gui.filechooser.FileChooserSelectionMode;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.util.FontesUtil;
import serpro.ppgd.irpf.ColecaoIdDeclaracao;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.TableModelSelecionaDeclaracaoTransmitida;
import serpro.ppgd.irpf.gui.dialogs.SubpainelDeclaracoesTransmitidas;
import serpro.ppgd.irpf.gui.util.ProgressMonitor;
import serpro.ppgd.irpf.gui.util.ProgressUtil;
import serpro.ppgd.irpf.txt.gravacaorestauracao.RepositorioDeclaracaoCentralTxt;
import serpro.ppgd.irpf.txt.util.IRPFTxtUtil;
import serpro.ppgd.irpf.util.ConstantesGlobaisIRPF;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.ppgd.negocio.util.UtilitariosArquivo;
import serpro.ppgd.negocio.util.Validador;

public class PainelGravarCopiaDeclaracaoTransmitida
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String HELP_ID = "Como fazer para.../Gravar c\u00f3pia de seguran\u00e7a";
    private List<RepositorioDeclaracaoCentralTxt> repositorios;
    private String dirSelecionado = UtilitariosArquivo.getPathTransmitidas();
    private String reciboSelecionado = null;
    private JButton btnAjuda;
    private JButton btnAvancar;
    private JButton btnCancelar;
    private JLabel jLabel1;
    private JPanel jPanel2;
    private SubpainelDeclaracoesTransmitidas subpainelDeclaracoesTransmitidas;

    public PainelGravarCopiaDeclaracaoTransmitida(String reciboSelecionado) {
        this();
        this.reciboSelecionado = reciboSelecionado;
        boolean selecionouDeclaracao = this.selecionarDeclaracao(reciboSelecionado);
        if (selecionouDeclaracao) {
            this.avancar();
            Component c = SwingUtilities.getRoot(this);
            if (c != null) {
                ((JDialog)c).setVisible(false);
            }
        }
    }

    public PainelGravarCopiaDeclaracaoTransmitida() {
        this.initComponents();
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)this, HELP_ID);
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)this.btnAjuda, HELP_ID);
        this.atualizaTextoDirSelecionado();
        this.configurarPainelDeclaracoes();
    }

    private void configurarPainelDeclaracoes() {
        this.subpainelDeclaracoesTransmitidas.getTabela().setSelectionMode(2);
        this.subpainelDeclaracoesTransmitidas.getTabela().addDeclaracaoSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (PainelGravarCopiaDeclaracaoTransmitida.this.subpainelDeclaracoesTransmitidas.getTabela().getSelectedRowCount() > 0) {
                    PainelGravarCopiaDeclaracaoTransmitida.this.btnAvancar.setEnabled(true);
                } else {
                    PainelGravarCopiaDeclaracaoTransmitida.this.btnAvancar.setEnabled(false);
                }
            }
        });
        this.subpainelDeclaracoesTransmitidas.getTabela().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && PainelGravarCopiaDeclaracaoTransmitida.this.subpainelDeclaracoesTransmitidas.getTabela().getSelectedRowCount() > 0) {
                    PainelGravarCopiaDeclaracaoTransmitida.this.btnAvancarActionPerformed(null);
                }
            }
        });
    }

    private boolean selecionarDeclaracao(String reciboSelecionado) {
        boolean selecionouDeclaracao = false;
        TableModelSelecionaDeclaracaoTransmitida tableModel = (TableModelSelecionaDeclaracaoTransmitida)this.subpainelDeclaracoesTransmitidas.getTabela().getModel();
        int selIndice = -1;
        for (int i = 0; i < tableModel.getRowCount(); ++i) {
            String reciboAtual = String.valueOf(tableModel.getValueAt(i, 0)).split("Recibo: ")[1].replaceAll("\\.", "");
            if (!reciboAtual.equals(reciboSelecionado)) continue;
            selIndice = ((TableRowSorter)this.subpainelDeclaracoesTransmitidas.getTabela().getRowSorter()).convertRowIndexToView(i);
            break;
        }
        if (selIndice > -1) {
            this.subpainelDeclaracoesTransmitidas.getTabela().setRowSelectionInterval(selIndice, selIndice);
            selecionouDeclaracao = true;
        }
        return selecionouDeclaracao;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jPanel2 = new JPanel();
        this.btnCancelar = new JButton();
        this.btnAjuda = new JButton();
        this.btnAvancar = new JButton();
        this.subpainelDeclaracoesTransmitidas = new SubpainelDeclaracoesTransmitidas();
        this.setBackground(new Color(241, 245, 249));
        this.jLabel1.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel1.setForeground(new Color(0, 74, 106));
        this.jLabel1.setText("Selecione as declara\u00e7\u00f5es a serem copiadas e clique no bot\u00e3o Avan\u00e7ar");
        this.jPanel2.setBackground(new Color(241, 245, 249));
        this.btnCancelar.setMnemonic('C');
        this.btnCancelar.setText("Cancelar");
        this.btnCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelGravarCopiaDeclaracaoTransmitida.this.btnCancelarActionPerformed(evt);
            }
        });
        this.btnAjuda.setMnemonic('A');
        this.btnAjuda.setText("Ajuda");
        this.btnAvancar.setMnemonic('v');
        this.btnAvancar.setText("Avan\u00e7ar");
        this.btnAvancar.setEnabled(false);
        this.btnAvancar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelGravarCopiaDeclaracaoTransmitida.this.btnAvancarActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.btnAvancar, -1, 99, Short.MAX_VALUE).add((Component)this.btnCancelar, -1, 99, Short.MAX_VALUE).add((Component)this.btnAjuda, -1, 99, Short.MAX_VALUE)).addContainerGap()));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.btnAvancar).addPreferredGap(0).add((Component)this.btnCancelar).addPreferredGap(0).add((Component)this.btnAjuda).addContainerGap(137, Short.MAX_VALUE)));
        jPanel2Layout.linkSize(new Component[]{this.btnAjuda, this.btnAvancar, this.btnCancelar}, 2);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.subpainelDeclaracoesTransmitidas, -1, 714, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jPanel2, -2, -1, -2)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addContainerGap()))));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.subpainelDeclaracoesTransmitidas, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jPanel2, -2, -1, -2).add(0, 0, Short.MAX_VALUE))).addContainerGap()));
        this.jLabel1.getAccessibleContext().setAccessibleName("Selecione as declara\u00e7\u00f5es a serem copiadas e clique no bot\u00e3o Avan\u00e7ar. Para colocar o foco na tabela de declara\u00e7\u00f5es, aperte a tecla TAB, e utilize as setas para cima e para baixo para navegar pelas declara\u00e7\u00f5es.");
    }

    private void btnAvancarActionPerformed(ActionEvent evt) {
        ((JDialog)SwingUtilities.getRoot(this)).setVisible(false);
        this.avancar();
    }

    private void avancar() {
        FileChooser fc = FileChooserFactory.getInstance().createFileChooser();
        fc.setDialogTitle("Grava\u00e7\u00e3o de C\u00f3pia de Seguran\u00e7a");
        fc.setApproveButtonText("Salvar");
        fc.setApproveButtonToolTipText("Gravar C\u00f3pia de Seguran\u00e7a");
        fc.setMultiSelectionEnabled(false);
        fc.setAcceptAllFileFilterUsed(false);
        fc.setFileSelectionMode(FileChooserSelectionMode.DIRECTORIES_ONLY);
        FileChooserResponse retorno = fc.showSaveDialog((Component)PlataformaPPGD.getPlataforma().getJanelaPrincipal());
        if (retorno == FileChooserResponse.APPROVE_OPTION) {
            ExecutarGravarIdDeclaracao executarGravarIdDeclaracao = new ExecutarGravarIdDeclaracao(fc.getSelectedFile());
            executarGravarIdDeclaracao.gravar();
        }
    }

    private void btnCancelarActionPerformed(ActionEvent evt) {
        ((JDialog)SwingUtilities.getRoot(this)).setVisible(false);
    }

    private void atualizaTextoDirSelecionado() {
        String caminhoGravacao = this.dirSelecionado;
        if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            caminhoGravacao = caminhoGravacao.replaceFirst("/", "");
        }
        ((TableModelSelecionaDeclaracaoTransmitida)this.subpainelDeclaracoesTransmitidas.getTabela().getModel()).setColecaoIdDeclaracao(this.obtemListaDeclaracoesGravadas(this.dirSelecionado));
    }

    private ColecaoIdDeclaracao obtemListaDeclaracoesGravadas(String path) {
        try {
            File dir = new File(path);
            FilenameFilter filterREC = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    boolean retorno = Validador.validarString((String)name, (String)ConstantesGlobaisIRPF.PADRAO_NOME_ARQ_RECIBO) || Validador.validarString((String)name, (String)"\\d{8}.(REC|rec)");
                    return retorno;
                }
            };
            File[] filesREC = dir.listFiles(filterREC);
            this.repositorios = new ArrayList<RepositorioDeclaracaoCentralTxt>();
            ColecaoIdDeclaracao ids = new ColecaoIdDeclaracao();
            if (filesREC != null) {
                RepositorioDeclaracaoCentralTxt repositorioRecibo = null;
                RegistroTxt registroRecibo = null;
                String cpfDec = null;
                for (int i = 0; i < filesREC.length; ++i) {
                    String nomeFileREC = filesREC[i].getName();
                    try {
                        repositorioRecibo = new RepositorioDeclaracaoCentralTxt("ARQ_COMPLRECIBO", new File(path + File.separator + nomeFileREC));
                        registroRecibo = repositorioRecibo.recuperarRegistroComplementoRecibo();
                        cpfDec = registroRecibo.fieldByName("NR_CPF").asString();
                        if (cpfDec == null || cpfDec.trim().length() == 0) {
                            JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), "Erro ao ler arquivo .DEC", "Erro", 0);
                        }
                    }
                    catch (GeracaoTxtException e) {
                        e.printStackTrace();
                        LogPPGD.erro((String)e.getMessage());
                        JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), e.getMessage(), "Erro", 0);
                    }
                    File fileDEC = this.getArquivoDec(path, dir, nomeFileREC);
                    if (!fileDEC.exists()) continue;
                    try {
                        RepositorioDeclaracaoCentralTxt repDeclaracao = new RepositorioDeclaracaoCentralTxt("ARQ_IRPF", fileDEC);
                        repDeclaracao.validarDeclaracaoNaoPersistido();
                        ids.itens().add(repDeclaracao.recuperarIdDeclaracaoNaoPersistido(true));
                        this.repositorios.add(repDeclaracao);
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                        LogPPGD.erro((String)e.getMessage());
                        JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), e.getMessage(), "Erro", 0);
                        continue;
                    }
                    catch (GeracaoTxtException e) {
                        e.printStackTrace();
                        LogPPGD.erro((String)e.getMessage());
                        JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), e.getMessage(), "Erro", 0);
                    }
                }
            }
            return ids;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            LogPPGD.erro((String)ioe.getMessage());
            JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), "Erro ao acessar o diret\u00f3rio Gravadas: " + ioe.getMessage(), "Erro", 0);
            return new ColecaoIdDeclaracao();
        }
    }

    private File getArquivoDec(String path, File dir, String nomeFileRec) {
        String nomeFileDec = null;
        File retorno = null;
        if (nomeFileRec.length() > 12) {
            nomeFileDec = nomeFileRec.substring(0, nomeFileRec.length() - 4) + ".DEC";
            retorno = new File(path + File.separator + nomeFileDec);
        } else {
            FilenameFilter filterDEC = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    boolean retorno = Validador.validarString((String)name, (String)ConstantesGlobaisIRPF.PADRAO_NOME_ARQ_DECLARACAO);
                    return retorno;
                }
            };
            File[] files = dir.listFiles(filterDEC);
            File fileDecMaisAtual = null;
            for (int i = 0; i < files.length; ++i) {
                String nomeArqDecAtual = files[i].getName();
                if (fileDecMaisAtual != null && fileDecMaisAtual.lastModified() > files[i].lastModified() || !nomeArqDecAtual.substring(0, 8).equals(nomeFileRec.subSequence(0, 8))) continue;
                fileDecMaisAtual = files[i];
            }
            retorno = fileDecMaisAtual;
            if (retorno == null) {
                nomeFileDec = nomeFileRec.substring(0, nomeFileRec.length() - 4) + ".DEC";
                retorno = new File(path + File.separator + nomeFileDec);
            }
        }
        return retorno;
    }

    public void gravarCopia(int linhaSelecionada, String pathDest) {
        RepositorioDeclaracaoCentralTxt repDecl = this.repositorios.get(linhaSelecionada);
        if (repDecl != null) {
            String arqDEC = repDecl.getPath();
            int indiceUltimoSeparador = arqDEC.lastIndexOf(File.separator);
            Object arqREC = arqDEC.substring(0, arqDEC.length() - 4) + ".REC";
            String cpf = null;
            try {
                cpf = repDecl.recuperarIdDeclaracaoNaoPersistido().getCpf().naoFormatado();
            }
            catch (Exception e) {
                e.printStackTrace();
                LogPPGD.erro((String)e.getMessage());
                JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), e.getMessage(), "Erro", 0);
                return;
            }
            File fileDec = new File(arqDEC);
            File fileRec = new File((String)arqREC);
            if (!fileRec.exists()) {
                arqREC = arqDEC.substring(0, indiceUltimoSeparador + 1);
                arqREC = (String)arqREC + cpf.substring(0, 8);
                arqREC = (String)arqREC + ".REC";
                fileRec = new File((String)arqREC);
            }
            try {
                IRPFTxtUtil.copiaBinariaArquivo((String)fileDec.toString(), (String)pathDest);
                IRPFTxtUtil.copiaBinariaArquivo((String)fileRec.toString(), (String)pathDest);
            }
            catch (Exception e) {
                e.printStackTrace();
                LogPPGD.erro((String)e.getMessage());
            }
        }
    }

    class ExecutarGravarIdDeclaracao {
        private File dir = null;

        public ExecutarGravarIdDeclaracao(File _dir) {
            this.dir = _dir;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void gravar() {
            ControladorGui.iniciarGravacaoDemonstrativo();
            String path = "";
            int[] linhasSelecionadas = PainelGravarCopiaDeclaracaoTransmitida.this.subpainelDeclaracoesTransmitidas.getTabela().getSelectedRows();
            int[] rows = new int[linhasSelecionadas.length];
            for (int a = 0; a < rows.length; ++a) {
                rows[a] = ((TableRowSorter)PainelGravarCopiaDeclaracaoTransmitida.this.subpainelDeclaracoesTransmitidas.getTabela().getRowSorter()).convertRowIndexToModel(linhasSelecionadas[a]);
            }
            ProgressMonitor monitor = ProgressUtil.createProgressMonitor(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), rows.length, false, 500, "Gravando");
            try {
                if (rows.length > 0) {
                    path = this.dir.getPath();
                    boolean emiteMsgSucesso = false;
                    for (int i = 0; i < rows.length; ++i) {
                        if (i == 0) {
                            monitor.start("Gravando " + (i + 1) + " de " + rows.length);
                        } else {
                            monitor.setCurrent("Gravando " + (i + 1) + " de " + rows.length, i + 1);
                        }
                        if (path.equals("")) continue;
                        PainelGravarCopiaDeclaracaoTransmitida.this.gravarCopia(rows[i], path);
                        emiteMsgSucesso = true;
                    }
                    if (emiteMsgSucesso) {
                        JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), "Grava\u00e7\u00e3o conclu\u00edda com sucesso.", "Informa\u00e7\u00e3o", 1);
                    } else {
                        JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), "Grava\u00e7\u00e3o cancelada pelo usu\u00e1rio.", "Informa\u00e7\u00e3o", 1);
                    }
                }
            }
            finally {
                if (monitor != null) {
                    monitor.setCurrent("Conclu\u00eddo", rows.length);
                }
                ControladorGui.terminarGravacaoDemonstrativo();
            }
        }
    }
}

