/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.declaracao.assistida.informerendimentos;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import serpro.ppgd.gui.xbeans.autocomplete.JAutoCompleteEditAlfa;
import serpro.ppgd.infraestrutura.util.FontesUtil;
import serpro.ppgd.irpf.alimentandos.Alimentando;
import serpro.ppgd.irpf.declaracao.assistida.informerendimentos.ItemPagamento;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.ElementoTabela;
import serpro.ppgd.negocio.Observador;

public class PainelItemPensaoAlimenticia
extends JPanel {
    private static final long serialVersionUID = 1L;
    private ItemPagamento pensaoAlimenticia;
    List<ElementoTabela> alimentandosPodemAssociarPagamentos;
    private ButtonGroup btnGroupResidencia;
    private JAutoCompleteEditAlfa cmbAlimentando;
    private JLabel lbl13Salario;
    private JLabel lblCPFAlimentando;
    private JLabel lblNomeAlimentando;
    private JLabel lblOBSNaoImportar;
    private JLabel lblSelecaoAlimentando;
    private JLabel lblSeparador;
    private JLabel lblTipoPensao;
    private JLabel lblValorPago;
    private JPanel painelSelecaoAlimentando;
    private JPanel painelTipoPensao;
    private JRadioButton rdPensaoDivorcioSeparacao;
    private JRadioButton rdPensaoJudicial;

    public PainelItemPensaoAlimenticia(ItemPagamento pensaoAlimenticia, boolean ultimo) {
        this.pensaoAlimenticia = pensaoAlimenticia;
        this.initComponents();
        this.lblSeparador.setVisible(!ultimo);
        this.preencherCampos();
        this.adicionarEventosRadiosTipoPensao();
        this.configuraExibicaoPainelTipoPensao();
    }

    private void preencherCampos() {
        this.lblCPFAlimentando.setText("<html><b>CPF do Alimentando:</b> " + this.pensaoAlimenticia.getCpfBeneficiario().formatado() + "</html>");
        this.lblNomeAlimentando.setText("<html><b>Nome do Alimentando:</b> " + this.pensaoAlimenticia.getNomeBeneficiario().formatado() + "</html>");
        this.lblValorPago.setText("<html><b>Valor Pago:</b> R$ " + this.pensaoAlimenticia.getValorPago().formatado() + "</html>");
        this.lbl13Salario.setText("<html><b>13\u00ba sal\u00e1rio:</b> R$ " + this.pensaoAlimenticia.getValorDecimoTerceiro().formatado() + "</html>");
        if (this.pensaoAlimenticia.getCpfBeneficiario().isVazio()) {
            this.adcionarEventoOkCombo();
            this.alimentandosPodemAssociarPagamentos = CadastroTabelasIRPF.recuperarAlimentandosResidentesInforme();
            if (this.alimentandosPodemAssociarPagamentos.size() > 0) {
                this.cmbAlimentando.setDados(this.alimentandosPodemAssociarPagamentos);
                this.painelSelecaoAlimentando.setVisible(true);
            } else {
                this.painelSelecaoAlimentando.setVisible(false);
            }
        } else {
            Alimentando alimentando = ControladorGui.getDemonstrativoAberto().getAlimentandos().getAlimentandoByCpf(this.pensaoAlimenticia.getCpfBeneficiario().naoFormatado());
            if (alimentando != null) {
                this.pensaoAlimenticia.getCpfBeneficiarioSelecionado().setConteudo(alimentando.getCpf().naoFormatado());
                this.pensaoAlimenticia.getNomeBeneficiarioSelecionado().setConteudo(alimentando.getNome().naoFormatado());
                this.pensaoAlimenticia.getTipoResidencia().setConteudo(alimentando.getResidente().naoFormatado());
            }
            this.painelSelecaoAlimentando.setVisible(false);
        }
        String msgErro = this.obterMensagemOBSNaoImportar();
        if (msgErro != null) {
            this.lblOBSNaoImportar.setVisible(true);
            this.lblOBSNaoImportar.setText(msgErro);
            this.pensaoAlimenticia.setImportar(false);
        } else {
            this.lblOBSNaoImportar.setVisible(false);
        }
    }

    private void configuraExibicaoPainelTipoPensao() {
        if (this.obterMensagemOBSNaoImportar() != null) {
            this.painelTipoPensao.setVisible(false);
        } else if (this.pensaoAlimenticia.getCpfBeneficiario().isVazio()) {
            this.painelTipoPensao.setVisible(false);
        } else if (this.pensaoAlimenticia.getTipoResidencia().naoFormatado().equals("2")) {
            this.painelTipoPensao.setVisible(false);
        }
    }

    private void adicionarEventosRadiosTipoPensao() {
        this.rdPensaoJudicial.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (PainelItemPensaoAlimenticia.this.rdPensaoJudicial.isSelected()) {
                    PainelItemPensaoAlimenticia.this.lblTipoPensao.setIcon(new ImageIcon(this.getClass().getResource("/icones/png20px/MN_verificar.png")));
                    PainelItemPensaoAlimenticia.this.pensaoAlimenticia.getTipoPensaoAlimenticia().setConteudo("1");
                }
            }
        });
        this.rdPensaoDivorcioSeparacao.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (PainelItemPensaoAlimenticia.this.rdPensaoDivorcioSeparacao.isSelected()) {
                    PainelItemPensaoAlimenticia.this.lblTipoPensao.setIcon(new ImageIcon(this.getClass().getResource("/icones/png20px/MN_verificar.png")));
                    PainelItemPensaoAlimenticia.this.pensaoAlimenticia.getTipoPensaoAlimenticia().setConteudo("2");
                }
            }
        });
    }

    private void adcionarEventoOkCombo() {
        this.cmbAlimentando.getInformacao().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                String val = (String)valorNovo;
                if (!val.isEmpty() && !val.equals("-1")) {
                    String[] vals = val.split("\\|");
                    if (vals.length == 3) {
                        PainelItemPensaoAlimenticia.this.pensaoAlimenticia.getCpfBeneficiarioSelecionado().setConteudo(vals[0]);
                        PainelItemPensaoAlimenticia.this.pensaoAlimenticia.getNomeBeneficiarioSelecionado().setConteudo(vals[1]);
                        PainelItemPensaoAlimenticia.this.pensaoAlimenticia.getTipoResidencia().setConteudo(vals[2]);
                    }
                } else {
                    PainelItemPensaoAlimenticia.this.pensaoAlimenticia.getCpfBeneficiarioSelecionado().clear();
                    PainelItemPensaoAlimenticia.this.pensaoAlimenticia.getNomeBeneficiarioSelecionado().clear();
                    PainelItemPensaoAlimenticia.this.pensaoAlimenticia.getTipoResidencia().clear();
                }
            }
        });
        ((JComboBox)this.cmbAlimentando.getComponenteEditor()).addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                int indice = ((JComboBox)PainelItemPensaoAlimenticia.this.cmbAlimentando.getComponenteEditor()).getSelectedIndex();
                if (indice == -1) {
                    PainelItemPensaoAlimenticia.this.lblSelecaoAlimentando.setIcon(new ImageIcon(this.getClass().getResource("/icones/png16px/erro.png")));
                    PainelItemPensaoAlimenticia.this.painelTipoPensao.setVisible(false);
                } else {
                    PainelItemPensaoAlimenticia.this.lblSelecaoAlimentando.setIcon(new ImageIcon(this.getClass().getResource("/icones/png20px/MN_verificar.png")));
                    PainelItemPensaoAlimenticia.this.painelTipoPensao.setVisible(true);
                }
                PainelItemPensaoAlimenticia.this.btnGroupResidencia.clearSelection();
                PainelItemPensaoAlimenticia.this.pensaoAlimenticia.getTipoPensaoAlimenticia().clear();
                PainelItemPensaoAlimenticia.this.lblTipoPensao.setIcon(new ImageIcon(this.getClass().getResource("/icones/png16px/erro.png")));
            }
        });
    }

    private String obterMensagemOBSNaoImportar() {
        String msgRetorno = null;
        if (this.pensaoAlimenticia.getCpfBeneficiario().isVazio()) {
            if (CadastroTabelasIRPF.recuperarAlimentandosResidentesInforme().size() == 0) {
                msgRetorno = MensagemUtil.getMensagem((String)"nao_importar_pensao_sem_alimentando_correspondente");
            }
        } else if (ControladorGui.getDemonstrativoAberto().getAlimentandos().isExisteCPF(this.pensaoAlimenticia.getCpfBeneficiario().naoFormatado())) {
            if (ControladorGui.getDemonstrativoAberto().getAlimentandos().getAlimentandoByCpf(this.pensaoAlimenticia.getCpfBeneficiario().naoFormatado()).getResidente().naoFormatado().equals("2")) {
                msgRetorno = MensagemUtil.getMensagem((String)"nao_importar_pensao_alimentando_sem_residencia");
            }
        } else {
            msgRetorno = MensagemUtil.getMensagem((String)"nao_importar_pensao_sem_alimentando_correspondente");
        }
        return msgRetorno;
    }

    private void initComponents() {
        this.btnGroupResidencia = new ButtonGroup();
        this.lblCPFAlimentando = new JLabel();
        this.lblNomeAlimentando = new JLabel();
        this.lblValorPago = new JLabel();
        this.lblSeparador = new JLabel();
        this.lblOBSNaoImportar = new JLabel();
        this.painelSelecaoAlimentando = new JPanel();
        this.lblSelecaoAlimentando = new JLabel();
        this.cmbAlimentando = new JAutoCompleteEditAlfa();
        this.painelTipoPensao = new JPanel();
        this.lblTipoPensao = new JLabel();
        this.rdPensaoJudicial = new JRadioButton();
        this.rdPensaoDivorcioSeparacao = new JRadioButton();
        this.lbl13Salario = new JLabel();
        this.btnGroupResidencia.add(this.rdPensaoJudicial);
        this.btnGroupResidencia.add(this.rdPensaoDivorcioSeparacao);
        this.setBackground(new Color(255, 255, 255));
        this.lblCPFAlimentando.setFont(FontesUtil.FONTE_NORMAL);
        this.lblCPFAlimentando.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblCPFAlimentando.setText("<html><b>CPF do Alimentando:");
        this.lblCPFAlimentando.setAlignmentY(0.0f);
        this.lblNomeAlimentando.setFont(FontesUtil.FONTE_NORMAL);
        this.lblNomeAlimentando.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblNomeAlimentando.setText("<html><b>Nome do Alimentando:");
        this.lblNomeAlimentando.setAlignmentY(0.0f);
        this.lblValorPago.setFont(FontesUtil.FONTE_NORMAL);
        this.lblValorPago.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblValorPago.setText("<html><b>Valor Pago:");
        this.lblValorPago.setAlignmentY(0.0f);
        this.lblSeparador.setFont(FontesUtil.FONTE_NORMAL);
        this.lblSeparador.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblSeparador.setText("                  ");
        this.lblSeparador.setBorder(BorderFactory.createMatteBorder(2, 0, 0, 0, new Color(189, 189, 189)));
        this.lblOBSNaoImportar.setFont(FontesUtil.FONTE_NORMAL);
        this.lblOBSNaoImportar.setForeground(new Color(234, 84, 84));
        this.lblOBSNaoImportar.setText("OBS: Este Pagamento de pens\u00e3o aliment\u00edcia n\u00e3o ser\u00e1 importado por n\u00e3o existir alimentando correspondente na declara\u00e7\u00e3o.");
        this.painelSelecaoAlimentando.setBackground(new Color(255, 255, 255));
        this.painelSelecaoAlimentando.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.lblSelecaoAlimentando.setFont(FontesUtil.FONTE_NORMAL);
        this.lblSelecaoAlimentando.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblSelecaoAlimentando.setIcon(new ImageIcon(this.getClass().getResource("/icones/png16px/erro.png")));
        this.lblSelecaoAlimentando.setText("Selecione o Alimentando correspondente para esta Pens\u00e3o Aliment\u00edcia:");
        this.lblSelecaoAlimentando.setAlignmentY(0.0f);
        GroupLayout painelSelecaoAlimentandoLayout = new GroupLayout(this.painelSelecaoAlimentando);
        this.painelSelecaoAlimentando.setLayout(painelSelecaoAlimentandoLayout);
        painelSelecaoAlimentandoLayout.setHorizontalGroup(painelSelecaoAlimentandoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(painelSelecaoAlimentandoLayout.createSequentialGroup().addGroup(painelSelecaoAlimentandoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblSelecaoAlimentando).addComponent((Component)this.cmbAlimentando, -2, 590, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        painelSelecaoAlimentandoLayout.setVerticalGroup(painelSelecaoAlimentandoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(painelSelecaoAlimentandoLayout.createSequentialGroup().addComponent(this.lblSelecaoAlimentando, -2, 31, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.cmbAlimentando, -2, -1, -2)));
        this.painelTipoPensao.setBackground(new Color(255, 255, 255));
        this.lblTipoPensao.setFont(FontesUtil.FONTE_NORMAL);
        this.lblTipoPensao.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblTipoPensao.setIcon(new ImageIcon(this.getClass().getResource("/icones/png16px/erro.png")));
        this.lblTipoPensao.setText("Informe o tipo de pens\u00e3o aliment\u00edcia:");
        this.rdPensaoJudicial.setFont(FontesUtil.FONTE_NORMAL);
        this.rdPensaoJudicial.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.rdPensaoJudicial.setText("Judicial");
        this.rdPensaoJudicial.setBackground(Color.WHITE);
        this.rdPensaoDivorcioSeparacao.setFont(FontesUtil.FONTE_NORMAL);
        this.rdPensaoDivorcioSeparacao.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.rdPensaoDivorcioSeparacao.setText("Separa\u00e7\u00e3o / Div\u00f3rcio por escritura p\u00fablica");
        this.rdPensaoDivorcioSeparacao.setBackground(Color.WHITE);
        GroupLayout painelTipoPensaoLayout = new GroupLayout(this.painelTipoPensao);
        this.painelTipoPensao.setLayout(painelTipoPensaoLayout);
        painelTipoPensaoLayout.setHorizontalGroup(painelTipoPensaoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(painelTipoPensaoLayout.createSequentialGroup().addComponent(this.lblTipoPensao).addGap(39, 39, 39).addComponent(this.rdPensaoJudicial).addGap(18, 18, 18).addComponent(this.rdPensaoDivorcioSeparacao).addContainerGap(-1, Short.MAX_VALUE)));
        painelTipoPensaoLayout.setVerticalGroup(painelTipoPensaoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(painelTipoPensaoLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblTipoPensao).addComponent(this.rdPensaoJudicial).addComponent(this.rdPensaoDivorcioSeparacao)));
        this.lbl13Salario.setFont(FontesUtil.FONTE_NORMAL);
        this.lbl13Salario.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lbl13Salario.setText("<html><b>Valor Pago:");
        this.lbl13Salario.setAlignmentY(0.0f);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblSeparador, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.painelSelecaoAlimentando, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblValorPago, -2, 213, -2).addComponent(this.lblCPFAlimentando, -2, 280, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblNomeAlimentando).addGroup(layout.createSequentialGroup().addComponent(this.lbl13Salario, -2, 213, -2).addGap(0, 0, Short.MAX_VALUE)))).addComponent(this.lblOBSNaoImportar, -2, 819, Short.MAX_VALUE).addComponent(this.painelTipoPensao, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblCPFAlimentando, -2, 16, -2).addComponent(this.lblNomeAlimentando, -2, 16, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblValorPago, -2, 16, -2).addComponent(this.lbl13Salario, -2, 16, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.painelSelecaoAlimentando, -2, -1, -2).addGap(18, 18, 18).addComponent(this.painelTipoPensao, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblOBSNaoImportar).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 17, Short.MAX_VALUE).addComponent(this.lblSeparador)));
    }
}

