/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.declaracao.assistida.informeplanosaude;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.util.FontesUtil;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.declaracao.assistida.informeplanosaude.InformePagamentosPlanoSaude;
import serpro.ppgd.irpf.declaracao.assistida.informeplanosaude.ItemPagamentoPlanoSaude;
import serpro.ppgd.irpf.declaracao.assistida.informeplanosaude.ItemReembolsoPlanoSaude;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.NavegacaoIf;
import serpro.ppgd.irpf.gui.PainelDemonstrativoAb;
import serpro.ppgd.irpf.gui.PainelDemonstrativoIf;
import serpro.ppgd.irpf.gui.declaracao.assistida.informeplanosaude.PainelItemPagamentosPlanoSaude;
import serpro.ppgd.irpf.gui.declaracao.assistida.informeplanosaude.PainelItemReembolsosPlanoSaude;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.pagamentos.Pagamento;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.util.FabricaUtilitarios;

public class PainelPrevisualizadorDeclaracaoAssistidaInformePlanoSaude
extends PainelDemonstrativoAb {
    private static final long serialVersionUID = 1L;
    private static final String TITULO = "Informe de Pagamento a Planos de Sa\u00fade no Brasil";
    private static final String HELP_ID = "Como fazer para.../Importar informe de plano de sa\u00fade";
    private InformePagamentosPlanoSaude informePlanoSaude;
    private boolean podeSair = false;
    private boolean valorPagoOpened = true;
    private boolean valorReembolsadoOpened = true;
    private JButton btnPagamentoPremio;
    private JButton btnReembolso;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel9;
    private JScrollPane jScrollPane1;
    private JLabel lblHeaderAnoCalendario;
    private JLabel lblHeaderAnoExercicio;
    private JLabel lblHeaderCPFContribuinte;
    private JLabel lblHeaderNiOperadoraPlanoSaude;
    private JLabel lblHeaderNomeContribuinte;
    private JLabel lblHeaderNomeFontePagadora;
    private JPanel panelInternoValorPago;
    private JPanel panelInternoValorReembolsado;
    private JPanel panelPrincipalValorPago;
    private JPanel panelPrincipalValorReembolsado;

    public PainelPrevisualizadorDeclaracaoAssistidaInformePlanoSaude(InformePagamentosPlanoSaude informePlanoSaude, PainelDemonstrativoIf painelExibidoAntesDaImportacao) {
        this.informePlanoSaude = informePlanoSaude;
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)this, HELP_ID);
        this.initComponents();
        this.preencherCabecalho();
        this.preencherValorPago();
        this.preencherValorReembolsado();
    }

    public boolean isValorPagoOpened() {
        return this.valorPagoOpened;
    }

    public void setValorPagoOpened(boolean valorPagoOpened) {
        this.valorPagoOpened = valorPagoOpened;
    }

    public boolean isValorReembolsadoOpened() {
        return this.valorReembolsadoOpened;
    }

    public void setValorReembolsadoOpened(boolean valorReembolsadoOpened) {
        this.valorReembolsadoOpened = valorReembolsadoOpened;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jPanel3 = new JPanel();
        this.lblHeaderAnoExercicio = new JLabel();
        this.lblHeaderCPFContribuinte = new JLabel();
        this.lblHeaderAnoCalendario = new JLabel();
        this.lblHeaderNomeContribuinte = new JLabel();
        this.lblHeaderNiOperadoraPlanoSaude = new JLabel();
        this.lblHeaderNomeFontePagadora = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jPanel4 = new JPanel();
        this.panelPrincipalValorPago = new JPanel();
        this.jPanel5 = new JPanel();
        this.btnPagamentoPremio = new JButton();
        this.panelInternoValorPago = new JPanel();
        this.panelPrincipalValorReembolsado = new JPanel();
        this.jPanel9 = new JPanel();
        this.btnReembolso = new JButton();
        this.panelInternoValorReembolsado = new JPanel();
        this.jLabel1 = new JLabel();
        this.setBackground(new Color(241, 245, 249));
        this.setForeground(new Color(255, 255, 255));
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.jPanel1.setBorder(BorderFactory.createLineBorder(new Color(211, 222, 232)));
        this.jLabel2.setText("    ");
        this.jPanel3.setBackground(new Color(255, 255, 255));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(null, "Dados de Identifica\u00e7\u00e3o", 0, 0, FontesUtil.FONTE_TITULO_MENOR, new Color(0, 74, 106)));
        this.lblHeaderAnoExercicio.setFont(FontesUtil.FONTE_NORMAL);
        this.lblHeaderAnoExercicio.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblHeaderAnoExercicio.setText("Ano de Exerc\u00edcio:");
        this.lblHeaderAnoExercicio.setAlignmentY(0.0f);
        this.lblHeaderCPFContribuinte.setFont(FontesUtil.FONTE_NORMAL);
        this.lblHeaderCPFContribuinte.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblHeaderCPFContribuinte.setText("CPF do Contribuinte:");
        this.lblHeaderCPFContribuinte.setAlignmentY(0.0f);
        this.lblHeaderAnoCalendario.setFont(FontesUtil.FONTE_NORMAL);
        this.lblHeaderAnoCalendario.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblHeaderAnoCalendario.setText("Ano Calend\u00e1rio:");
        this.lblHeaderAnoCalendario.setAlignmentY(0.0f);
        this.lblHeaderNomeContribuinte.setFont(FontesUtil.FONTE_NORMAL);
        this.lblHeaderNomeContribuinte.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblHeaderNomeContribuinte.setText("Nome do Contribuinte:");
        this.lblHeaderNomeContribuinte.setAlignmentY(0.0f);
        this.lblHeaderNiOperadoraPlanoSaude.setFont(FontesUtil.FONTE_NORMAL);
        this.lblHeaderNiOperadoraPlanoSaude.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblHeaderNiOperadoraPlanoSaude.setText("CNPJ da Operadora do Plano de Sa\u00fade:");
        this.lblHeaderNiOperadoraPlanoSaude.setAlignmentY(0.0f);
        this.lblHeaderNomeFontePagadora.setBackground(new Color(255, 255, 255));
        this.lblHeaderNomeFontePagadora.setFont(FontesUtil.FONTE_NORMAL);
        this.lblHeaderNomeFontePagadora.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblHeaderNomeFontePagadora.setText("Nome da Operadora do Plano de Sa\u00fade:");
        this.lblHeaderNomeFontePagadora.setAlignmentY(0.0f);
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.lblHeaderNiOperadoraPlanoSaude, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.lblHeaderNomeContribuinte, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.lblHeaderCPFContribuinte, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addGap(12, 12, 12)).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblHeaderNomeFontePagadora, -1, -1, Short.MAX_VALUE).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.lblHeaderAnoExercicio, -2, 147, -2).addGap(18, 18, 18).addComponent(this.lblHeaderAnoCalendario, -2, 147, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()))));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.lblHeaderNomeFontePagadora, -2, 16, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblHeaderNiOperadoraPlanoSaude, -2, 16, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblHeaderNomeContribuinte, -2, 16, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblHeaderCPFContribuinte, -2, 16, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblHeaderAnoExercicio, -2, 16, -2).addComponent(this.lblHeaderAnoCalendario, -2, 16, -2))));
        this.jScrollPane1.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jScrollPane1.setBorder(null);
        this.jPanel4.setBackground(new Color(255, 255, 255));
        this.jPanel4.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.panelPrincipalValorPago.setBackground(new Color(255, 255, 255));
        this.panelPrincipalValorPago.setBorder(BorderFactory.createLineBorder(new Color(195, 195, 195)));
        this.jPanel5.setBackground(new Color(205, 224, 239));
        this.btnPagamentoPremio.setBackground(new Color(255, 255, 255));
        this.btnPagamentoPremio.setFont(FontesUtil.FONTE_TITULO_MENOR);
        this.btnPagamentoPremio.setForeground(new Color(0, 74, 106));
        this.btnPagamentoPremio.setIcon(new ImageIcon(this.getClass().getResource("/icones/menos.png")));
        this.btnPagamentoPremio.setText("Pagamentos a Plano de Sa\u00fade");
        this.btnPagamentoPremio.setBorder(null);
        this.btnPagamentoPremio.setBorderPainted(false);
        this.btnPagamentoPremio.setContentAreaFilled(false);
        this.btnPagamentoPremio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelPrevisualizadorDeclaracaoAssistidaInformePlanoSaude.this.btnPagamentoPremioActionPerformed(evt);
            }
        });
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addComponent(this.btnPagamentoPremio).addGap(0, 392, Short.MAX_VALUE)));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel5Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.btnPagamentoPremio)));
        this.panelInternoValorPago.setBackground(new Color(255, 255, 255));
        this.panelInternoValorPago.setLayout(new BoxLayout(this.panelInternoValorPago, 1));
        GroupLayout panelPrincipalValorPagoLayout = new GroupLayout(this.panelPrincipalValorPago);
        this.panelPrincipalValorPago.setLayout(panelPrincipalValorPagoLayout);
        panelPrincipalValorPagoLayout.setHorizontalGroup(panelPrincipalValorPagoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel5, -1, -1, Short.MAX_VALUE).addComponent(this.panelInternoValorPago, -1, -1, Short.MAX_VALUE));
        panelPrincipalValorPagoLayout.setVerticalGroup(panelPrincipalValorPagoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelPrincipalValorPagoLayout.createSequentialGroup().addComponent(this.jPanel5, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 14, Short.MAX_VALUE).addComponent(this.panelInternoValorPago, -2, -1, -2)));
        this.panelPrincipalValorReembolsado.setBackground(new Color(255, 255, 255));
        this.panelPrincipalValorReembolsado.setBorder(BorderFactory.createLineBorder(new Color(195, 195, 195)));
        this.jPanel9.setBackground(new Color(205, 224, 239));
        this.btnReembolso.setBackground(new Color(255, 255, 255));
        this.btnReembolso.setFont(FontesUtil.FONTE_TITULO_MENOR);
        this.btnReembolso.setForeground(new Color(0, 74, 106));
        this.btnReembolso.setIcon(new ImageIcon(this.getClass().getResource("/icones/menos.png")));
        this.btnReembolso.setText("Reembolsos");
        this.btnReembolso.setBorder(null);
        this.btnReembolso.setBorderPainted(false);
        this.btnReembolso.setContentAreaFilled(false);
        this.btnReembolso.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelPrevisualizadorDeclaracaoAssistidaInformePlanoSaude.this.btnReembolsoActionPerformed(evt);
            }
        });
        GroupLayout jPanel9Layout = new GroupLayout(this.jPanel9);
        this.jPanel9.setLayout(jPanel9Layout);
        jPanel9Layout.setHorizontalGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel9Layout.createSequentialGroup().addComponent(this.btnReembolso).addGap(0, 0, Short.MAX_VALUE)));
        jPanel9Layout.setVerticalGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel9Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.btnReembolso)));
        this.panelInternoValorReembolsado.setBackground(new Color(255, 255, 255));
        this.panelInternoValorReembolsado.setLayout(new BoxLayout(this.panelInternoValorReembolsado, 1));
        GroupLayout panelPrincipalValorReembolsadoLayout = new GroupLayout(this.panelPrincipalValorReembolsado);
        this.panelPrincipalValorReembolsado.setLayout(panelPrincipalValorReembolsadoLayout);
        panelPrincipalValorReembolsadoLayout.setHorizontalGroup(panelPrincipalValorReembolsadoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel9, -1, -1, Short.MAX_VALUE).addComponent(this.panelInternoValorReembolsado, -1, -1, Short.MAX_VALUE));
        panelPrincipalValorReembolsadoLayout.setVerticalGroup(panelPrincipalValorReembolsadoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelPrincipalValorReembolsadoLayout.createSequentialGroup().addComponent(this.jPanel9, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 14, Short.MAX_VALUE).addComponent(this.panelInternoValorReembolsado, -2, -1, -2)));
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.panelPrincipalValorPago, -1, -1, Short.MAX_VALUE).addComponent(this.panelPrincipalValorReembolsado, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.panelPrincipalValorPago, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.panelPrincipalValorReembolsado, -2, -1, -2)));
        this.jScrollPane1.setViewportView(this.jPanel4);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 61, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2, -2, 9, -2).addContainerGap()));
        this.jLabel1.setFont(FontesUtil.FONTE_TITULO_NORMAL);
        this.jLabel1.setForeground(new Color(0, 74, 106));
        this.jLabel1.setText("Importa\u00e7\u00e3o de Informe de Pagamentos Efetuados a Planos de Sa\u00fade no Brasil");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addGap(0, 183, Short.MAX_VALUE)).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void btnPagamentoPremioActionPerformed(ActionEvent evt) {
        if (this.isValorPagoOpened()) {
            this.btnPagamentoPremio.setIcon(GuiUtil.getImage("/icones/mais.png"));
            this.panelInternoValorPago.setVisible(false);
        } else {
            this.btnPagamentoPremio.setIcon(GuiUtil.getImage("/icones/menos.png"));
            this.panelInternoValorPago.setVisible(true);
        }
        this.setValorPagoOpened(!this.isValorPagoOpened());
    }

    private void btnReembolsoActionPerformed(ActionEvent evt) {
        if (this.isValorReembolsadoOpened()) {
            this.btnReembolso.setIcon(GuiUtil.getImage("/icones/mais.png"));
            this.panelInternoValorReembolsado.setVisible(false);
        } else {
            this.btnReembolso.setIcon(GuiUtil.getImage("/icones/menos.png"));
            this.panelInternoValorReembolsado.setVisible(true);
        }
        this.setValorReembolsadoOpened(!this.isValorReembolsadoOpened());
    }

    @Override
    public boolean isPodeSair() {
        return this.podeSair || GuiUtil.mostrarConfirma(ControladorGui.getJanelaPrincipal(), MensagemUtil.getMensagem((String)"importar_informe_plano_saude_desistir"));
    }

    @Override
    public ImageIcon getImagemTitulo() {
        return GuiUtil.getImage("/icones/png40px/RE_rend.png");
    }

    @Override
    public JComponent getDefaultFocus() {
        if (this.panelInternoValorPago.isVisible()) {
            return this.btnPagamentoPremio;
        }
        if (this.panelInternoValorReembolsado.isVisible()) {
            return this.btnReembolso;
        }
        return this;
    }

    @Override
    public String getTituloPainel() {
        return TITULO;
    }

    @Override
    public boolean isTelaComVoltar() {
        return true;
    }

    @Override
    public boolean isTelaComCancelar() {
        return true;
    }

    @Override
    public void executaCancelar() {
        ControladorGui.acionarPainel(NavegacaoIf.PAINEL_IDENTIFICACAO_CONTRIBUINTE);
    }

    @Override
    public void executaVoltar() {
        if (this.temPendenciasInforme(this.informePlanoSaude)) {
            GuiUtil.mostrarAviso(null, "Para confirmar a importa\u00e7\u00e3o, \u00e9 necess\u00e1rio resolver todas as pend\u00eancias presentes no informe.");
        } else {
            this.importarDadosInformeRendPJ(this.informePlanoSaude, ControladorGui.getDemonstrativoAberto());
            this.podeSair = true;
            ControladorGui.acionarPainel(NavegacaoIf.PAINEL_IDENTIFICACAO_CONTRIBUINTE);
        }
    }

    @Override
    public String getHelpID() {
        return HELP_ID;
    }

    public boolean temPendenciasInforme(InformePagamentosPlanoSaude informe) {
        List pendencias = FabricaUtilitarios.verificarPendencias((Object)informe);
        return pendencias.size() > 0;
    }

    private void preencherCabecalho() {
        this.lblHeaderNomeFontePagadora.setText("<html><b>Nome da Operadora do Plano de Sa\u00fade:</b> " + this.informePlanoSaude.getHeader().getNomeOperadoraPlanoSaude().formatado() + "</html>");
        this.lblHeaderNiOperadoraPlanoSaude.setText("<html><b>CNPJ da Operadora do Plano de Sa\u00fade:</b> " + this.informePlanoSaude.getHeader().getCnpjOperadoraPlanoSaude().formatado() + "</html>");
        this.lblHeaderNomeContribuinte.setText("<html><b>Nome do Contribuinte:</b> " + this.informePlanoSaude.getHeader().getNomeContribuinte().formatado() + "</html>");
        this.lblHeaderCPFContribuinte.setText("<html><b>CPF do Contribuinte:</b> " + this.informePlanoSaude.getHeader().getCpfContribuinte().formatado() + "</html>");
        this.lblHeaderAnoExercicio.setText("<html><b>Ano de Exerc\u00edcio:</b> " + this.informePlanoSaude.getHeader().getAnoExercicio().formatado() + "</html>");
        this.lblHeaderAnoCalendario.setText("<html><b>Ano Calend\u00e1rio:</b> " + this.informePlanoSaude.getHeader().getAnoCalendario().formatado() + "</html>");
    }

    private void preencherValorPago() {
        int quantidadeItens = this.informePlanoSaude.getColecaoValorPago().itens().size();
        if (quantidadeItens == 0) {
            this.panelPrincipalValorPago.setVisible(false);
        } else {
            this.panelPrincipalValorPago.setVisible(true);
            int contador = 0;
            Iterator itValorPago = this.informePlanoSaude.getColecaoValorPago().itens().iterator();
            while (itValorPago.hasNext()) {
                this.panelInternoValorPago.add(new PainelItemPagamentosPlanoSaude((ItemPagamentoPlanoSaude)itValorPago.next(), ++contador == quantidadeItens));
            }
        }
    }

    private void preencherValorReembolsado() {
        int quantidadeItens = this.informePlanoSaude.getColecaoValorReembolsado().itens().size();
        if (quantidadeItens == 0) {
            this.panelPrincipalValorReembolsado.setVisible(false);
        } else {
            this.panelPrincipalValorReembolsado.setVisible(true);
            int contador = 0;
            Iterator itValorReembolsado = this.informePlanoSaude.getColecaoValorReembolsado().itens().iterator();
            while (itValorReembolsado.hasNext()) {
                this.panelInternoValorReembolsado.add(new PainelItemReembolsosPlanoSaude((ItemReembolsoPlanoSaude)itValorReembolsado.next(), ++contador == quantidadeItens));
            }
        }
    }

    public void importarDadosInformeRendPJ(InformePagamentosPlanoSaude informe, DeclaracaoIRPF dec) {
        Pagamento pagamento;
        ItemPagamentoPlanoSaude itemPagamento;
        List itens = informe.getColecaoValorPago().itens();
        for (ObjetoNegocio item : itens) {
            itemPagamento = (ItemPagamentoPlanoSaude)item;
            if (!itemPagamento.isImportar()) continue;
            pagamento = new Pagamento(dec);
            dec.getPagamentos().itens().add(pagamento);
            pagamento.getCodigo().setConteudo(itemPagamento.getCodigo().naoFormatado());
            if (itemPagamento.getTipoBeneficiario().naoFormatado().equals("1")) {
                pagamento.getTipo().setConteudo("T");
            } else {
                if (itemPagamento.getTipoBeneficiario().naoFormatado().equals("2")) {
                    pagamento.getTipo().setConteudo("D");
                    pagamento.getCPFDependente().setConteudo(itemPagamento.getCpfBeneficiarioSelecionado().naoFormatado());
                } else if (itemPagamento.getTipoBeneficiario().naoFormatado().equals("3")) {
                    pagamento.getTipo().setConteudo("A");
                    pagamento.getCPFAlimentando().setConteudo(itemPagamento.getCpfBeneficiarioSelecionado().naoFormatado());
                }
                pagamento.getDependenteOuAlimentando().setConteudo(itemPagamento.getNomeBeneficiarioSelecionado().naoFormatado());
            }
            pagamento.getNiBeneficiario().setConteudo(informe.getHeader().getCnpjOperadoraPlanoSaude().naoFormatado());
            pagamento.getNomeBeneficiario().setConteudo(informe.getHeader().getNomeOperadoraPlanoSaude().naoFormatado());
            pagamento.getValorPago().setConteudo(itemPagamento.getValorPago().naoFormatado());
        }
        itens = informe.getColecaoValorReembolsado().itens();
        for (ObjetoNegocio item : itens) {
            itemPagamento = (ItemReembolsoPlanoSaude)item;
            if (!itemPagamento.isImportar()) continue;
            pagamento = new Pagamento(dec);
            dec.getPagamentos().itens().add(pagamento);
            pagamento.getCodigo().setConteudo(itemPagamento.getCodigo().naoFormatado());
            if (itemPagamento.getTipoBeneficiario().naoFormatado().equals("1")) {
                pagamento.getTipo().setConteudo("T");
            } else {
                if (itemPagamento.getTipoBeneficiario().naoFormatado().equals("2")) {
                    pagamento.getTipo().setConteudo("D");
                    pagamento.getCPFDependente().setConteudo(itemPagamento.getCpfBeneficiarioSelecionado().naoFormatado());
                } else if (itemPagamento.getTipoBeneficiario().naoFormatado().equals("3")) {
                    pagamento.getTipo().setConteudo("A");
                    pagamento.getCPFAlimentando().setConteudo(itemPagamento.getCpfBeneficiarioSelecionado().naoFormatado());
                }
                pagamento.getDependenteOuAlimentando().setConteudo(itemPagamento.getNomeBeneficiarioSelecionado().naoFormatado());
            }
            pagamento.getParcelaNaoDedutivel().setConteudo((Valor)itemPagamento.getValorReembolsado());
            pagamento.getNiBeneficiario().setConteudo(itemPagamento.getCpfCnpjPrestadorServico().naoFormatado());
            pagamento.getNomeBeneficiario().setConteudo(itemPagamento.getNomePrestadorServico().naoFormatado());
            pagamento.getValorPago().setConteudo(itemPagamento.getValorPago().naoFormatado());
        }
        dec.getIdentificadorDeclaracao().getInUtilizouAssistidaPlanoSaude().setConteudo(Logico.SIM);
    }

    @Override
    public String getLabelConfirmar() {
        return "Importar";
    }

    @Override
    public int getAtalhoConfirmar() {
        return 73;
    }

    @Override
    public boolean isTelaComFavoritos() {
        return false;
    }
}

