/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.dashboard;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import serpro.ppgd.app.acoes.GravarCopiaSegurancaAction;
import serpro.ppgd.app.acoes.ImportarInformeRendimentosAction;
import serpro.ppgd.app.acoes.ImprimirDarfCodBarrasAction;
import serpro.ppgd.app.acoes.ImprimirDeclaracaoAction;
import serpro.ppgd.app.acoes.VerificarPendenciasAction;
import serpro.ppgd.gui.xbeans.JEditValor;
import serpro.ppgd.gui.xbeans.JFlipComponentes;
import serpro.ppgd.infraestrutura.util.FontesUtil;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.PainelDemonstrativoAb;
import serpro.ppgd.irpf.gui.componente.JDegradePanel;
import serpro.ppgd.irpf.gui.componente.JTaskAction;
import serpro.ppgd.irpf.gui.dashboard.fichas.ScrollGridFichas;
import serpro.ppgd.irpf.gui.resumo.SubPainelDadosBancarios;
import serpro.ppgd.irpf.gui.resumo.SubPainelParcelamentoInfoBancarias;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Observador;

public class PainelDashboard
extends PainelDemonstrativoAb {
    private SubPainelParcelamentoInfoBancarias subPainelParcelamentoInfoBancarias = new SubPainelParcelamentoInfoBancarias();
    private SubPainelDadosBancarios subPainelDadosBancarios = new SubPainelDadosBancarios();
    private JEditValor edtValor;
    private JFlipComponentes flipParcelamentoInfoBancarias;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JLabel lblImpostoPagarRestituir;
    private JLabel lblValor;
    private JPanel pnlAcoes;
    private JPanel pnlImposto;
    private JPanel pnlImpostoPagarRestituir;
    private JDegradePanel pnlValor;
    private ScrollGridFichas scrollPanelGrid;

    public PainelDashboard() {
        this.initComponents();
        this.edtValor.getComponenteEditor().setFont(FontesUtil.FONTE_TITULO_NORMAL);
        this.adicionarObservadores();
        JTaskAction task = null;
        task = new JTaskAction("Verificar Avisos e Erros", (Action)new VerificarPendenciasAction(), (Icon)GuiUtil.getImage("/icones/png20px/MN_verificar.png"), true);
        task.setOpaque(false);
        this.pnlAcoes.add(task);
        this.pnlAcoes.add(Box.createRigidArea(new Dimension(0, 8)));
        task = new JTaskAction("Imprimir Declara\u00e7\u00e3o", new ImprimirDeclaracaoAction(), (Icon)GuiUtil.getImage("/icones/png20px/IM_decl.png"));
        task.setOpaque(false);
        this.pnlAcoes.add(task);
        this.pnlAcoes.add(Box.createRigidArea(new Dimension(0, 8)));
        task = new JTaskAction("Imprimir Darf", new ImprimirDarfCodBarrasAction(), (Icon)GuiUtil.getImage("/icones/png20px/IM_darf_cb.png"));
        task.setOpaque(false);
        this.pnlAcoes.add(task);
        this.pnlAcoes.add(Box.createRigidArea(new Dimension(0, 8)));
        task = new JTaskAction("Gravar C\u00f3pia", new GravarCopiaSegurancaAction(), (Icon)GuiUtil.getImage("/icones/png20px/MN_gravar.png"));
        task.setOpaque(false);
        this.pnlAcoes.add(task);
        this.pnlAcoes.add(Box.createRigidArea(new Dimension(0, 8)));
        task = new JTaskAction("Importar Assistida", new ImportarInformeRendimentosAction(), (Icon)GuiUtil.getImage("/icones/png20px/MN_import.png"));
        task.setOpaque(false);
        this.pnlAcoes.add(task);
        this.pnlAcoes.add(Box.createRigidArea(new Dimension(0, 8)));
    }

    private void adicionarObservadores() {
        IRPFFacade.getInstancia().getDeclaracao().getResumo().getCalculoImposto().getImpostoRestituir().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                PainelDashboard.this.atualizaImpostoPagarRestituir();
                if (ControladorGui.getPainelAtualmenteExibido() == PainelDashboard.this) {
                    PainelDashboard.this.preExibir();
                }
                PainelDashboard.this.repaint();
                PainelDashboard.this.revalidate();
            }
        });
    }

    private void configurarSubPainelDadosBancarios() {
        DeclaracaoIRPF dec = IRPFFacade.getInstancia().getDeclaracao();
        this.subPainelDadosBancarios.setDeclaracao(dec);
        this.subPainelDadosBancarios.configurarComponentes();
    }

    @Override
    public void preExibir() {
        this.subPainelParcelamentoInfoBancarias = new SubPainelParcelamentoInfoBancarias();
        this.subPainelDadosBancarios = new SubPainelDadosBancarios();
        this.flipParcelamentoInfoBancarias.setComponenteA((JComponent)this.subPainelParcelamentoInfoBancarias);
        this.flipParcelamentoInfoBancarias.setComponenteB((JComponent)this.subPainelDadosBancarios);
        this.atualizaImpostoPagarRestituir();
        this.scrollPanelGrid.atualizar();
        this.configurarSubPainelDadosBancarios();
    }

    @Override
    public String getHelpID() {
        return "Fichas da Declara\u00e7\u00e3o/Aba In\u00edcio";
    }

    private void atualizaImpostoPagarRestituir() {
        DeclaracaoIRPF dec = IRPFFacade.getInstancia().getDeclaracao();
        if (dec.getResumo().getCalculoImposto().getImpostoRestituir().comparacao(">", "0,00")) {
            this.lblImpostoPagarRestituir.setVisible(true);
            this.pnlImposto.setVisible(true);
            this.flipParcelamentoInfoBancarias.setVisible(true);
            this.lblImpostoPagarRestituir.setText("Imposto a Restituir");
            this.edtValor.setInformacao((Informacao)dec.getResumo().getCalculoImposto().getImpostoRestituir());
            this.flipParcelamentoInfoBancarias.exibeComponenteB();
        } else if (dec.getResumo().getCalculoImposto().getSaldoImpostoPagar().comparacao(">", "0,00")) {
            this.lblImpostoPagarRestituir.setVisible(true);
            this.pnlImposto.setVisible(true);
            this.flipParcelamentoInfoBancarias.setVisible(true);
            this.lblImpostoPagarRestituir.setText("Imposto a Pagar");
            this.edtValor.setInformacao((Informacao)dec.getResumo().getCalculoImposto().getSaldoImpostoPagar());
            this.flipParcelamentoInfoBancarias.exibeComponenteA();
        } else {
            this.lblImpostoPagarRestituir.setVisible(false);
            this.pnlImposto.setVisible(false);
            this.flipParcelamentoInfoBancarias.setVisible(false);
        }
    }

    @Override
    public String getTituloPainel() {
        return "In\u00edcio";
    }

    @Override
    public ImageIcon getImagemTitulo() {
        return GuiUtil.getImage("/icones/png40px/DE_rfb.png");
    }

    @Override
    public boolean isTelaComFavoritos() {
        return false;
    }

    @Override
    public JComponent getDefaultFocus() {
        return this.scrollPanelGrid;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.scrollPanelGrid = new ScrollGridFichas();
        this.jScrollPane1 = new JScrollPane();
        this.pnlAcoes = new JPanel();
        this.jLabel2 = new JLabel();
        this.lblImpostoPagarRestituir = new JLabel();
        this.pnlImpostoPagarRestituir = new JPanel();
        this.pnlImposto = new JPanel();
        this.lblValor = new JLabel();
        this.pnlValor = new JDegradePanel();
        this.edtValor = new JEditValor();
        this.flipParcelamentoInfoBancarias = new JFlipComponentes();
        this.jLabel1.setFont(FontesUtil.FONTE_TITULO_NORMAL);
        this.jLabel1.setForeground(new Color(0, 74, 106));
        this.jLabel1.setText("Identificamos que estas podem ser as fichas mais relevantes para voc\u00ea. Caso necessite de outras, utilize o menu \u00e0 esquerda.");
        this.pnlAcoes.setBackground(new Color(255, 255, 255));
        this.pnlAcoes.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.pnlAcoes.setLayout(new BoxLayout(this.pnlAcoes, 1));
        this.jScrollPane1.setViewportView(this.pnlAcoes);
        this.jLabel2.setFont(FontesUtil.FONTE_TITULO_NORMAL);
        this.jLabel2.setForeground(new Color(0, 74, 106));
        this.jLabel2.setText("A\u00e7\u00f5es");
        this.lblImpostoPagarRestituir.setFont(FontesUtil.FONTE_TITULO_NORMAL);
        this.lblImpostoPagarRestituir.setForeground(new Color(0, 74, 106));
        this.lblImpostoPagarRestituir.setText("Imposto a Pagar");
        this.pnlImpostoPagarRestituir.setBackground(new Color(255, 255, 255));
        this.pnlImpostoPagarRestituir.setBorder(BorderFactory.createLineBorder(new Color(211, 222, 232)));
        this.pnlImposto.setBackground(new Color(255, 255, 255));
        this.lblValor.setFont(FontesUtil.FONTE_TITULO_NORMAL);
        this.lblValor.setForeground(new Color(0, 74, 106));
        this.lblValor.setText("Valor");
        this.pnlValor.setBackground(new Color(212, 231, 233));
        this.pnlValor.setCorFinal(new Color(203, 224, 243));
        this.pnlValor.setCorInicial(new Color(180, 200, 222));
        this.pnlValor.setPontoFimDegrade(new Point(132, 0));
        this.pnlValor.setPontoInicioDegrade(new Point(132, 100));
        this.pnlValor.setPreferredSize(new Dimension(264, 100));
        GroupLayout pnlValorLayout = new GroupLayout(this.pnlValor);
        this.pnlValor.setLayout(pnlValorLayout);
        pnlValorLayout.setHorizontalGroup(pnlValorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, pnlValorLayout.createSequentialGroup().addContainerGap(31, Short.MAX_VALUE).addComponent((Component)this.edtValor, -2, 221, -2).addContainerGap()));
        pnlValorLayout.setVerticalGroup(pnlValorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlValorLayout.createSequentialGroup().addGap(36, 36, 36).addComponent((Component)this.edtValor, -2, -1, -2).addContainerGap(29, Short.MAX_VALUE)));
        this.edtValor.getAccessibleContext().setAccessibleName(IRPFFacade.getInstancia().getDeclaracao().getResumo().getCalculoImposto().getImpostoRestituir().comparacao(">", "0,00") ? "Imposto a Restituir" : "Imposto a Pagar");
        GroupLayout pnlImpostoLayout = new GroupLayout(this.pnlImposto);
        this.pnlImposto.setLayout(pnlImpostoLayout);
        pnlImpostoLayout.setHorizontalGroup(pnlImpostoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlImpostoLayout.createSequentialGroup().addContainerGap().addGroup(pnlImpostoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlValor, -1, -1, Short.MAX_VALUE).addComponent(this.lblValor)).addContainerGap()));
        pnlImpostoLayout.setVerticalGroup(pnlImpostoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlImpostoLayout.createSequentialGroup().addGap(28, 28, 28).addComponent(this.lblValor).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlValor, -2, -1, -2).addContainerGap(22, Short.MAX_VALUE)));
        this.flipParcelamentoInfoBancarias.setComponenteA((JComponent)this.subPainelParcelamentoInfoBancarias);
        this.flipParcelamentoInfoBancarias.setComponenteB((JComponent)this.subPainelDadosBancarios);
        GroupLayout pnlImpostoPagarRestituirLayout = new GroupLayout(this.pnlImpostoPagarRestituir);
        this.pnlImpostoPagarRestituir.setLayout(pnlImpostoPagarRestituirLayout);
        pnlImpostoPagarRestituirLayout.setHorizontalGroup(pnlImpostoPagarRestituirLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlImpostoPagarRestituirLayout.createSequentialGroup().addComponent(this.pnlImposto, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.flipParcelamentoInfoBancarias, -1, 427, Short.MAX_VALUE)));
        pnlImpostoPagarRestituirLayout.setVerticalGroup(pnlImpostoPagarRestituirLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlImposto, -2, -1, -2).addComponent((Component)this.flipParcelamentoInfoBancarias, -1, -1, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.scrollPanelGrid, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jScrollPane1, -1, 119, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.lblImpostoPagarRestituir).addComponent(this.pnlImpostoPagarRestituir, -2, -1, -2)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jScrollPane1).addComponent(this.scrollPanelGrid, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblImpostoPagarRestituir).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlImpostoPagarRestituir, -2, -1, -2).addContainerGap(49, Short.MAX_VALUE)));
    }
}

