/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.comparativo;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import serpro.ppgd.app.acoes.ComparativoAction;
import serpro.ppgd.app.acoes.TransmitirDeclaracaoAction;
import serpro.ppgd.gui.xbeans.JButtonGroupPanel;
import serpro.ppgd.gui.xbeans.JEditValor;
import serpro.ppgd.gui.xbeans.PPGDRadioItem;
import serpro.ppgd.infraestrutura.eventos.BarramentoEventos;
import serpro.ppgd.infraestrutura.util.FontesUtil;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.ObservadorTipoDeclaracao;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.PainelDemonstrativoAb;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.negocio.Observador;

public class PainelComparativoAuxiliar
extends PainelDemonstrativoAb {
    private static final long serialVersionUID = 1L;
    private static final Color VERDE_ESCURO = new Color(0, 127, 0);
    private static final Color AZUL_ESCURO = new Color(0, 74, 106);
    private String backupName;
    private LayoutManager layoutHorizontal;
    private LayoutManager layoutVertical;
    private Dimension backupMaxSize;
    private Dimension backupMinSize;
    private Dimension backupPrefSize;
    private Dimension minimizedMaxSize;
    private Dimension minimizedMinSize;
    private Dimension minimizedPrefSize;
    private JButton btnEntregar;
    private JButton btnVer;
    public JCheckBox cbxComCert;
    private JEditValor edtDeducoesLegais;
    private JEditValor edtDescontoSimplificado;
    private JButtonGroupPanel grpRadios;
    private JLabel lblAliquotaEfetivaCompleta;
    private JLabel lblAliquotaEfetivaSimplificada;
    private JLabel lblDeducoesLegais;
    private JLabel lblDescontoSimplificado;
    private JLabel lblOpcaoTributacao;
    private JPanel pnlBotao;
    private JPanel pnlRadios;
    private PPGDRadioItem rdbDeducoesLegais;
    private PPGDRadioItem rdbDescontoSimplificado;

    public PainelComparativoAuxiliar() {
        this.initComponents();
        BarramentoEventos.getInstancia().registraOutput((Object)this);
        this.lblOpcaoTributacao.setIcon(GuiUtil.getImage("/icones/png20px/MN_comp.png"));
        this.backupName = this.lblOpcaoTributacao.getText();
        this.layoutHorizontal = this.pnlBotao.getLayout();
        this.layoutVertical = new BoxLayout(this.pnlBotao, 1);
        this.backupMaxSize = this.pnlBotao.getMaximumSize();
        this.backupMinSize = this.pnlBotao.getMinimumSize();
        this.backupPrefSize = this.pnlBotao.getPreferredSize();
        this.minimizedMaxSize = new Dimension(1000, 53);
        this.minimizedMinSize = new Dimension(30, 50);
        this.minimizedPrefSize = new Dimension(50, 50);
        this.adicionarObservadores();
        this.alterarDeducoesLegais();
        this.alterarDescontoSimplificado();
        this.rdbDeducoesLegais.setSelected(ControladorGui.getDemonstrativoAberto().getIdentificadorDeclaracao().isCompleta());
        this.rdbDescontoSimplificado.setSelected(!ControladorGui.getDemonstrativoAberto().getIdentificadorDeclaracao().isCompleta());
        if (ControladorGui.isReadOnly()) {
            ControladorGui.desabilitarTela(this.pnlRadios);
        }
    }

    private void initComponents() {
        this.pnlBotao = new JPanel();
        this.lblOpcaoTributacao = new JLabel();
        this.btnVer = new JButton();
        this.pnlRadios = new JPanel();
        this.grpRadios = new JButtonGroupPanel();
        this.rdbDeducoesLegais = new PPGDRadioItem();
        this.lblDeducoesLegais = new JLabel();
        this.edtDeducoesLegais = new JEditValor();
        this.rdbDescontoSimplificado = new PPGDRadioItem();
        this.lblDescontoSimplificado = new JLabel();
        this.edtDescontoSimplificado = new JEditValor();
        this.btnEntregar = new JButton();
        this.lblAliquotaEfetivaSimplificada = new JLabel();
        this.lblAliquotaEfetivaCompleta = new JLabel();
        this.cbxComCert = new JCheckBox();
        this.setLayout(new BoxLayout(this, 1));
        this.pnlBotao.setMaximumSize(new Dimension(1000, 28));
        this.pnlBotao.setMinimumSize(new Dimension(80, 25));
        this.pnlBotao.setPreferredSize(new Dimension(100, 25));
        this.pnlBotao.setLayout(new BoxLayout(this.pnlBotao, 2));
        this.lblOpcaoTributacao.setFont(FontesUtil.FONTE_TITULO_MENOR);
        this.lblOpcaoTributacao.setForeground(new Color(0, 74, 106));
        this.lblOpcaoTributacao.setText("Op\u00e7\u00e3o pela Tributa\u00e7\u00e3o:     ");
        this.lblOpcaoTributacao.setAlignmentX(0.5f);
        this.pnlBotao.add(this.lblOpcaoTributacao);
        this.btnVer.setAction(new ComparativoAction());
        this.btnVer.setIcon(GuiUtil.getImage("/icones/png14px/lente_aumento.png"));
        this.btnVer.setToolTipText("Comparativo");
        this.btnVer.setAlignmentX(0.5f);
        this.btnVer.setPreferredSize(new Dimension(20, 9));
        this.pnlBotao.add(this.btnVer);
        this.add(this.pnlBotao);
        this.pnlRadios.setBackground(new Color(213, 231, 245));
        this.grpRadios.setBorder(null);
        this.grpRadios.setForeground(new Color(0, 74, 106));
        this.rdbDeducoesLegais.setBackground(new Color(213, 231, 245));
        this.rdbDeducoesLegais.setForeground(new Color(0, 74, 106));
        this.rdbDeducoesLegais.setText("Por Dedu\u00e7\u00f5es Legais");
        this.rdbDeducoesLegais.setValorSelecionadoTrue("0");
        this.rdbDeducoesLegais.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelComparativoAuxiliar.this.rdbDeducoesLegaisActionPerformed(evt);
            }
        });
        this.lblDeducoesLegais.setForeground(new Color(0, 74, 106));
        this.lblDeducoesLegais.setText("Imposto a Pagar");
        this.edtDeducoesLegais.setButtonMensagem(null);
        this.edtDeducoesLegais.setInformacaoAssociada("comparativo.impostoPagarRestituirCompleta");
        this.rdbDescontoSimplificado.setBackground(new Color(213, 231, 245));
        this.rdbDescontoSimplificado.setForeground(new Color(0, 74, 106));
        this.rdbDescontoSimplificado.setText("Por Desconto Simplificado");
        this.rdbDescontoSimplificado.setValorSelecionadoTrue("1");
        this.rdbDescontoSimplificado.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelComparativoAuxiliar.this.rdbDescontoSimplificadoActionPerformed(evt);
            }
        });
        this.lblDescontoSimplificado.setForeground(new Color(0, 74, 106));
        this.lblDescontoSimplificado.setText("Imposto a Pagar");
        this.edtDescontoSimplificado.setButtonMensagem(null);
        this.edtDescontoSimplificado.setInformacaoAssociada("comparativo.impostoPagarRestituirSimplificada");
        this.btnEntregar.setIcon(GuiUtil.getImage("/icones/png20px/MN_transmitir_globo.png"));
        this.btnEntregar.setText("Entregar Declara\u00e7\u00e3o");
        this.btnEntregar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelComparativoAuxiliar.this.btnEntregarActionPerformed(evt);
            }
        });
        this.lblAliquotaEfetivaSimplificada.setFont(FontesUtil.FONTE_MENOR_NEGRITO);
        this.lblAliquotaEfetivaSimplificada.setForeground(new Color(0, 74, 106));
        this.lblAliquotaEfetivaSimplificada.setHorizontalAlignment(2);
        this.lblAliquotaEfetivaSimplificada.setText("Al\u00edquota efetiva 100%");
        this.lblAliquotaEfetivaCompleta.setFont(FontesUtil.FONTE_MENOR_NEGRITO);
        this.lblAliquotaEfetivaCompleta.setForeground(new Color(0, 74, 106));
        this.lblAliquotaEfetivaCompleta.setHorizontalAlignment(2);
        this.lblAliquotaEfetivaCompleta.setText("Al\u00edquota efetiva: 100%");
        this.cbxComCert.setBackground(new Color(213, 231, 245));
        this.cbxComCert.setForeground(new Color(0, 74, 106));
        this.cbxComCert.setText("Transmitir com certifica\u00e7\u00e3o digital");
        this.cbxComCert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelComparativoAuxiliar.this.cbxComCertActionPerformed(evt);
            }
        });
        GroupLayout grpRadiosLayout = new GroupLayout((Container)this.grpRadios);
        this.grpRadios.setLayout((LayoutManager)grpRadiosLayout);
        grpRadiosLayout.setHorizontalGroup(grpRadiosLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(grpRadiosLayout.createSequentialGroup().addContainerGap().addGroup(grpRadiosLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.rdbDescontoSimplificado, -1, -1, Short.MAX_VALUE).addComponent(this.btnEntregar, -1, -1, Short.MAX_VALUE).addGroup(grpRadiosLayout.createSequentialGroup().addGap(12, 12, 12).addGroup(grpRadiosLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(grpRadiosLayout.createSequentialGroup().addGroup(grpRadiosLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent((Component)this.edtDescontoSimplificado, -1, -1, Short.MAX_VALUE).addComponent(this.lblDescontoSimplificado, -1, 139, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblAliquotaEfetivaSimplificada, -1, -1, Short.MAX_VALUE)).addGroup(grpRadiosLayout.createSequentialGroup().addGroup(grpRadiosLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent((Component)this.edtDeducoesLegais, -1, -1, Short.MAX_VALUE).addComponent(this.lblDeducoesLegais, -1, 137, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblAliquotaEfetivaCompleta, -1, -1, Short.MAX_VALUE)))).addGroup(grpRadiosLayout.createSequentialGroup().addGroup(grpRadiosLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.rdbDeducoesLegais, -2, -1, -2).addComponent(this.cbxComCert)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        grpRadiosLayout.setVerticalGroup(grpRadiosLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(grpRadiosLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.rdbDeducoesLegais, -2, 20, -2).addGap(3, 3, 3).addComponent(this.lblDeducoesLegais).addGap(1, 1, 1).addGroup(grpRadiosLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.edtDeducoesLegais, -2, -1, -2).addComponent(this.lblAliquotaEfetivaCompleta, -2, 26, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.rdbDescontoSimplificado, -2, 20, -2).addGap(4, 4, 4).addComponent(this.lblDescontoSimplificado).addGap(1, 1, 1).addGroup(grpRadiosLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.edtDescontoSimplificado, -2, -1, -2).addComponent(this.lblAliquotaEfetivaSimplificada, -2, 26, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, Short.MAX_VALUE).addComponent(this.cbxComCert).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnEntregar).addGap(10, 10, 10)));
        this.edtDeducoesLegais.getAccessibleContext().setAccessibleName("Imposto a Pagar");
        this.edtDeducoesLegais.getAccessibleContext().setAccessibleDescription("");
        this.edtDescontoSimplificado.getAccessibleContext().setAccessibleName("Imposto a Pagar");
        this.edtDescontoSimplificado.getAccessibleContext().setAccessibleDescription("");
        GroupLayout pnlRadiosLayout = new GroupLayout(this.pnlRadios);
        this.pnlRadios.setLayout(pnlRadiosLayout);
        pnlRadiosLayout.setHorizontalGroup(pnlRadiosLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.grpRadios, -2, -1, -2));
        pnlRadiosLayout.setVerticalGroup(pnlRadiosLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.grpRadios, -1, -1, Short.MAX_VALUE));
        this.add(this.pnlRadios);
    }

    private void rdbDescontoSimplificadoActionPerformed(ActionEvent evt) {
        ObservadorTipoDeclaracao.chamarMensagensObservadores = false;
        ControladorGui.alterarOpcaoTributacao(evt, null);
    }

    private void rdbDeducoesLegaisActionPerformed(ActionEvent evt) {
        ObservadorTipoDeclaracao.chamarMensagensObservadores = false;
        ControladorGui.alterarOpcaoTributacao(evt, null);
    }

    private void cbxComCertActionPerformed(ActionEvent evt) {
    }

    private void btnEntregarActionPerformed(ActionEvent evt) {
        TransmitirDeclaracaoAction action = new TransmitirDeclaracaoAction(this.cbxComCert.isSelected());
        action.actionPerformed(evt);
    }

    private void adicionarObservadores() {
        DeclaracaoIRPF dec = IRPFFacade.getInstancia().getDeclaracao();
        dec.getComparativo().getSaldoPagarCompleta().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                PainelComparativoAuxiliar.this.alterarDeducoesLegais();
            }
        });
        dec.getComparativo().getImpRestituirCompleta().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                PainelComparativoAuxiliar.this.alterarDeducoesLegais();
            }
        });
        dec.getComparativo().getSaldoPagarSimplificada().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                PainelComparativoAuxiliar.this.alterarDescontoSimplificado();
            }
        });
        dec.getComparativo().getImpRestituirSimplificada().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                PainelComparativoAuxiliar.this.alterarDescontoSimplificado();
            }
        });
    }

    private void alterarDeducoesLegais() {
        DeclaracaoIRPF dec = IRPFFacade.getInstancia().getDeclaracao();
        if (!dec.getComparativo().getImpRestituirCompleta().isVazio()) {
            this.edtDeducoesLegais.getComponenteEditor().setForeground(VERDE_ESCURO);
            this.lblDeducoesLegais.setText("Imposto a Restituir");
            this.edtDeducoesLegais.getAccessibleContext().setAccessibleName("Imposto a restituir (dedu\u00e7\u00f5es legais)");
        } else if (!dec.getComparativo().getSaldoPagarCompleta().isVazio()) {
            this.edtDeducoesLegais.getComponenteEditor().setForeground(AZUL_ESCURO);
            this.lblDeducoesLegais.setText("Imposto a Pagar");
            this.edtDeducoesLegais.getAccessibleContext().setAccessibleName("Imposto a pagar (dedu\u00e7\u00f5es legais)");
        } else {
            this.edtDeducoesLegais.getComponenteEditor().setForeground(AZUL_ESCURO);
            this.lblDeducoesLegais.setText("Sem Saldo de Imposto");
            this.edtDeducoesLegais.getAccessibleContext().setAccessibleName("Sem saldo de imposto (dedu\u00e7\u00f5es legais)");
        }
        String aliquotaCompleta = "Al\u00edquota efetiva: " + dec.getModeloCompleta().getAliquotaEfetiva().formatado() + "%";
        this.lblAliquotaEfetivaCompleta.setText(aliquotaCompleta);
    }

    private void alterarDescontoSimplificado() {
        DeclaracaoIRPF dec = IRPFFacade.getInstancia().getDeclaracao();
        if (!dec.getComparativo().getImpRestituirSimplificada().isVazio()) {
            this.edtDescontoSimplificado.getComponenteEditor().setForeground(VERDE_ESCURO);
            this.lblDescontoSimplificado.setText("Imposto a Restituir");
            this.edtDescontoSimplificado.getAccessibleContext().setAccessibleName("Imposto a restituir (desconto simplificado)");
        } else if (!dec.getComparativo().getSaldoPagarSimplificada().isVazio()) {
            this.edtDescontoSimplificado.getComponenteEditor().setForeground(AZUL_ESCURO);
            this.lblDescontoSimplificado.setText("Imposto a Pagar");
            this.edtDescontoSimplificado.getAccessibleContext().setAccessibleName("Imposto a pagar (desconto simplificado)");
        } else {
            this.edtDescontoSimplificado.getComponenteEditor().setForeground(AZUL_ESCURO);
            this.lblDescontoSimplificado.setText("Sem Saldo de Imposto");
            this.edtDescontoSimplificado.getAccessibleContext().setAccessibleName("Sem saldo de imposto (desconto simplificado)");
        }
        String aliquotaSimplificada = "Al\u00edquota efetiva: " + dec.getModeloSimplificada().getAliquotaEfetiva().formatado() + "%";
        this.lblAliquotaEfetivaSimplificada.setText(aliquotaSimplificada);
    }

    public void setMinimized(boolean minimized) {
        if (minimized) {
            this.lblOpcaoTributacao.setText("");
            this.pnlBotao.setLayout(this.layoutVertical);
            this.pnlBotao.setMaximumSize(this.minimizedMaxSize);
            this.pnlBotao.setMinimumSize(this.minimizedMinSize);
            this.pnlBotao.setPreferredSize(this.minimizedPrefSize);
        } else {
            this.lblOpcaoTributacao.setText(this.backupName);
            this.pnlBotao.setLayout(this.layoutHorizontal);
            this.pnlBotao.setMaximumSize(this.backupMaxSize);
            this.pnlBotao.setMinimumSize(this.backupMinSize);
            this.pnlBotao.setPreferredSize(this.backupPrefSize);
        }
        this.pnlRadios.setVisible(!minimized);
    }

    public PPGDRadioItem getRdbDeducoesLegais() {
        return this.rdbDeducoesLegais;
    }

    public PPGDRadioItem getRdbDescontoSimplificado() {
        return this.rdbDescontoSimplificado;
    }
}

