/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.table.TableRowSorter;
import org.jdesktop.layout.GroupLayout;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.util.FontesUtil;
import serpro.ppgd.irpf.gui.IRPFTableAb;
import serpro.ppgd.irpf.gui.IRPFTableModelAb;
import serpro.ppgd.irpf.gui.JIRPFToolbar;
import serpro.ppgd.irpf.gui.PainelPrincipalAb;
import serpro.ppgd.irpf.gui.TableLista;
import serpro.ppgd.irpf.gui.TableListaModel;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.gui.util.IRPFTableDecorator;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ObjetoNegocio;

public abstract class PainelQuadroAuxiliarListaAb<E extends ObjetoNegocio>
extends PainelPrincipalAb {
    private static final long serialVersionUID = 1L;
    protected Colecao<E> colecao;
    private String textoCabecalho;
    private JButton btnOk;
    private JIRPFToolbar irpfToolbar;
    private JScrollPane jScrollPane1;
    private JLabel lblQuadro;
    private TableLista tableLista;

    public PainelQuadroAuxiliarListaAb() {
        this(null, "");
    }

    public PainelQuadroAuxiliarListaAb(Colecao<E> colecao) {
        this(colecao, "");
    }

    public PainelQuadroAuxiliarListaAb(Colecao<E> colecao, String textoCabecalho) {
        this.colecao = colecao;
        this.textoCabecalho = textoCabecalho;
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)this, this.getButtonHelpID());
        this.initComponents();
        this.configurarTamanhoColunas();
        IRPFTableDecorator.decorate(this.getTabela(), this);
        this.getTabela().getSelectionModel().addListSelectionListener(this.irpfToolbar);
        if (this.getTabela().getModel().getRowCount() > 0) {
            this.getTabela().selecionaCelula(0, 0);
        }
        this.inibirEnterNavegacaoFocoBotoes();
    }

    private void inibirEnterNavegacaoFocoBotoes() {
        HashSet<KeyStroke> set = new HashSet<KeyStroke>();
        set.add(KeyStroke.getKeyStroke(9, 0));
        this.btnOk.setFocusTraversalKeys(0, set);
        this.irpfToolbar.getBtnNovo().setFocusTraversalKeys(0, set);
        this.irpfToolbar.getBtnAbrir().setFocusTraversalKeys(0, set);
        this.irpfToolbar.getBtnExcluir().setFocusTraversalKeys(0, set);
    }

    protected String getTextoCabecalho() {
        return this.textoCabecalho;
    }

    private void initComponents() {
        this.irpfToolbar = new JIRPFToolbar();
        this.jScrollPane1 = new JScrollPane();
        this.tableLista = this.instanciarTabela(this.getTableModel(), this.getColunaOrdenacao(), this.getColunasOrdenaveis());
        this.lblQuadro = new JLabel();
        this.btnOk = new JButton();
        this.setBackground(new Color(241, 245, 249));
        this.irpfToolbar.addToolBarListener(this);
        this.jScrollPane1.setViewportView(this.tableLista);
        this.lblQuadro.setFont(FontesUtil.FONTE_NORMAL);
        this.lblQuadro.setForeground(new Color(0, 74, 106));
        this.lblQuadro.setText(this.getTextoCabecalho());
        this.btnOk.setMnemonic('o');
        this.btnOk.setText("Ok");
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelQuadroAuxiliarListaAb.this.btnOkActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.jScrollPane1, -1, 578, Short.MAX_VALUE).add(1, (Component)this.lblQuadro, -1, 578, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.btnOk, -2, 90, -2).addPreferredGap(0).add((Component)this.irpfToolbar, -2, -1, -2))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.lblQuadro, -1, -1, Short.MAX_VALUE).addPreferredGap(1).add((Component)this.jScrollPane1, -1, 306, Short.MAX_VALUE).add(32, 32, 32).add((GroupLayout.Group)layout.createParallelGroup(4).add((Component)this.btnOk, -2, 25, -2).add((Component)this.irpfToolbar, -2, -1, -2)).addContainerGap()));
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        this.onBtnOkClick(evt);
    }

    @Override
    public IRPFTableAb getTabela() {
        return this.tableLista;
    }

    protected void onBtnOkClick(ActionEvent e) {
        GuiUtil.fecharDialog(this);
    }

    protected abstract void configurarTamanhoColunas();

    protected abstract TableLista instanciarTabela(TableListaModel var1, int var2, Integer[] var3);

    protected abstract String getClassePainelNavegacao();

    protected abstract String getButtonHelpID();

    protected abstract TableListaModel getTableModel();

    protected abstract int getColunaOrdenacao();

    protected abstract Integer[] getColunasOrdenaveis();

    protected abstract String getMensagemExclusao();

    @Override
    public void preExibir() {
        ((Colecao)((IRPFTableModelAb)this.getTabela().getModel()).getObjetoNegocio()).excluirRegistrosEmBranco();
        ((IRPFTableModelAb)this.getTabela().getModel()).refresh();
    }

    @Override
    public JComponent getDefaultFocus() {
        return this.irpfToolbar.getBtnNovo();
    }

    public JIRPFToolbar getIrpfToolbar() {
        return this.irpfToolbar;
    }

    public Colecao<E> getColecao() {
        return this.colecao;
    }

    public JLabel getLblQuadro() {
        return this.lblQuadro;
    }

    @Override
    public void onBtnExcluirClick(ActionEvent e) {
        IRPFTableAb tabela = this.getTabela();
        if (tabela.getSelectedRowCount() > 0) {
            int[] linhasTabela = tabela.getSelectedRows();
            if (GuiUtil.mostrarConfirmaNaoPadrao("ConfirmaExcluirItens1", new String[]{"item(ns)"})) {
                ArrayList<ObjetoNegocio> listaRemocao = new ArrayList<ObjetoNegocio>(linhasTabela.length);
                Colecao<ObjetoNegocio> colecao = new Colecao<ObjetoNegocio>(){};
                for (int linhaTabela : linhasTabela) {
                    int indiceVetor = ((TableRowSorter)tabela.getRowSorter()).convertRowIndexToModel(linhaTabela);
                    TableListaModel model = (TableListaModel)tabela.getModel();
                    colecao = (Colecao)model.getObjetoNegocio();
                    ObjetoNegocio objetoNegocio = (ObjetoNegocio)colecao.itens().get(indiceVetor);
                    listaRemocao.add(objetoNegocio);
                }
                try {
                    colecao.itens().removeAll(listaRemocao);
                }
                catch (Exception exception) {}
            }
        } else {
            GuiUtil.mostrarAviso("ErroSelecioneItem");
        }
    }
}

