/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui;

import java.awt.Component;
import java.awt.Container;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import serpro.ppgd.cacheni.CacheNI;
import serpro.ppgd.irpf.gui.IRPFTableAb;
import serpro.ppgd.irpf.gui.PainelAbaIf;
import serpro.ppgd.irpf.gui.PainelDemonstrativoIf;
import serpro.ppgd.irpf.util.IRPFUtil;

public abstract class PainelDemonstrativoAb
extends JPanel
implements PainelDemonstrativoIf {
    private static final long serialVersionUID = 1L;
    private boolean cacheNIRegistrado = false;

    @Override
    public boolean isTelaComAjuda() {
        return true;
    }

    @Override
    public boolean isTelaComVoltar() {
        return false;
    }

    @Override
    public boolean isTelaComCancelar() {
        return false;
    }

    @Override
    public boolean isTelaComImportacao() {
        return false;
    }

    @Override
    public boolean isTelaComFavoritos() {
        return false;
    }

    @Override
    public String getLabelImportacao() {
        return "Importar";
    }

    @Override
    public String getLabelConfirmar() {
        return "OK";
    }

    @Override
    public int getAtalhoConfirmar() {
        return 79;
    }

    @Override
    public String getLabelCancelar() {
        return "Cancelar";
    }

    @Override
    public int getAtalhoCancelar() {
        return 67;
    }

    @Override
    public Action obterImportacaoAction() {
        return null;
    }

    @Override
    public String getMensagemTela() {
        return null;
    }

    @Override
    public boolean isTelaComMensagem() {
        return false;
    }

    public boolean isTelaComSubtitulo() {
        return false;
    }

    public String getSubtitulo() {
        return null;
    }

    @Override
    public void executaVoltar() {
    }

    @Override
    public void executaCancelar() {
    }

    @Override
    public boolean isPodeSair() {
        return true;
    }

    @Override
    public void posExibir() {
    }

    @Override
    public void preExibir() {
    }

    @Override
    public String getTituloPainel() {
        return null;
    }

    @Override
    public JComponent getDefaultFocus() {
        return null;
    }

    @Override
    public ImageIcon getImagemTitulo() {
        return null;
    }

    @Override
    public boolean isPossuiAbas() {
        return this.getAbas() != null && this.getAbas().length > 0;
    }

    @Override
    public JTabbedPane getTabbedPane() {
        return null;
    }

    @Override
    public PainelAbaIf[] getAbas() {
        PainelAbaIf[] lPaineis = null;
        if (this.getTabbedPane() != null && this.getTabbedPane().getTabCount() > 0) {
            lPaineis = new PainelAbaIf[this.getTabbedPane().getTabCount()];
            for (int i = 0; i < this.getTabbedPane().getTabCount(); ++i) {
                Component c = this.getTabbedPane().getComponentAt(i);
                if (!(c instanceof PainelAbaIf)) continue;
                lPaineis[i] = (PainelAbaIf)((Object)c);
            }
        }
        return lPaineis;
    }

    @Override
    public void acionarAba(String pNomeAba, boolean pFocusPadraoDaAba) {
        int indice = this.getIndiceAbaPorNome(pNomeAba);
        if (indice != -1 && this.getTabbedPane().isEnabledAt(indice)) {
            this.getTabbedPane().setSelectedIndex(indice);
            PainelDemonstrativoAb painelDemonstrativoAb = (PainelDemonstrativoAb)this.getTabbedPane().getComponentAt(indice);
        }
    }

    @Override
    public int getIndiceAbaPorNome(String nomeAba) {
        if (this.isPossuiAbas()) {
            return this.getTabbedPane().indexOfTab(nomeAba);
        }
        return -1;
    }

    @Override
    public void setEnabledAbaPorNome(String pNomeAba, boolean pEnabled) {
        int index = this.getIndiceAbaPorNome(pNomeAba);
        if (index > -1) {
            this.getTabbedPane().setEnabledAt(index, pEnabled);
        }
    }

    @Override
    public boolean isEnabledAbaPorNome(String pNomeAba) {
        int index = this.getIndiceAbaPorNome(pNomeAba);
        if (index > -1) {
            return this.getTabbedPane().isEnabledAt(index);
        }
        return false;
    }

    @Override
    public void setAbaPorNome(PainelAbaIf pPainelAba, String pNomeAbaSubstituir) {
        int index = this.getIndiceAbaPorNome(pNomeAbaSubstituir);
        if (index > -1 && ((PainelDemonstrativoIf)((Object)this.getTabbedPane().getSelectedComponent())).isPodeSair()) {
            ((PainelDemonstrativoIf)((Object)pPainelAba)).preExibir();
            this.getTabbedPane().setComponentAt(index, (Component)((Object)pPainelAba));
            ((PainelDemonstrativoIf)((Object)pPainelAba)).posExibir();
            ((Component)((Object)pPainelAba)).repaint();
            if (IRPFUtil.getEstadoSistema() != 1) {
                ((PainelDemonstrativoIf)((Object)pPainelAba)).getDefaultFocus().requestFocusInWindow();
            }
        }
    }

    @Override
    public void removeAbaPorNome(String pNomeAba) {
        int index = this.getIndiceAbaPorNome(pNomeAba);
        if (index > -1) {
            this.getTabbedPane().remove(index);
        }
    }

    @Override
    public void adicionarAba(PainelAbaIf pPainelAba) {
        if (this.getIndiceAbaPorNome(pPainelAba.getNomeAba()) == -1) {
            this.getTabbedPane().add((Component)((Object)pPainelAba));
        }
    }

    @Override
    public void adicionarAba(PainelAbaIf pPainelAba, int pIndex) {
        if (this.getIndiceAbaPorNome(pPainelAba.getNomeAba()) == -1) {
            this.getTabbedPane().add((Component)((Object)pPainelAba), pIndex);
        }
    }

    @Override
    public void initListener() {
    }

    public IRPFTableAb getTabela() {
        return null;
    }

    public void atualizarLista() {
        TableModel model;
        IRPFTableAb tabela = this.getTabela();
        if (tabela != null && (model = tabela.getModel()) instanceof AbstractTableModel) {
            ((AbstractTableModel)model).fireTableDataChanged();
        }
    }

    @Override
    public String getHelpID() {
        return null;
    }

    public void registrarCacheCampoNI() {
        if (!this.cacheNIRegistrado) {
            this.cacheNIRegistrado = true;
            CacheNI.getInstancia().registrarCacheCampoNI((Container)this);
        }
    }
}

