/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui;

import com.jgoodies.forms.builder.I15dPanelBuilder;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ConstantSize;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import serpro.ppgd.gui.xbeans.JEditCampo;
import serpro.ppgd.gui.xbeans.JEditLogico;
import serpro.ppgd.irpf.gui.PPGDComponentFactory;

public final class PPGDFormBuilder
extends I15dPanelBuilder {
    private RowSpec lineGapSpec = FormFactory.LINE_GAP_ROWSPEC;
    private RowSpec paragraphGapSpec = FormFactory.PARAGRAPH_GAP_ROWSPEC;
    private int leadingColumnOffset = 0;
    private boolean rowGroupingEnabled = false;

    public PPGDFormBuilder(FormLayout layout) {
        this(new JPanel(), layout);
    }

    public PPGDFormBuilder(JPanel panel, FormLayout layout) {
        this(panel, layout, null);
    }

    public PPGDFormBuilder(FormLayout layout, ResourceBundle bundle) {
        this(new JPanel(), layout, bundle);
    }

    public PPGDFormBuilder(JPanel panel, FormLayout layout, ResourceBundle bundle) {
        super(panel, layout, bundle);
        this.setComponentFactory(PPGDComponentFactory.getInstancia());
    }

    public void setLineGapSize(ConstantSize lineGapSize) {
        RowSpec rowSpec = FormFactory.createGapRowSpec((ConstantSize)lineGapSize);
        this.lineGapSpec = rowSpec.asUnmodifyable();
    }

    public RowSpec getLineGapSpec() {
        return this.lineGapSpec;
    }

    public void setParagraphGapSize(ConstantSize paragraphGapSize) {
        RowSpec rowSpec = FormFactory.createGapRowSpec((ConstantSize)paragraphGapSize);
        this.paragraphGapSpec = rowSpec.asUnmodifyable();
    }

    public int getLeadingColumnOffset() {
        return this.leadingColumnOffset;
    }

    public void setLeadingColumnOffset(int columnOffset) {
        this.leadingColumnOffset = columnOffset;
    }

    public boolean isRowGroupingEnabled() {
        return this.rowGroupingEnabled;
    }

    public void setRowGroupingEnabled(boolean enabled) {
        this.rowGroupingEnabled = enabled;
    }

    public void append(Component component) {
        this.append(component, 1);
    }

    public void append(Component component, int columnSpan, boolean lastInLine) {
        this.ensureCursorColumnInGrid();
        this.ensureHasGapRow(this.lineGapSpec);
        this.ensureHasComponentLine();
        if (lastInLine) {
            int colAtual = this.getColumn();
            int numCols = this.getColumnCount();
            columnSpan = numCols - colAtual + 1;
        }
        this.add(component, this.createLeftAdjustedConstraints(columnSpan));
        this.nextColumn(columnSpan + 1);
    }

    public void append(Component component, int columnSpan) {
        this.append(component, columnSpan, false);
    }

    public void append(Component c1, Component c2) {
        this.append(c1);
        this.append(c2);
    }

    public void append(Component c1, Component c2, Component c3) {
        this.append(c1);
        this.append(c2);
        this.append(c3);
    }

    public JLabel append(String textWithMnemonic) {
        JLabel label = this.getComponentFactory().createLabel(textWithMnemonic);
        this.append(label);
        return label;
    }

    public JLabel append(String textWithMnemonic, Component component) {
        return this.append(textWithMnemonic, component, 1);
    }

    public JLabel append(String textWithMnemonic, Component c, int columnSpan) {
        JLabel label = this.append(textWithMnemonic);
        label.setLabelFor(c);
        this.append(c, columnSpan);
        return label;
    }

    public JLabel append(JLabel l, Component c, int columnSpan) {
        this.append(l);
        l.setLabelFor(c);
        this.append(c, columnSpan);
        return l;
    }

    public void appendNoMessage(JEditCampo eCampo) {
        this.append((Component)eCampo.getRotulo(), (Component)eCampo.getComponenteEditor());
    }

    public void appendNoMessage(JEditCampo eCampo, int columnSpan) {
        this.append(eCampo.getRotulo(), (Component)eCampo.getComponenteEditor(), columnSpan);
    }

    public void append(JEditCampo eCampo, int columnSpan) {
        JPanel panel = this.createMessagePanel(eCampo);
        this.append(eCampo.getRotulo(), (Component)panel, columnSpan);
    }

    public void appendLabel(JEditCampo eCampo, int columnSpan) {
        CellConstraints cc = new CellConstraints();
        JPanel pnlRotulo = new JPanel((LayoutManager)new FormLayout("p:grow,center:MAX(p;8dlu)", "fill:p"));
        pnlRotulo.add((Component)eCampo.getRotulo(), cc.xy(1, 1));
        pnlRotulo.add((Component)eCampo.getSimbolo(), cc.xy(2, 1));
        this.append((Component)pnlRotulo, columnSpan);
    }

    public void appendEditor(JEditCampo eCampo, int columnSpan) {
        JPanel panel = this.createMessagePanel(eCampo);
        this.append((Component)panel, columnSpan);
    }

    public void appendEditorNoMessage(JEditCampo eCampo) {
        this.append(eCampo.getComponenteEditor());
    }

    public void appendEditorNoMessage(JEditCampo eCampo, int columnSpan) {
        this.append((Component)eCampo.getComponenteEditor(), columnSpan);
    }

    public void appendSingleCell(JEditCampo eCampo, int columnSpan) {
        JPanel panel = this.createAllPanel(eCampo);
        this.append((Component)panel, columnSpan);
    }

    public void appendSingleCellToEOL(JEditCampo eCampo) {
        JPanel panel = this.createAllPanel(eCampo);
        this.append((Component)panel, 0, true);
    }

    public JLabel appendTitulo(String titulo) {
        return this.appendTitulo(titulo, 0);
    }

    public JLabel appendTitulo(String titulo, boolean negrito) {
        return this.appendTitulo(titulo, 0, negrito);
    }

    public JLabel appendTitulo(String titulo, int colSpan) {
        return this.appendTitulo(titulo, colSpan, false);
    }

    public JLabel appendTitulo(String titulo, int colSpan, boolean negrito) {
        JLabel lbTit = new JLabel(titulo);
        if (colSpan != 0) {
            this.append((Component)lbTit, colSpan);
        } else {
            this.append(lbTit);
        }
        return lbTit;
    }

    private JPanel createMessagePanel(JEditCampo eCampo) {
        FormLayout layout = new FormLayout("fill:default:grow, center:8dlu", "fill:p");
        JPanel p = new JPanel((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        p.add((Component)eCampo.getComponenteEditor(), cc.xy(1, 1));
        p.add((Component)eCampo.getButtonMensagem(), cc.xy(2, 1));
        p.setOpaque(false);
        return p;
    }

    public JPanel createAllPanel(JEditCampo eCampo) {
        FormLayout layout = new FormLayout("left:pref, 2dlu, fill:default:grow, center:8dlu", "fill:p");
        JPanel p = new JPanel((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        JPanel pnlRotulo = new JPanel((LayoutManager)new FormLayout("p:grow,center:8dlu", "fill:p"));
        pnlRotulo.add((Component)eCampo.getRotulo(), cc.xy(1, 1));
        pnlRotulo.add((Component)eCampo.getSimbolo(), cc.xy(2, 1));
        p.add((Component)pnlRotulo, cc.xy(1, 1));
        p.add((Component)eCampo.getComponenteEditor(), cc.xy(3, 1));
        p.add((Component)eCampo.getButtonMensagem(), cc.xy(4, 1));
        p.setOpaque(false);
        return p;
    }

    public void append(JEditCampo eCampo) {
        CellConstraints cc = new CellConstraints();
        JPanel pnlRotulo = new JPanel((LayoutManager)new FormLayout("p:grow,center:MAX(8dlu;p)", "fill:p"));
        pnlRotulo.add((Component)eCampo.getRotulo(), cc.xy(1, 1));
        pnlRotulo.add((Component)eCampo.getSimbolo(), cc.xy(2, 1));
        this.append((Component)pnlRotulo, (Component)this.createMessagePanel(eCampo));
    }

    public void appendToEOLNoMessage(JEditCampo eCampo) {
        JLabel label = this.append(eCampo.getInformacao().getNomeCampo());
        JComponent c = eCampo.getComponenteEditor();
        label.setLabelFor(c);
        eCampo.setRotulo(label);
        this.append((Component)c, 0, true);
    }

    public void appendToEOL(JEditCampo eCampo) {
        JLabel label = this.append(eCampo.getInformacao().getNomeCampo());
        JPanel c = this.createMessagePanel(eCampo);
        label.setLabelFor(eCampo.getComponenteEditor());
        eCampo.setRotulo(label);
        this.append((Component)c, 0, true);
    }

    public void appendCenter(JComponent c) {
        this.append((Component)this.createCenterPanel(c), 0, true);
    }

    public JPanel createCenterPanel(JComponent c) {
        FormLayout layout = new FormLayout("p:grow, center:p, p:grow", "p");
        JPanel p = new JPanel((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        p.add((Component)c, cc.xy(2, 1));
        return p;
    }

    public JLabel append(String textWithMnemonic, Component c1, Component c2) {
        JLabel label = this.append(textWithMnemonic, c1);
        this.append(c2);
        return label;
    }

    public void append(String textWithMnemonic, Component c1, Component c2, int colSpan) {
        this.append(textWithMnemonic, c1);
        this.append(c2, colSpan);
    }

    public JLabel append(String textWithMnemonic, Component c1, Component c2, Component c3) {
        JLabel label = this.append(textWithMnemonic, c1, c2);
        this.append(c3);
        return label;
    }

    public JLabel append(String textWithMnemonic, Component c1, Component c2, Component c3, Component c4) {
        JLabel label = this.append(textWithMnemonic, c1, c2, c3);
        this.append(c4);
        return label;
    }

    public JLabel appendI15d(String resourceKey) {
        return this.append(this.getI15dString(resourceKey));
    }

    public JLabel appendI15d(String resourceKey, Component c, int columnSpan) {
        JLabel label = this.appendI15d(resourceKey);
        this.append(c, columnSpan);
        return label;
    }

    public JLabel appendI15d(String resourceKey, Component component) {
        return this.appendI15d(resourceKey, component, 1);
    }

    public JLabel appendI15d(String resourceKey, Component component, boolean nextLine) {
        JLabel label = this.appendI15d(resourceKey, component, 1);
        if (nextLine) {
            this.nextLine();
        }
        return label;
    }

    public JLabel appendI15d(String resourceKey, Component c1, Component c2) {
        JLabel label = this.appendI15d(resourceKey, c1);
        this.append(c2);
        return label;
    }

    public JLabel appendI15d(String resourceKey, Component c1, Component c2, int colSpan) {
        JLabel label = this.appendI15d(resourceKey, c1);
        this.append(c2, colSpan);
        return label;
    }

    public JLabel appendI15d(String resourceKey, Component c1, Component c2, Component c3) {
        JLabel label = this.appendI15d(resourceKey, c1, c2);
        this.append(c3);
        return label;
    }

    public JLabel appendI15d(String resourceKey, Component c1, Component c2, Component c3, Component c4) {
        JLabel label = this.appendI15d(resourceKey, c1, c2, c3);
        this.append(c4);
        return label;
    }

    public JLabel appendTitle(String textWithMnemonic) {
        JLabel titleLabel = this.getComponentFactory().createTitle(textWithMnemonic);
        this.append(titleLabel);
        return titleLabel;
    }

    public JLabel appendI15dTitle(String resourceKey) {
        return this.appendTitle(this.getI15dString(resourceKey));
    }

    public JComponent appendSeparator() {
        return this.appendSeparator("");
    }

    public JComponent appendSeparator(String text) {
        this.ensureCursorColumnInGrid();
        this.ensureHasGapRow(this.paragraphGapSpec);
        this.ensureHasComponentLine();
        this.setColumn(super.getLeadingColumn());
        int columnSpan = this.getColumnCount();
        this.setColumnSpan(this.getColumnCount());
        JComponent titledSeparator = this.addSeparator(text);
        this.setColumnSpan(1);
        this.nextColumn(columnSpan);
        return titledSeparator;
    }

    public void appendI15dSeparator(String resourceKey) {
        this.appendSeparator(this.getI15dString(resourceKey));
    }

    protected int getLeadingColumn() {
        int column = super.getLeadingColumn();
        return column + this.getLeadingColumnOffset() * this.getColumnIncrementSign();
    }

    private void ensureCursorColumnInGrid() {
        if (this.isLeftToRight() && this.getColumn() > this.getColumnCount() || !this.isLeftToRight() && this.getColumn() < 1) {
            this.nextLine();
        }
    }

    private void ensureHasGapRow(RowSpec gapRowSpec) {
        RowSpec rowSpec;
        if (this.getRow() == 1 || this.getRow() <= this.getRowCount()) {
            return;
        }
        if (this.getRow() <= this.getRowCount() && (rowSpec = this.getCursorRowSpec()) == gapRowSpec) {
            return;
        }
        this.appendRow(gapRowSpec);
        this.nextLine();
    }

    private void ensureHasComponentLine() {
        if (this.getRow() <= this.getRowCount()) {
            return;
        }
        this.appendRow(FormFactory.PREF_ROWSPEC);
        if (this.isRowGroupingEnabled()) {
            this.getLayout().addGroupedRow(this.getRow());
        }
    }

    private RowSpec getCursorRowSpec() {
        return this.getLayout().getRowSpec(this.getRow());
    }

    public void appendWithBorder(Border borda, JEditCampo c, int colSpan) {
        JPanel panel = this.createAllPanel(c);
        panel.setBorder(borda);
        this.append((Component)panel, colSpan, false);
    }

    public void appendButtonGroup(Border borda, JEditCampo c, int colSpan) {
        JPanel panel = this.createButtonGroupPanel(c);
        panel.setBorder(borda);
        this.append((Component)panel, colSpan, false);
    }

    public JPanel createButtonGroupPanel(JEditCampo c) {
        JEditCampo edtCampo = c;
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)edtCampo.getComponenteEditor(), "Center");
        p.add((Component)edtCampo.getButtonMensagem(), "East");
        p.setOpaque(false);
        return p;
    }

    public void appendButtonGroupFormLayout(Border borda, JEditCampo c, int colSpan) {
        JPanel panel = this.createButtonGroupPanelFormLayout(c);
        panel.setBorder(borda);
        this.append((Component)panel, colSpan, false);
    }

    public JPanel createButtonGroupPanelFormLayout(JEditCampo c) {
        JEditLogico edtLogico = (JEditLogico)c;
        JPanel panel = new JPanel((LayoutManager)new FormLayout("left:pref, 2dlu, center:MAX(8dlu;M)", "fill:p,fill:p"));
        Box box = new Box(edtLogico.getOrientacaoTexto());
        CellConstraints cc = new CellConstraints();
        for (JRadioButton rb : edtLogico.getListaRadiosOrdenada()) {
            box.add(rb);
            if (edtLogico.getOrientacaoTexto() != 0) continue;
            box.add(new JLabel(" "));
        }
        panel.add((Component)box, cc.xy(1, 1));
        panel.add((Component)edtLogico.getButtonMensagem(), cc.xywh(3, 1, 1, 2));
        panel.setOpaque(false);
        return panel;
    }
}

