/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui;

import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.text.MaskFormatter;
import javax.swing.tree.DefaultMutableTreeNode;
import serpro.ppgd.gui.xbeans.JButtonMensagem;
import serpro.ppgd.gui.xbeans.JEditCampo;
import serpro.ppgd.gui.xbeans.PainelBotao;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.irpf.gui.componente.PPGDFormPanel;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.ElementoTabela;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.util.LogPPGD;

public class JEditOcupacaoPrincipal
extends JEditCampo {
    private static final long serialVersionUID = 1L;
    private static final Color COR_BORDA = new Color(205, 205, 205);
    private static Codigo vazio = new Codigo(null, "EditOcupacaoPrincipal", new ArrayList());
    private static String TITULO_OCUP_PRINCIPAL = "Ocupa\u00e7\u00e3o Principal";
    private JTextField labelCodigo;
    private JLabel label;
    private JButton button;
    private JPanel box;
    private JDialog frame;
    private JTree tree;
    private float tamanhoOriginalLabel = -1.0f;

    public JEditOcupacaoPrincipal() {
        this((Informacao)vazio);
    }

    public JEditOcupacaoPrincipal(Informacao campo, Dimension[] d) {
        super(campo);
        if (d.length < 4) {
            throw new IllegalStateException("O array d[] deve ter pelo menos 4 elementos");
        }
    }

    public JEditOcupacaoPrincipal(Informacao campo) {
        this(campo, new Dimension[]{new Dimension(3, 0), new Dimension(2, 0), new Dimension(0, 0), new Dimension(700, 400)});
    }

    public JEditOcupacaoPrincipal(Informacao campo, Dimension d) {
        this(campo, new Dimension[]{new Dimension(3, 0), new Dimension(2, 0), new Dimension(0, 0), d});
    }

    public int getBaseline(int width, int height) {
        JComponent editor = this.getComponenteEditor();
        if (editor != null) {
            return editor.getBaseline(width, height);
        }
        return -1;
    }

    public Component.BaselineResizeBehavior getBaselineResizeBehavior() {
        JComponent editor = this.getComponenteEditor();
        if (editor != null) {
            return editor.getBaselineResizeBehavior();
        }
        return Component.BaselineResizeBehavior.OTHER;
    }

    public JComponent getComponenteEditor() {
        return this.box;
    }

    protected void buildComponente() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        if (this.box == null) {
            this.box = new JPanel(new BorderLayout());
            this.box.setFocusable(false);
            JPanel boxInter1 = new JPanel(new BorderLayout());
            MaskFormatter format = null;
            try {
                format = new MaskFormatter("###");
            }
            catch (Exception e) {
                LogPPGD.erro((String)e.getMessage());
            }
            this.labelCodigo = new JFormattedTextField(format);
            ((JFormattedTextField)this.labelCodigo).setFocusLostBehavior(0);
            this.labelCodigo.setPreferredSize(new Dimension(40, this.labelCodigo.getPreferredSize().height));
            this.labelCodigo.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JEditOcupacaoPrincipal.this.labelCodigo.selectAll();
                        }
                    });
                }

                @Override
                public void focusLost(FocusEvent e) {
                    JEditOcupacaoPrincipal.this.setIdentificacaoFoco(false);
                    JEditOcupacaoPrincipal.this.setObservadorAtivo(false);
                    JEditOcupacaoPrincipal.this.getInformacao().setConteudo(JEditOcupacaoPrincipal.this.labelCodigo.getText());
                    String codigo = "";
                    String desc = "";
                    if (JEditOcupacaoPrincipal.this.chamaValidacao()) {
                        codigo = JEditOcupacaoPrincipal.this.getInformacao().formatado();
                        desc = ((Codigo)JEditOcupacaoPrincipal.this.campo).getConteudoAtual(3);
                    }
                    JEditOcupacaoPrincipal.this.label.setText(desc);
                    JEditOcupacaoPrincipal.this.setAccessibleName(codigo, desc);
                    JEditOcupacaoPrincipal.this.setObservadorAtivo(true);
                }
            });
            this.button = new JButton(GuiUtil.getImage("/icones/png14px/lente_aumento.png"));
            this.button.getAccessibleContext().setAccessibleName("Lista de ocupa\u00e7\u00f5es principais");
            this.button.setPreferredSize(new Dimension(24, this.button.getPreferredSize().height));
            if (!PlataformaPPGD.isEmDesign()) {
                this.button.addActionListener(new LocalActionListener());
            }
            boxInter1.add((Component)this.labelCodigo, "Center");
            boxInter1.add((Component)this.button, "East");
            this.box.add((Component)boxInter1, "West");
            this.label = new JLabel();
            this.label.setPreferredSize(new Dimension(90, this.label.getPreferredSize().height));
            this.init(this.label, BorderFactory.createLineBorder(COR_BORDA));
            this.label.setHorizontalAlignment(2);
            this.label.setFocusable(false);
            this.box.add((Component)this.label, "Center");
        }
        PPGDFormPanel pnl = new PPGDFormPanel();
        pnl.setLayout((LayoutManager)new FormLayout("30dlu:grow", "P"));
        pnl.getBuilder().append(this.getComponenteEditor());
        this.add(pnl, "Center");
        JButtonMensagem btnMsg = this.getButtonMensagem();
        if (btnMsg != null) {
            this.add((Component)new PainelBotao(btnMsg), "East");
        }
    }

    private void init(JComponent componente, Border border) {
        componente.setAlignmentY(0.0f);
        if (border != null) {
            componente.setBorder(border);
        }
    }

    protected void readOnlyPropertyChange(boolean readOnly) {
        if (readOnly) {
            this.labelCodigo.setEditable(false);
            this.label.setEnabled(false);
            this.button.setEnabled(false);
            if (this.getRotulo() != null) {
                this.getRotulo().setEnabled(false);
            }
        } else {
            this.labelCodigo.setEnabled(true);
            this.label.setEnabled(true);
            this.button.setEnabled(true);
            if (this.getRotulo() != null) {
                this.getRotulo().setEnabled(true);
            }
        }
    }

    protected void habilitadoPropertyChange(boolean habilitado) {
        this.labelCodigo.setEnabled(habilitado);
        this.label.setEnabled(habilitado);
        this.button.setEnabled(habilitado);
        if (this.getRotulo() != null) {
            this.getRotulo().setEnabled(habilitado);
        }
    }

    private void setAccessibleName(String codigo, String texto) {
        this.getAccessibleContext().setAccessibleName("Ocupa\u00e7\u00e3o Principal do Contribuinte " + codigo + " " + texto);
    }

    public void implementacaoPropertyChange(PropertyChangeEvent evt) {
        String codigo = this.getInformacao().formatado();
        String texto = ((Codigo)this.getInformacao()).getConteudoAtual(3);
        this.labelCodigo.setText(codigo);
        this.label.setText(texto);
        this.setAccessibleName(codigo, texto);
    }

    public JComponent getComponenteFoco() {
        return this.labelCodigo;
    }

    protected void informacaoModificada() {
        this.implementacaoPropertyChange(null);
    }

    public void setEstiloFonte(int estilo) {
        Font f = this.labelCodigo.getFont();
        f = f.deriveFont(estilo);
        this.labelCodigo.setFont(f);
        f = this.label.getFont();
        f = f.deriveFont(estilo);
        this.label.setFont(f);
    }

    public void setIncrementoTamanhoFonte(int incremento) {
        this.incrementoTamanhoFonte = incremento;
        Font f = this.labelCodigo.getFont();
        if (this.tamanhoOriginal == -1.0f) {
            this.tamanhoOriginal = f.getSize2D();
        }
        f = f.deriveFont(this.tamanhoOriginal + (float)incremento);
        this.labelCodigo.setFont(f);
        f = this.label.getFont();
        if (this.tamanhoOriginalLabel == -1.0f) {
            this.tamanhoOriginalLabel = f.getSize2D();
        }
        f = f.deriveFont(this.tamanhoOriginal + (float)incremento);
        this.label.setFont(f);
    }

    public int getIncrementoTamanhoFonte() {
        return this.incrementoTamanhoFonte;
    }

    public void conteudoPropertyChange(PropertyChangeEvent arg0) {
    }

    private class LocalActionListener
    implements ActionListener {
        private LocalActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (JEditOcupacaoPrincipal.this.frame == null) {
                JEditOcupacaoPrincipal.this.frame = new JDialog();
                JEditOcupacaoPrincipal.this.frame.setIconImage(GuiUtil.getImage("/icones/png16px/Icon_barraTitulo_16px.png").getImage());
                JEditOcupacaoPrincipal.this.frame.setDefaultCloseOperation(2);
                DefaultMutableTreeNode raiz = new DefaultMutableTreeNode(TITULO_OCUP_PRINCIPAL);
                Vector colecao = new Vector(((Codigo)JEditOcupacaoPrincipal.this.getInformacao()).getColecaoElementoTabela());
                ElementoTabela elementoTabela = (ElementoTabela)colecao.firstElement();
                String codigoNivel1 = elementoTabela.getConteudo(1);
                String codigoNivel2 = elementoTabela.getConteudo(0);
                String descricaoNivel1 = elementoTabela.getConteudo(2);
                String descricaoNivel2 = elementoTabela.getConteudo(3);
                for (int i = 0; i < colecao.size(); ++i) {
                    String _codigoNivel1 = codigoNivel1;
                    DefaultMutableTreeNode elementoRaiz = new DefaultMutableTreeNode(codigoNivel1 + "-" + descricaoNivel1);
                    raiz.add(elementoRaiz);
                    while (_codigoNivel1.equals(elementoTabela.getConteudo(1))) {
                        DefaultMutableTreeNode elemento = new DefaultMutableTreeNode(codigoNivel2 + "-" + descricaoNivel2);
                        elementoRaiz.add(elemento);
                        if (++i >= colecao.size()) break;
                        elementoTabela = (ElementoTabela)colecao.get(i);
                        codigoNivel1 = elementoTabela.getConteudo(1);
                        codigoNivel2 = elementoTabela.getConteudo(0);
                        descricaoNivel1 = elementoTabela.getConteudo(2);
                        descricaoNivel2 = elementoTabela.getConteudo(3);
                    }
                    --i;
                }
                JEditOcupacaoPrincipal.this.tree = new JTree(raiz);
                JEditOcupacaoPrincipal.this.tree.getSelectionModel().setSelectionMode(1);
                JEditOcupacaoPrincipal.this.tree.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyReleased(KeyEvent e) {
                        super.keyReleased(e);
                        switch (e.getKeyCode()) {
                            case 27: {
                                JEditOcupacaoPrincipal.this.frame.dispose();
                                break;
                            }
                            case 10: {
                                if (!LocalActionListener.this.setLabelCodigo(JEditOcupacaoPrincipal.this.tree)) break;
                                JEditOcupacaoPrincipal.this.frame.dispose();
                            }
                        }
                    }
                });
                JEditOcupacaoPrincipal.this.tree.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent e) {
                        if (e.getClickCount() == 2 && LocalActionListener.this.setLabelCodigo(JEditOcupacaoPrincipal.this.tree)) {
                            JEditOcupacaoPrincipal.this.frame.dispose();
                        }
                    }
                });
                JScrollPane scrollPane = new JScrollPane(JEditOcupacaoPrincipal.this.tree);
                JEditOcupacaoPrincipal.this.frame.getContentPane().add(scrollPane);
                JEditOcupacaoPrincipal.this.frame.addWindowFocusListener(new WindowFocusListener(){

                    @Override
                    public void windowGainedFocus(WindowEvent e) {
                    }

                    @Override
                    public void windowLostFocus(WindowEvent e) {
                        JEditOcupacaoPrincipal.this.frame.dispose();
                    }
                });
            }
            JEditOcupacaoPrincipal.this.frame.setSize(new Dimension(700, 400));
            JEditOcupacaoPrincipal.this.frame.setLocationRelativeTo(null);
            JEditOcupacaoPrincipal.this.frame.setVisible(true);
        }

        private boolean setLabelCodigo(JTree tree) {
            String s;
            int i;
            boolean ret = false;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree.getLastSelectedPathComponent();
            if (node != null && (i = (s = (String)node.getUserObject()).indexOf(45)) == 3) {
                ret = true;
                String codigo = s.substring(0, i);
                String descricao = s.substring(i + 1, s.length());
                JEditOcupacaoPrincipal.this.setObservadorAtivo(false);
                JEditOcupacaoPrincipal.this.getInformacao().setConteudo(codigo);
                JEditOcupacaoPrincipal.this.labelCodigo.setText(codigo);
                JEditOcupacaoPrincipal.this.chamaValidacao();
                JEditOcupacaoPrincipal.this.setObservadorAtivo(true);
                JEditOcupacaoPrincipal.this.label.setText(descricao);
                JEditOcupacaoPrincipal.this.setAccessibleName(codigo, descricao);
            }
            return ret;
        }
    }
}

