/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.apache.commons.io.FileUtils;
import serpro.ppgd.app.acoes.AbrirCalculadoraAction;
import serpro.ppgd.app.acoes.ConverterDeclaracaoAction;
import serpro.ppgd.cacheni.CacheNI;
import serpro.ppgd.formatosexternos.txt.excecao.GeracaoTxtException;
import serpro.ppgd.gui.pendencia.MapeamentoInformacaoEditCampo;
import serpro.ppgd.gui.xbeans.JButtonGroupPanel;
import serpro.ppgd.gui.xbeans.JEditAlfa;
import serpro.ppgd.gui.xbeans.JEditCampo;
import serpro.ppgd.gui.xbeans.JEditCodigo;
import serpro.ppgd.gui.xbeans.JEditInteiro;
import serpro.ppgd.gui.xbeans.JEditLogico;
import serpro.ppgd.gui.xbeans.autocomplete.JAutoCompleteEditCPF;
import serpro.ppgd.gui.xbeans.autocomplete.JAutoCompleteEditCodigo;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.util.PainelCacher;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.exception.AplicacaoException;
import serpro.ppgd.irpf.exception.BarramentoException;
import serpro.ppgd.irpf.gui.IRPFBemVindos;
import serpro.ppgd.irpf.gui.IRPFTableModelAb;
import serpro.ppgd.irpf.gui.JanelaPrincipalIRPF;
import serpro.ppgd.irpf.gui.NavegacaoIf;
import serpro.ppgd.irpf.gui.PainelContainer;
import serpro.ppgd.irpf.gui.PainelDemonstrativoAb;
import serpro.ppgd.irpf.gui.PainelDemonstrativoIf;
import serpro.ppgd.irpf.gui.PainelPrincipalAb;
import serpro.ppgd.irpf.gui.dashboard.fichas.ButtonFicha2;
import serpro.ppgd.irpf.gui.listener.CabecalhoFichaListener;
import serpro.ppgd.irpf.gui.listener.DemonstrativoListener;
import serpro.ppgd.irpf.gui.listener.FavoritoEvent;
import serpro.ppgd.irpf.gui.listener.FavoritoListener;
import serpro.ppgd.irpf.gui.listener.HabilitacaoAvaliacaoListener;
import serpro.ppgd.irpf.gui.listener.HelpListener;
import serpro.ppgd.irpf.gui.listener.LoginGovListener;
import serpro.ppgd.irpf.gui.listener.MensagemFichaListener;
import serpro.ppgd.irpf.gui.listener.TabelasAtualizadasListener;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.gui.util.ProcessoSwing;
import serpro.ppgd.irpf.gui.util.Tarefa;
import serpro.ppgd.irpf.nuvem.BarramentoIRPFService;
import serpro.ppgd.irpf.nuvem.UsuarioLogado;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.irpf.tabelas.CodigoTabelaMensagens;
import serpro.ppgd.irpf.tabelas.TabelaDatasIRPF;
import serpro.ppgd.irpf.txt.gravacaorestauracao.ImportadorTxt;
import serpro.ppgd.irpf.util.ConstantesGlobaisIRPF;
import serpro.ppgd.irpf.util.IRPFUtil;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.ppgd.persistenciagenerica.BackupInexistenteException;
import serpro.ppgd.persistenciagenerica.HashInvalidoException;

public class ControladorGui {
    private static DeclaracaoIRPF demonstrativoAberto = null;
    private static PainelDemonstrativoIf painelAtualmenteExibido = null;
    private static ListenerList<DemonstrativoListener> listaEscutadores = null;
    private static ListenerList<CabecalhoFichaListener> listaEscutadoresCabecalhoFicha = null;
    private static ListenerList<MensagemFichaListener> listaEscutadoresMensagemFicha = null;
    private static ListenerList<HelpListener> listaEscutadoresHelp = null;
    private static ListenerList<FavoritoListener> listaEscutadoresFavoritos = null;
    private static ListenerList<LoginGovListener> listaEscutadoresLoginGov = null;
    private static ListenerList<TabelasAtualizadasListener> listaEscutadoresTabelasAtualizadas = null;
    private static ListenerList<HabilitacaoAvaliacaoListener> listaEscutadoresHabilitacaoAvaliacao = null;
    private static final Preferences preferences = Preferences.userNodeForPackage(DeclaracaoIRPF.class);
    public static final String CACHE_NI_LIGADO_PREF = "CacheNILigado";
    public static final String CACHE_NI_MSG_INICIAL_EXIBIDA_PREF = "CacheNIMsgInicial";
    public static final String NAO_EXIBIR_NOVIDADES_IRPF = "NaoExibirNovidades" + ConstantesGlobais.EXERCICIO;
    public static final String NAO_EXIBIR_AVALIACAO = "NaoExibirAvaliacao" + ConstantesGlobais.EXERCICIO;
    private static boolean readOnly = false;
    private static Boolean cacheNIHabilitado = null;
    private static Date dataConsultaDataAtual = null;
    private static Date dataServidor = null;
    private static boolean foraPrazoHOM = false;

    public static void setReadOnlyMode(boolean flag) {
        readOnly = flag;
        if (flag) {
            cacheNIHabilitado = CacheNI.getInstancia().isLigado();
            CacheNI.getInstancia().setLigado(false);
        } else if (cacheNIHabilitado != null) {
            CacheNI.getInstancia().setLigado(cacheNIHabilitado.booleanValue());
            cacheNIHabilitado = null;
        }
    }

    public static boolean isReadOnly() {
        return readOnly;
    }

    public static Preferences getIRPFPreferences() {
        return preferences;
    }

    private static void dispatchDemonstrativoAberto() {
        if (listaEscutadores != null) {
            for (DemonstrativoListener lListener : listaEscutadores.list()) {
                lListener.demonstrativoAberto();
            }
        }
    }

    private static boolean dispatchDemonstrativoVaiFechar() {
        if (listaEscutadores != null) {
            for (DemonstrativoListener lListener : listaEscutadores.list()) {
                if (lListener.demonstrativoVaiFechar()) continue;
                return false;
            }
        }
        return true;
    }

    private static void dispatchDemonstrativoFechado() {
        if (listaEscutadores != null) {
            for (DemonstrativoListener lListener : listaEscutadores.list()) {
                lListener.demonstrativoFechado();
            }
        }
    }

    private static void dispatchDemonstrativoSalvo() {
        if (listaEscutadores != null) {
            for (DemonstrativoListener lListener : listaEscutadores.list()) {
                lListener.demonstrativoSalvo();
            }
        }
    }

    private static void dispatchMudouNumeroDemonstrativos() {
        if (listaEscutadores != null) {
            for (DemonstrativoListener lListener : listaEscutadores.list()) {
                lListener.mudouNumeroDemonstrativos();
            }
        }
    }

    private static void dispatchAlterouOpcaoTributacao(DeclaracaoIRPF dec) {
        if (listaEscutadores != null) {
            for (DemonstrativoListener lListener : listaEscutadores.list()) {
                lListener.alterouOpcaoTributacao(dec);
            }
        }
    }

    private static boolean dispatchDemonstrativoVaiGravar() {
        if (listaEscutadores != null) {
            for (DemonstrativoListener lListener : listaEscutadores.list()) {
                lListener.demonstrativoVaiGravar();
            }
        }
        return true;
    }

    private static void dispatchDemonstrativoGravado() {
        if (listaEscutadores != null) {
            for (DemonstrativoListener lListener : listaEscutadores.list()) {
                lListener.demonstrativoGravado();
            }
        }
    }

    private static void dispatchMudouNumeroFavoritos(FavoritoEvent event) {
        if (listaEscutadores != null) {
            for (FavoritoListener lListener : listaEscutadoresFavoritos.list()) {
                lListener.mudouNumeroFavoritos(event);
            }
        }
    }

    private static void dispatchMudouCabecalho(String novoTextoCabecalho) {
        if (listaEscutadoresCabecalhoFicha != null) {
            for (CabecalhoFichaListener lListener : listaEscutadoresCabecalhoFicha.list()) {
                lListener.cabecalhoAlterado(novoTextoCabecalho);
            }
        }
    }

    private static void dispatchMudouMensagem(String novaMensagem) {
        if (listaEscutadoresMensagemFicha != null) {
            for (MensagemFichaListener lListener : listaEscutadoresMensagemFicha.list()) {
                lListener.mensagemAlterada(novaMensagem);
            }
        }
    }

    private static void dispatchMudouHelpId(String novoHelpId) {
        if (listaEscutadoresHelp != null) {
            for (HelpListener lListener : listaEscutadoresHelp.list()) {
                lListener.helpIdAlterado(novoHelpId);
            }
        }
    }

    public static void atualizarMenuAvaliacao(boolean habilitada) {
        if (habilitada) {
            ControladorGui.dispatchAvaliacaoHabilitada();
        } else {
            ControladorGui.dispatchAvaliacaoDesabilitada();
        }
    }

    private static void dispatchAvaliacaoHabilitada() {
        if (listaEscutadoresHabilitacaoAvaliacao != null) {
            for (HabilitacaoAvaliacaoListener lListener : listaEscutadoresHabilitacaoAvaliacao.list()) {
                lListener.avaliacaoHabilitada();
            }
        }
    }

    private static void dispatchAvaliacaoDesabilitada() {
        if (listaEscutadoresHabilitacaoAvaliacao != null) {
            for (HabilitacaoAvaliacaoListener lListener : listaEscutadoresHabilitacaoAvaliacao.list()) {
                lListener.avaliacaoDesabilitada();
            }
        }
    }

    public static void addHabilitacaoAvaliacaoListener(HabilitacaoAvaliacaoListener pListener) {
        if (listaEscutadoresHabilitacaoAvaliacao == null) {
            listaEscutadoresHabilitacaoAvaliacao = new ListenerList();
        }
        listaEscutadoresHabilitacaoAvaliacao.add(pListener);
    }

    public static void removeHabilitacaoAvaliacaoListener(LoginGovListener pListener) {
        if (listaEscutadoresHabilitacaoAvaliacao != null) {
            listaEscutadoresHabilitacaoAvaliacao.remove(pListener);
            if (listaEscutadoresHabilitacaoAvaliacao.isEmpty()) {
                listaEscutadoresHabilitacaoAvaliacao = null;
            }
        }
    }

    public static void atualizarUsuarioLogado(UsuarioLogado usuario) {
        if (usuario != null) {
            ControladorGui.dispatchUsuarioLogado(usuario);
        } else {
            ControladorGui.dispatchUsuarioDeslogado();
        }
    }

    private static void dispatchUsuarioLogado(UsuarioLogado usuario) {
        if (listaEscutadoresLoginGov != null) {
            for (LoginGovListener lListener : listaEscutadoresLoginGov.list()) {
                lListener.usuarioLogado(usuario);
            }
        }
    }

    private static void dispatchUsuarioDeslogado() {
        if (listaEscutadoresLoginGov != null) {
            for (LoginGovListener lListener : listaEscutadoresLoginGov.list()) {
                lListener.usuarioDeslogado();
            }
        }
    }

    public static void addLoginGovListener(LoginGovListener pListener) {
        if (listaEscutadoresLoginGov == null) {
            listaEscutadoresLoginGov = new ListenerList();
        }
        listaEscutadoresLoginGov.add(pListener);
    }

    public static void removeLoginGovListener(LoginGovListener pListener) {
        if (listaEscutadoresLoginGov != null) {
            listaEscutadoresLoginGov.remove(pListener);
            if (listaEscutadoresLoginGov.isEmpty()) {
                listaEscutadoresLoginGov = null;
            }
        }
    }

    public static void informarTabelasAtualizadas() {
        ControladorGui.dispatchTabelasAtualizadas();
    }

    private static void dispatchTabelasAtualizadas() {
        if (listaEscutadoresTabelasAtualizadas != null) {
            for (TabelasAtualizadasListener lListener : listaEscutadoresTabelasAtualizadas.list()) {
                lListener.tabelasAtualizadas();
            }
        }
    }

    public static void addTabelasAtualizadasListener(TabelasAtualizadasListener pListener) {
        if (listaEscutadoresTabelasAtualizadas == null) {
            listaEscutadoresTabelasAtualizadas = new ListenerList();
        }
        listaEscutadoresTabelasAtualizadas.add(pListener);
    }

    public static void removeTabelasAtualizadasListener(TabelasAtualizadasListener pListener) {
        if (listaEscutadoresTabelasAtualizadas != null) {
            listaEscutadoresTabelasAtualizadas.remove(pListener);
            if (listaEscutadoresTabelasAtualizadas.isEmpty()) {
                listaEscutadoresTabelasAtualizadas = null;
            }
        }
    }

    public static void addDemonstrativoListener(DemonstrativoListener pListener) {
        if (listaEscutadores == null) {
            listaEscutadores = new ListenerList();
        }
        listaEscutadores.add(pListener);
    }

    public static void removeDemonstrativoListener(DemonstrativoListener pListener) {
        if (listaEscutadores != null) {
            listaEscutadores.remove(pListener);
            if (listaEscutadores.isEmpty()) {
                listaEscutadores = null;
            }
        }
    }

    public static void addCabecalhoFichaListener(CabecalhoFichaListener pListener) {
        if (listaEscutadoresCabecalhoFicha == null) {
            listaEscutadoresCabecalhoFicha = new ListenerList();
        }
        listaEscutadoresCabecalhoFicha.add(pListener);
    }

    public static void addMensagemFichaListener(MensagemFichaListener pListener) {
        if (listaEscutadoresMensagemFicha == null) {
            listaEscutadoresMensagemFicha = new ListenerList();
        }
        listaEscutadoresMensagemFicha.add(pListener);
    }

    public static void removeMensagemFichaListener(MensagemFichaListener pListener) {
        if (listaEscutadoresMensagemFicha != null) {
            listaEscutadoresMensagemFicha.remove(pListener);
            if (listaEscutadoresMensagemFicha.isEmpty()) {
                listaEscutadoresMensagemFicha = null;
            }
        }
    }

    public static void addHelpListener(HelpListener pListener) {
        if (listaEscutadoresHelp == null) {
            listaEscutadoresHelp = new ListenerList();
        }
        listaEscutadoresHelp.add(pListener);
    }

    public static void removeHelpListener(HelpListener pListener) {
        if (listaEscutadoresHelp != null) {
            listaEscutadoresHelp.remove(pListener);
            if (listaEscutadoresHelp.isEmpty()) {
                listaEscutadoresHelp = null;
            }
        }
    }

    public static void addFavoritoListener(FavoritoListener pListener) {
        if (listaEscutadoresFavoritos == null) {
            listaEscutadoresFavoritos = new ListenerList();
        }
        listaEscutadoresFavoritos.add(pListener);
    }

    public static void removeFavoritoListener(FavoritoListener pListener) {
        if (listaEscutadoresFavoritos != null) {
            listaEscutadoresFavoritos.remove(pListener);
            if (listaEscutadoresFavoritos.isEmpty()) {
                listaEscutadoresFavoritos = null;
            }
        }
    }

    public static void init() {
        if (ControladorGui.isDemonstrativoAberto()) {
            ControladorGui.dispatchDemonstrativoAberto();
        } else {
            ControladorGui.dispatchDemonstrativoFechado();
        }
        ControladorGui.dispatchMudouNumeroDemonstrativos();
        IRPFBemVindos painelBemVindos = (IRPFBemVindos)PainelCacher.getInstancia().obtemUrgentemente(NavegacaoIf.PAINEL_BEM_VINDOS);
        ControladorGui.addDemonstrativoListener(painelBemVindos);
        ControladorGui.acionarPainel(painelBemVindos);
    }

    public static DeclaracaoIRPF getDemonstrativoAberto() {
        return demonstrativoAberto;
    }

    private static void setDemonstrativoAberto(DeclaracaoIRPF pDemonstrativoAberto) {
        demonstrativoAberto = pDemonstrativoAberto;
    }

    public static void setPainelAtualmenteExibido(PainelDemonstrativoIf pPainelAtualmenteExibido) {
        painelAtualmenteExibido = pPainelAtualmenteExibido;
    }

    public static PainelDemonstrativoIf getPainelAtualmenteExibido() {
        return painelAtualmenteExibido;
    }

    public static void atualizarListaPainelAtual() {
        PainelDemonstrativoIf painel = ControladorGui.getPainelAtualmenteExibido();
        if (painel != null && painel instanceof PainelDemonstrativoAb) {
            ((PainelDemonstrativoAb)painel).atualizarLista();
        }
    }

    public static void tratarException(Exception pExcecao) {
        if (pExcecao instanceof AplicacaoException) {
            GuiUtil.mostrarErro(pExcecao);
        } else if (pExcecao instanceof HashInvalidoException) {
            HashInvalidoException ex = (HashInvalidoException)pExcecao;
            FabricaUtilitarios.printStackEmDesenvolvimento((Exception)pExcecao);
            int result = JOptionPane.showConfirmDialog(null, "Foi detectado que o arquivo desta declara\u00e7\u00e3o est\u00e1 corrompido. \nGostaria que o sistema restaurasse um backup deste arquivo?", "Erro ao Abrir", 0, 0);
            if (result == 0) {
                try {
                    IRPFFacade.getInstancia().restaurarBackup(ex.getPathArquivo());
                    JOptionPane.showMessageDialog(null, "Declara\u00e7\u00e3o restaurada do backup com sucesso.", "Backup Restaurado", 1, null);
                }
                catch (BackupInexistenteException e) {
                    JOptionPane.showMessageDialog(null, "Ocorreu um erro ao restaurar o backup. \nN\u00e3o foi poss\u00edvel localizar o arquivo de backup em: " + e.getArquivoBkp(), "Erro ao Restaurar Backup", 0, null);
                }
            }
        } else {
            LogPPGD.erro((String)("Erro n\u00e3o Tratado: " + pExcecao));
        }
    }

    public static void desabilitarTela(Container cont) {
        Component[] components = cont.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (components[i] instanceof ButtonFicha2) continue;
            if (components[i] instanceof JEditCampo) {
                JEditCampo edt = (JEditCampo)components[i];
                MouseListener[] info = edt.getInformacao();
                String conteudo = info.formatado();
                if (components[i] instanceof JEditCodigo || components[i] instanceof JAutoCompleteEditCPF || components[i] instanceof JAutoCompleteEditCodigo || components[i] instanceof JEditInteiro) {
                    if (info instanceof Codigo) {
                        conteudo = ((Codigo)info).getDescricaoDefault();
                    }
                    JComponent cbo = edt.getComponenteFoco();
                    cbo.setEnabled(false);
                    cbo.setVisible(false);
                    JEditAlfa alfa = new JEditAlfa();
                    alfa.remove(1);
                    alfa.getInformacao().setConteudo(conteudo);
                    alfa.getInformacao().setReadOnly(true);
                    alfa.getComponenteFoco().getAccessibleContext().setAccessibleName(edt.getComponenteFoco().getAccessibleContext().getAccessibleName());
                    edt.add((Component)alfa, (Object)"Center");
                } else if (components[i] instanceof JButtonGroupPanel) {
                    JButtonGroupPanel grp = (JButtonGroupPanel)components[i];
                    Enumeration<AbstractButton> buttons = grp.getGroup().getElements();
                    while (buttons.hasMoreElements()) {
                        AbstractButton button = buttons.nextElement();
                        if (!(button instanceof JRadioButton)) continue;
                        button.setEnabled(button.isSelected());
                        button.setVisible(button.isSelected());
                    }
                } else if (components[i] instanceof JEditLogico) {
                    JEditLogico logico = (JEditLogico)components[i];
                    for (JRadioButton rdb : logico.getRadios().values()) {
                        rdb.setEnabled(rdb.isSelected());
                        rdb.setVisible(rdb.isSelected());
                    }
                } else {
                    info.setReadOnly(true);
                }
                System.out.println("\n" + edt + "\n" + edt.getComponenteFoco().getAccessibleContext().getAccessibleName() + ": " + conteudo);
                continue;
            }
            if (components[i] instanceof JCheckBox) {
                JCheckBox chk = (JCheckBox)components[i];
                for (MouseListener listener : chk.getMouseListeners()) {
                    chk.removeMouseListener(listener);
                }
                InputMap im = SwingUtilities.getUIInputMap(chk, 0);
                im.put(KeyStroke.getKeyStroke(32, 0), null);
                continue;
            }
            if (components[i] instanceof JButton) {
                JButton button = (JButton)components[i];
                if (button.getActionCommand().toUpperCase().equals("EDITAR")) {
                    String command = button.getActionCommand();
                    button.setText("Visualizar");
                    button.setMnemonic('V');
                    button.setToolTipText("Visualizar");
                    button.setActionCommand(command);
                }
                if (button.getActionCommand().toUpperCase().equals("EDITAR") || button.getActionCommand().toUpperCase().equals("FECHAR") || button.getActionCommand().toUpperCase().equals("AJUDA") || button.getActionCommand().toUpperCase().equals("CANCELAR") || button.getActionCommand().toUpperCase().equals("OK")) continue;
                components[i].setEnabled(false);
                continue;
            }
            if (!(components[i] instanceof Container)) continue;
            ControladorGui.desabilitarTela((Container)components[i]);
        }
    }

    public static boolean acionarPainel(String pPainelStr) {
        boolean lTrocouPainel = false;
        try {
            JPanel painelAcionado = PainelCacher.getInstancia().obtemUrgentemente(pPainelStr);
            if (painelAcionado == null) {
                Class<?> c = Class.forName(pPainelStr);
                painelAcionado = (JPanel)c.newInstance();
            }
            lTrocouPainel = ControladorGui.acionarPainel((PainelDemonstrativoIf)((Object)painelAcionado));
        }
        catch (Exception ex) {
            ControladorGui.tratarException(ex);
        }
        return lTrocouPainel;
    }

    public static boolean acionarPainel(PainelDemonstrativoIf pPainelAcionado) {
        PainelDemonstrativoIf painelAtual = ControladorGui.getPainelAtualmenteExibido();
        GuiUtil.adicionarEnterComoTeclaDeNavegacao((JPanel)((Object)pPainelAcionado));
        if (painelAtual == null) {
            try {
                ControladorGui.alterarPainel(pPainelAcionado);
                return true;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                ControladorGui.tratarException(ex);
            }
        } else if (!ControladorGui.getPainelAtualmenteExibido().getClass().isAssignableFrom(pPainelAcionado.getClass()) && painelAtual.isPodeSair()) {
            try {
                if (pPainelAcionado instanceof PainelPrincipalAb) {
                    PainelPrincipalAb painelPrincipal = (PainelPrincipalAb)pPainelAcionado;
                    IRPFTableModelAb gcapTableModel = (IRPFTableModelAb)painelPrincipal.getTabela().getModel();
                    gcapTableModel.refresh();
                }
                ControladorGui.alterarPainel(pPainelAcionado);
                return true;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                ControladorGui.tratarException(ex);
            }
        }
        return false;
    }

    private static void alterarPainel(PainelDemonstrativoIf pPainelAcionado) throws Exception {
        pPainelAcionado.preExibir();
        PainelContainer lPainelBasico = ControladorGui.obterPainelContainer();
        ControladorGui.salvarDemonstrativoAberto();
        ImageIcon lImagem = pPainelAcionado.getImagemTitulo();
        if (lImagem != null) {
            lPainelBasico.setImagem(lImagem);
        }
        lPainelBasico.mudaCorpoPainelPrincipal(pPainelAcionado);
        ControladorGui.setPainelAtualmenteExibido(pPainelAcionado);
        PlataformaPPGD.getPlataforma().mudaPainelExibido((JPanel)lPainelBasico);
        JComponent lComponent = pPainelAcionado.getDefaultFocus();
        if (lComponent != null && IRPFUtil.getEstadoSistema() != 1) {
            lComponent.requestFocusInWindow();
        }
        pPainelAcionado.posExibir();
        if (pPainelAcionado instanceof PainelDemonstrativoAb) {
            ((PainelDemonstrativoAb)pPainelAcionado).registrarCacheCampoNI();
        }
        if (pPainelAcionado instanceof IRPFBemVindos) {
            ControladorGui.setReadOnlyMode(false);
        } else if (pPainelAcionado instanceof Container && ControladorGui.isReadOnly()) {
            ControladorGui.desabilitarTela((Container)((Object)pPainelAcionado));
        }
    }

    public static PainelContainer obterPainelContainer() {
        return (PainelContainer)PainelCacher.getInstancia().obtemUrgentemente(PainelContainer.class.getName());
    }

    public static JanelaPrincipalIRPF getJanelaPrincipal() {
        return (JanelaPrincipalIRPF)PlataformaPPGD.getPlataforma().getJanelaPrincipal();
    }

    public static void fecharDemonstrativo() {
        try {
            if (ControladorGui.isDemonstrativoAberto()) {
                if (ControladorGui.dispatchDemonstrativoVaiFechar()) {
                    DeclaracaoIRPF lDemonstrativoAberto = ControladorGui.getDemonstrativoAberto();
                    IRPFFacade.getInstancia().salvarDeclaracao(lDemonstrativoAberto);
                    IRPFFacade.getInstancia().fazerBackup(IRPFFacade.getInstancia().getIdDeclaracaoAberto());
                    lDemonstrativoAberto.removeObservadores(new Class[]{JPanel.class});
                    ControladorGui.removeListeners();
                    PainelCacher.getInstancia().encerra();
                    ControladorGui.setPainelAtualmenteExibido(null);
                    ControladorGui.setDemonstrativoAberto(null);
                    ControladorGui.getJanelaPrincipal().fechaTodasAbas();
                    MapeamentoInformacaoEditCampo.limpaAssociacoes();
                    IRPFFacade.limpaCacheDeclaracoes();
                    ControladorGui.dispatchDemonstrativoFechado();
                    CacheNI.getInstancia().salvar();
                    System.gc();
                    IRPFBemVindos painelBemVindos = (IRPFBemVindos)PainelCacher.getInstancia().obtemUrgentemente(NavegacaoIf.PAINEL_BEM_VINDOS);
                    ControladorGui.removeDemonstrativoListener(painelBemVindos);
                    ControladorGui.addDemonstrativoListener(painelBemVindos);
                    ControladorGui.acionarPainel(painelBemVindos);
                }
                ControladorGui.setReadOnlyMode(false);
            }
        }
        catch (Exception e) {
            ControladorGui.tratarException(e);
        }
    }

    private static void removeListeners() {
        PainelContainer painelContainer = ControladorGui.obterPainelContainer();
        ControladorGui.removeMensagemFichaListener(painelContainer);
        ControladorGui.removeHelpListener(painelContainer);
        ControladorGui.removeDemonstrativoListener(painelContainer.getHoraSalvamentoPanel1());
        ControladorGui.removeFavoritoListener(ControladorGui.getJanelaPrincipal());
    }

    public static void retificarDeclaracaoTransmitida(IdentificadorDeclaracao pId, String numRecibo) {
        if (pId.getTpTransmitida().naoFormatado().equals("10") || pId.getTpTransmitida().naoFormatado().equals("11") || pId.getTpTransmitida().naoFormatado().equals("12")) {
            String mensagemTpTransmitida = CadastroTabelasIRPF.recuperarMensagem((CodigoTabelaMensagens)CodigoTabelaMensagens.CODIGO_00519);
            if (mensagemTpTransmitida.isEmpty()) {
                mensagemTpTransmitida = "A declara\u00e7\u00e3o anterior foi transmitida pelo MIR. Se voc\u00ea prosseguir com a retifica\u00e7\u00e3o, haver\u00e1 perda de dados.";
            }
            GuiUtil.mostrarAviso(mensagemTpTransmitida);
        }
        boolean retificar = false;
        if (IRPFFacade.existeDeclaracaoEmPreenchimento((String)pId.getCpf().naoFormatado())) {
            pId.getNumReciboTransmitido().setConteudo("0000000000");
            ArrayList<IdentificadorDeclaracao> idsExcluir = new ArrayList<IdentificadorDeclaracao>();
            idsExcluir.add(pId);
            ControladorGui.excluirDemonstrativo(idsExcluir);
            retificar = true;
        } else {
            pId.getNumReciboTransmitido().setConteudo("0000000000");
            retificar = true;
        }
        if (retificar) {
            try {
                DeclaracaoIRPF dec = new ImportadorTxt().restaurarDeclaracao(new File(IRPFUtil.obterNomeCompletoArquivoTransmitido((IdentificadorDeclaracao)pId)), false);
                dec.getContribuinte().getDeclaracaoRetificadora().setConteudo(Logico.SIM);
                dec.getContribuinte().getNumReciboDecRetif().setConteudo(numRecibo);
                dec.getIdentificadorDeclaracao().getDataCriacao().clear();
                ControladorGui.salvarDemonstrativo(dec);
                IRPFFacade.limpaCacheDeclaracoes();
                ControladorGui.abrirDemonstrativo(pId, false);
            }
            catch (IOException | GeracaoTxtException ex) {
                GuiUtil.mostrarErro("falha_importar_dec_para_retificar");
                LogPPGD.erro((String)ex.getMessage());
            }
            catch (Exception ex) {
                GuiUtil.mostrarErro("falha_informar_recibo_dec_retificadora");
                LogPPGD.erro((String)ex.getMessage());
            }
        }
    }

    public static void abrirDemonstrativo(IdentificadorDeclaracao pId, boolean pExecutaProcessoSwing) throws HashInvalidoException {
        if (pExecutaProcessoSwing) {
            try {
                GuiUtil.executarTarefa("Abrir Declara\u00e7\u00e3o", 300, () -> {
                    ControladorGui.abrirDemonstrativo(pId);
                    return null;
                });
            }
            catch (HashInvalidoException e) {
                throw e;
            }
            catch (Exception e) {
                LogPPGD.erro((String)("Erro ao abrir Declara\u00e7\u00e3o: " + e));
            }
        } else {
            ControladorGui.abrirDemonstrativo(pId);
        }
    }

    public static void abrirDemonstrativo(final DeclaracaoIRPF pDec, boolean pExecutaProcessoSwing) {
        if (pExecutaProcessoSwing) {
            ProcessoSwing.executarTarefa(new Tarefa(){

                @Override
                public Object definirTarefa() {
                    ControladorGui.abrirDemonstrativo(pDec);
                    return null;
                }
            });
        } else {
            ControladorGui.abrirDemonstrativo(pDec);
        }
    }

    private static void abrirDemonstrativo(IdentificadorDeclaracao pId) throws HashInvalidoException {
        try {
            IRPFUtil.setEstadoSistema((int)3);
            if (!pId.getNumReciboTransmitido().naoFormatado().equals("0000000000")) {
                ControladorGui.setReadOnlyMode(true);
                AbrirCalculadoraAction.fecharCalculadora();
            }
            PainelContainer pc = ControladorGui.obterPainelContainer();
            ControladorGui.addDemonstrativoListener(pc.getHoraSalvamentoPanel1());
            ControladorGui.addCabecalhoFichaListener(pc);
            ControladorGui.addMensagemFichaListener(pc);
            ControladorGui.addHelpListener(pc);
            ControladorGui.addFavoritoListener(ControladorGui.getJanelaPrincipal());
            IRPFBemVindos painelBemVindos = (IRPFBemVindos)PainelCacher.getInstancia().obtemUrgentemente(NavegacaoIf.PAINEL_BEM_VINDOS);
            ControladorGui.removeDemonstrativoListener(painelBemVindos);
            if (!pId.getNumReciboTransmitido().naoFormatado().equals("0000000000")) {
                boolean existe = IRPFFacade.existeDeclaracaoEmPreenchimento((String)pId.getCpf().naoFormatado());
                DeclaracaoIRPF decModelo = new ImportadorTxt().restaurarDeclaracao(new File(IRPFUtil.obterNomeCompletoArquivoTransmitido((IdentificadorDeclaracao)pId)), false);
                IRPFFacade.abreDeclaracao((IdentificadorDeclaracao)pId);
                IRPFFacade.getInstancia().getBens().corrigirCorrupcaoRenavam(IRPFFacade.getInstancia().getDeclaracao(), decModelo);
                if (!existe) {
                    IRPFFacade.excluirDeclaracao((String)pId.getCpf().naoFormatado(), (String)"0000000000");
                }
            } else {
                IRPFFacade.abreDeclaracao((IdentificadorDeclaracao)pId);
            }
            PlataformaPPGD.getPlataforma().getJanelaPrincipal().setEnabled(false);
            IdentificadorDeclaracao idDeclaracao = IRPFFacade.getInstancia().getIdDeclaracaoAberto();
            if (idDeclaracao.getExercicio().isVazio()) {
                idDeclaracao.getExercicio().setConteudo(ConstantesGlobais.EXERCICIO);
            }
            if (idDeclaracao.getTipoDeclaracao().isVazio()) {
                if (idDeclaracao.isCompleta()) {
                    idDeclaracao.getTipoDeclaracao().setConteudo("0");
                } else {
                    idDeclaracao.getTipoDeclaracao().setConteudo("1");
                }
            }
            ControladorGui.setDemonstrativoAberto(IRPFFacade.getInstancia().getDeclaracao());
            CacheNI.getInstancia().importarNIs((ObjetoNegocio)IRPFFacade.getInstancia().getDeclaracao(), false);
            ControladorGui.getDemonstrativoAberto().limparTrabalhoNaoAssalariadoSemLancamento();
            ControladorGui.getJanelaPrincipal().exibeDashboard();
            ControladorGui.dispatchDemonstrativoAberto();
            PlataformaPPGD.getPlataforma().getJanelaPrincipal().setEnabled(true);
            UsuarioLogado usuarioGovBr = BarramentoIRPFService.getUsuarioLogado();
            if (usuarioGovBr != null) {
                IRPFFacade.getInstancia().getDeclaracao().getUtlimoCPFAutenticado().setConteudo(usuarioGovBr.getCpf());
            }
            IRPFFacade.getInstancia().getDeclaracao().getPagamentos().verificarLegadoPagamentos();
            Map chavesRepetidas = IRPFFacade.getInstancia().getDeclaracao().getBens().obterListaChavesRepetidas();
            if (chavesRepetidas != null) {
                IRPFFacade.getInstancia().getDeclaracao().atualizarIndicesBens(chavesRepetidas);
            }
            IRPFUtil.setEstadoSistema((int)0);
        }
        catch (HashInvalidoException e) {
            throw e;
        }
        catch (Exception e) {
            ControladorGui.tratarException(e);
        }
    }

    private static void abrirDemonstrativo(DeclaracaoIRPF pDec) {
        try {
            PainelContainer pc = ControladorGui.obterPainelContainer();
            ControladorGui.addDemonstrativoListener(pc.getHoraSalvamentoPanel1());
            ControladorGui.addMensagemFichaListener(pc);
            ControladorGui.addHelpListener(pc);
            IRPFBemVindos painelBemVindos = (IRPFBemVindos)PainelCacher.getInstancia().obtemUrgentemente(NavegacaoIf.PAINEL_BEM_VINDOS);
            ControladorGui.removeDemonstrativoListener(painelBemVindos);
            PlataformaPPGD.getPlataforma().getJanelaPrincipal().setEnabled(false);
            IRPFFacade.abreDeclaracao((DeclaracaoIRPF)pDec);
            ControladorGui.setDemonstrativoAberto(pDec);
            ControladorGui.getDemonstrativoAberto().limparTrabalhoNaoAssalariadoSemLancamento();
            ControladorGui.getJanelaPrincipal().exibeDashboard();
            ControladorGui.dispatchDemonstrativoAberto();
            PlataformaPPGD.getPlataforma().getJanelaPrincipal().setEnabled(true);
        }
        catch (Exception e) {
            ControladorGui.tratarException(e);
        }
    }

    public static boolean isDemonstrativoAberto() {
        return ControladorGui.getDemonstrativoAberto() != null;
    }

    public static void salvarDemonstrativoAberto() throws Exception {
        DeclaracaoIRPF dec = ControladorGui.getDemonstrativoAberto();
        if (dec != null) {
            ControladorGui.salvarDemonstrativo(dec);
        }
    }

    public static void salvarDemonstrativo(DeclaracaoIRPF dec) throws Exception {
        IRPFFacade.getInstancia().salvarDeclaracao(dec);
        ControladorGui.dispatchDemonstrativoSalvo();
        ControladorGui.dispatchMudouNumeroDemonstrativos();
    }

    public static void excluirDemonstrativo(List<IdentificadorDeclaracao> pIds) {
        ControladorGui.excluirDemonstrativo(pIds, false);
    }

    public static void excluirDemonstrativo(List<IdentificadorDeclaracao> pIds, boolean heTransmitida) {
        try {
            for (IdentificadorDeclaracao identificadorDeclaracao : pIds) {
                IRPFFacade.excluirDeclaracao((IdentificadorDeclaracao)identificadorDeclaracao);
                if (!heTransmitida) continue;
                ControladorGui.excluirDeclaracaoGravada(identificadorDeclaracao);
                ControladorGui.excluirDeclaracaoTransmitida(identificadorDeclaracao);
            }
            ControladorGui.dispatchMudouNumeroDemonstrativos();
        }
        catch (Exception e) {
            ControladorGui.tratarException(e);
        }
    }

    public static void excluirDeclaracaoGravada(IdentificadorDeclaracao identificadorDeclaracao) {
        String nomeDEC = IRPFUtil.obterNomeCompletoArquivoGravado((IdentificadorDeclaracao)identificadorDeclaracao);
        String nomeREC = nomeDEC.substring(0, nomeDEC.length() - 3) + "REC";
        try {
            FileUtils.forceDelete((File)new File(nomeDEC));
        }
        catch (IOException ex) {
            LogPPGD.erro((String)ex.getMessage());
        }
        try {
            FileUtils.forceDelete((File)new File(nomeREC));
        }
        catch (IOException ex) {
            LogPPGD.erro((String)ex.getMessage());
        }
    }

    public static void excluirDeclaracaoTransmitida(IdentificadorDeclaracao identificadorDeclaracao) {
        String nomeDEC = IRPFUtil.obterNomeCompletoArquivoTransmitido((IdentificadorDeclaracao)identificadorDeclaracao);
        String nomeREC = nomeDEC.substring(0, nomeDEC.length() - 3) + "REC";
        try {
            FileUtils.forceDelete((File)new File(nomeDEC));
        }
        catch (IOException ex) {
            LogPPGD.erro((String)ex.getMessage());
        }
        try {
            FileUtils.forceDelete((File)new File(nomeREC));
        }
        catch (IOException ex) {
            LogPPGD.erro((String)ex.getMessage());
        }
    }

    public static boolean existemDemonstrativos() {
        try {
            return IRPFFacade.getInstancia().existeDeclaracoes();
        }
        catch (Exception e) {
            ControladorGui.tratarException(e);
            return false;
        }
    }

    public static void alterarOpcaoTributacao(ActionEvent evt, DeclaracaoIRPF dec) {
        try {
            ConverterDeclaracaoAction cd = dec == null ? new ConverterDeclaracaoAction() : new ConverterDeclaracaoAction(dec);
            cd.actionPerformed(evt);
            ControladorGui.dispatchAlterouOpcaoTributacao(dec);
        }
        catch (Exception e) {
            ControladorGui.tratarException(e);
        }
    }

    public static void alterarCabecalhoFicha(String novoTextoCabecalho) {
        try {
            ControladorGui.dispatchMudouCabecalho(novoTextoCabecalho);
        }
        catch (Exception e) {
            ControladorGui.tratarException(e);
        }
    }

    public static void atualizarSubtitulo(String subtitulo) {
        ControladorGui.obterPainelContainer().subtituloAlterado(subtitulo);
    }

    public static void alterarMensagemFicha(String novaMensagem) {
        try {
            ControladorGui.dispatchMudouMensagem(novaMensagem);
        }
        catch (Exception e) {
            ControladorGui.tratarException(e);
        }
    }

    public static void alterarHelpId(String novoHelpId) {
        try {
            ControladorGui.dispatchMudouHelpId(novoHelpId);
        }
        catch (Exception e) {
            ControladorGui.tratarException(e);
        }
    }

    public static void atualizarNumeroDemonstrativos() {
        try {
            ControladorGui.dispatchMudouNumeroDemonstrativos();
        }
        catch (Exception e) {
            ControladorGui.tratarException(e);
        }
    }

    public static void iniciarGravacaoDemonstrativo() {
        try {
            ControladorGui.dispatchDemonstrativoVaiGravar();
        }
        catch (Exception e) {
            ControladorGui.tratarException(e);
        }
    }

    public static void terminarGravacaoDemonstrativo() {
        try {
            ControladorGui.dispatchDemonstrativoGravado();
        }
        catch (Exception e) {
            ControladorGui.tratarException(e);
        }
    }

    public static void recalcularNumeroFavoritos(FavoritoEvent event) {
        try {
            ControladorGui.dispatchMudouNumeroFavoritos(event);
        }
        catch (Exception e) {
            ControladorGui.tratarException(e);
        }
    }

    public static void repaintTelaBemVindos() {
        try {
            if (ControladorGui.getPainelAtualmenteExibido() instanceof IRPFBemVindos) {
                IRPFBemVindos tela = (IRPFBemVindos)ControladorGui.getPainelAtualmenteExibido();
                tela.repaintPaineis();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void exibirPainelTestes(Data dataOriginal, String nomeCampo) {
        if (ConstantesGlobaisIRPF.VERSAO_TESTES) {
            String data = "01/04/" + ConstantesGlobais.EXERCICIO;
            if (ControladorGui.isForaPrazoHOM()) {
                data = "01/07/" + ConstantesGlobais.EXERCICIO;
            }
            SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
            df.setLenient(false);
            if (data != null) {
                try {
                    dataOriginal.setConteudo(df.parse(data));
                }
                catch (ParseException e) {
                    GuiUtil.mostrarErro(null, "Data inv\u00e1lida : " + data);
                    ControladorGui.exibirPainelTestes(dataOriginal, nomeCampo);
                }
            }
        }
    }

    private static long diferencaEmSegundos(Date dataIni, Date dataFim) {
        Calendar date = Calendar.getInstance();
        date.setTime(dataIni);
        Calendar now = Calendar.getInstance();
        now.setTime(dataFim);
        long differenceInMillis = now.getTimeInMillis() - date.getTimeInMillis();
        long differenceInSeconds = differenceInMillis / 1000L;
        return differenceInSeconds;
    }

    public static Date dataAtual() throws AplicacaoException {
        boolean permiteConsulta;
        int segundosEntreConsultas = 5;
        boolean bl = permiteConsulta = dataConsultaDataAtual == null || ControladorGui.diferencaEmSegundos(dataConsultaDataAtual, new Date()) > (long)segundosEntreConsultas;
        if (permiteConsulta) {
            try {
                dataServidor = GuiUtil.executarTarefa("Obtendo data atual...", 5, BarramentoIRPFService::obterDataServidor);
                dataConsultaDataAtual = new Date();
            }
            catch (Exception e) {
                LogPPGD.erro((String)e.toString());
                throw new AplicacaoException("N\u00e3o foi poss\u00edvel executar esta funcionalidade. Verifique sua conex\u00e3o com a Internet e tente mais tarde.", (Throwable)e, false);
            }
        }
        return dataServidor;
    }

    public static boolean emFaseEntrega(boolean emCalamidade) throws AplicacaoException {
        int segundosEntreConsultas = 20;
        if (ConstantesGlobaisIRPF.VERSAO_TESTES) {
            segundosEntreConsultas = 3;
        }
        boolean permiteConsulta = dataConsultaDataAtual == null || ControladorGui.diferencaEmSegundos(dataConsultaDataAtual, new Date()) > (long)segundosEntreConsultas;
        Data dataAtualFormatada = new Data();
        if (permiteConsulta) {
            try {
                dataServidor = (Date)ProcessoSwing.executarTarefa(new Tarefa(){

                    @Override
                    public Object definirTarefa() {
                        try {
                            return BarramentoIRPFService.obterDataServidor();
                        }
                        catch (BarramentoException ex) {
                            return null;
                        }
                    }
                });
                if (dataServidor == null) {
                    throw new Exception();
                }
                dataConsultaDataAtual = new Date();
                dataAtualFormatada.setConteudo(dataServidor);
                ControladorGui.exibirPainelTestes(dataAtualFormatada, "Data Confi\u00e1vel (Para Verifica\u00e7\u00e3o de Fase de Entrega)");
                dataServidor = dataAtualFormatada.asDate();
            }
            catch (Exception e) {
                LogPPGD.erro((String)e.toString());
                throw new AplicacaoException("N\u00e3o foi poss\u00edvel executar esta funcionalidade. Verifique sua conex\u00e3o com a Internet e tente mais tarde.", (Throwable)e, false);
            }
        } else {
            dataAtualFormatada.setConteudo(dataServidor);
        }
        Data dataFimEntrega = new Data();
        if (emCalamidade) {
            dataFimEntrega.setConteudo(TabelaDatasIRPF.ConstantesDatas.dataFimRecepcaoCalamidade.getDataFormatada());
        } else {
            dataFimEntrega.setConteudo(TabelaDatasIRPF.ConstantesDatas.dataFimRecepcao.getDataFormatada());
        }
        return !dataAtualFormatada.maisNova(dataFimEntrega);
    }

    public static boolean isForaPrazoHOM() {
        return foraPrazoHOM;
    }

    public static void setForaPrazoHOM(boolean aForaPrazoHOM) {
        foraPrazoHOM = aForaPrazoHOM;
    }

    public static class ListenerList<E> {
        private final ArrayList<WeakReference<E>> list = new ArrayList();

        public void add(E e) {
            this.list.add(new WeakReference<E>(e));
        }

        public boolean remove(Object o) {
            return this.list.removeIf(e -> e == null || e.get() == null || Objects.equals(e.get(), o));
        }

        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        public List<E> list() {
            return this.list.stream().filter(e -> e != null && e.get() != null).map(e -> e.get()).collect(Collectors.toList());
        }
    }
}

