/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.app.acoes;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import serpro.ppgd.app.acoes.ActionAb;
import serpro.ppgd.app.acoes.LoginGovAction;
import serpro.ppgd.formatosexternos.txt.excecao.GeracaoTxtException;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.exception.AplicacaoException;
import serpro.ppgd.irpf.exception.BarramentoException;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.update.PainelDownloadAtualizacoes;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.nuvem.BarramentoIRPFService;
import serpro.ppgd.irpf.nuvem.BarramentoIRPFUtil;
import serpro.ppgd.irpf.nuvem.UsuarioLogado;
import serpro.ppgd.irpf.txt.gravacaorestauracao.GravadorTXT;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.Pendencia;
import serpro.ppgd.negocio.util.FabricaUtilitarios;

public class SalvarOnlineAction
extends ActionAb {
    private static final long serialVersionUID = 1L;
    private static final Integer LIMITE_DEPENDENTES = 100;
    private static final Integer LIMITE_ALIMENTANDOS = 100;
    private static final Integer LIMITE_RENDIMENTOS = 100;
    private static final Integer LIMITE_PAGAMENTOS = 100;

    @Override
    public void executarAcao(ActionEvent actionEvent) {
        try {
            this.verificarPossibilidadeSalvarOnline();
            this.gerarIndicativoPendencias();
            this.executarSalvarDecOnline();
        }
        catch (AplicacaoException e) {
            GuiUtil.mostrarErro(e);
        }
    }

    public void executarSalvarDecOnline() {
        UsuarioLogado usuarioGov = BarramentoIRPFService.getUsuarioLogado();
        if (usuarioGov == null) {
            try {
                new LoginGovAction().iniciarLogon(this::executarSalvarDecOnline);
                usuarioGov = BarramentoIRPFService.getUsuarioLogado();
            }
            catch (AplicacaoException e) {
                GuiUtil.mostrarErro(ControladorGui.getJanelaPrincipal(), e.getMessage());
                return;
            }
        } else {
            this.executarSalvarDecOnline(usuarioGov);
        }
    }

    public void executarSalvarDecOnline(UsuarioLogado usuarioGov) {
        final PainelDownloadAtualizacoes painelDownload = new PainelDownloadAtualizacoes("Salvando Declara\u00e7\u00e3o On-line", GuiUtil.getImage("/icones/png20px/icon_salvar_online_20x26.png"));
        painelDownload.getLblDescricao().setText("Salvando...");
        painelDownload.getLblPercentual().setText("");
        painelDownload.getProgressBar().setIndeterminate(true);
        final SwingWorker<String, Void> sw = new SwingWorker<String, Void>(){

            @Override
            protected String doInBackground() throws Exception {
                try {
                    SalvarOnlineAction.this.salvarDeclaracao();
                }
                catch (AplicacaoException | BarramentoException e) {
                    return e.getMessage();
                }
                return null;
            }

            @Override
            protected void done() {
                String msgErro;
                try {
                    msgErro = (String)this.get();
                }
                catch (InterruptedException | CancellationException e) {
                    msgErro = "Opera\u00e7\u00e3o cancelada.";
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                    msgErro = MensagemUtil.getMensagem((String)"nuvem.erro.inesperado");
                }
                finally {
                    GuiUtil.fecharDialog(painelDownload);
                }
                if (msgErro == null) {
                    GuiUtil.mostrarInfo("nuvem.info.declaracao.salva");
                } else {
                    GuiUtil.mostrarErro(GuiUtil.getParent(), msgErro);
                }
            }
        };
        painelDownload.getBtnCancelar().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                sw.cancel(true);
            }
        });
        SwingUtilities.invokeLater(() -> GuiUtil.exibeDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), painelDownload, true, "Salvar Declara\u00e7\u00e3o On-line", false, null, null, false, 2, false, true));
        sw.execute();
    }

    public void salvarDeclaracao() throws AplicacaoException, BarramentoException {
        String declaracaoCompactada;
        if (ControladorGui.isDemonstrativoAberto()) {
            declaracaoCompactada = null;
            try {
                declaracaoCompactada = BarramentoIRPFUtil.compactarDeclaracao((InputStream)GravadorTXT.criarArquivoPersistenciaOnline((DeclaracaoIRPF)ControladorGui.getDemonstrativoAberto()));
            }
            catch (IOException | GeracaoTxtException e) {
                e.printStackTrace();
                throw new AplicacaoException("nuvem.erro.salvar.online", e);
            }
        } else {
            throw new AplicacaoException("nuvem.erro.salvar.online");
        }
        BarramentoIRPFService.salvarDecOnline((String)declaracaoCompactada, (boolean)ControladorGui.getDemonstrativoAberto().getIdentificadorDeclaracao().isRetificadora(), (String)ConstantesGlobais.EXERCICIO, (String)ControladorGui.getDemonstrativoAberto().getIdentificadorDeclaracao().getCpf().naoFormatado());
    }

    private void verificarPossibilidadeSalvarOnline() throws AplicacaoException {
        DeclaracaoIRPF dec = ControladorGui.getDemonstrativoAberto();
        StringBuilder mensagem = this.validarTipoDeclaracao(dec);
        if (mensagem.length() > 0) {
            throw new AplicacaoException(mensagem.toString(), false);
        }
        mensagem.append((CharSequence)this.validarFichasCampos(dec));
        mensagem.append((CharSequence)this.validarLimites(dec));
        if (mensagem.length() > 0) {
            throw new AplicacaoException("nuvem.erro.salvar.fichas_invalidas", new String[]{mensagem.toString()});
        }
    }

    private StringBuilder validarTipoDeclaracao(DeclaracaoIRPF dec) {
        StringBuilder mensagem = new StringBuilder();
        if (dec.getIdentificadorDeclaracao().isEspolio()) {
            mensagem.append(MensagemUtil.getMensagem((String)"nuvem.erro.salvar.espolio"));
        } else if (dec.getIdentificadorDeclaracao().isSaida()) {
            mensagem.append(MensagemUtil.getMensagem((String)"nuvem.erro.salvar.saida"));
        } else if (dec.getContribuinte().getDataNascimento().isVazio()) {
            mensagem.append(MensagemUtil.getMensagem((String)"nuvem.erro.salvar.dataNascimento.vazia"));
        } else if (dec.getIdentificadorDeclaracao().getDeclaracaoRetificadora().isVazio()) {
            mensagem.append(MensagemUtil.getMensagem((String)"nuvem.erro.salvar.retificadora.vazia"));
        }
        return mensagem;
    }

    private StringBuilder validarFichasCampos(DeclaracaoIRPF dec) {
        StringBuilder mensagem = new StringBuilder();
        if (!dec.getRendPFTitular().getTotalExterior().isVazio() || !dec.getRendPFDependente().getTotalExterior().isVazio()) {
            mensagem.append(MensagemUtil.getMensagem((String)"nuvem.erro.salvar.ficha_invalida.exterior"));
        }
        if (!dec.getImpostoPago().getImpostoPagoExterior().isVazio()) {
            mensagem.append(MensagemUtil.getMensagem((String)"nuvem.erro.salvar.ficha_invalida.imposto_pago_exterior"));
        }
        if (!dec.getRendaVariavel().isVazio() || !dec.getRendaVariavelDependente().itens().isEmpty()) {
            mensagem.append("- Opera\u00e7\u00f5es Comuns / Day Trade em Renda Vari\u00e1vel\n");
        }
        if (!dec.getAtividadeRural().isVazio()) {
            mensagem.append("- Atividade Rural\n");
        }
        if (!dec.getGCAP().getIds().itens().isEmpty()) {
            mensagem.append("- Ganhos de Capital\n");
        }
        return mensagem;
    }

    private StringBuilder validarLimites(DeclaracaoIRPF dec) {
        StringBuilder mensagem = new StringBuilder();
        if (dec.getDependentes().itens().size() > LIMITE_DEPENDENTES) {
            mensagem.append(MensagemUtil.getMensagem((String)"nuvem.erro.salvar.limite_excedido.dependentes", (String[])new String[]{String.valueOf(LIMITE_DEPENDENTES)}));
        }
        if (dec.getAlimentandos().itens().size() > LIMITE_ALIMENTANDOS) {
            mensagem.append(MensagemUtil.getMensagem((String)"nuvem.erro.salvar.limite_excedido.alimentandos", (String[])new String[]{String.valueOf(LIMITE_ALIMENTANDOS)}));
        }
        if (dec.getRendPJ().getColecaoRendPJTitular().itens().size() + dec.getRendPJ().getColecaoRendPJDependente().itens().size() > LIMITE_RENDIMENTOS) {
            mensagem.append(MensagemUtil.getMensagem((String)"nuvem.erro.salvar.limite_excedido.rendimentos", (String[])new String[]{String.valueOf(LIMITE_RENDIMENTOS)}));
        }
        if (dec.getPagamentos().itens().size() > LIMITE_PAGAMENTOS) {
            mensagem.append(MensagemUtil.getMensagem((String)"nuvem.erro.salvar.limite_excedido.pagamentos", (String[])new String[]{String.valueOf(LIMITE_PAGAMENTOS)}));
        }
        return mensagem;
    }

    private void gerarIndicativoPendencias() {
        DeclaracaoIRPF dec = ControladorGui.getDemonstrativoAberto();
        List pendencias = FabricaUtilitarios.verificarPendencias((Object)dec);
        Iterator itPendencia = pendencias.iterator();
        while (itPendencia.hasNext()) {
            Pendencia p = (Pendencia)itPendencia.next();
            if ((p.getSeveridade() == 3 || p.getSeveridade() == 5) && !p.getCampoInformacao().getNomeCampo().equals("D\u00e9bito autom\u00e1tico") && !p.getCampoInformacao().getNomeCampo().equals("Banco")) continue;
            itPendencia.remove();
        }
        dec.getIdentificadorDeclaracao().getInPendencia().setConteudo(pendencias.isEmpty() ? Logico.NAO : Logico.SIM);
    }

    @Override
    public boolean isDesabilitadoVersaoBeta() {
        return true;
    }

    @Override
    public boolean isFecharDemonstrativoExigido() {
        return false;
    }

    @Override
    protected boolean podeExecutarEmReadOnly() {
        return false;
    }
}

