/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.app.acoes;

import java.awt.event.ActionEvent;
import java.io.IOException;
import serpro.ppgd.app.acoes.ActionAb;
import serpro.ppgd.app.acoes.LogoutGovAction;
import serpro.ppgd.cacheni.CacheNI;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.irpf.exception.AplicacaoException;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.nuvem.BarramentoIRPFService;
import serpro.ppgd.irpf.nuvem.UsuarioLogado;
import serpro.ppgd.irpf.util.IRPFUtil;
import serpro.ppgd.negocio.util.LogPPGD;

public class SairAction
extends ActionAb {
    private static final long serialVersionUID = 1L;
    private boolean mostrarConfirmacaoFecharPrograma = true;

    @Override
    public void executarAcao(ActionEvent e) {
        UsuarioLogado usuarioLogado = BarramentoIRPFService.getUsuarioLogado();
        if (!this.isMostrarConfirmacaoFecharPrograma() || GuiUtil.mostrarConfirma("ConfirmarFecharPrograma")) {
            try {
                ControladorGui.fecharDemonstrativo();
                if (!ControladorGui.isDemonstrativoAberto()) {
                    this.exitPgd(usuarioLogado != null);
                }
                IRPFUtil.deleteDir((String)IRPFUtil.DIR_TMP);
            }
            catch (Exception ex) {
                ControladorGui.tratarException(ex);
            }
        }
    }

    protected void exitPgd(boolean usuarioLogado) {
        if (usuarioLogado) {
            try {
                new LogoutGovAction().executarLogout();
            }
            catch (AplicacaoException e) {
                GuiUtil.mostrarErro(e);
            }
        }
        try {
            CacheNI.getInstancia().salvar();
        }
        catch (IOException e) {
            LogPPGD.erro((String)e.getMessage());
        }
        this.onExitPgd();
        PlataformaPPGD.getPlataforma().exitPgd();
    }

    protected void onExitPgd() {
    }

    public boolean isMostrarConfirmacaoFecharPrograma() {
        return this.mostrarConfirmacaoFecharPrograma;
    }

    public void setMostrarConfirmacaoFecharPrograma(boolean mostrarConfirmacaoFecharPrograma) {
        this.mostrarConfirmacaoFecharPrograma = mostrarConfirmacaoFecharPrograma;
    }
}

