/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.app.acoes;

import java.awt.event.ActionEvent;
import serpro.ppgd.app.acoes.ActionAb;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.exception.AplicacaoException;
import serpro.ppgd.irpf.exception.BarramentoException;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.dialogs.PainelImprimirDARFCodigoBarras;
import serpro.ppgd.irpf.gui.dialogs.PainelImprimirDARFCodigoBarrasDemonstrativoAberto;
import serpro.ppgd.irpf.gui.dialogs.PainelImprimirDARFEscolherCota;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.tabelas.TabelaAliquotasIRPF;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.util.FabricaUtilitarios;

public class ImprimirDarfCodBarrasAction
extends ActionAb {
    private static final long serialVersionUID = 1L;

    @Override
    public void executarAcao(ActionEvent e) {
        try {
            if (ControladorGui.isDemonstrativoAberto()) {
                DeclaracaoIRPF dec = ControladorGui.getDemonstrativoAberto();
                boolean fecharDeclaracao = Boolean.valueOf(FabricaUtilitarios.getProperties().getProperty("aplicacao.impressao.fechar.declaracao"));
                ControladorGui.salvarDemonstrativoAberto();
                PainelImprimirDARFCodigoBarrasDemonstrativoAberto painelImprimirDARFCodBarras = new PainelImprimirDARFCodigoBarrasDemonstrativoAberto(dec);
                GuiUtil.exibeDialog(painelImprimirDARFCodBarras, true, "Impress\u00e3o do Darf", false);
                if (!painelImprimirDARFCodBarras.isCancelou() && fecharDeclaracao) {
                    ControladorGui.fecharDemonstrativo();
                }
            } else {
                PainelImprimirDARFCodigoBarras painelImprimirDARFCodBarras = new PainelImprimirDARFCodigoBarras();
                GuiUtil.exibeDialog(painelImprimirDARFCodBarras, true, "Impress\u00e3o do Darf", false);
            }
        }
        catch (Exception pE) {
            ControladorGui.tratarException(pE);
        }
    }

    @Override
    public boolean isDesabilitadoVersaoBeta() {
        return true;
    }

    public static void imprimirDARF(DeclaracaoIRPF dec, int tipoOperacao) {
        Valor minimoQuota = new Valor();
        minimoQuota.append('+', TabelaAliquotasIRPF.ConstantesAliquotas.valorMinIAP.getValor());
        if (dec.getResumo().getCalculoImposto().getValorQuota().comparacao(">=", minimoQuota)) {
            String chaveErro = null;
            String dataVencimentoDFE = "";
            if (!dec.getIdentificadorDeclaracao().isEspolio()) {
                chaveErro = null;
            } else if (dec.getIdentificadorDeclaracao().isEspolio() && dec.getEspolio().podeImprimirDARFDFE()) {
                if (dec.getEspolio().isPartilhaSobrepartilhaJudicial()) {
                    try {
                        dataVencimentoDFE = dec.getEspolio().obterDataVencimentoDFE();
                    }
                    catch (Exception ex) {
                        BarramentoException exp;
                        if (ex instanceof BarramentoException && "406".equals((exp = (BarramentoException)ex).getCodigoRetorno())) {
                            chaveErro = "darf_data_vencimento_dfe_nao_cadastrada";
                        }
                        if (chaveErro == null) {
                            chaveErro = "darf_data_vencimento_dfe_com_erro";
                        }
                    }
                }
            } else {
                chaveErro = "darf_dfe_com_erro";
            }
            if (chaveErro == null) {
                try {
                    PainelImprimirDARFEscolherCota painelImprimirDARFEscolherCota = new PainelImprimirDARFEscolherCota(dec, tipoOperacao, dataVencimentoDFE);
                    GuiUtil.exibeDialog(painelImprimirDARFEscolherCota, true, "Impress\u00e3o de Darf", false);
                }
                catch (AplicacaoException e) {
                    ControladorGui.tratarException((Exception)((Object)e));
                }
            } else {
                GuiUtil.mostrarErroSemQuebraDeLinha(chaveErro);
            }
        } else {
            GuiUtil.mostrarInfo("darf_sem_info");
        }
    }
}

