/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.persistenciagenerica;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import serpro.ppgd.gui.DialogoOcupado;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.DeclaracaoComIdentificador;
import serpro.ppgd.negocio.IdentificadorDeclaracaoXML;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.util.UtilitariosArquivo;
import serpro.ppgd.persistenciagenerica.BackupInexistenteException;
import serpro.ppgd.persistenciagenerica.DefaultTagHandler;
import serpro.ppgd.persistenciagenerica.HashInvalidoException;
import serpro.ppgd.persistenciagenerica.RepositorioXMLDefault;
import serpro.ppgd.persistenciagenerica.RepositorioXMLListener;
import serpro.ppgd.persistenciagenerica.XMLSaxHandler;
import serpro.ppgd.repositorio.RepositorioException;
import serpro.ppgd.repositorio.repositorioXML.RepositorioXMLException;

public abstract class RepositorioXML {
    private ArrayList<RepositorioXMLListener> listeners = new ArrayList();
    private IdentificadorDeclaracaoXML identificadorDeclaracao = null;
    private DeclaracaoComIdentificador declaracao = null;
    private Colecao listaIdDeclaracoesCache = null;
    private boolean cacheIdDeclaracao = false;
    private RepositorioXMLDefault repositorioIds = new RepositorioXMLDefault();
    private RepositorioXMLDefault repositorioDeclaracoes = new RepositorioXMLDefault();

    public RepositorioXML() {
        this.carregaIdDeclaracoes();
    }

    protected abstract String obterPathDados();

    protected abstract String obterPathXmlIdsDeclaracoes();

    protected abstract Colecao criarListaIdDeclaracoes();

    protected abstract DeclaracaoComIdentificador instanciarDeclaracao(IdentificadorDeclaracaoXML var1);

    protected abstract IdentificadorDeclaracaoXML obterIdentificador(Colecao var1, String var2);

    protected abstract String obterNumeroIdentificacao(IdentificadorDeclaracaoXML var1);

    protected abstract boolean existeDeclaracao(IdentificadorDeclaracaoXML var1);

    protected abstract void removerIdentificador(Colecao var1, IdentificadorDeclaracaoXML var2);

    protected abstract void copiaIdentificador(IdentificadorDeclaracaoXML var1, IdentificadorDeclaracaoXML var2);

    protected abstract void antesDeSalvar(DeclaracaoComIdentificador var1);

    protected abstract DefaultTagHandler obterTagHandler();

    protected abstract void parseXml(Colecao var1, SAXParser var2, DefaultTagHandler var3, XMLSaxHandler var4, File[] var5);

    protected abstract String obterExpressaoRegularNomePasta();

    private Colecao carregaIdDeclaracoes() {
        if (PlataformaPPGD.isEmDesign()) {
            return this.criarListaIdDeclaracoes();
        }
        try {
            this.testaDiretorioDados();
            this.listaIdDeclaracoesCache = this.criarListaIdDeclaracoes();
            this.repositorioIds.preencheObjeto((ObjetoNegocio)this.listaIdDeclaracoesCache, this.obterPathXmlIdsDeclaracoes(), true);
            return this.listaIdDeclaracoesCache;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void fireRecuperouDeclaracao(DeclaracaoComIdentificador dec) {
        for (RepositorioXMLListener listener : this.listeners) {
            listener.recuperouDeclaracao(dec);
        }
    }

    private void fireAbriuDeclaracao(DeclaracaoComIdentificador dec) {
        for (RepositorioXMLListener listener : this.listeners) {
            listener.abriuDeclaracao(dec);
        }
    }

    private void fireCriouDeclaracao(DeclaracaoComIdentificador dec) {
        for (RepositorioXMLListener listener : this.listeners) {
            listener.criouDeclaracao(dec);
        }
    }

    public void addRepositorioXMLListener(RepositorioXMLListener aListener) {
        this.listeners.add(aListener);
    }

    public ArrayList<RepositorioXMLListener> getListeners() {
        return this.listeners;
    }

    public void testaDiretorioDados() {
        String diretorioDadosApp = this.obterPathDados();
        File flDados = new File(diretorioDadosApp);
        if (!flDados.exists()) {
            flDados.mkdirs();
        }
    }

    protected void removerIdentificadores(Colecao colecaoIdentificadores, List<IdentificadorDeclaracaoXML> listaIdentificadoresDeclaracao) {
        for (IdentificadorDeclaracaoXML idDec : listaIdentificadoresDeclaracao) {
            this.removerIdentificador(colecaoIdentificadores, idDec);
        }
    }

    public DeclaracaoComIdentificador recuperarDeclaracao(String numeroIdentificacao) throws RepositorioXMLException, HashInvalidoException {
        IdentificadorDeclaracaoXML idAtual = this.obterIdentificador(this.getListaIdDeclaracoes(), numeroIdentificacao);
        DeclaracaoComIdentificador dec = null;
        if (this.repositorioDeclaracoes.temObjetoNegocioEmCache(idAtual.getPathArquivo())) {
            dec = (DeclaracaoComIdentificador)this.repositorioDeclaracoes.getObjeto(idAtual.getPathArquivo());
        } else {
            dec = this.instanciarDeclaracao(idAtual);
            if (this.repositorioDeclaracoes.preencheObjeto((ObjetoNegocio)dec, idAtual.getPathArquivo(), false) == null) {
                throw new RepositorioXMLException("A declara\u00e7\u00e3o solicitada nao existe");
            }
            this.fireRecuperouDeclaracao(dec);
        }
        return dec;
    }

    public void verificaIdDeclaracoes() {
        Colecao colIds = this.getListaIdDeclaracoes();
        this.testaDiretorioDados();
        String[] decs = null;
        try {
            File dados = new File(this.obterPathDados());
            decs = dados.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    boolean ret = name.matches(RepositorioXML.this.obterExpressaoRegularNomePasta());
                    return ret;
                }
            });
        }
        catch (Exception e) {
            return;
        }
        if (colIds == null || decs != null && colIds.recuperarLista().size() != decs.length) {
            this.restaurarListaIdDeclaracoes(colIds, decs);
            try {
                this.salvarColecaoId(colIds);
            }
            catch (RepositorioXMLException repositorioXMLException) {
                // empty catch block
            }
        }
    }

    public abstract String getXPathCopiaId();

    private void restaurarListaIdDeclaracoes(Colecao colIds, String[] decs) {
        if (colIds == null) {
            colIds = this.criarListaIdDeclaracoes();
        } else {
            colIds.recuperarLista().clear();
        }
        DefaultTagHandler tagHandler = this.obterTagHandler();
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            XMLSaxHandler handler = new XMLSaxHandler();
            handler.addTagHandler(this.getXPathCopiaId(), tagHandler);
            int i = 0;
            while (i < decs.length) {
                File dirDec = new File(String.valueOf(this.obterPathDados()) + File.separator + decs[i]);
                if (dirDec.isDirectory()) {
                    try {
                        File[] decXml = dirDec.listFiles(new FileFilter(){

                            @Override
                            public boolean accept(File pathname) {
                                boolean ret = pathname.isFile() && pathname.getName().matches(String.valueOf(RepositorioXML.this.obterExpressaoRegularNomePasta()) + "\\.xml");
                                return ret;
                            }
                        });
                        if (decXml != null && decXml.length > 0) {
                            this.parseXml(colIds, parser, tagHandler, handler, decXml);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    public void salvarDeclaracao(DeclaracaoComIdentificador dec) throws RepositorioXMLException {
        try {
            Colecao colIds = this.getListaIdDeclaracoes();
            IdentificadorDeclaracaoXML idAtual = dec.getIdentificador();
            String numeroIdentificacao = this.obterNumeroIdentificacao(idAtual);
            IdentificadorDeclaracaoXML item = this.obterIdentificador(colIds, numeroIdentificacao);
            this.copiaIdentificador(idAtual, item);
            this.salvarColecaoId(colIds);
            this.antesDeSalvar(dec);
            this.repositorioDeclaracoes.salvar((ObjetoNegocio)dec, idAtual.getPathArquivo());
        }
        catch (RepositorioException e) {
            e.printStackTrace();
        }
    }

    public void salvarColecaoId(Colecao colIds) throws RepositorioXMLException {
        this.repositorioIds.salvar((ObjetoNegocio)colIds, this.obterPathXmlIdsDeclaracoes());
    }

    public void abreDeclaracao(IdentificadorDeclaracaoXML id) throws RepositorioXMLException, HashInvalidoException {
        this.identificadorDeclaracao = id;
        if (this.repositorioDeclaracoes.temObjetoNegocioEmCache(id.getPathArquivo())) {
            this.declaracao = (DeclaracaoComIdentificador)this.repositorioDeclaracoes.getObjeto(id.getPathArquivo());
        } else {
            DialogoOcupado diaOcupado = DialogoOcupado.exibeDialogo((int)0, (int)4, (String)"Aguarde...");
            try {
                diaOcupado.atualiza("Abrindo declara\u00e7\u00e3o...");
                this.declaracao = this.instanciarDeclaracao(this.identificadorDeclaracao);
                diaOcupado.atualiza();
                this.repositorioDeclaracoes.preencheObjeto((ObjetoNegocio)this.declaracao, id.getPathArquivo(), false);
                diaOcupado.atualiza();
                this.fireAbriuDeclaracao(this.declaracao);
                diaOcupado.atualiza();
            }
            finally {
                diaOcupado.finaliza();
            }
        }
    }

    public void abreDeclaracao(DeclaracaoComIdentificador dec) {
        this.identificadorDeclaracao = dec.getIdentificador();
        this.declaracao = dec;
    }

    public Colecao getListaIdDeclaracoes() {
        if (this.isCacheIdDeclaracao()) {
            return this.listaIdDeclaracoesCache;
        }
        return this.carregaIdDeclaracoes();
    }

    public void criarDeclaracao(IdentificadorDeclaracaoXML id) {
        try {
            this.testaDiretorioDados();
            if (this.existeDeclaracao(id)) {
                throw new Exception("Declara\u00e7\u00e3o j\u00e1 existe.");
            }
            Colecao colIds = this.getListaIdDeclaracoes();
            colIds.recuperarLista().add((ObjetoNegocio)id);
            this.repositorioIds.salvar((ObjetoNegocio)colIds, this.obterPathXmlIdsDeclaracoes());
            this.identificadorDeclaracao = id;
            DeclaracaoComIdentificador dec = this.instanciarDeclaracao(this.identificadorDeclaracao);
            this.fireCriouDeclaracao(dec);
            this.repositorioDeclaracoes.salvar((ObjetoNegocio)dec, id.getPathArquivo());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void criarDeclaracao(DeclaracaoComIdentificador dec) {
        try {
            this.testaDiretorioDados();
            IdentificadorDeclaracaoXML id = dec.getIdentificador();
            if (this.existeDeclaracao(id)) {
                throw new Exception("Declara\u00e7\u00e3o j\u00e1 existe.");
            }
            Colecao colIds = this.getListaIdDeclaracoes();
            colIds.recuperarLista().add((ObjetoNegocio)id);
            this.repositorioIds.salvar((ObjetoNegocio)colIds, this.obterPathXmlIdsDeclaracoes());
            this.identificadorDeclaracao = id;
            this.fireCriouDeclaracao(dec);
            this.repositorioDeclaracoes.salvar((ObjetoNegocio)dec, id.getPathArquivo());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void fazerBackup(IdentificadorDeclaracaoXML id) {
        this.repositorioDeclaracoes.fazerBackup(id.getPathArquivo());
    }

    public void fazerBackup(String pathArquivo) {
        this.repositorioDeclaracoes.fazerBackup(pathArquivo);
    }

    public void restaurarBackup(IdentificadorDeclaracaoXML id) throws BackupInexistenteException {
        this.repositorioDeclaracoes.restaurarBackup(id.getPathArquivo());
    }

    public void restaurarBackup(String pathArquivo) throws BackupInexistenteException {
        this.repositorioDeclaracoes.restaurarBackup(pathArquivo);
    }

    public void excluirBackup(IdentificadorDeclaracaoXML id) throws BackupInexistenteException {
        this.repositorioDeclaracoes.excluirBackup(id.getPathArquivo());
    }

    public void excluirBackup(String pathArquivo) throws BackupInexistenteException {
        this.repositorioDeclaracoes.excluirBackup(pathArquivo);
    }

    public void excluirDeclaracao(String numeroIdentificacao) {
        try {
            this.testaDiretorioDados();
            Colecao colIds = this.getListaIdDeclaracoes();
            IdentificadorDeclaracaoXML id = this.obterIdentificador(colIds, numeroIdentificacao);
            this.removerIdentificador(colIds, id);
            this.repositorioIds.salvar((ObjetoNegocio)colIds, this.obterPathXmlIdsDeclaracoes());
            String dir = UtilitariosArquivo.extraiPath((String)id.getPathArquivo());
            this.repositorioDeclaracoes.excluir(id.getPathArquivo());
            new File(dir).delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void excluirDeclaracao(IdentificadorDeclaracaoXML id) {
        try {
            this.testaDiretorioDados();
            Colecao colIds = this.getListaIdDeclaracoes();
            this.removerIdentificador(colIds, id);
            this.repositorioIds.salvar((ObjetoNegocio)colIds, this.obterPathXmlIdsDeclaracoes());
            this.repositorioDeclaracoes.excluir(id.getPathArquivo());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void excluirDeclaracao(List<IdentificadorDeclaracaoXML> ids) {
        try {
            this.testaDiretorioDados();
            Colecao colIds = this.getListaIdDeclaracoes();
            this.removerIdentificadores(colIds, ids);
            this.repositorioIds.salvar((ObjetoNegocio)colIds, this.obterPathXmlIdsDeclaracoes());
            for (IdentificadorDeclaracaoXML idDec : ids) {
                this.repositorioDeclaracoes.excluir(idDec.getPathArquivo());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void salvaDeclaracaoAberta() {
        try {
            Colecao colIds = this.getListaIdDeclaracoes();
            IdentificadorDeclaracaoXML idAberto = this.getIdDeclaracaoAberto();
            String numeroIdentificacao = this.obterNumeroIdentificacao(idAberto);
            IdentificadorDeclaracaoXML item = this.obterIdentificador(colIds, numeroIdentificacao);
            this.copiaIdentificador(idAberto, item);
            this.repositorioIds.salvar((ObjetoNegocio)colIds, this.obterPathXmlIdsDeclaracoes());
            this.antesDeSalvar(this.getDeclaracaoAberta());
            this.repositorioDeclaracoes.salvar((ObjetoNegocio)this.getDeclaracaoAberta(), idAberto.getPathArquivo());
        }
        catch (RepositorioException repositorioException) {
            // empty catch block
        }
    }

    public void fechaDeclaracao() {
        this.declaracao = null;
        this.identificadorDeclaracao = null;
        this.repositorioDeclaracoes.zeraCache();
        this.repositorioIds.zeraCache();
    }

    public IdentificadorDeclaracaoXML getIdDeclaracaoAberto() {
        return this.identificadorDeclaracao;
    }

    public DeclaracaoComIdentificador getDeclaracaoAberta() {
        return this.declaracao;
    }

    public boolean existeDeclaracoes() {
        return this.getListaIdDeclaracoes().recuperarLista().size() > 0;
    }

    public void setCacheIdDeclaracao(boolean cacheIdDeclaracao) {
        this.cacheIdDeclaracao = cacheIdDeclaracao;
        if (cacheIdDeclaracao) {
            this.listaIdDeclaracoesCache = this.criarListaIdDeclaracoes();
            this.listaIdDeclaracoesCache.recuperarLista().addAll(this.carregaIdDeclaracoes().recuperarLista());
        } else {
            if (this.listaIdDeclaracoesCache != null) {
                this.listaIdDeclaracoesCache.clear();
            }
            this.listaIdDeclaracoesCache = null;
        }
    }

    public boolean isCacheIdDeclaracao() {
        return this.cacheIdDeclaracao;
    }
}

