/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.txt.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import serpro.ppgd.formatosexternos.txt.RegistroTxt;
import serpro.ppgd.formatosexternos.txt.excecao.GeracaoTxtException;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.txt.gravacaorestauracao.GravadorTXT;
import serpro.ppgd.irpf.txt.gravacaorestauracao.RepositorioDeclaracaoCentralTxt;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.ppgd.negocio.util.UtilitariosString;
import serpro.ppgd.negocio.util.Validador;
import serpro.receitanet.Util;

public class IRPFTxtUtil {
    public static String declaracaoFoiTransmitida(IdentificadorDeclaracao idDecITR, String pathTransmitidas) {
        boolean foiTrans;
        boolean bl = foiTrans = !idDecITR.getNumReciboTransmitido().naoFormatado().equals("0000000000");
        if (foiTrans) {
            try {
                String numRecibo = idDecITR.getNumReciboTransmitido().naoFormatado();
                return (numRecibo + IRPFTxtUtil.obtemDVNumRecibo(numRecibo)).trim();
            }
            catch (Exception e) {
                LogPPGD.erro((String)e.getMessage());
                return null;
            }
        }
        return null;
    }

    public static boolean controleRFBBate(File dec, File rec) {
        try {
            RepositorioDeclaracaoCentralTxt repositorioRecibo = new RepositorioDeclaracaoCentralTxt("ARQ_COMPLRECIBO", rec);
            RegistroTxt registroRecibo = repositorioRecibo.recuperarRegistroComplementoRecibo();
            String controleSRFcodificado = registroRecibo.fieldByName("CONTROLE_SRF").asString();
            RepositorioDeclaracaoCentralTxt repDeclaracao = new RepositorioDeclaracaoCentralTxt("ARQ_IRPF", dec);
            RegistroTxt headerDec = repDeclaracao.recuperarRegistroHeader();
            if (IRPFTxtUtil.controleRFBBate(headerDec, controleSRFcodificado)) {
                return true;
            }
        }
        catch (GeracaoTxtException e1) {
            e1.printStackTrace();
        }
        catch (IOException e) {
            LogPPGD.erro((String)e.getMessage());
        }
        return false;
    }

    private static boolean controleRFBBate(RegistroTxt headerDec, String controleRFBcodificado) throws GeracaoTxtException {
        String h = headerDec.fieldByName("NR_HASH").asString();
        String controleDecodificado = Util.decodificaControleSRF((byte[])controleRFBcodificado.getBytes());
        return h.equals(controleDecodificado);
    }

    public static File montaPathTXTDeclaracao(String dirDados, IdentificadorDeclaracao idDec, boolean isParaEntrega) {
        File f = new File(dirDados);
        f.mkdirs();
        StringBuffer strPath = new StringBuffer(f.getPath());
        strPath.append(System.getProperty("file.separator"));
        strPath.append(GravadorTXT.montaNomeArquivoTXT((byte)0, idDec));
        f = new File(strPath.toString());
        return f;
    }

    public static String formataNumeroRecibo(String hashCode) {
        String hashCodeFormatado = UtilitariosString.formataComPontos((String)hashCode, (int)2);
        return hashCodeFormatado;
    }

    public static String obtemDVNumRecibo(String numRecibo) {
        Object DV = "";
        int dv1 = Validador.calcularModulo11((String)numRecibo, null, (int)2);
        DV = (String)DV + dv1;
        int dv2 = Validador.calcularModulo11((String)(numRecibo + dv1), null, (int)2);
        DV = (String)DV + dv2;
        return DV;
    }

    public static void copiaBinariaArquivo(String in, String outPath) throws FileNotFoundException, IOException {
        File origem = new File(in);
        File destino = new File(outPath + "/" + origem.getName());
        File flSaida = new File(outPath);
        if (origem.getParent().equals(flSaida.getPath())) {
            return;
        }
        boolean semPermissao = false;
        if (!flSaida.exists() && !flSaida.mkdirs()) {
            semPermissao = true;
        }
        try (FileInputStream fis = new FileInputStream(origem);
             FileOutputStream fos = new FileOutputStream(destino);){
            if (semPermissao) {
                throw new IOException(MensagemUtil.getMensagem((String)"gravar_pasta_sem_permissao"));
            }
            int count = 0;
            byte[] bytes = new byte[1024];
            while ((count = fis.read(bytes)) >= 0) {
                fos.write(bytes, 0, count);
            }
        }
        catch (Exception e) {
            LogPPGD.erro((String)e.getMessage());
            throw e;
        }
    }
}

