/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.txt.util;

import br.gov.serpro.midas.model.AplicacaoDTO;
import br.gov.serpro.midas.model.DeclaracaoDTO;
import br.gov.serpro.midas.negocio.Solicitacao;
import br.gov.serpro.midas.text.MidasTextResourceProcessor;
import br.gov.serpro.midas.xmlada.XMLAdaJ;
import groovy.lang.GroovyClassLoader;
import groovy.util.GroovyScriptEngine;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import java.util.Scanner;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.FileUtils;
import serpro.ppgd.formatosexternos.txt.excecao.GeracaoTxtException;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.txt.gravacaorestauracao.GravadorTXT;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.ppgd.negocio.util.UtilitariosArquivo;
import xslconverter.TransformadorXSL;

public class ConversorMidas {
    private String path = UtilitariosArquivo.getPathGravadas() + File.separator + ".midas";
    private final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;

    public String gerarDeclaracaoMidas(IdentificadorDeclaracao idDeclaracao, String pPathDEC) throws GeracaoTxtException, IOException {
        String pathDec = null;
        FileUtils.forceMkdir((File)new File(this.path));
        if (pPathDEC != null) {
            pathDec = pPathDEC;
        } else {
            GravadorTXT.copiarDeclaracaoParaImpressaoMidas(idDeclaracao, this.path, this.DEFAULT_CHARSET);
            pathDec = GravadorTXT.montaNome((byte)1, this.path, idDeclaracao);
        }
        String diretorio = idDeclaracao.getCpf().naoFormatado() + "-" + idDeclaracao.getExercicio() + "-" + new Date().getTime();
        new File(this.path + File.separator + diretorio).mkdir();
        String pathDecTemp = this.path + File.separator + diretorio + File.separator + "temp.dec";
        String pathXmlTemp = this.path + File.separator + diretorio + File.separator + "temp.xml";
        String pathXmlFinal = this.path + File.separator + diretorio + File.separator + "dados.xml";
        String exercicio = ConstantesGlobais.EXERCICIO;
        URL layoutDados = UtilitariosArquivo.localizaArquivoEmClasspath((String)("/LayoutDadosDIRPF" + exercicio + ".xml"));
        URL xsl = UtilitariosArquivo.localizaArquivoEmClasspath((String)("/DIRPF" + exercicio + ".xsl"));
        this.execGroovy(exercicio, pathDec, pathDecTemp);
        this.execXMLAda(pathDecTemp, layoutDados, pathXmlTemp);
        this.execXSL(xsl, pathXmlTemp, pathXmlFinal);
        return pathXmlFinal;
    }

    public String gerarDeclaracaoMidas(IdentificadorDeclaracao idDeclaracao) throws GeracaoTxtException, IOException {
        return this.gerarDeclaracaoMidas(idDeclaracao, null);
    }

    private void execXSL(URL pathXSL, String pathOutXMLAda, String pathOutFinal) throws TransformerFactoryConfigurationError {
        try (InputStream xsl = pathXSL.openStream();){
            File entrada = new File(pathOutXMLAda);
            File saida = new File(pathOutFinal);
            TransformadorXSL xls = new TransformadorXSL();
            FileInputStream input = new FileInputStream(entrada);
            StreamSource source = new StreamSource(input);
            FileOutputStream outputResult = new FileOutputStream(saida);
            StreamResult result = new StreamResult(outputResult);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer(new StreamSource(xsl));
            transformer.setOutputProperty("encoding", this.DEFAULT_CHARSET.name());
            transformer.transform(source, result);
        }
        catch (Exception e) {
            e.printStackTrace();
            LogPPGD.erro((String)e.getMessage());
        }
    }

    private void execXMLAda(String pathOut, URL urlLayoutDados, String pathOutXMLAda) {
        XMLAdaJ xmladaj = new XMLAdaJ();
        try (InputStream inLayoutDados = urlLayoutDados.openStream();){
            File fPathOut = new File(pathOut);
            Path pPathOut = Paths.get(fPathOut.getPath(), new String[0]);
            String dec = new String(Files.readAllBytes(pPathOut), this.DEFAULT_CHARSET);
            String xsl = this.convertStreamToString(inLayoutDados);
            String textoXml = xmladaj.textoXml(dec, xsl, false);
            try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(pathOutXMLAda), this.DEFAULT_CHARSET));){
                out.write(textoXml);
                ((Writer)out).flush();
            }
            catch (Exception e) {
                e.printStackTrace();
                LogPPGD.erro((String)e.getMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LogPPGD.erro((String)e.getMessage());
        }
    }

    private void execGroovy(String exercicio, String pathDec, String pathOut) {
        try {
            InputStream streamGroovy = this.getClass().getResourceAsStream("/DIRPFComponente.groovy");
            BufferedReader br = new BufferedReader(new InputStreamReader(streamGroovy, this.DEFAULT_CHARSET));
            GroovyClassLoader gcl = new GroovyScriptEngine(".").getGroovyClassLoader();
            Class clazz = gcl.parseClass((Reader)br, "DIRPFComponente.groovy");
            Object aScript = clazz.newInstance();
            MidasTextResourceProcessor ifc = (MidasTextResourceProcessor)aScript;
            DeclaracaoDTO dec = new DeclaracaoDTO();
            dec.setExercicio(exercicio);
            Solicitacao solicitacao = new Solicitacao("", null, new AplicacaoDTO(), "", "", "");
            String decStr = this.readFileToString(pathDec, this.DEFAULT_CHARSET);
            solicitacao.setTextoDeclaracao(decStr);
            FileOutputStream out = new FileOutputStream(pathOut);
            ifc.execute(dec, solicitacao, (OutputStream)out);
        }
        catch (Exception e) {
            e.printStackTrace();
            LogPPGD.erro((String)e.getMessage());
        }
    }

    private String readFileToString(String path, Charset encoding) throws IOException {
        byte[] encoded = Files.readAllBytes(Paths.get(path, new String[0]));
        return new String(encoded, encoding);
    }

    private String convertStreamToString(InputStream is) {
        Scanner s = new Scanner(is).useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }
}

