/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.txt.importacao.gcap;

import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import serpro.ppgd.gui.filechooser.FileChooser;
import serpro.ppgd.gui.filechooser.FileChooserFactory;
import serpro.ppgd.gui.filechooser.FileChooserResponse;
import serpro.ppgd.gui.filechooser.FileFilter;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.irpf.exception.InternetException;
import serpro.ppgd.irpf.gcap.DemonstrativoGCAP;
import serpro.ppgd.irpf.gcap.GCAP;
import serpro.ppgd.irpf.gcap.IdDemonstrativoGCAP;
import serpro.ppgd.irpf.gcap.ObjetoGCAP;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.txt.importacao.gcap.FiltroDemonstrativoGCAP;
import serpro.ppgd.irpf.util.IRPFUtil;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.ConstantesGlobais;

public class ProcessoImportacaoGCAP {
    public static final String PADRAO_EXT = "-(\\d){4}-(\\d){4}-GCAP-" + ConstantesGlobais.EXERCICIO_ANTERIOR + "\\.DEC";
    public static final String ACTION_IMPORTAR_GCAP = "Importa\u00e7\u00e3o GCAP " + ConstantesGlobais.ANO_BASE;
    private File[] arquivosImportacao = null;
    private int quantidadeSucessos;
    private int quantidadeErros;
    private boolean importacaoCombinada = false;
    private boolean exibirContabilizarSucessosErros;
    public static ArrayList<String> listaErros = new ArrayList();
    private String mensagemErroOriginal = null;

    public ProcessoImportacaoGCAP() {
        this.setExibirContabilizarSucessosErros(false);
    }

    public void setExibirContabilizarSucessosErros(boolean exibir) {
        this.exibirContabilizarSucessosErros = exibir;
    }

    public boolean isExibirContabilizarSucessosErros() {
        return this.exibirContabilizarSucessosErros;
    }

    public void setArquivosImportacao(File[] arquivosImportacao) {
        this.arquivosImportacao = arquivosImportacao;
    }

    public void importar() {
        if (this.arquivosImportacao == null) {
            FileChooser fc = FileChooserFactory.getInstance().createFileChooser();
            fc.setDialogTitle("Importa\u00e7\u00e3o de dados de Ganhos de Capital");
            fc.setApproveButtonText("OK");
            fc.setApproveButtonToolTipText("Importar dados de Ganhos de Capital");
            fc.setAcceptAllFileFilterUsed(false);
            fc.setFileFilter((FileFilter)new FiltroDemonstrativoGCAP());
            fc.setMultiSelectionEnabled(true);
            FileChooserResponse retorno = fc.showOpenDialog((Component)PlataformaPPGD.getPlataforma().getJanelaPrincipal());
            if (retorno == FileChooserResponse.APPROVE_OPTION) {
                for (File f : fc.getSelectedFiles()) {
                    if (IRPFUtil.validarArquivoGCAP((File)f)) continue;
                    JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), MensagemUtil.getMensagem((String)"importacao_gcap_cpf_invalido"), "Erro", 0);
                    return;
                }
                this.arquivosImportacao = fc.getSelectedFiles();
            }
        }
        if (this.arquivosImportacao != null) {
            this.setQuantidadeSucessos(0);
            this.setQuantidadeErros(0);
            boolean jaMostrouErro = false;
            boolean comInternet = true;
            GCAP gcap = ControladorGui.getDemonstrativoAberto().getGCAP();
            for (int i = 0; i < this.arquivosImportacao.length; ++i) {
                try {
                    serpro.ppgd.irpf.gcap.ProcessoImportacaoGCAP processo = new serpro.ppgd.irpf.gcap.ProcessoImportacaoGCAP();
                    DemonstrativoGCAP demonstrativoGCAP = processo.importar(this.arquivosImportacao[i]);
                    boolean importar = true;
                    if (!demonstrativoGCAP.demonstrativoAssociadoArquivo(this.arquivosImportacao[i])) {
                        importar = false;
                        jaMostrouErro = true;
                        GuiUtil.mostrarErro((String)"gcap_nome_arquivo_diferente");
                    } else {
                        boolean jaExiste = gcap.existeDemonstrativoJaImportado(demonstrativoGCAP);
                        if (jaExiste) {
                            if (GuiUtil.mostrarConfirma((String)"confirmacao_importacao")) {
                                gcap.removerDemonstrativo((ObjetoGCAP)demonstrativoGCAP.getIdDemonstrativo());
                            } else {
                                importar = false;
                            }
                        }
                    }
                    if (!importar) continue;
                    gcap.incluirDemonstrativo(demonstrativoGCAP);
                    this.setQuantidadeSucessos(this.getQuantidadeSucessos() + 1);
                    continue;
                }
                catch (Exception e) {
                    if (e instanceof InternetException) {
                        comInternet = false;
                    }
                    this.setQuantidadeErros(this.getQuantidadeErros() + 1);
                    this.mensagemErroOriginal = e.getMessage();
                    if (!this.isExibirContabilizarSucessosErros()) break;
                    listaErros.add(this.arquivosImportacao[i].getName() + " ==> " + e.getMessage());
                }
            }
            gcap.recalcularGCAPDeclaracaoIRPF();
            gcap.atualizarCodigosOperacao();
            ControladorGui.getDemonstrativoAberto().recalcularDeclaracao();
            if (this.getQuantidadeSucessos() > 0) {
                JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), MensagemUtil.getMensagem((String)"importacao_gcap_sucesso"), "Informa\u00e7\u00e3o", 1);
            } else if (this.mensagemErroOriginal == null || jaMostrouErro) {
                JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), MensagemUtil.getMensagem((String)"importacao_gcap_erro"), "Erro", 0);
            } else {
                JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), this.mensagemErroOriginal, "Erro", 0);
                if (comInternet) {
                    JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), MensagemUtil.getMensagem((String)"importacao_gcap_erro"), "Erro", 0);
                }
            }
        }
        this.arquivosImportacao = null;
    }

    protected boolean substituiDemosntrativo(GCAP ganhosCapital, IdDemonstrativoGCAP idDemonstrativoGCAP) {
        if (this.isImportacaoCombinada() || GuiUtil.mostrarConfirma((String)"confirmacao_importacao")) {
            ganhosCapital.removerDemonstrativo((ObjetoGCAP)idDemonstrativoGCAP);
            return true;
        }
        return false;
    }

    public int getQuantidadeSucessos() {
        return this.quantidadeSucessos;
    }

    public void setQuantidadeSucessos(int quantidadeSucessos) {
        this.quantidadeSucessos = quantidadeSucessos;
    }

    public int getQuantidadeErros() {
        return this.quantidadeErros;
    }

    private void setQuantidadeErros(int quantidadeErros) {
        this.quantidadeErros = quantidadeErros;
    }

    public boolean isImportacaoCombinada() {
        return this.importacaoCombinada;
    }

    public void setImportacaoCombinada(boolean importacaoCombinada) {
        this.importacaoCombinada = importacaoCombinada;
    }

    public static FileChooser obterFileChooserFiltradoGCAP() {
        FileChooser fc = FileChooserFactory.getInstance().createFileChooser();
        fc.setDialogTitle("Importa\u00e7\u00e3o de dados de Ganhos de Capital");
        fc.setApproveButtonText("OK");
        fc.setApproveButtonToolTipText("Importar dados de Ganhos de Capital");
        fc.setAcceptAllFileFilterUsed(false);
        fc.setFileFilter((FileFilter)new FiltroDemonstrativoGCAP());
        fc.setMultiSelectionEnabled(true);
        return fc;
    }
}

