/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.txt.importacao.carneleao;

import java.util.Iterator;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.espolio.Espolio;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.nuvem.carneleao.CarneLeao;
import serpro.ppgd.irpf.nuvem.carneleao.Registro01;
import serpro.ppgd.irpf.nuvem.carneleao.Registro02;
import serpro.ppgd.irpf.nuvem.carneleao.Registro03;
import serpro.ppgd.irpf.nuvem.carneleao.Registro04;
import serpro.ppgd.irpf.rendpf.Conta;
import serpro.ppgd.irpf.rendpf.ContasMes;
import serpro.ppgd.irpf.rendpf.MesRendPF;
import serpro.ppgd.irpf.rendpf.RendPF;
import serpro.ppgd.irpf.rendpj.RendPJDependente;
import serpro.ppgd.irpf.rendpj.RendPJTitular;
import serpro.ppgd.irpf.saida.Saida;
import serpro.ppgd.irpf.txt.importacao.RelatorioRepositorioTxtDadosAb;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Valor;

public class RepositorioTxtDadosCarneLeaoWeb
extends RelatorioRepositorioTxtDadosAb {
    private CarneLeao carneLeao;

    public RepositorioTxtDadosCarneLeaoWeb(CarneLeao carneLeao) {
        this.carneLeao = carneLeao;
        this.setContabilizarSucessosErros(false);
    }

    public void importaIdentificacao(DeclaracaoIRPF dec) {
        Registro01 registro = this.carneLeao.getDados().getRegistro01();
        if (!dec.getIdentificadorDeclaracao().isEspolio() && registro.getCodOcupacaoPrincipal() != null && registro.getCodOcupacaoPrincipal().matches("225|226|229|230|231|232|255|241")) {
            if (dec.getContribuinte().getOcupacaoPrincipal().isVazio()) {
                dec.getContribuinte().getOcupacaoPrincipal().setConteudo(registro.getCodOcupacaoPrincipal());
                dec.getContribuinte().getRegistroProfissional().setConteudo(registro.getNrRegProfissional());
            } else if (dec.getContribuinte().getOcupacaoPrincipal().naoFormatado().equals(registro.getCodOcupacaoPrincipal())) {
                dec.getContribuinte().getRegistroProfissional().setConteudo(registro.getNrRegProfissional());
            } else if (GuiUtil.mostrarConfirma((String)"confirmacao_substituicao_ocupacao_principal")) {
                dec.getContribuinte().getOcupacaoPrincipal().setConteudo(registro.getCodOcupacaoPrincipal());
                dec.getContribuinte().getRegistroProfissional().setConteudo(registro.getNrRegProfissional());
            }
        }
    }

    public void importaDados(RendPF rendPF, CPF cpfContribuinte, boolean titular) {
        Valor impostoPagoExterior;
        for (Registro02 reg : this.carneLeao.getDados().getRegistros02()) {
            MesRendPF mes = this.getMesRendPFTitular(reg.getMes(), rendPF);
            boolean importar = true;
            if (ControladorGui.getDemonstrativoAberto().getIdentificadorDeclaracao().isEspolio()) {
                Espolio espolio = IRPFFacade.getInstancia().getEspolio();
                String mesLimite = espolio.obterDataLimiteParaCalculos().getMes();
                if (mes.getMes().asInteger() + 1 > Integer.valueOf(mesLimite)) {
                    importar = false;
                }
            } else if (ControladorGui.getDemonstrativoAberto().getIdentificadorDeclaracao().isSaida()) {
                String mesCondicaoResidente;
                Saida saida = IRPFFacade.getInstancia().getSaida();
                String mesCondicaoNaoResidente = saida.getDtCondicaoNaoResidente().isVazio() ? "12" : saida.getDtCondicaoNaoResidente().getMes();
                String string = mesCondicaoResidente = saida.getDtCondicaoResidente().isVazio() ? "1" : saida.getDtCondicaoResidente().getMes();
                if (mes.getMes().asInteger() + 1 < Integer.valueOf(mesCondicaoResidente) || mes.getMes().asInteger() + 1 > Integer.valueOf(mesCondicaoNaoResidente)) {
                    importar = false;
                }
            }
            if (!importar) continue;
            mes.getAlugueis().setConteudo(Valor.valueOf((String)reg.getAlugueis()));
            mes.getOutros().setConteudo(Valor.valueOf((String)reg.getOutros()));
            mes.getExterior().setConteudo(Valor.valueOf((String)reg.getExterior()));
            mes.getPrevidencia().setConteudo(Valor.valueOf((String)reg.getPrevidenciaOficial()));
            mes.getNumDependentes().setConteudo(Valor.valueOf((long)reg.getDependentes().intValue()));
            mes.getPensao().setConteudo(Valor.valueOf((String)reg.getPensaoAlimenticia()));
            mes.getLivroCaixa().setConteudo(Valor.valueOf((String)reg.getLivroCaixa()));
            mes.getCarneLeao().setConteudo(Valor.valueOf((String)reg.getImpostoAPagar()));
            mes.getDarfPago().setConteudo(Valor.valueOf((String)reg.getImpostoPago()));
        }
        for (int i = 0; i < 12; ++i) {
            rendPF.getContasAno().getArrayMeses()[i].getTotalRendTrabNaoAssPF().clear();
            rendPF.getContasAno().getArrayMeses()[i].itens().clear();
        }
        boolean[] meses = new boolean[12];
        for (int i = 0; i < 12; ++i) {
            meses[i] = IRPFFacade.getInstancia().getDeclaracao().permiteInformarRendimento(i + 1);
        }
        for (Registro03 reg : this.carneLeao.getDados().getRegistros03()) {
            String strMes = reg.getData();
            int mes = Integer.valueOf(strMes.substring(0, 2));
            if (!meses[mes - 1]) continue;
            ContasMes contasMes = rendPF.getContasAno().getArrayMeses()[mes - 1];
            Conta conta = new Conta();
            conta.getCpfContribuinte().setConteudo(cpfContribuinte);
            conta.getDataMesAno().setConteudo(strMes);
            conta.getCpfTitularPagamento().setConteudo(reg.getCpfTitular());
            conta.getCpfBeneficiarioServico().setConteudo(reg.getCpfBeneficiario() != null ? reg.getCpfBeneficiario() : "");
            conta.getValor().setConteudo(Valor.valueOf((String)reg.getValor()));
            if (conta.getCpfTitularPagamento().naoFormatado().equals(conta.getCpfBeneficiarioServico().naoFormatado())) {
                conta.getIndTitularEhBeneficiario().setConteudo("1");
            } else {
                conta.getIndTitularEhBeneficiario().setConteudo("0");
            }
            if (conta.getCpfBeneficiarioServico().naoFormatado().length() != 11) {
                conta.getIndBeneficiarioNaoPossuiCPF().setConteudo("1");
            } else {
                conta.getIndBeneficiarioNaoPossuiCPF().setConteudo("0");
            }
            contasMes.itens().add(conta);
        }
        Iterator it_pj = this.carneLeao.getDados().getRegistros04().iterator();
        if (it_pj.hasNext()) {
            Object colecaoRendPJ = null;
            colecaoRendPJ = titular ? IRPFFacade.getInstancia().getColecaoRendPJTitular() : IRPFFacade.getInstancia().getColecaoRendPJDependente();
            boolean exibeMensagemRendPJNaoImportado = false;
            while (it_pj.hasNext()) {
                boolean existeRendPJ = false;
                Registro04 reg04 = (Registro04)it_pj.next();
                for (RendPJTitular rend : colecaoRendPJ.itens()) {
                    if (!rend.getNIFontePagadora().naoFormatado().equals(reg04.getCnpj())) continue;
                    existeRendPJ = true;
                    exibeMensagemRendPJNaoImportado = true;
                    break;
                }
                if (existeRendPJ) continue;
                if (titular) {
                    RendPJTitular rendTitular = new RendPJTitular(IRPFFacade.getInstancia().getIdDeclaracaoAberto());
                    rendTitular.getNIFontePagadora().setConteudo(reg04.getCnpj());
                    rendTitular.getNomeFontePagadora().setConteudo(reg04.getNomeFontePagadora());
                    rendTitular.getRendRecebidoPJ().setConteudo(Valor.valueOf((String)reg04.getValor()));
                    rendTitular.getImpostoRetidoFonte().setConteudo(Valor.valueOf((String)reg04.getValorIrrf()));
                    IRPFFacade.getInstancia().getColecaoRendPJTitular().add((ObjetoNegocio)rendTitular);
                    continue;
                }
                RendPJDependente rendDependente = new RendPJDependente(IRPFFacade.getInstancia().getDeclaracao());
                rendDependente.getCpfDependente().setConteudo(cpfContribuinte);
                rendDependente.getNIFontePagadora().setConteudo(reg04.getCnpj());
                rendDependente.getNomeFontePagadora().setConteudo(reg04.getNomeFontePagadora());
                rendDependente.getRendRecebidoPJ().setConteudo(Valor.valueOf((String)reg04.getValor()));
                rendDependente.getImpostoRetidoFonte().setConteudo(Valor.valueOf((String)reg04.getValorIrrf()));
                IRPFFacade.getInstancia().getColecaoRendPJDependente().add((ObjetoNegocio)rendDependente);
            }
            if (exibeMensagemRendPJNaoImportado) {
                GuiUtil.mostrarAviso(null, (String)MensagemUtil.getMensagemComQuebraDeLinha((String)"mensagem_carne_leao_pj_existente"));
            }
        }
        if (!(impostoPagoExterior = Valor.valueOf((String)this.carneLeao.getDados().getRegistro01().getValorImpostoPagoExterior())).isVazio()) {
            if (IRPFFacade.getInstancia().getDeclaracao().getImpostoPago().getImpostoPagoExterior().isVazio()) {
                IRPFFacade.getInstancia().getDeclaracao().getImpostoPago().getImpostoPagoExterior().setConteudo(impostoPagoExterior);
            } else {
                GuiUtil.mostrarAviso(null, (String)MensagemUtil.getMensagemComQuebraDeLinha((String)"mensagem_carne_leao_imposto_pago_exterior_ja_preenchido"));
            }
        }
        boolean heTitular = cpfContribuinte.naoFormatado().equals(IRPFFacade.getInstancia().getIdDeclaracaoAberto().getCpf().naoFormatado());
        String ocupacaoPrincipal = ControladorGui.getDemonstrativoAberto().getContribuinte().getOcupacaoPrincipal().getConteudoAtual(0);
        if (heTitular && ocupacaoPrincipal.equals("117")) {
            GuiUtil.mostrarAviso((String)"titular_cartorio");
        }
    }

    private MesRendPF getMesRendPFTitular(String mes, RendPF aRendPF) {
        mes = mes.trim().toUpperCase();
        RendPF rendPF = aRendPF;
        MesRendPF retorno = null;
        if (mes.equals("JANEIRO")) {
            retorno = rendPF.getJaneiro();
            retorno.getMes().setConteudo(0);
            return retorno;
        }
        if (mes.equals("FEVEREIRO")) {
            retorno = rendPF.getFevereiro();
            retorno.getMes().setConteudo(1);
            return retorno;
        }
        if (mes.equals("MARCO") || mes.equals("MAR\u00c7O")) {
            retorno = rendPF.getMarco();
            retorno.getMes().setConteudo(2);
            return retorno;
        }
        if (mes.equals("ABRIL")) {
            retorno = rendPF.getAbril();
            retorno.getMes().setConteudo(3);
            return retorno;
        }
        if (mes.equals("MAIO")) {
            retorno = rendPF.getMaio();
            retorno.getMes().setConteudo(4);
            return retorno;
        }
        if (mes.equals("JUNHO")) {
            retorno = rendPF.getJunho();
            retorno.getMes().setConteudo(5);
            return retorno;
        }
        if (mes.equals("JULHO")) {
            retorno = rendPF.getJulho();
            retorno.getMes().setConteudo(6);
            return retorno;
        }
        if (mes.equals("AGOSTO")) {
            retorno = rendPF.getAgosto();
            retorno.getMes().setConteudo(7);
            return retorno;
        }
        if (mes.equals("SETEMBRO")) {
            retorno = rendPF.getSetembro();
            retorno.getMes().setConteudo(8);
            return retorno;
        }
        if (mes.equals("OUTUBRO")) {
            retorno = rendPF.getOutubro();
            retorno.getMes().setConteudo(9);
            return retorno;
        }
        if (mes.equals("NOVEMBRO")) {
            retorno = rendPF.getNovembro();
            retorno.getMes().setConteudo(10);
            return retorno;
        }
        if (mes.equals("DEZEMBRO")) {
            retorno = rendPF.getDezembro();
            retorno.getMes().setConteudo(11);
            return retorno;
        }
        throw new IllegalArgumentException("M\u00eas inv\u00e1lido!");
    }
}

