/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.txt.gravacaorestauracao;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import serpro.ppgd.formatosexternos.txt.RegistroTxt;
import serpro.ppgd.formatosexternos.txt.excecao.GeracaoTxtException;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.txt.gravacaorestauracao.ConversorObjetosIRPF2Registros;
import serpro.ppgd.irpf.txt.gravacaorestauracao.ConversorRegistros2ObjetosIRPF;
import serpro.ppgd.irpf.txt.gravacaorestauracao.DocumentoAjusteTXT;
import serpro.ppgd.irpf.util.TipoDeclaracaoAES;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.util.UtilitariosArquivo;

public class RepositorioDeclaracaoCentralTxt {
    private static byte FINALIDADE_ENTREGA = 0;
    private static byte FINALIDADE_BACKUP = 1;
    private DocumentoAjusteTXT arquivo;
    private File file;
    private boolean fLido = false;
    private IdentificadorDeclaracao objIdArquivo;
    private ConversorRegistros2ObjetosIRPF conversor2ObjIRPF;
    private ConversorObjetosIRPF2Registros conversor2Registros;
    private boolean incluiCharsEspeciais = false;
    private Charset charset = null;

    public RepositorioDeclaracaoCentralTxt(String tipoArq, File file) throws GeracaoTxtException {
        this.file = file;
        this.arquivo = new DocumentoAjusteTXT(tipoArq, file.getPath());
        this.conversor2ObjIRPF = new ConversorRegistros2ObjetosIRPF();
        this.conversor2Registros = new ConversorObjetosIRPF2Registros();
    }

    public RepositorioDeclaracaoCentralTxt(String tipoArq, File file, boolean aIncluiCharsEspeciais, Charset aCharset) throws GeracaoTxtException {
        this.file = file;
        this.setIncluiCharsEspeciais(aIncluiCharsEspeciais);
        this.setCharset(aCharset);
        this.arquivo = new DocumentoAjusteTXT(tipoArq, file.getPath(), aIncluiCharsEspeciais);
        this.conversor2ObjIRPF = new ConversorRegistros2ObjetosIRPF();
        this.conversor2Registros = new ConversorObjetosIRPF2Registros();
    }

    public IdentificadorDeclaracao recuperarIdentificadorDeclaracao(IdentificadorDeclaracao idDeclaracao) throws GeracaoTxtException, IOException {
        this.lerDeclaracao();
        List vetorRegIdentificacao = this.arquivo.getRegistrosTxt("16");
        this.objIdArquivo = idDeclaracao;
        this.conversor2ObjIRPF.montarIdDeclaracaoOnline(vetorRegIdentificacao, idDeclaracao);
        return this.objIdArquivo;
    }

    public IdentificadorDeclaracao recuperarIdDeclaracao() throws GeracaoTxtException, IOException {
        return this.recuperarIdDeclaracao(false);
    }

    public IdentificadorDeclaracao recuperarIdDeclaracao(boolean heTransmitida) throws GeracaoTxtException, IOException {
        this.lerDeclaracao();
        List vetorRegHeader = this.arquivo.getRegistrosTxt("IR");
        if (vetorRegHeader == null || vetorRegHeader.size() == 0) {
            throw new GeracaoTxtException("Registro Header n\u00e3o encontrado.");
        }
        List vetorRegIdentificacao = this.arquivo.getRegistrosTxt("16");
        if (vetorRegIdentificacao == null || vetorRegIdentificacao.size() == 0) {
            throw new GeracaoTxtException("Registro Identifica\u00e7\u00e3o do Contribuinte n\u00e3o encontrado.");
        }
        this.objIdArquivo = this.conversor2ObjIRPF.montarIdDeclaracao(vetorRegHeader, vetorRegIdentificacao, heTransmitida);
        return this.objIdArquivo;
    }

    public void atualizarNroReciboTransmitida(String nrRecibo) throws Exception {
        this.arquivo.atualizarNrReciboTransmitida(nrRecibo);
        this.arquivo.setBKPno();
        this.arquivo.salvar();
    }

    public String recuperarNroRecibo() throws Exception {
        return this.recuperarRegistroHeader().fieldByName("NR_HASH").asString();
    }

    public int recuperarNroRetificadora() throws Exception {
        int retorno = 0;
        RegistroTxt registroVC = this.recuperarRegistroComplementoReciboValidador();
        if (registroVC != null) {
            try {
                retorno = Integer.valueOf(registroVC.fieldByName("QTD_RETIFICADORAS").asString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return retorno;
    }

    public Map<String, String> recuperarValoresAuxilioEmergencial() throws Exception {
        HashMap<String, String> retorno = new HashMap<String, String>();
        RegistroTxt registroVC = this.recuperarRegistroComplementoReciboValidador();
        if (registroVC != null) {
            try {
                CPF cpf = new CPF();
                Valor valor = new Valor();
                cpf.setConteudo(registroVC.fieldByName("NR_CPF_DARF1").asString());
                valor.setConteudo(registroVC.fieldByName("VL_DARF1").asString());
                valor.append('/', "100");
                if (cpf.validar().getPrimeiroRetornoValidacaoMaisSevero().isValido() && !valor.isVazio()) {
                    retorno.put(cpf.formatado(), valor.formatado());
                }
                cpf.setConteudo(registroVC.fieldByName("NR_CPF_DARF2").asString());
                valor.setConteudo(registroVC.fieldByName("VL_DARF2").asString());
                valor.append('/', "100");
                if (cpf.validar().getPrimeiroRetornoValidacaoMaisSevero().isValido() && !valor.isVazio()) {
                    retorno.put(cpf.formatado(), valor.formatado());
                }
                cpf.setConteudo(registroVC.fieldByName("NR_CPF_DARF3").asString());
                valor.setConteudo(registroVC.fieldByName("VL_DARF3").asString());
                valor.append('/', "100");
                if (cpf.validar().getPrimeiroRetornoValidacaoMaisSevero().isValido() && !valor.isVazio()) {
                    retorno.put(cpf.formatado(), valor.formatado());
                }
                cpf.setConteudo(registroVC.fieldByName("NR_CPF_DARF4").asString());
                valor.setConteudo(registroVC.fieldByName("VL_DARF4").asString());
                valor.append('/', "100");
                if (cpf.validar().getPrimeiroRetornoValidacaoMaisSevero().isValido() && !valor.isVazio()) {
                    retorno.put(cpf.formatado(), valor.formatado());
                }
                cpf.setConteudo(registroVC.fieldByName("NR_CPF_DARF5").asString());
                valor.setConteudo(registroVC.fieldByName("VL_DARF5").asString());
                valor.append('/', "100");
                if (cpf.validar().getPrimeiroRetornoValidacaoMaisSevero().isValido() && !valor.isVazio()) {
                    retorno.put(cpf.formatado(), valor.formatado());
                }
                cpf.setConteudo(registroVC.fieldByName("NR_CPF_DARF6").asString());
                valor.setConteudo(registroVC.fieldByName("VL_DARF6").asString());
                valor.append('/', "100");
                if (cpf.validar().getPrimeiroRetornoValidacaoMaisSevero().isValido() && !valor.isVazio()) {
                    retorno.put(cpf.formatado(), valor.formatado());
                }
                cpf.setConteudo(registroVC.fieldByName("NR_CPF_DARF7").asString());
                valor.setConteudo(registroVC.fieldByName("VL_DARF7").asString());
                valor.append('/', "100");
                if (cpf.validar().getPrimeiroRetornoValidacaoMaisSevero().isValido() && !valor.isVazio()) {
                    retorno.put(cpf.formatado(), valor.formatado());
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return retorno;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IdentificadorDeclaracao recuperarIdDeclaracaoAnoAnterior(boolean prePreenchida) throws GeracaoTxtException, IOException {
        this.lerDeclaracao();
        List vetorRegHeader = this.arquivo.getRegistrosTxt("IR");
        if (prePreenchida) {
            if (vetorRegHeader != null && vetorRegHeader.size() != 0) {
                this.objIdArquivo = this.conversor2ObjIRPF.montarIdDeclaracaoAnoAnterior(vetorRegHeader, prePreenchida);
                return this.objIdArquivo;
            } else {
                List vetorRegIdentificacao = this.arquivo.getRegistrosTxt("16");
                if (vetorRegIdentificacao == null || vetorRegIdentificacao.size() == 0) throw new GeracaoTxtException("Registro Identifica\u00e7\u00e3o do Contribuinte n\u00e3o encontrado.");
                this.objIdArquivo = this.conversor2ObjIRPF.montarIdDeclaracaoPrePreenchida(vetorRegIdentificacao);
            }
            return this.objIdArquivo;
        } else {
            if (vetorRegHeader == null || vetorRegHeader.size() == 0) {
                throw new GeracaoTxtException("Registro Header n\u00e3o encontrado.");
            }
            List vetorRegIdentificacao = this.arquivo.getRegistrosTxt("16");
            if (vetorRegIdentificacao == null || vetorRegIdentificacao.size() == 0) {
                throw new GeracaoTxtException("Registro Identifica\u00e7\u00e3o do Contribuinte n\u00e3o encontrado.");
            }
            this.objIdArquivo = this.conversor2ObjIRPF.montarIdDeclaracaoAnoAnterior(vetorRegHeader, prePreenchida);
        }
        return this.objIdArquivo;
    }

    public IdentificadorDeclaracao recuperarIdDeclaracaoNaoPersistido() throws GeracaoTxtException, IOException {
        return this.recuperarIdDeclaracaoNaoPersistido(false);
    }

    public IdentificadorDeclaracao recuperarIdDeclaracaoNaoPersistido(boolean heTransmitida) throws GeracaoTxtException, IOException {
        this.lerDeclaracao();
        List vetorRegistrosHeader = this.arquivo.getRegistrosTxt("IR");
        List vetorRegistrosIdentificacao = this.arquivo.getRegistrosTxt("16");
        this.objIdArquivo = this.conversor2ObjIRPF.montarIdDeclaracaoNaoPersistido(vetorRegistrosHeader, vetorRegistrosIdentificacao, false, heTransmitida);
        return this.objIdArquivo;
    }

    public IdentificadorDeclaracao recuperarIdDeclaracaoNaoPersistidoAnoAnterior(boolean transmitida) throws GeracaoTxtException, IOException {
        this.lerDeclaracao();
        List vetorRegistrosHeader = this.arquivo.getRegistrosTxt("IR");
        List vetorRegistrosIdentificacao = this.arquivo.getRegistrosTxt("16");
        this.objIdArquivo = this.conversor2ObjIRPF.montarIdDeclaracaoNaoPersistido(vetorRegistrosHeader, vetorRegistrosIdentificacao, true, transmitida);
        return this.objIdArquivo;
    }

    public DeclaracaoIRPF recuperarDeclaracao(IdentificadorDeclaracao idDecl, boolean recuperouPP) throws GeracaoTxtException {
        this.arquivo.validarHeader(idDecl);
        DeclaracaoIRPF objDecl = IRPFFacade.getInstancia().recuperarDeclaracaoIRPF(idDecl.getCpf().naoFormatado(), idDecl.getNumReciboTransmitido().naoFormatado());
        List vetorRegistros = this.arquivo.getRegistrosTxt("16");
        this.conversor2ObjIRPF.montarContribuinteIRPF(vetorRegistros, objDecl.getContribuinte(), objDecl.getIdentificadorDeclaracao(), objDecl.getBens());
        vetorRegistros = this.arquivo.getRegistrosTxt("27");
        this.conversor2ObjIRPF.montarBem(vetorRegistros, objDecl, recuperouPP);
        vetorRegistros = this.arquivo.getRegistrosTxt("36");
        this.conversor2ObjIRPF.montarBemProprietarioUsufrutuario(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("28");
        this.conversor2ObjIRPF.montarDividas(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("19");
        this.conversor2ObjIRPF.montarDeclaracaoCompleta(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("21");
        this.conversor2ObjIRPF.montarRendPJTitularCompleta(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("32");
        this.conversor2ObjIRPF.montarRendPJDependentesCompleta(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("22");
        this.conversor2ObjIRPF.montarRendPFTitular(vetorRegistros, objDecl);
        this.conversor2ObjIRPF.montarRendPFDependentes(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("49");
        this.conversor2ObjIRPF.montarRendimentosPFTrabalhoNaoAssalariado(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("23");
        this.conversor2ObjIRPF.recuperarRendIsentosNaoTributaveis(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("17");
        this.conversor2ObjIRPF.montarFichaSimplificada(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("24");
        this.conversor2ObjIRPF.recuperarRendTributacaoExclusiva(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("88");
        this.conversor2ObjIRPF.montarRendimentosAplicacoesFinanceiras(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("88");
        this.conversor2ObjIRPF.montarJurosCapitalProprio(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("88");
        this.conversor2ObjIRPF.montarParticipacaoLucrosResultados(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("35");
        this.conversor2ObjIRPF.montarAlimentandos(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("25");
        this.conversor2ObjIRPF.montarDependentes(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("16");
        this.conversor2ObjIRPF.montarNITPISPASEPDeIdentificacaoEmRendPFTitular(vetorRegistros, objDecl.getRendPFTitular());
        vetorRegistros = this.arquivo.getRegistrosTxt("25");
        this.conversor2ObjIRPF.montarNITPISPASEPDeDependenteEmRendPFDependente(vetorRegistros, objDecl.getRendPFDependente());
        vetorRegistros = this.arquivo.getRegistrosTxt("26");
        this.conversor2ObjIRPF.montarPagamentos(vetorRegistros, objDecl);
        objDecl.getPagamentos().reordenaPorCodigo();
        vetorRegistros = this.arquivo.getRegistrosTxt("90");
        this.conversor2ObjIRPF.montarDoacoes(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("83");
        this.conversor2ObjIRPF.montarFicharRendimentoIsentoTipo2(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("84");
        this.conversor2ObjIRPF.montarFicharRendimentoIsentoTipo3(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("85");
        this.conversor2ObjIRPF.montarFicharRendimentoIsentoTipo4(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("86");
        this.conversor2ObjIRPF.montarFicharRendimentoIsentoTipo5(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("87");
        this.conversor2ObjIRPF.montarFicharRendimentoIsentoTipo6(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("89");
        this.conversor2ObjIRPF.montarOutrosRendimentosIsentosTributacaoExclusivaTipo12(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("91");
        this.conversor2ObjIRPF.montarEstatutoCriancaAdolescente(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("92");
        this.conversor2ObjIRPF.montarEstatutoIdoso(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("40");
        this.conversor2ObjIRPF.montarRendaVariavel(vetorRegistros, objDecl, false);
        vetorRegistros = this.arquivo.getRegistrosTxt("40");
        this.conversor2ObjIRPF.montarRendaVariavel(vetorRegistros, objDecl, true);
        vetorRegistros = this.arquivo.getRegistrosTxt("42");
        this.conversor2ObjIRPF.montarRendaVariavelFII(vetorRegistros, objDecl, false);
        vetorRegistros = this.arquivo.getRegistrosTxt("42");
        this.conversor2ObjIRPF.montarRendaVariavelFII(vetorRegistros, objDecl, true);
        if (objDecl.getIdentificadorDeclaracao().isAjuste()) {
            vetorRegistros = this.arquivo.getRegistrosTxt("30");
            this.conversor2ObjIRPF.montarInventariante(vetorRegistros, objDecl);
        } else if (objDecl.getIdentificadorDeclaracao().isEspolio()) {
            vetorRegistros = this.arquivo.getRegistrosTxt("38");
            this.conversor2ObjIRPF.montarFinalEspolio(vetorRegistros, objDecl);
            if (objDecl.getEspolio().isBensInventariarMarcado()) {
                vetorRegistros = this.arquivo.getRegistrosTxt("30");
                this.conversor2ObjIRPF.montarInventariante(vetorRegistros, objDecl);
            }
            vetorRegistros = this.arquivo.getRegistrosTxt("58");
            this.conversor2ObjIRPF.montarHerdeiros(vetorRegistros, objDecl);
            vetorRegistros = this.arquivo.getRegistrosTxt("59");
            this.conversor2ObjIRPF.montarPercentualParticipacaoInventario(vetorRegistros, objDecl);
        } else if (objDecl.getIdentificadorDeclaracao().isSaida()) {
            vetorRegistros = this.arquivo.getRegistrosTxt("39");
            this.conversor2ObjIRPF.montarSaida(vetorRegistros, objDecl);
        }
        vetorRegistros = this.arquivo.getRegistrosTxt("50");
        this.conversor2ObjIRPF.montarAtividadeRuralImoveis(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("54");
        this.conversor2ObjIRPF.montarAtividadeRuralBens(vetorRegistros, objDecl, recuperouPP);
        vetorRegistros = this.arquivo.getRegistrosTxt("55");
        this.conversor2ObjIRPF.montarAtividadeRuralDividas(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("53");
        this.conversor2ObjIRPF.montarAtividadeRuralMovimentacaoRebanho(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("51");
        this.conversor2ObjIRPF.montarAtividadeRuralReceitasDespesasBrasil(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("56");
        this.conversor2ObjIRPF.montarAtividadeRuralReceitasDespesasExterior(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("52");
        this.conversor2ObjIRPF.montarAtividadeRuralApuracaoResultado(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("57");
        this.conversor2ObjIRPF.montarAtividadeRuralProprietario(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("60");
        this.conversor2ObjIRPF.importaRegistro60(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("61");
        this.conversor2ObjIRPF.importaRegistro61(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("62");
        this.conversor2ObjIRPF.importaRegistro62(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("63");
        this.conversor2ObjIRPF.importaRegistro63(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("64");
        this.conversor2ObjIRPF.importaRegistro64(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("65");
        this.conversor2ObjIRPF.importaRegistro65(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("66");
        this.conversor2ObjIRPF.importaRegistro66(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("67");
        this.conversor2ObjIRPF.importaRegistro67(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("68");
        this.conversor2ObjIRPF.importaRegistro68(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("69");
        this.conversor2ObjIRPF.importaRegistro69(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("71");
        this.conversor2ObjIRPF.importaRegistro71(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("72");
        this.conversor2ObjIRPF.importaRegistro72(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("70");
        this.conversor2ObjIRPF.importaRegistro70(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("73");
        this.conversor2ObjIRPF.importaRegistro73(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("74");
        this.conversor2ObjIRPF.importaRegistro74(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("75");
        this.conversor2ObjIRPF.importaRegistro75(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("76");
        this.conversor2ObjIRPF.importaRegistro76(vetorRegistros, objDecl);
        objDecl.getGCAP().recalcularConsolidacoes();
        vetorRegistros = this.arquivo.getRegistrosTxt("80");
        this.conversor2ObjIRPF.montarRendPJExigTitular(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("81");
        this.conversor2ObjIRPF.montarRendPJExigDependente(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("45");
        this.conversor2ObjIRPF.montarRendAcmTitular(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("46");
        this.conversor2ObjIRPF.montarRendAcmTitularPensaoAlimenticia(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("47");
        this.conversor2ObjIRPF.montarRendAcmDependentes(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("48");
        this.conversor2ObjIRPF.montarRendAcmDependentesPensaoAlimenticia(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("34");
        this.conversor2ObjIRPF.montarDoacoesCampanha(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("16");
        this.conversor2ObjIRPF.montarContribuinteIRPF(vetorRegistros, objDecl.getContribuinte(), objDecl.getIdentificadorDeclaracao(), objDecl.getBens());
        this.conversor2ObjIRPF.montarInformacoesBancarias(vetorRegistros, objDecl);
        this.conversor2ObjIRPF.montarInformacoesObrigatorias(vetorRegistros, objDecl);
        objDecl.adicionaObservadoresCalculosLate();
        IRPFFacade.getInstancia().salvarDeclaracao(idDecl.getCpf().naoFormatado(), idDecl.getNumReciboTransmitido().naoFormatado());
        IRPFFacade.limpaCacheDeclaracoes();
        return objDecl;
    }

    public DeclaracaoIRPF recuperarDeclaracaoPersistenciaOnline(boolean realizarMerge, boolean salvarRecuperarOnline, String tipoDeclaracaoAES) throws GeracaoTxtException, IOException {
        this.lerDeclaracao();
        List vetorRegistros = this.arquivo.getRegistrosTxt("16");
        String cpf = null;
        if (vetorRegistros.size() > 0) {
            RegistroTxt objRegTXT = (RegistroTxt)vetorRegistros.get(0);
            cpf = objRegTXT.fieldByName("NR_CPF").asString();
            if (!realizarMerge) {
                if (IRPFFacade.existeDeclaracao((String)cpf, (String)"0000000000")) {
                    IRPFFacade.excluirDeclaracao((String)cpf, (String)"0000000000");
                }
                IdentificadorDeclaracao idDeclaracao = new IdentificadorDeclaracao();
                idDeclaracao.getCpf().setConteudo(cpf);
                idDeclaracao.getNumReciboTransmitido().setConteudo("0000000000");
                idDeclaracao.getTipoDeclaracaoAES().setConteudo(tipoDeclaracaoAES);
                IRPFFacade.criarDeclaracao((IdentificadorDeclaracao)idDeclaracao);
            } else if (!IRPFFacade.existeDeclaracao((String)cpf, (String)"0000000000")) {
                throw new GeracaoTxtException("Declara\u00e7\u00e3o n\u00e3o encontrada.");
            }
        } else {
            throw new GeracaoTxtException("Registro Identifica\u00e7\u00e3o do Contribuinte n\u00e3o encontrado");
        }
        DeclaracaoIRPF dec = IRPFFacade.getInstancia().recuperarDeclaracaoIRPF(cpf, "0000000000");
        try {
            this.recuperarIdentificadorDeclaracao(dec.getIdentificadorDeclaracao());
            vetorRegistros = this.arquivo.getRegistrosTxt("SR");
            this.conversor2ObjIRPF.montarIndicadoresPersistenciaOnline(vetorRegistros, dec.getIdentificadorDeclaracao(), salvarRecuperarOnline);
            vetorRegistros = this.arquivo.getRegistrosTxt("16");
            this.conversor2ObjIRPF.montarContribuinteIRPF(vetorRegistros, dec.getContribuinte(), dec.getIdentificadorDeclaracao(), dec.getBens(), realizarMerge, tipoDeclaracaoAES);
            vetorRegistros = this.arquivo.getRegistrosTxt("IP");
            this.conversor2ObjIRPF.montarFichaImpostoPago(vetorRegistros, dec);
            List vetorRegistrosDependentes = this.arquivo.getRegistrosTxt("25");
            this.conversor2ObjIRPF.montarDependentes(vetorRegistrosDependentes, dec, realizarMerge);
            vetorRegistros = this.arquivo.getRegistrosTxt("27");
            this.conversor2ObjIRPF.montarBem(vetorRegistros, dec, realizarMerge);
            vetorRegistros = this.arquivo.getRegistrosTxt("28");
            this.conversor2ObjIRPF.montarDividas(vetorRegistros, dec, realizarMerge);
            vetorRegistros = this.arquivo.getRegistrosTxt("21");
            this.conversor2ObjIRPF.montarRendPJTitularCompleta(vetorRegistros, dec, realizarMerge);
            vetorRegistros = this.arquivo.getRegistrosTxt("32");
            this.conversor2ObjIRPF.montarRendPJDependentesCompleta(vetorRegistros, dec, realizarMerge);
            vetorRegistros = this.arquivo.getRegistrosTxt("80");
            this.conversor2ObjIRPF.montarRendPJExigTitular(vetorRegistros, dec, realizarMerge);
            vetorRegistros = this.arquivo.getRegistrosTxt("81");
            this.conversor2ObjIRPF.montarRendPJExigDependente(vetorRegistros, dec, realizarMerge);
            vetorRegistros = this.arquivo.getRegistrosTxt("22");
            this.conversor2ObjIRPF.montarRendPFTitular(vetorRegistros, dec);
            this.conversor2ObjIRPF.montarRendPFDependentes(vetorRegistros, dec);
            vetorRegistros = this.arquivo.getRegistrosTxt("16");
            this.conversor2ObjIRPF.montarNITPISPASEPDeIdentificacaoEmRendPFTitular(vetorRegistros, dec.getRendPFTitular());
            vetorRegistros = this.arquivo.getRegistrosTxt("25");
            this.conversor2ObjIRPF.montarNITPISPASEPDeDependenteEmRendPFDependente(vetorRegistros, dec.getRendPFDependente());
            vetorRegistros = this.arquivo.getRegistrosTxt("49");
            this.conversor2ObjIRPF.montarRendimentosPFTrabalhoNaoAssalariado(vetorRegistros, dec);
            vetorRegistros = this.arquivo.getRegistrosTxt("23");
            this.conversor2ObjIRPF.recuperarRendIsentosNaoTributaveis(vetorRegistros, dec);
            vetorRegistros = this.arquivo.getRegistrosTxt("24");
            this.conversor2ObjIRPF.recuperarRendTributacaoExclusiva(vetorRegistros, dec);
            vetorRegistros = this.arquivo.getRegistrosTxt("88");
            this.conversor2ObjIRPF.montarRendimentosAplicacoesFinanceiras(vetorRegistros, dec);
            vetorRegistros = this.arquivo.getRegistrosTxt("88");
            this.conversor2ObjIRPF.montarJurosCapitalProprio(vetorRegistros, dec);
            vetorRegistros = this.arquivo.getRegistrosTxt("88");
            this.conversor2ObjIRPF.montarParticipacaoLucrosResultados(vetorRegistros, dec);
            vetorRegistros = this.arquivo.getRegistrosTxt("34");
            this.conversor2ObjIRPF.montarDoacoesCampanha(vetorRegistros, dec);
            List vetorRegistrosAlimentandos = this.arquivo.getRegistrosTxt("35");
            this.conversor2ObjIRPF.montarAlimentandos(vetorRegistrosAlimentandos, dec, realizarMerge);
            vetorRegistros = this.arquivo.getRegistrosTxt("26");
            if (realizarMerge) {
                this.conversor2ObjIRPF.montarPagamentosComMerge(vetorRegistros, dec, vetorRegistrosAlimentandos, vetorRegistrosDependentes);
            } else {
                this.conversor2ObjIRPF.montarPagamentos(vetorRegistros, dec);
            }
            List vetorRegistrosDoacoes = this.arquivo.getRegistrosTxt("90");
            this.conversor2ObjIRPF.montarDoacoes(vetorRegistrosDoacoes, dec);
            vetorRegistros = this.arquivo.getRegistrosTxt("91");
            this.conversor2ObjIRPF.montarEstatutoCriancaAdolescente(vetorRegistros, dec);
            vetorRegistros = this.arquivo.getRegistrosTxt("92");
            this.conversor2ObjIRPF.montarEstatutoIdoso(vetorRegistros, dec);
            vetorRegistros = this.arquivo.getRegistrosTxt("40");
            this.conversor2ObjIRPF.montarRendaVariavel(vetorRegistros, dec, false);
            vetorRegistros = this.arquivo.getRegistrosTxt("40");
            this.conversor2ObjIRPF.montarRendaVariavel(vetorRegistros, dec, true);
            vetorRegistros = this.arquivo.getRegistrosTxt("42");
            this.conversor2ObjIRPF.montarRendaVariavelFII(vetorRegistros, dec, false);
            vetorRegistros = this.arquivo.getRegistrosTxt("42");
            this.conversor2ObjIRPF.montarRendaVariavelFII(vetorRegistros, dec, true);
            if (dec.getIdentificadorDeclaracao().isAjuste()) {
                vetorRegistros = this.arquivo.getRegistrosTxt("30");
                this.conversor2ObjIRPF.montarInventariante(vetorRegistros, dec);
            }
            vetorRegistros = this.arquivo.getRegistrosTxt("83");
            this.conversor2ObjIRPF.montarFicharRendimentoIsentoTipo2(vetorRegistros, dec);
            vetorRegistros = this.arquivo.getRegistrosTxt("84");
            this.conversor2ObjIRPF.montarFicharRendimentoIsentoTipo3(vetorRegistros, dec);
            vetorRegistros = this.arquivo.getRegistrosTxt("85");
            this.conversor2ObjIRPF.montarFicharRendimentoIsentoTipo4(vetorRegistros, dec);
            vetorRegistros = this.arquivo.getRegistrosTxt("86");
            this.conversor2ObjIRPF.montarFicharRendimentoIsentoTipo5(vetorRegistros, dec);
            vetorRegistros = this.arquivo.getRegistrosTxt("87");
            this.conversor2ObjIRPF.montarFicharRendimentoIsentoTipo6(vetorRegistros, dec);
            vetorRegistros = this.arquivo.getRegistrosTxt("89");
            this.conversor2ObjIRPF.montarOutrosRendimentosIsentosTributacaoExclusivaTipo12(vetorRegistros, dec);
            vetorRegistros = this.arquivo.getRegistrosTxt("45");
            this.conversor2ObjIRPF.montarRendAcmTitular(vetorRegistros, dec);
            vetorRegistros = this.arquivo.getRegistrosTxt("46");
            this.conversor2ObjIRPF.montarRendAcmTitularPensaoAlimenticia(vetorRegistros, dec);
            vetorRegistros = this.arquivo.getRegistrosTxt("47");
            this.conversor2ObjIRPF.montarRendAcmDependentes(vetorRegistros, dec);
            vetorRegistros = this.arquivo.getRegistrosTxt("48");
            this.conversor2ObjIRPF.montarRendAcmDependentesPensaoAlimenticia(vetorRegistros, dec);
            vetorRegistros = this.arquivo.getRegistrosTxt("16");
            this.conversor2ObjIRPF.montarInformacoesBancarias(vetorRegistros, dec);
            this.conversor2ObjIRPF.montarInformacoesObrigatorias(vetorRegistros, dec);
        }
        catch (IOException | GeracaoTxtException e) {
            IRPFFacade.excluirDeclaracao((String)cpf, (String)"0000000000");
            throw e;
        }
        dec.adicionaObservadoresCalculosLate();
        IRPFFacade.getInstancia().salvarDeclaracao(dec);
        IRPFFacade.limpaCacheDeclaracoes();
        return dec;
    }

    public void gravarDeclaracaoPersistenciaOnline(DeclaracaoIRPF dec) throws GeracaoTxtException, IOException {
        dec.getIdentificadorDeclaracao().getInUtilizouSalvarRecuperarOnLine().setConteudo(Logico.SIM);
        this.montarDeclaracaoPersistenciaOnline(dec);
        this.arquivo.salvar();
        IRPFFacade.getInstancia().salvarDeclaracao(dec);
    }

    public void montarDeclaracaoPersistenciaOnline(DeclaracaoIRPF dec) throws GeracaoTxtException {
        this.arquivo.clear();
        List<RegistroTxt> vetorRegistros = this.conversor2Registros.montarRegistroHeaderSR(dec.getIdentificadorDeclaracao());
        this.arquivo.setFicha(vetorRegistros, false);
        vetorRegistros = this.conversor2Registros.montarRegistroImpostoPago(dec);
        this.arquivo.setFicha(vetorRegistros, false);
        vetorRegistros = this.conversor2Registros.montarRegistroContribuinte(dec);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaRendPJ(dec);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaRendPJDependente(dec);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaRendPF(dec, false);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaRendPF(dec, true);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaRendPFTrabalhoNaoAssalariado(dec);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaRendIsentos(dec);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaRendTribExcl(dec);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaRendPJExigTitular(dec);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaRendPJExigDependente(dec);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaEstatutoCriancaAdolescente(dec);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaEstatutoIdoso(dec);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaDependentes(dec);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaPagamentos(dec);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaBem(dec);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaDividas(dec);
        this.arquivo.setFicha(vetorRegistros);
        if (dec.getIdentificadorDeclaracao().isAjuste()) {
            vetorRegistros = this.conversor2Registros.montarFichaInventariante(dec);
            this.arquivo.setFicha(vetorRegistros);
        }
        vetorRegistros = this.conversor2Registros.montarFichaDoacoesCampanha(dec);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaAlimentandos(dec);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaRendIsentosTipo2(dec);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaRendIsentosTipo3(dec);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaRendIsentosTipo4(dec);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaRendIsentosTipo5(dec);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaRendIsentosTipo6(dec);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaParcelaIsentaAposentadoria(dec);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaSocio(dec);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaRendExclusivoTipo2(dec);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaOutrosRendimentosIsentos(dec);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaOutrosRendimentosExclusivosTipo3(dec);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaDoacoes(dec);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaRendAcmTitular(dec);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaRendAcmTitularPensao(dec);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaRendAcmDependentes(dec);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaRendAcmDependentesPensao(dec);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaRendaVariavelFII(dec, false);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaRendaVariavelFII(dec, true);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaRendaVariavelTotaisFII(dec);
        this.arquivo.setFicha(vetorRegistros);
    }

    public void gravarDeclaracao(IdentificadorDeclaracao objIdDecl) throws GeracaoTxtException, IOException {
        DeclaracaoIRPF objDecl = IRPFFacade.getInstancia().recuperarDeclaracaoIRPF(objIdDecl.getCpf().naoFormatado(), objIdDecl.getNumReciboTransmitido().naoFormatado());
        this.atualizarDeclaracao(objDecl);
        String hash = this.arquivo.calcularHash();
        List<RegistroTxt> vRegistros = this.conversor2Registros.montarRegistroHeader(objDecl);
        this.arquivo.atualizaHeader(vRegistros, hash);
        vRegistros = this.conversor2Registros.montarRecibo(objDecl);
        this.arquivo.incluirRecibo(vRegistros, hash);
        this.arquivo.salvar();
        IRPFFacade.getInstancia().salvarDeclaracao(objIdDecl.getCpf().naoFormatado(), objIdDecl.getNumReciboTransmitido().naoFormatado());
        IRPFFacade.limpaCacheDeclaracoes();
    }

    public void gravarDeclaracaoAberta() throws GeracaoTxtException, IOException {
        DeclaracaoIRPF objDecl = IRPFFacade.getInstancia().getDeclaracao();
        this.atualizarDeclaracao(objDecl);
        String hash = this.arquivo.calcularHash();
        List<RegistroTxt> vRegistros = this.conversor2Registros.montarRegistroHeader(objDecl);
        this.arquivo.atualizaHeader(vRegistros, hash);
        vRegistros = this.conversor2Registros.montarRecibo(objDecl);
        this.arquivo.incluirRecibo(vRegistros, hash);
        this.arquivo.salvar();
        IRPFFacade.getInstancia().salvarDeclaracaoAberta();
    }

    public void salvarDeclaracao(IdentificadorDeclaracao objIdDecl) throws GeracaoTxtException, IOException {
        DeclaracaoIRPF objDecl = IRPFFacade.getInstancia().recuperarDeclaracaoIRPF(objIdDecl.getCpf().naoFormatado(), objIdDecl.getNumReciboTransmitido().naoFormatado());
        this.atualizarDeclaracao(objDecl);
        String hash = this.arquivo.calcularHash();
        List<RegistroTxt> vRegistros = this.conversor2Registros.montarRegistroHeader(objDecl);
        this.arquivo.atualizaHeader(vRegistros, hash);
        Charset cset = this.getCharset();
        if (cset != null) {
            this.arquivo.salvar(cset);
        } else {
            this.arquivo.salvar();
        }
    }

    public void atualizarDeclaracao(DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        boolean gravarRegistrosDaCompleta = objDecl.getIdentificadorDeclaracao().isCompleta();
        this.arquivo.clear();
        List<RegistroTxt> vetorRegistros = this.conversor2Registros.montarRegistroHeader(objDecl);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarRegistroContribuinte(objDecl);
        this.arquivo.setFicha(vetorRegistros);
        if (gravarRegistrosDaCompleta) {
            vetorRegistros = this.conversor2Registros.montarRegistroDeclaracaoCompleta(objDecl);
            this.arquivo.setFicha(vetorRegistros);
            vetorRegistros = this.conversor2Registros.montarFichaResumoCompleta(objDecl);
            this.arquivo.setFicha(vetorRegistros);
        } else {
            vetorRegistros = this.conversor2Registros.montarFichaSimplificada(objDecl);
            this.arquivo.setFicha(vetorRegistros);
            vetorRegistros = this.conversor2Registros.montarFichaResumoSimplificada(objDecl);
            this.arquivo.setFicha(vetorRegistros);
        }
        vetorRegistros = this.conversor2Registros.montarFichaRendPJ(objDecl);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaRendPF(objDecl, false);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaRendPF(objDecl, true);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaRendIsentos(objDecl);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaRendTribExcl(objDecl);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaDependentes(objDecl);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaPagamentos(objDecl);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaBem(objDecl);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaDividas(objDecl);
        this.arquivo.setFicha(vetorRegistros);
        if (objDecl.getIdentificadorDeclaracao().isAjuste() || objDecl.getEspolio().isBensInventariarMarcado()) {
            vetorRegistros = this.conversor2Registros.montarFichaInventariante(objDecl);
            this.arquivo.setFicha(vetorRegistros);
        }
        vetorRegistros = this.conversor2Registros.montarFichaRendPJDependente(objDecl);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaDoacoesCampanha(objDecl);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaAlimentandos(objDecl);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarREG36_BensDireitosProprietarioUsufrutuario(objDecl);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarRegistro37RendimentosAplicacoesFinanceirasExterior(objDecl);
        this.arquivo.setFicha(vetorRegistros);
        if (objDecl.getIdentificadorDeclaracao().isEspolio()) {
            vetorRegistros = this.conversor2Registros.montarFichaFinalEspolio(objDecl);
            this.arquivo.setFicha(vetorRegistros);
        } else if (objDecl.getIdentificadorDeclaracao().isSaida()) {
            vetorRegistros = this.conversor2Registros.montarFichaSaida(objDecl);
            this.arquivo.setFicha(vetorRegistros);
        }
        if (!objDecl.getRendaVariavel().isVazio()) {
            vetorRegistros = this.conversor2Registros.montarFichaRendaVariavel(objDecl, false);
            this.arquivo.setFicha(vetorRegistros);
        }
        if (!objDecl.getRendaVariavelDependente().isVazio()) {
            vetorRegistros = this.conversor2Registros.montarFichaRendaVariavel(objDecl, true);
            this.arquivo.setFicha(vetorRegistros);
        }
        if (!objDecl.getRendaVariavel().isVazio() || !objDecl.getRendaVariavelDependente().isVazio()) {
            vetorRegistros = this.conversor2Registros.montarFichaRendaVariavelAnual(objDecl);
            this.arquivo.setFicha(vetorRegistros);
        }
        if (!objDecl.getFundosInvestimentos().isVazio()) {
            vetorRegistros = this.conversor2Registros.montarFichaRendaVariavelFII(objDecl, false);
            this.arquivo.setFicha(vetorRegistros);
        }
        if (!objDecl.getFundosInvestimentosDependente().isVazio()) {
            vetorRegistros = this.conversor2Registros.montarFichaRendaVariavelFII(objDecl, true);
            this.arquivo.setFicha(vetorRegistros);
        }
        if (!objDecl.getFundosInvestimentos().isVazio() || !objDecl.getFundosInvestimentosDependente().isVazio()) {
            vetorRegistros = this.conversor2Registros.montarFichaRendaVariavelTotaisFII(objDecl);
            this.arquivo.setFicha(vetorRegistros);
        }
        vetorRegistros = this.conversor2Registros.montarFichaRendAcmTitular(objDecl);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaRendAcmTitularPensao(objDecl);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaRendAcmDependentes(objDecl);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaRendAcmDependentesPensao(objDecl);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaRendPFTrabalhoNaoAssalariado(objDecl);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaAtividadeRuralIdentificacaoImovel(objDecl);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaAtividadeRuralReceitasDespesasBrasil(objDecl);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaAtividadeRuralApuracaoResultado(objDecl);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaAtividadeRuralMovimentacaoRebanho(objDecl);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaAtividadeRuralBens(objDecl);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaAtividadeRuralDividas(objDecl);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaAtividadeRuralReceitasDespesasExterior(objDecl);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarREG57_AtividadeRuralProprietario(objDecl);
        this.arquivo.setFicha(vetorRegistros);
        if (objDecl.getIdentificadorDeclaracao().isEspolio()) {
            vetorRegistros = this.conversor2Registros.montarFichaHerdeiros(objDecl);
            this.arquivo.setFicha(vetorRegistros);
            vetorRegistros = this.conversor2Registros.montarFichaPercentualBem(objDecl);
            this.arquivo.setFicha(vetorRegistros);
        }
        vetorRegistros = this.conversor2Registros.montarRegistro60(objDecl);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarRegistro61(objDecl);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarRegistro62(objDecl);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarRegistro63(objDecl);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarRegistro64(objDecl);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarRegistro65(objDecl);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarRegistro66(objDecl);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarRegistro67(objDecl);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarRegistro68(objDecl);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarRegistro69(objDecl);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarRegistro70(objDecl);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarRegistro71(objDecl);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarRegistro72(objDecl);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarRegistro73(objDecl);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarRegistro74(objDecl);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarRegistro75(objDecl);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarRegistro76(objDecl);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaRendPJExigTitular(objDecl);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaRendPJExigDependente(objDecl);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaRendIsentosTipo2(objDecl);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaRendIsentosTipo3(objDecl);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaRendIsentosTipo4(objDecl);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaRendIsentosTipo5(objDecl);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaRendIsentosTipo6(objDecl);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaParcelaIsentaAposentadoria(objDecl);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaSocio(objDecl);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaRendExclusivoTipo2(objDecl);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaOutrosRendimentosIsentos(objDecl);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaOutrosRendimentosExclusivosTipo3(objDecl);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaDoacoes(objDecl);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaEstatutoCriancaAdolescente(objDecl);
        this.arquivo.setFicha(vetorRegistros);
        vetorRegistros = this.conversor2Registros.montarFichaEstatutoIdoso(objDecl);
        this.arquivo.setFicha(vetorRegistros);
        this.arquivo.incluirTrailler(objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado());
    }

    public void importarDeclaracaoAnoAnterior(IdentificadorDeclaracao idDecl, TipoDeclaracaoAES tipoDeclaracaoAES, boolean prePreenchida) throws GeracaoTxtException {
        boolean prePreenchidaApenasComRegistro16;
        boolean bl = prePreenchidaApenasComRegistro16 = prePreenchida && ((String)this.arquivo.arquivo().get(0)).startsWith("16");
        if (!prePreenchidaApenasComRegistro16) {
            this.arquivo.validarHeaderAnoAnt(idDecl, this.getValidaHash());
        }
        DeclaracaoIRPF objDecl = IRPFFacade.getInstancia().recuperarDeclaracaoIRPF(idDecl.getCpf().naoFormatado(), idDecl.getNumReciboTransmitido().naoFormatado());
        List vetorRegistros = this.arquivo.getRegistrosTxt("16");
        String NitTitular = ((RegistroTxt)vetorRegistros.get(0)).fieldByName("NR_NITPISPASEP").asString();
        this.conversor2ObjIRPF.montarContribuinteIRPFAnoAnterior(vetorRegistros, objDecl.getContribuinte(), idDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("27");
        this.conversor2ObjIRPF.montarBensAnoAnterior(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("28");
        this.conversor2ObjIRPF.montarDividasAnoAnterior(vetorRegistros, objDecl);
        if (!tipoDeclaracaoAES.equals((Object)TipoDeclaracaoAES.ESPOLIO)) {
            vetorRegistros = this.arquivo.getRegistrosTxt("29");
            this.conversor2ObjIRPF.montarConjugeAnoAnterior(vetorRegistros, objDecl);
        }
        vetorRegistros = this.arquivo.getRegistrosTxt("25");
        this.conversor2ObjIRPF.montarDependentesAnoAnterior(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("35");
        this.conversor2ObjIRPF.montarAlimentandosAnoAnterior(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("21");
        this.conversor2ObjIRPF.montarRendPJTitularAnoAnterior(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("32");
        this.conversor2ObjIRPF.montarRendPJDependentesAnoAnterior(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("26");
        this.conversor2ObjIRPF.montarPagamentosAnoAnterior(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("30");
        this.conversor2ObjIRPF.montarInventarianteAnoAnterior(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("33");
        this.conversor2ObjIRPF.montarLucrosDividendosAnoAnterior(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("31");
        this.conversor2ObjIRPF.montarPensaoAnoAnterior(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("84");
        this.conversor2ObjIRPF.montarFicharRendimentoIsentoTipo3AnoAnterior(vetorRegistros, objDecl, new String[]{"0009", "0010", "0012", "0013"});
        vetorRegistros = this.arquivo.getRegistrosTxt("85");
        this.conversor2ObjIRPF.montarFicharRendimentoIsentoTipo4AnoAnterior(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("88");
        this.conversor2ObjIRPF.montarRendimentosAplicacoesFinanceirasAnoAnterior(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("88");
        this.conversor2ObjIRPF.montarJurosCapitalProprioAnoAnterior(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("88");
        this.conversor2ObjIRPF.montarParticipacaoLucrosResultadosAnoAnterior(vetorRegistros, objDecl);
        idDecl.getDeclaracaoRetificadora().clear();
        idDecl.getNumReciboDecRetif().clear();
        objDecl.getIdentificadorDeclaracao().getEnderecoDiferente().clear();
        vetorRegistros = this.arquivo.getRegistrosTxt("50");
        this.conversor2ObjIRPF.montarAtividadeRuralImoveisAnoAnterior(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("52");
        this.conversor2ObjIRPF.montarAtividadeRuralApuracaoResultadoAnoAnterior(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("54");
        this.conversor2ObjIRPF.montarAtividadeRuralBensAnoAnterior(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("55");
        this.conversor2ObjIRPF.montarAtividadeRuralDividasAnoAnterior(vetorRegistros, objDecl);
        vetorRegistros = this.arquivo.getRegistrosTxt("53");
        this.conversor2ObjIRPF.montarAtividadeRuralMovimentacaoRebanhoAnoAnterior(vetorRegistros, objDecl);
        objDecl.getDependentes().excluirDependentesCadastradosComoAlimentando(objDecl);
        objDecl.getRendPFTitular().getNITPISPASEP().setConteudo(NitTitular);
        IRPFFacade.getInstancia().salvarDeclaracao(idDecl.getCpf().naoFormatado(), idDecl.getNumReciboTransmitido().naoFormatado());
        IRPFFacade.limpaCacheDeclaracoes();
    }

    public void validarDeclaracao() throws Exception {
        if (this.objIdArquivo == null) {
            this.objIdArquivo = this.recuperarIdDeclaracao();
        }
        this.arquivo.validarCRC();
        this.arquivo.validarHeader(this.objIdArquivo);
    }

    public void validarDeclaracaoNaoPersistido() throws GeracaoTxtException, IOException {
        if (this.objIdArquivo == null) {
            this.objIdArquivo = this.recuperarIdDeclaracaoNaoPersistido();
        }
        this.arquivo.validarCRC();
        this.arquivo.validarHeader(this.objIdArquivo);
    }

    public void lerDeclaracao() throws GeracaoTxtException, IOException {
        if (this.arquivo == null) {
            this.arquivo = new DocumentoAjusteTXT("ARQ_IRPF", this.file.getPath());
        }
        if (!this.fLido) {
            this.arquivo.ler();
        }
        this.fLido = true;
    }

    public void lerDeclaracaoValidando() throws GeracaoTxtException, IOException {
        if (this.arquivo == null) {
            this.arquivo = new DocumentoAjusteTXT("ARQ_IRPF", this.file.getPath());
        }
        if (!this.fLido) {
            this.arquivo.ler();
        }
        this.arquivo.validarHashsDeclaracao();
        this.fLido = true;
    }

    public RegistroTxt recuperarRegistroHeader() throws GeracaoTxtException, IOException {
        this.lerDeclaracao();
        List vetorHeader = this.arquivo.getRegistrosTxt("IR");
        return this.conversor2ObjIRPF.getRegistroHeader(vetorHeader);
    }

    public RegistroTxt recuperarRegistroIdentificacao() throws GeracaoTxtException, IOException {
        this.lerDeclaracao();
        List vetorRegistros = this.arquivo.getRegistrosTxt("16");
        return (RegistroTxt)vetorRegistros.get(0);
    }

    public RegistroTxt recuperarRegistroFinalEspolio() throws GeracaoTxtException, IOException {
        this.lerDeclaracao();
        List vetorRegistros = this.arquivo.getRegistrosTxt("38");
        return (RegistroTxt)vetorRegistros.get(0);
    }

    public RegistroTxt recuperarRegistroSaida() throws GeracaoTxtException, IOException {
        this.lerDeclaracao();
        List vetorRegistros = this.arquivo.getRegistrosTxt("39");
        return (RegistroTxt)vetorRegistros.get(0);
    }

    public RegistroTxt recuperarRegistroRecibo() throws GeracaoTxtException, IOException {
        this.lerDeclaracao();
        List vetorRecibo = this.arquivo.getRegistrosTxt("DR");
        return this.conversor2ObjIRPF.getRegistroRecibo(vetorRecibo);
    }

    public RegistroTxt recuperarRegistroComplementoRecibo() throws GeracaoTxtException, IOException {
        this.lerDeclaracao();
        List vetorRecibo = this.arquivo.getRegistrosTxt("RC");
        return this.conversor2ObjIRPF.getRegistroRecibo(vetorRecibo);
    }

    public RegistroTxt recuperarRegistroComplementoReciboMulta() throws GeracaoTxtException, IOException {
        this.lerDeclaracao();
        List vetorRecibo = this.arquivo.getRegistrosTxt("NC");
        if (vetorRecibo.isEmpty()) {
            return null;
        }
        return this.conversor2ObjIRPF.getRegistroRecibo(vetorRecibo);
    }

    public RegistroTxt recuperarRegistroComplementoReciboValidador() throws GeracaoTxtException, IOException {
        this.lerDeclaracao();
        List vetorRecibo = this.arquivo.getRegistrosTxt("VC");
        if (vetorRecibo.isEmpty()) {
            return null;
        }
        return this.conversor2ObjIRPF.getRegistroRecibo(vetorRecibo);
    }

    public String getPath() {
        return this.file.getPath();
    }

    private boolean getValidaHash() {
        return !UtilitariosArquivo.extraiExtensaoAquivo((String)this.getPath()).toUpperCase().equals(".F2B");
    }

    public void validarComplementoRecibo(IdentificadorDeclaracao idDecl) throws GeracaoTxtException, IOException {
        this.lerDeclaracao();
        this.arquivo.validarCRCAcumulado();
        this.arquivo.validarComplRecibo(idDecl);
    }

    public DocumentoAjusteTXT getArquivo() {
        return this.arquivo;
    }

    public boolean isIncluiCharsEspeciais() {
        return this.incluiCharsEspeciais;
    }

    public void setIncluiCharsEspeciais(boolean incluiCharsEspeciais) {
        this.incluiCharsEspeciais = incluiCharsEspeciais;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public static void main(String[] args) {
        try {
            File fileRec = new File("/home/lucas/ProgramasRFB/IRPF2021/transmitidas/11123920761-IRPF-A-2021-2020-ORIGI.REC");
            RepositorioDeclaracaoCentralTxt repositorioDeclaracaoCentralTxt = new RepositorioDeclaracaoCentralTxt("ARQ_COMPLRECIBO", fileRec);
            Map<String, String> mapAuxilio = repositorioDeclaracaoCentralTxt.recuperarValoresAuxilioEmergencial();
            for (String chave : mapAuxilio.keySet()) {
                System.out.println(chave + ": " + mapAuxilio.get(chave));
            }
        }
        catch (Exception ex) {
            System.out.println("ERRO: " + ex.getMessage());
        }
    }
}

