/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.txt.gravacaorestauracao;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import serpro.hash.Crc32;
import serpro.ppgd.formatosexternos.txt.RegistroTxt;
import serpro.ppgd.formatosexternos.txt.excecao.GeracaoTxtException;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.ValorPositivo;
import serpro.ppgd.irpf.alimentandos.Alimentando;
import serpro.ppgd.irpf.alimentandos.Alimentandos;
import serpro.ppgd.irpf.atividaderural.AtividadeRural;
import serpro.ppgd.irpf.atividaderural.BemAR;
import serpro.ppgd.irpf.atividaderural.DividaAR;
import serpro.ppgd.irpf.atividaderural.ImovelAR;
import serpro.ppgd.irpf.atividaderural.ItemMovimentacaoRebanho;
import serpro.ppgd.irpf.atividaderural.MovimentacaoRebanho;
import serpro.ppgd.irpf.atividaderural.ParticipanteImovelAR;
import serpro.ppgd.irpf.atividaderural.brasil.ARBrasil;
import serpro.ppgd.irpf.atividaderural.brasil.ApuracaoResultadoBrasil;
import serpro.ppgd.irpf.atividaderural.brasil.ImovelARBrasil;
import serpro.ppgd.irpf.atividaderural.brasil.MesReceitaDespesa;
import serpro.ppgd.irpf.atividaderural.brasil.ReceitasDespesas;
import serpro.ppgd.irpf.atividaderural.exterior.ARExterior;
import serpro.ppgd.irpf.atividaderural.exterior.ApuracaoResultadoExterior;
import serpro.ppgd.irpf.atividaderural.exterior.ReceitaDespesa;
import serpro.ppgd.irpf.bens.Bem;
import serpro.ppgd.irpf.bens.Bens;
import serpro.ppgd.irpf.bens.ItemPercentualParticipacaoInventario;
import serpro.ppgd.irpf.bens.ProprietarioUsufrutuarioBem;
import serpro.ppgd.irpf.bens.RendimentoAplicacoesFinanceiras;
import serpro.ppgd.irpf.calculos.CalculosPagamentos;
import serpro.ppgd.irpf.contribuinte.Contribuinte;
import serpro.ppgd.irpf.dependentes.Dependente;
import serpro.ppgd.irpf.dependentes.Dependentes;
import serpro.ppgd.irpf.dividas.Divida;
import serpro.ppgd.irpf.dividas.Dividas;
import serpro.ppgd.irpf.doacaodeclaracao.ColecaoEstatutoCriancaAdolescente;
import serpro.ppgd.irpf.doacaodeclaracao.ColecaoEstatutoIdoso;
import serpro.ppgd.irpf.doacaodeclaracao.EstatutoCriancaAdolescente;
import serpro.ppgd.irpf.doacaodeclaracao.EstatutoIdoso;
import serpro.ppgd.irpf.doacoes.Doacao;
import serpro.ppgd.irpf.doacoes.Doacoes;
import serpro.ppgd.irpf.eleicoes.DoacaoEleitoral;
import serpro.ppgd.irpf.eleicoes.DoacoesEleitorais;
import serpro.ppgd.irpf.espolio.Espolio;
import serpro.ppgd.irpf.espolio.EspolioDecisaoJudicial;
import serpro.ppgd.irpf.espolio.EspolioEscrituracaoPublica;
import serpro.ppgd.irpf.espolio.EspolioPartilha;
import serpro.ppgd.irpf.exception.AplicacaoException;
import serpro.ppgd.irpf.gcap.IdDemonstrativoGCAP;
import serpro.ppgd.irpf.gcap.adquirente.Adquirente;
import serpro.ppgd.irpf.gcap.alienacao.Alienacao;
import serpro.ppgd.irpf.gcap.alienacao.AlienacaoBemImovel;
import serpro.ppgd.irpf.gcap.alienacao.AlienacaoBemMovel;
import serpro.ppgd.irpf.gcap.alienacao.AlienacaoParticipacaoSocietaria;
import serpro.ppgd.irpf.gcap.alienacao.ParcelaAlienacao;
import serpro.ppgd.irpf.gcap.alienacao.ParcelaAlienacaoBem;
import serpro.ppgd.irpf.gcap.apuracao.ApuracaoBemImovel;
import serpro.ppgd.irpf.gcap.apuracao.ApuracaoBemMovel;
import serpro.ppgd.irpf.gcap.apuracao.ParcelaApuracaoCustoAquisicao;
import serpro.ppgd.irpf.gcap.aquisicao.ParcelaAquisicao;
import serpro.ppgd.irpf.gcap.calculo.CalculoImposto;
import serpro.ppgd.irpf.gcap.consolidacao.Consolidacao;
import serpro.ppgd.irpf.gcap.consolidacao.ConsolidacaoEspecie;
import serpro.ppgd.irpf.gcap.especie.MoedaAlienada;
import serpro.ppgd.irpf.gcap.especie.MoedasAlienadasMensal;
import serpro.ppgd.irpf.gcap.especie.OperacaoEspecie;
import serpro.ppgd.irpf.gcap.especie.TotalizacaoMoedasAlienadas;
import serpro.ppgd.irpf.gcap.psocietarias.ParcelaAquisicaoParticipacaoSocietaria;
import serpro.ppgd.irpf.herdeiros.Herdeiro;
import serpro.ppgd.irpf.herdeiros.Herdeiros;
import serpro.ppgd.irpf.pagamentos.Pagamento;
import serpro.ppgd.irpf.pagamentos.Pagamentos;
import serpro.ppgd.irpf.rendIsentos.ColecaoItemQuadroTransporteDetalhado;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroMeacaoDissolucao;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroOutrosRendimentos;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroPensaoAlimenticia;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroPensaoMolestiaGrave;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroTransporteDetalhado;
import serpro.ppgd.irpf.rendIsentos.RendIsentos;
import serpro.ppgd.irpf.rendTributacaoExclusiva.RendTributacaoExclusiva;
import serpro.ppgd.irpf.rendacm.ColecaoRendAcmDependente;
import serpro.ppgd.irpf.rendacm.ColecaoRendAcmTitular;
import serpro.ppgd.irpf.rendacm.RendAcm;
import serpro.ppgd.irpf.rendacm.RendAcmDependente;
import serpro.ppgd.irpf.rendacm.RendAcmTitular;
import serpro.ppgd.irpf.rendavariavel.ColecaoRendaVariavelDependente;
import serpro.ppgd.irpf.rendavariavel.FundosInvestimentos;
import serpro.ppgd.irpf.rendavariavel.GanhosLiquidosOuPerdas;
import serpro.ppgd.irpf.rendavariavel.ItemFundosInvestimentosDependente;
import serpro.ppgd.irpf.rendavariavel.ItemRendaVariavelDependente;
import serpro.ppgd.irpf.rendavariavel.MesFundosInvestimentos;
import serpro.ppgd.irpf.rendavariavel.Operacoes;
import serpro.ppgd.irpf.rendavariavel.RendaVariavel;
import serpro.ppgd.irpf.rendpf.ColecaoRendPFDependente;
import serpro.ppgd.irpf.rendpf.Conta;
import serpro.ppgd.irpf.rendpf.ContasMes;
import serpro.ppgd.irpf.rendpf.ItemRendPFDependente;
import serpro.ppgd.irpf.rendpf.MesRendPF;
import serpro.ppgd.irpf.rendpf.RendPF;
import serpro.ppgd.irpf.rendpj.ColecaoRendPJDependente;
import serpro.ppgd.irpf.rendpj.ColecaoRendPJTitular;
import serpro.ppgd.irpf.rendpj.RendPJDependente;
import serpro.ppgd.irpf.rendpj.RendPJTitular;
import serpro.ppgd.irpf.rendpjexigibilidade.ColecaoRendPJComExigibilidadeDependente;
import serpro.ppgd.irpf.rendpjexigibilidade.ColecaoRendPJComExigibilidadeTitular;
import serpro.ppgd.irpf.rendpjexigibilidade.RendPJComExigibilidadeDependente;
import serpro.ppgd.irpf.rendpjexigibilidade.RendPJComExigibilidadeTitular;
import serpro.ppgd.irpf.saida.Saida;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.irpf.tabelas.CodigoTabelaMensagens;
import serpro.ppgd.irpf.tabelas.TabelaDatasIRPF;
import serpro.ppgd.irpf.txt.gravacaorestauracao.ConstantesRepositorio;
import serpro.ppgd.irpf.util.ConstantesGlobaisIRPF;
import serpro.ppgd.irpf.util.IRPFUtil;
import serpro.ppgd.irpf.util.QuadroAuxiliarUtil;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.RetornosValidacoes;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.util.PLong;

public class ConversorObjetosIRPF2Registros {
    public static String calcularHashCRC32(String pTexto) {
        PLong pLong = new PLong();
        Crc32 crc32 = new Crc32();
        pLong.setValue(0L);
        crc32.CalcCrc32(pTexto, pTexto.length(), pLong);
        return crc32.getStrCrc32();
    }

    public List<RegistroTxt> montarRegistroHeader(DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        NI[] maioresNis;
        String dataNascimento;
        String cpfSextoMaiorDepPagador;
        String cpfQuintoMaiorDepPagador;
        String cpfQuartoMaiorDepPagador;
        String cpfTerceiroMaiorDepPagador;
        String cpfSegundoMaiorDepPagador;
        String cpfMaiorDep;
        String NIBaseQuartaPagadora;
        String NIBaseTerceiraPagadora;
        String NIBaseSegundaPagadora;
        ArrayList<RegistroTxt> linha = new ArrayList<RegistroTxt>();
        RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "IR");
        objRegTXT.fieldByName("SISTEMA").set("IRPF");
        objRegTXT.fieldByName("EXERCICIO").set(ConstantesGlobais.EXERCICIO);
        objRegTXT.fieldByName("ANO_BASE").set(ConstantesGlobais.ANO_BASE);
        if (objDecl.getIdentificadorDeclaracao().isEspolio()) {
            objRegTXT.fieldByName("CODIGO_RECNET").set(3521);
        } else if (objDecl.getIdentificadorDeclaracao().isSaida()) {
            objRegTXT.fieldByName("CODIGO_RECNET").set(3520);
        } else {
            objRegTXT.fieldByName("CODIGO_RECNET").set(3500);
        }
        if (objDecl.getIdentificadorDeclaracao().isEspolio()) {
            Data dtAux = new Data(null, "");
            dtAux.setConteudo("01/03/" + ConstantesGlobais.EXERCICIO);
            Data dtTransito = objDecl.getEspolio().obterDataTransitoJulgadoOuLavraturaParaCalculos();
            if (dtTransito != null && (dtTransito.naoFormatado().equals(dtAux.naoFormatado()) || dtTransito.maisNova(dtAux))) {
                Object dtInvertida = dtTransito.naoFormatado();
                dtInvertida = ((String)dtInvertida).substring(4, 8) + ((String)dtInvertida).substring(2, 4) + ((String)dtInvertida).substring(0, 2);
                objRegTXT.fieldByName("DATA_TRANSITO_JULGADO").set((String)dtInvertida);
            }
        }
        if (objDecl.getIdentificadorDeclaracao().getDeclaracaoRetificadora().naoFormatado().equals("")) {
            objRegTXT.fieldByName("IN_RETIFICADORA").set(" ");
        } else if (objDecl.getIdentificadorDeclaracao().isRetificadora()) {
            objRegTXT.fieldByName("IN_RETIFICADORA").set(1);
            String numeroRecibo = objDecl.getIdentificadorDeclaracao().getNumReciboDecRetif().naoFormatado();
            if (numeroRecibo.length() >= 10) {
                objRegTXT.fieldByName("NR_RECIBO_ULTIMA_DEC_EX_ATUAL").set(numeroRecibo.substring(0, 10));
            } else if (numeroRecibo.length() > 0) {
                objRegTXT.fieldByName("NR_RECIBO_ULTIMA_DEC_EX_ATUAL").set(numeroRecibo.substring(0, 9));
            }
        } else {
            objRegTXT.fieldByName("IN_RETIFICADORA").set(0);
        }
        String numeroDeclaracaoAnoAnterior = objDecl.getContribuinte().getNumeroReciboDecAnterior().naoFormatado();
        if (numeroDeclaracaoAnoAnterior.length() >= 10) {
            objRegTXT.fieldByName("NR_RECIBO_ULTIMA_DEC_EX_ANTERIOR").set(numeroDeclaracaoAnoAnterior.substring(0, 10));
        } else if (numeroDeclaracaoAnoAnterior.length() > 0) {
            objRegTXT.fieldByName("NR_RECIBO_ULTIMA_DEC_EX_ANTERIOR").set(numeroDeclaracaoAnoAnterior.substring(0, 9));
        }
        objRegTXT.fieldByName("NR_CPF").set(objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado());
        objRegTXT.fieldByName("TIPO_NI").set(1);
        objRegTXT.fieldByName("NR_VERSAO").set(FabricaUtilitarios.getProperties().getProperty("versao_txt"));
        if (ConstantesGlobaisIRPF.VERSAO_TESTES) {
            objRegTXT.fieldByName("VERSAOTESTEPGD").set(FabricaUtilitarios.getProperties().getProperty("versao_teste_txt"));
        } else {
            objRegTXT.fieldByName("VERSAOTESTEPGD").set("   ");
        }
        objRegTXT.fieldByName("NM_NOME").setLimitado(objDecl.getIdentificadorDeclaracao().getNome().naoFormatado());
        if (objDecl.getContribuinte().getExterior().naoFormatado().equals(Logico.NAO)) {
            objRegTXT.fieldByName("SG_UF").set(objDecl.getContribuinte().getUf().naoFormatado());
        } else {
            objRegTXT.fieldByName("SG_UF").set("EX");
        }
        objRegTXT.fieldByName("NR_HASH").set(0);
        if (objDecl.getIdentificadorDeclaracao().getInCertificavel().naoFormatado().equals(Logico.SIM)) {
            objRegTXT.fieldByName("IN_CERTIFICAVEL").set(1);
        } else {
            objRegTXT.fieldByName("IN_CERTIFICAVEL").set(0);
        }
        objRegTXT.fieldByName("DT_NASCIM").set(objDecl.getContribuinte().getDataNascimento().naoFormatado());
        objRegTXT.fieldByName("IN_COMPLETA").set(objDecl.getIdentificadorDeclaracao().getTipoDeclaracao().naoFormatado().equals("0") ? "S" : "N");
        objRegTXT.fieldByName("IN_GERADA").set(objDecl.getIdentificadorDeclaracao().isDeclaracaoGerada() ? "S" : "N");
        objRegTXT.fieldByName("NOME_SO").setLimitado(System.getProperty("os.name"));
        objRegTXT.fieldByName("VERSAO_SO").setLimitado(System.getProperty("os.version"));
        objRegTXT.fieldByName("VERSAO_JVM").setLimitado(System.getProperty("java.version"));
        if (objDecl.getContribuinte().getPais().naoFormatado().equals("105")) {
            objRegTXT.fieldByName("CD_MUNICIP").set(objDecl.getContribuinte().getMunicipio().getConteudoAtual(0));
        } else {
            objRegTXT.fieldByName("CD_MUNICIP").set(9707);
        }
        objRegTXT.fieldByName("NR_CONJ").set(objDecl.getContribuinte().getCpfConjuge().naoFormatado());
        String NIBaseMaiorPagadora = objDecl.recuperarPrincipalFontePagadora().naoFormatado();
        if (NIBaseMaiorPagadora != null) {
            objRegTXT.fieldByName("NR_BASE_FONTE_MAIOR").set(NIBaseMaiorPagadora);
        }
        if ((NIBaseSegundaPagadora = objDecl.recuperarSegundaMaiorFontePagadora().naoFormatado()) != null) {
            objRegTXT.fieldByName("NR_BASE_FONTE_DOIS").set(NIBaseSegundaPagadora);
        }
        if ((NIBaseTerceiraPagadora = objDecl.recuperarTerceiraMaiorFontePagadora().naoFormatado()) != null) {
            objRegTXT.fieldByName("NR_BASE_FONTE_TRES").set(NIBaseTerceiraPagadora);
        }
        if ((NIBaseQuartaPagadora = objDecl.recuperarQuartaMaiorFontePagadora().naoFormatado()) != null) {
            objRegTXT.fieldByName("NR_BASE_FONTE_QUATRO").set(NIBaseQuartaPagadora);
        }
        if ((cpfMaiorDep = objDecl.recuperarMaiorDependente().naoFormatado()) != null) {
            objRegTXT.fieldByName("NR_CPF_DEPE_REND_MAIOR").set(cpfMaiorDep);
        }
        if ((cpfSegundoMaiorDepPagador = objDecl.recuperarSegundoMaiorDependente().naoFormatado()) != null) {
            objRegTXT.fieldByName("NR_CPF_DEPE_REND_DOIS").set(cpfSegundoMaiorDepPagador);
        }
        if ((cpfTerceiroMaiorDepPagador = objDecl.recuperarTerceiroMaiorDependente().naoFormatado()) != null) {
            objRegTXT.fieldByName("NR_CPF_DEPE_REND_TRES").set(cpfTerceiroMaiorDepPagador);
        }
        if ((cpfQuartoMaiorDepPagador = objDecl.recuperarQuartoMaiorDependente().naoFormatado()) != null) {
            objRegTXT.fieldByName("NR_CPF_DEPE_REND_QUATRO").set(cpfQuartoMaiorDepPagador);
        }
        if ((cpfQuintoMaiorDepPagador = objDecl.recuperarQuintoMaiorDependente().naoFormatado()) != null) {
            objRegTXT.fieldByName("NR_CPF_DEPE_REND_CINCO").set(cpfQuintoMaiorDepPagador);
        }
        if ((cpfSextoMaiorDepPagador = objDecl.recuperarSextoMaiorDependente().naoFormatado()) != null) {
            objRegTXT.fieldByName("NR_CPF_DEPE_REND_SEIS").set(cpfSextoMaiorDepPagador);
        }
        if ((dataNascimento = objDecl.recuperarDataNascimentoMaiorDependente().naoFormatado()) != null) {
            objRegTXT.fieldByName("DT_NASC_DEPE_REND_MAIOR").set(dataNascimento);
        }
        if ((dataNascimento = objDecl.recuperarDataNascimentoSegundoMaiorDependente().naoFormatado()) != null) {
            objRegTXT.fieldByName("DT_NASC_DEPE_REND_DOIS").set(dataNascimento);
        }
        if ((dataNascimento = objDecl.recuperarDataNascimentoTerceiroMaiorDependente().naoFormatado()) != null) {
            objRegTXT.fieldByName("DT_NASC_DEPE_REND_TRES").set(dataNascimento);
        }
        if ((dataNascimento = objDecl.recuperarDataNascimentoQuartoMaiorDependente().naoFormatado()) != null) {
            objRegTXT.fieldByName("DT_NASC_DEPE_REND_QUATRO").set(dataNascimento);
        }
        if ((dataNascimento = objDecl.recuperarDataNascimentoQuintoMaiorDependente().naoFormatado()) != null) {
            objRegTXT.fieldByName("DT_NASC_DEPE_REND_CINCO").set(dataNascimento);
        }
        if ((dataNascimento = objDecl.recuperarDataNascimentoSextoMaiorDependente().naoFormatado()) != null) {
            objRegTXT.fieldByName("DT_NASC_DEPE_REND_SEIS").set(dataNascimento);
        }
        if ((maioresNis = objDecl.getPagamentos().recuperarMaioresNIsDepesasMedicas(2))[0] != null) {
            objRegTXT.fieldByName("NR_BASE_BENEF_DESP_MED_MAIOR").set(maioresNis[0].naoFormatado());
        }
        if (maioresNis[1] != null) {
            objRegTXT.fieldByName("NR_BASE_BENEF_DESP_MED_DOIS").set(maioresNis[1].naoFormatado());
        }
        String inCriticaEntrega = objDecl.detalhaObrigatoriedadeEntregaAjusteOuEspolio();
        objRegTXT.fieldByName("IN_CRIT_OBRIGAT").set(inCriticaEntrega);
        objRegTXT.fieldByName("IN_OBRIGAT_ENTREGA").set(objDecl.verificaObrigatoriedadeEntrega(inCriticaEntrega));
        if (objDecl.getIdentificadorDeclaracao().getTipoDeclaracao().naoFormatado().equals("0")) {
            objRegTXT.fieldByName("VR_IMPDEVIDO").set(objDecl.getModelo().getImpostoDevidoI());
        }
        if (objDecl.getIdentificadorDeclaracao().getTipoDeclaracao().naoFormatado().equals("1")) {
            objRegTXT.fieldByName("VR_IMPDEVIDO").set(objDecl.getModelo().getImpostoDevidoI());
        }
        if (!objDecl.getModelo().getSaldoImpostoPagar().isVazio() && objDecl.getResumo().getCalculoImposto().getDebitoAutomatico().naoFormatado().equals("autorizado")) {
            objRegTXT.fieldByName("IN_RESULTADO_IMPOSTO").set(3);
        } else if (!objDecl.getModelo().getSaldoImpostoPagar().isVazio()) {
            objRegTXT.fieldByName("IN_RESULTADO_IMPOSTO").set(1);
        } else if (!objDecl.getModelo().getImpostoRestituir().isVazio()) {
            objRegTXT.fieldByName("IN_RESULTADO_IMPOSTO").set(2);
        } else {
            objRegTXT.fieldByName("IN_RESULTADO_IMPOSTO").set(0);
        }
        objRegTXT.fieldByName("IN_IMPOSTO_ANTECIPADO").set(objDecl.getModelo().recuperarCodInImpostoAntecipado());
        objRegTXT.fieldByName("IN_IMPOSTO_PAGO").set(objDecl.getModelo().recuperarCodInImpostoPago());
        objRegTXT.fieldByName("IN_MUDA_ENDERECO").set(objDecl.getContribuinte().getEnderecoDiferente().naoFormatado());
        if (objDecl.getContribuinte().getExterior().naoFormatado().equals(Logico.NAO)) {
            objRegTXT.fieldByName("NR_CEP").set(objDecl.getContribuinte().getCep().naoFormatado());
        }
        objRegTXT.fieldByName("IN_DEBITO_PRIMEIRA_QUOTA").set(objDecl.getResumo().getCalculoImposto().getIndicadorPrimeiraQuota().naoFormatado().equals("1") ? "1" : "0");
        objRegTXT.fieldByName("NR_BANCO").set(objDecl.getResumo().getCalculoImposto().getBanco().getConteudoAtual(0));
        objRegTXT.fieldByName("NR_AGENCIA").set(objDecl.getResumo().getCalculoImposto().getAgencia().naoFormatado());
        try {
            String tipoConta = objDecl.getResumo().getCalculoImposto().getTipoConta().getConteudoAtual(0);
            if (objDecl.getModelo().getSaldoImpostoPagar().comparacao(">", "0,00")) {
                objRegTXT.fieldByName("IN_TIPO_CONTA").set("0");
            } else {
                objRegTXT.fieldByName("IN_TIPO_CONTA").set(tipoConta.isEmpty() ? "0" : tipoConta);
            }
            objRegTXT.fieldByName("NR_CONTA").set(objDecl.getResumo().getCalculoImposto().getContaCreditoFormatadaTxt());
        }
        catch (AplicacaoException e) {
            throw new GeracaoTxtException(e.getMessage(), (Throwable)e);
        }
        objRegTXT.fieldByName("NR_DV_CONTA").set(objDecl.getResumo().getCalculoImposto().getDvContaCredito().naoFormatado());
        RetornosValidacoes retVal = objDecl.getResumo().getCalculoImposto().getDvContaCredito().validar();
        if (retVal.getPrimeiroRetornoValidacaoMaisSevero().getSeveridade() != 0) {
            objRegTXT.fieldByName("IN_DV_CONTA").set(1);
        }
        objRegTXT.fieldByName("NM_CONTRIBUINTE").setLimitado(objDecl.getIdentificadorDeclaracao().getNome().naoFormatado());
        String hash = ConversorObjetosIRPF2Registros.calcularHashCRC32(objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado());
        objRegTXT.fieldByName("FILLER3").setLimitado(hash);
        if (objDecl.getContribuinte().getPais().naoFormatado().equals("105")) {
            objRegTXT.fieldByName("NM_MUNICIPIO").setLimitado(objDecl.getContribuinte().getMunicipio().getConteudoAtual(1));
        }
        objRegTXT.fieldByName("NR_CPF_INVENTARIANTE").set(objDecl.getEspolio().obterInformacoEspolioCPFInventarianteHeader().getCpfInventariante().naoFormatado());
        if ((objDecl.getEspolio().ehFinalEspolioSobrepartilha() || objDecl.getEspolio().ehInicialSobrepartilha()) && !objDecl.getEspolio().ehFinalEspolioPartilha()) {
            objRegTXT.fieldByName("IN_SOBREPARTILHA").set(Logico.SIM);
        } else {
            objRegTXT.fieldByName("IN_SOBREPARTILHA").set(Logico.NAO);
        }
        String maiorPensaoAlimenticia = objDecl.getPagamentos().recuperarCpfMaiorPensaoAlimenticia();
        objRegTXT.fieldByName("NR_CPF_DEST_PENSAO_ALIMENT_MAIOR").set(maiorPensaoAlimenticia);
        objRegTXT.fieldByName("ENDERECO_MAC").set(IRPFUtil.getMacAddress());
        boolean ehRetificadora = objDecl.getIdentificadorDeclaracao().isRetificadora();
        objDecl.getContribuinte().getNumeroReciboDecAnterior().validar();
        if (ehRetificadora) {
            objRegTXT.fieldByName("IN_SEGURANCA").set(0);
        } else if (objDecl.getContribuinte().getNumeroReciboDecAnterior().isVazio()) {
            objRegTXT.fieldByName("IN_SEGURANCA").set(1);
        } else {
            objRegTXT.fieldByName("IN_SEGURANCA").set(2);
        }
        objRegTXT.fieldByName("FILLER1").setLimitado(" ");
        if (objDecl.getIdentificadorDeclaracao().isSaida()) {
            Data dtCondicaoNaoResidente = objDecl.getSaida().getDtCondicaoNaoResidente();
            if (!dtCondicaoNaoResidente.isVazio()) {
                Object dtInvertida = dtCondicaoNaoResidente.naoFormatado();
                dtInvertida = ((String)dtInvertida).substring(4, 8) + ((String)dtInvertida).substring(2, 4) + ((String)dtInvertida).substring(0, 2);
                objRegTXT.fieldByName("DT_COND_NAO_RESIDENTE").set((String)dtInvertida);
            }
            objRegTXT.fieldByName("NR_CPF_PROCURADOR").set(objDecl.getSaida().getCpfProcurador().naoFormatado());
        } else if (objDecl.getIdentificadorDeclaracao().isAjuste() && objDecl.getContribuinte().getExterior().naoFormatado().equals(Logico.SIM)) {
            objRegTXT.fieldByName("NR_CPF_PROCURADOR").set(objDecl.getContribuinte().getCpfProcurador().naoFormatado());
        }
        if (objDecl.getIdentificadorDeclaracao().isCompleta()) {
            objRegTXT.fieldByName("VR_TOTAL_RENDTRIB_PFPJ_TITDEP").set(objDecl.getModeloCompleta().getTotalRendimentos());
        } else {
            objRegTXT.fieldByName("VR_TOTAL_RENDTRIB_PFPJ_TITDEP").set(objDecl.getModeloSimplificada().getTotalResultadosTributaveis());
        }
        objDecl.setarConfiabilidade();
        String confiabilidade = objDecl.getIdentificadorDeclaracao().getInConfiabilidade().naoFormatado();
        objRegTXT.fieldByName("IN_CONFIABILIDADE").set(confiabilidade);
        objDecl.setarCpfTransmissaoEPerfilCpfTransmissao();
        String cpfTransmissao = objDecl.getIdentificadorDeclaracao().getCpfTransmissao().naoFormatado();
        objRegTXT.fieldByName("NR_CPF_TRANSMISSAO").set(cpfTransmissao);
        String perfilCpfTransmissao = objDecl.getIdentificadorDeclaracao().getInPerfilCpfTransmissao().naoFormatado();
        objRegTXT.fieldByName("IN_CPF_TRANSMISSAO_PERFIL").set(perfilCpfTransmissao);
        if (objDecl.getResumo().getCalculoImposto().getImpostoRestituir().comparacao("<=", "0,00")) {
            Valor impostoPagar = new Valor();
            impostoPagar.append('+', objDecl.getResumo().getCalculoImposto().getSaldoImpostoPagar());
            impostoPagar.append('+', (Valor)objDecl.getGCAP().getConsolidacaoGeralBrasil().getImpostoDevidoAnoAtual());
            impostoPagar.append('+', (Valor)objDecl.getGCAP().obterSomatorioImpostoDevido1NoExercicioAlienacoesGCME());
            impostoPagar.append('+', (Valor)objDecl.getGCAP().getConsolidacaoGeralEspecie().getImpostoDevido());
            impostoPagar.append('+', objDecl.getRendaVariavel().getTotalImpostoAPagar());
            impostoPagar.append('+', objDecl.getRendaVariavelDependente().getTotalImpostoAPagar());
            Valor impostoPagarFII = new Valor("0,00");
            impostoPagarFII.append('+', objDecl.getFundosInvestimentos().getTotalImpostoDevido());
            impostoPagarFII.append('-', objDecl.getFundosInvestimentos().getTotalImpostoRetidoFonteLei11033());
            impostoPagarFII.append('+', objDecl.getFundosInvestimentosDependente().getTotalImpostoDevido());
            impostoPagarFII.append('-', objDecl.getFundosInvestimentosDependente().getTotalImpostoRetidoFonteLei11033());
            if (impostoPagarFII.comparacao("<", "0,00")) {
                impostoPagarFII.clear();
            }
            impostoPagar.append('+', impostoPagarFII);
            objRegTXT.fieldByName("VR_SOMA_IMPOSTO_PAGAR").set(impostoPagar);
        } else {
            objRegTXT.fieldByName("VR_SOMA_IMPOSTO_PAGAR").set(0);
        }
        List fontesPagadorasRRA = objDecl.getRendAcm().obterBeneficiariosEmOrdemDecrescente();
        if (!fontesPagadorasRRA.isEmpty()) {
            int i = 1;
            for (String s : fontesPagadorasRRA) {
                String[] valores = s.split("#");
                int opcaoTributacao = 1;
                if (i == 1) {
                    if (valores[1].equals("A")) {
                        opcaoTributacao = 0;
                    } else if (valores[1].equals("E")) {
                        opcaoTributacao = 1;
                    }
                    objRegTXT.fieldByName("IN_OPCAO_TRIBUTACAO_BENEFICIARIO_UM_RRA").set(opcaoTributacao);
                    objRegTXT.fieldByName("CPF_BENEFICIARIO_UM_RRA").set(valores[0]);
                    ++i;
                    continue;
                }
                if (i == 2) {
                    if (valores[1].equals("A")) {
                        opcaoTributacao = 0;
                    } else if (valores[1].equals("E")) {
                        opcaoTributacao = 1;
                    }
                    objRegTXT.fieldByName("IN_OPCAO_TRIBUTACAO_BENEFICIARIO_DOIS_RRA").set(opcaoTributacao);
                    objRegTXT.fieldByName("CPF_BENEFICIARIO_DOIS_RRA").set(valores[0]);
                    ++i;
                    continue;
                }
                if (i == 3) {
                    if (valores[1].equals("A")) {
                        opcaoTributacao = 0;
                    } else if (valores[1].equals("E")) {
                        opcaoTributacao = 1;
                    }
                    objRegTXT.fieldByName("IN_OPCAO_TRIBUTACAO_BENEFICIARIO_TRES_RRA").set(opcaoTributacao);
                    objRegTXT.fieldByName("CPF_BENEFICIARIO_TRES_RRA").set(valores[0]);
                    ++i;
                    continue;
                }
                if (i != 4) continue;
                if (valores[1].equals("A")) {
                    opcaoTributacao = 0;
                } else if (valores[1].equals("E")) {
                    opcaoTributacao = 1;
                }
                objRegTXT.fieldByName("IN_OPCAO_TRIBUTACAO_BENEFICIARIO_QUATRO_RRA").set(opcaoTributacao);
                objRegTXT.fieldByName("CPF_BENEFICIARIO_QUATRO_RRA").set(valores[0]);
                break;
            }
        }
        Valor totalDeducaoIncentivoLiquidoECA = new Valor();
        for (EstatutoCriancaAdolescente eca : objDecl.getColecaoEstatutoCriancaAdolescente().itens()) {
            totalDeducaoIncentivoLiquidoECA.append('+', eca.getValor());
        }
        objRegTXT.fieldByName("VR_DOACAO_ECA").set(totalDeducaoIncentivoLiquidoECA);
        if (objDecl.getIdentificadorDeclaracao().isCompleta()) {
            objRegTXT.fieldByName("VR_TOTISENTOS").set(objDecl.getModeloCompleta().getRendIsentosNaoTributaveis());
        } else {
            objRegTXT.fieldByName("VR_TOTISENTOS").set(objDecl.getModeloSimplificada().getRendIsentosNaoTributaveis());
        }
        if (objDecl.getIdentificadorDeclaracao().isCompleta()) {
            objRegTXT.fieldByName("VR_TOTEXCLUSIVO").set((Valor)objDecl.getModeloCompleta().getRendSujeitoTribExclusiva());
        } else {
            objRegTXT.fieldByName("VR_TOTEXCLUSIVO").set(objDecl.getModeloSimplificada().getRendSujeitoTribExclusiva());
        }
        Iterator itPagamentos = objDecl.getPagamentos().itens().iterator();
        Valor vrTotalPagamentos = new Valor();
        while (itPagamentos.hasNext()) {
            Pagamento pag = (Pagamento)itPagamentos.next();
            vrTotalPagamentos.append('+', pag.getValorPago());
        }
        objRegTXT.fieldByName("VR_TOTAL_PAGAMENTOS").set(vrTotalPagamentos);
        objRegTXT.fieldByName("CD_NATUR").set(objDecl.getContribuinte().getNaturezaOcupacao().getConteudoAtual(0));
        ArrayList empregadas = objDecl.getPagamentos().recuperarDadosTresMaioresEmpregadasDomesticas();
        if (empregadas.size() > 0) {
            objRegTXT.fieldByName("NR_CPF_EMPREGADA_DOMESTICA_MAIOR").set(((String[])empregadas.get(0))[0]);
            objRegTXT.fieldByName("NR_NIT_EMP_DOM_MAIOR").set(((String[])empregadas.get(0))[1]);
        }
        if (empregadas.size() > 1) {
            objRegTXT.fieldByName("NR_CPF_EMPREGADA_DOMESTICA_DOIS").set(((String[])empregadas.get(1))[0]);
            objRegTXT.fieldByName("NR_NIT_EMP_DOM_DOIS").set(((String[])empregadas.get(1))[1]);
        }
        if (empregadas.size() > 2) {
            objRegTXT.fieldByName("NR_CPF_EMPREGADA_DOMESTICA_TRES").set(((String[])empregadas.get(2))[0]);
            objRegTXT.fieldByName("NR_NIT_EMP_DOM_TRES").set(((String[])empregadas.get(2))[1]);
        }
        objRegTXT.fieldByName("TP_INICIADA").set(objDecl.getIdentificadorDeclaracao().getTpIniciada().naoFormatado());
        objRegTXT.fieldByName("IN_UTILIZOU_APP").set(objDecl.getIdentificadorDeclaracao().getInUtilizouAPP().naoFormatado());
        objRegTXT.fieldByName("IN_UTILIZOU_ONLINE").set(objDecl.getIdentificadorDeclaracao().getInUtilizouOnLine().naoFormatado());
        objRegTXT.fieldByName("IN_UTILIZOU_SALVAR_RECUPERAR_ONLINE").set(objDecl.getIdentificadorDeclaracao().getInUtilizouSalvarRecuperarOnLine().naoFormatado());
        objRegTXT.fieldByName("IN_UTILIZOU_RASCUNHO").set(objDecl.getIdentificadorDeclaracao().getInUtilizouRascunho().naoFormatado());
        objRegTXT.fieldByName("IN_UTILIZOU_ASSISTIDA_FONTES_PAGADORAS").set(objDecl.getIdentificadorDeclaracao().getInUtilizouAssistidaFontePagadora().naoFormatado());
        objRegTXT.fieldByName("IN_UTILIZOU_ASSISTIDA_PLANO_SAUDE").set(objDecl.getIdentificadorDeclaracao().getInUtilizouAssistidaPlanoSaude().naoFormatado());
        objRegTXT.fieldByName("IN_UTILIZOU_PGD").set(objDecl.getIdentificadorDeclaracao().getInUtilizouPGD().naoFormatado());
        objRegTXT.fieldByName("IN_UTILIZOU_PREPREENCHIDA").set(objDecl.getIdentificadorDeclaracao().getPrepreenchida().naoFormatado());
        objRegTXT.fieldByName("IN_TRANSMITIDA").set("01");
        List nis6Fontes = objDecl.getPagamentos().recuperarNISeisMaioresPagamentos();
        objRegTXT.fieldByName("NR_PAGAMENTO_DEDUTIVEL_MAIOR_UM").set((String)nis6Fontes.get(0));
        objRegTXT.fieldByName("NR_PAGAMENTO_DEDUTIVEL_MAIOR_DOIS").set((String)nis6Fontes.get(1));
        objRegTXT.fieldByName("NR_PAGAMENTO_DEDUTIVEL_MAIOR_TRES").set((String)nis6Fontes.get(2));
        objRegTXT.fieldByName("NR_PAGAMENTO_DEDUTIVEL_MAIOR_QUATRO").set((String)nis6Fontes.get(3));
        objRegTXT.fieldByName("NR_PAGAMENTO_DEDUTIVEL_MAIOR_CINCO").set((String)nis6Fontes.get(4));
        objRegTXT.fieldByName("NR_PAGAMENTO_DEDUTIVEL_MAIOR_SEIS").set((String)nis6Fontes.get(5));
        Valor totalDeducaoIncentivoLiquidoIdoso = new Valor();
        for (EstatutoIdoso idoso : objDecl.getColecaoEstatutoIdoso().itens()) {
            totalDeducaoIncentivoLiquidoIdoso.append('+', idoso.getValor());
        }
        objRegTXT.fieldByName("VR_DOACAO_IDOSO").set(totalDeducaoIncentivoLiquidoIdoso);
        objRegTXT.fieldByName("IN_SOCIAL").set(Logico.NAO);
        objDecl.usouImportacaoCarneLeaoWeb();
        objRegTXT.fieldByName("IN_CLWEB").set(objDecl.getIdentificadorDeclaracao().getInCLWeb().naoFormatado());
        objRegTXT.fieldByName("IN_ISENCAO_GCAP_TITULAR").set(objDecl.getGCAP().obterFlagIsencaoImovel(objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado()));
        objRegTXT.fieldByName("IN_ISENCAO_GCAP_MAIOR").set(objDecl.getGCAP().obterFlagIsencaoImovel(cpfMaiorDep));
        objRegTXT.fieldByName("IN_ISENCAO_GCAP_DOIS").set(objDecl.getGCAP().obterFlagIsencaoImovel(cpfSegundoMaiorDepPagador));
        objRegTXT.fieldByName("IN_ISENCAO_GCAP_TRES").set(objDecl.getGCAP().obterFlagIsencaoImovel(cpfTerceiroMaiorDepPagador));
        objRegTXT.fieldByName("IN_ISENCAO_GCAP_QUATRO").set(objDecl.getGCAP().obterFlagIsencaoImovel(cpfQuartoMaiorDepPagador));
        objRegTXT.fieldByName("IN_ISENCAO_GCAP_CINCO").set(objDecl.getGCAP().obterFlagIsencaoImovel(cpfQuintoMaiorDepPagador));
        objRegTXT.fieldByName("IN_ISENCAO_GCAP_SEIS").set(objDecl.getGCAP().obterFlagIsencaoImovel(cpfSextoMaiorDepPagador));
        List maioresBeneficiariosPJ = objDecl.maioresBeneficiariosPJ(10);
        for (int i = 0; i < maioresBeneficiariosPJ.size(); ++i) {
            String[] item = (String[])maioresBeneficiariosPJ.get(i);
            objRegTXT.fieldByName("IN_FICHA_" + (i + 1)).set(item[0]);
            objRegTXT.fieldByName("IN_COD_FICHA_" + (i + 1)).set(item[1]);
            objRegTXT.fieldByName("CNPJ_MAIOR_VALOR_" + (i + 1)).set(item[2]);
        }
        maioresBeneficiariosPJ = null;
        objRegTXT.fieldByName("DT_RETORNO_PAIS").set(objDecl.getContribuinte().getDataRetorno().naoFormatado());
        objRegTXT.fieldByName("IN_PROCESSO_ATUALIZACAO_BEM").set(objDecl.getBens().getExisteAtualizacaoValorBem().naoFormatado());
        if (objDecl.getBens().getExisteAtualizacaoValorBem().naoFormatado().equals(Logico.SIM)) {
            objRegTXT.fieldByName("NR_PROCESSO_ATUALIZACAO_BEM").set(objDecl.getBens().getNumeroProcessoAtualizacaoValorBem().naoFormatado());
        }
        linha.add(objRegTXT);
        return linha;
    }

    public List<RegistroTxt> montarRegistroHeaderSR(IdentificadorDeclaracao idDeclaracao) throws GeracaoTxtException {
        ArrayList<RegistroTxt> linha = new ArrayList<RegistroTxt>();
        RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "SR");
        objRegTXT.fieldByName("NR_REG").set("SR");
        objRegTXT.fieldByName("EXERCICIO").set(ConstantesGlobais.EXERCICIO);
        objRegTXT.fieldByName("NR_CPF").set(idDeclaracao.getCpf().naoFormatado());
        objRegTXT.fieldByName("TP_INICIADA").set(idDeclaracao.getTpIniciada().naoFormatado());
        objRegTXT.fieldByName("IN_UTILIZOU_APP").set(idDeclaracao.getInUtilizouAPP().naoFormatado());
        objRegTXT.fieldByName("IN_UTILIZOU_ASSISTIDA_FONTES_PAGADORAS").set(idDeclaracao.getInUtilizouAssistidaFontePagadora().naoFormatado());
        objRegTXT.fieldByName("IN_UTILIZOU_ASSISTIDA_PLANO_SAUDE").set(idDeclaracao.getInUtilizouAssistidaPlanoSaude().naoFormatado());
        objRegTXT.fieldByName("IN_UTILIZOU_ONLINE").set(idDeclaracao.getInUtilizouOnLine().naoFormatado());
        objRegTXT.fieldByName("IN_UTILIZOU_PGD").set(idDeclaracao.getInUtilizouPGD().naoFormatado());
        objRegTXT.fieldByName("IN_UTILIZOU_RASCUNHO").set(idDeclaracao.getInUtilizouRascunho().naoFormatado());
        objRegTXT.fieldByName("IN_UTILIZOU_PREPREENCHIDA").set(idDeclaracao.getPrepreenchida().naoFormatado());
        objRegTXT.fieldByName("IN_UTILIZOU_SALVAR_RECUPERAR_ONLINE").set(idDeclaracao.getInUtilizouSalvarRecuperarOnLine().naoFormatado());
        objRegTXT.fieldByName("IN_PENDENCIA").set(idDeclaracao.getInPendencia().naoFormatado());
        linha.add(objRegTXT);
        return linha;
    }

    public List<RegistroTxt> montarRegistroContribuinte(DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        ArrayList<RegistroTxt> linha = new ArrayList<RegistroTxt>();
        Contribuinte contribuinte = objDecl.getContribuinte();
        RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "16");
        objRegTXT.fieldByName("NR_REG").set("16");
        objRegTXT.fieldByName("NR_CPF").set(objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado());
        objRegTXT.fieldByName("NM_NOME").setLimitado(objDecl.getIdentificadorDeclaracao().getNome().naoFormatado());
        objRegTXT.fieldByName("DT_NASCIM").set(contribuinte.getDataNascimento().naoFormatado());
        if (contribuinte.getConjuge().naoFormatado().equals(Logico.SIM)) {
            objRegTXT.fieldByName("IN_CONJUGE").set("S");
            objRegTXT.fieldByName("NR_CPF_CONJUGE").set(contribuinte.getCpfConjuge().naoFormatado());
        } else if (contribuinte.getConjuge().naoFormatado().equals(Logico.NAO)) {
            objRegTXT.fieldByName("IN_CONJUGE").set("N");
        }
        objRegTXT.fieldByName("NR_REGISTRO_PROFISSIONAL").set(objDecl.getContribuinte().getRegistroProfissional().naoFormatado());
        objRegTXT.fieldByName("NR_NITPISPASEP").set(objDecl.getRendPFTitular().getNITPISPASEP().naoFormatado());
        if (contribuinte.getExterior().naoFormatado().equals(Logico.SIM)) {
            objRegTXT.fieldByName("SG_UF").set("EX");
            objRegTXT.fieldByName("CD_EX").set(contribuinte.getCodigoExterior().getConteudoAtual(0));
            objRegTXT.fieldByName("CD_PAIS").set(contribuinte.getPais().getConteudoAtual(0));
            objRegTXT.fieldByName("NM_MUNICIP").setLimitado(contribuinte.getCidade().formatado());
            objRegTXT.fieldByName("NM_LOGRA").setLimitado(contribuinte.getLogradouroExt().naoFormatado());
            objRegTXT.fieldByName("NR_NUMERO").setLimitado(contribuinte.getNumeroExt().naoFormatado());
            objRegTXT.fieldByName("NM_BAIRRO").setLimitado(contribuinte.getBairroExt().naoFormatado());
            objRegTXT.fieldByName("NM_COMPLEM").setLimitado(contribuinte.getComplementoExt().naoFormatado());
            objRegTXT.fieldByName("NR_CEP").set(contribuinte.getCepExt().naoFormatado());
            objRegTXT.fieldByName("NR_DDD_TELEFONE").set(contribuinte.getDdi().naoFormatado().trim());
            objRegTXT.fieldByName("NR_TELEFONE").set(contribuinte.getTelefoneExt().naoFormatado());
        } else {
            objRegTXT.fieldByName("CD_PAIS").set("105");
            objRegTXT.fieldByName("CD_MUNICIP").set(contribuinte.getMunicipio().getConteudoAtual(0));
            objRegTXT.fieldByName("NM_MUNICIP").setLimitado(contribuinte.getMunicipio().getConteudoAtual(1));
            objRegTXT.fieldByName("SG_UF").set(contribuinte.getUf().getConteudoAtual(0));
            objRegTXT.fieldByName("TIP_LOGRA").set(contribuinte.getTipoLogradouro().getConteudoAtual(0));
            objRegTXT.fieldByName("NM_LOGRA").setLimitado(contribuinte.getLogradouro().naoFormatado());
            objRegTXT.fieldByName("NR_NUMERO").setLimitado(contribuinte.getNumero().naoFormatado());
            objRegTXT.fieldByName("NM_BAIRRO").setLimitado(contribuinte.getBairro().naoFormatado());
            objRegTXT.fieldByName("NM_COMPLEM").setLimitado(contribuinte.getComplemento().naoFormatado());
            objRegTXT.fieldByName("NR_CEP").set(contribuinte.getCep().naoFormatado());
            objRegTXT.fieldByName("NR_DDD_TELEFONE").set(contribuinte.getDdd().naoFormatado().trim());
            objRegTXT.fieldByName("NR_TELEFONE").set(contribuinte.getTelefone().naoFormatado());
            objRegTXT.fieldByName("NR_DDD_CELULAR").set(contribuinte.getDddCelular().naoFormatado().trim());
            objRegTXT.fieldByName("NR_CELULAR").set(contribuinte.getCelular().naoFormatado());
        }
        objRegTXT.fieldByName("DT_RETORNO_PAIS").set(contribuinte.getDataRetorno().naoFormatado());
        if (objDecl.getIdentificadorDeclaracao().isAjuste()) {
            if (contribuinte.getRetornoPais().isVazio()) {
                objRegTXT.fieldByName("IN_RETORNO_PAIS").set(" ");
            } else {
                objRegTXT.fieldByName("IN_RETORNO_PAIS").set(contribuinte.getRetornoPais().naoFormatado());
            }
        } else {
            objRegTXT.fieldByName("IN_RETORNO_PAIS").set(Logico.NAO);
        }
        objRegTXT.fieldByName("NM_EMAIL").set(contribuinte.getEmail().naoFormatado());
        objRegTXT.fieldByName("NR_NUMERO_PROCESSO").set(contribuinte.getProcessoDigital().naoFormatado());
        objRegTXT.fieldByName("CD_OCUP").set(contribuinte.getOcupacaoPrincipal().getConteudoAtual(0));
        objRegTXT.fieldByName("CD_NATUR").set(contribuinte.getNaturezaOcupacao().getConteudoAtual(0));
        objRegTXT.fieldByName("NR_QUOTAS").set(objDecl.getResumo().getCalculoImposto().getNumQuotas().asInteger());
        objRegTXT.fieldByName("NR_BANCO").set(objDecl.getResumo().getCalculoImposto().getBanco().getConteudoAtual(0));
        objRegTXT.fieldByName("NR_AGENCIA").set(objDecl.getResumo().getCalculoImposto().getAgencia().naoFormatado());
        try {
            String tipoConta = objDecl.getResumo().getCalculoImposto().getTipoConta().getConteudoAtual(0);
            if (objDecl.getModelo().getSaldoImpostoPagar().comparacao(">", "0,00")) {
                objRegTXT.fieldByName("IN_TIPO_CONTA").set("0");
            } else {
                objRegTXT.fieldByName("IN_TIPO_CONTA").set(tipoConta.isEmpty() ? "0" : tipoConta);
            }
            objRegTXT.fieldByName("NR_CONTA").set(objDecl.getResumo().getCalculoImposto().getContaCreditoFormatadaTxt());
        }
        catch (AplicacaoException e) {
            throw new GeracaoTxtException(e.getMessage(), (Throwable)e);
        }
        objRegTXT.fieldByName("NR_DV_CONTA").set(objDecl.getResumo().getCalculoImposto().getDvContaCredito().naoFormatado());
        String debitoAutom = objDecl.getResumo().getCalculoImposto().getDebitoAutomatico().naoFormatado().equals("autorizado") ? "S" : "N";
        objRegTXT.fieldByName("IN_DEBITO_AUTOM").set(debitoAutom);
        objRegTXT.fieldByName("IN_DEBITO_PRIMEIRA_QUOTA").set(objDecl.getResumo().getCalculoImposto().getIndicadorPrimeiraQuota().naoFormatado().equals("1") ? "1" : "0");
        objRegTXT.fieldByName("IN_COMPLETA").set(objDecl.getIdentificadorDeclaracao().isCompleta() ? "S" : "N");
        objRegTXT.fieldByName("IN_GERADO").set(objDecl.getIdentificadorDeclaracao().isDeclaracaoGerada() ? "S" : "N");
        if (objDecl.getIdentificadorDeclaracao().getDeclaracaoRetificadora().naoFormatado().equals("")) {
            objRegTXT.fieldByName("IN_RETIFICADORA").set(" ");
        } else {
            objRegTXT.fieldByName("IN_RETIFICADORA").set(objDecl.getIdentificadorDeclaracao().isRetificadora() ? "S" : "N");
        }
        if (objDecl.getIdentificadorDeclaracao().isRetificadora()) {
            objRegTXT.fieldByName("NR_CONTROLE_ORIGINAL").set(objDecl.getIdentificadorDeclaracao().getNumReciboDecRetif().naoFormatado());
        }
        if (!objDecl.getContribuinte().getEnderecoDiferente().isVazio()) {
            objRegTXT.fieldByName("IN_ENDERECO").set(objDecl.getContribuinte().getEnderecoDiferente().naoFormatado().equals(Logico.SIM) ? "S" : "N");
        }
        objRegTXT.fieldByName("NR_FONTE_PRINCIPAL").set(objDecl.recuperarPrincipalFontePagadora().naoFormatado());
        String numeroDeclaracaoAnoAnterior = objDecl.getContribuinte().getNumeroReciboDecAnterior().naoFormatado();
        if (numeroDeclaracaoAnoAnterior.length() >= 10) {
            objRegTXT.fieldByName("NR_RECIBO_ULTIMA_DEC_ANO_ANTERIOR").set(numeroDeclaracaoAnoAnterior.substring(0, 10));
        } else if (numeroDeclaracaoAnoAnterior.length() > 0) {
            objRegTXT.fieldByName("NR_RECIBO_ULTIMA_DEC_ANO_ANTERIOR").set(numeroDeclaracaoAnoAnterior.substring(0, 9));
        }
        objRegTXT.fieldByName("IN_TIPODECLARACAO").set(objDecl.getIdentificadorDeclaracao().getTipoDeclaracaoAES().naoFormatado());
        objRegTXT.fieldByName("IN_DOENCA_DEFICIENCIA").set(objDecl.getContribuinte().getDeficiente().naoFormatado().equals("S") ? "S" : "N");
        if (objDecl.getIdentificadorDeclaracao().getPrepreenchida().isVazio() || objDecl.getIdentificadorDeclaracao().getPrepreenchida().naoFormatado().trim().equals("")) {
            objRegTXT.fieldByName("IN_PREPREENCHIDA").set("0");
        } else {
            objRegTXT.fieldByName("IN_PREPREENCHIDA").set(objDecl.getIdentificadorDeclaracao().getPrepreenchida().naoFormatado());
        }
        objRegTXT.fieldByName("DT_DIA_UTIL_RECIBO").set(TabelaDatasIRPF.obterDataReaberturaEntregaNaoFormatada((boolean)objDecl.getEmCalamidade()));
        if (contribuinte.getExterior().naoFormatado().equals(Logico.SIM) && objDecl.getIdentificadorDeclaracao().isAjuste()) {
            objRegTXT.fieldByName("NR_CPF_PROCURADOR").set(objDecl.getContribuinte().getCpfProcurador().naoFormatado());
        }
        if (!objDecl.getUtlimoCPFAutenticado().isVazio()) {
            objRegTXT.fieldByName("CPF_RESPONSAVEL").set(objDecl.getUtlimoCPFAutenticado().naoFormatado());
        }
        if (!objDecl.getIdentificadorDeclaracao().getDataCriacao().isVazio()) {
            objRegTXT.fieldByName("NR_DATA_HORA_ORIGINAL_RETIFICADORA").set(objDecl.getIdentificadorDeclaracao().getDataCriacao().naoFormatado());
        }
        if (objDecl.getResumo().getCalculoImposto().getNumQuotas().getConteudoInteiro() > 1 && !objDecl.getResumo().getCalculoImposto().isDebitoAutomatico()) {
            objRegTXT.fieldByName("TX_MENSAGEM_RECIBO").set(CadastroTabelasIRPF.recuperarMensagem((CodigoTabelaMensagens)CodigoTabelaMensagens.CODIGO_00118), false);
        }
        objRegTXT.fieldByName("IN_PROCESSO_ATUALIZACAO_BEM").set(objDecl.getBens().getExisteAtualizacaoValorBem().naoFormatado());
        if (objDecl.getBens().getExisteAtualizacaoValorBem().naoFormatado().equals(Logico.SIM)) {
            objRegTXT.fieldByName("NR_PROCESSO_ATUALIZACAO_BEM").set(objDecl.getBens().getNumeroProcessoAtualizacaoValorBem().naoFormatado());
        }
        objRegTXT.fieldByName("VR_PREJUIZO_ANO_ANTERIOR_LEI_14754").set((Valor)objDecl.getContribuinte().getPrejuizoAnoAnteriorLei14754());
        linha.add(objRegTXT);
        return linha;
    }

    public List<RegistroTxt> montarRegistroImpostoPago(DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        ArrayList<RegistroTxt> linha = new ArrayList<RegistroTxt>();
        RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "IP");
        objRegTXT.fieldByName("NR_REG").set("IP");
        objRegTXT.fieldByName("NR_CPF").set(objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado());
        objRegTXT.fieldByName("VR_IMPCOMP").set((Valor)objDecl.getImpostoPago().getImpostoComplementar());
        linha.add(objRegTXT);
        return linha;
    }

    public List<RegistroTxt> montarRegistroDeclaracaoCompleta(DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        ArrayList<RegistroTxt> linha = new ArrayList<RegistroTxt>();
        RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "19");
        objRegTXT.fieldByName("NR_REG").set("19");
        objRegTXT.fieldByName("NR_CPF").set(objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado());
        objRegTXT.fieldByName("NR_FONTE").set(objDecl.getColecaoRendPJTitular().getNiMaiorFontePagadora().naoFormatado());
        objRegTXT.fieldByName("VR_IMPEXT").set((Valor)objDecl.getImpostoPago().getImpostoPagoExterior());
        objRegTXT.fieldByName("VR_IMPCOMP").set((Valor)objDecl.getImpostoPago().getImpostoComplementar());
        objRegTXT.fieldByName("VR_IRFONTELEI11033").set(objDecl.getModeloCompleta().getImpostoRetidoFonteLei11033());
        objRegTXT.fieldByName("VR_RECEX_TIT").set(objDecl.getRendPFTitular().getTotalExterior());
        objRegTXT.fieldByName("VR_LIVCAIX_TIT").set(objDecl.getRendPFTitular().getTotalLivroCaixa());
        objRegTXT.fieldByName("VR_CARNELEAO_TIT").set(objDecl.getRendPFTitular().getTotalDarfPago());
        objRegTXT.fieldByName("VR_RECEX_DEP").set(objDecl.getRendPFDependente().getTotalExterior());
        objRegTXT.fieldByName("VR_LIVCAIX_DEP").set(objDecl.getRendPFDependente().getTotalLivroCaixa());
        objRegTXT.fieldByName("VR_CARNELEAO_DEP").set(objDecl.getRendPFDependente().getTotalDarfPago());
        objRegTXT.fieldByName("VR_PREVPRIV").set(CalculosPagamentos.totalizarPagamentosGlosado((Pagamentos)objDecl.getPagamentos(), (String[])new String[]{"36"}, (boolean)true));
        Valor prevTitTotal = new Valor(objDecl.getRendPFTitular().getTotalPrevidencia().naoFormatado());
        prevTitTotal.append('+', objDecl.getColecaoRendPJTitular().getTotaisContribuicaoPrevOficial());
        prevTitTotal.append('+', objDecl.getRendIsentos().getPensaoQuadroAuxiliar().getTotalPrevidenciaOficialTitular());
        objRegTXT.fieldByName("VR_PREVOFTITULAR").set(prevTitTotal);
        Valor prevDepTotal = new Valor(objDecl.getRendPFDependente().getTotalPrevidencia().naoFormatado());
        prevDepTotal.append('+', objDecl.getColecaoRendPJDependente().getTotaisContribuicaoPrevOficial());
        prevDepTotal.append('+', objDecl.getRendIsentos().getPensaoQuadroAuxiliar().getTotalPrevidenciaOficialDependentes());
        objRegTXT.fieldByName("VR_PREVOFDEPENDENTE").set(prevDepTotal);
        Valor valTotalFunprespAteLimite = objDecl.getPagamentos().obterTotalFunprespAteLimite("T");
        valTotalFunprespAteLimite.append('+', objDecl.getPagamentos().obterTotalFunprespAteLimite("D"));
        objRegTXT.fieldByName("VR_ATE_LIMITE_FUNPRESP").set(valTotalFunprespAteLimite);
        Valor valTotalFunprespAcimaLimite = objDecl.getPagamentos().obterTotalFunprespAcimaLimite("T");
        valTotalFunprespAcimaLimite.append('+', objDecl.getPagamentos().obterTotalFunprespAcimaLimite("D"));
        objRegTXT.fieldByName("VR_ACIMA_LIMITE_FUNPRESP").set(valTotalFunprespAcimaLimite);
        objRegTXT.fieldByName("VR_TOTAL13SALARIOTITULAR").set(objDecl.getRendTributacaoExclusiva().getDecimoTerceiro());
        objRegTXT.fieldByName("VR_TOTAL13SALARIODEPENDENTE").set(objDecl.getRendTributacaoExclusiva().getDecimoTerceiroDependentes());
        objRegTXT.fieldByName("NR_DEPENDENTE_DESP_INSTRUCAO").set(objDecl.getPagamentos().obterTotalDependentesEnvolvidos());
        objRegTXT.fieldByName("NR_ALIMENTANDO_DESP_INSTRUCAO").set(objDecl.getPagamentos().obterTotalAlimentandosEnvolvidos());
        RendPF rendimentosPF = objDecl.getRendPFTitular();
        ColecaoRendPFDependente rendDep = objDecl.getRendPFDependente();
        Valor totalTitPFAlugueisOutros = new Valor("0,00");
        totalTitPFAlugueisOutros.append('+', rendimentosPF.getTotalPessoaFisica());
        totalTitPFAlugueisOutros.append('+', rendimentosPF.getTotalAlugueis());
        totalTitPFAlugueisOutros.append('+', rendimentosPF.getTotalOutros());
        Valor totalDepPFAlugueisOutros = new Valor("0,00");
        totalDepPFAlugueisOutros.append('+', rendDep.getTotalPessoaFisica());
        totalDepPFAlugueisOutros.append('+', rendDep.getTotalAlugueis());
        totalDepPFAlugueisOutros.append('+', rendDep.getTotalOutros());
        objRegTXT.fieldByName("VR_RENDEXTTIT").set(rendimentosPF.getTotalExterior());
        objRegTXT.fieldByName("VR_RENDPFTIT").set(totalTitPFAlugueisOutros);
        objRegTXT.fieldByName("VR_RENDEXTDEPEN").set(rendDep.getTotalExterior());
        objRegTXT.fieldByName("VR_RENDPFDEPEN").set(totalDepPFAlugueisOutros);
        objRegTXT.fieldByName("VR_IMPDEVIDO_SEM_REND_EXT").set(objDecl.getImpostoPago().getImpostoDevidoSemRendExterior());
        objRegTXT.fieldByName("VR_LIMITE_IMP_PAGO_EXT").set(objDecl.getImpostoPago().getLimiteImpPagoExterior());
        linha.add(objRegTXT);
        return linha;
    }

    public List<RegistroTxt> montarFichaResumoCompleta(DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        ArrayList<RegistroTxt> linha = new ArrayList<RegistroTxt>();
        RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "20");
        objRegTXT.fieldByName("NR_REG").set("20");
        objRegTXT.fieldByName("NR_CPF").set(objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado());
        objRegTXT.fieldByName("VR_RENDJUR").set(objDecl.getModeloCompleta().getRendRecebidoPJTitular());
        objRegTXT.fieldByName("VR_RENDJURDEPENDENTE").set(objDecl.getModeloCompleta().getRendRecebidoPJDependentes());
        objRegTXT.fieldByName("VR_RENDFISICEXT_TIT").set(objDecl.getModeloCompleta().getRendRecebidoPFEXTTitular());
        objRegTXT.fieldByName("VR_RENDFISICEXT_DEP").set(objDecl.getModeloCompleta().getRendRecebidoPFEXTDependentes());
        objRegTXT.fieldByName("VR_RESAR").set(objDecl.getModeloCompleta().getResultadoTributavelAR());
        objRegTXT.fieldByName("VR_TOTTRIB").set(objDecl.getModeloCompleta().getTotalRendimentos());
        objRegTXT.fieldByName("VR_PREVOF").set(objDecl.getModeloCompleta().getPrevidenciaOficial());
        objRegTXT.fieldByName("VR_TOTPRIVADA").set(objDecl.getModeloCompleta().getPrevidencia());
        objRegTXT.fieldByName("VR_DEPEN").set(objDecl.getModeloCompleta().getDeducaoDependentes());
        objRegTXT.fieldByName("VR_DESPINST").set(objDecl.getModeloCompleta().getDespesasInstrucao());
        objRegTXT.fieldByName("VR_DESPMEDIC").set(objDecl.getModeloCompleta().getDespesasMedicas());
        objRegTXT.fieldByName("VR_PENSAO").set(objDecl.getModeloCompleta().getPensaoAlimenticia());
        objRegTXT.fieldByName("VR_PENSAO_CARTORIO").set(objDecl.getModeloCompleta().getPensaoCartoral());
        objRegTXT.fieldByName("VR_LIVCAIX").set(objDecl.getModeloCompleta().getLivroCaixa());
        objRegTXT.fieldByName("VR_DEDUC").set(objDecl.getModeloCompleta().getTotalDeducoes());
        objRegTXT.fieldByName("VR_BASECALC").set(objDecl.getModeloCompleta().getBaseCalculo());
        objRegTXT.fieldByName("VR_IMPOSTO").set(objDecl.getModeloCompleta().getImposto());
        objRegTXT.fieldByName("VR_DEDIMPOSTO").set(objDecl.getModeloCompleta().getDeducaoIncentivo());
        objRegTXT.fieldByName("VR_IMPDEV").set(objDecl.getModeloCompleta().getImpostoDevido());
        objRegTXT.fieldByName("VR_CONTPATRONAL").set(objDecl.getResumo().getCalculoImposto().getTotalContribEmpregadoDomestico());
        objRegTXT.fieldByName("VR_IMPDEV2").set(objDecl.getModeloCompleta().getImpostoDevidoI());
        objRegTXT.fieldByName("VR_IMPDEV3").set(objDecl.getModeloCompleta().getImpostoDevidoII());
        objRegTXT.fieldByName("VR_IMPFONTE").set(objDecl.getModeloCompleta().getImpostoRetidoFonteTitular());
        objRegTXT.fieldByName("VR_IMPFONTEDEPENDENTE").set(objDecl.getModeloCompleta().getImpostoRetidoFonteDependentes());
        objRegTXT.fieldByName("VR_CARNELEAO").set(objDecl.getModeloCompleta().getCarneLeaoTitular().operacao('+', objDecl.getModeloCompleta().getCarneLeaoDependentes()));
        objRegTXT.fieldByName("VR_IMPCOMPL").set(objDecl.getModeloCompleta().getImpostoComplementar());
        objRegTXT.fieldByName("VR_IMPEXT").set(objDecl.getModeloCompleta().getImpostoPagoExterior());
        objRegTXT.fieldByName("VR_IRFONTELEI11033").set(objDecl.getModeloCompleta().getImpostoRetidoFonteLei11033());
        objRegTXT.fieldByName("VR_TOTIMPPAGO").set(objDecl.getModeloCompleta().getTotalImpostoPago());
        if (objDecl.getModelo().getImpostoRestituir().comparacao(">", "0,00")) {
            objRegTXT.fieldByName("VR_IMPREST").set(objDecl.getModeloCompleta().getImpostoRestituir());
            objRegTXT.fieldByName("VR_IMPPAGAR").set(0);
        } else if (objDecl.getModelo().getSaldoImpostoPagar().comparacao(">", "0,00")) {
            objRegTXT.fieldByName("VR_IMPPAGAR").set(objDecl.getModeloCompleta().getSaldoImpostoPagar());
            objRegTXT.fieldByName("VR_IMPREST").set(0);
        } else {
            objRegTXT.fieldByName("VR_IMPREST").set(0);
            objRegTXT.fieldByName("VR_IMPPAGAR").set(0);
        }
        objRegTXT.fieldByName("NR_QUOTAS").set(objDecl.getResumo().getCalculoImposto().getNumQuotas().asInteger());
        objRegTXT.fieldByName("VR_QUOTA").set(objDecl.getResumo().getCalculoImposto().getValorQuota());
        objRegTXT.fieldByName("VR_BENSANT").set(objDecl.getModeloCompleta().getBensDireitosExercicioAnterior());
        objRegTXT.fieldByName("VR_BENSATUAL").set(objDecl.getModeloCompleta().getBensDireitosExercicioAtual());
        objRegTXT.fieldByName("VR_DIVIDAANT").set(objDecl.getModeloCompleta().getDividasExercicioAnterior());
        objRegTXT.fieldByName("VR_DIVIDAATUAL").set(objDecl.getModeloCompleta().getDividasExercicioAtual());
        objRegTXT.fieldByName("VR_TOTISENTOS").set(objDecl.getModeloCompleta().getRendIsentosNaoTributaveis());
        objRegTXT.fieldByName("VR_TOTEXCLUS").set((Valor)objDecl.getModeloCompleta().getRendSujeitoTribExclusiva());
        objRegTXT.fieldByName("VR_IMPGC").set((Valor)objDecl.getGCAP().getConsolidacaoGeralBrasil().getTotalImpostoPago());
        objRegTXT.fieldByName("VR_TOTIRFONTELEI11033").set(objDecl.getModeloCompleta().getTotalImpostoRetidoNaFonte());
        objRegTXT.fieldByName("VR_IMPRV").set(objDecl.getModeloCompleta().getImpostoPagoSobreRendaVariavel());
        objRegTXT.fieldByName("VR_IMPPAGOVCBENS").set((Valor)objDecl.getGCAP().getConsolidacaoGeralExterior().getTotalImpostoPago());
        objRegTXT.fieldByName("VR_IMPPAGOVCESPECIE").set(objDecl.getResumo().getOutrasInformacoes().getImpostoEspecie());
        objRegTXT.fieldByName("VR_TOTRENDISENTOSTITULAR").set(objDecl.getRendIsentos().recuperarTotalTitular());
        objRegTXT.fieldByName("VR_TOTRENDISENTOSDEPENDENTE").set(objDecl.getRendIsentos().recuperarTotalDependentes());
        objRegTXT.fieldByName("VR_TOTRENDEXCLTITULAR").set(objDecl.getRendTributacaoExclusiva().recuperarExclusivosTitular());
        objRegTXT.fieldByName("VR_TOTRENDEXCLDEPENDENTE").set(objDecl.getRendTributacaoExclusiva().recuperarExclusivosDependentes());
        objRegTXT.fieldByName("VR_DOACOESCAMPANHA").set(objDecl.getResumo().getOutrasInformacoes().getTotalDoacoesCampanhasEleitorais());
        objRegTXT.fieldByName("VR_TOTRENDPJ_EXIB_SUSPTITULAR").set(objDecl.getRendPJComExigibilidade().getColecaoRendPJComExigibilidadeTitular().getTotaisRendPJExigSuspensa());
        objRegTXT.fieldByName("VR_TOTRENDPJ_EXIB_SUSPDEPENDEN").set(objDecl.getRendPJComExigibilidade().getColecaoRendPJComExigibilidadeDependente().getTotaisRendPJExigSuspensa());
        objRegTXT.fieldByName("VR_TOTDEPJUDIC_TITULAR").set(objDecl.getRendPJComExigibilidade().getColecaoRendPJComExigibilidadeTitular().getTotaisDepositoJudicial());
        objRegTXT.fieldByName("VR_TOTDEPJUDIC_DEPENDEN").set(objDecl.getRendPJComExigibilidade().getColecaoRendPJComExigibilidadeDependente().getTotaisDepositoJudicial());
        objRegTXT.fieldByName("VR_TOTREND_AC_TIT").set(objDecl.getRendAcm().getColecaoRendAcmTitular().getTotaisRendRecebidosAjuste());
        objRegTXT.fieldByName("VR_TOT_PREVOFC_AC_TIT").set(objDecl.getRendAcm().getColecaoRendAcmTitular().getTotaisContribuicaoPrevOficialAjuste());
        objRegTXT.fieldByName("VR_TOT_PENSALI_AC_TIT").set(objDecl.getRendAcm().getColecaoRendAcmTitular().getTotaisPensaoAlimenticiaAjuste());
        objRegTXT.fieldByName("VR_TOT_IRF_AC_TIT").set(objDecl.getRendAcm().getColecaoRendAcmTitular().getTotaisImpostoRetidoFonteExclusiva());
        objRegTXT.fieldByName("VR_TOT_IMPOSTO_RRA_TIT").set(objDecl.getRendAcm().getColecaoRendAcmTitular().getTotaisImpostoDevidoRRA());
        objRegTXT.fieldByName("VR_TOTREND_AC_DEP").set(objDecl.getRendAcm().getColecaoRendAcmDependente().getTotaisRendRecebidosAjuste());
        objRegTXT.fieldByName("VR_TOT_PREVOFC_AC_DEP").set(objDecl.getRendAcm().getColecaoRendAcmDependente().getTotaisContribuicaoPrevOficialAjuste());
        objRegTXT.fieldByName("VR_TOT_PENSALI_AC_DEP").set(objDecl.getRendAcm().getColecaoRendAcmDependente().getTotaisPensaoAlimenticiaAjuste());
        objRegTXT.fieldByName("VR_TOT_IRF_AC_DEP").set(objDecl.getRendAcm().getColecaoRendAcmDependente().getTotaisImpostoRetidoFonteExclusiva());
        objRegTXT.fieldByName("VR_TOT_IMPOSTO_RRA_DEP").set(objDecl.getRendAcm().getColecaoRendAcmDependente().getTotaisImpostoDevidoRRA());
        objRegTXT.fieldByName("VR_IMPOSTO_DIFERIDO_GCAP").set(objDecl.getResumo().getOutrasInformacoes().getImpostoDiferidoGCAP());
        objRegTXT.fieldByName("VR_IMPOSTO_DEVIDO_GCAP").set(objDecl.getResumo().getOutrasInformacoes().getImpostoDevidoGCAP());
        objRegTXT.fieldByName("VR_IMPOSTO_GANHOLIQ_RVAR").set(objDecl.getResumo().getOutrasInformacoes().getImpostoDevidoRendaVariavel());
        objRegTXT.fieldByName("VR_IMPOSTO_DEVIDO_GCME").set(objDecl.getResumo().getOutrasInformacoes().getImpostoDevidoGCME());
        objRegTXT.fieldByName("VR_ALIQUOTA_EFETIVA").set(objDecl.getResumo().getCalculoImposto().getAliquotaEfetiva());
        objRegTXT.fieldByName("VR_BASE_CALCULO_LEI_14754").set(objDecl.getContribuinte().getBaseCalculoFinalLei14754());
        objRegTXT.fieldByName("VR_IMPOSTO_DEVIDO_LEI_14754").set((Valor)objDecl.getContribuinte().getImpostoDevidoLei14754());
        linha.add(objRegTXT);
        return linha;
    }

    public List<RegistroTxt> montarFichaRendPJ(DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        ArrayList<RegistroTxt> linha = new ArrayList<RegistroTxt>();
        ColecaoRendPJTitular colecaoRendimentos = objDecl.getColecaoRendPJTitular();
        for (int i = 0; i < colecaoRendimentos.itens().size(); ++i) {
            RendPJTitular rendimentoPJ = (RendPJTitular)colecaoRendimentos.itens().get(i);
            RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "21");
            objRegTXT.fieldByName("NR_REG").set("21");
            objRegTXT.fieldByName("NR_CPF").set(objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado());
            objRegTXT.fieldByName("NR_PAGADOR").set(rendimentoPJ.getNIFontePagadora().naoFormatado());
            objRegTXT.fieldByName("NM_PAGADOR").setLimitado(rendimentoPJ.getNomeFontePagadora().naoFormatado());
            objRegTXT.fieldByName("VR_RENDTO").set(rendimentoPJ.getRendRecebidoPJ());
            objRegTXT.fieldByName("VR_IMPOSTO").set(rendimentoPJ.getImpostoRetidoFonte());
            objRegTXT.fieldByName("VR_CONTRIB").set(rendimentoPJ.getContribuicaoPrevOficial());
            objRegTXT.fieldByName("VR_DECTERC").set(rendimentoPJ.getDecimoTerceiro());
            objRegTXT.fieldByName("VR_IRRF13SALARIO").set((Valor)rendimentoPJ.getIRRFDecimoTerceiro());
            if (objDecl.getIdentificadorDeclaracao().isSaida()) {
                objRegTXT.fieldByName("DT_COMUNICACAO_SAIDA").set(rendimentoPJ.getDataComunicacaoSaida().naoFormatado());
            }
            linha.add(objRegTXT);
        }
        return linha;
    }

    public List<RegistroTxt> montarFichaRendPF(DeclaracaoIRPF objDecl, boolean ehDependente) throws GeracaoTxtException {
        return this.montarFichaRendPF(objDecl, ehDependente, true);
    }

    public List<RegistroTxt> montarFichaRendPF(DeclaracaoIRPF objDecl, boolean ehDependente, boolean comExterior) throws GeracaoTxtException {
        ArrayList<RegistroTxt> linha = new ArrayList<RegistroTxt>();
        String cpfContrib = objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado();
        if (ehDependente) {
            for (ItemRendPFDependente dep : objDecl.getRendPFDependente().itens()) {
                this.montaRendPF(cpfContrib, dep.getCpf().naoFormatado(), ehDependente, linha, dep.getRendimentos(), comExterior);
            }
        } else {
            this.montaRendPF(cpfContrib, "", ehDependente, linha, objDecl.getRendPFTitular(), comExterior);
        }
        return linha;
    }

    private void montaRendPF(String cpfContribuinte, String cpfDependente, boolean ehDependente, List<RegistroTxt> linha, RendPF colecaoRendPF) throws GeracaoTxtException {
        this.montaRendPF(cpfContribuinte, cpfDependente, ehDependente, linha, colecaoRendPF, true);
    }

    private void montaRendPF(String cpfContribuinte, String cpfDependente, boolean ehDependente, List<RegistroTxt> linha, RendPF colecaoRendPF, boolean comExterior) throws GeracaoTxtException {
        if (ehDependente || !colecaoRendPF.isVazio()) {
            for (int i = 1; i <= 12; ++i) {
                MesRendPF rendimentoMensalPF = colecaoRendPF.getMesRendPFPorIndice(i - 1);
                RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "22");
                objRegTXT.fieldByName("NR_REG").set("22");
                objRegTXT.fieldByName("NR_CPF").set(cpfContribuinte);
                objRegTXT.fieldByName("E_DEPENDENTE").set(ehDependente);
                objRegTXT.fieldByName("NR_CPF_DEPEN").set(cpfDependente);
                objRegTXT.fieldByName("NR_MES").set(i);
                objRegTXT.fieldByName("VR_RENDTO").set(rendimentoMensalPF.getPessoaFisica());
                objRegTXT.fieldByName("VR_ALUGUEIS").set(rendimentoMensalPF.getAlugueis());
                objRegTXT.fieldByName("VR_OUTROS").set(rendimentoMensalPF.getOutros());
                if (comExterior) {
                    objRegTXT.fieldByName("VR_EXTER").set(rendimentoMensalPF.getExterior());
                }
                objRegTXT.fieldByName("VR_LIVCAIX").set(rendimentoMensalPF.getLivroCaixa());
                objRegTXT.fieldByName("VR_ALIMENT").set(rendimentoMensalPF.getPensao());
                objRegTXT.fieldByName("VR_DEDUC").set(rendimentoMensalPF.getDependentes());
                objRegTXT.fieldByName("VR_PREVID").set(rendimentoMensalPF.getPrevidencia());
                Valor valBaseCalculo = new Valor();
                valBaseCalculo.append('+', rendimentoMensalPF.getPessoaFisica());
                if (comExterior) {
                    valBaseCalculo.append('+', rendimentoMensalPF.getExterior());
                }
                valBaseCalculo.append('+', rendimentoMensalPF.getAlugueis());
                valBaseCalculo.append('+', rendimentoMensalPF.getOutros());
                valBaseCalculo.append('-', rendimentoMensalPF.getPrevidencia());
                valBaseCalculo.append('-', rendimentoMensalPF.getDependentes());
                valBaseCalculo.append('-', rendimentoMensalPF.getPensao());
                valBaseCalculo.append('-', rendimentoMensalPF.getLivroCaixa());
                int tamanho = valBaseCalculo.getParteInteira().length();
                if (valBaseCalculo.getConteudo() < 0L) {
                    ++tamanho;
                }
                if (tamanho > valBaseCalculo.getMaximoDigitosParteInteira()) {
                    valBaseCalculo.setConteudo(Long.valueOf(0L));
                }
                objRegTXT.fieldByName("VR_BASECALCULO").set(valBaseCalculo);
                objRegTXT.fieldByName("VR_IMPOSTO").set(rendimentoMensalPF.getDarfPago());
                linha.add(objRegTXT);
            }
        }
    }

    public List<RegistroTxt> montarFichaRendPFTrabalhoNaoAssalariado(DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        Vector<RegistroTxt> linha = new Vector<RegistroTxt>();
        this.montarRegistroRendPFTrabNaoAssalariado(linha, objDecl.getRendPFTitular(), objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado());
        for (ItemRendPFDependente lItem : objDecl.getRendPFDependente().itens()) {
            this.montarRegistroRendPFTrabNaoAssalariado(linha, lItem.getRendimentos(), objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado());
        }
        return linha;
    }

    private void montarRegistroRendPFTrabNaoAssalariado(Vector<RegistroTxt> linha, RendPF rendPF, String cpfTitular) throws GeracaoTxtException {
        for (ContasMes mes : rendPF.getContasAno().getColecaoEscrituracao().itens()) {
            for (Conta conta : mes.itens()) {
                RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "49");
                objRegTXT.fieldByName("NR_REG").set("49");
                objRegTXT.fieldByName("NR_CPF_TITULAR").set(cpfTitular);
                if (conta.getCpfContribuinte().naoFormatado().equals(cpfTitular)) {
                    objRegTXT.fieldByName("NR_CPF_DEPENDENTE").set("           ");
                } else {
                    objRegTXT.fieldByName("NR_CPF_DEPENDENTE").set(conta.getCpfContribuinte().naoFormatado());
                }
                objRegTXT.fieldByName("NR_MES").set(conta.getDataMesAno().naoFormatado().substring(0, 2));
                objRegTXT.fieldByName("NR_CPF_TITULAR_PAGAMENTO").set(conta.getCpfTitularPagamento().naoFormatado());
                objRegTXT.fieldByName("NR_CPF_BENEFIC").set(conta.getCpfBeneficiarioServico().naoFormatado());
                objRegTXT.fieldByName("NR_VALOR").set(conta.getValor());
                linha.add(objRegTXT);
            }
        }
    }

    public List<RegistroTxt> montarFichaRendPJExigTitular(DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        Vector<RegistroTxt> linha = new Vector<RegistroTxt>();
        String cpfContrib = objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado();
        ColecaoRendPJComExigibilidadeTitular col = objDecl.getColecaoRendPJComExigibilidadeTitular();
        col.excluirRegistrosEmBranco();
        for (ObjetoNegocio item : col.itens()) {
            RendPJComExigibilidadeTitular rend = (RendPJComExigibilidadeTitular)item;
            RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "80");
            objRegTXT.fieldByName("NR_REG").set("80");
            objRegTXT.fieldByName("NR_CPF").set(cpfContrib);
            objRegTXT.fieldByName("NR_PAGADOR").set(rend.getNIFontePagadora().naoFormatado());
            objRegTXT.fieldByName("NM_PAGADOR").set(rend.getNomeFontePagadora().naoFormatado());
            objRegTXT.fieldByName("VR_DEP_JUDICIAL").set((Valor)rend.getDepositoJudicial());
            objRegTXT.fieldByName("VR_RENDTO").set((Valor)rend.getRendExigSuspensa());
            linha.add(objRegTXT);
        }
        return linha;
    }

    public List<RegistroTxt> montarFichaRendPJExigDependente(DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        Vector<RegistroTxt> linha = new Vector<RegistroTxt>();
        String cpfContrib = objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado();
        ColecaoRendPJComExigibilidadeDependente col = objDecl.getColecaoRendPJComExigibilidadeDependente();
        col.excluirRegistrosEmBranco();
        for (ObjetoNegocio item : col.itens()) {
            RendPJComExigibilidadeDependente rend = (RendPJComExigibilidadeDependente)item;
            RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "81");
            objRegTXT.fieldByName("NR_REG").set("81");
            objRegTXT.fieldByName("NR_CPF").set(cpfContrib);
            objRegTXT.fieldByName("CPF_BENEF").set(rend.getCpfDependente().naoFormatado());
            objRegTXT.fieldByName("NR_PAGADOR").set(rend.getNIFontePagadora().naoFormatado());
            objRegTXT.fieldByName("NM_PAGADOR").set(rend.getNomeFontePagadora().naoFormatado());
            objRegTXT.fieldByName("VR_DEP_JUDICIAL").set((Valor)rend.getDepositoJudicial());
            objRegTXT.fieldByName("VR_RENDTO").set((Valor)rend.getRendExigSuspensa());
            linha.add(objRegTXT);
        }
        return linha;
    }

    public List<RegistroTxt> montarFichaRendAcmTitular(DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        Vector<RegistroTxt> linha = new Vector<RegistroTxt>();
        int i = 1;
        int opcaoTributacao = 2;
        String cpfContrib = objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado();
        ColecaoRendAcmTitular col = objDecl.getColecaoRendAcmTitular();
        col.excluirRegistrosEmBranco();
        for (ObjetoNegocio item : col.itens()) {
            RendAcmTitular rend = (RendAcmTitular)item;
            if (rend.getOpcaoTributacao().naoFormatado().equals("A")) {
                opcaoTributacao = 0;
            } else if (rend.getOpcaoTributacao().naoFormatado().equals("E")) {
                opcaoTributacao = 1;
            }
            rend.setChave(String.valueOf(i++));
            RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "45");
            objRegTXT.fieldByName("NR_REG").set("45");
            objRegTXT.fieldByName("NR_CPF").set(cpfContrib);
            objRegTXT.fieldByName("CD_RRA_TITULAR").set(rend.getChave());
            objRegTXT.fieldByName("NR_PAGADOR").set(rend.getNiFontePagadora().naoFormatado());
            objRegTXT.fieldByName("NM_PAGADOR").set(rend.getNomeFontePagadora().naoFormatado());
            objRegTXT.fieldByName("VR_RENDTO").set((Valor)rend.getRendRecebidosInformado());
            objRegTXT.fieldByName("VR_ISENTO_65").set((Valor)rend.getParcIsenta65Anos());
            objRegTXT.fieldByName("VR_VALOR_TRIBUTAVEL").set((Valor)rend.getRendRecebidos());
            objRegTXT.fieldByName("VR_CONTRIB").set((Valor)rend.getContribuicaoPrevOficial());
            objRegTXT.fieldByName("VR_PENSAO").set((Valor)rend.getPensaoAlimenticia());
            objRegTXT.fieldByName("VR_IMPOSTO").set((Valor)rend.getImpostoRetidoFonte());
            objRegTXT.fieldByName("NR_MES_RECEBIMENTO").set(rend.getMesRecebimento().naoFormatado());
            objRegTXT.fieldByName("VR_JUROS").set((Valor)rend.getValorJuros());
            objRegTXT.fieldByName("OPCAO_TRIBUTACAO").set(opcaoTributacao);
            objRegTXT.fieldByName("NUM_MESES").set((Valor)rend.getNumMeses());
            objRegTXT.fieldByName("IMPOSTO_RRA").set((Valor)rend.getImpostoDevidoRRA());
            linha.add(objRegTXT);
        }
        return linha;
    }

    public List<RegistroTxt> montarFichaRendAcmTitularPensao(DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        Vector<RegistroTxt> linha = new Vector<RegistroTxt>();
        ColecaoRendAcmTitular col = objDecl.getColecaoRendAcmTitular();
        col.excluirRegistrosEmBranco();
        String cpfContrib = objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado();
        Alimentandos colAlimentandos = objDecl.getAlimentandos();
        for (ObjetoNegocio item : col.itens()) {
            RendAcmTitular rend = (RendAcmTitular)item;
            for (ObjetoNegocio itemPensao : rend.getPensaoAlimenticiaQuadroAuxiliar().itens()) {
                ItemQuadroPensaoAlimenticia pensao = (ItemQuadroPensaoAlimenticia)itemPensao;
                RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "46");
                objRegTXT.fieldByName("NR_REG").set("46");
                objRegTXT.fieldByName("NR_CPF").set(cpfContrib);
                objRegTXT.fieldByName("CD_RRA_TITULAR").set(rend.getChave());
                String chave = colAlimentandos.getChaveAlimentandoByNome(pensao.getAlimentando().naoFormatado());
                objRegTXT.fieldByName("NR_CHAVE_ALIMENT").set(chave != null ? chave : "");
                objRegTXT.fieldByName("VR_PAGTO").set(pensao.getValor());
                linha.add(objRegTXT);
            }
        }
        return linha;
    }

    public List<RegistroTxt> montarFichaRendAcmDependentes(DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        Vector<RegistroTxt> linha = new Vector<RegistroTxt>();
        int i = 1;
        int opcaoTributacao = 2;
        String cpfContrib = objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado();
        ColecaoRendAcmDependente col = objDecl.getColecaoRendAcmDependente();
        col.excluirRegistrosEmBranco();
        for (ObjetoNegocio item : col.itens()) {
            RendAcmDependente rend = (RendAcmDependente)item;
            if (rend.getOpcaoTributacao().naoFormatado().equals("A")) {
                opcaoTributacao = 0;
            } else if (rend.getOpcaoTributacao().naoFormatado().equals("E")) {
                opcaoTributacao = 1;
            }
            rend.setChave(String.valueOf(i++));
            RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "47");
            objRegTXT.fieldByName("NR_REG").set("47");
            objRegTXT.fieldByName("NR_CPF").set(cpfContrib);
            objRegTXT.fieldByName("CD_RRA_DEPENDENTE").set(rend.getChave());
            objRegTXT.fieldByName("CPF_BENEF").set(rend.getCpfDependente().naoFormatado());
            objRegTXT.fieldByName("NR_PAGADOR").set(rend.getNiFontePagadora().naoFormatado());
            objRegTXT.fieldByName("NM_PAGADOR").set(rend.getNomeFontePagadora().naoFormatado());
            objRegTXT.fieldByName("VR_RENDTO").set((Valor)rend.getRendRecebidosInformado());
            objRegTXT.fieldByName("VR_ISENTO_65").set((Valor)rend.getParcIsenta65Anos());
            objRegTXT.fieldByName("VR_VALOR_TRIBUTAVEL").set((Valor)rend.getRendRecebidos());
            objRegTXT.fieldByName("VR_CONTRIB").set((Valor)rend.getContribuicaoPrevOficial());
            objRegTXT.fieldByName("VR_PENSAO").set((Valor)rend.getPensaoAlimenticia());
            objRegTXT.fieldByName("VR_IMPOSTO").set((Valor)rend.getImpostoRetidoFonte());
            objRegTXT.fieldByName("NR_MES_RECEBIMENTO").set(rend.getMesRecebimento().naoFormatado());
            objRegTXT.fieldByName("VR_JUROS").set((Valor)rend.getValorJuros());
            objRegTXT.fieldByName("OPCAO_TRIBUTACAO").set(opcaoTributacao);
            objRegTXT.fieldByName("NUM_MESES").set((Valor)rend.getNumMeses());
            objRegTXT.fieldByName("IMPOSTO_RRA").set((Valor)rend.getImpostoDevidoRRA());
            linha.add(objRegTXT);
        }
        return linha;
    }

    public List<RegistroTxt> montarFichaRendAcmDependentesPensao(DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        Vector<RegistroTxt> linha = new Vector<RegistroTxt>();
        ColecaoRendAcmDependente col = objDecl.getColecaoRendAcmDependente();
        col.excluirRegistrosEmBranco();
        String cpfContrib = objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado();
        Alimentandos colAlimentandos = objDecl.getAlimentandos();
        for (ObjetoNegocio item : col.itens()) {
            RendAcmDependente rend = (RendAcmDependente)item;
            for (ObjetoNegocio itemPensao : rend.getPensaoAlimenticiaQuadroAuxiliar().itens()) {
                ItemQuadroPensaoAlimenticia pensao = (ItemQuadroPensaoAlimenticia)itemPensao;
                RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "48");
                objRegTXT.fieldByName("NR_REG").set("48");
                objRegTXT.fieldByName("NR_CPF").set(cpfContrib);
                objRegTXT.fieldByName("CD_RRA_DEPEND").set(rend.getChave());
                String chave = colAlimentandos.getChaveAlimentandoByNome(pensao.getAlimentando().naoFormatado());
                objRegTXT.fieldByName("NR_CHAVE_ALIMENT").set(chave != null ? chave : "");
                objRegTXT.fieldByName("VR_PAGTO").set(pensao.getValor());
                linha.add(objRegTXT);
            }
        }
        return linha;
    }

    public List<RegistroTxt> montarFichaHerdeiros(DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        Vector<RegistroTxt> linha = new Vector<RegistroTxt>();
        String cpfContrib = objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado();
        Herdeiros col = objDecl.getHerdeiros();
        col.excluirRegistrosEmBranco();
        int i = 1;
        for (ObjetoNegocio item : col.itens()) {
            Herdeiro herdeiro = (Herdeiro)item;
            herdeiro.setChave(String.valueOf(i++));
            RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "58");
            objRegTXT.fieldByName("NR_REG").set("58");
            objRegTXT.fieldByName("NR_CPF").set(cpfContrib);
            objRegTXT.fieldByName("NR_CHAVE_HERDEIRO").set(herdeiro.getChave());
            objRegTXT.fieldByName("NM_NOME").set(herdeiro.getNome().naoFormatado());
            objRegTXT.fieldByName("NR_CPF_CNPJ").set(herdeiro.getNiHerdeiro().naoFormatado());
            linha.add(objRegTXT);
        }
        return linha;
    }

    public List<RegistroTxt> montarFichaPercentualBem(DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        Vector<RegistroTxt> linha = new Vector<RegistroTxt>();
        Bens col = objDecl.getBens();
        col.excluirRegistrosEmBranco();
        String cpfContrib = objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado();
        Herdeiros colHerdeiros = objDecl.getHerdeiros();
        for (ObjetoNegocio item : col.itens()) {
            Bem bem = (Bem)item;
            for (ObjetoNegocio itemPensao : bem.getParticipacoesInventario().itens()) {
                ItemPercentualParticipacaoInventario percParticipacao = (ItemPercentualParticipacaoInventario)itemPensao;
                RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "59");
                objRegTXT.fieldByName("NR_REG").set("59");
                objRegTXT.fieldByName("NR_CPF").set(cpfContrib);
                objRegTXT.fieldByName("NR_CHAVE_BEM").set(bem.getChave());
                objRegTXT.fieldByName("NR_CHAVE_HERDEIRO").set(colHerdeiros.getChaveHerdeiroByNI(percParticipacao.getNi().naoFormatado()));
                objRegTXT.fieldByName("VR_PERCENTUAL").set((Valor)percParticipacao.getPercentual());
                linha.add(objRegTXT);
            }
        }
        return linha;
    }

    public void auxMontaRegistroRendIsento(List<RegistroTxt> linha, String cpf, String cod, Valor aValor) throws GeracaoTxtException {
        if (!aValor.isVazio()) {
            RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "23");
            objRegTXT.fieldByName("NR_REG").set("23");
            objRegTXT.fieldByName("NR_CPF").set(cpf);
            objRegTXT.fieldByName("CD_ISENTO").set(cod);
            objRegTXT.fieldByName("VR_VALOR").set(aValor);
            linha.add(objRegTXT);
        }
    }

    public void auxMontaRegistroRendExclusivo(List<RegistroTxt> linha, String cpf, String cod, Valor aValor) throws GeracaoTxtException {
        if (!aValor.isVazio()) {
            RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "24");
            objRegTXT.fieldByName("NR_REG").set("24");
            objRegTXT.fieldByName("NR_CPF").set(cpf);
            objRegTXT.fieldByName("CD_EXCLUSIVO").set(cod);
            objRegTXT.fieldByName("VR_VALOR").set(aValor);
            linha.add(objRegTXT);
        }
    }

    public List<RegistroTxt> montarFichaRendIsentos(DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        return this.montarFichaRendIsentos(objDecl, false);
    }

    public List<RegistroTxt> montarFichaRendIsentos(DeclaracaoIRPF objDecl, boolean salvarOnline) throws GeracaoTxtException {
        ArrayList<RegistroTxt> linha = new ArrayList<RegistroTxt>();
        String cpf = objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado();
        RendIsentos rendIsentos = objDecl.getRendIsentos();
        if (rendIsentos.getTotal().comparacao(">", "0,00")) {
            this.auxMontaRegistroRendIsento(linha, cpf, "01", rendIsentos.getBolsaEstudos());
            this.auxMontaRegistroRendIsento(linha, cpf, "02", (Valor)rendIsentos.getMedicosResidentes());
            this.auxMontaRegistroRendIsento(linha, cpf, "03", rendIsentos.getCapitalApolices());
            this.auxMontaRegistroRendIsento(linha, cpf, "04", rendIsentos.getIndenizacoes());
            this.auxMontaRegistroRendIsento(linha, cpf, "05", (Valor)rendIsentos.getSomaBensPequenoValor());
            this.auxMontaRegistroRendIsento(linha, cpf, "06", (Valor)rendIsentos.getSomaUnicoImovel());
            this.auxMontaRegistroRendIsento(linha, cpf, "07", (Valor)rendIsentos.getSomaOutrosBensImoveis());
            this.auxMontaRegistroRendIsento(linha, cpf, "08", rendIsentos.getMoedaEstrangeiraEspecieInformado());
            this.auxMontaRegistroRendIsento(linha, cpf, "09", rendIsentos.getLucroRecebido());
            this.auxMontaRegistroRendIsento(linha, cpf, "10", rendIsentos.getParcIsentaAposentadoria());
            this.auxMontaRegistroRendIsento(linha, cpf, "11", rendIsentos.getPensao());
            this.auxMontaRegistroRendIsento(linha, cpf, "12", rendIsentos.getPoupanca());
            this.auxMontaRegistroRendIsento(linha, cpf, "13", rendIsentos.getRendSocio());
            this.auxMontaRegistroRendIsento(linha, cpf, "14", rendIsentos.getTransferencias());
            if (!salvarOnline) {
                this.auxMontaRegistroRendIsento(linha, cpf, "15", rendIsentos.getParcIsentaAtivRural());
            }
            this.auxMontaRegistroRendIsento(linha, cpf, "16", (Valor)rendIsentos.getImpostoRendasAnterioresCompensadoJudicialmente());
            this.auxMontaRegistroRendIsento(linha, cpf, "17", (Valor)rendIsentos.getRendAssalariadosMoedaEstrangeira());
            this.auxMontaRegistroRendIsento(linha, cpf, "18", (Valor)rendIsentos.getIncorporacaoReservaCapital());
            this.auxMontaRegistroRendIsento(linha, cpf, "19", (Valor)rendIsentos.getMeacaoDissolucao());
            this.auxMontaRegistroRendIsento(linha, cpf, "20", (Valor)rendIsentos.getGanhosLiquidosAcoes());
            this.auxMontaRegistroRendIsento(linha, cpf, "21", (Valor)rendIsentos.getGanhosCapitalOuro());
            if (!salvarOnline) {
                this.auxMontaRegistroRendIsento(linha, cpf, "22", (Valor)rendIsentos.getRecuperacaoPrejuizosBolsaValores());
            }
            this.auxMontaRegistroRendIsento(linha, cpf, "23", (Valor)rendIsentos.getTransportadorCargas());
            this.auxMontaRegistroRendIsento(linha, cpf, "24", (Valor)rendIsentos.getTransportadorPassageiros());
            this.auxMontaRegistroRendIsento(linha, cpf, "25", (Valor)rendIsentos.getRestituicaoImpostoRendaAnosAnteriores());
            this.auxMontaRegistroRendIsento(linha, cpf, "26", rendIsentos.getOutros());
            this.auxMontaRegistroRendIsento(linha, cpf, "27", rendIsentos.getJurosRra());
            this.auxMontaRegistroRendIsento(linha, cpf, "28", rendIsentos.getPensaoAlimenticia());
        }
        return linha;
    }

    public List<RegistroTxt> montarFichaRendTribExcl(DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        ArrayList<RegistroTxt> linhas = new ArrayList<RegistroTxt>();
        String cpf = objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado();
        RendTributacaoExclusiva rendExclusivos = objDecl.getRendTributacaoExclusiva();
        if (rendExclusivos.getTotal().comparacao(">", "0,00")) {
            this.auxMontaRegistroRendExclusivo(linhas, cpf, "01", rendExclusivos.getDecimoTerceiro());
            this.auxMontaRegistroRendExclusivo(linhas, cpf, "02", rendExclusivos.getGanhosCapital());
            this.auxMontaRegistroRendExclusivo(linhas, cpf, "03", rendExclusivos.getGanhosCapitalEstrangeira());
            this.auxMontaRegistroRendExclusivo(linhas, cpf, "04", rendExclusivos.getGanhosCapitalEmEspecie());
            this.auxMontaRegistroRendExclusivo(linhas, cpf, "05", rendExclusivos.getGanhosRendaVariavel());
            this.auxMontaRegistroRendExclusivo(linhas, cpf, "06", rendExclusivos.getRendAplicacoes());
            this.auxMontaRegistroRendExclusivo(linhas, cpf, "07", (Valor)rendExclusivos.getRraTitular());
            this.auxMontaRegistroRendExclusivo(linhas, cpf, "08", rendExclusivos.getDecimoTerceiroDependentes());
            this.auxMontaRegistroRendExclusivo(linhas, cpf, "09", (Valor)rendExclusivos.getRraDependentes());
            this.auxMontaRegistroRendExclusivo(linhas, cpf, "10", rendExclusivos.getJurosCapitalProprio());
            this.auxMontaRegistroRendExclusivo(linhas, cpf, "11", rendExclusivos.getParticipacaoLucrosResultados());
            this.auxMontaRegistroRendExclusivo(linhas, cpf, "12", rendExclusivos.getOutros());
            this.auxMontaRegistroRendExclusivo(linhas, cpf, "13", (Valor)rendExclusivos.getLei14754());
        }
        return linhas;
    }

    public List<RegistroTxt> montarFichaRendTribExclSalvarOnline(DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        ArrayList<RegistroTxt> linha = new ArrayList<RegistroTxt>();
        RendTributacaoExclusiva rendExclusivos = objDecl.getRendTributacaoExclusiva();
        if (rendExclusivos.getTotal().comparacao(">", "0,00")) {
            for (int tipo = 1; tipo <= 12; ++tipo) {
                if (tipo == 2 || tipo == 3 || tipo == 4 || tipo == 5 || rendExclusivos.getValorPorTipoRendimento(tipo).isVazio()) continue;
                RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "24");
                objRegTXT.fieldByName("NR_REG").set("24");
                objRegTXT.fieldByName("NR_CPF").set(objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado());
                objRegTXT.fieldByName("CD_EXCLUSIVO").set(ConstantesRepositorio.ARR_TIPOS_EXCLUSIVA[tipo - 1]);
                objRegTXT.fieldByName("VR_VALOR").set(rendExclusivos.getValorPorTipoRendimento(tipo));
                linha.add(objRegTXT);
            }
        }
        return linha;
    }

    public List<RegistroTxt> montarFichaDependentes(DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        ArrayList<RegistroTxt> linha = new ArrayList<RegistroTxt>();
        Dependentes colecaoDependentes = objDecl.getDependentes();
        for (int i = 0; i < colecaoDependentes.itens().size(); ++i) {
            ItemRendPFDependente rendimentosDependente;
            Dependente dependente = (Dependente)colecaoDependentes.itens().get(i);
            RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "25");
            objRegTXT.fieldByName("NR_REG").set("25");
            objRegTXT.fieldByName("NR_CPF").set(objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado());
            try {
                objRegTXT.fieldByName("CD_DEPEND").set(dependente.getCodigo().getConteudoAtual(0));
            }
            catch (Exception exception) {
                // empty catch block
            }
            objRegTXT.fieldByName("NR_CHAVE").set(i + 1);
            objRegTXT.fieldByName("NM_DEPEND").setLimitado(dependente.getNome().naoFormatado());
            objRegTXT.fieldByName("DT_NASCIM").set(dependente.getDataNascimento().naoFormatado());
            objRegTXT.fieldByName("NI_DEPEND").set(dependente.getCpfDependente().naoFormatado());
            if (objDecl.getIdentificadorDeclaracao().isSaida()) {
                objRegTXT.fieldByName("IN_SAIDA").set(dependente.getIndSaidaPaisMesmaData().naoFormatado());
            }
            if ((rendimentosDependente = objDecl.getRendPFDependente().obterItemRendPFDependentePorCPF(dependente.getCpfDependente().naoFormatado())) != null) {
                objRegTXT.fieldByName("NR_NITPISPASEP").set(rendimentosDependente.getRendimentos().getNITPISPASEP().naoFormatado());
            }
            if (dependente.getIndMoraComTitular().isVazio()) {
                dependente.getIndMoraComTitular().setConteudo("0");
            }
            objRegTXT.fieldByName("IN_ENDERECO_TITULAR").set(dependente.getIndMoraComTitular().naoFormatado());
            if (objDecl.getContribuinte().getExterior().naoFormatado().equals(Logico.NAO) || !"1".equals(dependente.getIndMoraComTitular().naoFormatado())) {
                objRegTXT.fieldByName("NR_DDD_CELULAR").set(dependente.getDdd().naoFormatado());
                objRegTXT.fieldByName("NR_CELULAR").set(dependente.getTelefone().naoFormatado());
            }
            objRegTXT.fieldByName("NM_EMAIL").set(dependente.getEmail().naoFormatado());
            linha.add(objRegTXT);
        }
        return linha;
    }

    public List<RegistroTxt> montarFichaPagamentos(DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        ArrayList<RegistroTxt> linha = new ArrayList<RegistroTxt>();
        Pagamentos colecaoPagamentos = objDecl.getPagamentos();
        for (int i = 0; i < colecaoPagamentos.itens().size(); ++i) {
            Pagamento pagamento = (Pagamento)colecaoPagamentos.itens().get(i);
            RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "26");
            objRegTXT.fieldByName("NR_REG").set("26");
            objRegTXT.fieldByName("NR_CPF").set(objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado());
            objRegTXT.fieldByName("CD_PAGTO").set(pagamento.getCodigo().naoFormatado());
            objRegTXT.fieldByName("NR_BENEF").set(pagamento.getNiBeneficiario().naoFormatado());
            objRegTXT.fieldByName("NR_CHAVE_DEPEND").set(objDecl.getChaveDependenteOuAlimentando(pagamento));
            objRegTXT.fieldByName("NM_BENEF").set(this.retornaNomeBeneficario(pagamento));
            objRegTXT.fieldByName("NR_NIT").setLimitado(pagamento.getNitEmpregadoDomestico().naoFormatado());
            objRegTXT.fieldByName("VR_PAGTO").set(pagamento.getValorPago());
            objRegTXT.fieldByName("VR_REDUC").set(pagamento.getParcelaNaoDedutivel());
            objRegTXT.fieldByName("VR_CONTRIB_PATR").set(pagamento.getContribuicaoEntePatrocinador());
            objRegTXT.fieldByName("IN_TIPO_PGTO").set(pagamento.getTipo().naoFormatado().equals("V") ? " " : pagamento.getTipo().naoFormatado());
            if (pagamento.getNiBeneficiario().naoFormatado().length() == 14) {
                objRegTXT.fieldByName("IN_TIPO_CPF_CNPJ").set("2");
            } else if (pagamento.getNiBeneficiario().naoFormatado().length() == 11) {
                objRegTXT.fieldByName("IN_TIPO_CPF_CNPJ").set("1");
            } else {
                objRegTXT.fieldByName("IN_TIPO_CPF_CNPJ").set("0");
            }
            objRegTXT.fieldByName("NM_DESCRICAO").set(pagamento.getDescricao().naoFormatado());
            objRegTXT.fieldByName("CD_PAIS").set(pagamento.getPais().naoFormatado());
            linha.add(objRegTXT);
        }
        return linha;
    }

    private String retornaNomeBeneficario(Pagamento pagamento) {
        String conteudo = pagamento.isPensao() ? pagamento.getDependenteOuAlimentando().naoFormatado() : pagamento.getNomeBeneficiario().naoFormatado();
        return conteudo;
    }

    public List<RegistroTxt> montarFichaDoacoes(DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        ArrayList<RegistroTxt> linha = new ArrayList<RegistroTxt>();
        Doacoes colecaoDoacoes = objDecl.getDoacoes();
        for (int i = 0; i < colecaoDoacoes.itens().size(); ++i) {
            Doacao doacao = (Doacao)colecaoDoacoes.itens().get(i);
            RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "90");
            objRegTXT.fieldByName("NR_REG").set("90");
            objRegTXT.fieldByName("NR_CPF").set(objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado());
            objRegTXT.fieldByName("CD_DOACAO").set(doacao.getCodigo().naoFormatado());
            objRegTXT.fieldByName("NR_BENEF").set(doacao.getNiBeneficiario().naoFormatado());
            objRegTXT.fieldByName("NM_BENEF").setLimitado(doacao.getNomeBeneficiario().naoFormatado());
            objRegTXT.fieldByName("VR_DOACAO").set(doacao.getValorPago());
            objRegTXT.fieldByName("VR_PARC_NAO_DEDUT").set(doacao.getParcelaNaoDedutivel());
            if (doacao.getNiBeneficiario().naoFormatado().length() == 14) {
                objRegTXT.fieldByName("IN_TIPO_CPF_CNPJ").set("2");
            } else if (doacao.getNiBeneficiario().naoFormatado().length() == 11) {
                objRegTXT.fieldByName("IN_TIPO_CPF_CNPJ").set("1");
            } else {
                objRegTXT.fieldByName("IN_TIPO_CPF_CNPJ").set("0");
            }
            linha.add(objRegTXT);
        }
        return linha;
    }

    public List<RegistroTxt> montarFichaEstatutoCriancaAdolescente(DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        ArrayList<RegistroTxt> linha = new ArrayList<RegistroTxt>();
        if (objDecl.getIdentificadorDeclaracao().isCompleta()) {
            ColecaoEstatutoCriancaAdolescente colecaoEstatutoCriancaAdolescente = objDecl.getColecaoEstatutoCriancaAdolescente();
            for (int i = 0; i < colecaoEstatutoCriancaAdolescente.itens().size(); ++i) {
                EstatutoCriancaAdolescente estatutoCriancaAdolescente = (EstatutoCriancaAdolescente)colecaoEstatutoCriancaAdolescente.itens().get(i);
                RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "91");
                objRegTXT.fieldByName("NR_REG").set("91");
                objRegTXT.fieldByName("NR_CPF").set(objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado());
                objRegTXT.fieldByName("IN_TIPO_FUNDO").set(estatutoCriancaAdolescente.getTipoFundo().naoFormatado());
                objRegTXT.fieldByName("SG_UF").set(estatutoCriancaAdolescente.getUf().naoFormatado());
                objRegTXT.fieldByName("NM_MUNICIPIO").setLimitado(estatutoCriancaAdolescente.getNomeMunicipio().naoFormatado());
                objRegTXT.fieldByName("VR_DOACAO").set(estatutoCriancaAdolescente.getValor());
                objRegTXT.fieldByName("NR_CNPJ_FUNDO").set(estatutoCriancaAdolescente.getCnpjFundo().naoFormatado());
                linha.add(objRegTXT);
            }
        }
        return linha;
    }

    public List<RegistroTxt> montarFichaEstatutoIdoso(DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        ArrayList<RegistroTxt> linha = new ArrayList<RegistroTxt>();
        if (objDecl.getIdentificadorDeclaracao().isCompleta()) {
            ColecaoEstatutoIdoso colecaoEstatutoIdoso = objDecl.getColecaoEstatutoIdoso();
            for (int i = 0; i < colecaoEstatutoIdoso.itens().size(); ++i) {
                EstatutoIdoso estatutoIdoso = (EstatutoIdoso)colecaoEstatutoIdoso.itens().get(i);
                RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "92");
                objRegTXT.fieldByName("NR_REG").set("92");
                objRegTXT.fieldByName("NR_CPF").set(objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado());
                objRegTXT.fieldByName("IN_TIPO_FUNDO").set(estatutoIdoso.getTipoFundo().naoFormatado());
                objRegTXT.fieldByName("SG_UF").set(estatutoIdoso.getUf().naoFormatado());
                objRegTXT.fieldByName("NM_MUNICIPIO").setLimitado(estatutoIdoso.getNomeMunicipio().naoFormatado());
                objRegTXT.fieldByName("VR_DOACAO").set(estatutoIdoso.getValor());
                objRegTXT.fieldByName("NR_CNPJ_FUNDO").set(estatutoIdoso.getCnpjFundo().naoFormatado());
                linha.add(objRegTXT);
            }
        }
        return linha;
    }

    public List<RegistroTxt> montarFichaSocio(DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        ArrayList<RegistroTxt> linha = new ArrayList<RegistroTxt>();
        return linha;
    }

    public void montarFichaJurosCapitalProprio(DeclaracaoIRPF objDecl, List<RegistroTxt> linha) throws GeracaoTxtException {
        ColecaoItemQuadroTransporteDetalhado jurosCapitalProprio = objDecl.getRendTributacaoExclusiva().getJurosCapitalProprioQuadroAuxiliar();
        for (ItemQuadroTransporteDetalhado item : jurosCapitalProprio.itens()) {
            RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "88");
            objRegTXT.fieldByName("NR_REG").set("88");
            objRegTXT.fieldByName("NR_CPF").set(objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado());
            String tipo = item.getTipoBeneficiario().naoFormatado().trim().length() == 0 ? " " : item.getTipoBeneficiario().naoFormatado().substring(0, 1);
            objRegTXT.fieldByName("IN_TIPO").set(tipo);
            objRegTXT.fieldByName("NR_CPF_BENEFIC").set(item.getCpfBeneficiario().naoFormatado());
            objRegTXT.fieldByName("NR_COD").set("0010");
            objRegTXT.fieldByName("NR_PAGADORA").set(item.getNIFontePagadora().naoFormatado());
            objRegTXT.fieldByName("NM_NOME").set(item.getNomeFonte().naoFormatado());
            objRegTXT.fieldByName("VR_VALOR").set(item.getValor());
            objRegTXT.fieldByName("NR_CHAVE_BEM").set(item.getCodBem().naoFormatado());
            linha.add(objRegTXT);
        }
    }

    private void auxMontarFicharRendimentoIsentoTipo2(List<RegistroTxt> linha, String cpf, String tipo, String cpfBenef, String nrCod, Valor valor) throws GeracaoTxtException {
        RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "83");
        objRegTXT.fieldByName("NR_REG").set("83");
        objRegTXT.fieldByName("NR_CPF").set(cpf);
        objRegTXT.fieldByName("IN_TIPO").set(tipo);
        objRegTXT.fieldByName("NR_CPF_BENEFIC").set(cpfBenef);
        objRegTXT.fieldByName("NR_COD").set(nrCod);
        objRegTXT.fieldByName("VR_VALOR").set(valor);
        linha.add(objRegTXT);
    }

    public void montarFicharRendimentoIsentoTipo2(DeclaracaoIRPF objDecl, List<RegistroTxt> linha, String tipo) throws GeracaoTxtException {
        if (tipo.equals("0019")) {
            for (ItemQuadroMeacaoDissolucao item : objDecl.getRendIsentos().getMeacaoDissolucaoQuadroAuxiliar().itens()) {
                this.auxMontarFicharRendimentoIsentoTipo2(linha, objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado(), item.getTipoBeneficiario().naoFormatado().trim().length() == 0 ? " " : item.getTipoBeneficiario().naoFormatado().substring(0, 1), item.getCpfBeneficiario().naoFormatado(), tipo, item.getValor());
            }
        }
        if (tipo.equals("0020")) {
            for (ItemQuadroMeacaoDissolucao item : objDecl.getRendIsentos().getGanhosLiquidosAcoesQuadroAuxiliar().itens()) {
                this.auxMontarFicharRendimentoIsentoTipo2(linha, objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado(), item.getTipoBeneficiario().naoFormatado().trim().length() == 0 ? " " : item.getTipoBeneficiario().naoFormatado().substring(0, 1), item.getCpfBeneficiario().naoFormatado(), tipo, item.getValor());
            }
        }
        if (tipo.equals("0021")) {
            for (ItemQuadroMeacaoDissolucao item : objDecl.getRendIsentos().getGanhosCapitalOuroQuadroAuxiliar().itens()) {
                this.auxMontarFicharRendimentoIsentoTipo2(linha, objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado(), item.getTipoBeneficiario().naoFormatado().trim().length() == 0 ? " " : item.getTipoBeneficiario().naoFormatado().substring(0, 1), item.getCpfBeneficiario().naoFormatado(), tipo, item.getValor());
            }
        }
    }

    private void auxMontarFicharRendimentoIsentoTipo3(List<RegistroTxt> linha, String cpf, String tipo, String cpfBenef, String nrCod, String niFontePagadora, String nomeFonte, Valor valor, Valor valor13, String chaveBem) throws GeracaoTxtException {
        RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "84");
        objRegTXT.fieldByName("NR_REG").set("84");
        objRegTXT.fieldByName("NR_CPF").set(cpf);
        objRegTXT.fieldByName("IN_TIPO").set(tipo);
        objRegTXT.fieldByName("NR_CPF_BENEFIC").set(cpfBenef);
        objRegTXT.fieldByName("NR_COD").set(nrCod);
        if (niFontePagadora != null) {
            objRegTXT.fieldByName("NR_PAGADORA").set(niFontePagadora);
            if (nomeFonte != null) {
                objRegTXT.fieldByName("NM_NOME").set(nomeFonte);
            }
        }
        objRegTXT.fieldByName("VR_VALOR").set(valor);
        if ("0010".equals(nrCod)) {
            objRegTXT.fieldByName("VR_VALOR_13").set(valor13);
        }
        objRegTXT.fieldByName("NR_CHAVE_BEM").set(chaveBem);
        linha.add(objRegTXT);
    }

    public void montarFicharRendimentoIsentoTipo3(DeclaracaoIRPF objDecl, List<RegistroTxt> linha, String tipo) throws GeracaoTxtException {
        ColecaoItemQuadroTransporteDetalhado colDividendos = objDecl.getRendIsentos().getMedicosResidentesQuadroAuxiliar();
        if (tipo.equals("0001")) {
            for (ItemQuadroTransporteDetalhado item : objDecl.getRendIsentos().getBolsaEstudosQuadroAuxiliar().itens()) {
                this.auxMontarFicharRendimentoIsentoTipo3(linha, objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado(), item.getTipoBeneficiario().naoFormatado().trim().length() == 0 ? " " : item.getTipoBeneficiario().naoFormatado().substring(0, 1), item.getCpfBeneficiario().naoFormatado(), tipo, item.getNIFontePagadora().naoFormatado(), item.getNomeFontePagadora().naoFormatado(), item.getValor(), (Valor)item.getValor13Salario(), item.getCodBem().naoFormatado());
            }
        }
        if (tipo.equals("0002")) {
            for (ItemQuadroTransporteDetalhado item : objDecl.getRendIsentos().getMedicosResidentesQuadroAuxiliar().itens()) {
                this.auxMontarFicharRendimentoIsentoTipo3(linha, objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado(), item.getTipoBeneficiario().naoFormatado().trim().length() == 0 ? " " : item.getTipoBeneficiario().naoFormatado().substring(0, 1), item.getCpfBeneficiario().naoFormatado(), tipo, item.getNIFontePagadora().naoFormatado(), item.getNomeFontePagadora().naoFormatado(), item.getValor(), (Valor)item.getValor13Salario(), item.getCodBem().naoFormatado());
            }
        }
        if (tipo.equals("0004")) {
            for (ItemQuadroTransporteDetalhado item : objDecl.getRendIsentos().getIndenizacoesQuadroAuxiliar().itens()) {
                this.auxMontarFicharRendimentoIsentoTipo3(linha, objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado(), item.getTipoBeneficiario().naoFormatado().trim().length() == 0 ? " " : item.getTipoBeneficiario().naoFormatado().substring(0, 1), item.getCpfBeneficiario().naoFormatado(), tipo, item.getNIFontePagadora().naoFormatado(), item.getNomeFontePagadora().naoFormatado(), item.getValor(), (Valor)item.getValor13Salario(), item.getCodBem().naoFormatado());
            }
        }
        if (tipo.equals("0009")) {
            for (ItemQuadroTransporteDetalhado item : objDecl.getRendIsentos().getLucroRecebidoQuadroAuxiliar().itens()) {
                this.auxMontarFicharRendimentoIsentoTipo3(linha, objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado(), item.getTipoBeneficiario().naoFormatado().trim().length() == 0 ? " " : item.getTipoBeneficiario().naoFormatado().substring(0, 1), item.getCpfBeneficiario().naoFormatado(), tipo, item.getNIFontePagadora().naoFormatado(), item.getNomeFontePagadora().naoFormatado(), item.getValor(), (Valor)item.getValor13Salario(), item.getCodBem().naoFormatado());
            }
        }
        if (tipo.equals("0010")) {
            for (ItemQuadroTransporteDetalhado item : objDecl.getRendIsentos().getParcIsentaAposentadoriaQuadroAuxiliar().itens()) {
                this.auxMontarFicharRendimentoIsentoTipo3(linha, objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado(), item.getTipoBeneficiario().naoFormatado().trim().length() == 0 ? " " : item.getTipoBeneficiario().naoFormatado().substring(0, 1), item.getCpfBeneficiario().naoFormatado(), tipo, item.getNIFontePagadora().naoFormatado(), item.getNomeFontePagadora().naoFormatado(), item.getValor(), (Valor)item.getValor13Salario(), item.getCodBem().naoFormatado());
            }
        }
        if (tipo.equals("0012")) {
            for (ItemQuadroTransporteDetalhado item : objDecl.getRendIsentos().getPoupancaQuadroAuxiliar().itens()) {
                this.auxMontarFicharRendimentoIsentoTipo3(linha, objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado(), item.getTipoBeneficiario().naoFormatado().trim().length() == 0 ? " " : item.getTipoBeneficiario().naoFormatado().substring(0, 1), item.getCpfBeneficiario().naoFormatado(), tipo, item.getNIFontePagadora().naoFormatado(), item.getNomeFontePagadora().naoFormatado(), item.getValor(), (Valor)item.getValor13Salario(), item.getCodBem().naoFormatado());
            }
        }
        if (tipo.equals("0013")) {
            for (ItemQuadroTransporteDetalhado item : objDecl.getRendIsentos().getRendSocioQuadroAuxiliar().itens()) {
                this.auxMontarFicharRendimentoIsentoTipo3(linha, objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado(), item.getTipoBeneficiario().naoFormatado().trim().length() == 0 ? " " : item.getTipoBeneficiario().naoFormatado().substring(0, 1), item.getCpfBeneficiario().naoFormatado(), tipo, item.getNIFontePagadora().naoFormatado(), item.getNomeFontePagadora().naoFormatado(), item.getValor(), (Valor)item.getValor13Salario(), item.getCodBem().naoFormatado());
            }
        }
        if (tipo.equals("0014")) {
            for (ItemQuadroTransporteDetalhado item : objDecl.getRendIsentos().getTransferenciasQuadroAuxiliar().itens()) {
                this.auxMontarFicharRendimentoIsentoTipo3(linha, objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado(), item.getTipoBeneficiario().naoFormatado().trim().length() == 0 ? " " : item.getTipoBeneficiario().naoFormatado().substring(0, 1), item.getCpfBeneficiario().naoFormatado(), tipo, item.getNIFontePagadora().naoFormatado(), item.getNomeFontePagadora().naoFormatado(), item.getValor(), (Valor)item.getValor13Salario(), item.getCodBem().naoFormatado());
            }
        }
        if (tipo.equals("0016")) {
            for (ItemQuadroTransporteDetalhado item : objDecl.getRendIsentos().getImpostoRendasAnterioresCompensadoJudicialmenteQuadroAuxiliar().itens()) {
                this.auxMontarFicharRendimentoIsentoTipo3(linha, objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado(), item.getTipoBeneficiario().naoFormatado().trim().length() == 0 ? " " : item.getTipoBeneficiario().naoFormatado().substring(0, 1), item.getCpfBeneficiario().naoFormatado(), tipo, item.getNIFontePagadora().naoFormatado(), item.getNomeFontePagadora().naoFormatado(), item.getValor(), (Valor)item.getValor13Salario(), item.getCodBem().naoFormatado());
            }
        }
        if (tipo.equals("0017")) {
            for (ItemQuadroTransporteDetalhado item : objDecl.getRendIsentos().getRendAssalariadoMoedaEstrangeiraQuadroAuxiliar().itens()) {
                this.auxMontarFicharRendimentoIsentoTipo3(linha, objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado(), item.getTipoBeneficiario().naoFormatado().trim().length() == 0 ? " " : item.getTipoBeneficiario().naoFormatado().substring(0, 1), item.getCpfBeneficiario().naoFormatado(), tipo, item.getNIFontePagadora().naoFormatado(), item.getNomeFontePagadora().naoFormatado(), item.getValor(), (Valor)item.getValor13Salario(), item.getCodBem().naoFormatado());
            }
        }
        if (tipo.equals("0018")) {
            for (ItemQuadroTransporteDetalhado item : objDecl.getRendIsentos().getIncorporacaoReservaCapitalQuadroAuxiliar().itens()) {
                this.auxMontarFicharRendimentoIsentoTipo3(linha, objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado(), item.getTipoBeneficiario().naoFormatado().trim().length() == 0 ? " " : item.getTipoBeneficiario().naoFormatado().substring(0, 1), item.getCpfBeneficiario().naoFormatado(), tipo, item.getNIFontePagadora().naoFormatado(), item.getNomeFontePagadora().naoFormatado(), item.getValor(), (Valor)item.getValor13Salario(), item.getCodBem().naoFormatado());
            }
        }
        if (tipo.equals("0028")) {
            for (ItemQuadroTransporteDetalhado item : objDecl.getRendIsentos().getPensaoAlimenticiaQuadroAuxiliar().itens()) {
                this.auxMontarFicharRendimentoIsentoTipo3(linha, objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado(), item.getTipoBeneficiario().naoFormatado().trim().length() == 0 ? " " : item.getTipoBeneficiario().naoFormatado().substring(0, 1), item.getCpfBeneficiario().naoFormatado(), tipo, item.getCpfAlimentante().naoFormatado(), item.getNomeAlimentante().naoFormatado(), item.getValor(), (Valor)item.getValor13Salario(), item.getCodBem().naoFormatado());
            }
        }
    }

    public void montarFicharRendimentoIsentoTipo4(DeclaracaoIRPF objDecl, List<RegistroTxt> linha, String tipo) throws GeracaoTxtException {
        ColecaoItemQuadroTransporteDetalhado colDividendos = objDecl.getRendIsentos().getMedicosResidentesQuadroAuxiliar();
        if (tipo.equals("0011")) {
            for (ItemQuadroPensaoMolestiaGrave item : objDecl.getRendIsentos().getPensaoQuadroAuxiliar().itens()) {
                RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "85");
                objRegTXT.fieldByName("NR_REG").set("85");
                objRegTXT.fieldByName("NR_CPF").set(objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado());
                objRegTXT.fieldByName("IN_TIPO").set(item.getTipoBeneficiario().naoFormatado().trim().length() == 0 ? " " : item.getTipoBeneficiario().naoFormatado().substring(0, 1));
                objRegTXT.fieldByName("NR_CPF_BENEFIC").set(item.getCpfBeneficiario().naoFormatado());
                objRegTXT.fieldByName("NR_COD").set(tipo);
                objRegTXT.fieldByName("NR_PAGADORA").set(item.getNIFontePagadora().naoFormatado());
                objRegTXT.fieldByName("NM_NOME").set(item.getNomeFontePagadora().naoFormatado());
                objRegTXT.fieldByName("VR_RECEB").set(item.getValor());
                objRegTXT.fieldByName("VR_13SALARIO").set((Valor)item.getValor13Salario());
                objRegTXT.fieldByName("VR_IRRF").set((Valor)item.getValorIRRF());
                objRegTXT.fieldByName("VR_IRRF13SALARIO").set((Valor)item.getValorIRRF13Salario());
                objRegTXT.fieldByName("VR_PREVIDENCIA").set((Valor)item.getValorPrevidenciaOficial());
                linha.add(objRegTXT);
            }
        }
    }

    public void montarFicharRendimentoIsentoTipo5(DeclaracaoIRPF objDecl, List<RegistroTxt> linha, String tipo) throws GeracaoTxtException {
        ColecaoItemQuadroTransporteDetalhado colDividendos = objDecl.getRendIsentos().getMedicosResidentesQuadroAuxiliar();
        if (tipo.equals("0026")) {
            for (ItemQuadroOutrosRendimentos item : objDecl.getRendIsentos().getOutrosQuadroAuxiliar().itens()) {
                RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "86");
                objRegTXT.fieldByName("NR_REG").set("86");
                objRegTXT.fieldByName("NR_CPF").set(objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado());
                objRegTXT.fieldByName("IN_TIPO").set(item.getTipoBeneficiario().naoFormatado().trim().length() == 0 ? " " : item.getTipoBeneficiario().naoFormatado().substring(0, 1));
                objRegTXT.fieldByName("NR_CPF_BENEFIC").set(item.getCpfBeneficiario().naoFormatado());
                objRegTXT.fieldByName("NR_COD").set(tipo);
                objRegTXT.fieldByName("NR_PAGADORA").set(item.getNIFontePagadora().naoFormatado());
                objRegTXT.fieldByName("NM_NOME").set(item.getNomeFontePagadora().naoFormatado());
                objRegTXT.fieldByName("VR_VALOR").set(item.getValor());
                objRegTXT.fieldByName("NM_DESCRICAO").set(item.getDescricaoRendimento().naoFormatado());
                objRegTXT.fieldByName("NR_CHAVE_BEM").set(item.getCodBem().naoFormatado());
                linha.add(objRegTXT);
            }
        }
    }

    public void montarFicharRendimentoIsentoTipo6(DeclaracaoIRPF objDecl, List<RegistroTxt> linha) throws GeracaoTxtException {
        RegistroTxt objRegTXT;
        if (!objDecl.getRendIsentos().getBensPequenoValorInformado().isVazio() || !objDecl.getRendIsentos().getBensPequenoValorTransportado().isVazio()) {
            objRegTXT = new RegistroTxt("ARQ_IRPF", "87");
            objRegTXT.fieldByName("NR_REG").set("87");
            objRegTXT.fieldByName("NR_CPF").set(objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado());
            objRegTXT.fieldByName("NR_COD").set("0005");
            objRegTXT.fieldByName("VR_VALOR").set(objDecl.getRendIsentos().getBensPequenoValorInformado());
            objRegTXT.fieldByName("VR_VALORGCAP").set(objDecl.getRendIsentos().getBensPequenoValorTransportado());
            linha.add(objRegTXT);
        }
        if (!objDecl.getRendIsentos().getUnicoImovelInformado().isVazio() || !objDecl.getRendIsentos().getUnicoImovelTransportado().isVazio()) {
            objRegTXT = new RegistroTxt("ARQ_IRPF", "87");
            objRegTXT.fieldByName("NR_REG").set("87");
            objRegTXT.fieldByName("NR_CPF").set(objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado());
            objRegTXT.fieldByName("NR_COD").set("0006");
            objRegTXT.fieldByName("VR_VALOR").set(objDecl.getRendIsentos().getUnicoImovelInformado());
            objRegTXT.fieldByName("VR_VALORGCAP").set((Valor)objDecl.getRendIsentos().getUnicoImovelTransportado());
            linha.add(objRegTXT);
        }
        if (!objDecl.getRendIsentos().getOutrosBensImoveisInformado().isVazio() || !objDecl.getRendIsentos().getOutrosBensImoveisTransportado().isVazio()) {
            objRegTXT = new RegistroTxt("ARQ_IRPF", "87");
            objRegTXT.fieldByName("NR_REG").set("87");
            objRegTXT.fieldByName("NR_CPF").set(objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado());
            objRegTXT.fieldByName("NR_COD").set("0007");
            objRegTXT.fieldByName("VR_VALOR").set(objDecl.getRendIsentos().getOutrosBensImoveisInformado());
            objRegTXT.fieldByName("VR_VALORGCAP").set(objDecl.getRendIsentos().getOutrosBensImoveisTransportado());
            linha.add(objRegTXT);
        }
    }

    public List<RegistroTxt> montarFichaParcelaIsentaAposentadoria(DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        ArrayList<RegistroTxt> linha = new ArrayList<RegistroTxt>();
        return linha;
    }

    public List<RegistroTxt> montarFichaDoacoesCampanha(DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        ArrayList<RegistroTxt> linha = new ArrayList<RegistroTxt>();
        DoacoesEleitorais colDoacoes = objDecl.getDoacoesEleitorais();
        colDoacoes.excluirRegistrosEmBranco();
        for (DoacaoEleitoral item : colDoacoes.itens()) {
            RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "34");
            objRegTXT.fieldByName("NR_REG").set("34");
            objRegTXT.fieldByName("NR_CPF").set(objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado());
            objRegTXT.fieldByName("NR_PARTIDO").set(item.getCNPJ().naoFormatado());
            objRegTXT.fieldByName("NM_PARTIDO").set(item.getNome().naoFormatado());
            objRegTXT.fieldByName("VR_DOACAO").set(item.getValor());
            linha.add(objRegTXT);
        }
        return linha;
    }

    public void montarFichaRendimentosAplicacoesFinanceiras(DeclaracaoIRPF objDecl, List<RegistroTxt> linha) throws GeracaoTxtException {
        ColecaoItemQuadroTransporteDetalhado rendAplicacoesFinanceiras = objDecl.getRendTributacaoExclusiva().getRendAplicacoesQuadroAuxiliar();
        for (ItemQuadroTransporteDetalhado item : rendAplicacoesFinanceiras.itens()) {
            RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "88");
            objRegTXT.fieldByName("NR_REG").set("88");
            objRegTXT.fieldByName("NR_CPF").set(objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado());
            String tipo = item.getTipoBeneficiario().naoFormatado().trim().length() == 0 ? " " : item.getTipoBeneficiario().naoFormatado().substring(0, 1);
            objRegTXT.fieldByName("IN_TIPO").set(tipo);
            objRegTXT.fieldByName("NR_CPF_BENEFIC").set(item.getCpfBeneficiario().naoFormatado());
            objRegTXT.fieldByName("NR_COD").set("0006");
            objRegTXT.fieldByName("NR_PAGADORA").set(item.getNIFontePagadora().naoFormatado());
            objRegTXT.fieldByName("NM_NOME").set(item.getNomeFonte().naoFormatado());
            objRegTXT.fieldByName("VR_VALOR").set(item.getValor());
            objRegTXT.fieldByName("NR_CHAVE_BEM").set(item.getCodBem().naoFormatado());
            linha.add(objRegTXT);
        }
    }

    public List<RegistroTxt> montarFichaRendExclusivoTipo2(DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        ArrayList<RegistroTxt> linha = new ArrayList<RegistroTxt>();
        this.montarFichaRendimentosAplicacoesFinanceiras(objDecl, linha);
        this.montarFichaJurosCapitalProprio(objDecl, linha);
        this.montarFichaParticipacaoLucrosResultados(objDecl, linha);
        return linha;
    }

    public List<RegistroTxt> montarFichaRendIsentosTipo2(DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        ArrayList<RegistroTxt> linha = new ArrayList<RegistroTxt>();
        this.montarFicharRendimentoIsentoTipo2(objDecl, linha, "0019");
        this.montarFicharRendimentoIsentoTipo2(objDecl, linha, "0020");
        this.montarFicharRendimentoIsentoTipo2(objDecl, linha, "0021");
        return linha;
    }

    public List<RegistroTxt> montarFichaRendIsentosTipo3(DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        ArrayList<RegistroTxt> linha = new ArrayList<RegistroTxt>();
        this.montarFicharRendimentoIsentoTipo3(objDecl, linha, "0001");
        this.montarFicharRendimentoIsentoTipo3(objDecl, linha, "0002");
        this.montarFicharRendimentoIsentoTipo3(objDecl, linha, "0004");
        this.montarFicharRendimentoIsentoTipo3(objDecl, linha, "0009");
        this.montarFicharRendimentoIsentoTipo3(objDecl, linha, "0010");
        this.montarFicharRendimentoIsentoTipo3(objDecl, linha, "0012");
        this.montarFicharRendimentoIsentoTipo3(objDecl, linha, "0013");
        this.montarFicharRendimentoIsentoTipo3(objDecl, linha, "0014");
        this.montarFicharRendimentoIsentoTipo3(objDecl, linha, "0016");
        this.montarFicharRendimentoIsentoTipo3(objDecl, linha, "0017");
        this.montarFicharRendimentoIsentoTipo3(objDecl, linha, "0018");
        this.montarFicharRendimentoIsentoTipo3(objDecl, linha, "0028");
        return linha;
    }

    public List<RegistroTxt> montarFichaRendIsentosTipo4(DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        ArrayList<RegistroTxt> linha = new ArrayList<RegistroTxt>();
        this.montarFicharRendimentoIsentoTipo4(objDecl, linha, "0011");
        return linha;
    }

    public List<RegistroTxt> montarFichaRendIsentosTipo5(DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        ArrayList<RegistroTxt> linha = new ArrayList<RegistroTxt>();
        this.montarFicharRendimentoIsentoTipo5(objDecl, linha, "0026");
        return linha;
    }

    public List<RegistroTxt> montarFichaRendIsentosTipo6(DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        ArrayList<RegistroTxt> linha = new ArrayList<RegistroTxt>();
        this.montarFicharRendimentoIsentoTipo6(objDecl, linha);
        return linha;
    }

    public void montarFichaParticipacaoLucrosResultados(DeclaracaoIRPF objDecl, List<RegistroTxt> linha) throws GeracaoTxtException {
        ColecaoItemQuadroTransporteDetalhado participacaoLucrosResultados = objDecl.getRendTributacaoExclusiva().getParticipacaoLucrosResultadosQuadroAuxiliar();
        for (ItemQuadroTransporteDetalhado item : participacaoLucrosResultados.itens()) {
            RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "88");
            objRegTXT.fieldByName("NR_REG").set("88");
            objRegTXT.fieldByName("NR_CPF").set(objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado());
            String tipo = item.getTipoBeneficiario().naoFormatado().trim().length() == 0 ? " " : item.getTipoBeneficiario().naoFormatado().substring(0, 1);
            objRegTXT.fieldByName("IN_TIPO").set(tipo);
            objRegTXT.fieldByName("NR_CPF_BENEFIC").set(item.getCpfBeneficiario().naoFormatado());
            objRegTXT.fieldByName("NR_COD").set("0011");
            objRegTXT.fieldByName("NR_PAGADORA").set(item.getNIFontePagadora().naoFormatado());
            objRegTXT.fieldByName("NM_NOME").set(item.getNomeFonte().naoFormatado());
            objRegTXT.fieldByName("VR_VALOR").set(item.getValor());
            linha.add(objRegTXT);
        }
    }

    public List<RegistroTxt> montarFichaOutrosRendimentosIsentos(DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        return new ArrayList<RegistroTxt>();
    }

    public List<RegistroTxt> montarFichaOutrosRendimentosExclusivosTipo3(DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        ArrayList<RegistroTxt> linha = new ArrayList<RegistroTxt>();
        for (ItemQuadroOutrosRendimentos item : objDecl.getRendTributacaoExclusiva().getOutrosQuadroAuxiliar().itens()) {
            RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "89");
            objRegTXT.fieldByName("NR_REG").set("89");
            objRegTXT.fieldByName("NR_CPF").set(objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado());
            String tipo = item.getTipoBeneficiario().naoFormatado().trim().length() == 0 ? " " : item.getTipoBeneficiario().naoFormatado().substring(0, 1);
            objRegTXT.fieldByName("IN_TIPO").set(tipo);
            objRegTXT.fieldByName("NR_CPF_BENEFIC").set(item.getCpfBeneficiario().naoFormatado());
            objRegTXT.fieldByName("NR_COD").set("0012");
            objRegTXT.fieldByName("NR_PAGADORA").set(item.getNIFontePagadora().naoFormatado());
            objRegTXT.fieldByName("NM_NOME").set(item.getNomeFonte().naoFormatado());
            objRegTXT.fieldByName("VR_VALOR").set(item.getValor());
            objRegTXT.fieldByName("NM_DESCRICAO").set(item.getDescricaoRendimento().naoFormatado());
            linha.add(objRegTXT);
        }
        return linha;
    }

    public List<RegistroTxt> montarFichaAlimentandos(DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        ArrayList<RegistroTxt> linha = new ArrayList<RegistroTxt>();
        Alimentandos colecaoAlimentandos = objDecl.getAlimentandos();
        colecaoAlimentandos.excluirRegistrosEmBranco();
        for (int i = 0; i < colecaoAlimentandos.itens().size(); ++i) {
            Alimentando alimentando = (Alimentando)colecaoAlimentandos.itens().get(i);
            RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "35");
            objRegTXT.fieldByName("NR_REG").set("35");
            objRegTXT.fieldByName("NR_CPF").set(objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado());
            objRegTXT.fieldByName("NM_NOME").setLimitado(alimentando.getNome().naoFormatado());
            objRegTXT.fieldByName("INDICADOR_RESIDENC").set(alimentando.getResidente().naoFormatado());
            objRegTXT.fieldByName("DT_NASCIM").set(alimentando.getDtNascimento().naoFormatado());
            objRegTXT.fieldByName("NI_ALIMENTANDO").set(alimentando.getCpf().naoFormatado());
            objRegTXT.fieldByName("NR_CPF_VINCULADO").set(alimentando.getCpfResponsavel().naoFormatado());
            alimentando.setChave(String.valueOf(i + 1));
            objRegTXT.fieldByName("NR_CHAVE").set(alimentando.getChave());
            objRegTXT.fieldByName("IN_TIPO_PROCESSO").set(alimentando.getTipoProcesso().naoFormatado());
            if ("C".equals(alimentando.getTipoProcesso().naoFormatado()) || "A".equals(alimentando.getTipoProcesso().naoFormatado())) {
                objRegTXT.fieldByName("NR_CNPJ_CARTORIO").set(alimentando.getEscrituraPublica().getCnpjCartorio().naoFormatado());
                objRegTXT.fieldByName("NM_CARTORIO").set(alimentando.getEscrituraPublica().getNome().naoFormatado());
                objRegTXT.fieldByName("SG_UFCARTORIO").set(alimentando.getEscrituraPublica().getUf().naoFormatado());
                objRegTXT.fieldByName("CD_MUNICIP").set(alimentando.getEscrituraPublica().getMunicipio().getConteudoAtual(0));
                objRegTXT.fieldByName("NM_MUNICIPIO").set(alimentando.getEscrituraPublica().getMunicipio().getConteudoAtual(1));
                objRegTXT.fieldByName("NM_FOLHA").set(alimentando.getEscrituraPublica().getFolhas().naoFormatado());
                objRegTXT.fieldByName("NM_LIVRO").set(alimentando.getEscrituraPublica().getLivro().naoFormatado());
                objRegTXT.fieldByName("DT_LAVRATURA").set(alimentando.getEscrituraPublica().getDataLavratura().naoFormatado());
            }
            if ("J".equals(alimentando.getTipoProcesso().naoFormatado()) || "A".equals(alimentando.getTipoProcesso().naoFormatado())) {
                objRegTXT.fieldByName("NR_PROCESSOJUDICIAL").set(alimentando.getDecisaoJudicial().getNumProcessoJudicial().naoFormatado());
                objRegTXT.fieldByName("NR_IDENTIFICACAOVARACIVIL").set(alimentando.getDecisaoJudicial().getIdVaraCivil().naoFormatado());
                objRegTXT.fieldByName("NM_COMARCA").set(alimentando.getDecisaoJudicial().getComarca().naoFormatado());
                objRegTXT.fieldByName("SG_UFCOMARCA").set(alimentando.getDecisaoJudicial().getUf().naoFormatado());
                objRegTXT.fieldByName("DT_DECJUDICIAL").set(alimentando.getDecisaoJudicial().getDtDecisaoJud().naoFormatado());
            }
            linha.add(objRegTXT);
        }
        return linha;
    }

    public List<RegistroTxt> montarFichaBem(DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        ArrayList<RegistroTxt> linha = new ArrayList<RegistroTxt>();
        objDecl.getBens().excluirRegistrosEmBranco();
        Bens colecaoBens = objDecl.getBens();
        Map chavesRepetidas = colecaoBens.obterListaChavesRepetidas();
        if (chavesRepetidas != null) {
            objDecl.atualizarIndicesBens(chavesRepetidas);
        }
        for (int i = 0; i < colecaoBens.itens().size(); ++i) {
            Bem bem = (Bem)colecaoBens.itens().get(i);
            RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "27");
            bem.setChave(bem.getIndice().naoFormatado());
            objRegTXT.fieldByName("NR_REG").set("27");
            objRegTXT.fieldByName("NR_CPF").set(objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado());
            objRegTXT.fieldByName("NR_CHAVE_BEM").set(bem.getChave());
            objRegTXT.fieldByName("TX_BEM").setLimitado(bem.getDiscriminacao().naoFormatado());
            objRegTXT.fieldByName("CD_GRUPO_BEM").set(bem.getGrupo().naoFormatado());
            objRegTXT.fieldByName("CD_BEM").set(bem.getCodigo().naoFormatado());
            objRegTXT.fieldByName("VR_ANTER").set(bem.getValorExercicioAnterior());
            objRegTXT.fieldByName("VR_ATUAL").set(bem.getValorExercicioAtual());
            objRegTXT.fieldByName("CD_PAIS").set(bem.getPais().getConteudoAtual(0));
            objRegTXT.fieldByName("IN_BEM_INVENTARIAR").set(bem.getIndicadorBemInventariar().naoFormatado());
            if (bem.getPais().getConteudoAtual(0).equals("105")) {
                objRegTXT.fieldByName("IN_EXTERIOR").set(0);
            } else {
                objRegTXT.fieldByName("IN_EXTERIOR").set(1);
            }
            if (bem.isBemImovel()) {
                objRegTXT.fieldByName("NM_LOGRA").set(bem.getLogradouro().naoFormatado());
                objRegTXT.fieldByName("NR_NUMERO").set(bem.getNumero().naoFormatado());
                objRegTXT.fieldByName("NM_COMPLEM").set(bem.getComplemento().naoFormatado());
                objRegTXT.fieldByName("NM_BAIRRO").set(bem.getBairro().naoFormatado());
                if (bem.getPais().getConteudoAtual(0).equals("105")) {
                    objRegTXT.fieldByName("SG_UF").set(bem.getUf().naoFormatado());
                    if (bem.getMunicipio().getIndiceElementoTabela() >= 0) {
                        objRegTXT.fieldByName("CD_MUNICIP").set(bem.getMunicipio().naoFormatado());
                        objRegTXT.fieldByName("NM_MUNICIP").set(bem.getMunicipio().getConteudoAtual(1));
                    }
                } else {
                    objRegTXT.fieldByName("NM_MUNICIP").set(bem.getCidade().naoFormatado());
                }
                objRegTXT.fieldByName("NR_CEP").set(bem.getCep().naoFormatado());
                objRegTXT.fieldByName("AREA").set(bem.getAreaTotal());
                if (!bem.getUnidade().isVazio()) {
                    objRegTXT.fieldByName("NM_UNID").set(bem.getUnidade().naoFormatado());
                } else {
                    objRegTXT.fieldByName("NM_UNID").set("2");
                }
                if (bem.isBemImovelRegistravel()) {
                    objRegTXT.fieldByName("NM_IND_REG_IMOV").set(bem.getRegistrado().naoFormatado());
                    objRegTXT.fieldByName("DT_AQUISICAO").set(bem.getDataAquisicao().naoFormatado());
                    if (bem.getRegistrado().naoFormatado().equals("1")) {
                        objRegTXT.fieldByName("MATRIC_IMOV").set(bem.getMatricula().naoFormatado());
                        objRegTXT.fieldByName("NM_CARTORIO").set(bem.getNomeCartorio().naoFormatado());
                    }
                } else {
                    objRegTXT.fieldByName("NM_IND_REG_IMOV").set("2");
                }
            } else {
                objRegTXT.fieldByName("NM_IND_REG_IMOV").set("2");
                objRegTXT.fieldByName("NM_UNID").set("2");
            }
            if (bem.possuiValorIPTU()) {
                objRegTXT.fieldByName("NR_IPTU").set(bem.getValorIPTU());
            }
            if (bem.possuiValorCIB()) {
                objRegTXT.fieldByName("NR_CIB").set(bem.getValorCIB());
            }
            if (bem.possuiValorRENAVAM()) {
                objRegTXT.fieldByName("NR_RENAVAN").set(bem.getValorRENAVAM());
            }
            if (bem.possuiValorRegistroAviacao()) {
                objRegTXT.fieldByName("NR_DEP_AVIACAO_CIVIL").set(bem.getValorRegistroAviacao());
            }
            if (bem.possuiValorRegistroPortos()) {
                objRegTXT.fieldByName("NR_CAPITANIA_PORTOS").set(bem.getValorRegistroPortos());
            }
            if (bem.isImovelEmConstrucaoNoBrasil(bem.getGrupo().naoFormatado(), bem.getCodigo().naoFormatado(), bem.getPais().naoFormatado())) {
                objRegTXT.fieldByName("NR_CEI_CNO").set(bem.getRegistroBem().naoFormatado());
            }
            if (bem.isBemComDadosBancarios()) {
                try {
                    int nuBanco = Integer.parseInt(bem.getBanco().naoFormatado());
                    if (nuBanco > 0) {
                        objRegTXT.fieldByName("NR_BANCO").set(bem.getBanco().naoFormatado());
                    }
                }
                catch (NumberFormatException nuBanco) {
                    // empty catch block
                }
                objRegTXT.fieldByName("NR_AGENCIA").set(bem.getAgencia().naoFormatado());
                try {
                    objRegTXT.fieldByName("NR_CONTA").set(bem.getContaFormatadaTxt());
                }
                catch (AplicacaoException e) {
                    throw new GeracaoTxtException(e.getMessage(), (Throwable)e);
                }
                objRegTXT.fieldByName("NR_DV_CONTA").set(bem.getDVConta().naoFormatado());
            }
            if (bem.isBemComNI()) {
                objRegTXT.fieldByName("NM_CPFCNPJ").set(bem.getNiEmpresa().naoFormatado());
            }
            if (bem.isBemComBeneficiario()) {
                objRegTXT.fieldByName("IN_TIPO_BENEFIC").set(bem.getTipo().naoFormatado());
                objRegTXT.fieldByName("NR_CPF_BENEFIC").set(bem.getCPFBeneficiario().naoFormatado());
            }
            if (bem.isBemNegociadoBolsa()) {
                objRegTXT.fieldByName("IN_BOLSA").set(bem.getNegociadoBolsa().naoFormatado());
                objRegTXT.fieldByName("NR_COD_NEGOCIACAO_BOLSA").set(bem.getCodigoNegociacao().naoFormatado());
            }
            if (bem.isCriptoativos()) {
                objRegTXT.fieldByName("IN_CUSTODIANTE").set(bem.getIndicadorAutoCustodiante().naoFormatado());
                objRegTXT.fieldByName("COD_ALTCOIN").set(bem.getCodigoAltcoin().naoFormatado());
                objRegTXT.fieldByName("COD_STABLECOIN").set(bem.getCodigoStablecoin().naoFormatado());
            }
            if (bem.isBemComAplicacaoFinanceira()) {
                objRegTXT.fieldByName("VR_LUCRO_PREJUIZO_APLICACAO_FINANCEIRA").set(bem.getLucroPrejuizo());
                objRegTXT.fieldByName("VR_IMPOSTO_PAGO_EXTERIOR_APLICACAO_FINANCEIRA").set((Valor)bem.getImpostoPagoExterior());
            }
            if (bem.isBemComLucrosDividendos()) {
                objRegTXT.fieldByName("VR_RECEBIDO_LUCROS_DIVIDENDOS").set((Valor)bem.getValorRecebido());
                objRegTXT.fieldByName("VR_IMPOSTO_PAGO_EXTERIOR_LUCROS_DIVIDENDOS").set((Valor)bem.getImpostoPagoExteriorIRRF());
            }
            String inProcessoAtualizacao = bem.getAtualizadoValorBem().naoFormatado();
            if (objDecl.getBens().getExisteAtualizacaoValorBem().naoFormatado().equals(Logico.SIM)) {
                if (inProcessoAtualizacao.isEmpty()) {
                    inProcessoAtualizacao = "0";
                }
            } else {
                inProcessoAtualizacao = "";
            }
            objRegTXT.fieldByName("IN_PROCESSO_ATUALIZACAO_BEM").set(inProcessoAtualizacao);
            if (!bem.getIndicadorContaPagamento().isVazio()) {
                objRegTXT.fieldByName("IN_CONTA_PAGAMENTO").set(bem.getIndicadorContaPagamento().naoFormatado());
            }
            objRegTXT.fieldByName("IN_RECLASSIFICAR").set(bem.getIndicadorReclassificar().naoFormatado());
            linha.add(objRegTXT);
        }
        return linha;
    }

    public List<RegistroTxt> montarREG36_BensDireitosProprietarioUsufrutuario(DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        ArrayList<RegistroTxt> linha = new ArrayList<RegistroTxt>();
        Bem bem = null;
        objDecl.getBens().excluirRegistrosEmBranco();
        Bens colecaoBens = objDecl.getBens();
        for (int i = 0; i < colecaoBens.itens().size(); ++i) {
            bem = (Bem)colecaoBens.itens().get(i);
            if (!bem.getIndicadorBemComUsufruto().naoFormatado().equals("1")) continue;
            for (ProprietarioUsufrutuarioBem proprietarioUsufrutuario : bem.getProprietariosUsufrutuariosBem().itens()) {
                if (proprietarioUsufrutuario == null || proprietarioUsufrutuario.isVazio()) continue;
                RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "36");
                objRegTXT.fieldByName("NR_REG").set("36");
                objRegTXT.fieldByName("NR_CPF").set(objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado());
                objRegTXT.fieldByName("NR_CHAVE_BEM").set(proprietarioUsufrutuario.getIndice().naoFormatado());
                objRegTXT.fieldByName("NR_CPF_CNPJ").set(proprietarioUsufrutuario.getNi().naoFormatado());
                objRegTXT.fieldByName("CD_GRUPO_BEM").set(bem.getGrupo().naoFormatado());
                objRegTXT.fieldByName("CD_BEM").set(bem.getCodigo().naoFormatado());
                linha.add(objRegTXT);
            }
        }
        return linha;
    }

    public List<RegistroTxt> montarRegistro37RendimentosAplicacoesFinanceirasExterior(DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        ArrayList<RegistroTxt> registros = new ArrayList<RegistroTxt>();
        objDecl.getBens().excluirRegistrosEmBranco();
        objDecl.getBens().recalcularDemonstrativoAplicacoesFinanceirasExterior(objDecl);
        for (RendimentoAplicacoesFinanceiras rendimento : objDecl.getColecaoRendimentoAplicacoesFinanceiras().itens()) {
            RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "37");
            objRegTXT.fieldByName("NR_REG").set("37");
            objRegTXT.fieldByName("NR_CPF").set(objDecl.getContribuinte().getIdentificadorDeclaracao().getCpf().naoFormatado());
            objRegTXT.fieldByName("NR_CHAVE_BEM").set(rendimento.getChaveBem().naoFormatado());
            objRegTXT.fieldByName("NR_ORDEM").set(rendimento.getNumeroOrdem().naoFormatado());
            objRegTXT.fieldByName("TIPO").set(rendimento.getTipoRendimento().naoFormatado());
            objRegTXT.fieldByName("VR_GANHO_PREJUIZO").set(rendimento.getGanhoPrejuizo());
            objRegTXT.fieldByName("VR_IMPOSTO_DEVIDO").set(rendimento.getImpostoDevido());
            objRegTXT.fieldByName("VR_IMPOSTO_PAGO_EXTERIOR_BRASIL").set(rendimento.getImpostoPagoExterior());
            objRegTXT.fieldByName("VR_BASE_CALCULO").set(rendimento.getBaseCalculo());
            objRegTXT.fieldByName("VR_SALDO").set(rendimento.getSaldo());
            objRegTXT.fieldByName("CD_GRUPO_BEM").set(rendimento.getGrupo().naoFormatado());
            objRegTXT.fieldByName("CD_BEM").set(rendimento.getCodigo().naoFormatado());
            registros.add(objRegTXT);
        }
        return registros;
    }

    public List<RegistroTxt> montarFichaDividas(DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        ArrayList<RegistroTxt> linha = new ArrayList<RegistroTxt>();
        Dividas colecaoDividas = objDecl.getDividas();
        colecaoDividas.excluirRegistrosEmBranco();
        for (int i = 0; i < colecaoDividas.itens().size(); ++i) {
            Divida divida = (Divida)colecaoDividas.itens().get(i);
            RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "28");
            objRegTXT.fieldByName("NR_REG").set("28");
            objRegTXT.fieldByName("NR_CPF").set(objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado());
            objRegTXT.fieldByName("TX_DIV").setLimitado(divida.getDiscriminacao().naoFormatado());
            objRegTXT.fieldByName("CD_DIV").set(divida.getCodigo().naoFormatado());
            objRegTXT.fieldByName("VR_ANTER").set(divida.getValorExercicioAnterior());
            objRegTXT.fieldByName("VR_ATUAL").set(divida.getValorExercicioAtual());
            objRegTXT.fieldByName("VR_PGTO_ANUAL").set(divida.getValorPgtoAnual());
            linha.add(objRegTXT);
        }
        return linha;
    }

    public List<RegistroTxt> montarFichaInventariante(DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        ArrayList<RegistroTxt> linha = new ArrayList<RegistroTxt>();
        Espolio espolio = objDecl.getEspolio();
        EspolioPartilha infoEspolio = espolio.obterInformacoEspolioParaCalculos();
        boolean sobrepartilha = espolio.ehInicialSobrepartilha();
        if (objDecl.getIdentificadorDeclaracao().isAjuste()) {
            boolean isEspolio = "81".equals(objDecl.getContribuinte().getNaturezaOcupacao().naoFormatado());
            String cpf = null;
            String nome = null;
            String flagSobrepartilha = null;
            if (sobrepartilha) {
                flagSobrepartilha = isEspolio ? Logico.SIM : Logico.NAO;
                cpf = objDecl.getEspolio().getSobrepartilha().getCpfInventariante().naoFormatado();
                nome = objDecl.getEspolio().getSobrepartilha().getNomeInventariante().naoFormatado();
            } else {
                flagSobrepartilha = Logico.NAO;
                cpf = objDecl.getEspolio().getPartilha().getCpfInventariante().naoFormatado();
                nome = objDecl.getEspolio().getPartilha().getNomeInventariante().naoFormatado();
            }
            if (isEspolio || !cpf.isBlank() && !nome.isBlank()) {
                RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "30");
                objRegTXT.fieldByName("NR_REG").set("30");
                objRegTXT.fieldByName("NR_CPF").set(objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado());
                objRegTXT.fieldByName("IN_SOBREPARTILHA").setLimitado(flagSobrepartilha);
                objRegTXT.fieldByName("NR_INVENT").set(cpf);
                objRegTXT.fieldByName("NM_INVENT").setLimitado(nome);
                linha.add(objRegTXT);
            }
        } else if (!(espolio.isBensInventariarMarcado() || !"81".equals(objDecl.getContribuinte().getNaturezaOcupacao().getConteudoAtual(0)) && !sobrepartilha && infoEspolio.getNomeInventariante().naoFormatado().equals("") && infoEspolio.getCpfInventariante().naoFormatado().equals(""))) {
            RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "30");
            objRegTXT.fieldByName("NR_REG").set("30");
            objRegTXT.fieldByName("NR_CPF").set(objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado());
            objRegTXT.fieldByName("NR_INVENT").set(infoEspolio.getCpfInventariante().naoFormatado());
            objRegTXT.fieldByName("NM_INVENT").setLimitado(infoEspolio.getNomeInventariante().naoFormatado());
            if (sobrepartilha) {
                objRegTXT.fieldByName("IN_SOBREPARTILHA").setLimitado(Logico.SIM);
            } else {
                objRegTXT.fieldByName("IN_SOBREPARTILHA").setLimitado(Logico.NAO);
            }
            linha.add(objRegTXT);
        } else if (espolio.isBensInventariarMarcado()) {
            RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "30");
            objRegTXT.fieldByName("NR_REG").set("30");
            objRegTXT.fieldByName("NR_CPF").set(objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado());
            if (sobrepartilha) {
                objRegTXT.fieldByName("IN_SOBREPARTILHA").setLimitado(Logico.SIM);
            } else {
                objRegTXT.fieldByName("IN_SOBREPARTILHA").setLimitado(Logico.NAO);
            }
            objRegTXT.fieldByName("NR_INVENT").set(espolio.getCpfInventariante().naoFormatado());
            objRegTXT.fieldByName("NM_INVENT").setLimitado(espolio.getNomeInventariante().naoFormatado());
            linha.add(objRegTXT);
        }
        return linha;
    }

    public List<RegistroTxt> montarFichaFinalEspolio(DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        RegistroTxt reg;
        ArrayList<RegistroTxt> linha = new ArrayList<RegistroTxt>();
        Espolio espolio = objDecl.getEspolio();
        if (espolio.ehFinalEspolioPartilha() || espolio.ehFinalEspolioPartilhaSobrepartilha()) {
            reg = this.montarFichaFinalEspolio(objDecl.getEspolio().getPartilha(), objDecl.getEspolio().getAnoObito().naoFormatado(), objDecl.getEspolio().obterFaseFinalEspolio(), objDecl.getEspolio().getIndicadorBensInventariar().naoFormatado(), false, objDecl.getIdentificadorDeclaracao());
            linha.add(reg);
        }
        if (espolio.ehInicialSobrepartilha() || espolio.ehFinalEspolioSobrepartilha() || espolio.ehFinalEspolioPartilhaSobrepartilha()) {
            reg = this.montarFichaFinalEspolio(objDecl.getEspolio().getSobrepartilha(), objDecl.getEspolio().getAnoObito().naoFormatado(), objDecl.getEspolio().obterFaseFinalEspolio(), objDecl.getEspolio().getIndicadorBensInventariar().naoFormatado(), true, objDecl.getIdentificadorDeclaracao());
            linha.add(reg);
        }
        return linha;
    }

    public RegistroTxt montarFichaFinalEspolio(EspolioPartilha infoEspolio, String anoObito, String faseEspolio, String inBensIventariar, boolean sobrepartilha, IdentificadorDeclaracao idDec) throws GeracaoTxtException {
        RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "38");
        objRegTXT.fieldByName("NR_REG").set("38");
        objRegTXT.fieldByName("NR_CPF").set(idDec.getCpf().naoFormatado());
        objRegTXT.fieldByName("NR_ANOOBITO").set(anoObito);
        objRegTXT.fieldByName("NR_INVENT").set(infoEspolio.getCpfInventariante().naoFormatado());
        objRegTXT.fieldByName("NM_INVENT").set(infoEspolio.getNomeInventariante().naoFormatado());
        objRegTXT.fieldByName("IN_SOBREPARTILHA").set(sobrepartilha ? Logico.SIM : Logico.NAO);
        objRegTXT.fieldByName("IN_STATUS_SOBREPARTILHA").set(faseEspolio);
        objRegTXT.fieldByName("IN_BENS_INVENTARIAR").set(inBensIventariar);
        if (!sobrepartilha || !"2".equals(faseEspolio)) {
            if (infoEspolio.getTipoJudicial().naoFormatado().equals(Logico.SIM)) {
                EspolioDecisaoJudicial decisaoJudicial = infoEspolio.getDecisaoJudicial();
                objRegTXT.fieldByName("NR_PROCESSO_JUDICIAL").set(decisaoJudicial.getNumProcessoJudicial().naoFormatado());
                objRegTXT.fieldByName("NR_VARACIVIL").set(decisaoJudicial.getIdVaraCivil().naoFormatado());
                objRegTXT.fieldByName("NM_COMARCA").set(decisaoJudicial.getComarca().naoFormatado());
                objRegTXT.fieldByName("DT_DECJUDICIALPARTILHA").set(decisaoJudicial.getDtDecisaoJud().naoFormatado());
                objRegTXT.fieldByName("DT_TRANSITOJULGADO").set(decisaoJudicial.getDtTransito().naoFormatado());
                objRegTXT.fieldByName("SG_UFCOMARCA").set(decisaoJudicial.getUf().naoFormatado());
            } else {
                EspolioEscrituracaoPublica escrituracaoPublica = infoEspolio.getEscrituracaoPublica();
                objRegTXT.fieldByName("NR_CNPJ_CARTORIO").set(escrituracaoPublica.getCnpjCartorio().naoFormatado());
                objRegTXT.fieldByName("NM_CARTORIO").set(escrituracaoPublica.getNome().naoFormatado());
                objRegTXT.fieldByName("NM_LIVRO").set(escrituracaoPublica.getLivro().naoFormatado());
                objRegTXT.fieldByName("NM_FOLHA").set(escrituracaoPublica.getFolhas().naoFormatado());
                objRegTXT.fieldByName("NM_MUNICIPIO").set(escrituracaoPublica.getMunicipio().naoFormatado());
                objRegTXT.fieldByName("SG_UFCARTORIO").set(escrituracaoPublica.getUf().naoFormatado());
                objRegTXT.fieldByName("DT_LAVRATURA").set(escrituracaoPublica.getDataLavratura().naoFormatado());
            }
            objRegTXT.fieldByName("IN_MEEIRO").set(infoEspolio.getConjugeMeeiro().naoFormatado());
            if (infoEspolio.getInventarioConjunto().naoFormatado().equals(Logico.SIM)) {
                objRegTXT.fieldByName("NM_CONJUGE").set(infoEspolio.getNomeConjugeCompanheiro().naoFormatado());
            }
            objRegTXT.fieldByName("IN_TIPO_PROCESSO").set(infoEspolio.getTipoJudicial().naoFormatado().equals(Logico.SIM) ? "J" : "C");
            objRegTXT.fieldByName("IN_MORTEAMBOSCONJUGES").set(infoEspolio.getMorteAmbosConjuges().naoFormatado());
            objRegTXT.fieldByName("IN_INVENTARIOCONJUNTO").set(infoEspolio.getInventarioConjunto().naoFormatado());
        }
        return objRegTXT;
    }

    public List<RegistroTxt> montarFichaSaida(DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        ArrayList<RegistroTxt> linha = new ArrayList<RegistroTxt>();
        Saida saida = objDecl.getSaida();
        RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "39");
        objRegTXT.fieldByName("NR_REG").set("39");
        objRegTXT.fieldByName("NR_CPF").set(objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado());
        objRegTXT.fieldByName("NR_PROCURADOR").set(saida.getCpfProcurador().naoFormatado());
        objRegTXT.fieldByName("NM_PROCURADOR").set(saida.getNomeProcurador().naoFormatado());
        objRegTXT.fieldByName("NM_END_PROCURADOR").set(saida.getEndProcurador().naoFormatado());
        objRegTXT.fieldByName("DT_NAORESIDENTE").set(saida.getDtCondicaoNaoResidente().naoFormatado());
        objRegTXT.fieldByName("DT_RESIDENTE").set(saida.getDtCondicaoResidente().naoFormatado());
        objRegTXT.fieldByName("CD_NOVO_PAIS_RESIDENCIA").set(saida.getPaisResidencia().naoFormatado());
        linha.add(objRegTXT);
        return linha;
    }

    public List<RegistroTxt> montarFichaRendPJDependente(DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        ArrayList<RegistroTxt> linha = new ArrayList<RegistroTxt>();
        ColecaoRendPJDependente colecaoRendimentos = objDecl.getColecaoRendPJDependente();
        for (int i = 0; i < colecaoRendimentos.itens().size(); ++i) {
            RendPJDependente rendimentoPJ = (RendPJDependente)colecaoRendimentos.itens().get(i);
            RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "32");
            objRegTXT.fieldByName("NR_REG").set("32");
            objRegTXT.fieldByName("NR_CPF").set(objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado());
            objRegTXT.fieldByName("CPF_BENEF").set(rendimentoPJ.getCpfDependente().naoFormatado());
            objRegTXT.fieldByName("NR_PAGADOR").set(rendimentoPJ.getNIFontePagadora().naoFormatado());
            objRegTXT.fieldByName("NM_PAGADOR").setLimitado(rendimentoPJ.getNomeFontePagadora().naoFormatado());
            objRegTXT.fieldByName("VR_RENDTO").set(rendimentoPJ.getRendRecebidoPJ());
            objRegTXT.fieldByName("VR_CONTRIB").set(rendimentoPJ.getContribuicaoPrevOficial());
            objRegTXT.fieldByName("VR_DECTERC").set(rendimentoPJ.getDecimoTerceiro());
            objRegTXT.fieldByName("VR_IMPOSTO").set(rendimentoPJ.getImpostoRetidoFonte());
            objRegTXT.fieldByName("VR_IRRF13SALARIO").set((Valor)rendimentoPJ.getIRRFDecimoTerceiro());
            if (objDecl.getIdentificadorDeclaracao().isSaida()) {
                objRegTXT.fieldByName("DT_COMUNICACAO_SAIDA").set(rendimentoPJ.getDataComunicacaoSaida().naoFormatado());
            }
            linha.add(objRegTXT);
        }
        return linha;
    }

    public List<RegistroTxt> montarFichaSimplificada(DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        ArrayList<RegistroTxt> linha = new ArrayList<RegistroTxt>();
        RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "17");
        objRegTXT.fieldByName("NR_REG").set("17");
        objRegTXT.fieldByName("NR_CPF").set(objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado());
        objRegTXT.fieldByName("VR_IMPCOMP").set(objDecl.getModeloSimplificada().getImpostoComplementar());
        objRegTXT.fieldByName("VR_LUCROSTIT").set(QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarTitular((Colecao)objDecl.getRendIsentos().getLucroRecebidoQuadroAuxiliar()));
        objRegTXT.fieldByName("VR_ISENTOS").set(objDecl.getRendIsentos().recuperarTotalTitularExcetoAtividadeRuraleGC());
        objRegTXT.fieldByName("VR_EXCLUSIVOS").set(objDecl.getRendTributacaoExclusiva().recuperarTotalTitularExceto13_RV_e_GC());
        objRegTXT.fieldByName("VR_TOTAL13").set(objDecl.getRendTributacaoExclusiva().getDecimoTerceiro());
        objRegTXT.fieldByName("VR_IRFONTELEI11033").set(objDecl.getModeloSimplificada().getImpostoRetidoFonteLei11033());
        objRegTXT.fieldByName("VR_TOTAL13DEPEND").set(objDecl.getRendTributacaoExclusiva().getDecimoTerceiroDependentes());
        objRegTXT.fieldByName("VR_LUCROSDEPEND").set(QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarDependente((Colecao)objDecl.getRendIsentos().getLucroRecebidoQuadroAuxiliar()));
        objRegTXT.fieldByName("VR_ISENTOSDEPEND").set(QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarDependente((Colecao)objDecl.getRendIsentos().getOutrosQuadroAuxiliar()));
        objRegTXT.fieldByName("VR_EXCLUSIVOSDEPEND").set(objDecl.getRendTributacaoExclusiva().recuperarExclusivosDependentesExceto13Salario());
        Valor valRendPfExtDep = new Valor();
        valRendPfExtDep.append('+', objDecl.getRendPFDependente().getTotalExterior());
        valRendPfExtDep.append('+', objDecl.getRendPFDependente().getTotalPessoaFisica());
        RendPF rendimentosPF = objDecl.getRendPFTitular();
        ColecaoRendPFDependente rendDep = objDecl.getRendPFDependente();
        Valor totalTitPFAlugueisOutros = new Valor("0,00");
        totalTitPFAlugueisOutros.append('+', rendimentosPF.getTotalPessoaFisica());
        totalTitPFAlugueisOutros.append('+', rendimentosPF.getTotalAlugueis());
        totalTitPFAlugueisOutros.append('+', rendimentosPF.getTotalOutros());
        Valor totalDepPFAlugueisOutros = new Valor("0,00");
        totalDepPFAlugueisOutros.append('+', rendDep.getTotalPessoaFisica());
        totalDepPFAlugueisOutros.append('+', rendDep.getTotalAlugueis());
        totalDepPFAlugueisOutros.append('+', rendDep.getTotalOutros());
        objRegTXT.fieldByName("VR_RENDEXTTIT").set(rendimentosPF.getTotalExterior());
        objRegTXT.fieldByName("VR_RENDPFTIT").set(totalTitPFAlugueisOutros);
        objRegTXT.fieldByName("VR_RENDEXTDEPEN").set(rendDep.getTotalExterior());
        objRegTXT.fieldByName("VR_RENDPFDEPEN").set(totalDepPFAlugueisOutros);
        objRegTXT.fieldByName("VR_CARNELEAOTIT").set(rendimentosPF.getTotalDarfPago());
        objRegTXT.fieldByName("VR_CARNELEAODEPEND").set(rendDep.getTotalDarfPago());
        objRegTXT.fieldByName("VR_DEPEN").set(objDecl.getDependentes().getTotalDeducaoDependentes());
        RendAcm rendAcm = objDecl.getRendAcm();
        objRegTXT.fieldByName("VR_TOT_PREVOFC_AC_TIT").set(rendAcm.getColecaoRendAcmTitular().getTotaisContribuicaoPrevOficialAjuste());
        objRegTXT.fieldByName("VR_TOT_PREVOFC_AC_DEP").set(rendAcm.getColecaoRendAcmDependente().getTotaisContribuicaoPrevOficialAjuste());
        objRegTXT.fieldByName("VR_TOT_PENSALI_AC_TIT").set(rendAcm.getColecaoRendAcmTitular().getTotaisPensaoAlimenticiaAjuste());
        objRegTXT.fieldByName("VR_TOT_PENSALI_AC_DEP").set(rendAcm.getColecaoRendAcmDependente().getTotaisPensaoAlimenticiaAjuste());
        objRegTXT.fieldByName("VR_IMPEXT").set((Valor)objDecl.getImpostoPago().getImpostoPagoExterior());
        objRegTXT.fieldByName("VR_IMPDEVIDO_SEM_REND_EXT").set(objDecl.getImpostoPago().getImpostoDevidoSemRendExterior());
        objRegTXT.fieldByName("VR_LIMITE_IMP_PAGO_EXT").set(objDecl.getImpostoPago().getLimiteImpPagoExterior());
        linha.add(objRegTXT);
        return linha;
    }

    public List<RegistroTxt> montarFichaResumoSimplificada(DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        ArrayList<RegistroTxt> linha = new ArrayList<RegistroTxt>();
        RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "18");
        objRegTXT.fieldByName("NR_REG").set("18");
        objRegTXT.fieldByName("NR_CPF").set(objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado());
        objRegTXT.fieldByName("VR_RENDTRIB").set(objDecl.getModeloSimplificada().getTotalResultadosTributaveis());
        objRegTXT.fieldByName("VR_DESCSIMP").set(objDecl.getModeloSimplificada().getDescontoSimplificado());
        objRegTXT.fieldByName("VR_BASECALC").set(objDecl.getModeloSimplificada().getBaseCalculo());
        objRegTXT.fieldByName("VR_IMPDEVIDO").set(objDecl.getModeloSimplificada().getImpostoDevidoI());
        Valor totImpostoRetido = new Valor();
        totImpostoRetido.append('+', objDecl.getModeloSimplificada().getImpostoRetidoFonteTitular());
        totImpostoRetido.append('+', objDecl.getModeloSimplificada().getImpostoRetidoFonteDependentes());
        objRegTXT.fieldByName("VR_IMPOSTO").set(totImpostoRetido);
        objRegTXT.fieldByName("VR_IMPCOMP").set(objDecl.getResumo().getCalculoImposto().getImpostoComplementar());
        objRegTXT.fieldByName("VR_LEAO").set(objDecl.getResumo().getCalculoImposto().getCarneLeaoTitular().operacao('+', objDecl.getResumo().getCalculoImposto().getCarneLeaoDependentes()));
        objRegTXT.fieldByName("VR_IRFONTELEI11033").set(objDecl.getModeloSimplificada().getImpostoRetidoFonteLei11033());
        objRegTXT.fieldByName("VR_RENDTRIBDEPENDENTE").set(objDecl.getColecaoRendPJDependente().getTotaisRendRecebidoPJ());
        objRegTXT.fieldByName("VR_IMPOSTODEPENDENTE").set(objDecl.getModeloSimplificada().getImpostoRetidoFonteDependentes());
        objRegTXT.fieldByName("VR_IMPPAGARESPECIE").set(objDecl.getResumo().getOutrasInformacoes().getImpostoEspecie());
        if (objDecl.getModeloSimplificada().getImpostoRestituir().comparacao(">", "0,00")) {
            objRegTXT.fieldByName("VR_IMPRESTIT").set(objDecl.getModeloSimplificada().getImpostoRestituir());
            objRegTXT.fieldByName("VR_IMPPAGAR").set(ConstantesGlobais.ZERO);
        } else if (objDecl.getModeloSimplificada().getSaldoImpostoPagar().comparacao(">", "0,00")) {
            objRegTXT.fieldByName("VR_IMPRESTIT").set(ConstantesGlobais.ZERO);
            objRegTXT.fieldByName("VR_IMPPAGAR").set(objDecl.getModeloSimplificada().getSaldoImpostoPagar());
        } else {
            objRegTXT.fieldByName("VR_IMPPAGAR").set(ConstantesGlobais.ZERO);
            objRegTXT.fieldByName("VR_IMPRESTIT").set(ConstantesGlobais.ZERO);
        }
        objRegTXT.fieldByName("NR_QUOTAS").set(objDecl.getResumo().getCalculoImposto().getNumQuotas().asInteger());
        objRegTXT.fieldByName("VR_QUOTA").set(objDecl.getResumo().getCalculoImposto().getValorQuota());
        objRegTXT.fieldByName("VR_TOTISENTO").set(objDecl.getModeloSimplificada().getRendIsentosNaoTributaveis());
        objRegTXT.fieldByName("VR_TOTEXCLUSIVO").set(objDecl.getModeloSimplificada().getRendSujeitoTribExclusiva());
        objRegTXT.fieldByName("VR_TOTRENDTRIBPJTITULAR").set(objDecl.getModeloSimplificada().getRendRecebidoPJTitular());
        objRegTXT.fieldByName("VR_RENDTRIBARURAL").set(objDecl.getModeloSimplificada().getResultadoTributavelAR());
        objRegTXT.fieldByName("VR_TOTFONTETITULAR").set(objDecl.getModeloSimplificada().getImpostoRetidoFonteTitular());
        objRegTXT.fieldByName("VR_TOTBENSANOBASEANTERIOR").set(objDecl.getModeloSimplificada().getBensDireitosExercicioAnterior());
        objRegTXT.fieldByName("VR_TOTBENSANOBASE").set(objDecl.getModeloSimplificada().getBensDireitosExercicioAtual());
        objRegTXT.fieldByName("VR_TOTDIVIDAANOBASEANTERIOR").set(objDecl.getModeloSimplificada().getDividasExercicioAnterior());
        objRegTXT.fieldByName("VR_TOTDIVIDAANOBASE").set(objDecl.getModeloSimplificada().getDividasExercicioAtual());
        objRegTXT.fieldByName("VR_TOTIRFONTELEI11033").set(objDecl.getModeloSimplificada().getTotalImpostoRetidoNaFonte());
        objRegTXT.fieldByName("VR_RENDISENTOTITULAR").set(objDecl.getRendIsentos().recuperarTotalTitular());
        objRegTXT.fieldByName("VR_RENDISENTODEPENDENTES").set(objDecl.getRendIsentos().recuperarTotalDependentes());
        objRegTXT.fieldByName("VR_TOTRENDEXCLUSTITULAR").set(objDecl.getRendTributacaoExclusiva().recuperarExclusivosTitular());
        objRegTXT.fieldByName("VR_RENDEXCLUSDEPENDENTES").set(objDecl.getRendTributacaoExclusiva().recuperarExclusivosDependentes());
        objRegTXT.fieldByName("VR_RESNAOTRIB_AR").set(objDecl.getRendIsentos().getParcIsentaAtivRural());
        objRegTXT.fieldByName("VR_SUBTOTALISENTOTRANSPORTE").set(objDecl.getRendIsentos().recuperarSubTotalRendIsentoTransportado());
        objRegTXT.fieldByName("VR_SUBTOTALEXCLUSIVOTRANSPORTE").set(objDecl.recuperarSubTotalExclusivoTransporteRendTribExclusiva());
        objRegTXT.fieldByName("VR_GANHOLIQUIDORVTRANSPORTE").set(objDecl.recuperarRendaVariavelTribtExclusiva());
        objRegTXT.fieldByName("VR_RENDISENTOGCTRANSPORTE").set(objDecl.getRendIsentos().getLucroAlienacao());
        objRegTXT.fieldByName("VR_RENDPFEXT").set(objDecl.getModeloSimplificada().getRendRecebidoPFEXTTitular());
        objRegTXT.fieldByName("VR_RENDPFEXTDEPEN").set(objDecl.getModeloSimplificada().getRendRecebidoPFEXTDependentes());
        objRegTXT.fieldByName("VR_DOACOESCAMPANHA").set(objDecl.getResumo().getOutrasInformacoes().getTotalDoacoesCampanhasEleitorais());
        objRegTXT.fieldByName("VR_TOTRENDPJ_EXIB_SUSPTITULAR").set(objDecl.getRendPJComExigibilidade().getColecaoRendPJComExigibilidadeTitular().getTotaisRendPJExigSuspensa());
        objRegTXT.fieldByName("VR_TOTRENDPJ_EXIB_SUSPDEPEN").set(objDecl.getRendPJComExigibilidade().getColecaoRendPJComExigibilidadeDependente().getTotaisRendPJExigSuspensa());
        objRegTXT.fieldByName("VR_TOTDEPJUDIC_TITULAR").set(objDecl.getRendPJComExigibilidade().getColecaoRendPJComExigibilidadeTitular().getTotaisDepositoJudicial());
        objRegTXT.fieldByName("VR_TOTDEPJUDIC_DEPENDEN").set(objDecl.getRendPJComExigibilidade().getColecaoRendPJComExigibilidadeDependente().getTotaisDepositoJudicial());
        objRegTXT.fieldByName("VR_TOTREND_AC_TIT").set(objDecl.getRendAcm().getColecaoRendAcmTitular().getTotaisRendRecebidosAjuste());
        objRegTXT.fieldByName("VR_TOT_IRF_AC_TIT").set(objDecl.getRendAcm().getColecaoRendAcmTitular().getTotaisImpostoRetidoFonteExclusiva());
        objRegTXT.fieldByName("VR_TOT_IMPOSTO_RRA_TIT").set(objDecl.getRendAcm().getColecaoRendAcmTitular().getTotaisImpostoDevidoRRA());
        objRegTXT.fieldByName("VR_TOTREND_AC_DEP").set(objDecl.getRendAcm().getColecaoRendAcmDependente().getTotaisRendRecebidosAjuste());
        objRegTXT.fieldByName("VR_TOT_IRF_AC_DEP").set(objDecl.getRendAcm().getColecaoRendAcmDependente().getTotaisImpostoRetidoFonteExclusiva());
        objRegTXT.fieldByName("VR_TOT_IMPOSTO_RRA_DEP").set(objDecl.getRendAcm().getColecaoRendAcmDependente().getTotaisImpostoDevidoRRA());
        objRegTXT.fieldByName("VR_TOT_IMPOSTO_DEVIDO").set(objDecl.getModeloSimplificada().getImpostoDevidoII());
        objRegTXT.fieldByName("VR_IMPOSTO_DIFERIDO_GCAP").set(objDecl.getResumo().getOutrasInformacoes().getImpostoDiferidoGCAP());
        objRegTXT.fieldByName("VR_IMPOSTO_DEVIDO_GCAP").set(objDecl.getResumo().getOutrasInformacoes().getImpostoDevidoGCAP());
        objRegTXT.fieldByName("VR_IMPOSTO_GANHOLIQ_RVAR").set(objDecl.getResumo().getOutrasInformacoes().getImpostoDevidoRendaVariavel());
        objRegTXT.fieldByName("VR_IMPOSTO_DEVIDO_GCME").set(objDecl.getResumo().getOutrasInformacoes().getImpostoDevidoGCME());
        objRegTXT.fieldByName("VR_IMPEXT").set(objDecl.getModeloSimplificada().getImpostoPagoExterior());
        objRegTXT.fieldByName("VR_ALIQUOTA_EFETIVA").set(objDecl.getResumo().getCalculoImposto().getAliquotaEfetiva());
        objRegTXT.fieldByName("VR_BASE_CALCULO_LEI_14754").set(objDecl.getContribuinte().getBaseCalculoFinalLei14754());
        objRegTXT.fieldByName("VR_IMPOSTO_DEVIDO_LEI_14754").set((Valor)objDecl.getContribuinte().getImpostoDevidoLei14754());
        linha.add(objRegTXT);
        return linha;
    }

    public List<RegistroTxt> montarRecibo(DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        ArrayList<RegistroTxt> linha = new ArrayList<RegistroTxt>();
        RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "HR");
        objRegTXT.fieldByName("NR_REG").set("HR");
        objRegTXT.fieldByName("NR_CPF").set(objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado());
        linha.add(objRegTXT);
        Contribuinte contribuinte = objDecl.getContribuinte();
        objRegTXT = new RegistroTxt("ARQ_IRPF", "DR");
        objRegTXT.fieldByName("NR_REG").set("DR");
        objRegTXT.fieldByName("NR_CPF").set(objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado());
        objRegTXT.fieldByName("IN_COMPLETA").set(objDecl.getIdentificadorDeclaracao().isCompleta());
        objRegTXT.fieldByName("NM_NOME").setLimitado(objDecl.getIdentificadorDeclaracao().getNome().naoFormatado());
        if (contribuinte.getExterior().naoFormatado().equals(Logico.SIM)) {
            objRegTXT.fieldByName("NM_LOGRA").setLimitado(contribuinte.getLogradouroExt().naoFormatado());
            objRegTXT.fieldByName("NR_NUMERO").setLimitado(contribuinte.getNumeroExt().naoFormatado());
            objRegTXT.fieldByName("NM_COMPLEM").setLimitado(contribuinte.getComplementoExt().naoFormatado());
            objRegTXT.fieldByName("NM_BAIRRO").setLimitado(contribuinte.getBairroExt().naoFormatado());
            objRegTXT.fieldByName("NR_CEP").set(contribuinte.getCepExt().naoFormatado());
            objRegTXT.fieldByName("CD_MUNICIP").set("9701");
            objRegTXT.fieldByName("NM_MUNICIP").set(contribuinte.getCidade().formatado());
            objRegTXT.fieldByName("SG_UF").set("EX");
            objRegTXT.fieldByName("NR_DDD_TELEFONE").set(contribuinte.getDdi().naoFormatado());
            objRegTXT.fieldByName("NR_TELEFONE").set(contribuinte.getTelefoneExt().naoFormatado());
        } else {
            objRegTXT.fieldByName("NR_NUMERO").setLimitado(contribuinte.getNumero().naoFormatado());
            objRegTXT.fieldByName("NM_COMPLEM").setLimitado(contribuinte.getComplemento().naoFormatado());
            objRegTXT.fieldByName("NM_BAIRRO").setLimitado(contribuinte.getBairro().naoFormatado());
            objRegTXT.fieldByName("NR_CEP").set(contribuinte.getCep().naoFormatado());
            objRegTXT.fieldByName("TIP_LOGRA").setLimitado(contribuinte.getTipoLogradouro().naoFormatado());
            objRegTXT.fieldByName("NM_LOGRA").setLimitado(contribuinte.getLogradouro().naoFormatado());
            objRegTXT.fieldByName("CD_MUNICIP").set(contribuinte.getMunicipio().getConteudoAtual(0));
            objRegTXT.fieldByName("NM_MUNICIP").set(contribuinte.getMunicipio().getConteudoAtual(1));
            objRegTXT.fieldByName("SG_UF").set(contribuinte.getUf().getConteudoAtual(0));
            objRegTXT.fieldByName("NR_DDD_TELEFONE").set(contribuinte.getDdd().naoFormatado());
            objRegTXT.fieldByName("NR_TELEFONE").set(contribuinte.getTelefone().naoFormatado());
        }
        objRegTXT.fieldByName("IN_RETIFICADORA").set(objDecl.getIdentificadorDeclaracao().isRetificadora() ? "S" : "N");
        objRegTXT.fieldByName("VR_TOTTRIB").set(objDecl.getModelo().recuperarTotalRendimentosTributaveis());
        objRegTXT.fieldByName("VR_IMPDEV").set(objDecl.getModelo().getImpostoDevidoII());
        if (objDecl.getModelo().getSaldoImpostoPagar().comparacao(">", "0,00")) {
            objRegTXT.fieldByName("VR_IMPPAGAR").set(objDecl.getModelo().getSaldoImpostoPagar());
            objRegTXT.fieldByName("VR_IMPREST").set(0);
        } else if (objDecl.getModelo().getImpostoRestituir().comparacao(">", "0,00")) {
            objRegTXT.fieldByName("VR_IMPPAGAR").set(0);
            objRegTXT.fieldByName("VR_IMPREST").set(objDecl.getModelo().getImpostoRestituir());
        }
        objRegTXT.fieldByName("NR_QUOTAS").set(objDecl.getResumo().getCalculoImposto().getNumQuotas().asInteger());
        objRegTXT.fieldByName("VR_QUOTA").set(objDecl.getResumo().getCalculoImposto().getValorQuota());
        objRegTXT.fieldByName("NR_BANCO").set(objDecl.getResumo().getCalculoImposto().getBanco().getConteudoAtual(0));
        objRegTXT.fieldByName("NR_AGENCIA").set(objDecl.getResumo().getCalculoImposto().getAgencia().formatado());
        objRegTXT.fieldByName("IN_DEBITO_PRIMEIRA_QUOTA").set(objDecl.getResumo().getCalculoImposto().getIndicadorPrimeiraQuota().naoFormatado().equals("1") ? "1" : "0");
        ValorPositivo impPagoGCAP = objDecl.getGCAP().getConsolidacaoGeralBrasil().getTotalImpostoPago();
        objRegTXT.fieldByName("VR_GCIMPOSTOPAGO").set((Valor)impPagoGCAP);
        try {
            objRegTXT.fieldByName("NR_CONTA").set(objDecl.getResumo().getCalculoImposto().getContaCreditoFormatadaTxt());
        }
        catch (AplicacaoException e) {
            throw new GeracaoTxtException(e.getMessage(), (Throwable)e);
        }
        objRegTXT.fieldByName("NR_DV_CONTA").set(objDecl.getResumo().getCalculoImposto().getDvContaCredito().formatado());
        objRegTXT.fieldByName("VR_VCMOEDAEST").set(objDecl.getResumo().getOutrasInformacoes().getImpostoEspecie());
        linha.add(objRegTXT);
        objRegTXT = new RegistroTxt("ARQ_IRPF", "R9");
        objRegTXT.fieldByName("NR_REG").set("R9");
        objRegTXT.fieldByName("NR_CPF").set(objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado());
        linha.add(objRegTXT);
        return linha;
    }

    public List<RegistroTxt> montarFichaRendaVariavel(DeclaracaoIRPF objDecl, boolean ehDependente) throws GeracaoTxtException {
        ArrayList<RegistroTxt> linha = new ArrayList<RegistroTxt>();
        String cpfContrib = objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado();
        if (ehDependente) {
            for (ItemRendaVariavelDependente dep : objDecl.getRendaVariavelDependente().itens()) {
                this.montarRendaVariavel(cpfContrib, dep.getCpf().naoFormatado(), ehDependente, linha, dep.getRendaVariavel());
            }
        } else {
            this.montarRendaVariavel(cpfContrib, "", ehDependente, linha, objDecl.getRendaVariavel());
        }
        return linha;
    }

    private void montarRendaVariavel(String cpfContribuinte, String cpfDependente, boolean ehDependente, List<RegistroTxt> linha, RendaVariavel rendaVariavel) throws GeracaoTxtException {
        for (int i = 1; i <= 12; ++i) {
            GanhosLiquidosOuPerdas ganhoLiquidoOuPerda = rendaVariavel.getGanhosPorIndice(i - 1);
            RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "40");
            objRegTXT.fieldByName("NR_REG").set("40");
            objRegTXT.fieldByName("NR_CPF").set(cpfContribuinte);
            objRegTXT.fieldByName("NR_MES").set(rendaVariavel.obterMesFormatoNumerico(ganhoLiquidoOuPerda));
            Operacoes opComuns = ganhoLiquidoOuPerda.getOperacoesComuns();
            objRegTXT.fieldByName("VR_COMUM_MVISTA_ACOES").set(opComuns.getMercadoVistaAcoes());
            objRegTXT.fieldByName("VR_COMUM_MVISTA_OURO").set(opComuns.getMercadoVistaOuro());
            objRegTXT.fieldByName("VR_COMUM_MVISTA_OUROFORA").set(opComuns.getMercadoVistaForaBolsa());
            objRegTXT.fieldByName("VR_COMUM_MOPC_ACOES").set(opComuns.getMercadoOpcoesAcoes());
            objRegTXT.fieldByName("VR_COMUM_MOPC_OURO").set(opComuns.getMercadoOpcoesOuro());
            objRegTXT.fieldByName("VR_COMUM_MOPC_OUROFORA").set(opComuns.getMercadoOpcoesForaDeBolsa());
            objRegTXT.fieldByName("VR_COMUM_MOPC_OUTROS").set(opComuns.getMercadoOpcoesOutros());
            objRegTXT.fieldByName("VR_COMUM_MFUT_DOLAR").set(opComuns.getMercadoFuturoDolar());
            objRegTXT.fieldByName("VR_COMUM_MFUT_INDICES").set(opComuns.getMercadoFuturoIndices());
            objRegTXT.fieldByName("VR_COMUM_MFUT_JUROS").set(opComuns.getMercadoFuturoJuros());
            objRegTXT.fieldByName("VR_COMUM_MFUT_OUTROS").set(opComuns.getMercadoFuturoOutros());
            objRegTXT.fieldByName("VR_COMUM_MTERMO_ACOESOURO").set(opComuns.getMercadoTermoAcoes());
            objRegTXT.fieldByName("VR_COMUM_MTERMO_OUTROS").set(opComuns.getMercadoTermoOutros());
            Operacoes opDayTrade = ganhoLiquidoOuPerda.getOperacoesDayTrade();
            objRegTXT.fieldByName("VR_DAYTR_MVISTA_ACOES").set(opDayTrade.getMercadoVistaAcoes());
            objRegTXT.fieldByName("VR_DAYTR_MVISTA_OURO").set(opDayTrade.getMercadoVistaOuro());
            objRegTXT.fieldByName("VR_DAYTR_MVISTA_OUROFORA").set(opDayTrade.getMercadoVistaForaBolsa());
            objRegTXT.fieldByName("VR_DAYTR_MOPC_ACOES").set(opDayTrade.getMercadoOpcoesAcoes());
            objRegTXT.fieldByName("VR_DAYTR_MOPC_OURO").set(opDayTrade.getMercadoOpcoesOuro());
            objRegTXT.fieldByName("VR_DAYTR_MOPC_OUROFORA").set(opDayTrade.getMercadoOpcoesForaDeBolsa());
            objRegTXT.fieldByName("VR_DAYTR_MOPC_OUTROS").set(opDayTrade.getMercadoOpcoesOutros());
            objRegTXT.fieldByName("VR_DAYTR_MFUT_DOLAR").set(opDayTrade.getMercadoFuturoDolar());
            objRegTXT.fieldByName("VR_DAYTR_MFUT_INDICES").set(opDayTrade.getMercadoFuturoIndices());
            objRegTXT.fieldByName("VR_DAYTR_MFUT_JUROS").set(opDayTrade.getMercadoFuturoJuros());
            objRegTXT.fieldByName("VR_DAYTR_MFUT_OUTROS").set(opDayTrade.getMercadoFuturoOutros());
            objRegTXT.fieldByName("VR_DAYTR_MTERMO_ACOESOURO").set(opDayTrade.getMercadoTermoAcoes());
            objRegTXT.fieldByName("VR_DAYTR_MTERMO_OUTROS").set(opDayTrade.getMercadoTermoOutros());
            objRegTXT.fieldByName("VR_FONTE_DAYTRADE").set((Valor)ganhoLiquidoOuPerda.getIrFonteDayTradeMesAtual());
            objRegTXT.fieldByName("VR_IMPOSTO_PAGO").set((Valor)ganhoLiquidoOuPerda.getImpostoPago());
            objRegTXT.fieldByName("VR_IMPRENDAFONTE").set((Valor)ganhoLiquidoOuPerda.getImpostoRetidoFonteLei11033());
            objRegTXT.fieldByName("VR_RESULTNEG_MESANT_COMUM").set((Valor)opComuns.getResultadoNegativoMesAnterior());
            objRegTXT.fieldByName("VR_RESULTNEG_MESANT_DAYTR").set((Valor)opDayTrade.getResultadoNegativoMesAnterior());
            objRegTXT.fieldByName("VR_RESULTLIQ_MES_COMUM").set(opComuns.getResultadoLiquidoMes());
            objRegTXT.fieldByName("VR_RESULTLIQ_MES_DAYTR").set(opDayTrade.getResultadoLiquidoMes());
            objRegTXT.fieldByName("VR_BASECALCULO_MES_COMUM").set(opComuns.getBaseCalculoImposto());
            objRegTXT.fieldByName("VR_BASECALCULO_MES_DAYTR").set(opDayTrade.getBaseCalculoImposto());
            objRegTXT.fieldByName("VR_PREJACOMPENS_MES_COMUM").set(opComuns.getPrejuizoCompensar());
            objRegTXT.fieldByName("VR_PREJACOMPENS_MES_DAYTR").set(opDayTrade.getPrejuizoCompensar());
            objRegTXT.fieldByName("VR_ALIQUOTA_IMPOSTO_COMUM").set(new Valor("15"));
            objRegTXT.fieldByName("VR_ALIQUOTA_IMPOSTO_DAYTRADE").set(new Valor("20"));
            objRegTXT.fieldByName("VR_IMPOSTODEVIDO_MES_COMUM").set(opComuns.getImpostoDevido());
            objRegTXT.fieldByName("VR_IMPOSTODEVIDO_MES_DAYTR").set(opDayTrade.getImpostoDevido());
            objRegTXT.fieldByName("VR_TOTAL_IMPOSTODEVIDO").set(ganhoLiquidoOuPerda.getTotalImpostoDevido());
            objRegTXT.fieldByName("VR_IRFONTE_MESESANT_DAYTR").set(ganhoLiquidoOuPerda.getIrFonteDayTradeMesesAnteriores());
            objRegTXT.fieldByName("VR_IRFONTE_ACOMPENS_DAYTR").set(ganhoLiquidoOuPerda.getIrFonteDayTradeAcompensar());
            objRegTXT.fieldByName("VR_TOTAL_IMPOSTOAPAGAR").set((Valor)ganhoLiquidoOuPerda.getImpostoApagar());
            objRegTXT.fieldByName("VR_IRF_MESESANT").set((Valor)ganhoLiquidoOuPerda.getImpostoRetidoFonteLei11033MesesAnteriores());
            objRegTXT.fieldByName("VR_IRF_COMPENSAR").set((Valor)ganhoLiquidoOuPerda.getImpostoRetidoFonteLei11033MesesCompensar());
            objRegTXT.fieldByName("E_DEPENDENTE").set(ehDependente);
            objRegTXT.fieldByName("NR_CPF_DEPEN").set(cpfDependente);
            linha.add(objRegTXT);
        }
    }

    public List<RegistroTxt> montarFichaRendaVariavelAnual(DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        ArrayList<RegistroTxt> linha = new ArrayList<RegistroTxt>();
        RendaVariavel rendaVariavelTitular = objDecl.getRendaVariavel();
        ColecaoRendaVariavelDependente colecaoRendaVariavelDependente = objDecl.getRendaVariavelDependente();
        Map tabelaTotais = rendaVariavelTitular.obterTotalAnual();
        RendaVariavel.somarTotalAnual((Map)tabelaTotais, (Map)colecaoRendaVariavelDependente.obterTotalAnual());
        RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "41");
        objRegTXT.fieldByName("NR_REG").set("41");
        objRegTXT.fieldByName("NR_CPF").set(objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado());
        objRegTXT.fieldByName("VR_RESULTLIQUIDO").set((Valor)tabelaTotais.get("TotalResultadosLiquidos"));
        objRegTXT.fieldByName("VR_RESULTNEGMESANTERIOR").set((Valor)tabelaTotais.get("TotalResultadosNegativos"));
        objRegTXT.fieldByName("VR_BASECALCULO").set((Valor)tabelaTotais.get("BaseCalculoImposto"));
        objRegTXT.fieldByName("VR_PREJUIZOCOMPENSAR").set((Valor)tabelaTotais.get("PrejuizoCompensar"));
        objRegTXT.fieldByName("VR_IMPOSTODEVIDO").set((Valor)tabelaTotais.get("ImpostoDevido"));
        objRegTXT.fieldByName("VR_CONSOL_IMPOSTOIMPOSTODEVIDO").set((Valor)tabelaTotais.get("ImpostoDevidoConsolidacao"));
        objRegTXT.fieldByName("VR_CONSOL_IRFONTEDAYTRMESANT").set((Valor)tabelaTotais.get("IRDayTradeMesesAnteriores"));
        objRegTXT.fieldByName("VR_CONSOL_IRFONTEDAYTRCOMPENSAR").set((Valor)tabelaTotais.get("IRDayTradeCompensar"));
        Valor totalIrFonteLei11033 = new Valor();
        totalIrFonteLei11033.append('+', objDecl.getRendaVariavel().getTotalImpostoRetidoFonteLei11033());
        totalIrFonteLei11033.append('+', objDecl.getRendaVariavelDependente().getTotalImpostoRetidoFonteLei11033());
        objRegTXT.fieldByName("VR_TOTALANUALIRFONTELEI11033").set(totalIrFonteLei11033);
        objRegTXT.fieldByName("VR_CONSOL_IMPOSTOAPAGAR").set((Valor)tabelaTotais.get("TotalImpostoAPagar"));
        linha.add(objRegTXT);
        return linha;
    }

    public List<RegistroTxt> montarFichaRendaVariavelFII(DeclaracaoIRPF objDecl, boolean ehDependente) throws GeracaoTxtException {
        ArrayList<RegistroTxt> linha = new ArrayList<RegistroTxt>();
        String cpfContrib = objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado();
        if (ehDependente) {
            for (ItemFundosInvestimentosDependente dep : objDecl.getFundosInvestimentosDependente().itens()) {
                this.montarRendaVariavelFII(cpfContrib, dep.getCpf().naoFormatado(), ehDependente, linha, dep.getFundosInvestimentos());
            }
        } else {
            this.montarRendaVariavelFII(cpfContrib, "", ehDependente, linha, objDecl.getFundosInvestimentos());
        }
        return linha;
    }

    private void montarRendaVariavelFII(String cpfContribuinte, String cpfDependente, boolean ehDependente, List<RegistroTxt> linha, FundosInvestimentos fundosInvestimentos) throws GeracaoTxtException {
        NumberFormat numFormat = null;
        for (int i = 1; i <= 12; ++i) {
            MesFundosInvestimentos mesFundoInvest = fundosInvestimentos.getMeses()[i - 1];
            if (mesFundoInvest.isVazio()) continue;
            RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "42");
            objRegTXT.fieldByName("NR_REG").set("42");
            objRegTXT.fieldByName("NR_CPF").set(cpfContribuinte);
            numFormat = NumberFormat.getInstance();
            numFormat.setMaximumFractionDigits(0);
            numFormat.setMinimumIntegerDigits(2);
            numFormat.setGroupingUsed(false);
            objRegTXT.fieldByName("NR_MES").set(numFormat.format(i));
            objRegTXT.fieldByName("VR_RESLIQUIDO_MES").set(mesFundoInvest.getResultLiquidoMes());
            objRegTXT.fieldByName("VR_RESULT_NEG_MESANT").set(mesFundoInvest.getResultNegativoAnterior());
            objRegTXT.fieldByName("VR_BASECALCULO_MES").set(mesFundoInvest.getBaseCalcImposto());
            objRegTXT.fieldByName("VR_PREJACOMPENSAR_MES_OPCOMUNS").set(mesFundoInvest.getPrejuizoCompensar());
            objRegTXT.fieldByName("VR_ALIQUOTA_IMPOSTO_OPCOMUNS").set(mesFundoInvest.getAliquotaImposto());
            objRegTXT.fieldByName("VR_IMPOSTODEVIDO_MES_OPCOMUNS").set(mesFundoInvest.getImpostoDevido());
            objRegTXT.fieldByName("VR_IMPOSTO_RETIDO_MESES_ANTERIORES").set(mesFundoInvest.getImpostoRetidoMesesAnteriores());
            objRegTXT.fieldByName("VR_IMPOSTO_RETIDO_FONTE").set(mesFundoInvest.getImpostoRetidoFonte());
            objRegTXT.fieldByName("VR_IMPOSTO_RETIDO_COMPENSAR").set(mesFundoInvest.getImpostoRetidoCompensar());
            objRegTXT.fieldByName("VR_IMPOSTO_PAGAR").set(mesFundoInvest.getImpostoAPagar());
            objRegTXT.fieldByName("VR_IMPOSTOPAGO").set(mesFundoInvest.getImpostoPago());
            objRegTXT.fieldByName("E_DEPENDENTE").set(ehDependente);
            objRegTXT.fieldByName("NR_CPF_DEPEN").set(cpfDependente);
            linha.add(objRegTXT);
        }
    }

    public List<RegistroTxt> montarFichaRendaVariavelTotaisFII(DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        ArrayList<RegistroTxt> linha = new ArrayList<RegistroTxt>();
        FundosInvestimentos fundoInvest = objDecl.getFundosInvestimentos();
        Map map = fundoInvest.obterTotalAnual();
        RendaVariavel.somarTotalAnual((Map)map, (Map)objDecl.getFundosInvestimentosDependente().obterTotalAnual());
        RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "43");
        objRegTXT.fieldByName("NR_REG").set("43");
        objRegTXT.fieldByName("NR_CPF").set(objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado());
        objRegTXT.fieldByName("VR_TOTALANUALRESULTADOLIQUIDOSRENDAVARIAVEL_FII").set((Valor)map.get("VR_TOTALANUALRESULTADOLIQUIDOSRENDAVARIAVEL_FII"));
        objRegTXT.fieldByName("VR_TOTALANUALRESULTADONEGATIVOMESANTERIOR_FII").set((Valor)map.get("VR_TOTALANUALRESULTADONEGATIVOMESANTERIOR_FII"));
        objRegTXT.fieldByName("VR_TOTALANUALBASECALCULOIMPOSTO_FII").set((Valor)map.get("VR_TOTALANUALBASECALCULOIMPOSTO_FII"));
        objRegTXT.fieldByName("VR_TOTALANUALPREJUIZOCOMPENSAR_FII").set((Valor)map.get("VR_TOTALANUALPREJUIZOCOMPENSAR_FII"));
        objRegTXT.fieldByName("VR_TOTALANUALIMPOSTODEVIDO_FII").set((Valor)map.get("VR_TOTALANUALIMPOSTODEVIDO_FII"));
        objRegTXT.fieldByName("VR_TOTALANUALIMPOSTOPAGAR_FII").set((Valor)map.get("VR_TOTALANUALIMPOSTOPAGAR_FII"));
        objRegTXT.fieldByName("VR_TOTALANUALIMPOSTORETIDONAFONTE_FII").set((Valor)map.get("VR_TOTALANUALIMPOSTORETIDONAFONTE_FII"));
        linha.add(objRegTXT);
        return linha;
    }

    public List<RegistroTxt> montarFichaAtividadeRuralIdentificacaoImovel(DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        RegistroTxt objRegTXT;
        ArrayList<RegistroTxt> linha = new ArrayList<RegistroTxt>();
        ARBrasil arBrasil = objDecl.getAtividadeRural().getBrasil();
        arBrasil.getIdentificacaoImovel().excluirRegistrosEmBranco();
        for (ImovelARBrasil imovel : arBrasil.getIdentificacaoImovel().itens()) {
            objRegTXT = new RegistroTxt("ARQ_IRPF", "50");
            objRegTXT.fieldByName("NR_REG").set("50");
            objRegTXT.fieldByName("NR_CPF").set(objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado());
            objRegTXT.fieldByName("IN_EXTERIOR").set(0);
            objRegTXT.fieldByName("NR_INCRA").set(imovel.getCIB().naoFormatado());
            objRegTXT.fieldByName("NM_IMOVEL").set(imovel.getNome().naoFormatado());
            objRegTXT.fieldByName("NM_LOCAL").set(imovel.getLocalizacao().naoFormatado());
            objRegTXT.fieldByName("QT_AREA").set(imovel.getArea());
            objRegTXT.fieldByName("PC_PARTIC").set(imovel.getParticipacao());
            objRegTXT.fieldByName("CD_EXPLOR").set(imovel.getCondicaoExploracao().getConteudoAtual(0));
            objRegTXT.fieldByName("CD_ATIV").set(imovel.getCodigo().getConteudoAtual(0));
            objRegTXT.fieldByName("NR_CHAVE_AR").set(imovel.getIndice().naoFormatado());
            linha.add(objRegTXT);
        }
        ARExterior arExterior = objDecl.getAtividadeRural().getExterior();
        arExterior.getIdentificacaoImovel().excluirRegistrosEmBranco();
        for (ImovelAR imovel : arExterior.getIdentificacaoImovel().itens()) {
            objRegTXT = new RegistroTxt("ARQ_IRPF", "50");
            objRegTXT.fieldByName("NR_REG").set("50");
            objRegTXT.fieldByName("NR_CPF").set(objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado());
            objRegTXT.fieldByName("IN_EXTERIOR").set(1);
            objRegTXT.fieldByName("NM_IMOVEL").set(imovel.getNome().naoFormatado());
            objRegTXT.fieldByName("NM_LOCAL").set(imovel.getLocalizacao().naoFormatado());
            objRegTXT.fieldByName("QT_AREA").set(imovel.getArea());
            objRegTXT.fieldByName("PC_PARTIC").set(imovel.getParticipacao());
            objRegTXT.fieldByName("CD_EXPLOR").set(imovel.getCondicaoExploracao().getConteudoAtual(0));
            objRegTXT.fieldByName("CD_ATIV").set(imovel.getCodigo().naoFormatado());
            objRegTXT.fieldByName("NR_CHAVE_AR").set(imovel.getIndice().naoFormatado());
            linha.add(objRegTXT);
        }
        return linha;
    }

    public List<RegistroTxt> montarFichaAtividadeRuralReceitasDespesasBrasil(DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        ArrayList<RegistroTxt> linha = new ArrayList<RegistroTxt>();
        ReceitasDespesas receitasDespesas = objDecl.getAtividadeRural().getBrasil().getReceitasDespesas();
        for (int i = 0; i <= 11; ++i) {
            MesReceitaDespesa receita = receitasDespesas.getMesReceitaPorIndice(i);
            if (receita.isVazio()) continue;
            RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "51");
            objRegTXT.fieldByName("NR_REG").set("51");
            objRegTXT.fieldByName("NR_CPF").set(objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado());
            objRegTXT.fieldByName("IN_EXTERIOR").set(0);
            objRegTXT.fieldByName("NR_MES").set(receitasDespesas.obterMesFormatoNumerico(receita));
            objRegTXT.fieldByName("VR_DESP").set(receita.getDespesaCusteioInvestimento());
            objRegTXT.fieldByName("VR_REC").set(receita.getReceitaBrutaMensal());
            linha.add(objRegTXT);
        }
        return linha;
    }

    public List<RegistroTxt> montarFichaAtividadeRuralApuracaoResultado(DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        ApuracaoResultadoExterior apuracaoEx;
        RegistroTxt objRegTXT;
        ArrayList<RegistroTxt> linha = new ArrayList<RegistroTxt>();
        AtividadeRural atividadeRural = objDecl.getAtividadeRural();
        ApuracaoResultadoBrasil apuracaoBR = atividadeRural.getBrasil().getApuracaoResultado();
        if (!apuracaoBR.isVazio()) {
            objRegTXT = new RegistroTxt("ARQ_IRPF", "52");
            objRegTXT.fieldByName("NR_REG").set("52");
            objRegTXT.fieldByName("IN_EXTERIOR").set(0);
            objRegTXT.fieldByName("NR_CPF").set(objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado());
            objRegTXT.fieldByName("VR_RECTOTAL").set(apuracaoBR.getReceitaBrutaTotal());
            objRegTXT.fieldByName("VR_DESPTOTAL").set(apuracaoBR.getDespesaCusteio());
            objRegTXT.fieldByName("VR_RES1REAL").set(apuracaoBR.getResultadoI());
            objRegTXT.fieldByName("VR_PREJEXERCANT").set((Valor)apuracaoBR.getPrejuizoExercicioAnterior());
            objRegTXT.fieldByName("VR_COMP_PREJ_EXERC_ANT").set((Valor)apuracaoBR.getCompensacaoPrejuizoExerciciosAnteriores());
            objRegTXT.fieldByName("VR_OPCAO").set(apuracaoBR.getLimiteVintePorCentoReceitaBruta());
            objRegTXT.fieldByName("VR_RESTRIB").set((Valor)apuracaoBR.getResultadoTributavel());
            objRegTXT.fieldByName("VR_PREJUIZO").set(apuracaoBR.getPrejuizoCompensar());
            objRegTXT.fieldByName("VR_RECVENDAFUTURA").set((Valor)apuracaoBR.getReceitaRecebidaContaVenda());
            objRegTXT.fieldByName("VR_ADIANT").set((Valor)apuracaoBR.getValorAdiantamento());
            objRegTXT.fieldByName("VR_RESNAOTRIBAR").set(apuracaoBR.getResultadoNaoTributavel());
            objRegTXT.fieldByName("VR_RES1DOLAR").set(0);
            objRegTXT.fieldByName("IN_OPC_APURRESTRIB").set(apuracaoBR.getOpcaoFormaApuracao().naoFormatado());
            linha.add(objRegTXT);
        }
        if (!(apuracaoEx = atividadeRural.getExterior().getApuracaoResultado()).isVazio()) {
            objRegTXT = new RegistroTxt("ARQ_IRPF", "52");
            objRegTXT.fieldByName("NR_REG").set("52");
            objRegTXT.fieldByName("NR_CPF").set(objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado());
            objRegTXT.fieldByName("IN_EXTERIOR").set(1);
            objRegTXT.fieldByName("VR_RECTOTAL").set(0);
            objRegTXT.fieldByName("VR_DESPTOTAL").set(0);
            objRegTXT.fieldByName("VR_RES1REAL").set(apuracaoEx.getResultadoI_EmReais());
            objRegTXT.fieldByName("VR_PREJEXERCANT").set((Valor)apuracaoEx.getPrejuizoExercicioAnterior());
            objRegTXT.fieldByName("VR_COMP_PREJ_EXERC_ANT").set((Valor)apuracaoEx.getCompensacaoPrejuizoExerciciosAnteriores());
            objRegTXT.fieldByName("VR_OPCAO").set((Valor)apuracaoEx.getLimiteVintePorCentoReceitaBruta());
            objRegTXT.fieldByName("VR_RESTRIB").set((Valor)apuracaoEx.getResultadoTributavel());
            objRegTXT.fieldByName("VR_PREJUIZO").set(apuracaoEx.getPrejuizoCompensar());
            objRegTXT.fieldByName("VR_RECVENDAFUTURA").set((Valor)apuracaoEx.getReceitaRecebidaContaVenda());
            objRegTXT.fieldByName("VR_ADIANT").set((Valor)apuracaoEx.getValorAdiantamento());
            objRegTXT.fieldByName("VR_RESNAOTRIBAR").set(apuracaoEx.getResultadoNaoTributavel());
            objRegTXT.fieldByName("VR_RES1DOLAR").set(apuracaoEx.getResultadoI_EmDolar());
            objRegTXT.fieldByName("IN_OPC_APURRESTRIB").set(apuracaoEx.getOpcaoFormaApuracao().naoFormatado());
            linha.add(objRegTXT);
        }
        return linha;
    }

    private void setarValoresTipoDadoMovimentacaoRebanho(ItemMovimentacaoRebanho tipoDado, RegistroTxt pReg) throws GeracaoTxtException {
        pReg.fieldByName("QT_INIC").set(tipoDado.getEstoqueInicial());
        pReg.fieldByName("QT_COMPRA").set(tipoDado.getAquisicoesAno());
        pReg.fieldByName("QT_NASCIM").set(tipoDado.getNascidosAno());
        pReg.fieldByName("QT_PERDA").set(tipoDado.getConsumo());
        pReg.fieldByName("QT_VENDA").set(tipoDado.getVendas());
        pReg.fieldByName("QT_ESTFINAL").set(tipoDado.getEstoqueFinal());
    }

    private void setarMovimentacaoRebanho(DeclaracaoIRPF objDecl, RegistroTxt pObjRegTXT, List<RegistroTxt> linha, int pExterior) throws GeracaoTxtException {
        RegistroTxt objRegTXT;
        AtividadeRural atividadeRural = objDecl.getAtividadeRural();
        MovimentacaoRebanho movBr = pExterior == 0 ? atividadeRural.getBrasil().getMovimentacaoRebanho() : atividadeRural.getExterior().getMovimentacaoRebanho();
        if (!movBr.getBovinos().isVazio()) {
            objRegTXT = new RegistroTxt("ARQ_IRPF", "53");
            objRegTXT.fieldByName("NR_REG").set("53");
            objRegTXT.fieldByName("IN_EXTERIOR").set(pExterior);
            objRegTXT.fieldByName("NR_CPF").set(objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado());
            objRegTXT.fieldByName("CD_ESPEC").set(1);
            this.setarValoresTipoDadoMovimentacaoRebanho(movBr.getBovinos(), objRegTXT);
            linha.add(objRegTXT);
        }
        if (!movBr.getSuinos().isVazio()) {
            objRegTXT = new RegistroTxt("ARQ_IRPF", "53");
            objRegTXT.fieldByName("NR_REG").set("53");
            objRegTXT.fieldByName("IN_EXTERIOR").set(pExterior);
            objRegTXT.fieldByName("NR_CPF").set(objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado());
            objRegTXT.fieldByName("CD_ESPEC").set(2);
            this.setarValoresTipoDadoMovimentacaoRebanho(movBr.getSuinos(), objRegTXT);
            linha.add(objRegTXT);
        }
        if (!movBr.getCaprinos().isVazio()) {
            objRegTXT = new RegistroTxt("ARQ_IRPF", "53");
            objRegTXT.fieldByName("NR_REG").set("53");
            objRegTXT.fieldByName("IN_EXTERIOR").set(pExterior);
            objRegTXT.fieldByName("NR_CPF").set(objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado());
            objRegTXT.fieldByName("CD_ESPEC").set(3);
            this.setarValoresTipoDadoMovimentacaoRebanho(movBr.getCaprinos(), objRegTXT);
            linha.add(objRegTXT);
        }
        if (!movBr.getAsininos().isVazio()) {
            objRegTXT = new RegistroTxt("ARQ_IRPF", "53");
            objRegTXT.fieldByName("NR_REG").set("53");
            objRegTXT.fieldByName("IN_EXTERIOR").set(pExterior);
            objRegTXT.fieldByName("NR_CPF").set(objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado());
            objRegTXT.fieldByName("CD_ESPEC").set(4);
            this.setarValoresTipoDadoMovimentacaoRebanho(movBr.getAsininos(), objRegTXT);
            linha.add(objRegTXT);
        }
        if (!movBr.getOutros().isVazio()) {
            objRegTXT = new RegistroTxt("ARQ_IRPF", "53");
            objRegTXT.fieldByName("NR_REG").set("53");
            objRegTXT.fieldByName("IN_EXTERIOR").set(pExterior);
            objRegTXT.fieldByName("NR_CPF").set(objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado());
            objRegTXT.fieldByName("CD_ESPEC").set(5);
            this.setarValoresTipoDadoMovimentacaoRebanho(movBr.getOutros(), objRegTXT);
            linha.add(objRegTXT);
        }
    }

    public List<RegistroTxt> montarFichaAtividadeRuralMovimentacaoRebanho(DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        ArrayList<RegistroTxt> linha = new ArrayList<RegistroTxt>();
        RegistroTxt objRegTXT = null;
        if (!objDecl.getAtividadeRural().getBrasil().getMovimentacaoRebanho().isVazio()) {
            this.setarMovimentacaoRebanho(objDecl, objRegTXT, linha, 0);
        }
        if (!objDecl.getAtividadeRural().getExterior().getMovimentacaoRebanho().isVazio()) {
            this.setarMovimentacaoRebanho(objDecl, objRegTXT, linha, 1);
        }
        return linha;
    }

    public List<RegistroTxt> montarFichaAtividadeRuralBens(DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        ArrayList<RegistroTxt> linha = new ArrayList<RegistroTxt>();
        this.setarBensAR(objDecl, 0, linha);
        this.setarBensAR(objDecl, 1, linha);
        return linha;
    }

    public void setarBensAR(DeclaracaoIRPF objDecl, int pExterior, List<RegistroTxt> linha) throws GeracaoTxtException {
        AtividadeRural atividadeRural = objDecl.getAtividadeRural();
        Iterator itBens = null;
        if (pExterior == 0) {
            atividadeRural.getBens().excluirRegistrosEmBranco();
            itBens = atividadeRural.getBensBrasil().iterator();
        } else {
            atividadeRural.getBens().excluirRegistrosEmBranco();
            itBens = atividadeRural.getBensExterior().iterator();
        }
        while (itBens.hasNext()) {
            BemAR bem = (BemAR)itBens.next();
            RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "54");
            objRegTXT.fieldByName("NR_REG").set("54");
            objRegTXT.fieldByName("IN_EXTERIOR").set(pExterior);
            objRegTXT.fieldByName("NR_CPF").set(objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado());
            objRegTXT.fieldByName("CD_PAIS").set(bem.getPais().getConteudoAtual(0));
            objRegTXT.fieldByName("CD_BEMAR").set(bem.getCodigo().getConteudoAtual(0));
            objRegTXT.fieldByName("TX_BEM").set(bem.getDiscriminacao().formatado());
            objRegTXT.fieldByName("VR_BEM").set((Valor)bem.getValorExercicioAtual());
            objRegTXT.fieldByName("VR_BEM_ANTERIOR").set((Valor)bem.getValorExercicioAnterior());
            linha.add(objRegTXT);
        }
    }

    public List<RegistroTxt> montarFichaAtividadeRuralDividas(DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        ArrayList<RegistroTxt> linha = new ArrayList<RegistroTxt>();
        this.setarDividasAR(objDecl, 0, linha);
        this.setarDividasAR(objDecl, 1, linha);
        return linha;
    }

    public void setarDividasAR(DeclaracaoIRPF objDecl, int pExterior, List<RegistroTxt> linha) throws GeracaoTxtException {
        AtividadeRural atividadeRural = objDecl.getAtividadeRural();
        Iterator itDividas = null;
        if (pExterior == 0) {
            atividadeRural.getBrasil().getDividas().excluirRegistrosEmBranco();
            itDividas = atividadeRural.getBrasil().getDividas().itens().iterator();
        } else {
            atividadeRural.getExterior().getDividas().excluirRegistrosEmBranco();
            itDividas = atividadeRural.getExterior().getDividas().itens().iterator();
        }
        while (itDividas.hasNext()) {
            DividaAR divida = (DividaAR)itDividas.next();
            RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "55");
            objRegTXT.fieldByName("NR_REG").set("55");
            objRegTXT.fieldByName("IN_EXTERIOR").set(pExterior);
            objRegTXT.fieldByName("NR_CPF").set(objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado());
            objRegTXT.fieldByName("TX_DIVIDA").set(divida.getDiscriminacao().formatado());
            objRegTXT.fieldByName("VR_DIVATE").set((Valor)divida.getContraidasAteExercicioAnterior());
            objRegTXT.fieldByName("VR_DIVATU").set((Valor)divida.getContraidasAteExercicioAtual());
            objRegTXT.fieldByName("VR_PAGAMENTOANUAL").set((Valor)divida.getValorPagamentoAnual());
            linha.add(objRegTXT);
        }
    }

    public List<RegistroTxt> montarFichaAtividadeRuralReceitasDespesasExterior(DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        ArrayList<RegistroTxt> linha = new ArrayList<RegistroTxt>();
        AtividadeRural atividadeRural = objDecl.getAtividadeRural();
        atividadeRural.getExterior().getReceitasDespesas().excluirRegistrosEmBranco();
        for (ReceitaDespesa receita : atividadeRural.getExterior().getReceitasDespesas().itens()) {
            RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "56");
            objRegTXT.fieldByName("NR_REG").set("56");
            objRegTXT.fieldByName("NR_CPF").set(objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado());
            objRegTXT.fieldByName("CD_PAIS").set(receita.getPais().getConteudoAtual(0));
            objRegTXT.fieldByName("DESPCUSTEIO").set(receita.getDespesaCusteio());
            objRegTXT.fieldByName("RECBRUTA").set(receita.getReceitaBruta());
            objRegTXT.fieldByName("RESDOLAR").set(receita.getResultadoI_EmDolar());
            objRegTXT.fieldByName("RESORIGINAL").set(receita.getResultadoIMoedaOriginal());
            linha.add(objRegTXT);
        }
        return linha;
    }

    public List<RegistroTxt> montarREG57_AtividadeRuralProprietario(DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        RegistroTxt objRegTXT;
        ArrayList<RegistroTxt> linha = new ArrayList<RegistroTxt>();
        ARBrasil arBrasil = objDecl.getAtividadeRural().getBrasil();
        arBrasil.getIdentificacaoImovel().excluirRegistrosEmBranco();
        for (ImovelARBrasil imovel : arBrasil.getIdentificacaoImovel().itens()) {
            for (ParticipanteImovelAR participante : imovel.getParticipantesImovelAR().itens()) {
                if (participante == null || participante.isVazio()) continue;
                objRegTXT = new RegistroTxt("ARQ_IRPF", "57");
                objRegTXT.fieldByName("NR_REG").set("57");
                objRegTXT.fieldByName("NR_CPF").set(objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado());
                objRegTXT.fieldByName("NR_CPF_CNPJ_PROPRIETARIO").set(participante.getNi().naoFormatado());
                objRegTXT.fieldByName("NM_NOME_PROPRIETARIO").set(participante.getNome().naoFormatado());
                if (participante.getEstrangeiro().isVazio()) {
                    objRegTXT.fieldByName("IN_EXTERIOR").set(0);
                } else {
                    objRegTXT.fieldByName("IN_EXTERIOR").set(participante.getEstrangeiro().naoFormatado());
                }
                objRegTXT.fieldByName("NR_CHAVE_AR").set(participante.getIndice().naoFormatado());
                linha.add(objRegTXT);
            }
        }
        ARExterior arExterior = objDecl.getAtividadeRural().getExterior();
        arExterior.getIdentificacaoImovel().excluirRegistrosEmBranco();
        for (ImovelAR imovel : arExterior.getIdentificacaoImovel().itens()) {
            for (ParticipanteImovelAR participante : imovel.getParticipantesImovelAR().itens()) {
                if (participante == null) continue;
                objRegTXT = new RegistroTxt("ARQ_IRPF", "57");
                objRegTXT.fieldByName("NR_REG").set("57");
                objRegTXT.fieldByName("NR_CPF").set(objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado());
                objRegTXT.fieldByName("NR_CPF_CNPJ_PROPRIETARIO").set(participante.getNi().naoFormatado());
                objRegTXT.fieldByName("NM_NOME_PROPRIETARIO").set(participante.getNome().naoFormatado());
                if (participante.getEstrangeiro().isVazio()) {
                    objRegTXT.fieldByName("IN_EXTERIOR").set(0);
                } else {
                    objRegTXT.fieldByName("IN_EXTERIOR").set(participante.getEstrangeiro().naoFormatado());
                }
                objRegTXT.fieldByName("NR_CHAVE_AR").set(participante.getIndice().naoFormatado());
                linha.add(objRegTXT);
            }
        }
        return linha;
    }

    public List<RegistroTxt> montarRegistro60(DeclaracaoIRPF declaracao) throws GeracaoTxtException {
        ArrayList<RegistroTxt> linha = new ArrayList<RegistroTxt>();
        for (IdDemonstrativoGCAP idDemonstrativoGCAP : declaracao.getGCAP().getIds().itens()) {
            String cpf = idDemonstrativoGCAP.getCpf().naoFormatado();
            String dataInicio = idDemonstrativoGCAP.getDataInicioPermanencia().naoFormatado();
            String dataFim = idDemonstrativoGCAP.getDataFimPermanencia().naoFormatado();
            String identificador = dataInicio.substring(0, dataInicio.length() - 4) + dataFim.substring(0, dataFim.length() - 4);
            Consolidacao consolidacao = declaracao.getGCAP().getConsolidacoesBrasil().obterConsolidacaoporID(idDemonstrativoGCAP);
            Consolidacao consolidacaoExterior = declaracao.getGCAP().getConsolidacoesExterior().obterConsolidacaoporID(idDemonstrativoGCAP);
            ValorPositivo pequenoValor = declaracao.getGCAP().obterSomatorioIsentoBemPequenoValorGCAPBrasil(idDemonstrativoGCAP);
            ValorPositivo unicoImovel = declaracao.getGCAP().obterSomatorioIsentoUnicoImovelGCAPBrasil(idDemonstrativoGCAP);
            ValorPositivo reducaoSemPequenoUnico = declaracao.getGCAP().obterSomatorioIsentoSemPequenoSemUnicoGCAPBrasil(idDemonstrativoGCAP);
            ValorPositivo vrPequenoMaisvrUnicoMaisvrReducao = new ValorPositivo();
            vrPequenoMaisvrUnicoMaisvrReducao.append('+', (Valor)pequenoValor);
            vrPequenoMaisvrUnicoMaisvrReducao.append('+', (Valor)unicoImovel);
            vrPequenoMaisvrUnicoMaisvrReducao.append('+', (Valor)reducaoSemPequenoUnico);
            ConsolidacaoEspecie consolidacaoEspecie = declaracao.getGCAP().obterConsolidacaoEspeciePorId(idDemonstrativoGCAP);
            RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "60");
            objRegTXT.fieldByName("NR_REG").set("60");
            objRegTXT.fieldByName("NR_CPF").set(declaracao.getIdentificadorDeclaracao().getCpf().naoFormatado());
            objRegTXT.fieldByName("NR_CPF_BENEFICIARIO").set(cpf);
            objRegTXT.fieldByName("NR_IDENTIFICACAO").set(identificador);
            objRegTXT.fieldByName("DT_INICIO").set(idDemonstrativoGCAP.getDataInicioPermanencia().naoFormatado());
            objRegTXT.fieldByName("DT_FIM").set(idDemonstrativoGCAP.getDataFimPermanencia().naoFormatado());
            objRegTXT.fieldByName("CD_PAIS").set(idDemonstrativoGCAP.getPaisDeclarante().getConteudoAtual(0));
            objRegTXT.fieldByName("NM_PAIS").set(idDemonstrativoGCAP.getPaisDeclarante().getConteudoAtual(2));
            objRegTXT.fieldByName("GC_TRANSP_VR_PEQUENO").set((Valor)pequenoValor);
            objRegTXT.fieldByName("GC_TRANSP_VR_UNICOIMOVEL").set((Valor)unicoImovel);
            objRegTXT.fieldByName("GC_TRANSP_VR_REDUCAO").set((Valor)reducaoSemPequenoUnico);
            objRegTXT.fieldByName("GC_TRANSP_VR_ISENTRIB").set((Valor)vrPequenoMaisvrUnicoMaisvrReducao);
            if (consolidacao != null) {
                objRegTXT.fieldByName("GC_TRANSP_VR_EXCLUSIVO").set((Valor)consolidacao.getTotalRendSujeitosTributacao());
                objRegTXT.fieldByName("GC_TRANSP_VR_IMPOSTOPAGO").set((Valor)consolidacao.getTotalImpostoPago());
                objRegTXT.fieldByName("GC_TRANSP_VR_IMPOSTODEVIDO").set((Valor)consolidacao.getImpostoDevidoAnoAtual());
                objRegTXT.fieldByName("GC_TRANSP_VR_IMPOSTODIFERIDOANOSPOSTERIORES").set((Valor)consolidacao.getImpostoDiferidoAnosPosteriores());
            }
            if (consolidacaoEspecie != null) {
                objRegTXT.fieldByName("GC_GCAP_MOEDA").set((Valor)consolidacaoEspecie.getGanhoCapitalTotal());
                objRegTXT.fieldByName("GC_IMPOSTO_DEVIDO_MOEDA").set((Valor)consolidacaoEspecie.getImpostoDevido());
                objRegTXT.fieldByName("GC_MOEDA_ALIQUOTA_MEDIA").set((Valor)consolidacaoEspecie.getAliquotaMedia());
            }
            if (consolidacaoExterior != null) {
                objRegTXT.fieldByName("GC_TRANSP_VR_EXCLUSIVO_EXTERIOR").set((Valor)consolidacaoExterior.getTotalRendSujeitosTributacao());
                objRegTXT.fieldByName("GC_TRANSP_VR_IMPOSTOPAGO_EXTERIOR").set((Valor)consolidacaoExterior.getTotalImpostoPago());
                objRegTXT.fieldByName("GC_TRANSP_VR_ISENTO_EXTERIOR").set((Valor)consolidacaoExterior.getTotalRendIsentosNaoTributaveis());
            }
            linha.add(objRegTXT);
        }
        return linha;
    }

    public List<RegistroTxt> montarRegistro61(DeclaracaoIRPF declaracao) throws GeracaoTxtException {
        ArrayList<RegistroTxt> linha = new ArrayList<RegistroTxt>();
        for (AlienacaoBemImovel alienacao : declaracao.getGCAP().getBensImoveis().itens()) {
            String cpf = alienacao.getCpf().naoFormatado();
            String dataInicio = alienacao.getDataInicioPermanencia().naoFormatado();
            String dataFim = alienacao.getDataFimPermanencia().naoFormatado();
            String identificador = dataInicio.substring(0, dataInicio.length() - 4) + dataFim.substring(0, dataFim.length() - 4);
            RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "61");
            objRegTXT.fieldByName("NR_REG").set("61");
            objRegTXT.fieldByName("NR_CPF").set(declaracao.getIdentificadorDeclaracao().getCpf().naoFormatado());
            objRegTXT.fieldByName("NR_CPF_BENEFICIARIO").set(cpf);
            objRegTXT.fieldByName("NR_IDENTIFICACAO").set(identificador);
            objRegTXT.fieldByName("NR_OPERACAO").set(alienacao.getCodigoOperacao().naoFormatado());
            objRegTXT.fieldByName("IN_BRASIL_EXTERIOR").set(alienacao.getBemImovel().getBemAdquiridoNoBrasil());
            objRegTXT.fieldByName("NM_IMOVEL_DESCRICAO").set(alienacao.getBemImovel().getEspecificacao().naoFormatado());
            objRegTXT.fieldByName("DT_AQUISICAO").set(alienacao.getBemImovel().getAquisicao().getDataAquisicao().naoFormatado());
            objRegTXT.fieldByName("IN_REFORMA").set(alienacao.getBemImovel().getAquisicao().getHouveReforma().naoFormatado());
            if (alienacao.getBemImovel().isAdquiridoNoBrasil()) {
                objRegTXT.fieldByName("END_TIPO_LOGRADOURO").set(alienacao.getBemImovel().getEndereco().getTipoLogradouro().naoFormatado());
                objRegTXT.fieldByName("END_LOGRADOURO").set(alienacao.getBemImovel().getEndereco().getLogradouro().naoFormatado());
                objRegTXT.fieldByName("END_NUMERO").set(alienacao.getBemImovel().getEndereco().getNumero().naoFormatado());
                objRegTXT.fieldByName("END_COMPLEMENTO").set(alienacao.getBemImovel().getEndereco().getComplemento().naoFormatado());
                objRegTXT.fieldByName("END_BAIRRO").set(alienacao.getBemImovel().getEndereco().getBairro().naoFormatado());
                objRegTXT.fieldByName("END_CEP").set(alienacao.getBemImovel().getEndereco().getCep().naoFormatado());
                objRegTXT.fieldByName("END_CD_MUNICIPIO").set(alienacao.getBemImovel().getEndereco().getMunicipio().getConteudoAtual(0));
                objRegTXT.fieldByName("END_MUNICIPIO").set(alienacao.getBemImovel().getEndereco().getMunicipio().getConteudoAtual(1));
                objRegTXT.fieldByName("END_UF").set(alienacao.getBemImovel().getEndereco().getUf().getConteudoAtual(0));
                objRegTXT.fieldByName("VR_OPERACAO").set((Valor)alienacao.getValorAlienacao());
                objRegTXT.fieldByName("VR_CORRETAGEM").set((Valor)alienacao.getCustoCorretagem());
                objRegTXT.fieldByName("VR_TORNA").set((Valor)alienacao.getBemImovel().getAquisicao().getCustoAquisicaoTorna());
                if (alienacao.getBemImovel().getAquisicao().houveReforma()) {
                    objRegTXT.fieldByName("VR_AQUISICAO").set((Valor)alienacao.getBemImovel().getAquisicao().getParcelasAquisicao().getTotalCustoAquisicao());
                } else {
                    objRegTXT.fieldByName("VR_AQUISICAO").set((Valor)alienacao.getBemImovel().getAquisicao().getCustoAquisicao());
                }
            } else if (alienacao.getBemImovel().isAdquiridoNoExterior()) {
                objRegTXT.fieldByName("END_LOGRADOURO").set(alienacao.getBemImovel().getEndereco().getLogradouroEx().naoFormatado());
                objRegTXT.fieldByName("END_NUMERO").set(alienacao.getBemImovel().getEndereco().getNumeroEx().naoFormatado());
                objRegTXT.fieldByName("END_COMPLEMENTO").set(alienacao.getBemImovel().getEndereco().getComplementoEx().naoFormatado());
                objRegTXT.fieldByName("END_BAIRRO").set(alienacao.getBemImovel().getEndereco().getBairroEx().naoFormatado());
                objRegTXT.fieldByName("END_CEP").set(alienacao.getBemImovel().getEndereco().getCodigoPostalEx().naoFormatado());
                objRegTXT.fieldByName("END_MUNICIPIO").set(alienacao.getBemImovel().getEndereco().getCidadeEx().naoFormatado());
                objRegTXT.fieldByName("END_COD_PAIS").set(alienacao.getBemImovel().getEndereco().getPaisEx().naoFormatado());
                objRegTXT.fieldByName("END_NOME_PAIS").set(alienacao.getBemImovel().getEndereco().getPaisEx().getConteudoAtual(2));
                objRegTXT.fieldByName("VR_OPERACAO").set((Valor)alienacao.getValorAlienacaoReal());
                objRegTXT.fieldByName("VR_CORRETAGEM").set((Valor)alienacao.getValorCorretagemReal());
                objRegTXT.fieldByName("VR_TORNA").set((Valor)alienacao.getBemImovel().getAquisicao().getCustoAquisicaoTornaOrigemMNReal());
                if (alienacao.getBemImovel().getAquisicao().houveReforma()) {
                    objRegTXT.fieldByName("VR_AQUISICAO").set((Valor)alienacao.getBemImovel().getAquisicao().getParcelasAquisicao().getTotalCustoAquisicaoOrigemMNReal());
                } else {
                    objRegTXT.fieldByName("VR_AQUISICAO").set((Valor)alienacao.getBemImovel().getAquisicao().getCustoAquisicaoOrigemNacionalReal());
                }
            }
            if (!alienacao.getBemGrandeValor().isVazio()) {
                objRegTXT.fieldByName("IN_PEQUENO_VALOR").set(alienacao.isBemPequenoValor() ? Logico.SIM : Logico.NAO);
            }
            objRegTXT.fieldByName("IN_PROPR_OUTRO_IMOVEL").set(alienacao.getPerguntas().getPropriedadeOutroImovel().naoFormatado());
            objRegTXT.fieldByName("IN_OUTRA_ALIENACAO").set(alienacao.getPerguntas().getOutraAlienacao().naoFormatado());
            objRegTXT.fieldByName("IN_RESIDENCIAL").set(alienacao.getPerguntas().getImovelResidencial().naoFormatado());
            objRegTXT.fieldByName("IN_UTILIZAZAOOUTROIMOVEL").set(alienacao.getPerguntas().getMP252().naoFormatado());
            objRegTXT.fieldByName("IN_UTILIZACAOOUTROIMOVEL_PARTE2").set(alienacao.getPerguntas().getMP252().naoFormatado());
            objRegTXT.fieldByName("VR_UTILIZAZAOOUTROIMOVEL").set((Valor)alienacao.getValorAplicado());
            objRegTXT.fieldByName("CD_OPERACAO").set(IRPFUtil.formatarZerosEsquerda((String)alienacao.getNatureza().getConteudoAtual(0), (int)2));
            objRegTXT.fieldByName("NM_OPERACAO").set(alienacao.getNatureza().getConteudoAtual(1));
            if (alienacao.isTransmissaoCausaMortis()) {
                String dataTCM = alienacao.getDataVencimentoTCM().naoFormatado();
                if (ConstantesGlobaisIRPF.ULTIMO_DIA_ENTREGA_ORIGINAL.equals(alienacao.getDataVencimentoTCM().formatado())) {
                    dataTCM = TabelaDatasIRPF.obterVencimentosQuotas((boolean)declaracao.getEmCalamidade())[0].replaceAll("/", "");
                }
                objRegTXT.fieldByName("DT_DATA_DARF_TCM").set(dataTCM);
                objRegTXT.fieldByName("IN_DECISAO_JUDICIAL").set(alienacao.getMotivoTransmissaoCausaMortisDecisaoJudicial().naoFormatado());
                if (Logico.SIM.equals(alienacao.getMotivoTransmissaoCausaMortisDecisaoJudicial().naoFormatado())) {
                    objRegTXT.fieldByName("DT_DECISAO_JUDICIAL").set(alienacao.getDataAlienacao().naoFormatado());
                    objRegTXT.fieldByName("DT_TRANSITO_JULGADO").set(alienacao.getDataTransitoJulgado().naoFormatado());
                } else {
                    objRegTXT.fieldByName("DT_LAVRATURA").set(alienacao.getDataAlienacao().naoFormatado());
                }
            } else {
                objRegTXT.fieldByName("DT_ALIENACAO").set(alienacao.getDataAlienacao().naoFormatado());
            }
            objRegTXT.fieldByName("IN_ALIENPRAZO").set(alienacao.getAlienacaoAPrazo().naoFormatado());
            objRegTXT.fieldByName("IN_GCAP_ANTERIOR").set(alienacao.getAlienacaoParcial().naoFormatado());
            objRegTXT.fieldByName("VR_GCAP_ANTERIOR").set((Valor)alienacao.getGanhoCapitalAlienacaoAnterior());
            objRegTXT.fieldByName("VR_OPERACAO_BRUTO_ANT").set((Valor)alienacao.getValorRecebidoAnosAnteriores());
            objRegTXT.fieldByName("VR_CORRETAGEM_ANT").set((Valor)alienacao.getCorretagemAnosAnteriores());
            objRegTXT.fieldByName("VR_GCAP_CI_ANT_LIGUIDO").set((Valor)alienacao.getValorLiquidoRecebidoAnosAnteriores());
            if (alienacao.isAlienacaoAVista()) {
                objRegTXT.fieldByName("VR_GCAP_CI").set((Valor)alienacao.getCalculoImposto().getGanhoCapitalTotal());
                objRegTXT.fieldByName("VR_ALIQUOTA_MEDIA_CI").set(alienacao.getCalculoImposto().getAliquotaMedia().asTxt());
                objRegTXT.fieldByName("VR_IMPOSTO_DEVIDO_CI").set((Valor)alienacao.getCalculoImposto().getImpostoDevido());
                objRegTXT.fieldByName("VR_IMPOSTO_PAGO_CI").set((Valor)alienacao.getCalculoImposto().getImpostoPago());
            } else {
                if (alienacao.getBemImovel().isAdquiridoNoBrasil()) {
                    objRegTXT.fieldByName("VR_GCAP_CI").set((Valor)alienacao.getColecaoParcelaAlienacao().getGanho5ProporcionalTotal());
                } else if (alienacao.getBemImovel().isAdquiridoNoExterior()) {
                    objRegTXT.fieldByName("VR_GCAP_CI").set((Valor)alienacao.getColecaoParcelaAlienacao().getGanhoCapital5ProporcionalRealTotal());
                }
                objRegTXT.fieldByName("VR_ALIQUOTA_MEDIA_CI").set(alienacao.getCalculoImposto().getAliquotaMedia().asTxt());
                objRegTXT.fieldByName("VR_IMPOSTO_DEVIDO_CI").set((Valor)alienacao.getColecaoParcelaAlienacao().getImpostoDevidoTotal());
                objRegTXT.fieldByName("VR_IMPOSTO_PAGO_CI").set((Valor)alienacao.getColecaoParcelaAlienacao().getImpostoPagoTotal());
                objRegTXT.fieldByName("VR_RECEBIDO_CL").set((Valor)alienacao.getColecaoParcelaAlienacao().getValorRecebidoTotal());
                objRegTXT.fieldByName("VR_CORRETAGEM_CL").set((Valor)alienacao.getColecaoParcelaAlienacao().getCustoCorretagemTotal());
                objRegTXT.fieldByName("VR_VALOR_LIQUIDO").set((Valor)alienacao.getColecaoParcelaAlienacao().getValorLiquidoAlienacaoTotal());
                objRegTXT.fieldByName("VR_AQUISICAO_PROPORCIONAL_CL").set((Valor)alienacao.getColecaoParcelaAlienacao().getCustoAquisicaoProporcionalTotal());
            }
            objRegTXT.fieldByName("VR_DIFERIDO_ANTERIORES_CB").set((Valor)alienacao.getConsolidacao().getImpostoDiferidoAnosAnteriores());
            objRegTXT.fieldByName("VR_EXERCICIO_CB").set((Valor)alienacao.getConsolidacao().getImpostoReferenteAlienacaoAnoAtual());
            objRegTXT.fieldByName("VR_TOTAL_CB").set((Valor)alienacao.getConsolidacao().getImpostoTotal());
            objRegTXT.fieldByName("VR_IR_CB").set((Valor)alienacao.getConsolidacao().getValorIRF());
            objRegTXT.fieldByName("VR_IR_DEVIDO_CB").set((Valor)alienacao.getConsolidacao().getImpostoDevidoAnoAtual());
            objRegTXT.fieldByName("VR_DIFERIDO_POSTERIOR_CB").set((Valor)alienacao.getConsolidacao().getImpostoDiferidoAnosPosteriores());
            objRegTXT.fieldByName("VR_IMPOSTO_PAGO_CB").set((Valor)alienacao.getConsolidacao().getTotalImpostoPago());
            objRegTXT.fieldByName("VR_ISENTO_CB").set((Valor)alienacao.getConsolidacao().getTotalRendIsentosNaoTributaveis());
            objRegTXT.fieldByName("VR_EXCLUSIVO_CB").set((Valor)alienacao.getConsolidacao().getTotalRendSujeitosTributacao());
            objRegTXT.fieldByName("DT_DATA_ULTIMA_PARCELA").set(alienacao.getDataRecebimentoUltimaParcela().naoFormatado());
            if (alienacao.isTerritorioParaisoFiscal()) {
                objRegTXT.fieldByName("IND_TER_PARAISO_FISCAL").set(Logico.SIM);
            } else {
                objRegTXT.fieldByName("IND_TER_PARAISO_FISCAL").set(Logico.NAO);
            }
            objRegTXT.fieldByName("CD_PAIS_PARAISO_FISCAL").set(alienacao.getPaisResidencia().naoFormatado());
            linha.add(objRegTXT);
            objRegTXT.fieldByName("IN_MULTIPLO_IMOVEL").set(alienacao.getPerguntas().getMP252PrimeiraAlienacao().naoFormatado());
            objRegTXT.fieldByName("DT_DATA_MULTIPLO_IMOVEL").set(alienacao.getPerguntas().getDataPrimeiraAlienacao().naoFormatado());
        }
        return linha;
    }

    public List<RegistroTxt> montarRegistro62(DeclaracaoIRPF declaracao) throws GeracaoTxtException {
        ArrayList<RegistroTxt> linha = new ArrayList<RegistroTxt>();
        for (AlienacaoBemMovel alienacao : declaracao.getGCAP().getBensMoveis().itens()) {
            String cpf = alienacao.getCpf().naoFormatado();
            String dataInicio = alienacao.getDataInicioPermanencia().naoFormatado();
            String dataFim = alienacao.getDataFimPermanencia().naoFormatado();
            String identificador = dataInicio.substring(0, dataInicio.length() - 4) + dataFim.substring(0, dataFim.length() - 4);
            RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "62");
            objRegTXT.fieldByName("NR_REG").set("62");
            objRegTXT.fieldByName("NR_CPF").set(declaracao.getIdentificadorDeclaracao().getCpf().naoFormatado());
            objRegTXT.fieldByName("NR_CPF_BENEFICIARIO").set(cpf);
            objRegTXT.fieldByName("NR_IDENTIFICACAO").set(identificador);
            objRegTXT.fieldByName("NR_OPERACAO").set(alienacao.getCodigoOperacao().naoFormatado());
            objRegTXT.fieldByName("IN_BRASIL_EXTERIOR").set(alienacao.getBemMovel().getBemAdquiridoNoBrasil());
            objRegTXT.fieldByName("NM_MOVEL_DESCRICAO").set(alienacao.getBemMovel().getEspecificacao().naoFormatado());
            objRegTXT.fieldByName("IN_REGISTRO_PUBLICO").set(alienacao.getBemMovel().getSujeitoRegistroPublico().naoFormatado());
            objRegTXT.fieldByName("DT_AQUISICAO").set(alienacao.getBemMovel().getAquisicao().getDataAquisicao().naoFormatado());
            if (!alienacao.getBemGrandeValor().isVazio()) {
                objRegTXT.fieldByName("IN_PEQUENO_VALOR").set(alienacao.isBemPequenoValor() ? Logico.SIM : Logico.NAO);
            }
            objRegTXT.fieldByName("CD_OPERACAO").set(IRPFUtil.formatarZerosEsquerda((String)alienacao.getNatureza().getConteudoAtual(0), (int)2));
            objRegTXT.fieldByName("NM_OPERACAO").set(alienacao.getNatureza().getConteudoAtual(1));
            if (alienacao.isTransmissaoCausaMortis()) {
                String dataTCM = alienacao.getDataVencimentoTCM().naoFormatado();
                if (ConstantesGlobaisIRPF.ULTIMO_DIA_ENTREGA_ORIGINAL.equals(alienacao.getDataVencimentoTCM().formatado())) {
                    dataTCM = TabelaDatasIRPF.obterVencimentosQuotas((boolean)declaracao.getEmCalamidade())[0].replaceAll("/", "");
                }
                objRegTXT.fieldByName("DT_DATA_DARF_TCM").set(dataTCM);
                objRegTXT.fieldByName("IN_DECISAO_JUDICIAL").set(alienacao.getMotivoTransmissaoCausaMortisDecisaoJudicial().naoFormatado());
                if (Logico.SIM.equals(alienacao.getMotivoTransmissaoCausaMortisDecisaoJudicial().naoFormatado())) {
                    objRegTXT.fieldByName("DT_DECISAO_JUDICIAL").set(alienacao.getDataAlienacao().naoFormatado());
                    objRegTXT.fieldByName("DT_TRANSITO_JULGADO").set(alienacao.getDataTransitoJulgado().naoFormatado());
                } else {
                    objRegTXT.fieldByName("DT_LAVRATURA").set(alienacao.getDataAlienacao().naoFormatado());
                }
            } else {
                objRegTXT.fieldByName("DT_ALIENACAO").set(alienacao.getDataAlienacao().naoFormatado());
            }
            if (alienacao.getBemMovel().isAdquiridoNoBrasil()) {
                objRegTXT.fieldByName("VR_AQUISICAO").set((Valor)alienacao.getBemMovel().getAquisicao().getCustoAquisicao());
                objRegTXT.fieldByName("VR_OPERACAO").set((Valor)alienacao.getValorAlienacao());
                objRegTXT.fieldByName("VR_CORRETAGEM").set((Valor)alienacao.getCustoCorretagem());
            } else if (alienacao.getBemMovel().isAdquiridoNoExterior()) {
                objRegTXT.fieldByName("VR_AQUISICAO").set((Valor)alienacao.getBemMovel().getAquisicao().getCustoAquisicaoOrigemNacionalReal());
                objRegTXT.fieldByName("VR_OPERACAO").set((Valor)alienacao.getValorAlienacaoReal());
                objRegTXT.fieldByName("VR_CORRETAGEM").set((Valor)alienacao.getValorCorretagemReal());
            }
            objRegTXT.fieldByName("IN_ALIENPRAZO").set(alienacao.getAlienacaoAPrazo().naoFormatado());
            objRegTXT.fieldByName("IN_GCAP_ANTERIOR").set(alienacao.getAlienacaoParcial().naoFormatado());
            objRegTXT.fieldByName("VR_GCAP_ANTERIOR").set((Valor)alienacao.getGanhoCapitalAlienacaoAnterior());
            objRegTXT.fieldByName("VR_OPERACAO_BRUTO_ANT").set((Valor)alienacao.getValorRecebidoAnosAnteriores());
            objRegTXT.fieldByName("VR_CORRETAGEM_ANT").set((Valor)alienacao.getCorretagemAnosAnteriores());
            objRegTXT.fieldByName("VR_GCAP_CI_ANT_LIGUIDO").set((Valor)alienacao.getValorLiquidoRecebidoAnosAnteriores());
            if (alienacao.isAlienacaoAVista()) {
                objRegTXT.fieldByName("VR_GCAP_CI").set((Valor)alienacao.getCalculoImposto().getGanhoCapitalTotal());
                objRegTXT.fieldByName("VR_ALIQUOTA_MEDIA_CI").set(alienacao.getCalculoImposto().getAliquotaMedia().asTxt());
                objRegTXT.fieldByName("VR_IMPOSTO_DEVIDO_CI").set((Valor)alienacao.getCalculoImposto().getImpostoDevido());
                objRegTXT.fieldByName("VR_IMPOSTO_PAGO_CI").set((Valor)alienacao.getCalculoImposto().getImpostoPago());
            } else {
                if (alienacao.getBemMovel().isAdquiridoNoBrasil()) {
                    objRegTXT.fieldByName("VR_GCAP_CI").set((Valor)alienacao.getColecaoParcelaAlienacao().getGanho1ProporcionalTotal());
                } else if (alienacao.getBemMovel().isAdquiridoNoExterior()) {
                    objRegTXT.fieldByName("VR_GCAP_CI").set((Valor)alienacao.getColecaoParcelaAlienacao().getGanhoCapital1ProporcionalRealTotal());
                }
                objRegTXT.fieldByName("VR_ALIQUOTA_MEDIA_CI").set(alienacao.getCalculoImposto().getAliquotaMedia().asTxt());
                objRegTXT.fieldByName("VR_IMPOSTO_DEVIDO_CI").set((Valor)alienacao.getColecaoParcelaAlienacao().getImpostoDevidoTotal());
                objRegTXT.fieldByName("VR_IMPOSTO_PAGO_CI").set((Valor)alienacao.getColecaoParcelaAlienacao().getImpostoPagoTotal());
                objRegTXT.fieldByName("VR_RECEBIDO_CL").set((Valor)alienacao.getColecaoParcelaAlienacao().getValorRecebidoTotal());
                objRegTXT.fieldByName("VR_CORRETAGEM_CL").set((Valor)alienacao.getColecaoParcelaAlienacao().getCustoCorretagemTotal());
                objRegTXT.fieldByName("VR_VALOR_LIQUIDO").set((Valor)alienacao.getColecaoParcelaAlienacao().getValorLiquidoAlienacaoTotal());
                objRegTXT.fieldByName("VR_AQUISICAO_PROPORCIONAL_CL").set((Valor)alienacao.getColecaoParcelaAlienacao().getCustoAquisicaoProporcionalTotal());
            }
            objRegTXT.fieldByName("VR_DIFERIDO_ANTERIORES_CB").set((Valor)alienacao.getConsolidacao().getImpostoDiferidoAnosAnteriores());
            objRegTXT.fieldByName("VR_EXERCICIO_CB").set((Valor)alienacao.getConsolidacao().getImpostoReferenteAlienacaoAnoAtual());
            objRegTXT.fieldByName("VR_TOTAL_CB").set((Valor)alienacao.getConsolidacao().getImpostoTotal());
            objRegTXT.fieldByName("VR_IR_CB").set((Valor)alienacao.getConsolidacao().getValorIRF());
            objRegTXT.fieldByName("VR_IR_DEVIDO_CB").set((Valor)alienacao.getConsolidacao().getImpostoDevidoAnoAtual());
            objRegTXT.fieldByName("VR_DIFERIDO_POSTERIOR_CB").set((Valor)alienacao.getConsolidacao().getImpostoDiferidoAnosPosteriores());
            objRegTXT.fieldByName("VR_IMPOSTO_PAGO_CB").set((Valor)alienacao.getConsolidacao().getTotalImpostoPago());
            objRegTXT.fieldByName("VR_ISENTO_CB").set((Valor)alienacao.getConsolidacao().getTotalRendIsentosNaoTributaveis());
            objRegTXT.fieldByName("VR_EXCLUSIVO_CB").set((Valor)alienacao.getConsolidacao().getTotalRendSujeitosTributacao());
            objRegTXT.fieldByName("DT_DATA_ULTIMA_PARCELA").set(alienacao.getDataRecebimentoUltimaParcela().naoFormatado());
            if (alienacao.isTerritorioParaisoFiscal()) {
                objRegTXT.fieldByName("IND_TER_PARAISO_FISCAL").set(Logico.SIM);
            } else {
                objRegTXT.fieldByName("IND_TER_PARAISO_FISCAL").set(Logico.NAO);
            }
            objRegTXT.fieldByName("CD_PAIS_PARAISO_FISCAL").set(alienacao.getPaisResidencia().naoFormatado());
            linha.add(objRegTXT);
        }
        return linha;
    }

    public List<RegistroTxt> montarRegistro63(DeclaracaoIRPF declaracao) throws GeracaoTxtException {
        ArrayList<RegistroTxt> linha = new ArrayList<RegistroTxt>();
        for (AlienacaoParticipacaoSocietaria alienacao : declaracao.getGCAP().getpSocietarias().itens()) {
            String cpf = alienacao.getCpf().naoFormatado();
            String dataInicio = alienacao.getDataInicioPermanencia().naoFormatado();
            String dataFim = alienacao.getDataFimPermanencia().naoFormatado();
            String identificador = dataInicio.substring(0, dataInicio.length() - 4) + dataFim.substring(0, dataFim.length() - 4);
            RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "63");
            objRegTXT.fieldByName("NR_REG").set("63");
            objRegTXT.fieldByName("NR_CPF").set(declaracao.getIdentificadorDeclaracao().getCpf().naoFormatado());
            objRegTXT.fieldByName("NR_CPF_BENEFICIARIO").set(cpf);
            objRegTXT.fieldByName("NR_IDENTIFICACAO").set(identificador);
            objRegTXT.fieldByName("NR_OPERACAO").set(alienacao.getCodigoOperacao().naoFormatado());
            objRegTXT.fieldByName("NM_SOCIEDADE").set(alienacao.getParticipacaoSocietaria().getNome().naoFormatado());
            objRegTXT.fieldByName("NR_CNPJ").set(alienacao.getParticipacaoSocietaria().getCnpj().naoFormatado());
            objRegTXT.fieldByName("CD_MUNICIPIO").set(alienacao.getParticipacaoSocietaria().getMunicipio().getConteudoAtual(0));
            objRegTXT.fieldByName("NM_MUNICIPIO").set(alienacao.getParticipacaoSocietaria().getMunicipio().getConteudoAtual(1));
            objRegTXT.fieldByName("NM_UF").set(alienacao.getParticipacaoSocietaria().getUf().getConteudoAtual(0));
            objRegTXT.fieldByName("CD_OPERACAO").set(IRPFUtil.formatarZerosEsquerda((String)alienacao.getNatureza().getConteudoAtual(0), (int)2));
            objRegTXT.fieldByName("NM_OPERACAO").set(alienacao.getNatureza().getConteudoAtual(1));
            objRegTXT.fieldByName("CD_ESPECIE").set(alienacao.getParticipacaoSocietaria().getEspecie().getConteudoAtual(0));
            objRegTXT.fieldByName("NM_ESPECIE").set(alienacao.getParticipacaoSocietaria().getEspecie().getConteudoAtual(1));
            if (alienacao.isTransmissaoCausaMortis()) {
                String dataTCM = alienacao.getDataVencimentoTCM().naoFormatado();
                if (ConstantesGlobaisIRPF.ULTIMO_DIA_ENTREGA_ORIGINAL.equals(alienacao.getDataVencimentoTCM().formatado())) {
                    dataTCM = TabelaDatasIRPF.obterVencimentosQuotas((boolean)declaracao.getEmCalamidade())[0].replaceAll("/", "");
                }
                objRegTXT.fieldByName("DT_DATA_DARF_TCM").set(dataTCM);
                objRegTXT.fieldByName("IN_DECISAO_JUDICIAL").set(alienacao.getMotivoTransmissaoCausaMortisDecisaoJudicial().naoFormatado());
                if (Logico.SIM.equals(alienacao.getMotivoTransmissaoCausaMortisDecisaoJudicial().naoFormatado())) {
                    objRegTXT.fieldByName("DT_DECISAO_JUDICIAL").set(alienacao.getDataAlienacao().naoFormatado());
                    objRegTXT.fieldByName("DT_TRANSITO_JULGADO").set(alienacao.getDataTransitoJulgado().naoFormatado());
                } else {
                    objRegTXT.fieldByName("DT_LAVRATURA").set(alienacao.getDataAlienacao().naoFormatado());
                }
            } else {
                objRegTXT.fieldByName("DT_ALIENACAO").set(alienacao.getDataAlienacao().naoFormatado());
            }
            objRegTXT.fieldByName("IN_ALIENPRAZO").set(alienacao.getAlienacaoAPrazo().naoFormatado());
            objRegTXT.fieldByName("VR_OPERACAO").set((Valor)alienacao.getValorAlienacao());
            objRegTXT.fieldByName("VR_CORRETAGEM").set((Valor)alienacao.getCustoCorretagem());
            if (!alienacao.getBemGrandeValor().isVazio()) {
                objRegTXT.fieldByName("IN_PEQUENO_VALOR").set(alienacao.isBemPequenoValor() ? Logico.SIM : Logico.NAO);
            }
            objRegTXT.fieldByName("IN_GCAP_ANTERIOR").set(alienacao.getAlienacaoParcial().naoFormatado());
            objRegTXT.fieldByName("VR_GCAP_ANTERIOR").set((Valor)alienacao.getGanhoCapitalAlienacaoAnterior());
            objRegTXT.fieldByName("VR_VALOR_ALIENACAO_AP").set((Valor)alienacao.getApuracao().getValorAlienacao());
            objRegTXT.fieldByName("VR_CUSTO_CORRETAGEM_AP").set((Valor)alienacao.getApuracao().getCustoCorretagem());
            objRegTXT.fieldByName("VR_LIGUIDO_ALIENACAO_AP").set((Valor)alienacao.getApuracao().getValorLiquidoAlienacao());
            objRegTXT.fieldByName("VR_CUSTO_AQUISICAO_AP").set((Valor)alienacao.getApuracao().getCustoAquisicao());
            objRegTXT.fieldByName("VR_GCAP_AP").set((Valor)alienacao.getApuracao().getGanhoCapital1());
            objRegTXT.fieldByName("VR_OPERACAO_BRUTO_ANT").set((Valor)alienacao.getValorRecebidoAnosAnteriores());
            objRegTXT.fieldByName("VR_CORRETAGEM_ANT").set((Valor)alienacao.getCorretagemAnosAnteriores());
            objRegTXT.fieldByName("VR_GCAP_CI_ANT_LIGUIDO").set((Valor)alienacao.getValorLiquidoRecebidoAnosAnteriores());
            if (alienacao.isAlienacaoAVista()) {
                objRegTXT.fieldByName("VR_GCAP_CI").set((Valor)alienacao.getCalculoImposto().getGanhoCapitalTotal());
                objRegTXT.fieldByName("VR_ALIQUOTA_MEDIA_CI").set(alienacao.getCalculoImposto().getAliquotaMedia().asTxt());
                objRegTXT.fieldByName("VR_IMPOSTO_DEVIDO_CI").set((Valor)alienacao.getCalculoImposto().getImpostoDevido());
                objRegTXT.fieldByName("VR_IRRF_CI").set((Valor)alienacao.getCalculoImposto().getIRRFLei110332004());
                objRegTXT.fieldByName("VR_IMPOSTO_DEVIDO_APOS_COMPENSACAO_CI").set((Valor)alienacao.getCalculoImposto().getImpostoDevido2());
                objRegTXT.fieldByName("VR_IMPOSTO_PAGO_CI").set((Valor)alienacao.getCalculoImposto().getImpostoPago());
            } else {
                objRegTXT.fieldByName("VR_GCAP_CI").set((Valor)alienacao.getColecaoParcelaAlienacao().getGanhoProporcionalTotal());
                objRegTXT.fieldByName("VR_ALIQUOTA_MEDIA_CI").set(alienacao.getCalculoImposto().getAliquotaMedia().asTxt());
                objRegTXT.fieldByName("VR_IMPOSTO_DEVIDO_CI").set((Valor)alienacao.getColecaoParcelaAlienacao().getImpostoDevidoTotal());
                objRegTXT.fieldByName("VR_IRRF_CI").set((Valor)alienacao.getColecaoParcelaAlienacao().getIrrfLei110332004Total());
                objRegTXT.fieldByName("VR_IMPOSTO_DEVIDO_APOS_COMPENSACAO_CI").set((Valor)alienacao.getColecaoParcelaAlienacao().getImpostoDevido2Total());
                objRegTXT.fieldByName("VR_IMPOSTO_PAGO_CI").set((Valor)alienacao.getColecaoParcelaAlienacao().getImpostoPagoTotal());
                objRegTXT.fieldByName("VR_RECEBIDO_CL").set((Valor)alienacao.getColecaoParcelaAlienacao().getValorRecebidoTotal());
                objRegTXT.fieldByName("VR_CORRETAGEM_CL").set((Valor)alienacao.getColecaoParcelaAlienacao().getCustoCorretagemTotal());
                objRegTXT.fieldByName("VR_VALOR_LIQUIDO").set((Valor)alienacao.getColecaoParcelaAlienacao().getValorLiquidoAlienacaoTotal());
                objRegTXT.fieldByName("VR_AQUISICAO_PROPORCIONAL_CL").set((Valor)alienacao.getColecaoParcelaAlienacao().getCustoAquisicaoProporcionalTotal());
            }
            objRegTXT.fieldByName("VR_DIFERIDO_ANTERIORES_CB").set((Valor)alienacao.getConsolidacao().getImpostoDiferidoAnosAnteriores());
            objRegTXT.fieldByName("VR_EXERCICIO_CB").set((Valor)alienacao.getConsolidacao().getImpostoReferenteAlienacaoAnoAtual());
            objRegTXT.fieldByName("VR_TOTAL_CB").set((Valor)alienacao.getConsolidacao().getImpostoTotal());
            objRegTXT.fieldByName("VR_IR_CB").set((Valor)alienacao.getConsolidacao().getValorIRF());
            objRegTXT.fieldByName("VR_IR_DEVIDO_CB").set((Valor)alienacao.getConsolidacao().getImpostoDevidoAnoAtual());
            objRegTXT.fieldByName("VR_DIFERIDO_POSTERIOR_CB").set((Valor)alienacao.getConsolidacao().getImpostoDiferidoAnosPosteriores());
            objRegTXT.fieldByName("VR_IMPOSTO_PAGO_CB").set((Valor)alienacao.getConsolidacao().getTotalImpostoPago());
            objRegTXT.fieldByName("VR_ISENTO_CB").set((Valor)alienacao.getConsolidacao().getTotalRendIsentosNaoTributaveis());
            objRegTXT.fieldByName("VR_EXCLUSIVO_CB").set((Valor)alienacao.getConsolidacao().getTotalRendSujeitosTributacao());
            objRegTXT.fieldByName("VR_CUSTO_TOTAL_AQUISICAO").set((Valor)alienacao.getColecaoParcelaAquisicaoParticipacaoSocietaria().getCustoAquisicaoTotal());
            objRegTXT.fieldByName("DT_DATA_ULTIMA_PARCELA").set(alienacao.getDataRecebimentoUltimaParcela().naoFormatado());
            if (alienacao.isTerritorioParaisoFiscal()) {
                objRegTXT.fieldByName("IND_TER_PARAISO_FISCAL").set(Logico.SIM);
            } else {
                objRegTXT.fieldByName("IND_TER_PARAISO_FISCAL").set(Logico.NAO);
            }
            objRegTXT.fieldByName("CD_PAIS_PARAISO_FISCAL").set(alienacao.getPaisResidencia().naoFormatado());
            linha.add(objRegTXT);
        }
        return linha;
    }

    public List<RegistroTxt> montarRegistro64(DeclaracaoIRPF declaracao) throws GeracaoTxtException {
        String msg;
        RegistroTxt objRegTXT;
        String identificador;
        String dataFim;
        String dataInicio;
        String cpf;
        ArrayList<RegistroTxt> linha = new ArrayList<RegistroTxt>();
        for (AlienacaoBemImovel alienacao : declaracao.getGCAP().getBensImoveis().itens()) {
            if (!alienacao.getBemImovel().isAdquiridoNoExterior()) continue;
            cpf = alienacao.getCpf().naoFormatado();
            dataInicio = alienacao.getDataInicioPermanencia().naoFormatado();
            dataFim = alienacao.getDataFimPermanencia().naoFormatado();
            identificador = dataInicio.substring(0, dataInicio.length() - 4) + dataFim.substring(0, dataFim.length() - 4);
            objRegTXT = new RegistroTxt("ARQ_IRPF", "64");
            objRegTXT.fieldByName("NR_REG").set("64");
            objRegTXT.fieldByName("NR_CPF").set(declaracao.getIdentificadorDeclaracao().getCpf().naoFormatado());
            objRegTXT.fieldByName("NR_CPF_BENEFICIARIO").set(cpf);
            objRegTXT.fieldByName("NR_IDENTIFICACAO").set(identificador);
            objRegTXT.fieldByName("NR_OPERACAO").set(alienacao.getCodigoOperacao().naoFormatado());
            objRegTXT.fieldByName("IN_TIPO").set("1");
            objRegTXT.fieldByName("VR_COTACAO_OP").set((Valor)alienacao.getCotacaoDolarDataAlienacao());
            objRegTXT.fieldByName("VR_OPERACAO_DOLAR").set((Valor)alienacao.getValorAlienacaoDolar());
            objRegTXT.fieldByName("VR_CORRETAGEM_DOLAR").set((Valor)alienacao.getValorCorretagemDolar());
            objRegTXT.fieldByName("VR_TORNA_MN_DOLAR").set((Valor)alienacao.getBemImovel().getAquisicao().getCustoAquisicaoTornaOrigemMNDolar());
            objRegTXT.fieldByName("VR_TORNA_ME_DOLAR").set((Valor)alienacao.getBemImovel().getAquisicao().getCustoAquisicaoTornaOrigemMEDolar());
            if ("3".equals(alienacao.getBemImovel().getAquisicao().getOrigemRendimentos().naoFormatado())) {
                objRegTXT.fieldByName("VR_VALOR_ALIENACAO_AP_AMBAS").set((Valor)alienacao.getApuracao().getValorAlienacaoDolar());
                objRegTXT.fieldByName("VR_CUSTO_CORRETAGEM_AP_AMBAS").set((Valor)alienacao.getApuracao().getCustoCorretagemDolar());
                objRegTXT.fieldByName("VR_LIQUIDO_ALIENACAO_AP_AMBAS").set((Valor)alienacao.getApuracao().getValorLiquidoAlienacaoDolar());
                objRegTXT.fieldByName("VR_GCAP_TOTAL_AP_AMBAS").set((Valor)alienacao.getApuracao().getGanhoCapitalTotalExterior());
            }
            objRegTXT.fieldByName("IN_ORIGEM_REND").set(alienacao.getBemImovel().getAquisicao().getOrigemRendimentos().getConteudoAtual(0));
            objRegTXT.fieldByName("NM_ORIGEM_REND_DESC").set(alienacao.getBemImovel().getAquisicao().getOrigemRendimentos().getConteudoAtual(1));
            objRegTXT.fieldByName("VR_COTACAO_AQUISICAO").set((Valor)alienacao.getBemImovel().getAquisicao().getCotacaoDolarDataAquisicao());
            if (alienacao.getBemImovel().getAquisicao().houveReforma()) {
                objRegTXT.fieldByName("VR_BEM_AQUISICAO_DOLAR").set((Valor)alienacao.getBemImovel().getAquisicao().getParcelasAquisicao().getTotalCustoAquisicaoDolar());
                if ("3".equals(alienacao.getBemImovel().getAquisicao().getOrigemRendimentos().naoFormatado())) {
                    objRegTXT.fieldByName("VR_BEM_AQUISICAO_RMN").set((Valor)alienacao.getBemImovel().getAquisicao().getParcelasAquisicao().getTotalCustoAquisicaoOrigemMNDolar());
                    objRegTXT.fieldByName("FT_BEM_AQUISICAO_RMN").set((Valor)alienacao.getBemImovel().getAquisicao().getParcelasAquisicao().getPercentualCustoAquisicaoOrigemNacional());
                    objRegTXT.fieldByName("VR_BEM_AQUISICAO_RME").set((Valor)alienacao.getBemImovel().getAquisicao().getParcelasAquisicao().getTotalCustoAquisicaoOrigemMEDolar());
                    objRegTXT.fieldByName("FT_BEM_AQUISICAO_RME").set((Valor)alienacao.getBemImovel().getAquisicao().getParcelasAquisicao().getPercentualCustoAquisicaoOrigemME());
                }
            } else {
                objRegTXT.fieldByName("VR_BEM_AQUISICAO_DOLAR").set((Valor)alienacao.getBemImovel().getAquisicao().getCustoAquisicaoTotalDolar());
                if ("3".equals(alienacao.getBemImovel().getAquisicao().getOrigemRendimentos().naoFormatado())) {
                    objRegTXT.fieldByName("VR_BEM_AQUISICAO_RMN").set((Valor)alienacao.getBemImovel().getAquisicao().getCustoAquisicaoOrigemNacionalDolar());
                    objRegTXT.fieldByName("FT_BEM_AQUISICAO_RMN").set((Valor)alienacao.getBemImovel().getAquisicao().getPercentualCustoAquisicaoOrigemNacional());
                    objRegTXT.fieldByName("VR_BEM_AQUISICAO_RME").set((Valor)alienacao.getBemImovel().getAquisicao().getCustoAquisicaoOrigemMEDolar());
                    objRegTXT.fieldByName("FT_BEM_AQUISICAO_RME").set((Valor)alienacao.getBemImovel().getAquisicao().getPercentualCustoAquisicaoOrigemME());
                }
            }
            objRegTXT.fieldByName("COD_PAIS_ACORDO").set(alienacao.getPaisAcordo().getConteudoAtual(0));
            objRegTXT.fieldByName("NM_COD_PAIS_ACORDO").set(alienacao.getPaisAcordo().getConteudoAtual(1));
            objRegTXT.fieldByName("VR_IMPOSTO_REAL_ACORDO").set((Valor)alienacao.getValorImpostoExteriorReal());
            if (alienacao.isAlienacaoAPrazo()) {
                objRegTXT.fieldByName("VR_GCAP_TOTAL_AJUSTE").set((Valor)alienacao.getAjuste().getGanhoCapitalTotal());
                objRegTXT.fieldByName("FT_ALIQUOTA_MEDIA_AJUSTE").set(alienacao.getAjuste().getAliquotaMedia().asTxt());
                objRegTXT.fieldByName("VR_IMPOSTO_TOTAL_AJUSTE").set((Valor)alienacao.getAjuste().getImpostoDevido());
                objRegTXT.fieldByName("VR_IMPOSTO_PAGO_COMPENSACAO").set((Valor)alienacao.getAjuste().getImpostoPagoExterior());
                objRegTXT.fieldByName("VR_SALDO_IMPOSTO_DEVIDO").set((Valor)alienacao.getAjuste().getImpostoDevido2());
                objRegTXT.fieldByName("VR_IMPOSTO_PARCELA_AJUSTE").set((Valor)alienacao.getAjuste().getImpostoDevidoNoBrasilRelativoParcelasAnteriores());
                objRegTXT.fieldByName("VR_SALDO_IMPOSTO_AJUSTE").set((Valor)alienacao.getAjuste().getSaldoImpostoDevidoNoBrasil());
                objRegTXT.fieldByName("VR_IMPOSTO_PAGO_AJUSTE").set((Valor)alienacao.getAjuste().getImpostoPago());
            } else {
                objRegTXT.fieldByName("VR_IMPOSTO_PAGO_COMPENSACAO").set((Valor)alienacao.getCalculoImposto().getTotalImpostoPagoExteriorPassivelCompensacao());
                objRegTXT.fieldByName("VR_SALDO_IMPOSTO_DEVIDO").set((Valor)alienacao.getCalculoImposto().getImpostoDevido2());
            }
            objRegTXT.fieldByName("IN_COBRANCA").set(alienacao.getInCobranca().naoFormatado());
            objRegTXT.fieldByName("VR_TOTAL_RECEBIDO_DOLAR").set((Valor)alienacao.getColecaoParcelaAlienacao().getValorRecebidoDolarTotal());
            objRegTXT.fieldByName("VR_TOTAL_CUSTO_CORRETAGEM_DOLAR").set((Valor)alienacao.getColecaoParcelaAlienacao().getCustoCorretagemDolarTotal());
            objRegTXT.fieldByName("VR_TOTAL_LIQUIDO_RECEBIDO_DOLAR").set((Valor)alienacao.getColecaoParcelaAlienacao().getValorLiquidoAlienacaoDolarTotal());
            objRegTXT.fieldByName("VR_TOTAL_LIQUIDO_RECEBIDO_REAL").set((Valor)alienacao.getColecaoParcelaAlienacao().getValorLiquidoAlienacaoRealTotal());
            objRegTXT.fieldByName("VR_TOTAL_AQUISICAO_DOLAR").set((Valor)alienacao.getColecaoParcelaAlienacao().getCustoAquisicaoProporcionalOrigemMEDolarTotal());
            objRegTXT.fieldByName("VR_TOTAL_AQUISICAO_REAL").set((Valor)alienacao.getColecaoParcelaAlienacao().getCustoAquisicaoProporcionalOrigemNacionalRealTotal());
            objRegTXT.fieldByName("VR_TOTAL_AQUISICAO_TORNA_DOLAR").set((Valor)alienacao.getColecaoParcelaAlienacao().getCustoAquisicaoTornaProporcionalOrigemMEDolarTotal());
            objRegTXT.fieldByName("VR_TOTAL_AQUISICAO_TORNA_REAL").set((Valor)alienacao.getColecaoParcelaAlienacao().getCustoAquisicaoTornaProporcionalOrigemNacionalRealTotal());
            objRegTXT.fieldByName("VR_TOTAL_RESULTADO1").set((Valor)alienacao.getColecaoParcelaAlienacao().getGanhoCapital1ProporcionalRealTotal());
            objRegTXT.fieldByName("VR_TOTAL_REDUCAO").set(alienacao.getColecaoParcelaAlienacao().obterTotalSomatorioReducoesMN().operacao('+', (Valor)alienacao.getColecaoParcelaAlienacao().obterTotalSomatorioReducoesME()));
            if ("2".equals(alienacao.getBemImovel().getAquisicao().getOrigemRendimentos().naoFormatado())) {
                objRegTXT.fieldByName("VR_TOTAL_GCAP_DOLAR").set((Valor)alienacao.getColecaoParcelaAlienacao().getGanhoCapital1ProporcionalMEDolarTotal());
            }
            objRegTXT.fieldByName("VR_TOTAL_IR").set((Valor)alienacao.getColecaoParcelaAlienacao().getImpostoDevido2Total());
            objRegTXT.fieldByName("VR_TOTAL_IR_PAGO").set((Valor)alienacao.getColecaoParcelaAlienacao().getImpostoPagoTotal());
            msg = alienacao.obterTextoIsencao().replaceAll("<html>", "").replaceAll("</html>", "").replaceAll("<br>", "");
            objRegTXT.fieldByName("NM_MENSAGEM").set(msg == null ? "" : msg);
            objRegTXT.fieldByName("NM_MOEDA_ESTRANGEIRA").set(alienacao.getAquisicao().getMoedaEstrangeira().getConteudoAtual(1));
            objRegTXT.fieldByName("CD_MOEDA_ESTRANGEIRA").set(alienacao.getAquisicao().getMoedaEstrangeira().getConteudoAtual(0));
            if (alienacao.getAquisicao().getResidenteBrasilAplicacaoExterior().naoFormatado().equals(Logico.SIM)) {
                objRegTXT.fieldByName("IN_RESIDENTE_BRASIL_APLICACAO_EXTERIOR").set(Logico.SIM);
            } else {
                objRegTXT.fieldByName("IN_RESIDENTE_BRASIL_APLICACAO_EXTERIOR").set(Logico.NAO);
            }
            linha.add(objRegTXT);
        }
        for (AlienacaoBemImovel alienacao : declaracao.getGCAP().getBensMoveis().itens()) {
            if (!alienacao.getBemMovel().isAdquiridoNoExterior()) continue;
            cpf = alienacao.getCpf().naoFormatado();
            dataInicio = alienacao.getDataInicioPermanencia().naoFormatado();
            dataFim = alienacao.getDataFimPermanencia().naoFormatado();
            identificador = dataInicio.substring(0, dataInicio.length() - 4) + dataFim.substring(0, dataFim.length() - 4);
            objRegTXT = new RegistroTxt("ARQ_IRPF", "64");
            objRegTXT.fieldByName("NR_REG").set("64");
            objRegTXT.fieldByName("NR_CPF").set(declaracao.getIdentificadorDeclaracao().getCpf().naoFormatado());
            objRegTXT.fieldByName("NR_CPF_BENEFICIARIO").set(cpf);
            objRegTXT.fieldByName("NR_IDENTIFICACAO").set(identificador);
            objRegTXT.fieldByName("NR_OPERACAO").set(alienacao.getCodigoOperacao().naoFormatado());
            objRegTXT.fieldByName("IN_TIPO").set("2");
            objRegTXT.fieldByName("VR_COTACAO_OP").set((Valor)alienacao.getCotacaoDolarDataAlienacao());
            objRegTXT.fieldByName("VR_OPERACAO_DOLAR").set((Valor)alienacao.getValorAlienacaoDolar());
            objRegTXT.fieldByName("VR_CORRETAGEM_DOLAR").set((Valor)alienacao.getValorCorretagemDolar());
            if ("3".equals(alienacao.getBemMovel().getAquisicao().getOrigemRendimentos().naoFormatado())) {
                objRegTXT.fieldByName("VR_VALOR_ALIENACAO_AP_AMBAS").set((Valor)alienacao.getApuracao().getValorAlienacaoDolar());
                objRegTXT.fieldByName("VR_CUSTO_CORRETAGEM_AP_AMBAS").set((Valor)alienacao.getApuracao().getCustoCorretagemDolar());
                objRegTXT.fieldByName("VR_LIQUIDO_ALIENACAO_AP_AMBAS").set((Valor)alienacao.getApuracao().getValorLiquidoAlienacaoDolar());
                objRegTXT.fieldByName("VR_GCAP_TOTAL_AP_AMBAS").set((Valor)alienacao.getApuracao().getGanhoCapitalTotalExterior());
            }
            objRegTXT.fieldByName("IN_ORIGEM_REND").set(alienacao.getAquisicao().getOrigemRendimentos().getConteudoAtual(0));
            objRegTXT.fieldByName("NM_ORIGEM_REND_DESC").set(alienacao.getAquisicao().getOrigemRendimentos().getConteudoAtual(1));
            objRegTXT.fieldByName("VR_COTACAO_AQUISICAO").set((Valor)alienacao.getBemMovel().getAquisicao().getCotacaoDolarDataAquisicao());
            objRegTXT.fieldByName("VR_BEM_AQUISICAO_DOLAR").set((Valor)alienacao.getAquisicao().getCustoAquisicaoTotalDolar());
            objRegTXT.fieldByName("VR_BEM_AQUISICAO_RMN").set((Valor)alienacao.getBemMovel().getAquisicao().getCustoAquisicaoOrigemNacionalDolar());
            objRegTXT.fieldByName("FT_BEM_AQUISICAO_RMN").set((Valor)alienacao.getBemMovel().getAquisicao().getPercentualCustoAquisicaoOrigemNacional());
            objRegTXT.fieldByName("VR_BEM_AQUISICAO_RME").set((Valor)alienacao.getBemMovel().getAquisicao().getCustoAquisicaoOrigemMEDolar());
            objRegTXT.fieldByName("FT_BEM_AQUISICAO_RME").set((Valor)alienacao.getBemMovel().getAquisicao().getPercentualCustoAquisicaoOrigemME());
            objRegTXT.fieldByName("COD_PAIS_ACORDO").set(alienacao.getPaisAcordo().getConteudoAtual(0));
            objRegTXT.fieldByName("NM_COD_PAIS_ACORDO").set(alienacao.getPaisAcordo().getConteudoAtual(1));
            objRegTXT.fieldByName("VR_IMPOSTO_REAL_ACORDO").set((Valor)alienacao.getValorImpostoExteriorReal());
            if (alienacao.isAlienacaoAPrazo()) {
                objRegTXT.fieldByName("VR_GCAP_TOTAL_AJUSTE").set((Valor)alienacao.getAjuste().getGanhoCapitalTotal());
                objRegTXT.fieldByName("FT_ALIQUOTA_MEDIA_AJUSTE").set(alienacao.getAjuste().getAliquotaMedia().asTxt());
                objRegTXT.fieldByName("VR_IMPOSTO_TOTAL_AJUSTE").set((Valor)alienacao.getAjuste().getImpostoDevido());
                objRegTXT.fieldByName("VR_IMPOSTO_PAGO_COMPENSACAO").set((Valor)alienacao.getAjuste().getImpostoPagoExterior());
                objRegTXT.fieldByName("VR_SALDO_IMPOSTO_DEVIDO").set((Valor)alienacao.getAjuste().getImpostoDevido2());
                objRegTXT.fieldByName("VR_IMPOSTO_PARCELA_AJUSTE").set((Valor)alienacao.getAjuste().getImpostoDevidoNoBrasilRelativoParcelasAnteriores());
                objRegTXT.fieldByName("VR_SALDO_IMPOSTO_AJUSTE").set((Valor)alienacao.getAjuste().getSaldoImpostoDevidoNoBrasil());
                objRegTXT.fieldByName("VR_IMPOSTO_PAGO_AJUSTE").set((Valor)alienacao.getAjuste().getImpostoPago());
            } else {
                objRegTXT.fieldByName("VR_IMPOSTO_PAGO_COMPENSACAO").set((Valor)alienacao.getCalculoImposto().getTotalImpostoPagoExteriorPassivelCompensacao());
                objRegTXT.fieldByName("VR_SALDO_IMPOSTO_DEVIDO").set((Valor)alienacao.getCalculoImposto().getImpostoDevido2());
            }
            objRegTXT.fieldByName("IN_COBRANCA").set(alienacao.getInCobranca().naoFormatado());
            objRegTXT.fieldByName("VR_TOTAL_RECEBIDO_DOLAR").set((Valor)alienacao.getColecaoParcelaAlienacao().getValorRecebidoDolarTotal());
            objRegTXT.fieldByName("VR_TOTAL_CUSTO_CORRETAGEM_DOLAR").set((Valor)alienacao.getColecaoParcelaAlienacao().getCustoCorretagemDolarTotal());
            objRegTXT.fieldByName("VR_TOTAL_LIQUIDO_RECEBIDO_DOLAR").set((Valor)alienacao.getColecaoParcelaAlienacao().getValorLiquidoAlienacaoDolarTotal());
            objRegTXT.fieldByName("VR_TOTAL_LIQUIDO_RECEBIDO_REAL").set((Valor)alienacao.getColecaoParcelaAlienacao().getValorLiquidoAlienacaoRealTotal());
            objRegTXT.fieldByName("VR_TOTAL_AQUISICAO_DOLAR").set((Valor)alienacao.getColecaoParcelaAlienacao().getCustoAquisicaoProporcionalOrigemMEDolarTotal());
            objRegTXT.fieldByName("VR_TOTAL_AQUISICAO_REAL").set((Valor)alienacao.getColecaoParcelaAlienacao().getCustoAquisicaoProporcionalOrigemNacionalRealTotal());
            if ("2".equals(alienacao.getBemMovel().getAquisicao().getOrigemRendimentos().naoFormatado())) {
                objRegTXT.fieldByName("VR_TOTAL_GCAP_DOLAR").set((Valor)alienacao.getColecaoParcelaAlienacao().getGanhoCapital1ProporcionalMEDolarTotal());
            }
            objRegTXT.fieldByName("VR_TOTAL_IR").set((Valor)alienacao.getColecaoParcelaAlienacao().getImpostoDevido2Total());
            objRegTXT.fieldByName("VR_TOTAL_IR_PAGO").set((Valor)alienacao.getColecaoParcelaAlienacao().getImpostoPagoTotal());
            msg = alienacao.obterTextoIsencao().replaceAll("<html>", "").replaceAll("</html>", "").replaceAll("<br>", "");
            objRegTXT.fieldByName("NM_MENSAGEM").set(msg == null ? "" : msg);
            objRegTXT.fieldByName("NM_MOEDA_ESTRANGEIRA").set(alienacao.getAquisicao().getMoedaEstrangeira().getConteudoAtual(1));
            objRegTXT.fieldByName("CD_MOEDA_ESTRANGEIRA").set(alienacao.getAquisicao().getMoedaEstrangeira().getConteudoAtual(0));
            if (alienacao.getAquisicao().getResidenteBrasilAplicacaoExterior().naoFormatado().equals(Logico.SIM)) {
                objRegTXT.fieldByName("IN_RESIDENTE_BRASIL_APLICACAO_EXTERIOR").set(Logico.SIM);
            } else {
                objRegTXT.fieldByName("IN_RESIDENTE_BRASIL_APLICACAO_EXTERIOR").set(Logico.NAO);
            }
            linha.add(objRegTXT);
        }
        return linha;
    }

    public List<RegistroTxt> montarRegistro65(DeclaracaoIRPF declaracao) throws GeracaoTxtException {
        RegistroTxt objRegTXT;
        String identificador;
        String dataFim;
        String dataInicio;
        String cpfBeneficiario;
        ArrayList<RegistroTxt> linha = new ArrayList<RegistroTxt>();
        String cpfDeclaracao = declaracao.getIdentificadorDeclaracao().getCpf().naoFormatado();
        for (AlienacaoBemImovel alienacao : declaracao.getGCAP().getBensImoveis().itens()) {
            cpfBeneficiario = alienacao.getCpf().naoFormatado();
            dataInicio = alienacao.getDataInicioPermanencia().naoFormatado();
            dataFim = alienacao.getDataFimPermanencia().naoFormatado();
            identificador = dataInicio.substring(0, dataInicio.length() - 4) + dataFim.substring(0, dataFim.length() - 4);
            for (Adquirente adquirente : alienacao.getBemImovel().getAdquirentes().itens()) {
                objRegTXT = new RegistroTxt("ARQ_IRPF", "65");
                objRegTXT.fieldByName("NR_REG").set("65");
                objRegTXT.fieldByName("NR_CPF").set(cpfDeclaracao);
                objRegTXT.fieldByName("NR_CPF_BENEFICIARIO").set(cpfBeneficiario);
                objRegTXT.fieldByName("NR_IDENTIFICACAO").set(identificador);
                objRegTXT.fieldByName("NR_OPERACAO").set(alienacao.getCodigoOperacao().naoFormatado());
                objRegTXT.fieldByName("IN_TIPO").set("1");
                objRegTXT.fieldByName("NR_CPFCNPJ").set(adquirente.getCpfCnpj().naoFormatado());
                objRegTXT.fieldByName("NR_NOME").set(adquirente.getNome().naoFormatado());
                linha.add(objRegTXT);
            }
        }
        for (AlienacaoBemImovel alienacao : declaracao.getGCAP().getBensMoveis().itens()) {
            cpfBeneficiario = alienacao.getCpf().naoFormatado();
            dataInicio = alienacao.getDataInicioPermanencia().naoFormatado();
            dataFim = alienacao.getDataFimPermanencia().naoFormatado();
            identificador = dataInicio.substring(0, dataInicio.length() - 4) + dataFim.substring(0, dataFim.length() - 4);
            for (Adquirente adquirente : alienacao.getBemMovel().getAdquirentes().itens()) {
                objRegTXT = new RegistroTxt("ARQ_IRPF", "65");
                objRegTXT.fieldByName("NR_REG").set("65");
                objRegTXT.fieldByName("NR_CPF").set(cpfDeclaracao);
                objRegTXT.fieldByName("NR_CPF_BENEFICIARIO").set(cpfBeneficiario);
                objRegTXT.fieldByName("NR_IDENTIFICACAO").set(identificador);
                objRegTXT.fieldByName("NR_OPERACAO").set(alienacao.getCodigoOperacao().naoFormatado());
                objRegTXT.fieldByName("IN_TIPO").set("2");
                objRegTXT.fieldByName("NR_CPFCNPJ").set(adquirente.getCpfCnpj().naoFormatado());
                objRegTXT.fieldByName("NR_NOME").set(adquirente.getNome().naoFormatado());
                linha.add(objRegTXT);
            }
        }
        for (AlienacaoBemImovel alienacao : declaracao.getGCAP().getpSocietarias().itens()) {
            cpfBeneficiario = alienacao.getCpf().naoFormatado();
            dataInicio = alienacao.getDataInicioPermanencia().naoFormatado();
            dataFim = alienacao.getDataFimPermanencia().naoFormatado();
            identificador = dataInicio.substring(0, dataInicio.length() - 4) + dataFim.substring(0, dataFim.length() - 4);
            for (Adquirente adquirente : alienacao.getAdquirentes().itens()) {
                objRegTXT = new RegistroTxt("ARQ_IRPF", "65");
                objRegTXT.fieldByName("NR_REG").set("65");
                objRegTXT.fieldByName("NR_CPF").set(cpfDeclaracao);
                objRegTXT.fieldByName("NR_CPF_BENEFICIARIO").set(cpfBeneficiario);
                objRegTXT.fieldByName("NR_IDENTIFICACAO").set(identificador);
                objRegTXT.fieldByName("NR_OPERACAO").set(alienacao.getCodigoOperacao().naoFormatado());
                objRegTXT.fieldByName("IN_TIPO").set("3");
                objRegTXT.fieldByName("NR_CPFCNPJ").set(adquirente.getCpfCnpj().naoFormatado());
                objRegTXT.fieldByName("NR_NOME").set(adquirente.getNome().naoFormatado());
                linha.add(objRegTXT);
            }
        }
        return linha;
    }

    public List<RegistroTxt> montarRegistro66(DeclaracaoIRPF declaracao) throws GeracaoTxtException {
        ArrayList<RegistroTxt> linha = new ArrayList<RegistroTxt>();
        String cpfDeclaracao = declaracao.getIdentificadorDeclaracao().getCpf().naoFormatado();
        for (AlienacaoBemImovel alienacao : declaracao.getGCAP().getBensImoveis().itens()) {
            if (!alienacao.getBemImovel().isAdquiridoNoBrasil()) continue;
            String cpfBeneficiario = alienacao.getCpf().naoFormatado();
            String dataInicio = alienacao.getDataInicioPermanencia().naoFormatado();
            String dataFim = alienacao.getDataFimPermanencia().naoFormatado();
            String identificador = dataInicio.substring(0, dataInicio.length() - 4) + dataFim.substring(0, dataFim.length() - 4);
            int qtdParcelasAquis = alienacao.getBemImovel().getAquisicao().getParcelasAquisicao().itens().size();
            int qtdParcelasApuracao = alienacao.getApuracao().getParcelasCustoAquisicao().itens().size();
            for (int i = 0; i < qtdParcelasAquis && i < qtdParcelasApuracao; ++i) {
                RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "66");
                ParcelaAquisicao parcela = (ParcelaAquisicao)alienacao.getBemImovel().getAquisicao().getParcelasAquisicao().itens().get(i);
                objRegTXT.fieldByName("NR_REG").set("66");
                objRegTXT.fieldByName("NR_CPF").set(cpfDeclaracao);
                objRegTXT.fieldByName("NR_CPF_BENEFICIARIO").set(cpfBeneficiario);
                objRegTXT.fieldByName("NR_IDENTIFICACAO").set(identificador);
                objRegTXT.fieldByName("NR_OPERACAO").set(alienacao.getCodigoOperacao().naoFormatado());
                objRegTXT.fieldByName("DT_DATA").set(parcela.getData().naoFormatado());
                objRegTXT.fieldByName("VR_VALOR_REAIS").set((Valor)parcela.getCustoAquisicao());
                objRegTXT.fieldByName("VR_PORCENTAGEM_PARCELA").set(parcela.getPercentualCustoTotal().asTxt());
                ParcelaApuracaoCustoAquisicao parcelaApuracao = (ParcelaApuracaoCustoAquisicao)alienacao.getApuracao().getParcelasCustoAquisicao().itens().get(i);
                objRegTXT.fieldByName("DT_DATA").set(parcelaApuracao.getData().naoFormatado());
                objRegTXT.fieldByName("VR_PORCENTAGEM_PARCELA").set(parcelaApuracao.getPercentualCustoTotal().asTxt());
                objRegTXT.fieldByName("VR_VALOR_REDUCAO").set((Valor)parcelaApuracao.getValorPassivelReducao());
                objRegTXT.fieldByName("VR_PORCENTAGEM_RED7713").set(parcelaApuracao.getPercentualReducaoLei7713().asTxt());
                objRegTXT.fieldByName("VR_PORCENTAGEM_REDFR1").set(parcelaApuracao.getPercentualReducaoLei11196FR1().asTxt());
                objRegTXT.fieldByName("VR_PORCENTAGEM_REDFR2").set(parcelaApuracao.getPercentualReducaoLei11196FR2().asTxt());
                linha.add(objRegTXT);
            }
        }
        return linha;
    }

    public List<RegistroTxt> montarRegistro67(DeclaracaoIRPF declaracao) throws GeracaoTxtException {
        ArrayList<RegistroTxt> linha = new ArrayList<RegistroTxt>();
        String cpfDeclaracao = declaracao.getIdentificadorDeclaracao().getCpf().naoFormatado();
        for (AlienacaoBemImovel alienacao : declaracao.getGCAP().getBensImoveis().itens()) {
            if (!alienacao.getBemImovel().isAdquiridoNoExterior()) continue;
            String cpfBeneficiario = alienacao.getCpf().naoFormatado();
            String dataInicio = alienacao.getDataInicioPermanencia().naoFormatado();
            String dataFim = alienacao.getDataFimPermanencia().naoFormatado();
            String identificador = dataInicio.substring(0, dataInicio.length() - 4) + dataFim.substring(0, dataFim.length() - 4);
            int qtdParcelasAquis = alienacao.getBemImovel().getAquisicao().getParcelasAquisicao().itens().size();
            int qtdParcelasApuracao = alienacao.getApuracao().getParcelasCustoAquisicao().itens().size();
            for (int i = 0; i < qtdParcelasAquis && i < qtdParcelasApuracao; ++i) {
                RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "67");
                ParcelaAquisicao parcela = (ParcelaAquisicao)alienacao.getBemImovel().getAquisicao().getParcelasAquisicao().itens().get(i);
                objRegTXT.fieldByName("NR_REG").set("67");
                objRegTXT.fieldByName("NR_CPF").set(cpfDeclaracao);
                objRegTXT.fieldByName("NR_CPF_BENEFICIARIO").set(cpfBeneficiario);
                objRegTXT.fieldByName("NR_IDENTIFICACAO").set(identificador);
                objRegTXT.fieldByName("NR_OPERACAO").set(alienacao.getCodigoOperacao().naoFormatado());
                objRegTXT.fieldByName("DT_DATA").set(parcela.getData().naoFormatado());
                objRegTXT.fieldByName("VR_VALOR_RMN_REAIS").set((Valor)parcela.getCustoAquisicaoOrigemNacionalReal());
                objRegTXT.fieldByName("VR_PORCENTAGEM_PARCELA_RMN").set(parcela.getPercentualCustoTotalReal().asTxt());
                objRegTXT.fieldByName("VR_COTACAO_AMPLIACAO").set((Valor)parcela.getCotacaoDolar());
                objRegTXT.fieldByName("VR_VALOR_RMN_DOLAR").set((Valor)parcela.getCustoAquisicaoOrigemNacionalDolar());
                objRegTXT.fieldByName("VR_VALOR_RME_DOLAR").set((Valor)parcela.getCustoAquisicaoOrigemMEDolar());
                objRegTXT.fieldByName("VR_TOTAL_PARCELA_DOLAR").set((Valor)parcela.getCustoAquisicaoTotalDolar());
                objRegTXT.fieldByName("VR_PORCENTAGEM_PARCELA_RME").set(parcela.getPercentualCustoTotalDolar().asTxt());
                ParcelaApuracaoCustoAquisicao parcelaApuracao = (ParcelaApuracaoCustoAquisicao)alienacao.getApuracao().getParcelasCustoAquisicao().itens().get(i);
                objRegTXT.fieldByName("DT_DATA").set(parcela.getData().naoFormatado());
                objRegTXT.fieldByName("VR_PORCENTAGEM_PARCELA_RMN").set(parcela.getPercentualCustoTotalReal().asTxt());
                objRegTXT.fieldByName("VR_PORCENTAGEM_PARCELA_RME").set(parcela.getPercentualCustoTotalDolar().asTxt());
                objRegTXT.fieldByName("VR_VALOR_REDUCAO_RMN").set((Valor)parcelaApuracao.getValorPassivelReducaoOrigemMN());
                objRegTXT.fieldByName("VR_VALOR_REDUCAO_RME").set((Valor)parcelaApuracao.getValorPassivelReducaoOrigemME());
                objRegTXT.fieldByName("VR_PORCENTAGEM_RED7713").set(parcelaApuracao.getPercentualReducaoLei7713().asTxt());
                objRegTXT.fieldByName("VR_PORCENTAGEM_REDFR1").set(parcelaApuracao.getPercentualReducaoLei11196FR1().asTxt());
                objRegTXT.fieldByName("VR_PORCENTAGEM_REDFR2").set(parcelaApuracao.getPercentualReducaoLei11196FR2().asTxt());
                linha.add(objRegTXT);
            }
        }
        return linha;
    }

    public List<RegistroTxt> montarRegistro68(DeclaracaoIRPF declaracao) throws GeracaoTxtException {
        ArrayList<RegistroTxt> linha = new ArrayList<RegistroTxt>();
        for (AlienacaoBemImovel alienacao : declaracao.getGCAP().getBensImoveis().itens()) {
            String cpf = alienacao.getCpf().naoFormatado();
            String dataInicio = alienacao.getDataInicioPermanencia().naoFormatado();
            String dataFim = alienacao.getDataFimPermanencia().naoFormatado();
            String identificador = dataInicio.substring(0, dataInicio.length() - 4) + dataFim.substring(0, dataFim.length() - 4);
            int tipoApuracao = 0;
            if (alienacao.isAlienacaoBrasil()) {
                tipoApuracao = 1;
            } else if ("1".equals(alienacao.obterCodigoOrigemRendimentos().naoFormatado())) {
                tipoApuracao = 2;
            } else if ("2".equals(alienacao.obterCodigoOrigemRendimentos().naoFormatado())) {
                tipoApuracao = 3;
            } else if ("3".equals(alienacao.obterCodigoOrigemRendimentos().naoFormatado())) {
                tipoApuracao = 4;
            }
            switch (tipoApuracao) {
                case 1: {
                    linha.add(this.obterRegistro68ImovelBrasil(declaracao.getIdentificadorDeclaracao().getCpf().naoFormatado(), cpf, identificador, alienacao, alienacao.getApuracao(), 1));
                    break;
                }
                case 2: {
                    linha.add(this.obterRegistro68ImovelExMN(declaracao.getIdentificadorDeclaracao().getCpf().naoFormatado(), cpf, identificador, alienacao, alienacao.getApuracao(), 2));
                    linha.add(this.obterRegistro68ImovelExMN(declaracao.getIdentificadorDeclaracao().getCpf().naoFormatado(), cpf, identificador, alienacao, alienacao.getApuracaoFinal(), 6));
                    break;
                }
                case 3: {
                    linha.add(this.obterRegistro68ImovelExME(declaracao.getIdentificadorDeclaracao().getCpf().naoFormatado(), cpf, identificador, alienacao, alienacao.getApuracao(), 3));
                    linha.add(this.obterRegistro68ImovelExME(declaracao.getIdentificadorDeclaracao().getCpf().naoFormatado(), cpf, identificador, alienacao, alienacao.getApuracaoFinal(), 7));
                    break;
                }
                case 4: {
                    linha.add(this.obterRegistro68ImovelExMN(declaracao.getIdentificadorDeclaracao().getCpf().naoFormatado(), cpf, identificador, alienacao, alienacao.getApuracao(), 4));
                    linha.add(this.obterRegistro68ImovelExME(declaracao.getIdentificadorDeclaracao().getCpf().naoFormatado(), cpf, identificador, alienacao, alienacao.getApuracao(), 5));
                    if (!alienacao.isAlienacaoAPrazo()) break;
                    linha.add(this.obterRegistro68ImovelExMN(declaracao.getIdentificadorDeclaracao().getCpf().naoFormatado(), cpf, identificador, alienacao, alienacao.getApuracaoFinal(), 8));
                    linha.add(this.obterRegistro68ImovelExME(declaracao.getIdentificadorDeclaracao().getCpf().naoFormatado(), cpf, identificador, alienacao, alienacao.getApuracaoFinal(), 9));
                }
            }
        }
        return linha;
    }

    private RegistroTxt obterRegistro68ImovelBrasil(String cpfIRPF, String cpfGCAP, String identificador, AlienacaoBemImovel alienacao, ApuracaoBemImovel apuracao, int tipoApuracao) throws GeracaoTxtException {
        RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "68");
        objRegTXT.fieldByName("NR_REG").set("68");
        objRegTXT.fieldByName("NR_CPF").set(cpfIRPF);
        objRegTXT.fieldByName("NR_CPF_BENEFICIARIO").set(cpfGCAP);
        objRegTXT.fieldByName("NR_IDENTIFICACAO").set(identificador);
        objRegTXT.fieldByName("NR_OPERACAO").set(alienacao.getCodigoOperacao().naoFormatado());
        objRegTXT.fieldByName("NR_TIPO_APURACAO").set(tipoApuracao);
        objRegTXT.fieldByName("VR_VALOR").set((Valor)apuracao.getValorAlienacao());
        objRegTXT.fieldByName("VR_CORRETAGEM").set((Valor)apuracao.getCustoCorretagem());
        objRegTXT.fieldByName("VR_LIQUIDO_APURACAO").set((Valor)apuracao.getValorLiquidoAlienacao());
        if (alienacao.isPermutaComTorna()) {
            objRegTXT.fieldByName("VR_CUSTO_APURACAO").set((Valor)apuracao.getCustoAquisicaoTorna());
        } else {
            objRegTXT.fieldByName("VR_CUSTO_APURACAO").set((Valor)apuracao.getCustoAquisicao());
        }
        objRegTXT.fieldByName("VR_RESULTADO_1_APURACAO").set((Valor)apuracao.getGanhoCapital1());
        objRegTXT.fieldByName("FT_REDUCAO_LEI7713_APURACAO").set(apuracao.getPercentualReducaoLei7713().asTxt());
        objRegTXT.fieldByName("VR_REDUCAO_LEI7713_APURACAO").set((Valor)apuracao.getValorReducaoLei7713());
        objRegTXT.fieldByName("VR_RESULTADO_2_APURACAO").set((Valor)apuracao.getGanhoCapital2());
        objRegTXT.fieldByName("FT_REDUCAO_LEI11196FR1").set(apuracao.getPercentualReducaoLei11196FR1().asTxt());
        objRegTXT.fieldByName("VR_REDUCAO_LEI11196FR1").set((Valor)apuracao.getValorReducaoLei11196FR1());
        objRegTXT.fieldByName("VR_RESULTADO_3_APURACAO").set((Valor)apuracao.getGanhoCapital3());
        objRegTXT.fieldByName("FT_REDUCAO_LEI11196FR2").set(apuracao.getPercentualReducaoLei11196FR2().asTxt());
        objRegTXT.fieldByName("VR_REDUCAO_LEI11196FR2").set((Valor)apuracao.getValorReducaoLei11196FR2());
        objRegTXT.fieldByName("VR_RESULTADO_4_APURACAO").set((Valor)apuracao.getGanhoCapital4());
        objRegTXT.fieldByName("FT_APLICA_OUTRO_APURACAO").set(apuracao.getPercentualReducaoAplicacaoOutroImovel().asTxt());
        objRegTXT.fieldByName("VR_APLICA_OUTRO_APURACAO").set((Valor)apuracao.getValorReducaoAplicacaoOutroImovel());
        objRegTXT.fieldByName("FT_APLICA_PEQUENO_APURACAO").set(apuracao.getPercentualReducaoBemPequenoValor().asTxt());
        objRegTXT.fieldByName("VR_APLICA_PEQUENO_APURACAO").set((Valor)apuracao.getValorReducaoBemPequenoValor());
        objRegTXT.fieldByName("FT_APLICA_UNICO_APURACAO").set(apuracao.getPercentualReducaoUnicoImovel().asTxt());
        objRegTXT.fieldByName("VR_APLICA_UNICO_APURACAO").set((Valor)apuracao.getValorReducaoUnicoImovel());
        objRegTXT.fieldByName("VR_RESULTADO_5_APURACAO").set((Valor)apuracao.getGanhoCapital5());
        return objRegTXT;
    }

    private RegistroTxt obterRegistro68ImovelExMN(String cpfIRPF, String cpfGCAP, String identificador, AlienacaoBemImovel alienacao, ApuracaoBemImovel apuracao, int tipoApuracao) throws GeracaoTxtException {
        RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "68");
        objRegTXT.fieldByName("NR_REG").set("68");
        objRegTXT.fieldByName("NR_CPF").set(cpfIRPF);
        objRegTXT.fieldByName("NR_CPF_BENEFICIARIO").set(cpfGCAP);
        objRegTXT.fieldByName("NR_IDENTIFICACAO").set(identificador);
        objRegTXT.fieldByName("NR_OPERACAO").set(alienacao.getCodigoOperacao().naoFormatado());
        objRegTXT.fieldByName("NR_TIPO_APURACAO").set(tipoApuracao);
        objRegTXT.fieldByName("VR_VALOR").set((Valor)apuracao.getValorAlienacaoOrigemNacionalDolar());
        objRegTXT.fieldByName("VR_CORRETAGEM").set((Valor)apuracao.getCustoCorretagemOrigemNacionalDolar());
        objRegTXT.fieldByName("VR_LIQUIDO_APURACAO").set((Valor)apuracao.getValorLiquidoAlienacaoOrigemNacionalReal());
        objRegTXT.fieldByName("VR_LIQUIDO_APURACAO_DOLAR").set((Valor)apuracao.getValorLiquidoAlienacaoOrigemNacionalDolar());
        if (alienacao.isPermutaComTorna()) {
            objRegTXT.fieldByName("VR_CUSTO_APURACAO").set((Valor)apuracao.getCustoAquisicaoTornaOrigemMNReal());
        } else {
            objRegTXT.fieldByName("VR_CUSTO_APURACAO").set((Valor)apuracao.getCustoAquisicaoOrigemNacionalReal());
        }
        objRegTXT.fieldByName("VR_RESULTADO_1_APURACAO").set((Valor)apuracao.getGanhoCapital1OrigemNacionalReal());
        objRegTXT.fieldByName("FT_REDUCAO_LEI7713_APURACAO").set(apuracao.getPercentualReducaoLei7713OrigemMN().asTxt());
        objRegTXT.fieldByName("VR_REDUCAO_LEI7713_APURACAO").set((Valor)apuracao.getValorReducaoLei7713OrigemMN());
        objRegTXT.fieldByName("VR_RESULTADO_2_APURACAO").set((Valor)apuracao.getGanhoCapital2OrigemMNReal());
        objRegTXT.fieldByName("FT_REDUCAO_LEI11196FR1").set(apuracao.getPercentualReducaoLei11196FR1OrigemMN().asTxt());
        objRegTXT.fieldByName("VR_REDUCAO_LEI11196FR1").set((Valor)apuracao.getValorReducaoLei11196FR1OrigemMN());
        objRegTXT.fieldByName("VR_RESULTADO_3_APURACAO").set((Valor)apuracao.getGanhoCapital3OrigemMNReal());
        objRegTXT.fieldByName("FT_REDUCAO_LEI11196FR2").set(apuracao.getPercentualReducaoLei11196FR2OrigemMN().asTxt());
        objRegTXT.fieldByName("VR_REDUCAO_LEI11196FR2").set((Valor)apuracao.getValorReducaoLei11196FR2OrigemMN());
        objRegTXT.fieldByName("VR_RESULTADO_4_APURACAO").set((Valor)apuracao.getGanhoCapital4OrigemMNReal());
        objRegTXT.fieldByName("FT_APLICA_OUTRO_APURACAO").set(apuracao.getPercentualReducaoAplicacaoOutroImovelOrigemMN().asTxt());
        objRegTXT.fieldByName("VR_APLICA_OUTRO_APURACAO").set((Valor)apuracao.getValorReducaoAplicacaoOutroImovelOrigemMN());
        objRegTXT.fieldByName("FT_APLICA_PEQUENO_APURACAO").set(apuracao.getPercentualReducaoBemPequenoValorOrigemMN().asTxt());
        objRegTXT.fieldByName("VR_APLICA_PEQUENO_APURACAO").set((Valor)apuracao.getValorReducaoBemPequenoValorOrigemMN());
        objRegTXT.fieldByName("FT_APLICA_UNICO_APURACAO").set(apuracao.getPercentualReducaoUnicoImovelOrigemMN().asTxt());
        objRegTXT.fieldByName("VR_APLICA_UNICO_APURACAO").set((Valor)apuracao.getValorReducaoUnicoImovelOrigemMN());
        objRegTXT.fieldByName("VR_RESULTADO_5_APURACAO").set((Valor)apuracao.getGanhoCapital5OrigemMNReal());
        objRegTXT.fieldByName("VR_COTACAO_APURACAO").set((Valor)apuracao.getCotacaoDolarOrigemNacional());
        return objRegTXT;
    }

    private RegistroTxt obterRegistro68ImovelExME(String cpfIRPF, String cpfGCAP, String identificador, AlienacaoBemImovel alienacao, ApuracaoBemImovel apuracao, int tipoApuracao) throws GeracaoTxtException {
        RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "68");
        objRegTXT.fieldByName("NR_REG").set("68");
        objRegTXT.fieldByName("NR_CPF").set(cpfIRPF);
        objRegTXT.fieldByName("NR_CPF_BENEFICIARIO").set(cpfGCAP);
        objRegTXT.fieldByName("NR_IDENTIFICACAO").set(identificador);
        objRegTXT.fieldByName("NR_OPERACAO").set(alienacao.getCodigoOperacao().naoFormatado());
        objRegTXT.fieldByName("NR_TIPO_APURACAO").set(tipoApuracao);
        objRegTXT.fieldByName("VR_VALOR").set((Valor)apuracao.getValorAlienacaoOrigemMEDolar());
        objRegTXT.fieldByName("VR_CORRETAGEM").set((Valor)apuracao.getCustoCorretagemOrigemMEDolar());
        objRegTXT.fieldByName("VR_LIQUIDO_APURACAO_DOLAR").set((Valor)apuracao.getValorLiquidoAlienacaoOrigemMEDolar());
        if (alienacao.isPermutaComTorna()) {
            objRegTXT.fieldByName("VR_CUSTO_APURACAO").set((Valor)apuracao.getCustoAquisicaoTornaOrigemMEDolar());
        } else {
            objRegTXT.fieldByName("VR_CUSTO_APURACAO").set((Valor)apuracao.getCustoAquisicaoOrigemMEDolar());
        }
        objRegTXT.fieldByName("VR_RESULTADO_1_APURACAO").set((Valor)apuracao.getGanhoCapital1OrigemMEReal());
        objRegTXT.fieldByName("VR_RESULTADO_1_APURACAO_DOLAR").set((Valor)apuracao.getGanhoCapital1OrigemMEDolar());
        objRegTXT.fieldByName("FT_REDUCAO_LEI7713_APURACAO").set(apuracao.getPercentualReducaoLei7713OrigemME().asTxt());
        objRegTXT.fieldByName("VR_REDUCAO_LEI7713_APURACAO").set((Valor)apuracao.getValorReducaoLei7713OrigemME());
        objRegTXT.fieldByName("VR_RESULTADO_2_APURACAO").set((Valor)apuracao.getGanhoCapital2OrigemMEReal());
        objRegTXT.fieldByName("FT_REDUCAO_LEI11196FR1").set(apuracao.getPercentualReducaoLei11196FR1OrigemME().asTxt());
        objRegTXT.fieldByName("VR_REDUCAO_LEI11196FR1").set((Valor)apuracao.getValorReducaoLei11196FR1OrigemME());
        objRegTXT.fieldByName("VR_RESULTADO_3_APURACAO").set((Valor)apuracao.getGanhoCapital3OrigemMEReal());
        objRegTXT.fieldByName("FT_REDUCAO_LEI11196FR2").set(apuracao.getPercentualReducaoLei11196FR2OrigemME().asTxt());
        objRegTXT.fieldByName("VR_REDUCAO_LEI11196FR2").set((Valor)apuracao.getValorReducaoLei11196FR2OrigemME());
        objRegTXT.fieldByName("VR_RESULTADO_4_APURACAO").set((Valor)apuracao.getGanhoCapital4OrigemMEReal());
        objRegTXT.fieldByName("FT_APLICA_OUTRO_APURACAO").set(apuracao.getPercentualReducaoAplicacaoOutroImovelOrigemME().asTxt());
        objRegTXT.fieldByName("VR_APLICA_OUTRO_APURACAO").set((Valor)apuracao.getValorReducaoAplicacaoOutroImovelOrigemME());
        objRegTXT.fieldByName("FT_APLICA_PEQUENO_APURACAO").set(apuracao.getPercentualReducaoBemPequenoValorOrigemME().asTxt());
        objRegTXT.fieldByName("VR_APLICA_PEQUENO_APURACAO").set((Valor)apuracao.getValorReducaoBemPequenoValorOrigemME());
        objRegTXT.fieldByName("FT_APLICA_UNICO_APURACAO").set(apuracao.getPercentualReducaoUnicoImovelOrigemME().asTxt());
        objRegTXT.fieldByName("VR_APLICA_UNICO_APURACAO").set((Valor)apuracao.getValorReducaoUnicoImovelOrigemME());
        objRegTXT.fieldByName("VR_RESULTADO_5_APURACAO").set((Valor)apuracao.getGanhoCapital5OrigemMEReal());
        objRegTXT.fieldByName("VR_COTACAO_APURACAO").set((Valor)apuracao.getCotacaoDolarOrigemME());
        return objRegTXT;
    }

    public List<RegistroTxt> montarRegistro69(DeclaracaoIRPF declaracao) throws GeracaoTxtException {
        ArrayList<RegistroTxt> linha = new ArrayList<RegistroTxt>();
        for (AlienacaoBemMovel alienacao : declaracao.getGCAP().getBensMoveis().itens()) {
            String cpf = alienacao.getCpf().naoFormatado();
            String dataInicio = alienacao.getDataInicioPermanencia().naoFormatado();
            String dataFim = alienacao.getDataFimPermanencia().naoFormatado();
            String identificador = dataInicio.substring(0, dataInicio.length() - 4) + dataFim.substring(0, dataFim.length() - 4);
            int tipoApuracao = 0;
            if (alienacao.isAlienacaoBrasil()) {
                tipoApuracao = 1;
            } else if ("1".equals(alienacao.obterCodigoOrigemRendimentos().naoFormatado())) {
                tipoApuracao = 2;
            } else if ("2".equals(alienacao.obterCodigoOrigemRendimentos().naoFormatado())) {
                tipoApuracao = 3;
            } else if ("3".equals(alienacao.obterCodigoOrigemRendimentos().naoFormatado())) {
                tipoApuracao = 4;
            }
            switch (tipoApuracao) {
                case 1: {
                    linha.add(this.obterRegistro69MovelBrasil(declaracao.getIdentificadorDeclaracao().getCpf().naoFormatado(), cpf, identificador, alienacao, alienacao.getApuracao(), 1));
                    break;
                }
                case 2: {
                    linha.add(this.obterRegistro69MovelExMN(declaracao.getIdentificadorDeclaracao().getCpf().naoFormatado(), cpf, identificador, alienacao, alienacao.getApuracao(), 2));
                    if (!alienacao.isAlienacaoAPrazo()) break;
                    linha.add(this.obterRegistro69MovelExMN(declaracao.getIdentificadorDeclaracao().getCpf().naoFormatado(), cpf, identificador, alienacao, alienacao.getApuracaoFinal(), 6));
                    break;
                }
                case 3: {
                    linha.add(this.obterRegistro69MovelExME(declaracao.getIdentificadorDeclaracao().getCpf().naoFormatado(), cpf, identificador, alienacao, alienacao.getApuracao(), 3));
                    if (!alienacao.isAlienacaoAPrazo()) break;
                    linha.add(this.obterRegistro69MovelExME(declaracao.getIdentificadorDeclaracao().getCpf().naoFormatado(), cpf, identificador, alienacao, alienacao.getApuracaoFinal(), 7));
                    break;
                }
                case 4: {
                    linha.add(this.obterRegistro69MovelExMN(declaracao.getIdentificadorDeclaracao().getCpf().naoFormatado(), cpf, identificador, alienacao, alienacao.getApuracao(), 4));
                    linha.add(this.obterRegistro69MovelExME(declaracao.getIdentificadorDeclaracao().getCpf().naoFormatado(), cpf, identificador, alienacao, alienacao.getApuracao(), 5));
                    if (!alienacao.isAlienacaoAPrazo()) break;
                    linha.add(this.obterRegistro69MovelExMN(declaracao.getIdentificadorDeclaracao().getCpf().naoFormatado(), cpf, identificador, alienacao, alienacao.getApuracaoFinal(), 8));
                    linha.add(this.obterRegistro69MovelExME(declaracao.getIdentificadorDeclaracao().getCpf().naoFormatado(), cpf, identificador, alienacao, alienacao.getApuracaoFinal(), 9));
                }
            }
        }
        return linha;
    }

    private RegistroTxt obterRegistro69MovelBrasil(String cpfIRPF, String cpfGCAP, String identificador, AlienacaoBemMovel alienacao, ApuracaoBemMovel apuracao, int tipoApuracao) throws GeracaoTxtException {
        RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "69");
        objRegTXT.fieldByName("NR_REG").set("69");
        objRegTXT.fieldByName("NR_CPF").set(cpfIRPF);
        objRegTXT.fieldByName("NR_CPF_BENEFICIARIO").set(cpfGCAP);
        objRegTXT.fieldByName("NR_IDENTIFICACAO").set(identificador);
        objRegTXT.fieldByName("NR_OPERACAO").set(alienacao.getCodigoOperacao().naoFormatado());
        objRegTXT.fieldByName("NR_TIPO_APURACAO").set(tipoApuracao);
        objRegTXT.fieldByName("VR_VALOR").set((Valor)apuracao.getValorAlienacao());
        objRegTXT.fieldByName("VR_CORRETAGEM").set((Valor)apuracao.getCustoCorretagem());
        objRegTXT.fieldByName("VR_LIQUIDO_APURACAO").set((Valor)apuracao.getValorLiquidoAlienacao());
        objRegTXT.fieldByName("VR_CUSTO_APURACAO").set((Valor)apuracao.getCustoAquisicao());
        objRegTXT.fieldByName("VR_RESULTADO_1_APURACAO").set((Valor)apuracao.getGanhoCapital1());
        return objRegTXT;
    }

    private RegistroTxt obterRegistro69MovelExMN(String cpfIRPF, String cpfGCAP, String identificador, AlienacaoBemMovel alienacao, ApuracaoBemMovel apuracao, int tipoApuracao) throws GeracaoTxtException {
        RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "69");
        objRegTXT.fieldByName("NR_REG").set("69");
        objRegTXT.fieldByName("NR_CPF").set(cpfIRPF);
        objRegTXT.fieldByName("NR_CPF_BENEFICIARIO").set(cpfGCAP);
        objRegTXT.fieldByName("NR_IDENTIFICACAO").set(identificador);
        objRegTXT.fieldByName("NR_OPERACAO").set(alienacao.getCodigoOperacao().naoFormatado());
        objRegTXT.fieldByName("NR_TIPO_APURACAO").set(tipoApuracao);
        objRegTXT.fieldByName("VR_VALOR").set((Valor)apuracao.getValorAlienacaoOrigemNacionalDolar());
        objRegTXT.fieldByName("VR_CORRETAGEM").set((Valor)apuracao.getCustoCorretagemOrigemNacionalDolar());
        objRegTXT.fieldByName("VR_LIQUIDO_APURACAO").set((Valor)apuracao.getValorLiquidoAlienacaoOrigemNacionalReal());
        objRegTXT.fieldByName("VR_LIQUIDO_APURACAO_DOLAR").set((Valor)apuracao.getValorLiquidoAlienacaoOrigemNacionalDolar());
        objRegTXT.fieldByName("VR_CUSTO_APURACAO").set((Valor)apuracao.getCustoAquisicaoOrigemNacionalReal());
        objRegTXT.fieldByName("VR_RESULTADO_1_APURACAO").set((Valor)apuracao.getGanhoCapital1OrigemNacionalReal());
        objRegTXT.fieldByName("VR_COTACAO_APURACAO").set((Valor)apuracao.getCotacaoDolarOrigemNacional());
        return objRegTXT;
    }

    private RegistroTxt obterRegistro69MovelExME(String cpfIRPF, String cpfGCAP, String identificador, AlienacaoBemMovel alienacao, ApuracaoBemMovel apuracao, int tipoApuracao) throws GeracaoTxtException {
        RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "69");
        objRegTXT.fieldByName("NR_REG").set("69");
        objRegTXT.fieldByName("NR_CPF").set(cpfIRPF);
        objRegTXT.fieldByName("NR_CPF_BENEFICIARIO").set(cpfGCAP);
        objRegTXT.fieldByName("NR_IDENTIFICACAO").set(identificador);
        objRegTXT.fieldByName("NR_OPERACAO").set(alienacao.getCodigoOperacao().naoFormatado());
        objRegTXT.fieldByName("NR_TIPO_APURACAO").set(tipoApuracao);
        objRegTXT.fieldByName("VR_VALOR").set((Valor)apuracao.getValorAlienacaoOrigemMEDolar());
        objRegTXT.fieldByName("VR_CORRETAGEM").set((Valor)apuracao.getCustoCorretagemOrigemMEDolar());
        objRegTXT.fieldByName("VR_LIQUIDO_APURACAO_DOLAR").set((Valor)apuracao.getValorLiquidoAlienacaoOrigemMEDolar());
        objRegTXT.fieldByName("VR_CUSTO_APURACAO").set((Valor)apuracao.getCustoAquisicaoOrigemMEDolar());
        objRegTXT.fieldByName("VR_RESULTADO_1_APURACAO").set((Valor)apuracao.getGanhoCapital1OrigemMEReal());
        objRegTXT.fieldByName("VR_RESULTADO_1_APURACAO_DOLAR").set((Valor)apuracao.getGanhoCapital1OrigemMEDolar());
        objRegTXT.fieldByName("VR_COTACAO_APURACAO").set((Valor)apuracao.getCotacaoDolarOrigemME());
        return objRegTXT;
    }

    public List<RegistroTxt> montarRegistro70(DeclaracaoIRPF declaracao) throws GeracaoTxtException {
        RegistroTxt objRegTXT;
        String identificador;
        String dataFim;
        String dataInicio;
        String cpf;
        ArrayList<RegistroTxt> linha = new ArrayList<RegistroTxt>();
        for (AlienacaoBemImovel alienacao : declaracao.getGCAP().getBensImoveis().itens()) {
            if (!alienacao.getBemImovel().isAdquiridoNoExterior() || !"3".equals(alienacao.obterCodigoOrigemRendimentos().naoFormatado()) || !alienacao.isAlienacaoAPrazo()) continue;
            cpf = alienacao.getCpf().naoFormatado();
            dataInicio = alienacao.getDataInicioPermanencia().naoFormatado();
            dataFim = alienacao.getDataFimPermanencia().naoFormatado();
            identificador = dataInicio.substring(0, dataInicio.length() - 4) + dataFim.substring(0, dataFim.length() - 4);
            for (ParcelaAlienacaoBem parcela : alienacao.getColecaoParcelaAlienacao().itens()) {
                objRegTXT = new RegistroTxt("ARQ_IRPF", "70");
                objRegTXT.fieldByName("NR_REG").set("70");
                objRegTXT.fieldByName("NR_CPF").set(declaracao.getIdentificadorDeclaracao().getCpf().naoFormatado());
                objRegTXT.fieldByName("NR_CPF_BENEFICIARIO").set(cpf);
                objRegTXT.fieldByName("NR_IDENTIFICACAO").set(identificador);
                objRegTXT.fieldByName("NR_OPERACAO").set(alienacao.getCodigoOperacao().naoFormatado());
                objRegTXT.fieldByName("IN_TIPO").set("1");
                objRegTXT.fieldByName("DT_PARCELA").set(parcela.getDataRecebimento().naoFormatado());
                objRegTXT.fieldByName("VR_VALOR").set((Valor)parcela.getValorRecebidoDolar());
                objRegTXT.fieldByName("VR_CORRETAGEM").set((Valor)parcela.getCustoCorretagemDolar());
                objRegTXT.fieldByName("VR_LIQUIDO").set((Valor)parcela.getValorLiquidoAlienacaoDolar());
                objRegTXT.fieldByName("VR_GCAP_TOTAL").set((Valor)parcela.getGanhoCapital5ProporcionalTotalReal());
                objRegTXT.fieldByName("VR_IMPOSTO_DEVIDO_PARCELA").set((Valor)parcela.getImpostoDevido());
                objRegTXT.fieldByName("VR_IMPOSTO_PAGO_COMPENSACAO").set((Valor)parcela.getImpostoPagoExterior());
                objRegTXT.fieldByName("VR_IMPOSTO_DEVIDO_BRASIL").set((Valor)parcela.getImpostoDevido2());
                objRegTXT.fieldByName("VR_IMPOSTO_PAGO_PARCELA_BRASIL").set((Valor)parcela.getImpostoPago());
                objRegTXT.fieldByName("VR_APLICA_OUTRO_INFORMADO_PARCELA").set((Valor)parcela.getValorInformadoReducaoAplicacaoOutroImovelAmbas());
                objRegTXT.fieldByName("VR_TOTAL_REDUCAO").set((Valor)parcela.obterSomatorioReducoesAM());
                linha.add(objRegTXT);
            }
        }
        for (AlienacaoBemImovel alienacao : declaracao.getGCAP().getBensMoveis().itens()) {
            if (!alienacao.getBemMovel().isAdquiridoNoExterior() || !"3".equals(alienacao.obterCodigoOrigemRendimentos().naoFormatado())) continue;
            cpf = alienacao.getCpf().naoFormatado();
            dataInicio = alienacao.getDataInicioPermanencia().naoFormatado();
            dataFim = alienacao.getDataFimPermanencia().naoFormatado();
            identificador = dataInicio.substring(0, dataInicio.length() - 4) + dataFim.substring(0, dataFim.length() - 4);
            for (ParcelaAlienacaoBem parcela : alienacao.getColecaoParcelaAlienacao().itens()) {
                objRegTXT = new RegistroTxt("ARQ_IRPF", "70");
                objRegTXT.fieldByName("NR_REG").set("70");
                objRegTXT.fieldByName("NR_CPF").set(declaracao.getIdentificadorDeclaracao().getCpf().naoFormatado());
                objRegTXT.fieldByName("NR_CPF_BENEFICIARIO").set(cpf);
                objRegTXT.fieldByName("NR_IDENTIFICACAO").set(identificador);
                objRegTXT.fieldByName("NR_OPERACAO").set(alienacao.getCodigoOperacao().naoFormatado());
                objRegTXT.fieldByName("IN_TIPO").set("2");
                objRegTXT.fieldByName("DT_PARCELA").set(parcela.getDataRecebimento().naoFormatado());
                objRegTXT.fieldByName("VR_VALOR").set((Valor)parcela.getValorRecebidoDolar());
                objRegTXT.fieldByName("VR_CORRETAGEM").set((Valor)parcela.getCustoCorretagemDolar());
                objRegTXT.fieldByName("VR_LIQUIDO").set((Valor)parcela.getValorLiquidoAlienacaoDolar());
                objRegTXT.fieldByName("VR_GCAP_TOTAL").set((Valor)parcela.getGanhoCapital1ProporcionalTotalReal());
                objRegTXT.fieldByName("VR_IMPOSTO_DEVIDO_PARCELA").set((Valor)parcela.getImpostoDevido());
                objRegTXT.fieldByName("VR_IMPOSTO_PAGO_COMPENSACAO").set((Valor)parcela.getImpostoPagoExterior());
                objRegTXT.fieldByName("VR_IMPOSTO_DEVIDO_BRASIL").set((Valor)parcela.getImpostoDevido2());
                objRegTXT.fieldByName("VR_IMPOSTO_PAGO_PARCELA_BRASIL").set((Valor)parcela.getImpostoPago());
                linha.add(objRegTXT);
            }
        }
        return linha;
    }

    public List<RegistroTxt> montarRegistro71(DeclaracaoIRPF declaracao) throws GeracaoTxtException {
        ArrayList<RegistroTxt> linha = new ArrayList<RegistroTxt>();
        block6: for (AlienacaoBemImovel alienacao : declaracao.getGCAP().getBensImoveis().itens()) {
            String cpf = alienacao.getCpf().naoFormatado();
            String dataInicio = alienacao.getDataInicioPermanencia().naoFormatado();
            String dataFim = alienacao.getDataFimPermanencia().naoFormatado();
            String identificador = dataInicio.substring(0, dataInicio.length() - 4) + dataFim.substring(0, dataFim.length() - 4);
            int tipoApuracao = 0;
            if (alienacao.isAlienacaoBrasil()) {
                tipoApuracao = 1;
            } else if ("1".equals(alienacao.obterCodigoOrigemRendimentos().naoFormatado())) {
                tipoApuracao = 2;
            } else if ("2".equals(alienacao.obterCodigoOrigemRendimentos().naoFormatado())) {
                tipoApuracao = 3;
            } else if ("3".equals(alienacao.obterCodigoOrigemRendimentos().naoFormatado())) {
                tipoApuracao = 4;
            }
            switch (tipoApuracao) {
                case 1: {
                    for (ParcelaAlienacaoBem parcela : alienacao.getColecaoParcelaAlienacao().itens()) {
                        linha.add(this.obterRegistro71ImovelBrasil(declaracao.getIdentificadorDeclaracao().getCpf().naoFormatado(), cpf, identificador, alienacao, parcela, "1"));
                    }
                    continue block6;
                }
                case 2: {
                    for (ParcelaAlienacaoBem parcela : alienacao.getColecaoParcelaAlienacao().itens()) {
                        linha.add(this.obterRegistro71ImovelExMN(declaracao.getIdentificadorDeclaracao().getCpf().naoFormatado(), cpf, identificador, alienacao, parcela, "2"));
                    }
                    continue block6;
                }
                case 3: {
                    for (ParcelaAlienacaoBem parcela : alienacao.getColecaoParcelaAlienacao().itens()) {
                        linha.add(this.obterRegistro71ImovelExME(declaracao.getIdentificadorDeclaracao().getCpf().naoFormatado(), cpf, identificador, alienacao, parcela, "3"));
                    }
                    continue block6;
                }
                case 4: {
                    for (ParcelaAlienacaoBem parcela : alienacao.getColecaoParcelaAlienacao().itens()) {
                        linha.add(this.obterRegistro71ImovelExMN(declaracao.getIdentificadorDeclaracao().getCpf().naoFormatado(), cpf, identificador, alienacao, parcela, "4"));
                        linha.add(this.obterRegistro71ImovelExME(declaracao.getIdentificadorDeclaracao().getCpf().naoFormatado(), cpf, identificador, alienacao, parcela, "5"));
                    }
                    break;
                }
            }
        }
        return linha;
    }

    private RegistroTxt obterRegistro71ImovelBrasil(String cpfIRPF, String cpfGCAP, String identificador, AlienacaoBemImovel alienacao, ParcelaAlienacaoBem parcela, String tipoParcela) throws GeracaoTxtException {
        RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "71");
        objRegTXT.fieldByName("NR_REG").set("71");
        objRegTXT.fieldByName("NR_CPF").set(cpfIRPF);
        objRegTXT.fieldByName("NR_CPF_BENEFICIARIO").set(cpfGCAP);
        objRegTXT.fieldByName("NR_IDENTIFICACAO").set(identificador);
        objRegTXT.fieldByName("NR_OPERACAO").set(alienacao.getCodigoOperacao().naoFormatado());
        objRegTXT.fieldByName("NR_TIPO_PARCELA").set(tipoParcela);
        objRegTXT.fieldByName("IN_ULTIMA_PARCELA").set(parcela.isUltimaParcela() ? "1" : "0");
        objRegTXT.fieldByName("DT_PARCELA").set(parcela.getDataRecebimento().naoFormatado());
        objRegTXT.fieldByName("VR_LIQUIDO_PARCELA").set((Valor)parcela.getValorLiquidoAlienacao());
        if (alienacao.isPermutaComTorna()) {
            objRegTXT.fieldByName("VR_CUSTO_PARCELA").set((Valor)parcela.getCustoAquisicaoTornaProporcional());
        } else {
            objRegTXT.fieldByName("VR_CUSTO_PARCELA").set((Valor)parcela.getCustoAquisicaoProporcional());
        }
        objRegTXT.fieldByName("VR_RESULTADO_1_PARCELA").set((Valor)parcela.getGanhoCapital1Proporcional());
        objRegTXT.fieldByName("FT_REDUCAO_LEI7713_PARCELA").set(parcela.getPercentualReducaoLei7713().asTxt());
        objRegTXT.fieldByName("VR_REDUCAO_LEI7713_PARCELA").set((Valor)parcela.getValorReducaoLei7713());
        objRegTXT.fieldByName("VR_RESULTADO_2_PARCELA").set((Valor)parcela.getGanhoCapital2Proporcional());
        objRegTXT.fieldByName("FT_REDUCAO_LEI11196FR1").set(parcela.getPercentualReducaoLei11196FR1().asTxt());
        objRegTXT.fieldByName("VR_REDUCAO_LEI11196FR1").set((Valor)parcela.getValorReducaoLei11196FR1());
        objRegTXT.fieldByName("VR_RESULTADO_3_PARCELA").set((Valor)parcela.getGanhoCapital3Proporcional());
        objRegTXT.fieldByName("FT_REDUCAO_LEI11196FR2").set(parcela.getPercentualReducaoLei11196FR2().asTxt());
        objRegTXT.fieldByName("VR_REDUCAO_LEI11196FR2").set((Valor)parcela.getValorReducaoLei11196FR2());
        objRegTXT.fieldByName("VR_RESULTADO_4_PARCELA").set((Valor)parcela.getGanhoCapital4Proporcional());
        objRegTXT.fieldByName("VR_APLICA_OUTRO_INFORMADO_PARCELA").set((Valor)parcela.getValorInformadoReducaoAplicacaoOutroImovel());
        objRegTXT.fieldByName("FT_APLICA_OUTRO_PARCELA").set(parcela.getPercentualReducaoAplicacaoOutroImovel().asTxt());
        objRegTXT.fieldByName("VR_APLICA_OUTRO_PARCELA").set((Valor)parcela.getValorReducaoAplicacaoOutroImovel());
        objRegTXT.fieldByName("FT_APLICA_PEQUENO_PARCELA").set(parcela.getPercentualReducaoBemPequenoValor().asTxt());
        objRegTXT.fieldByName("VR_APLICA_PEQUENO_PARCELA").set((Valor)parcela.getValorReducaoBemPequenoValor());
        objRegTXT.fieldByName("FT_APLICA_UNICO_PARCELA").set(parcela.getPercentualReducaoUnicoImovel().asTxt());
        objRegTXT.fieldByName("VR_APLICA_UNICO_PARCELA").set((Valor)parcela.getValorReducaoUnicoImovel());
        objRegTXT.fieldByName("VR_RESULTADO_5_PARCELA").set((Valor)parcela.getGanhoCapital5Proporcional());
        objRegTXT.fieldByName("VR_TOTAL_REDUCAO").set((Valor)parcela.obterSomatorioReducoes());
        objRegTXT.fieldByName("VR_ALIQUOTA_MEDIA_PARCELA").set(parcela.getAliquotaMedia().asTxt());
        objRegTXT.fieldByName("VR_VALOR").set((Valor)parcela.getValorRecebido());
        objRegTXT.fieldByName("VR_CORRETAGEM").set((Valor)parcela.getCustoCorretagem());
        objRegTXT.fieldByName("VR_IMPOSTO_DEVIDO_PARCELA").set((Valor)parcela.getImpostoDevido());
        objRegTXT.fieldByName("VR_IMPOSTO_PAGO_COMPENSACAO").set((Valor)parcela.getImpostoPagoExterior());
        objRegTXT.fieldByName("VR_IMPOSTO_DEVIDO_BRASIL").set((Valor)parcela.getImpostoDevido2());
        objRegTXT.fieldByName("VR_IMPOSTO_PAGO_PARCELA_BRASIL").set((Valor)parcela.getImpostoPago());
        return objRegTXT;
    }

    private RegistroTxt obterRegistro71ImovelExMN(String cpfIRPF, String cpfGCAP, String identificador, AlienacaoBemImovel alienacao, ParcelaAlienacaoBem parcela, String tipoParcela) throws GeracaoTxtException {
        RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "71");
        objRegTXT.fieldByName("NR_REG").set("71");
        objRegTXT.fieldByName("NR_CPF").set(cpfIRPF);
        objRegTXT.fieldByName("NR_CPF_BENEFICIARIO").set(cpfGCAP);
        objRegTXT.fieldByName("NR_IDENTIFICACAO").set(identificador);
        objRegTXT.fieldByName("NR_OPERACAO").set(alienacao.getCodigoOperacao().naoFormatado());
        objRegTXT.fieldByName("NR_TIPO_PARCELA").set(tipoParcela);
        objRegTXT.fieldByName("IN_ULTIMA_PARCELA").set(parcela.isUltimaParcela() ? "1" : "0");
        objRegTXT.fieldByName("DT_PARCELA").set(parcela.getDataRecebimento().naoFormatado());
        if ("4".equals(tipoParcela)) {
            objRegTXT.fieldByName("VR_LIQUIDO_PARCELA").set((Valor)parcela.getValorAlienacaoOrigemNacionalReal());
            objRegTXT.fieldByName("VR_LIQUIDO_PARCELA_DOLAR").set((Valor)parcela.getValorAlienacaoOrigemNacionalDolar());
        } else if ("2".equals(tipoParcela)) {
            objRegTXT.fieldByName("VR_LIQUIDO_PARCELA").set((Valor)parcela.getValorLiquidoAlienacaoReal());
            objRegTXT.fieldByName("VR_LIQUIDO_PARCELA_DOLAR").set((Valor)parcela.getValorLiquidoAlienacaoDolar());
            objRegTXT.fieldByName("VR_APLICA_OUTRO_INFORMADO_PARCELA").set((Valor)parcela.getValorInformadoReducaoAplicacaoOutroImovelMN());
            objRegTXT.fieldByName("VR_VALOR").set((Valor)parcela.getValorRecebidoDolar());
            objRegTXT.fieldByName("VR_CORRETAGEM").set((Valor)parcela.getCustoCorretagemDolar());
            objRegTXT.fieldByName("VR_IMPOSTO_DEVIDO_PARCELA").set((Valor)parcela.getImpostoDevido());
            objRegTXT.fieldByName("VR_IMPOSTO_PAGO_COMPENSACAO").set((Valor)parcela.getImpostoPagoExterior());
            objRegTXT.fieldByName("VR_IMPOSTO_DEVIDO_BRASIL").set((Valor)parcela.getImpostoDevido2());
            objRegTXT.fieldByName("VR_IMPOSTO_PAGO_PARCELA_BRASIL").set((Valor)parcela.getImpostoPago());
            objRegTXT.fieldByName("VR_TOTAL_REDUCAO").set((Valor)parcela.obterSomatorioReducoesMN());
        }
        if (alienacao.isPermutaComTorna()) {
            objRegTXT.fieldByName("VR_CUSTO_PARCELA").set((Valor)parcela.getCustoAquisicaoTornaProporcionalOrigemNacionalReal());
        } else {
            objRegTXT.fieldByName("VR_CUSTO_PARCELA").set((Valor)parcela.getCustoAquisicaoProporcionalOrigemNacionalReal());
        }
        objRegTXT.fieldByName("VR_RESULTADO_1_PARCELA").set((Valor)parcela.getGanhoCapital1ProporcionalOrigemNacionalReal());
        objRegTXT.fieldByName("FT_REDUCAO_LEI7713_PARCELA").set(parcela.getPercentualReducaoLei7713MN().asTxt());
        objRegTXT.fieldByName("VR_REDUCAO_LEI7713_PARCELA").set((Valor)parcela.getValorReducaoLei7713MN());
        objRegTXT.fieldByName("VR_RESULTADO_2_PARCELA").set((Valor)parcela.getGanhoCapital2ProporcionalMN());
        objRegTXT.fieldByName("FT_REDUCAO_LEI11196FR1").set(parcela.getPercentualReducaoLei11196FR1MN().asTxt());
        objRegTXT.fieldByName("VR_REDUCAO_LEI11196FR1").set((Valor)parcela.getValorReducaoLei11196FR1MN());
        objRegTXT.fieldByName("VR_RESULTADO_3_PARCELA").set((Valor)parcela.getGanhoCapital3ProporcionalMN());
        objRegTXT.fieldByName("FT_REDUCAO_LEI11196FR2").set(parcela.getPercentualReducaoLei11196FR2MN().asTxt());
        objRegTXT.fieldByName("VR_REDUCAO_LEI11196FR2").set((Valor)parcela.getValorReducaoLei11196FR2MN());
        objRegTXT.fieldByName("VR_RESULTADO_4_PARCELA").set((Valor)parcela.getGanhoCapital4ProporcionalMN());
        objRegTXT.fieldByName("FT_APLICA_OUTRO_PARCELA").set(parcela.getPercentualReducaoAplicacaoOutroImovelMN().asTxt());
        objRegTXT.fieldByName("VR_APLICA_OUTRO_PARCELA").set((Valor)parcela.getValorReducaoAplicacaoOutroImovelMN());
        objRegTXT.fieldByName("FT_APLICA_PEQUENO_PARCELA").set(parcela.getPercentualReducaoBemPequenoValorMN().asTxt());
        objRegTXT.fieldByName("VR_APLICA_PEQUENO_PARCELA").set((Valor)parcela.getValorReducaoBemPequenoValorMN());
        objRegTXT.fieldByName("FT_APLICA_UNICO_PARCELA").set(parcela.getPercentualReducaoUnicoImovelMN().asTxt());
        objRegTXT.fieldByName("VR_APLICA_UNICO_PARCELA").set((Valor)parcela.getValorReducaoUnicoImovelMN());
        objRegTXT.fieldByName("VR_RESULTADO_5_PARCELA").set((Valor)parcela.getGanhoCapital5ProporcionalMN());
        objRegTXT.fieldByName("VR_ALIQUOTA_MEDIA_PARCELA").set(parcela.getAliquotaMedia().asTxt());
        objRegTXT.fieldByName("VR_COTACAO_PARCELA").set((Valor)parcela.getCotacaoDolar());
        return objRegTXT;
    }

    private RegistroTxt obterRegistro71ImovelExME(String cpfIRPF, String cpfGCAP, String identificador, AlienacaoBemImovel alienacao, ParcelaAlienacaoBem parcela, String tipoParcela) throws GeracaoTxtException {
        RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "71");
        objRegTXT.fieldByName("NR_REG").set("71");
        objRegTXT.fieldByName("NR_CPF").set(cpfIRPF);
        objRegTXT.fieldByName("NR_CPF_BENEFICIARIO").set(cpfGCAP);
        objRegTXT.fieldByName("NR_IDENTIFICACAO").set(identificador);
        objRegTXT.fieldByName("NR_OPERACAO").set(alienacao.getCodigoOperacao().naoFormatado());
        objRegTXT.fieldByName("NR_TIPO_PARCELA").set(tipoParcela);
        objRegTXT.fieldByName("IN_ULTIMA_PARCELA").set(parcela.isUltimaParcela() ? "1" : "0");
        objRegTXT.fieldByName("DT_PARCELA").set(parcela.getDataRecebimento().naoFormatado());
        if ("5".equals(tipoParcela)) {
            objRegTXT.fieldByName("VR_LIQUIDO_PARCELA_DOLAR").set((Valor)parcela.getValorAlienacaoOrigemMEDolar());
        } else if ("3".equals(tipoParcela)) {
            objRegTXT.fieldByName("VR_LIQUIDO_PARCELA_DOLAR").set((Valor)parcela.getValorLiquidoAlienacaoDolar());
            objRegTXT.fieldByName("VR_APLICA_OUTRO_INFORMADO_PARCELA").set((Valor)parcela.getValorInformadoReducaoAplicacaoOutroImovelME());
            objRegTXT.fieldByName("VR_VALOR").set((Valor)parcela.getValorRecebidoDolar());
            objRegTXT.fieldByName("VR_CORRETAGEM").set((Valor)parcela.getCustoCorretagemDolar());
            objRegTXT.fieldByName("VR_IMPOSTO_DEVIDO_PARCELA").set((Valor)parcela.getImpostoDevido());
            objRegTXT.fieldByName("VR_IMPOSTO_PAGO_COMPENSACAO").set((Valor)parcela.getImpostoPagoExterior());
            objRegTXT.fieldByName("VR_IMPOSTO_DEVIDO_BRASIL").set((Valor)parcela.getImpostoDevido2());
            objRegTXT.fieldByName("VR_IMPOSTO_PAGO_PARCELA_BRASIL").set((Valor)parcela.getImpostoPago());
            objRegTXT.fieldByName("VR_TOTAL_REDUCAO").set((Valor)parcela.obterSomatorioReducoesME());
        }
        if (alienacao.isPermutaComTorna()) {
            objRegTXT.fieldByName("VR_CUSTO_PARCELA").set((Valor)parcela.getCustoAquisicaoTornaProporcionalOrigemMEDolar());
        } else {
            objRegTXT.fieldByName("VR_CUSTO_PARCELA").set((Valor)parcela.getCustoAquisicaoProporcionalOrigemMEDolar());
        }
        objRegTXT.fieldByName("VR_RESULTADO_1_PARCELA").set((Valor)parcela.getGanhoCapital1ProporcionalOrigemMEReal());
        objRegTXT.fieldByName("VR_RESULTADO_1_PARCELA_DOLAR").set((Valor)parcela.getGanhoCapital1ProporcionalOrigemMEDolar());
        objRegTXT.fieldByName("FT_REDUCAO_LEI7713_PARCELA").set(parcela.getPercentualReducaoLei7713ME().asTxt());
        objRegTXT.fieldByName("VR_REDUCAO_LEI7713_PARCELA").set((Valor)parcela.getValorReducaoLei7713ME());
        objRegTXT.fieldByName("VR_RESULTADO_2_PARCELA").set((Valor)parcela.getGanhoCapital2ProporcionalME());
        objRegTXT.fieldByName("FT_REDUCAO_LEI11196FR1").set(parcela.getPercentualReducaoLei11196FR1ME().asTxt());
        objRegTXT.fieldByName("VR_REDUCAO_LEI11196FR1").set((Valor)parcela.getValorReducaoLei11196FR1ME());
        objRegTXT.fieldByName("VR_RESULTADO_3_PARCELA").set((Valor)parcela.getGanhoCapital3ProporcionalME());
        objRegTXT.fieldByName("FT_REDUCAO_LEI11196FR2").set(parcela.getPercentualReducaoLei11196FR2ME().asTxt());
        objRegTXT.fieldByName("VR_REDUCAO_LEI11196FR2").set((Valor)parcela.getValorReducaoLei11196FR2ME());
        objRegTXT.fieldByName("VR_RESULTADO_4_PARCELA").set((Valor)parcela.getGanhoCapital4ProporcionalME());
        objRegTXT.fieldByName("FT_APLICA_OUTRO_PARCELA").set(parcela.getPercentualReducaoAplicacaoOutroImovelME().asTxt());
        objRegTXT.fieldByName("VR_APLICA_OUTRO_PARCELA").set((Valor)parcela.getValorReducaoAplicacaoOutroImovelME());
        objRegTXT.fieldByName("FT_APLICA_PEQUENO_PARCELA").set(parcela.getPercentualReducaoBemPequenoValorME().asTxt());
        objRegTXT.fieldByName("VR_APLICA_PEQUENO_PARCELA").set((Valor)parcela.getValorReducaoBemPequenoValorME());
        objRegTXT.fieldByName("FT_APLICA_UNICO_PARCELA").set(parcela.getPercentualReducaoUnicoImovelME().asTxt());
        objRegTXT.fieldByName("VR_APLICA_UNICO_PARCELA").set((Valor)parcela.getValorReducaoUnicoImovelME());
        objRegTXT.fieldByName("VR_RESULTADO_5_PARCELA").set((Valor)parcela.getGanhoCapital5ProporcionalME());
        objRegTXT.fieldByName("VR_ALIQUOTA_MEDIA_PARCELA").set(parcela.getAliquotaMedia().asTxt());
        objRegTXT.fieldByName("VR_COTACAO_PARCELA").set((Valor)parcela.getCotacaoDolar());
        return objRegTXT;
    }

    public List<RegistroTxt> montarRegistro72(DeclaracaoIRPF declaracao) throws GeracaoTxtException {
        String identificador;
        String dataFim;
        String dataInicio;
        String cpf;
        ArrayList<RegistroTxt> linha = new ArrayList<RegistroTxt>();
        block6: for (AlienacaoBemMovel alienacao : declaracao.getGCAP().getBensMoveis().itens()) {
            cpf = alienacao.getCpf().naoFormatado();
            dataInicio = alienacao.getDataInicioPermanencia().naoFormatado();
            dataFim = alienacao.getDataFimPermanencia().naoFormatado();
            identificador = dataInicio.substring(0, dataInicio.length() - 4) + dataFim.substring(0, dataFim.length() - 4);
            int tipoApuracao = 0;
            if (alienacao.isAlienacaoBrasil()) {
                tipoApuracao = 1;
            } else if ("1".equals(alienacao.obterCodigoOrigemRendimentos().naoFormatado())) {
                tipoApuracao = 2;
            } else if ("2".equals(alienacao.obterCodigoOrigemRendimentos().naoFormatado())) {
                tipoApuracao = 3;
            } else if ("3".equals(alienacao.obterCodigoOrigemRendimentos().naoFormatado())) {
                tipoApuracao = 4;
            }
            switch (tipoApuracao) {
                case 1: {
                    for (ParcelaAlienacaoBem parcela : alienacao.getColecaoParcelaAlienacao().itens()) {
                        linha.add(this.obterRegistro72MovelBrasil(declaracao.getIdentificadorDeclaracao().getCpf().naoFormatado(), cpf, identificador, alienacao, parcela, "1"));
                    }
                    continue block6;
                }
                case 2: {
                    for (ParcelaAlienacaoBem parcela : alienacao.getColecaoParcelaAlienacao().itens()) {
                        linha.add(this.obterRegistro72MovelExMN(declaracao.getIdentificadorDeclaracao().getCpf().naoFormatado(), cpf, identificador, alienacao, parcela, "2"));
                    }
                    continue block6;
                }
                case 3: {
                    for (ParcelaAlienacaoBem parcela : alienacao.getColecaoParcelaAlienacao().itens()) {
                        linha.add(this.obterRegistro72MovelExME(declaracao.getIdentificadorDeclaracao().getCpf().naoFormatado(), cpf, identificador, alienacao, parcela, "3"));
                    }
                    continue block6;
                }
                case 4: {
                    for (ParcelaAlienacaoBem parcela : alienacao.getColecaoParcelaAlienacao().itens()) {
                        linha.add(this.obterRegistro72MovelExMN(declaracao.getIdentificadorDeclaracao().getCpf().naoFormatado(), cpf, identificador, alienacao, parcela, "4"));
                        linha.add(this.obterRegistro72MovelExME(declaracao.getIdentificadorDeclaracao().getCpf().naoFormatado(), cpf, identificador, alienacao, parcela, "5"));
                    }
                    break;
                }
            }
        }
        for (AlienacaoBemMovel alienacao : declaracao.getGCAP().getpSocietarias().itens()) {
            cpf = alienacao.getCpf().naoFormatado();
            dataInicio = alienacao.getDataInicioPermanencia().naoFormatado();
            dataFim = alienacao.getDataFimPermanencia().naoFormatado();
            identificador = dataInicio.substring(0, dataInicio.length() - 4) + dataFim.substring(0, dataFim.length() - 4);
            for (ParcelaAlienacao parcela : alienacao.getColecaoParcelaAlienacao().itens()) {
                linha.add(this.obterRegistro72PSocietariaBrasil(declaracao.getIdentificadorDeclaracao().getCpf().naoFormatado(), cpf, identificador, (AlienacaoParticipacaoSocietaria)alienacao, parcela, 1));
            }
        }
        return linha;
    }

    private RegistroTxt obterRegistro72MovelBrasil(String cpfIRPF, String cpfGCAP, String identificador, AlienacaoBemMovel alienacao, ParcelaAlienacaoBem parcela, String tipoParcela) throws GeracaoTxtException {
        RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "72");
        objRegTXT.fieldByName("NR_REG").set("72");
        objRegTXT.fieldByName("NR_CPF").set(cpfIRPF);
        objRegTXT.fieldByName("NR_CPF_BENEFICIARIO").set(cpfGCAP);
        objRegTXT.fieldByName("NR_IDENTIFICACAO").set(identificador);
        objRegTXT.fieldByName("NR_OPERACAO").set(alienacao.getCodigoOperacao().naoFormatado());
        objRegTXT.fieldByName("IN_TIPO").set("1");
        objRegTXT.fieldByName("NR_TIPO_PARCELA").set(tipoParcela);
        objRegTXT.fieldByName("IN_ULTIMA_PARCELA").set(parcela.isUltimaParcela() ? "1" : "0");
        objRegTXT.fieldByName("DT_PARCELA").set(parcela.getDataRecebimento().naoFormatado());
        objRegTXT.fieldByName("VR_VALOR").set((Valor)parcela.getValorRecebido());
        objRegTXT.fieldByName("VR_CORRETAGEM").set((Valor)parcela.getCustoCorretagem());
        objRegTXT.fieldByName("VR_LIQUIDO_PARCELA").set((Valor)parcela.getValorLiquidoAlienacao());
        objRegTXT.fieldByName("VR_CUSTO_PARCELA").set((Valor)parcela.getCustoAquisicaoProporcional());
        objRegTXT.fieldByName("VR_RESULTADO_1_PARCELA").set((Valor)parcela.getGanhoCapital1Proporcional());
        objRegTXT.fieldByName("VR_ALIQUOTA_MEDIA_PARCELA").set(parcela.getAliquotaMedia().asTxt());
        objRegTXT.fieldByName("VR_IMPOSTO_DEVIDO_PARCELA").set((Valor)parcela.getImpostoDevido());
        objRegTXT.fieldByName("VR_IMPOSTO_PAGO_COMPENSACAO").set((Valor)parcela.getImpostoPagoExterior());
        objRegTXT.fieldByName("VR_IMPOSTO_DEVIDO_BRASIL").set((Valor)parcela.getImpostoDevido2());
        objRegTXT.fieldByName("VR_IMPOSTO_PAGO_PARCELA_BRASIL").set((Valor)parcela.getImpostoPago());
        return objRegTXT;
    }

    private RegistroTxt obterRegistro72MovelExMN(String cpfIRPF, String cpfGCAP, String identificador, AlienacaoBemMovel alienacao, ParcelaAlienacaoBem parcela, String tipoParcela) throws GeracaoTxtException {
        RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "72");
        objRegTXT.fieldByName("NR_REG").set("72");
        objRegTXT.fieldByName("NR_CPF").set(cpfIRPF);
        objRegTXT.fieldByName("NR_CPF_BENEFICIARIO").set(cpfGCAP);
        objRegTXT.fieldByName("NR_IDENTIFICACAO").set(identificador);
        objRegTXT.fieldByName("NR_OPERACAO").set(alienacao.getCodigoOperacao().naoFormatado());
        objRegTXT.fieldByName("IN_TIPO").set("1");
        objRegTXT.fieldByName("NR_TIPO_PARCELA").set(tipoParcela);
        objRegTXT.fieldByName("IN_ULTIMA_PARCELA").set(parcela.isUltimaParcela() ? "1" : "0");
        objRegTXT.fieldByName("DT_PARCELA").set(parcela.getDataRecebimento().naoFormatado());
        if ("4".equals(tipoParcela)) {
            objRegTXT.fieldByName("VR_LIQUIDO_PARCELA_AMBAS").set((Valor)parcela.getValorLiquidoAlienacaoDolar());
            objRegTXT.fieldByName("VR_LIQUIDO_PARCELA").set((Valor)parcela.getValorAlienacaoOrigemNacionalReal());
            objRegTXT.fieldByName("VR_LIQUIDO_PARCELA_DOLAR").set((Valor)parcela.getValorAlienacaoOrigemNacionalDolar());
        } else if ("2".equals(tipoParcela)) {
            objRegTXT.fieldByName("VR_LIQUIDO_PARCELA").set((Valor)parcela.getValorLiquidoAlienacaoReal());
            objRegTXT.fieldByName("VR_LIQUIDO_PARCELA_DOLAR").set((Valor)parcela.getValorLiquidoAlienacaoDolar());
            objRegTXT.fieldByName("VR_VALOR").set((Valor)parcela.getValorRecebidoDolar());
            objRegTXT.fieldByName("VR_CORRETAGEM").set((Valor)parcela.getCustoCorretagemDolar());
            objRegTXT.fieldByName("VR_IMPOSTO_DEVIDO_PARCELA").set((Valor)parcela.getImpostoDevido());
            objRegTXT.fieldByName("VR_IMPOSTO_PAGO_COMPENSACAO").set((Valor)parcela.getImpostoPagoExterior());
            objRegTXT.fieldByName("VR_IMPOSTO_DEVIDO_BRASIL").set((Valor)parcela.getImpostoDevido2());
            objRegTXT.fieldByName("VR_IMPOSTO_PAGO_PARCELA_BRASIL").set((Valor)parcela.getImpostoPago());
        }
        objRegTXT.fieldByName("VR_CUSTO_PARCELA").set((Valor)parcela.getCustoAquisicaoProporcionalOrigemNacionalReal());
        objRegTXT.fieldByName("VR_RESULTADO_1_PARCELA").set((Valor)parcela.getGanhoCapital1ProporcionalOrigemNacionalReal());
        objRegTXT.fieldByName("VR_ALIQUOTA_MEDIA_PARCELA").set(parcela.getAliquotaMedia().asTxt());
        objRegTXT.fieldByName("VR_COTACAO_PARCELA").set((Valor)parcela.getCotacaoDolar());
        return objRegTXT;
    }

    private RegistroTxt obterRegistro72MovelExME(String cpfIRPF, String cpfGCAP, String identificador, AlienacaoBemMovel alienacao, ParcelaAlienacaoBem parcela, String tipoParcela) throws GeracaoTxtException {
        RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "72");
        objRegTXT.fieldByName("NR_REG").set("72");
        objRegTXT.fieldByName("NR_CPF").set(cpfIRPF);
        objRegTXT.fieldByName("NR_CPF_BENEFICIARIO").set(cpfGCAP);
        objRegTXT.fieldByName("NR_IDENTIFICACAO").set(identificador);
        objRegTXT.fieldByName("NR_OPERACAO").set(alienacao.getCodigoOperacao().naoFormatado());
        objRegTXT.fieldByName("IN_TIPO").set("1");
        objRegTXT.fieldByName("NR_TIPO_PARCELA").set(tipoParcela);
        objRegTXT.fieldByName("IN_ULTIMA_PARCELA").set(parcela.isUltimaParcela() ? "1" : "0");
        objRegTXT.fieldByName("DT_PARCELA").set(parcela.getDataRecebimento().naoFormatado());
        if ("5".equals(tipoParcela)) {
            objRegTXT.fieldByName("VR_LIQUIDO_PARCELA_AMBAS").set((Valor)parcela.getValorLiquidoAlienacaoDolar());
            objRegTXT.fieldByName("VR_LIQUIDO_PARCELA_DOLAR").set((Valor)parcela.getValorAlienacaoOrigemMEDolar());
        } else if ("3".equals(tipoParcela)) {
            objRegTXT.fieldByName("VR_LIQUIDO_PARCELA_DOLAR").set((Valor)parcela.getValorLiquidoAlienacaoDolar());
            objRegTXT.fieldByName("VR_VALOR").set((Valor)parcela.getValorRecebidoDolar());
            objRegTXT.fieldByName("VR_CORRETAGEM").set((Valor)parcela.getCustoCorretagemDolar());
            objRegTXT.fieldByName("VR_IMPOSTO_DEVIDO_PARCELA").set((Valor)parcela.getImpostoDevido());
            objRegTXT.fieldByName("VR_IMPOSTO_PAGO_COMPENSACAO").set((Valor)parcela.getImpostoPagoExterior());
            objRegTXT.fieldByName("VR_IMPOSTO_DEVIDO_BRASIL").set((Valor)parcela.getImpostoDevido2());
            objRegTXT.fieldByName("VR_IMPOSTO_PAGO_PARCELA_BRASIL").set((Valor)parcela.getImpostoPago());
        }
        objRegTXT.fieldByName("VR_CUSTO_PARCELA").set((Valor)parcela.getCustoAquisicaoProporcionalOrigemMEDolar());
        objRegTXT.fieldByName("VR_RESULTADO_1_PARCELA_DOLAR").set((Valor)parcela.getGanhoCapital1ProporcionalOrigemMEDolar());
        objRegTXT.fieldByName("VR_RESULTADO_1_PARCELA").set((Valor)parcela.getGanhoCapital1ProporcionalOrigemMEReal());
        objRegTXT.fieldByName("VR_ALIQUOTA_MEDIA_PARCELA").set(parcela.getAliquotaMedia().asTxt());
        objRegTXT.fieldByName("VR_COTACAO_PARCELA").set((Valor)parcela.getCotacaoDolar());
        return objRegTXT;
    }

    private RegistroTxt obterRegistro72PSocietariaBrasil(String cpfIRPF, String cpfGCAP, String identificador, AlienacaoParticipacaoSocietaria alienacao, ParcelaAlienacao parcela, int tipoParcela) throws GeracaoTxtException {
        RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "72");
        objRegTXT.fieldByName("NR_REG").set("72");
        objRegTXT.fieldByName("NR_CPF").set(cpfIRPF);
        objRegTXT.fieldByName("NR_CPF_BENEFICIARIO").set(cpfGCAP);
        objRegTXT.fieldByName("NR_IDENTIFICACAO").set(identificador);
        objRegTXT.fieldByName("NR_OPERACAO").set(alienacao.getCodigoOperacao().naoFormatado());
        objRegTXT.fieldByName("IN_TIPO").set("2");
        objRegTXT.fieldByName("NR_TIPO_PARCELA").set(tipoParcela);
        objRegTXT.fieldByName("IN_ULTIMA_PARCELA").set(parcela.isUltimaParcela() ? "1" : "0");
        objRegTXT.fieldByName("DT_PARCELA").set(parcela.getDataRecebimento().naoFormatado());
        objRegTXT.fieldByName("VR_VALOR").set((Valor)parcela.getValorRecebido());
        objRegTXT.fieldByName("VR_CORRETAGEM").set((Valor)parcela.getCustoCorretagem());
        objRegTXT.fieldByName("VR_LIQUIDO_PARCELA").set((Valor)parcela.getValorLiquidoAlienacao());
        objRegTXT.fieldByName("VR_CUSTO_PARCELA").set((Valor)parcela.getCustoAquisicaoProporcional());
        objRegTXT.fieldByName("VR_RESULTADO_1_PARCELA").set((Valor)parcela.getGanhoCapital1Proporcional());
        objRegTXT.fieldByName("VR_ALIQUOTA_MEDIA_PARCELA").set(parcela.getAliquotaMedia().asTxt());
        objRegTXT.fieldByName("VR_IMPOSTO_DEVIDO_PARCELA").set((Valor)parcela.getImpostoDevido());
        objRegTXT.fieldByName("VR_IMPOSTO_PAGO_COMPENSACAO").set((Valor)parcela.getIrrfLei110332004());
        objRegTXT.fieldByName("VR_IMPOSTO_DEVIDO_BRASIL").set((Valor)parcela.getImpostoDevido2());
        objRegTXT.fieldByName("VR_IMPOSTO_PAGO_PARCELA_BRASIL").set((Valor)parcela.getImpostoPago());
        return objRegTXT;
    }

    public List<RegistroTxt> montarRegistro73(DeclaracaoIRPF declaracao) throws GeracaoTxtException {
        ArrayList<RegistroTxt> linha = new ArrayList<RegistroTxt>();
        Valor nrItem = new Valor(null, "", 4, 0);
        String cpfDeclaracao = declaracao.getIdentificadorDeclaracao().getCpf().naoFormatado();
        for (AlienacaoParticipacaoSocietaria alienacao : declaracao.getGCAP().getpSocietarias().itens()) {
            String cpfBeneficiario = alienacao.getCpf().naoFormatado();
            String dataInicio = alienacao.getDataInicioPermanencia().naoFormatado();
            String dataFim = alienacao.getDataFimPermanencia().naoFormatado();
            String identificador = dataInicio.substring(0, dataInicio.length() - 4) + dataFim.substring(0, dataFim.length() - 4);
            for (ParcelaAquisicaoParticipacaoSocietaria parcela : alienacao.getColecaoParcelaAquisicaoParticipacaoSocietaria().itens()) {
                RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "73");
                nrItem.append('+', "1");
                objRegTXT.fieldByName("NR_REG").set("73");
                objRegTXT.fieldByName("NR_CPF").set(cpfDeclaracao);
                objRegTXT.fieldByName("NR_CPF_BENEFICIARIO").set(cpfBeneficiario);
                objRegTXT.fieldByName("NR_IDENTIFICACAO").set(identificador);
                objRegTXT.fieldByName("NR_OPERACAO").set(alienacao.getCodigoOperacao().naoFormatado());
                objRegTXT.fieldByName("NR_ITEM").set(nrItem);
                objRegTXT.fieldByName("IN_ESPECIE").set(parcela.getEspecieAquisicao().naoFormatado());
                objRegTXT.fieldByName("NM_DESCRICAO_ESPECIE").set(parcela.getEspecieAquisicao().getConteudoAtual(1));
                objRegTXT.fieldByName("VR_QUANTIDADE_ALIENADA").set(new Valor(null, "", 11, 0).add((double)parcela.getQuantidadeQuotas().asInteger()));
                objRegTXT.fieldByName("VR_CUSTO_MEDIO").set(parcela.getCustoMedio().asTxt());
                objRegTXT.fieldByName("VR_CUSTO_TOTAL").set((Valor)parcela.getCustoAquisicao());
                linha.add(objRegTXT);
            }
            nrItem.clear();
        }
        return linha;
    }

    public List<RegistroTxt> montarRegistro74(DeclaracaoIRPF declaracao) throws GeracaoTxtException {
        ArrayList<RegistroTxt> linha = new ArrayList<RegistroTxt>();
        Valor nrItem = new Valor(null, "", 4, 0);
        for (MoedaAlienada moeda : declaracao.getGCAP().getEspecie().itens()) {
            nrItem.append('+', "1");
            String cpfDeclaracao = declaracao.getIdentificadorDeclaracao().getCpf().naoFormatado();
            String cpfBeneficiario = moeda.getCpf().naoFormatado();
            String dataInicio = moeda.getDataInicioPermanencia().naoFormatado();
            String dataFim = moeda.getDataFimPermanencia().naoFormatado();
            String identificador = dataInicio.substring(0, dataInicio.length() - 4) + dataFim.substring(0, dataFim.length() - 4);
            RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "74");
            objRegTXT.fieldByName("NR_REG").set("74");
            objRegTXT.fieldByName("NR_CPF").set(cpfDeclaracao);
            objRegTXT.fieldByName("NR_CPF_BENEFICIARIO").set(cpfBeneficiario);
            objRegTXT.fieldByName("NR_IDENTIFICACAO").set(identificador);
            objRegTXT.fieldByName("NR_ITEM").set(nrItem);
            objRegTXT.fieldByName("CD_MOEDA").set(moeda.getMoeda().getConteudoAtual(0));
            objRegTXT.fieldByName("NM_MOEDA").set(moeda.getMoeda().getConteudoAtual(1));
            objRegTXT.fieldByName("TIPO_OPERACAO").set("1");
            objRegTXT.fieldByName("NM_OPERACAO").set("SALDO INICIAL");
            objRegTXT.fieldByName("DT_OPERACAO").set("0101" + ConstantesGlobais.ANO_BASE);
            objRegTXT.fieldByName("VR_CUSTO").set(moeda.getCustoMedioInicial().asTxt());
            objRegTXT.fieldByName("VR_SALDO_REAIS").set((Valor)moeda.getSaldoInicial());
            objRegTXT.fieldByName("VR_SALDO_ME").set((Valor)moeda.getEstoqueInicial());
            linha.add(objRegTXT);
            for (OperacaoEspecie operacao : moeda.getOperacoesEspecie().itens()) {
                nrItem.append('+', "1");
                objRegTXT = new RegistroTxt("ARQ_IRPF", "74");
                objRegTXT.fieldByName("NR_REG").set("74");
                objRegTXT.fieldByName("NR_CPF").set(cpfDeclaracao);
                objRegTXT.fieldByName("NR_CPF_BENEFICIARIO").set(cpfBeneficiario);
                objRegTXT.fieldByName("NR_IDENTIFICACAO").set(identificador);
                objRegTXT.fieldByName("NR_ITEM").set(nrItem);
                objRegTXT.fieldByName("CD_MOEDA").set(moeda.getMoeda().getConteudoAtual(0));
                objRegTXT.fieldByName("NM_MOEDA").set(moeda.getMoeda().getConteudoAtual(1));
                if ("1".equals(operacao.getTipo().naoFormatado())) {
                    objRegTXT.fieldByName("TIPO_OPERACAO").set("2");
                    objRegTXT.fieldByName("NM_OPERACAO").set("COMPRA");
                    objRegTXT.fieldByName("DT_OPERACAO").set(operacao.getData().naoFormatado());
                    objRegTXT.fieldByName("VR_OPERACAO").set((Valor)operacao.getValor());
                    objRegTXT.fieldByName("NR_QUANTIDADE").set((Valor)operacao.getQuantidade());
                    objRegTXT.fieldByName("VR_CUSTO").set(operacao.getCustoMedio().asTxt());
                    objRegTXT.fieldByName("VR_SALDO_REAIS").set((Valor)operacao.getSaldo());
                    objRegTXT.fieldByName("VR_SALDO_ME").set((Valor)operacao.getEstoque());
                } else {
                    if (!"2".equals(operacao.getTipo().naoFormatado())) continue;
                    objRegTXT.fieldByName("TIPO_OPERACAO").set("3");
                    objRegTXT.fieldByName("NM_OPERACAO").set("VENDA");
                    objRegTXT.fieldByName("NM_ADQUIR").set(operacao.getNomeAdquirente().naoFormatado());
                    objRegTXT.fieldByName("NR_ADQUIR").set(operacao.getNiAdquirente().naoFormatado());
                    objRegTXT.fieldByName("DT_OPERACAO").set(operacao.getData().naoFormatado());
                    objRegTXT.fieldByName("VR_OPERACAO").set((Valor)operacao.getValor());
                    objRegTXT.fieldByName("NR_QUANTIDADE").set((Valor)operacao.getQuantidade());
                    objRegTXT.fieldByName("VR_CUSTO").set(operacao.getCustoMedio().asTxt());
                    objRegTXT.fieldByName("VR_CUSTOTOTAQUIS").set((Valor)operacao.getCustoAlienacao());
                    objRegTXT.fieldByName("VR_GANHOCAPITAL").set((Valor)operacao.getGanhoCapital());
                    objRegTXT.fieldByName("VR_SALDO_REAIS").set((Valor)operacao.getSaldo());
                    objRegTXT.fieldByName("VR_SALDO_ME").set((Valor)operacao.getEstoque());
                    objRegTXT.fieldByName("VR_COTACAO_MOEDA_ESTRANGEIRA_DOLAR").set((Valor)operacao.getCotacaoDolar());
                }
                linha.add(objRegTXT);
            }
            nrItem.clear();
        }
        return linha;
    }

    public List<RegistroTxt> montarRegistro75(DeclaracaoIRPF declaracao) throws GeracaoTxtException {
        RegistroTxt objRegTXT;
        ArrayList<RegistroTxt> linha = new ArrayList<RegistroTxt>();
        String cpfDeclaracao = declaracao.getIdentificadorDeclaracao().getCpf().naoFormatado();
        for (AlienacaoBemImovel alienacao : declaracao.getGCAP().getBensImoveis().itens()) {
            objRegTXT = this.montarBaseRegistro75((Alienacao)alienacao, alienacao.getCalculoImposto(), cpfDeclaracao, "1", "1");
            linha.add(objRegTXT);
        }
        for (AlienacaoBemImovel alienacao : declaracao.getGCAP().getBensMoveis().itens()) {
            objRegTXT = this.montarBaseRegistro75((Alienacao)alienacao, alienacao.getCalculoImposto(), cpfDeclaracao, "2", "1");
            linha.add(objRegTXT);
        }
        for (AlienacaoBemImovel alienacao : declaracao.getGCAP().getpSocietarias().itens()) {
            objRegTXT = this.montarBaseRegistro75((Alienacao)alienacao, alienacao.getCalculoImposto(), cpfDeclaracao, "3", "1");
            linha.add(objRegTXT);
        }
        return linha;
    }

    private RegistroTxt montarBaseRegistro75(Alienacao alienacao, CalculoImposto calculoImposto, String cpfIRPF, String tipo, String tipoApuracao) throws GeracaoTxtException {
        String cpfBeneficiario = alienacao.getCpf().naoFormatado();
        String dataInicio = alienacao.getDataInicioPermanencia().naoFormatado();
        String dataFim = alienacao.getDataFimPermanencia().naoFormatado();
        String identificador = dataInicio.substring(0, dataInicio.length() - 4) + dataFim.substring(0, dataFim.length() - 4);
        ValorPositivo[][] faixasCalculoImposto = this.splitFaixasRegistro75(alienacao.getCalculoImposto().getFaixasCalculoImposto().naoFormatado());
        RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "75");
        objRegTXT.fieldByName("NR_REG").set("75");
        objRegTXT.fieldByName("NR_CPF").set(cpfIRPF);
        objRegTXT.fieldByName("NR_CPF_BENEFICIARIO").set(cpfBeneficiario);
        objRegTXT.fieldByName("NR_IDENTIFICACAO").set(identificador);
        objRegTXT.fieldByName("NR_OPERACAO").set(alienacao.getCodigoOperacao().naoFormatado());
        objRegTXT.fieldByName("IN_TIPO").set(tipo);
        objRegTXT.fieldByName("IN_APURACAO").set(tipoApuracao);
        objRegTXT.fieldByName("VR_FAIXA1_ATUAL").set((Valor)faixasCalculoImposto[0][2]);
        objRegTXT.fieldByName("VR_FAIXA1_ANTERIOR").set((Valor)faixasCalculoImposto[0][1]);
        objRegTXT.fieldByName("VR_FAIXA1_TOTAL").set((Valor)faixasCalculoImposto[0][0]);
        objRegTXT.fieldByName("VR_FAIXA2_ATUAL").set((Valor)faixasCalculoImposto[1][2]);
        objRegTXT.fieldByName("VR_FAIXA2_ANTERIOR").set((Valor)faixasCalculoImposto[1][1]);
        objRegTXT.fieldByName("VR_FAIXA2_TOTAL").set((Valor)faixasCalculoImposto[1][0]);
        objRegTXT.fieldByName("VR_FAIXA3_ATUAL").set((Valor)faixasCalculoImposto[2][2]);
        objRegTXT.fieldByName("VR_FAIXA3_ANTERIOR").set((Valor)faixasCalculoImposto[2][1]);
        objRegTXT.fieldByName("VR_FAIXA3_TOTAL").set((Valor)faixasCalculoImposto[2][0]);
        objRegTXT.fieldByName("VR_FAIXA4_ATUAL").set((Valor)faixasCalculoImposto[3][2]);
        objRegTXT.fieldByName("VR_FAIXA4_ANTERIOR").set((Valor)faixasCalculoImposto[3][1]);
        objRegTXT.fieldByName("VR_FAIXA4_TOTAL").set((Valor)faixasCalculoImposto[3][0]);
        objRegTXT.fieldByName("VR_FAIXAT_ATUAL").set((Valor)faixasCalculoImposto[4][2]);
        objRegTXT.fieldByName("VR_FAIXAT_ANTERIOR").set((Valor)faixasCalculoImposto[4][1]);
        objRegTXT.fieldByName("VR_FAIXAT_TOTAL").set((Valor)faixasCalculoImposto[4][0]);
        return objRegTXT;
    }

    private ValorPositivo[][] splitFaixasRegistro75(String faixasCalculoImposto) {
        ValorPositivo[][] faixas = new ValorPositivo[5][3];
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 3; ++j) {
                faixas[i][j] = new ValorPositivo();
            }
        }
        String[] linhas = faixasCalculoImposto.split(" ");
        for (int i = 0; i < linhas.length; ++i) {
            String[] colunas = linhas[i].split(";");
            if (colunas.length != 3) continue;
            faixas[i][0].setConteudo(colunas[0]);
            faixas[i][1].setConteudo(colunas[1]);
            faixas[i][2].setConteudo(colunas[2]);
        }
        return faixas;
    }

    public List<RegistroTxt> montarRegistro76(DeclaracaoIRPF declaracao) throws GeracaoTxtException {
        ArrayList<RegistroTxt> linhas = new ArrayList<RegistroTxt>();
        for (TotalizacaoMoedasAlienadas totalizacao : declaracao.getGCAP().getColecaoTotalizacaoMoedasAlienadas().itens()) {
            String cpfDeclaracao = declaracao.getIdentificadorDeclaracao().getCpf().naoFormatado();
            String cpfBeneficiario = totalizacao.getCpf().naoFormatado();
            String dataInicio = totalizacao.getDataInicioPermanencia().naoFormatado();
            String dataFim = totalizacao.getDataFimPermanencia().naoFormatado();
            String identificador = dataInicio.substring(0, dataInicio.length() - 4) + dataFim.substring(0, dataFim.length() - 4);
            for (MoedasAlienadasMensal mes : totalizacao.getMeses()) {
                RegistroTxt objRegTXT = new RegistroTxt("ARQ_IRPF", "76");
                objRegTXT.fieldByName("NR_REG").set("76");
                objRegTXT.fieldByName("NR_CPF").set(cpfDeclaracao);
                objRegTXT.fieldByName("NR_CPF_BENEFICIARIO").set(cpfBeneficiario);
                objRegTXT.fieldByName("NR_IDENTIFICACAO").set(identificador);
                objRegTXT.fieldByName("NR_MES").set(mes.getMesToTXT());
                objRegTXT.fieldByName("VR_ALIENACAO_DOLAR").set((Valor)mes.getAlienacoesDolar());
                objRegTXT.fieldByName("VR_ALIENACAO_CONSOLIDADA_DOLAR").set((Valor)mes.getAlienacoesConsolidadasDolar());
                objRegTXT.fieldByName("VR_GANHO_CAPITAL").set((Valor)mes.getGanhosCapital());
                objRegTXT.fieldByName("VR_GANHO_CAPITAL_TRIBUTAVEL").set((Valor)mes.getGanhosCapitalTributavel());
                objRegTXT.fieldByName("VR_ALIQUOTA_MEDIA").set((Valor)mes.getAliquotaMedia());
                objRegTXT.fieldByName("VR_IMPOSTO_DEVIDO").set((Valor)mes.getImpostoDevido());
                objRegTXT.fieldByName("VR_IMPOSTO_PAGO").set((Valor)mes.getImpostoPago());
                linhas.add(objRegTXT);
            }
        }
        return linhas;
    }
}

