/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.virtualization;

import java.io.IOException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.fill.JREvaluationTime;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.virtualization.ObjectSerializer;
import net.sf.jasperreports.engine.virtualization.ReferenceType;
import net.sf.jasperreports.engine.virtualization.VirtualizationInput;
import net.sf.jasperreports.engine.virtualization.VirtualizationOutput;

public class EvaluationTimeSerializer
implements ObjectSerializer<JREvaluationTime> {
    @Override
    public int typeValue() {
        return 62;
    }

    @Override
    public ReferenceType defaultReferenceType() {
        return ReferenceType.OBJECT;
    }

    @Override
    public boolean defaultStoreReference() {
        return true;
    }

    @Override
    public void write(JREvaluationTime value, VirtualizationOutput out) throws IOException {
        EvaluationTimeEnum type = value.getType();
        out.writeByte(type.getValue());
        if (type == EvaluationTimeEnum.BAND) {
            out.writeInt(value.getBandId());
        } else if (type == EvaluationTimeEnum.GROUP) {
            out.writeJRObject(value.getGroupName());
        }
    }

    @Override
    public JREvaluationTime read(VirtualizationInput in) throws IOException {
        JREvaluationTime value;
        byte byteType = in.readByte();
        EvaluationTimeEnum type = EvaluationTimeEnum.getByValue(byteType);
        switch (type) {
            case NOW: {
                value = JREvaluationTime.EVALUATION_TIME_NOW;
                break;
            }
            case REPORT: {
                value = JREvaluationTime.EVALUATION_TIME_REPORT;
                break;
            }
            case PAGE: {
                value = JREvaluationTime.EVALUATION_TIME_PAGE;
                break;
            }
            case COLUMN: {
                value = JREvaluationTime.EVALUATION_TIME_COLUMN;
                break;
            }
            case BAND: {
                int bandId = in.readInt();
                value = JREvaluationTime.getBandEvaluationTime(bandId);
                break;
            }
            case GROUP: {
                String groupName = (String)in.readJRObject();
                value = JREvaluationTime.getGroupEvaluationTime(groupName);
                break;
            }
            default: {
                throw new JRRuntimeException("Unknown evaluation time " + type);
            }
        }
        return value;
    }
}

