/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.type.FooterPositionEnum;

class SavePoint {
    protected JRPrintPage page;
    protected int columnIndex;
    protected boolean isNewPage;
    protected boolean isNewColumn;
    protected int startOffsetY;
    protected int endOffsetY;
    protected int startElementIndex;
    protected int endElementIndex;
    protected int heightOffset;
    protected int groupIndex;
    protected FooterPositionEnum footerPosition = FooterPositionEnum.NORMAL;
    protected List<JRPrintElement> elementsToMove = new ArrayList<JRPrintElement>();

    protected SavePoint(JRPrintPage page, int columnIndex, boolean isNewPage, boolean isNewColumn, int startOffsetY) {
        this.page = page;
        this.columnIndex = columnIndex;
        this.isNewPage = isNewPage;
        this.isNewColumn = isNewColumn;
        this.endElementIndex = this.startElementIndex = page.getElements().size();
        this.startOffsetY = startOffsetY;
    }

    protected void saveHeightOffset(int heightOffset) {
        this.heightOffset = heightOffset;
        this.save();
    }

    protected void saveEndOffsetY(int endOffsetY) {
        this.endOffsetY = endOffsetY;
        this.save();
    }

    protected void save() {
        this.endElementIndex = this.page.getElements().size();
    }

    protected void removeContent() {
        int i = this.endElementIndex - 1;
        while (i >= this.startElementIndex) {
            this.elementsToMove.add(this.page.getElements().remove(i));
            --i;
        }
    }

    protected void addContent(JRPrintPage printPage, int xdelta, int ydelta) {
        int i = this.elementsToMove.size() - 1;
        while (i >= 0) {
            JRPrintElement printElement = this.elementsToMove.get(i);
            printElement.setX(printElement.getX() + xdelta);
            printElement.setY(printElement.getY() + ydelta);
            printPage.addElement(printElement);
            --i;
        }
    }

    protected void moveSavePointContent() {
        if (this.footerPosition != FooterPositionEnum.NORMAL) {
            int i = this.startElementIndex;
            while (i < this.endElementIndex) {
                JRPrintElement printElement = this.page.getElements().get(i);
                printElement.setY(printElement.getY() + this.heightOffset);
                ++i;
            }
        }
    }
}

