/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.base.JRBaseElement;
import net.sf.jasperreports.engine.base.JRBaseElementGroup;
import net.sf.jasperreports.engine.base.JRBaseLineBox;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.util.ElementsVisitorUtils;
import net.sf.jasperreports.engine.util.JRBoxUtil;
import net.sf.jasperreports.engine.util.JRStyleResolver;

public class JRBaseFrame
extends JRBaseElement
implements JRFrame {
    private static final long serialVersionUID = 10200L;
    protected List<JRChild> children;
    protected JRLineBox lineBox;
    private Byte border;
    private Byte topBorder;
    private Byte leftBorder;
    private Byte bottomBorder;
    private Byte rightBorder;
    private Color borderColor;
    private Color topBorderColor;
    private Color leftBorderColor;
    private Color bottomBorderColor;
    private Color rightBorderColor;
    private Integer padding;
    private Integer topPadding;
    private Integer leftPadding;
    private Integer bottomPadding;
    private Integer rightPadding;

    public JRBaseFrame(JRFrame frame, JRBaseObjectFactory factory) {
        super(frame, factory);
        List<JRChild> frameChildren = frame.getChildren();
        if (frameChildren != null) {
            this.children = new ArrayList<JRChild>(frameChildren.size());
            for (JRChild child : frameChildren) {
                this.children.add((JRChild)factory.getVisitResult(child));
            }
        }
        this.lineBox = frame.getLineBox().clone(this);
    }

    @Override
    public JRElement[] getElements() {
        return JRBaseElementGroup.getElements(this.children);
    }

    @Override
    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    @Override
    public void visit(JRVisitor visitor) {
        visitor.visitFrame(this);
        if (ElementsVisitorUtils.visitDeepElements(visitor)) {
            ElementsVisitorUtils.visitElements(visitor, this.children);
        }
    }

    @Override
    public List<JRChild> getChildren() {
        return this.children;
    }

    @Override
    public JRElement getElementByKey(String elementKey) {
        return JRBaseElementGroup.getElementByKey(this.getElements(), elementKey);
    }

    @Override
    public ModeEnum getModeValue() {
        return JRStyleResolver.getMode(this, ModeEnum.TRANSPARENT);
    }

    @Override
    public JRLineBox getLineBox() {
        return this.lineBox;
    }

    @Override
    public Color getDefaultLineColor() {
        return this.getForecolor();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.lineBox == null) {
            this.lineBox = new JRBaseLineBox(this);
            JRBoxUtil.setToBox(this.border, this.topBorder, this.leftBorder, this.bottomBorder, this.rightBorder, this.borderColor, this.topBorderColor, this.leftBorderColor, this.bottomBorderColor, this.rightBorderColor, this.padding, this.topPadding, this.leftPadding, this.bottomPadding, this.rightPadding, this.lineBox);
            this.border = null;
            this.topBorder = null;
            this.leftBorder = null;
            this.bottomBorder = null;
            this.rightBorder = null;
            this.borderColor = null;
            this.topBorderColor = null;
            this.leftBorderColor = null;
            this.bottomBorderColor = null;
            this.rightBorderColor = null;
            this.padding = null;
            this.topPadding = null;
            this.leftPadding = null;
            this.bottomPadding = null;
            this.rightPadding = null;
        }
    }

    @Override
    public Object clone() {
        JRBaseFrame clone = (JRBaseFrame)super.clone();
        if (this.children != null) {
            clone.children = new ArrayList<JRChild>(this.children.size());
            int i = 0;
            while (i < this.children.size()) {
                clone.children.add((JRChild)this.children.get(i).clone(clone));
                ++i;
            }
        }
        return clone;
    }
}

