/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.HtmlExporter;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRXmlExporter;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleHtmlExporterOutput;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import net.sf.jasperreports.export.SimpleWriterExporterOutput;
import net.sf.jasperreports.export.SimpleXmlExporterOutput;

public final class JasperExportManager {
    private JasperReportsContext jasperReportsContext;

    private JasperExportManager(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
    }

    private static JasperExportManager getDefaultInstance() {
        return new JasperExportManager(DefaultJasperReportsContext.getInstance());
    }

    public static JasperExportManager getInstance(JasperReportsContext jasperReportsContext) {
        return new JasperExportManager(jasperReportsContext);
    }

    public String exportToPdfFile(String sourceFileName) throws JRException {
        File sourceFile = new File(sourceFileName);
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject(sourceFile);
        File destFile = new File(sourceFile.getParent(), String.valueOf(jasperPrint.getName()) + ".pdf");
        String destFileName = destFile.toString();
        JasperExportManager.exportReportToPdfFile(jasperPrint, destFileName);
        return destFileName;
    }

    public void exportToPdfFile(String sourceFileName, String destFileName) throws JRException {
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObjectFromFile(sourceFileName);
        JasperExportManager.exportReportToPdfFile(jasperPrint, destFileName);
    }

    public void exportToPdfFile(JasperPrint jasperPrint, String destFileName) throws JRException {
        JRPdfExporter exporter = new JRPdfExporter(this.jasperReportsContext);
        exporter.setExporterInput(new SimpleExporterInput(jasperPrint));
        exporter.setExporterOutput(new SimpleOutputStreamExporterOutput(destFileName));
        exporter.exportReport();
    }

    public void exportToPdfStream(InputStream inputStream, OutputStream outputStream) throws JRException {
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject(inputStream);
        JasperExportManager.exportReportToPdfStream(jasperPrint, outputStream);
    }

    public void exportToPdfStream(JasperPrint jasperPrint, OutputStream outputStream) throws JRException {
        JRPdfExporter exporter = new JRPdfExporter(this.jasperReportsContext);
        exporter.setExporterInput(new SimpleExporterInput(jasperPrint));
        exporter.setExporterOutput(new SimpleOutputStreamExporterOutput(outputStream));
        exporter.exportReport();
    }

    public byte[] exportToPdf(JasperPrint jasperPrint) throws JRException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JRPdfExporter exporter = new JRPdfExporter(this.jasperReportsContext);
        exporter.setExporterInput(new SimpleExporterInput(jasperPrint));
        exporter.setExporterOutput(new SimpleOutputStreamExporterOutput(baos));
        exporter.exportReport();
        return baos.toByteArray();
    }

    public String exportToXmlFile(String sourceFileName, boolean isEmbeddingImages) throws JRException {
        File sourceFile = new File(sourceFileName);
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject(sourceFile);
        File destFile = new File(sourceFile.getParent(), String.valueOf(jasperPrint.getName()) + ".jrpxml");
        String destFileName = destFile.toString();
        JasperExportManager.exportReportToXmlFile(jasperPrint, destFileName, isEmbeddingImages);
        return destFileName;
    }

    public void exportToXmlFile(String sourceFileName, String destFileName, boolean isEmbeddingImages) throws JRException {
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObjectFromFile(sourceFileName);
        JasperExportManager.exportReportToXmlFile(jasperPrint, destFileName, isEmbeddingImages);
    }

    public void exportToXmlFile(JasperPrint jasperPrint, String destFileName, boolean isEmbeddingImages) throws JRException {
        JRXmlExporter exporter = new JRXmlExporter(this.jasperReportsContext);
        exporter.setExporterInput(new SimpleExporterInput(jasperPrint));
        SimpleXmlExporterOutput xmlOutput = new SimpleXmlExporterOutput(destFileName);
        xmlOutput.setEmbeddingImages(isEmbeddingImages);
        exporter.setExporterOutput(xmlOutput);
        exporter.exportReport();
    }

    public void exportToXmlStream(InputStream inputStream, OutputStream outputStream) throws JRException {
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject(inputStream);
        JasperExportManager.exportReportToXmlStream(jasperPrint, outputStream);
    }

    public void exportToXmlStream(JasperPrint jasperPrint, OutputStream outputStream) throws JRException {
        JRXmlExporter exporter = new JRXmlExporter(this.jasperReportsContext);
        exporter.setExporterInput(new SimpleExporterInput(jasperPrint));
        exporter.setExporterOutput(new SimpleWriterExporterOutput(outputStream));
        exporter.exportReport();
    }

    public String exportToXml(JasperPrint jasperPrint) throws JRException {
        StringBuffer sbuffer = new StringBuffer();
        JRXmlExporter exporter = new JRXmlExporter(this.jasperReportsContext);
        exporter.setExporterInput(new SimpleExporterInput(jasperPrint));
        exporter.setExporterOutput(new SimpleWriterExporterOutput(sbuffer));
        exporter.exportReport();
        return sbuffer.toString();
    }

    public String exportToHtmlFile(String sourceFileName) throws JRException {
        File sourceFile = new File(sourceFileName);
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject(sourceFile);
        File destFile = new File(sourceFile.getParent(), String.valueOf(jasperPrint.getName()) + ".html");
        String destFileName = destFile.toString();
        JasperExportManager.exportReportToHtmlFile(jasperPrint, destFileName);
        return destFileName;
    }

    public void exportToHtmlFile(String sourceFileName, String destFileName) throws JRException {
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObjectFromFile(sourceFileName);
        JasperExportManager.exportReportToHtmlFile(jasperPrint, destFileName);
    }

    public void exportToHtmlFile(JasperPrint jasperPrint, String destFileName) throws JRException {
        HtmlExporter exporter = new HtmlExporter(this.jasperReportsContext);
        exporter.setExporterInput(new SimpleExporterInput(jasperPrint));
        exporter.setExporterOutput(new SimpleHtmlExporterOutput(destFileName));
        exporter.exportReport();
    }

    public static String exportReportToPdfFile(String sourceFileName) throws JRException {
        return JasperExportManager.getDefaultInstance().exportToPdfFile(sourceFileName);
    }

    public static void exportReportToPdfFile(String sourceFileName, String destFileName) throws JRException {
        JasperExportManager.getDefaultInstance().exportToPdfFile(sourceFileName, destFileName);
    }

    public static void exportReportToPdfFile(JasperPrint jasperPrint, String destFileName) throws JRException {
        JasperExportManager.getDefaultInstance().exportToPdfFile(jasperPrint, destFileName);
    }

    public static void exportReportToPdfStream(InputStream inputStream, OutputStream outputStream) throws JRException {
        JasperExportManager.getDefaultInstance().exportToPdfStream(inputStream, outputStream);
    }

    public static void exportReportToPdfStream(JasperPrint jasperPrint, OutputStream outputStream) throws JRException {
        JasperExportManager.getDefaultInstance().exportToPdfStream(jasperPrint, outputStream);
    }

    public static byte[] exportReportToPdf(JasperPrint jasperPrint) throws JRException {
        return JasperExportManager.getDefaultInstance().exportToPdf(jasperPrint);
    }

    public static String exportReportToXmlFile(String sourceFileName, boolean isEmbeddingImages) throws JRException {
        return JasperExportManager.getDefaultInstance().exportToXmlFile(sourceFileName, isEmbeddingImages);
    }

    public static void exportReportToXmlFile(String sourceFileName, String destFileName, boolean isEmbeddingImages) throws JRException {
        JasperExportManager.getDefaultInstance().exportToXmlFile(sourceFileName, destFileName, isEmbeddingImages);
    }

    public static void exportReportToXmlFile(JasperPrint jasperPrint, String destFileName, boolean isEmbeddingImages) throws JRException {
        JasperExportManager.getDefaultInstance().exportToXmlFile(jasperPrint, destFileName, isEmbeddingImages);
    }

    public static void exportReportToXmlStream(InputStream inputStream, OutputStream outputStream) throws JRException {
        JasperExportManager.getDefaultInstance().exportToXmlStream(inputStream, outputStream);
    }

    public static void exportReportToXmlStream(JasperPrint jasperPrint, OutputStream outputStream) throws JRException {
        JasperExportManager.getDefaultInstance().exportToXmlStream(jasperPrint, outputStream);
    }

    public static String exportReportToXml(JasperPrint jasperPrint) throws JRException {
        return JasperExportManager.getDefaultInstance().exportToXml(jasperPrint);
    }

    public static String exportReportToHtmlFile(String sourceFileName) throws JRException {
        return JasperExportManager.getDefaultInstance().exportToHtmlFile(sourceFileName);
    }

    public static void exportReportToHtmlFile(String sourceFileName, String destFileName) throws JRException {
        JasperExportManager.getDefaultInstance().exportToHtmlFile(sourceFileName, destFileName);
    }

    public static void exportReportToHtmlFile(JasperPrint jasperPrint, String destFileName) throws JRException {
        JasperExportManager.getDefaultInstance().exportToHtmlFile(jasperPrint, destFileName);
    }
}

