/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.ref.SoftReference;
import java.net.URL;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRAbstractRenderer;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.RenderableUtil;
import net.sf.jasperreports.engine.type.ImageTypeEnum;
import net.sf.jasperreports.engine.type.OnErrorTypeEnum;
import net.sf.jasperreports.engine.type.RenderableTypeEnum;
import net.sf.jasperreports.engine.util.JRImageLoader;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRTypeSniffer;
import net.sf.jasperreports.repo.RepositoryUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRImageRenderer
extends JRAbstractRenderer {
    private static final long serialVersionUID = 10200L;
    private static final Log log = LogFactory.getLog(JRImageRenderer.class);
    private byte[] imageData;
    private String imageLocation;
    private ImageTypeEnum imageTypeValue = ImageTypeEnum.UNKNOWN;
    private transient SoftReference<Image> awtImageRef;
    private int PSEUDO_SERIAL_VERSION_UID = 50502;
    private byte imageType;

    protected JRImageRenderer(byte[] imageData) {
        this.imageData = imageData;
        if (imageData != null) {
            this.imageTypeValue = JRTypeSniffer.getImageTypeValue(imageData);
        }
    }

    protected JRImageRenderer(String imageLocation) {
        this.imageLocation = imageLocation;
    }

    public static JRImageRenderer getInstance(byte[] imageData) {
        return new JRImageRenderer(imageData);
    }

    public static JRRenderable getInstance(String imageLocation) throws JRException {
        return RenderableUtil.getInstance(DefaultJasperReportsContext.getInstance()).getRenderable(imageLocation);
    }

    public static JRRenderable getInstance(String imageLocation, OnErrorTypeEnum onErrorType) throws JRException {
        return RenderableUtil.getInstance(DefaultJasperReportsContext.getInstance()).getRenderable(imageLocation, onErrorType);
    }

    public static JRRenderable getInstance(String imageLocation, OnErrorTypeEnum onErrorType, boolean isLazy) throws JRException {
        return RenderableUtil.getInstance(DefaultJasperReportsContext.getInstance()).getRenderable(imageLocation, onErrorType, isLazy);
    }

    public static JRRenderable getInstance(Image img, OnErrorTypeEnum onErrorType) throws JRException {
        ColorModel colorModel;
        ImageTypeEnum type = ImageTypeEnum.JPEG;
        if (img instanceof RenderedImage && (colorModel = ((RenderedImage)((Object)img)).getColorModel()).hasAlpha() && colorModel.getTransparency() != 1) {
            type = ImageTypeEnum.PNG;
        }
        return JRImageRenderer.getInstance(img, type.getValue(), onErrorType);
    }

    public static JRRenderable getInstance(Image image, byte imageType, OnErrorTypeEnum onErrorType) throws JRException {
        try {
            return new JRImageRenderer(JRImageLoader.loadImageDataFromAWTImage(image, imageType));
        }
        catch (JRException e) {
            return JRImageRenderer.getOnErrorRenderer(onErrorType, e);
        }
    }

    public static JRRenderable getInstance(InputStream is, OnErrorTypeEnum onErrorType) throws JRException {
        try {
            return new JRImageRenderer(JRLoader.loadBytes(is));
        }
        catch (JRException e) {
            return JRImageRenderer.getOnErrorRenderer(onErrorType, e);
        }
    }

    public static JRRenderable getInstance(URL url, OnErrorTypeEnum onErrorType) throws JRException {
        try {
            return new JRImageRenderer(JRLoader.loadBytes(url));
        }
        catch (JRException e) {
            return JRImageRenderer.getOnErrorRenderer(onErrorType, e);
        }
    }

    public static JRRenderable getInstance(File file, OnErrorTypeEnum onErrorType) throws JRException {
        try {
            return new JRImageRenderer(JRLoader.loadBytes(file));
        }
        catch (JRException e) {
            return JRImageRenderer.getOnErrorRenderer(onErrorType, e);
        }
    }

    public static JRRenderable getOnErrorRendererForDimension(JRRenderable renderer, OnErrorTypeEnum onErrorType) throws JRException {
        try {
            renderer.getDimension();
            return renderer;
        }
        catch (JRException e) {
            return JRImageRenderer.getOnErrorRenderer(onErrorType, e);
        }
    }

    public static JRRenderable getOnErrorRendererForImageData(JRRenderable renderer, OnErrorTypeEnum onErrorType) throws JRException {
        try {
            renderer.getImageData();
            return renderer;
        }
        catch (JRException e) {
            return JRImageRenderer.getOnErrorRenderer(onErrorType, e);
        }
    }

    public static JRImageRenderer getOnErrorRendererForImage(JasperReportsContext jasperReportsContext, JRImageRenderer renderer, OnErrorTypeEnum onErrorType) throws JRException {
        JRImageRenderer result;
        block4: {
            try {
                renderer.getImage(jasperReportsContext);
                result = renderer;
            }
            catch (JRException e) {
                result = JRImageRenderer.getOnErrorRenderer(onErrorType, e);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("handled image error with type " + onErrorType), (Throwable)e);
                }
            }
            catch (JRRuntimeException e) {
                result = JRImageRenderer.getOnErrorRenderer(onErrorType, e);
                if (!log.isDebugEnabled()) break block4;
                log.debug((Object)("handled image error with type " + onErrorType), (Throwable)e);
            }
        }
        return result;
    }

    public static JRImageRenderer getOnErrorRendererForImage(JRImageRenderer renderer, OnErrorTypeEnum onErrorType) throws JRException {
        return JRImageRenderer.getOnErrorRendererForImage(DefaultJasperReportsContext.getInstance(), renderer, onErrorType);
    }

    public static JRImageRenderer getOnErrorRenderer(OnErrorTypeEnum onErrorType, JRException e) throws JRException {
        JRImageRenderer renderer = null;
        switch (onErrorType) {
            case ICON: {
                renderer = new JRImageRenderer("net/sf/jasperreports/engine/images/image-16.png");
                break;
            }
            case BLANK: {
                break;
            }
            default: {
                throw e;
            }
        }
        return renderer;
    }

    public static JRImageRenderer getOnErrorRenderer(OnErrorTypeEnum onErrorType, JRRuntimeException e) throws JRRuntimeException {
        JRImageRenderer renderer = null;
        switch (onErrorType) {
            case ICON: {
                renderer = new JRImageRenderer("net/sf/jasperreports/engine/images/image-16.png");
                break;
            }
            case BLANK: {
                break;
            }
            default: {
                throw e;
            }
        }
        return renderer;
    }

    public Image getImage(JasperReportsContext jasperReportsContext) throws JRException {
        if (this.awtImageRef == null || this.awtImageRef.get() == null) {
            Image awtImage = JRImageLoader.getInstance(jasperReportsContext).loadAwtImageFromBytes(this.getImageData(jasperReportsContext));
            this.awtImageRef = new SoftReference<Image>(awtImage);
        }
        return this.awtImageRef.get();
    }

    public Image getImage() throws JRException {
        return this.getImage(DefaultJasperReportsContext.getInstance());
    }

    public String getImageLocation() {
        return this.imageLocation;
    }

    @Override
    public byte getType() {
        return this.getTypeValue().getValue();
    }

    @Override
    public byte getImageType() {
        return this.getImageTypeValue().getValue();
    }

    @Override
    public RenderableTypeEnum getTypeValue() {
        return RenderableTypeEnum.IMAGE;
    }

    @Override
    public ImageTypeEnum getImageTypeValue() {
        return this.imageTypeValue;
    }

    @Override
    public Dimension2D getDimension() throws JRException {
        return this.getDimension(DefaultJasperReportsContext.getInstance());
    }

    @Override
    public Dimension2D getDimension(JasperReportsContext jasperReportsContext) throws JRException {
        Image img = this.getImage(jasperReportsContext);
        return new Dimension(img.getWidth(null), img.getHeight(null));
    }

    @Override
    public byte[] getImageData(JasperReportsContext jasperReportsContext) throws JRException {
        if (this.imageData == null) {
            this.imageData = RepositoryUtil.getInstance(jasperReportsContext).getBytesFromLocation(this.imageLocation);
            if (this.imageData != null) {
                this.imageTypeValue = JRTypeSniffer.getImageTypeValue(this.imageData);
            }
        }
        return this.imageData;
    }

    @Override
    public byte[] getImageData() throws JRException {
        return this.getImageData(DefaultJasperReportsContext.getInstance());
    }

    @Override
    public void render(Graphics2D grx, Rectangle2D rectangle) throws JRException {
        this.render(DefaultJasperReportsContext.getInstance(), grx, rectangle);
    }

    @Override
    public void render(JasperReportsContext jasperReportsContext, Graphics2D grx, Rectangle2D rectangle) throws JRException {
        Image img = this.getImage(jasperReportsContext);
        grx.drawImage(img, (int)rectangle.getX(), (int)rectangle.getY(), (int)rectangle.getWidth(), (int)rectangle.getHeight(), null);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.PSEUDO_SERIAL_VERSION_UID < 40600) {
            this.imageTypeValue = ImageTypeEnum.getByValue(this.imageType);
        }
    }
}

