/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.data.AbstractDataAdapterService;
import net.sf.jasperreports.data.ClasspathAwareDataAdapter;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.util.CompositeClassloader;
import net.sf.jasperreports.engine.util.SimpleFileResolver;

public abstract class AbstractClasspathAwareDataAdapterService
extends AbstractDataAdapterService {
    public static final String CURRENT_CLASS_LOADER = "CURRENT_CLASS_LOADER";

    public AbstractClasspathAwareDataAdapterService(JasperReportsContext jasperReportsContext, ClasspathAwareDataAdapter dataAdapter) {
        super(jasperReportsContext, dataAdapter);
    }

    public AbstractClasspathAwareDataAdapterService(ClasspathAwareDataAdapter dataAdapter) {
        this((JasperReportsContext)DefaultJasperReportsContext.getInstance(), dataAdapter);
    }

    protected ClassLoader getClassLoader(ClassLoader cloader) {
        Object obj = this.getJasperReportsContext().getValue(CURRENT_CLASS_LOADER);
        if (obj != null && obj instanceof ClassLoader) {
            cloader = (ClassLoader)obj;
        }
        return new CompositeClassloader(this.getPathClassloader(), cloader);
    }

    private ClassLoader getPathClassloader() {
        SimpleFileResolver fileResolver = null;
        if (fileResolver == null) {
            SimpleFileResolver sfr = new SimpleFileResolver(new File("."));
            sfr.setResolveAbsolutePath(true);
            fileResolver = sfr;
        }
        ClasspathAwareDataAdapter dataAdapter = (ClasspathAwareDataAdapter)this.getDataAdapter();
        List<String> classpath = dataAdapter.getClasspath();
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String path : classpath) {
            File file = fileResolver.resolveFile(path);
            if (file == null || !file.exists()) continue;
            try {
                urls.add(file.toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return new URLClassLoader(urls.toArray(new URL[urls.size()]));
    }
}

