/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.crosstabs.fill.calculation;

import net.sf.jasperreports.crosstabs.fill.calculation.BucketDefinition;
import net.sf.jasperreports.crosstabs.fill.calculation.MeasureDefinition;

public class CrosstabCell {
    private final BucketDefinition.Bucket[] rowBucketValues;
    private final int rowTotalGroupIndex;
    private final BucketDefinition.Bucket[] columnBucketValues;
    private final int columnTotalGroupIndex;
    private final MeasureDefinition.MeasureValue[] mesureValues;
    private final MeasureDefinition.MeasureValue[][][] totals;

    public CrosstabCell(BucketDefinition.Bucket[] rowBucketValues, BucketDefinition.Bucket[] columnBucketValues, MeasureDefinition.MeasureValue[] mesureValues, MeasureDefinition.MeasureValue[][][] totals) {
        this.rowBucketValues = rowBucketValues;
        this.rowTotalGroupIndex = CrosstabCell.getTotalIndex(rowBucketValues);
        this.columnBucketValues = columnBucketValues;
        this.columnTotalGroupIndex = CrosstabCell.getTotalIndex(columnBucketValues);
        this.mesureValues = mesureValues;
        this.totals = totals;
    }

    private static int getTotalIndex(BucketDefinition.Bucket[] values) {
        int i = 0;
        while (i < values.length && !values[i].isTotal()) {
            ++i;
        }
        return i;
    }

    public MeasureDefinition.MeasureValue[] getMesureValues() {
        return this.mesureValues;
    }

    public BucketDefinition.Bucket[] getColumnBucketValues() {
        return this.columnBucketValues;
    }

    public BucketDefinition.Bucket[] getRowBucketValues() {
        return this.rowBucketValues;
    }

    public int getColumnTotalGroupIndex() {
        return this.columnTotalGroupIndex;
    }

    public int getRowTotalGroupIndex() {
        return this.rowTotalGroupIndex;
    }

    public MeasureDefinition.MeasureValue[][][] getTotals() {
        return this.totals;
    }
}

