/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.util.update;

import br.gov.serpro.updater.AtualizacaoException;
import br.gov.serpro.updater.PgdUpdater;
import br.gov.serpro.updater.ReleaseUpdateProperties;
import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.logging.Level;
import jupar.Downloader;
import jupar.objects.Release;
import org.apache.commons.io.FileUtils;
import serpro.ppgd.app.ConstantesMensagens;
import serpro.ppgd.irpf.exception.AplicacaoException;
import serpro.ppgd.irpf.util.AplicacaoPropertiesUtil;
import serpro.ppgd.irpf.util.ConstantesGlobaisIRPF;
import serpro.ppgd.irpf.util.update.IRPFUpdateProperties;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.ppgd.negocio.util.UtilitariosArquivo;

public class IRPFUpdater {
    private final String NOME_ARQ_LATEST = "latest.xml";
    private final String NOME_ARQ_PROPRIEDADES = "release_properties.xml";
    private final String NOME_ARQ_UPDATE_JAR = "pgd-updater.jar";
    private final String PATH_PASTA_UPDATE_DESENVOLVIMENTO = "http://webdesdr.sdr.serpro/de5ps/irpf-update-desenvolvimento/" + ConstantesGlobais.EXERCICIO + "/update/";
    private final String PATH_PASTA_UPDATE_HOMOLOGACAO = "https://downloadirpf.receita.fazenda.gov.br/irpf/HOM/" + ConstantesGlobais.EXERCICIO + "/update/";
    private final String PATH_PASTA_UPDATE_PRODUCAO = "https://downloadirpf.receita.fazenda.gov.br/irpf/" + ConstantesGlobais.EXERCICIO + "/irpf/update/";
    private final String PATH_ENDERECO_UPDATE_DESENVOLVIMENTO = this.PATH_PASTA_UPDATE_DESENVOLVIMENTO + "latest.xml";
    private final String PATH_ENDERECO_UPDATE_HOMOLOGACAO = this.PATH_PASTA_UPDATE_HOMOLOGACAO + "latest.xml";
    private final String PATH_ENDERECO_UPDATE_PRODUCAO = this.PATH_PASTA_UPDATE_PRODUCAO + "latest.xml";
    private final String NOME_PASTA_TEMP = "tmp_IRPF" + ConstantesGlobais.EXERCICIO;
    private final String NOME_PASTA_APLICATIVO = ".irpf";
    private final String NOME_IRPF_APP_MAC = "IRPF" + ConstantesGlobais.EXERCICIO + ".app";
    private final String NOME_IRPF_EXE_WIN = "IRPF" + ConstantesGlobais.EXERCICIO + ".exe";
    public static final int TIPO_AMBIENTE_UPDATER_DESENVOLVIMENTO = 1;
    public static final int TIPO_AMBIENTE_UPDATER_HOMOLOGACAO = 2;
    public static final int TIPO_AMBIENTE_UPDATER_PRODUCAO = 3;
    private int ambienteUpdater = 2;
    private PgdUpdater updater = null;
    private File pastaBase = null;
    private static IRPFUpdater instance = null;
    private Release ultimaVersao;

    protected IRPFUpdater() {
    }

    public static IRPFUpdater getInstance() {
        if (instance == null) {
            instance = new IRPFUpdater();
        }
        return instance;
    }

    protected PgdUpdater getPgdUpdater() {
        if (this.updater == null) {
            this.updater = new PgdUpdater();
            this.updater.setReleasePropertiesPath(new File(UtilitariosArquivo.getPathDados() + File.separator + "release_properties.xml").getAbsolutePath());
            try {
                this.updater.setLogFile(new File(UtilitariosArquivo.getPathUsuario() + File.separator + "updater.log"));
            }
            catch (AtualizacaoException e) {
                LogPPGD.erro((String)e.getMessage());
            }
        }
        return this.updater;
    }

    protected String obterIdentificadorVersao(String versao, String release) {
        Object strVersao = versao;
        try {
            if (release != null && release.trim().length() > 0 && Integer.parseInt(release) > 0) {
                strVersao = (String)strVersao + "_Testes_" + release;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return strVersao;
    }

    protected IRPFUpdateProperties obterUpdateProperties(Release latest) throws AplicacaoException {
        try {
            String ultimaVersao = this.obterIdentificadorVersao(latest.getPkgver(), latest.getPkgrel());
            String versaoAtual = this.obterIdentificadorVersao(AplicacaoPropertiesUtil.getVersao(), ConstantesGlobaisIRPF.VERSAO_TESTES ? AplicacaoPropertiesUtil.getVersaoTeste() : null);
            Gson g = new Gson();
            IRPFUpdateProperties updateProperties = (IRPFUpdateProperties)g.fromJson(latest.getMessage(), IRPFUpdateProperties.class);
            updateProperties.setUltimaVersao(ultimaVersao);
            updateProperties.setVersaoAtual(versaoAtual);
            updateProperties.setTipoAtualizacao(IRPFUpdateProperties.TipoAtualizacao.valueOf(latest.getSeverity()));
            if (updateProperties.getArquivoZip() != null && updateProperties.getArquivoZip().trim().length() > 0) {
                updateProperties.setArquivoZip(updateProperties.getArquivoZip().replaceAll("\\@", updateProperties.getVersaoAtual() + "_update_" + updateProperties.getUltimaVersao()));
            }
            if (updateProperties.getUltimaVersaoManual() != null && !updateProperties.getUltimaVersaoManual().trim().isEmpty()) {
                Release relVersaoManual = new Release();
                Release relVersaoAtual = new Release();
                relVersaoAtual.setPkgver(AplicacaoPropertiesUtil.getVersao());
                relVersaoAtual.setPkgrel(AplicacaoPropertiesUtil.getVersaoTeste());
                String[] versaoManual = updateProperties.getUltimaVersaoManual().split("_");
                relVersaoManual.setPkgver(versaoManual[0]);
                if (versaoManual.length > 1) {
                    relVersaoManual.setPkgrel(versaoManual[1]);
                }
                updateProperties.setDownloadManual(relVersaoManual.compareTo((Object)relVersaoAtual) > 0);
            }
            return updateProperties;
        }
        catch (Exception e) {
            throw new AplicacaoException("atualizar.erro.generico", e);
        }
    }

    public IRPFUpdateProperties temAtualizacaoCompletada() throws AplicacaoException {
        PgdUpdater updater = this.getPgdUpdater();
        IRPFUpdateProperties irpfProperties = null;
        try {
            ReleaseUpdateProperties properies = updater.getReleaseUpdateProperties();
            if (properies != null && properies.getUpdateStatus() == ReleaseUpdateProperties.UpdateStatus.UpdateCompleted) {
                irpfProperties = this.obterUpdateProperties(properies.getLatestRelease());
            }
        }
        catch (AtualizacaoException e) {
            throw new AplicacaoException("atualizar.erro.generico", e);
        }
        return irpfProperties;
    }

    public IRPFUpdateProperties atualizacaoPendente() throws AplicacaoException {
        PgdUpdater updater = this.getPgdUpdater();
        IRPFUpdateProperties updateProperties = null;
        try {
            ReleaseUpdateProperties releaseProperties = updater.registerUpdateStatusUpdateNotStarted();
            if (releaseProperties != null) {
                updateProperties = this.obterUpdateProperties(releaseProperties.getLatestRelease());
            }
        }
        catch (AtualizacaoException e) {
            throw new AplicacaoException("atualizar.erro.generico", e);
        }
        return updateProperties;
    }

    public void resetUpdateStatus() {
        this.getPgdUpdater().resetUpdateStatus();
    }

    public boolean verificarUltimaVersaoAposPeriodo() throws AplicacaoException {
        PgdUpdater updater = this.getPgdUpdater();
        try {
            ReleaseUpdateProperties releaseProperties = updater.getReleaseUpdateProperties();
            if (releaseProperties != null && releaseProperties.getUpdateStatus() != ReleaseUpdateProperties.UpdateStatus.UpdateCompleted) {
                IRPFUpdateProperties updateProperties = this.obterUpdateProperties(releaseProperties.getLatestRelease());
                String dataUltimaConsulta = releaseProperties.getQueryDate();
                Calendar cal = Calendar.getInstance();
                cal.setLenient(false);
                cal.clear();
                cal.set(Integer.parseInt(dataUltimaConsulta.substring(0, 4)), Integer.parseInt(dataUltimaConsulta.substring(4, 6)) - 1, Integer.parseInt(dataUltimaConsulta.substring(6, 8)), Integer.parseInt(dataUltimaConsulta.substring(8, 10)), Integer.parseInt(dataUltimaConsulta.substring(10, 12)));
                cal.add(12, updateProperties.getPeriodoEspera());
                long dataProximaConsulta = Long.parseLong(updater.getDateTime(cal.getTime()));
                long dataAtual = Long.parseLong(updater.getDateTime(new Date()));
                if (dataAtual <= dataProximaConsulta) {
                    return false;
                }
            }
        }
        catch (AtualizacaoException | NumberFormatException e) {
            throw new AplicacaoException("atualizar.erro.generico", e);
        }
        return true;
    }

    public IRPFUpdateProperties obterUpdatePropertiesUltimaVersao() throws AplicacaoException {
        Release versaoAtual;
        IRPFUpdateProperties updateProperties = null;
        if (this.ultimaVersao != null && this.ultimaVersao.compareTo((Object)(versaoAtual = new Release(AplicacaoPropertiesUtil.getVersao(), AplicacaoPropertiesUtil.getVersaoTeste()))) > 0) {
            updateProperties = this.obterUpdateProperties(this.ultimaVersao);
        }
        return updateProperties;
    }

    public Release verificarUltimaVersao() throws AplicacaoException {
        try {
            this.ultimaVersao = this.getPgdUpdater().getLatestRelease(this.getEnderecoArqUltimaVersao());
            return this.ultimaVersao;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AplicacaoException(ConstantesMensagens.ConstantesEnum.MSG_ATUALIZAR_ERRO_VERIFICACAO.getChave(), e);
        }
    }

    public boolean temNovaVersaoArquivo(String idArquivo, String h) {
        Release.FileInfo ultimaVersaoArquivo = (Release.FileInfo)this.ultimaVersao.getFiles().get(idArquivo);
        return ultimaVersaoArquivo != null && !h.equals(ultimaVersaoArquivo.getHash());
    }

    public IRPFUpdateProperties verificarUltimaVersaoOnline() throws AplicacaoException {
        this.verificarUltimaVersao();
        IRPFUpdateProperties updateProperties = this.obterUpdatePropertiesUltimaVersao();
        return updateProperties;
    }

    public String getJavaCommand() {
        Object javaCommand = "java";
        File javaHomePath = new File(System.getProperty("java.home") + File.separator + "bin");
        if (javaHomePath.exists() && javaHomePath.isDirectory()) {
            javaCommand = javaHomePath.getAbsolutePath() + File.separator + (String)javaCommand;
        }
        return javaCommand;
    }

    public void execNavegador(String endereco) throws AplicacaoException {
        File baseDir = this.obterPastaBase();
        File updaterJar = new File(baseDir, "pgd-updater.jar");
        ArrayList<Object> cmd = new ArrayList<Object>();
        cmd.add(this.getJavaCommand());
        cmd.add("-jar");
        cmd.add(updaterJar.getAbsolutePath());
        cmd.add("-B");
        cmd.add("-appName");
        cmd.add("IRPF" + ConstantesGlobais.EXERCICIO);
        cmd.add("-url");
        cmd.add(endereco);
        System.err.println("cmdDir=" + baseDir);
        System.err.println("cmd=" + cmd.toString());
        try {
            Runtime.getRuntime().exec(cmd.toArray(new String[0]), null, baseDir);
        }
        catch (Throwable ex) {
            throw new AplicacaoException("atualizar.erro.navegador", new String[]{endereco, ConstantesGlobais.EXERCICIO}, ex);
        }
    }

    public void execUpdate(IRPFUpdateProperties updateProperties) throws AplicacaoException {
        File baseDir = this.obterPastaBase();
        String releaseUpdateProperties = this.getPgdUpdater().getReleasePropertiesPath();
        File updaterJar = new File(baseDir, "pgd-updater.jar");
        File tempDir = this.obterPastaTemp();
        File logFile = this.getPgdUpdater().getLogFile();
        Object comando = null;
        ArrayList<Object> cmd = new ArrayList<Object>();
        String javaCommand = this.getJavaCommand();
        File irpfExecFile = null;
        comando = FabricaUtilitarios.isWindows() && (irpfExecFile = new File(baseDir, this.NOME_IRPF_EXE_WIN)).exists() ? irpfExecFile.getAbsolutePath() : (FabricaUtilitarios.isMac() && (irpfExecFile = new File(baseDir.getParentFile().getParentFile().getParentFile(), this.NOME_IRPF_APP_MAC)).exists() ? "open#" + irpfExecFile.getAbsolutePath() : javaCommand + "#-jar#irpf.jar");
        cmd.add(javaCommand);
        cmd.add("-jar");
        cmd.add(updaterJar.getAbsolutePath());
        cmd.add("-U");
        cmd.add("-W");
        cmd.add("-appName");
        cmd.add("IRPF" + ConstantesGlobais.EXERCICIO);
        cmd.add("-tempDir");
        cmd.add(tempDir.getAbsolutePath());
        cmd.add("-destDir");
        cmd.add(baseDir.getAbsolutePath());
        cmd.add("-zipFile");
        cmd.add(updateProperties.getArquivoZip());
        cmd.add("-releaseUpdateProperties");
        cmd.add(releaseUpdateProperties);
        cmd.add("-logFile");
        cmd.add(logFile.getAbsolutePath());
        cmd.add("-appComandSeparator");
        cmd.add("#");
        cmd.add("-appComand");
        cmd.add(comando);
        System.err.println("cmdDir=" + baseDir);
        System.err.println("cmd=" + cmd.toString());
        try {
            Runtime.getRuntime().exec(cmd.toArray(new String[0]), null, baseDir);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            LogPPGD.erro((String)ex.getMessage());
            throw new AplicacaoException("atualizar.erro.update", ex);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            LogPPGD.erro((String)ex.getMessage());
            throw new AplicacaoException("atualizar.erro.update", ex);
        }
    }

    public File criarPastaTemporaria() throws AplicacaoException {
        File tempDir = this.obterPastaTemp();
        try {
            if (tempDir.exists()) {
                FileUtils.deleteDirectory((File)tempDir);
            }
            FileUtils.forceMkdir((File)tempDir);
        }
        catch (IOException e) {
            LogPPGD.erro((String)e.getMessage());
            throw new AplicacaoException("atualizar.erro.download", e);
        }
        return tempDir;
    }

    public void update(Collection<String> filesIds) throws AplicacaoException {
        String[] zipFilesNames = new String[filesIds.size()];
        String[] filesPaths = new String[filesIds.size()];
        int i = 0;
        for (String id : filesIds) {
            Release.FileInfo fileInfo = (Release.FileInfo)this.ultimaVersao.getFiles().get(id);
            if (fileInfo != null) {
                zipFilesNames[i] = fileInfo.getPackName();
                filesPaths[i] = fileInfo.getPath();
            }
            ++i;
        }
        try {
            this.getPgdUpdater().updateFiles(this.obterPastaTemp().getAbsolutePath(), this.obterPastaBase().getAbsolutePath(), zipFilesNames, filesPaths);
        }
        catch (AtualizacaoException e) {
            e.printStackTrace();
            LogPPGD.erro((String)e.getMessage());
            throw new AplicacaoException("atualizar.erro.update", e);
        }
    }

    public void download(Collection<String> filesIds, Downloader.DownloadProgress progress) throws AplicacaoException {
        PgdUpdater updater = this.getPgdUpdater();
        updater.setDownloadProgress(progress);
        IRPFUpdateProperties updateProperties = (IRPFUpdateProperties)new Gson().fromJson(this.ultimaVersao.getMessage(), IRPFUpdateProperties.class);
        File tempDir = this.criarPastaTemporaria();
        try {
            updater.getLogger().log(Level.INFO, "Iniciando download de arquivos internos: {0}.", filesIds);
            String[] zipFilesNames = new String[filesIds.size()];
            int i = 0;
            Iterator<String> iterator = filesIds.iterator();
            while (iterator.hasNext()) {
                Release.FileInfo fileInfo = (Release.FileInfo)this.ultimaVersao.getFiles().get(iterator.next());
                if (fileInfo != null) {
                    zipFilesNames[i] = fileInfo.getPackName();
                }
                ++i;
            }
            updater.executarDownload(updateProperties.getEnderecoServidor(), tempDir.getAbsolutePath(), zipFilesNames);
        }
        catch (AtualizacaoException e) {
            Throwable t = e;
            while (t.getCause() != null) {
                t = t.getCause();
            }
            if (t instanceof SocketTimeoutException) {
                throw new AplicacaoException("atualizar.erro.download.timeout", e);
            }
            throw new AplicacaoException("atualizar.erro.download", e);
        }
    }

    public void download(IRPFUpdateProperties updateProperties, Downloader.DownloadProgress progress) throws AplicacaoException {
        PgdUpdater updater = this.getPgdUpdater();
        updater.setDownloadProgress(progress);
        File tempDir = this.criarPastaTemporaria();
        try {
            updater.getLogger().info("Iniciando download da vers\u00e3o: " + updateProperties.getUltimaVersao() + " (" + updateProperties.getTipoAtualizacao() + "). Vers\u00e3o Atual: " + updateProperties.getVersaoAtual() + ".");
            updater.executarDownload(updateProperties.getEnderecoServidor(), tempDir.getAbsolutePath(), updateProperties.getArquivoZip());
        }
        catch (AtualizacaoException e) {
            Throwable t = e;
            while (t.getCause() != null) {
                t = t.getCause();
            }
            if (t instanceof SocketTimeoutException) {
                throw new AplicacaoException("atualizar.erro.download.timeout", e);
            }
            throw new AplicacaoException("atualizar.erro.download", e);
        }
    }

    public boolean temPermissaoEscritaPastaBase() {
        try {
            return this.obterPastaBase() != null;
        }
        catch (AplicacaoException aplicacaoException) {
            return false;
        }
    }

    public boolean temPermissaoEscritaPasta(File pasta) {
        try {
            File arquivoTeste = new File(pasta, "test.txt");
            if (!arquivoTeste.createNewFile()) {
                LogPPGD.erro((String)"Erro criando arquivoTeste");
            }
            if (!arquivoTeste.delete()) {
                LogPPGD.erro((String)"Erro deletando arquivoTeste");
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public File obterPastaTemp() throws AplicacaoException {
        return new File(this.obterPastaAplicativo(), this.NOME_PASTA_TEMP);
    }

    public File obterPastaAplicativo() throws AplicacaoException {
        File appHomeDir = null;
        try {
            appHomeDir = new File(new File(System.getProperty("user.home")), ".irpf");
            if (!appHomeDir.exists()) {
                FileUtils.forceMkdir((File)appHomeDir);
            }
        }
        catch (Exception e) {
            LogPPGD.erro((String)e.getMessage());
            throw new AplicacaoException("atualizar.erro.generico", e);
        }
        return appHomeDir;
    }

    public File obterPastaBase() throws AplicacaoException {
        if (this.pastaBase == null) {
            try {
                this.pastaBase = new File(Class.forName("serpro.ppgd.app.IRPFPGD").getProtectionDomain().getCodeSource().getLocation().toURI());
            }
            catch (Exception ex) {
                throw new AplicacaoException("atualizar.erro.generico", ex);
            }
            if (this.pastaBase.isFile()) {
                this.pastaBase = this.pastaBase.getParentFile();
            }
            if (!this.temPermissaoEscritaPasta(this.pastaBase)) {
                throw new AplicacaoException("atualizar.erro.generico");
            }
        }
        return this.pastaBase;
    }

    public String getEnderecoArqUltimaVersao() {
        if (ConstantesGlobaisIRPF.VERSAO_TESTES) {
            if (this.getAmbienteUpdater() == 1) {
                return this.PATH_ENDERECO_UPDATE_DESENVOLVIMENTO;
            }
            return this.PATH_ENDERECO_UPDATE_HOMOLOGACAO;
        }
        return this.PATH_ENDERECO_UPDATE_PRODUCAO;
    }

    public int getAmbienteUpdater() {
        return this.ambienteUpdater;
    }

    public void setAmbienteUpdater(int ambienteUpdater) {
        this.ambienteUpdater = ambienteUpdater;
    }

    public Release getUltimaVersao() {
        return this.ultimaVersao;
    }
}

