/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Stack;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class ZipHelper {
    public void zip(File[] files, File outputFile) throws IOException {
        if (files != null && files.length > 0) {
            try (ZipOutputStream out = new ZipOutputStream(new FileOutputStream(outputFile));){
                Stack<File> parentDirs = new Stack<File>();
                this.zipFiles(parentDirs, files, out);
                out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void zipFiles(Stack<File> parentDirs, File[] files, ZipOutputStream out) throws IOException {
        byte[] buf = new byte[1024];
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                parentDirs.push(files[i]);
                this.zipFiles(parentDirs, files[i].listFiles(), out);
                parentDirs.pop();
                continue;
            }
            try (FileInputStream in = new FileInputStream(files[i]);){
                int len;
                Object path = "";
                for (File parentDir : parentDirs) {
                    path = (String)path + parentDir.getName() + "/";
                }
                out.putNextEntry(new ZipEntry((String)path + files[i].getName()));
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                out.closeEntry();
                in.close();
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unzip(File zipFile, File dir) throws IOException {
        try (ZipFile zip = new ZipFile(zipFile);){
            File arquivo = null;
            byte[] buffer = new byte[1024];
            try {
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                if (!dir.exists() || !dir.isDirectory()) {
                    throw new IOException("O diret\u00f3rio " + dir.getName() + " n\u00e3o \u00e9 um diret\u00f3rio v\u00e1lido");
                }
                Enumeration<? extends ZipEntry> e = zip.entries();
                while (e.hasMoreElements()) {
                    ZipEntry entrada = e.nextElement();
                    arquivo = new File(dir, entrada.getName());
                    if (entrada.isDirectory() && !arquivo.exists()) {
                        arquivo.mkdirs();
                        continue;
                    }
                    if (!arquivo.getParentFile().exists()) {
                        arquivo.getParentFile().mkdirs();
                    }
                    if (arquivo.isDirectory()) continue;
                    try {
                        InputStream is = zip.getInputStream(entrada);
                        try (FileOutputStream os = new FileOutputStream(arquivo);){
                            int bytesLidos = 0;
                            if (is == null) {
                                throw new ZipException("Erro ao ler a entrada do zip: " + entrada.getName());
                            }
                            while ((bytesLidos = is.read(buffer)) > 0) {
                                ((OutputStream)os).write(buffer, 0, bytesLidos);
                            }
                        }
                        finally {
                            if (is == null) continue;
                            is.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (zip != null) {
                    try {
                        zip.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

