/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.JOptionPane;
import javax.swing.SortOrder;
import serpro.ppgd.formatosexternos.txt.excecao.GeracaoTxtException;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.dependentes.Dependente;
import serpro.ppgd.irpf.gui.NavegadorHtml;
import serpro.ppgd.irpf.txt.gravacaorestauracao.GravadorTXT;
import serpro.ppgd.irpf.txt.gravacaorestauracao.ImportadorTxt;
import serpro.ppgd.irpf.txt.gravacaorestauracao.RepositorioDeclaracaoCentralTxt;
import serpro.ppgd.irpf.txt.importacao.carneleao.FiltroCPFCarneLeao;
import serpro.ppgd.irpf.txt.importacao.gcap.ProcessoImportacaoGCAP;
import serpro.ppgd.irpf.txt.util.IRPFTxtUtil;
import serpro.ppgd.irpf.util.AplicacaoPropertiesUtil;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.ppgd.negocio.util.UtilitariosArquivo;
import serpro.ppgd.negocio.util.Validador;

public class IRPFUtil {
    private static final String ARQUIVO_INI = "IRPF" + ConstantesGlobais.EXERCICIO + ".INI";
    public static final int EM_PREENCHIMENTO = 0;
    public static final int EM_PENDENCIA = 1;
    public static final int EM_IMPORTACAO = 2;
    public static final int EM_ABERTURA = 3;
    private static String nomeArquivo = null;
    private static int estadoSistema = 0;
    private static boolean temDeclaracaoAberta = false;
    public static String DIR_DADOS;
    public static String DIR_TMP;
    public static boolean usaAcessibilidade;

    public static void atualizaTituloDeclaracaoAberta() {
        String tit = FabricaUtilitarios.getProperties().getProperty("titulo");
        String fase = FabricaUtilitarios.getProperties().getProperty("fase");
        String versao = FabricaUtilitarios.getProperties().getProperty("versao");
        String versao_teste = FabricaUtilitarios.getProperties().getProperty("versao_teste");
        if (IRPFUtil.isAccessibleMode()) {
            return;
        }
        String ajuste = "";
        ajuste = IRPFFacade.getInstancia().getIdDeclaracaoAberto().isEspolio() ? "DECLARA\u00c7\u00c3O FINAL DE ESP\u00d3LIO" : (IRPFFacade.getInstancia().getIdDeclaracaoAberto().isSaida() ? "DECLARA\u00c7\u00c3O DE SA\u00cdDA DEFINITIVA DO PA\u00cdS" : "DECLARA\u00c7\u00c3O DE AJUSTE ANUAL");
    }

    public static boolean isAccessibleMode() {
        return usaAcessibilidade;
    }

    private static void gerarTituloInicial() {
        String tit = FabricaUtilitarios.getProperties().getProperty("titulo");
        String fase = FabricaUtilitarios.getProperties().getProperty("fase");
        String versao = FabricaUtilitarios.getProperties().getProperty("versao");
        String versao_teste = FabricaUtilitarios.getProperties().getProperty("versao_teste");
    }

    public static void converterDeclaracao(DeclaracaoIRPF declaracaoIRPF) {
        if (declaracaoIRPF.getIdentificadorDeclaracao().isAjuste()) {
            if (!declaracaoIRPF.getIdentificadorDeclaracao().isCompleta()) {
                declaracaoIRPF.getIdentificadorDeclaracao().getTipoDeclaracao().setConteudo("0");
            } else {
                declaracaoIRPF.getIdentificadorDeclaracao().getTipoDeclaracao().setConteudo("1");
            }
        }
        if (temDeclaracaoAberta) {
            IRPFUtil.atualizaTituloDeclaracaoAberta();
        }
    }

    public static void setEstadoSistema(int estadoSistema) {
        IRPFUtil.estadoSistema = estadoSistema;
    }

    public static int getEstadoSistema() {
        return estadoSistema;
    }

    public static void habilitaAcessibilidade() {
        usaAcessibilidade = !IRPFUtil.isAccessibleMode();
        PlataformaPPGD.getPlataforma().adequarToolbarEsplitAcessiveis(usaAcessibilidade);
        if (usaAcessibilidade) {
            IRPFUtil.atualizaTituloModoAcessivel();
        } else if (temDeclaracaoAberta) {
            IRPFUtil.atualizaTituloDeclaracaoAberta();
        } else {
            IRPFUtil.gerarTituloInicial();
        }
        PlataformaPPGD.getPlataforma().getComponent("mainMenubar").requestFocusInWindow();
        IRPFUtil.persisteStatusAcessibilidade();
    }

    public static void persisteStatusAcessibilidade() {
        Object arqConf = UtilitariosArquivo.getPathAplicacao();
        arqConf = FabricaUtilitarios.isMac() ? (String)arqConf + "../" + ARQUIVO_INI : (String)arqConf + ARQUIVO_INI;
        Properties prop = new Properties();
        if (new File((String)arqConf).exists()) {
            try {
                prop.load(new FileInputStream((String)arqConf));
            }
            catch (Exception e) {
                LogPPGD.aviso((String)("Nao foi poss\u00edvel carregar o arquivo : " + (String)arqConf));
            }
        }
        prop.setProperty("aplicacao.acessibilidade.habilitado", Boolean.toString(usaAcessibilidade));
        try {
            prop.store(new FileOutputStream((String)arqConf), null);
        }
        catch (Exception e) {
            LogPPGD.aviso((String)("Nao foi poss\u00edvel gravar no arquivo : " + (String)arqConf));
        }
    }

    private static void atualizaTituloModoAcessivel() {
        String titulo = FabricaUtilitarios.getProperties().getProperty("titulo");
    }

    public static void exibirArquivoNavegador(byte[] bytes, String nome) {
        String nomeArq = nomeArquivo == null ? nome : nomeArquivo;
        nomeArquivo = null;
        Object caminho = null;
        caminho = FabricaUtilitarios.isLinux() || FabricaUtilitarios.isMac() ? UtilitariosArquivo.getPathUsuario() : UtilitariosArquivo.getPathAplicacao();
        caminho = (String)caminho + nomeArq;
        try (FileOutputStream stream = new FileOutputStream((String)caminho);){
            stream.write(bytes);
            stream.close();
            String osName = System.getProperty("os.name");
            NavegadorHtml.executarNavegador((URI)new File((String)caminho).toURI());
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            String msg = "Erro ao gerar o PDF, verifique se um PDF gerado anteriormente encontra-se aberto.";
            JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), msg, "Erro", 0);
        }
    }

    public static String getMacAddress() {
        String endereco;
        block4: {
            endereco = "";
            InetAddress enderecoLocal = IRPFUtil.obterConexaoComSiteNaInternet();
            byte[] mac = null;
            try {
                NetworkInterface ni = null;
                if (enderecoLocal != null && (ni = NetworkInterface.getByInetAddress(enderecoLocal)) != null && (mac = ni.getHardwareAddress()) != null && mac.length == 6) {
                    endereco = String.format("%1$02x%2$02x%3$02x%4$02x%5$02x%6$02x", mac[0], mac[1], mac[2], mac[3], mac[4], mac[5]).toUpperCase();
                }
                if (!endereco.isEmpty()) break block4;
                Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
                while (nis.hasMoreElements()) {
                    ni = nis.nextElement();
                    if (ni == null || (mac = ni.getHardwareAddress()) == null || mac.length != 6) continue;
                    endereco = String.format("%1$02x%2$02x%3$02x%4$02x%5$02x%6$02x", mac[0], mac[1], mac[2], mac[3], mac[4], mac[5]).toUpperCase();
                    break;
                }
            }
            catch (SocketException e) {
                LogPPGD.erro((String)e.getMessage());
            }
        }
        return endereco;
    }

    public static Boolean isConectadoInternet() {
        return IRPFUtil.obterConexaoComSiteNaInternet() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private static InetAddress obterConexaoComSiteNaInternet() {
        String[] sitesMaisVisitados = new String[]{"www.receita.fazenda.gov.br", "www.google.com.br", "www.uol.com.br", "www.globo.com", "www.terra.com.br", "www.estadao.com.br"};
        boolean conectou = false;
        int indice = 0;
        DatagramSocket sock = null;
        InetAddress destino = null;
        InetAddress enderecoLocal = null;
        while (!conectou && indice < sitesMaisVisitados.length) {
            try {
                destino = InetAddress.getByName(sitesMaisVisitados[indice++]);
                int porta = IRPFUtil.encontrarPortaNaoUtilizada();
                sock = new DatagramSocket(porta);
                sock.connect(destino, porta);
                enderecoLocal = sock.getLocalAddress();
                conectou = true;
            }
            catch (UnknownHostException e) {
                LogPPGD.erro((String)e.getMessage());
            }
            catch (SocketException e) {
                LogPPGD.erro((String)e.getMessage());
            }
            catch (IOException e) {
                LogPPGD.erro((String)e.getMessage());
            }
            finally {
                if (sock == null) continue;
                sock.close();
            }
        }
        return enderecoLocal;
    }

    private static int encontrarPortaNaoUtilizada() throws IOException {
        try (ServerSocket ss = new ServerSocket(0);){
            int porta = ss.getLocalPort();
            ss.close();
            int n = porta;
            return n;
        }
    }

    public static String obterNomeArquivoPDF(String cpf, String tipo, String opcao, String diferenciador) {
        StringBuilder nome = new StringBuilder();
        if (cpf != null) {
            nome.append(cpf);
            nome.append("-");
        }
        nome.append("IRPF-");
        nome.append(ConstantesGlobais.EXERCICIO);
        nome.append("-");
        nome.append(ConstantesGlobais.ANO_BASE);
        nome.append("-");
        if (tipo != null) {
            nome.append(tipo);
            nome.append("-");
        }
        nome.append("imagem");
        nome.append("-");
        nome.append(opcao);
        if (diferenciador != null) {
            nome.append(diferenciador);
        }
        nome.append(".pdf");
        return nome.toString();
    }

    public static String obterNomeArquivoDarfPDF(String cpf, String tipo, String quota) {
        StringBuilder nome = new StringBuilder();
        if (cpf != null) {
            nome.append(cpf);
            nome.append("-");
        }
        nome.append("IRPF-");
        nome.append(ConstantesGlobais.EXERCICIO);
        nome.append("-");
        nome.append(ConstantesGlobais.ANO_BASE);
        nome.append("-");
        if (tipo != null) {
            nome.append(tipo);
            nome.append("-");
        }
        nome.append("darf");
        nome.append(quota);
        nome.append("quota");
        nome.append(".pdf");
        return nome.toString();
    }

    private static String obterTrechoPorExtenso(String[] card, String sNum, int p0, int p1, int p2, boolean centena) {
        Object aux = "";
        if (sNum.charAt(p1) != ' ' && sNum.charAt(p1) != '0' || sNum.charAt(p2) != ' ' && sNum.charAt(p2) != '0') {
            if (sNum.charAt(p1) == ' ' || sNum.charAt(p1) == '0') {
                aux = card[sNum.charAt(p2) - 48];
            } else if (sNum.charAt(p1) == '1') {
                aux = card[sNum.charAt(p2) - 48 + 10];
            } else {
                aux = card[sNum.charAt(p1) - 48 + 18];
                if (sNum.charAt(p2) != '0') {
                    aux = (String)aux + "e " + card[sNum.charAt(p2) - 48];
                }
            }
        }
        if (centena && sNum.charAt(p0) != ' ' && sNum.charAt(p0) != '0') {
            aux = sNum.charAt(p0) == '1' && ((String)aux).equals("") ? "cem " : card[sNum.charAt(p0) - 48 + 27] + "e " + (String)aux;
        }
        return aux;
    }

    public static String escreverValorMonetarioPorExtenso(String valorMonetario) {
        DecimalFormat df = new DecimalFormat("###,###,##0.00");
        String retorno = "";
        try {
            retorno = IRPFUtil.escreverValorMonetarioPorExtenso(df.parse(valorMonetario).doubleValue());
        }
        catch (ParseException e) {
            LogPPGD.erro((String)e.getMessage());
        }
        return retorno;
    }

    public static String escreverValorMonetarioPorExtenso(double valorMonetario) {
        String[] palavras = new String[37];
        if (valorMonetario > 9.9999999999E8) {
            return "";
        }
        Object valorPorExtenso = "";
        String milhao = "";
        String milhar = "";
        String centena = "";
        Object centavos = "";
        String valorMonetarioString = new DecimalFormat("0000000000.00").format(valorMonetario);
        palavras[0] = "zero ";
        palavras[1] = "um ";
        palavras[2] = "dois ";
        palavras[3] = "tr\u00eas ";
        palavras[4] = "quatro ";
        palavras[5] = "cinco ";
        palavras[6] = "seis ";
        palavras[7] = "sete ";
        palavras[8] = "oito ";
        palavras[9] = "nove ";
        palavras[10] = "dez ";
        palavras[11] = "onze ";
        palavras[12] = "doze ";
        palavras[13] = "treze ";
        palavras[14] = "catorze ";
        palavras[15] = "quinze ";
        palavras[16] = "dezesseis ";
        palavras[17] = "dezessete ";
        palavras[18] = "dezoito ";
        palavras[19] = "dezenove ";
        palavras[20] = "vinte ";
        palavras[21] = "trinta ";
        palavras[22] = "quarenta ";
        palavras[23] = "cinquenta ";
        palavras[24] = "sessenta ";
        palavras[25] = "setenta ";
        palavras[26] = "oitenta ";
        palavras[27] = "noventa ";
        palavras[28] = "cento ";
        palavras[29] = "duzentos ";
        palavras[30] = "trezentos ";
        palavras[31] = "quatrocentos ";
        palavras[32] = "quinhentos ";
        palavras[33] = "seiscentos ";
        palavras[34] = "setecentos ";
        palavras[35] = "oitocentos ";
        palavras[36] = "novecentos ";
        if (valorMonetarioString.charAt(11) > '0' || valorMonetarioString.charAt(12) > '0') {
            centavos = IRPFUtil.obterTrechoPorExtenso(palavras, valorMonetarioString, 0, 11, 12, false) + "centavos";
        }
        centena = IRPFUtil.obterTrechoPorExtenso(palavras, valorMonetarioString, 7, 8, 9, true);
        milhar = IRPFUtil.obterTrechoPorExtenso(palavras, valorMonetarioString, 4, 5, 6, true);
        milhao = IRPFUtil.obterTrechoPorExtenso(palavras, valorMonetarioString, 1, 2, 3, true);
        if (valorMonetario > 1000000.0) {
            valorPorExtenso = milhao + "milh\u00f5es";
        }
        if (valorMonetarioString.charAt(3) == '1') {
            valorPorExtenso = milhao + "milh\u00e3o";
        }
        if (!milhar.isEmpty()) {
            valorPorExtenso = !((String)valorPorExtenso).isEmpty() ? (String)valorPorExtenso + ", " + milhar + "mil" : milhar + "mil";
        }
        if (!centena.isEmpty()) {
            valorPorExtenso = !((String)valorPorExtenso).isEmpty() ? (String)valorPorExtenso + " e " + centena : centena;
        }
        if (valorMonetario >= 1000000.0 && milhar.isEmpty() && centena.isEmpty()) {
            valorPorExtenso = (String)valorPorExtenso + " de reais";
        } else if (valorMonetario >= 2.0) {
            valorPorExtenso = (String)valorPorExtenso + "reais";
        } else if (valorMonetario >= 1.0) {
            valorPorExtenso = (String)valorPorExtenso + "real";
        } else if (valorMonetario == 0.0) {
            valorPorExtenso = "zero";
        }
        if (!((String)centavos).isEmpty()) {
            valorPorExtenso = !((String)valorPorExtenso).isEmpty() ? (String)valorPorExtenso + " e " + (String)centavos : centavos;
        }
        return valorPorExtenso;
    }

    public static void setNomeArquivo(String nomeArquivo) {
        IRPFUtil.nomeArquivo = nomeArquivo;
    }

    public static String getNomeArquivo() {
        return nomeArquivo;
    }

    public static boolean validarArquivoCarneLeao(File f) {
        IdentificadorDeclaracao idDeclaracao = IRPFFacade.getInstancia().getIdDeclaracaoAberto();
        List colDependentes = IRPFFacade.getInstancia().getDependentes().itens();
        Iterator it = colDependentes.iterator();
        boolean achouPadraoValido = Validador.validarString((String)f.getName(), (String)IRPFUtil.getPadraoArquivoCarneLeao(idDeclaracao.getCpf().naoFormatado()));
        while (!achouPadraoValido && it.hasNext()) {
            Dependente item = (Dependente)((Object)it.next());
            String cpf = item.getCpfDependente().naoFormatado();
            if (cpf.trim().length() != 11) continue;
            achouPadraoValido = Validador.validarString((String)f.getName(), (String)IRPFUtil.getPadraoArquivoCarneLeao(cpf));
        }
        return achouPadraoValido;
    }

    private static String getPadraoArquivoCarneLeao(String cpf) {
        return "(?i)" + cpf.substring(0, 11) + FiltroCPFCarneLeao.PADRAO_EXT_CARNE_LEAO;
    }

    public static boolean validarArquivoGCAP(File f) {
        IdentificadorDeclaracao idDeclaracao = IRPFFacade.getInstancia().getIdDeclaracaoAberto();
        List colDependentes = IRPFFacade.getInstancia().getDependentes().itens();
        Iterator it = colDependentes.iterator();
        boolean achouPadraoValido = Validador.validarString((String)f.getName(), (String)IRPFUtil.getPadraoNomeArquivoGCAP(idDeclaracao.getCpf().naoFormatado()));
        while (!achouPadraoValido && it.hasNext()) {
            Dependente item = (Dependente)((Object)it.next());
            String cpf = item.getCpfDependente().naoFormatado();
            if (cpf.trim().length() != 11) continue;
            achouPadraoValido = Validador.validarString((String)f.getName(), (String)IRPFUtil.getPadraoNomeArquivoGCAP(cpf));
        }
        return achouPadraoValido;
    }

    private static String getPadraoNomeArquivoGCAP(String cpf) {
        return "(?i)^" + cpf.substring(0, 11) + ProcessoImportacaoGCAP.PADRAO_EXT + "$";
    }

    public static int converterSortOrderParaInteiro(SortOrder sortOrder) {
        switch (sortOrder) {
            case DESCENDING: {
                return -1;
            }
            case UNSORTED: {
                return 0;
            }
            case ASCENDING: {
                return 1;
            }
        }
        return 0;
    }

    public static String formatarZerosEsquerda(String numero, int digitos) {
        StringBuilder builder = new StringBuilder(numero);
        int length = digitos - builder.length();
        for (int i = 0; i < length; ++i) {
            builder.insert(0, "0");
        }
        length = builder.length();
        return builder.toString().substring(length - digitos, length);
    }

    public static String repetirString(String s, int nVezes) {
        return nVezes <= 0 ? "" : String.format("%-" + nVezes + "s", "").replaceAll("\\s", s);
    }

    public static boolean deleteDir(String dir) {
        return IRPFUtil.deleteDir(new File(dir));
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = IRPFUtil.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static String obterNomeCompletoArquivoTransmitido(IdentificadorDeclaracao idSelecionado) {
        String txOrigiRetif = "ORIGI";
        if (idSelecionado.isRetificadora()) {
            txOrigiRetif = "RETIF";
        }
        String nomeDEC = idSelecionado.getCpf().naoFormatado() + "-IRPF-" + idSelecionado.getTipoDeclaracaoAES().naoFormatado() + "-" + AplicacaoPropertiesUtil.getExercicio() + "-" + String.valueOf(AplicacaoPropertiesUtil.getExercicioAsInt() - 1) + "-" + txOrigiRetif + ".DEC";
        return UtilitariosArquivo.getPathTransmitidas() + File.separator + nomeDEC;
    }

    public static String obterNomeCompletoArquivoGravado(IdentificadorDeclaracao idSelecionado) {
        String txOrigiRetif = "ORIGI";
        if (idSelecionado.isRetificadora()) {
            txOrigiRetif = "RETIF";
        }
        String nomeDEC = idSelecionado.getCpf().naoFormatado() + "-IRPF-" + idSelecionado.getTipoDeclaracaoAES().naoFormatado() + "-" + AplicacaoPropertiesUtil.getExercicio() + "-" + String.valueOf(AplicacaoPropertiesUtil.getExercicioAsInt() - 1) + "-" + txOrigiRetif + ".DEC";
        return UtilitariosArquivo.getPathGravadas() + File.separator + nomeDEC;
    }

    public static DeclaracaoIRPF iniciarPreencherObjetoDeclaracaoComTransmitida(IdentificadorDeclaracao idDec, Path tempDir) {
        DeclaracaoIRPF dec = null;
        try {
            if (IRPFFacade.existeDeclaracao(idDec.getCpf().naoFormatado(), "0000000000")) {
                IdentificadorDeclaracao copiaIdPreenchimento = idDec.obterCopiaIdentificador();
                copiaIdPreenchimento.getNumReciboTransmitido().setConteudo("0000000000");
                GravadorTXT.copiarDeclaracao((IdentificadorDeclaracao)copiaIdPreenchimento, (String)tempDir.toString());
                IRPFFacade.getInstancia();
                IRPFFacade.excluirDeclaracao(idDec.getCpf().naoFormatado(), "0000000000");
            }
            ImportadorTxt importador = new ImportadorTxt();
            dec = importador.restaurarDeclaracao(new File(IRPFUtil.obterNomeCompletoArquivoTransmitido(idDec)), false);
            importador = null;
        }
        catch (IOException | GeracaoTxtException ex) {
            ex.printStackTrace();
        }
        return dec;
    }

    public static void finalizarPreencherObjetoDeclaracaoComTransmitida(DeclaracaoIRPF dec, Path tempDir) {
        try {
            ImportadorTxt importador = new ImportadorTxt();
            IRPFFacade.excluirDeclaracao(dec.getIdentificadorDeclaracao());
            if (tempDir.toFile().list().length > 0) {
                IRPFFacade.limpaCacheDeclaracoes();
                File dbk = new File(GravadorTXT.montaNome((byte)1, (String)tempDir.toString(), (IdentificadorDeclaracao)dec.getIdentificadorDeclaracao()));
                importador = new ImportadorTxt();
                importador.restaurarDeclaracao(dbk, false);
                if (!dbk.delete()) {
                    LogPPGD.erro((String)"falha deletando aquivo.");
                }
                if (!tempDir.toFile().delete()) {
                    LogPPGD.erro((String)"falha deletando diretorio.");
                }
            }
        }
        catch (IOException | GeracaoTxtException ex) {
            ex.printStackTrace();
        }
    }

    public static boolean verificarVersaoJava(String versaoMinima, String versaoMaxima) {
        String[] minima = null;
        if (versaoMinima != null) {
            minima = versaoMinima.split("[^\\d]+");
        }
        String[] maxima = null;
        if (versaoMaxima != null) {
            maxima = versaoMaxima.split("[^\\d]+");
        }
        try {
            String[] versaoJava = System.getProperty("java.version").split("[^\\d]+");
            if (versaoJava.length > 0) {
                int verJava;
                int i;
                for (i = 0; i < versaoJava.length && (minima == null || minima != null && i < minima.length); ++i) {
                    verJava = Integer.parseInt(versaoJava[i]);
                    int verMin = 0;
                    if (minima != null) {
                        verMin = Integer.parseInt(minima[i]);
                    }
                    if (verJava < verMin) {
                        return false;
                    }
                    if (verJava > verMin) break;
                }
                for (i = 0; i < versaoJava.length && (maxima == null || maxima != null && i < maxima.length); ++i) {
                    verJava = Integer.parseInt(versaoJava[i]);
                    int verMax = Integer.MAX_VALUE;
                    if (maxima != null) {
                        verMax = Integer.parseInt(maxima[i]);
                    }
                    if (verJava > verMax) {
                        return false;
                    }
                    if (verJava < verMax) break;
                }
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean possuiAuxilioEmegencial(IdentificadorDeclaracao id) {
        File decGeradaEntrega = IRPFTxtUtil.montaPathTXTDeclaracao((String)UtilitariosArquivo.getPathTransmitidas(), (IdentificadorDeclaracao)id, (boolean)true);
        File fileRec = UtilitariosArquivo.getRECCorrespondente((File)decGeradaEntrega);
        try {
            if (fileRec != null) {
                RepositorioDeclaracaoCentralTxt repositorioDeclaracaoCentralTxt = new RepositorioDeclaracaoCentralTxt("ARQ_COMPLRECIBO", fileRec);
                Map mapAuxilio = repositorioDeclaracaoCentralTxt.recuperarValoresAuxilioEmergencial();
                return !mapAuxilio.isEmpty();
            }
        }
        catch (Exception ex) {
            LogPPGD.erro((String)ex.getMessage());
        }
        return false;
    }

    public static Alfa getCodigoAsAlfa(Codigo objetoOrigem, int posicao, boolean readOnly) {
        Alfa dummy = new Alfa();
        dummy.setReadOnly(readOnly);
        dummy.setConteudo(objetoOrigem.getConteudoAtual(posicao));
        return dummy;
    }

    public static Alfa getLogicoAsAlfa(Logico pergunta, String txtSim, String txtNao, boolean readOnly) {
        Alfa dummy = new Alfa();
        dummy.setReadOnly(readOnly);
        if (pergunta.naoFormatado().equals(Logico.SIM)) {
            dummy.setConteudo(txtSim);
        } else {
            dummy.setConteudo(txtNao);
        }
        return dummy;
    }

    public static Alfa getLogicoAsAlfa(Logico pergunta, String txtSim, String txtNao, String chaveTalvez, String txtTalvez, boolean readOnly) {
        Alfa dummy = new Alfa();
        dummy.setReadOnly(readOnly);
        if (pergunta.naoFormatado().equals(Logico.SIM)) {
            dummy.setConteudo(txtSim);
        } else if (pergunta.naoFormatado().equals(Logico.NAO)) {
            dummy.setConteudo(txtNao);
        } else if (pergunta.naoFormatado().equals(chaveTalvez)) {
            dummy.setConteudo(txtTalvez);
        }
        return dummy;
    }

    static {
        String executandoSobJWS = System.getProperty("ppgd.jws");
        if (executandoSobJWS != null && executandoSobJWS.trim().equals("true")) {
            DIR_DADOS = System.getProperty("user.home") + "/IRPF" + ConstantesGlobais.EXERCICIO + "/aplicacao/dados";
        } else {
            Object arqConf = UtilitariosArquivo.getPathAplicacao();
            arqConf = FabricaUtilitarios.isMac() ? (String)arqConf + "../" + ARQUIVO_INI : (String)arqConf + ARQUIVO_INI;
            if (new File((String)arqConf).exists()) {
                try {
                    Properties prop = new Properties();
                    prop.load(new FileInputStream((String)arqConf));
                    String dirDados = (String)prop.get("aplicacao.diretorio.dados");
                    usaAcessibilidade = prop.containsKey("aplicacao.acessibilidade.habilitado") ? new Boolean(prop.getProperty("aplicacao.acessibilidade.habilitado")) : false;
                    if (dirDados != null && !dirDados.trim().equals("")) {
                        FabricaUtilitarios.getProperties().setProperty("aplicacao.diretorio.dados", dirDados);
                    }
                }
                catch (IOException e) {
                    LogPPGD.erro((String)e.getMessage());
                }
            }
            DIR_DADOS = UtilitariosArquivo.getPathDados();
        }
        DIR_TMP = new File(DIR_DADOS, "tmp").getAbsolutePath();
    }
}

