/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.util;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import serpro.ppgd.irpf.util.AplicacaoPropertiesUtil;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.DataHora;

public class DataUtil {
    public static Date obterDataAtual() {
        return new Date();
    }

    public static Integer obterAnoExercicio() {
        String lAnoExercicio = AplicacaoPropertiesUtil.getExercicio();
        return Integer.valueOf(lAnoExercicio);
    }

    public static Integer obterAnoAnteriorExercicio() {
        return DataUtil.obterAnoExercicio() - 1;
    }

    public static String obterMesExtenso(String data) {
        Data mes = new Data();
        mes.setConteudo(data);
        int mesData = Integer.valueOf(mes.getMes());
        return ConstantesGlobais.MESES[mesData - 1];
    }

    public static String obterPrimeiroDiaAposDataInformada(String data) {
        Data dataAux = new Data();
        dataAux.setConteudo(data);
        Calendar c = Calendar.getInstance(new Locale("pt", "BR"));
        c.set(1, Integer.valueOf(dataAux.getAno()));
        c.set(2, Integer.valueOf(dataAux.getMes()) - 1);
        c.set(5, Integer.valueOf(dataAux.getDia()));
        c.add(5, 1);
        return DataUtil.formatarData(c.getTime());
    }

    public static boolean isDataHoje(Date pData) {
        Calendar lHoje = Calendar.getInstance();
        DataUtil.zerarHorario(lHoje);
        Calendar lData = Calendar.getInstance();
        lData.setTime(pData);
        DataUtil.zerarHorario(lData);
        return lHoje.equals(lData);
    }

    public static boolean isDataHoje(Data pData) {
        return DataUtil.isDataHoje(pData.asDate());
    }

    public static boolean isDataHoje(DataHora pData) {
        return DataUtil.isDataHoje(pData.asDate());
    }

    public static void zerarHorario(Calendar pCalendario) {
        pCalendario.set(11, 0);
        pCalendario.set(12, 0);
        pCalendario.set(13, 0);
        pCalendario.set(14, 0);
    }

    public static void zerarData(Calendar pCalendario) {
        pCalendario.set(5, 0);
        pCalendario.set(2, 0);
        pCalendario.set(1, 0);
    }

    public static boolean isDataNoAnoExercicio(Data data) {
        if (!data.isVazio()) {
            String anoAtual = DataUtil.obterAnoExercicio().toString();
            if (data.getAno().equals(anoAtual)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isAnoDataAnteriorAoAnoExercicio(Data data) {
        try {
            if (data.naoFormatado().trim().length() == 0) {
                return false;
            }
            if (Integer.valueOf(data.getAno()) < DataUtil.obterAnoExercicio()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean isAnoDataAnteriorAoAnoExercicioGCAP(Data data) {
        try {
            if (data.naoFormatado().trim().length() == 0) {
                return false;
            }
            if (Integer.valueOf(data.getAno()) < DataUtil.obterAnoExercicio() - 1) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean isAnoDataAnteriorAno(Data data, Integer pAno) {
        try {
            if (data.naoFormatado().trim().length() == 0) {
                return false;
            }
            if (Integer.valueOf(data.getAno()) < pAno) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean verificarIntercecaoPeriodos(Date pDataInicio1, Date pDataFim1, Date pDataInicio2, Date pDataFim2) {
        return pDataFim1.after(pDataInicio2) && pDataInicio1.before(pDataFim2);
    }

    public static boolean verificarIntercecaoPeriodos(Data pDataInicio1, Data pDataFim1, Data pDataInicio2, Data pDataFim2) {
        return DataUtil.verificarIntercecaoPeriodos(pDataInicio1.asDate(), pDataFim1.asDate(), pDataInicio2.asDate(), pDataFim2.asDate());
    }

    public static int obterPrimeiroDiaUtilDeMaio(int ano) {
        Calendar c = Calendar.getInstance(new Locale("pt", "BR"));
        c.set(1, ano);
        c.set(2, 4);
        for (int dia = 2; dia <= 4; ++dia) {
            c.set(5, dia);
            if (c.get(7) == 7 || c.get(7) == 1) continue;
            return dia;
        }
        return 0;
    }

    public static String obterPrimeiroDiaUtilDeMaioString(int ano) {
        DecimalFormat df = new DecimalFormat("00");
        return df.format(DataUtil.obterPrimeiroDiaUtilDeMaio(ano));
    }

    public static Date obterPrimeiroDiaAposPrazoEntrega() {
        Integer exercicioInt = Integer.valueOf(ConstantesGlobais.EXERCICIO);
        int mesAbril = 4;
        Calendar c = Calendar.getInstance(new Locale("pt", "BR"));
        c.set(1, exercicioInt);
        c.set(2, mesAbril - 1);
        c.set(5, DataUtil.obterUltimoDiaUtilMes(mesAbril, exercicioInt));
        c.add(5, 1);
        return c.getTime();
    }

    public static String obterPrimeiroDiaAposPrazoEntregaString() {
        return DataUtil.formatarData(DataUtil.obterPrimeiroDiaAposPrazoEntrega());
    }

    public static int obterUltimoDiaUtilMes(int mes, int ano) {
        int maxDias;
        Calendar c = Calendar.getInstance(new Locale("pt", "BR"));
        c.set(1, ano);
        c.set(2, mes - 1);
        c.set(5, 1);
        for (int dia = maxDias = c.getActualMaximum(5); dia > maxDias - 3; --dia) {
            c.set(5, dia);
            if (c.get(7) == 7 || c.get(7) == 1 || DataUtil.eFeriado(c.getTime())) continue;
            return dia;
        }
        return 0;
    }

    public static boolean eFeriado(Date pData) {
        try {
            List<String> feriados = AplicacaoPropertiesUtil.getFeriados();
            SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
            String sData = sdf.format(pData);
            Date data = sdf.parse(sData);
            for (int i = 0; i < feriados.size(); ++i) {
                if (sdf.parse(feriados.get(i)).compareTo(data) != 0) continue;
                return true;
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return false;
    }

    public static String obterUltimoDiaUtilMesString(int mes, int ano) {
        DecimalFormat df = new DecimalFormat("00");
        return df.format(DataUtil.obterUltimoDiaUtilMes(mes, ano));
    }

    public static String date2MesAno(Date pData) {
        Calendar lCalendar = Calendar.getInstance();
        lCalendar.setTime(pData);
        return String.format("%02d", lCalendar.get(2) + 1) + lCalendar.get(1);
    }

    public static String formatarDataSemBarras(Date pData) {
        SimpleDateFormat lSdf = new SimpleDateFormat("ddMMyyyy");
        return lSdf.format(pData);
    }

    public static String formatarData(Date pData) {
        SimpleDateFormat lSdf = new SimpleDateFormat("dd/MM/yyyy");
        return lSdf.format(pData);
    }

    public static long obterPeriodoEmSegundos(long inicio, long fim) {
        long diffInMillies = Math.abs(fim - inicio);
        return TimeUnit.SECONDS.convert(diffInMillies, TimeUnit.MILLISECONDS);
    }

    public static String obterPeriodoEmMinutosSegundos(long diff) {
        Object retorno = "";
        long minutos = diff / 60L;
        long segundos = diff % 60L;
        String sMinutos = null;
        String sSegundos = null;
        String string = sMinutos = minutos == 1L ? minutos + " minuto" : minutos + " minutos";
        if (minutos == 0L) {
            sMinutos = null;
        }
        String string2 = sSegundos = segundos == 1L ? segundos + " segundo" : segundos + " segundos";
        if (segundos == 0L) {
            sSegundos = null;
        }
        retorno = sMinutos != null && sSegundos != null ? sMinutos + " e " + sSegundos : (sMinutos != null ? sMinutos : (sSegundos != null ? sSegundos : null));
        return retorno;
    }
}

