/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.tabelas;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.negocio.ElementoTabela;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.util.FabricaTratamentoErro;
import serpro.ppgd.negocio.util.TrataErroSistemicoIf;
import serpro.ppgd.repositorio.RepositorioException;

public class TabelaAliquotasIRPF {
    private static CadastroTabelasIRPF.RepositorioTabelasBasicasIRPF repositorioTabelasBasicas = new CadastroTabelasIRPF.RepositorioTabelasBasicasIRPF();
    private static TrataErroSistemicoIf trataErro = FabricaTratamentoErro.getTrataErroSistemico();
    private static Map<String, String> aliquotas = new HashMap<String, String>();
    private static boolean testarCRC = true;
    public static String[] CONST_GERAIS = new String[]{"anoCalendario", "descontoLimiteDPadrao", "descontoPercentualDPadrao", "limiteBensDireitos", "limiteIAP", "limiteIsencao", "limiteReceitaBrutaAtividadeRural", "limiteRendimentosIsentosTributExclusiva", "limiteRendimentoTributavel", "peMultaParteBSuplementar", "peMultaSuplementar", "peMultaSuplementarReduzida", "qtdDiasAcessoECAC", "qtdMaxQuota", "quantidadeMesesSemAumento", "vaFolga1Mditec", "vaFolga2Mditec", "vaFolga3Mditec", "valorMensalComAumento", "valorMensalSemAumento", "valorMinDevImposto", "valorMinIAP", "valorMinQuota", "vaMinMdIAR", "vaTolerancia"};
    public static String[] CONST_DEDUCOES = new String[]{"deducaoDespesaInstrucao", "deducaoIncentivo", "deducaoLimiteContribuicaoPatronal", "deducaoPrevidenciaPrivada", "deducoesIncECA", "deducoesIncPronas", "deducoesIncPronon", "deducoesIncDesporto", "deducoesIncIdoso"};
    public static String[] CONST_TABELA_PROGRESSIVA = new String[]{"percentualFaixa1", "percentualFaixa2", "percentualFaixa3", "percentualFaixa4", "valorAjusteDescontoAnualFaixa1", "valorAjusteDescontoAnualFaixa2", "valorAjusteDescontoAnualFaixa3", "valorAjusteDescontoAnualFaixa4", "valorAjusteDescontoMEFaixa1mes1", "valorAjusteDescontoMEFaixa1mes2", "valorAjusteDescontoMEFaixa1mes3", "valorAjusteDescontoMEFaixa1mes4", "valorAjusteDescontoMEFaixa1mes5", "valorAjusteDescontoMEFaixa1mes6", "valorAjusteDescontoMEFaixa1mes7", "valorAjusteDescontoMEFaixa1mes8", "valorAjusteDescontoMEFaixa1mes9", "valorAjusteDescontoMEFaixa1mes10", "valorAjusteDescontoMEFaixa1mes11", "valorAjusteDescontoMEFaixa1mes12", "valorAjusteDescontoMEFaixa2mes1", "valorAjusteDescontoMEFaixa2mes2", "valorAjusteDescontoMEFaixa2mes3", "valorAjusteDescontoMEFaixa2mes4", "valorAjusteDescontoMEFaixa2mes5", "valorAjusteDescontoMEFaixa2mes6", "valorAjusteDescontoMEFaixa2mes7", "valorAjusteDescontoMEFaixa2mes8", "valorAjusteDescontoMEFaixa2mes9", "valorAjusteDescontoMEFaixa2mes10", "valorAjusteDescontoMEFaixa2mes11", "valorAjusteDescontoMEFaixa2mes12", "valorAjusteDescontoMEFaixa3mes1", "valorAjusteDescontoMEFaixa3mes2", "valorAjusteDescontoMEFaixa3mes3", "valorAjusteDescontoMEFaixa3mes4", "valorAjusteDescontoMEFaixa3mes5", "valorAjusteDescontoMEFaixa3mes6", "valorAjusteDescontoMEFaixa3mes7", "valorAjusteDescontoMEFaixa3mes8", "valorAjusteDescontoMEFaixa3mes9", "valorAjusteDescontoMEFaixa3mes10", "valorAjusteDescontoMEFaixa3mes11", "valorAjusteDescontoMEFaixa3mes12", "valorAjusteDescontoMEFaixa4mes1", "valorAjusteDescontoMEFaixa4mes2", "valorAjusteDescontoMEFaixa4mes3", "valorAjusteDescontoMEFaixa4mes4", "valorAjusteDescontoMEFaixa4mes5", "valorAjusteDescontoMEFaixa4mes6", "valorAjusteDescontoMEFaixa4mes7", "valorAjusteDescontoMEFaixa4mes8", "valorAjusteDescontoMEFaixa4mes9", "valorAjusteDescontoMEFaixa4mes10", "valorAjusteDescontoMEFaixa4mes11", "valorAjusteDescontoMEFaixa4mes12", "valorAjusteLimiteAnualFaixa1", "valorAjusteLimiteAnualFaixa2", "valorAjusteLimiteAnualFaixa3", "valorAjusteLimiteAnualFaixa4", "valorAjusteLimiteMEFaixa1mes1", "valorAjusteLimiteMEFaixa1mes2", "valorAjusteLimiteMEFaixa1mes3", "valorAjusteLimiteMEFaixa1mes4", "valorAjusteLimiteMEFaixa1mes5", "valorAjusteLimiteMEFaixa1mes6", "valorAjusteLimiteMEFaixa1mes7", "valorAjusteLimiteMEFaixa1mes8", "valorAjusteLimiteMEFaixa1mes9", "valorAjusteLimiteMEFaixa1mes10", "valorAjusteLimiteMEFaixa1mes11", "valorAjusteLimiteMEFaixa1mes12", "valorAjusteLimiteMEFaixa2mes1", "valorAjusteLimiteMEFaixa2mes2", "valorAjusteLimiteMEFaixa2mes3", "valorAjusteLimiteMEFaixa2mes4", "valorAjusteLimiteMEFaixa2mes5", "valorAjusteLimiteMEFaixa2mes6", "valorAjusteLimiteMEFaixa2mes7", "valorAjusteLimiteMEFaixa2mes8", "valorAjusteLimiteMEFaixa2mes9", "valorAjusteLimiteMEFaixa2mes10", "valorAjusteLimiteMEFaixa2mes11", "valorAjusteLimiteMEFaixa2mes12", "valorAjusteLimiteMEFaixa3mes1", "valorAjusteLimiteMEFaixa3mes2", "valorAjusteLimiteMEFaixa3mes3", "valorAjusteLimiteMEFaixa3mes4", "valorAjusteLimiteMEFaixa3mes5", "valorAjusteLimiteMEFaixa3mes6", "valorAjusteLimiteMEFaixa3mes7", "valorAjusteLimiteMEFaixa3mes8", "valorAjusteLimiteMEFaixa3mes9", "valorAjusteLimiteMEFaixa3mes10", "valorAjusteLimiteMEFaixa3mes11", "valorAjusteLimiteMEFaixa3mes12", "valorAjusteLimiteMEFaixa4mes1", "valorAjusteLimiteMEFaixa4mes2", "valorAjusteLimiteMEFaixa4mes3", "valorAjusteLimiteMEFaixa4mes4", "valorAjusteLimiteMEFaixa4mes5", "valorAjusteLimiteMEFaixa4mes6", "valorAjusteLimiteMEFaixa4mes7", "valorAjusteLimiteMEFaixa4mes8", "valorAjusteLimiteMEFaixa4mes9", "valorAjusteLimiteMEFaixa4mes10", "valorAjusteLimiteMEFaixa4mes11", "valorAjusteLimiteMEFaixa4mes12"};
    public static String[] CONST_TABELA_PROGRESSIVA_RRA = new String[]{"valorAjusteLimiteRRAFaixa1mes1", "valorAjusteLimiteRRAFaixa1mes2", "valorAjusteLimiteRRAFaixa1mes3", "valorAjusteLimiteRRAFaixa1mes4", "valorAjusteLimiteRRAFaixa1mes5", "valorAjusteLimiteRRAFaixa1mes6", "valorAjusteLimiteRRAFaixa1mes7", "valorAjusteLimiteRRAFaixa1mes8", "valorAjusteLimiteRRAFaixa1mes9", "valorAjusteLimiteRRAFaixa1mes10", "valorAjusteLimiteRRAFaixa1mes11", "valorAjusteLimiteRRAFaixa1mes12", "valorAjusteLimiteRRAFaixa2mes1", "valorAjusteLimiteRRAFaixa2mes2", "valorAjusteLimiteRRAFaixa2mes3", "valorAjusteLimiteRRAFaixa2mes4", "valorAjusteLimiteRRAFaixa2mes5", "valorAjusteLimiteRRAFaixa2mes6", "valorAjusteLimiteRRAFaixa2mes7", "valorAjusteLimiteRRAFaixa2mes8", "valorAjusteLimiteRRAFaixa2mes9", "valorAjusteLimiteRRAFaixa2mes10", "valorAjusteLimiteRRAFaixa2mes11", "valorAjusteLimiteRRAFaixa2mes12", "valorAjusteLimiteRRAFaixa3mes1", "valorAjusteLimiteRRAFaixa3mes2", "valorAjusteLimiteRRAFaixa3mes3", "valorAjusteLimiteRRAFaixa3mes4", "valorAjusteLimiteRRAFaixa3mes5", "valorAjusteLimiteRRAFaixa3mes6", "valorAjusteLimiteRRAFaixa3mes7", "valorAjusteLimiteRRAFaixa3mes8", "valorAjusteLimiteRRAFaixa3mes9", "valorAjusteLimiteRRAFaixa3mes10", "valorAjusteLimiteRRAFaixa3mes11", "valorAjusteLimiteRRAFaixa3mes12", "valorAjusteLimiteRRAFaixa4mes1", "valorAjusteLimiteRRAFaixa4mes2", "valorAjusteLimiteRRAFaixa4mes3", "valorAjusteLimiteRRAFaixa4mes4", "valorAjusteLimiteRRAFaixa4mes5", "valorAjusteLimiteRRAFaixa4mes6", "valorAjusteLimiteRRAFaixa4mes7", "valorAjusteLimiteRRAFaixa4mes8", "valorAjusteLimiteRRAFaixa4mes9", "valorAjusteLimiteRRAFaixa4mes10", "valorAjusteLimiteRRAFaixa4mes11", "valorAjusteLimiteRRAFaixa4mes12"};
    public static String[] CONST_CONTRIBUICAO_PATRONAL = new String[]{"valorCotaSalMinCPMEmes1", "valorCotaSalMinCPMEmes2", "valorCotaSalMinCPMEmes3", "valorCotaSalMinCPMEmes4", "valorCotaSalMinCPMEmes5", "valorCotaSalMinCPMEmes6", "valorCotaSalMinCPMEmes7", "valorCotaSalMinCPMEmes8", "valorCotaSalMinCPMEmes9", "valorCotaSalMinCPMEmes10", "valorCotaSalMinCPMEmes11", "valorCotaSalMinCPMEmes12", "valorCotaSalMinCPMEmes13"};
    public static String[] CONST_DEPENDENTES = new String[]{"valorDedDependenteMEmes1", "valorDedDependenteMEmes2", "valorDedDependenteMEmes3", "valorDedDependenteMEmes4", "valorDedDependenteMEmes5", "valorDedDependenteMEmes6", "valorDedDependenteMEmes7", "valorDedDependenteMEmes8", "valorDedDependenteMEmes9", "valorDedDependenteMEmes10", "valorDedDependenteMEmes11", "valorDedDependenteMEmes12", "deducaoDependente"};

    public static Map<String, String> getAliquotas() {
        if (aliquotas.isEmpty()) {
            TabelaAliquotasIRPF.carregarAliquotas();
        }
        return aliquotas;
    }

    public static String getHash() {
        return repositorioTabelasBasicas.getCRC("resources/aliquotas.xml");
    }

    public static String getVersao() {
        return repositorioTabelasBasicas.getVigencia("resources/aliquotas.xml");
    }

    public static void carregarAliquotas() {
        try {
            ArrayList<ElementoTabela> colecaoAliquotas = new ArrayList<ElementoTabela>();
            repositorioTabelasBasicas.recuperarObjetosTabela("resources/aliquotas.xml", colecaoAliquotas, testarCRC);
            aliquotas.clear();
            for (ElementoTabela et : colecaoAliquotas) {
                aliquotas.put(et.getConteudo(0), et.getConteudo(1));
            }
        }
        catch (RepositorioException e) {
            trataErro.trataErroSistemico((Throwable)e);
        }
    }

    public static Map<String, String> obterTabelaProgressivaMesesEspecificos(List<Integer> meses) {
        HashMap<String, String> tabelaProgressiva = new HashMap<String, String>();
        Valor valorAjusteLimiteMEFaixa1 = new Valor();
        Valor valorAjusteLimiteMEFaixa2 = new Valor();
        Valor valorAjusteLimiteMEFaixa3 = new Valor();
        Valor valorAjusteLimiteMEFaixa4 = new Valor();
        Valor valorAjusteDescontoMEFaixa1 = new Valor();
        Valor valorAjusteDescontoMEFaixa2 = new Valor();
        Valor valorAjusteDescontoMEFaixa3 = new Valor();
        Valor valorAjusteDescontoMEFaixa4 = new Valor();
        valorAjusteDescontoMEFaixa1.setCasasDecimais(4);
        valorAjusteDescontoMEFaixa2.setCasasDecimais(4);
        valorAjusteDescontoMEFaixa3.setCasasDecimais(4);
        valorAjusteDescontoMEFaixa4.setCasasDecimais(4);
        for (Integer mes : meses) {
            valorAjusteLimiteMEFaixa1.append('+', ConstantesAliquotas.valueOf("valorAjusteLimiteMEFaixa1mes" + String.valueOf(mes)).getValor());
            valorAjusteLimiteMEFaixa2.append('+', ConstantesAliquotas.valueOf("valorAjusteLimiteMEFaixa2mes" + String.valueOf(mes)).getValor());
            valorAjusteLimiteMEFaixa3.append('+', ConstantesAliquotas.valueOf("valorAjusteLimiteMEFaixa3mes" + String.valueOf(mes)).getValor());
            valorAjusteLimiteMEFaixa4.append('+', ConstantesAliquotas.valueOf("valorAjusteLimiteMEFaixa4mes" + String.valueOf(mes)).getValor());
            valorAjusteDescontoMEFaixa1.append('+', ConstantesAliquotas.valueOf("valorAjusteDescontoMEFaixa1mes" + String.valueOf(mes)).getValor());
            valorAjusteDescontoMEFaixa2.append('+', ConstantesAliquotas.valueOf("valorAjusteDescontoMEFaixa2mes" + String.valueOf(mes)).getValor());
            valorAjusteDescontoMEFaixa3.append('+', ConstantesAliquotas.valueOf("valorAjusteDescontoMEFaixa3mes" + String.valueOf(mes)).getValor());
            valorAjusteDescontoMEFaixa4.append('+', ConstantesAliquotas.valueOf("valorAjusteDescontoMEFaixa4mes" + String.valueOf(mes)).getValor());
        }
        tabelaProgressiva.put("valorAjusteLimiteMEFaixa1", valorAjusteLimiteMEFaixa1.formatado());
        tabelaProgressiva.put("valorAjusteLimiteMEFaixa2", valorAjusteLimiteMEFaixa2.formatado());
        tabelaProgressiva.put("valorAjusteLimiteMEFaixa3", valorAjusteLimiteMEFaixa3.formatado());
        tabelaProgressiva.put("valorAjusteLimiteMEFaixa4", valorAjusteLimiteMEFaixa4.formatado());
        tabelaProgressiva.put("valorAjusteDescontoMEFaixa1", valorAjusteDescontoMEFaixa1.formatado());
        tabelaProgressiva.put("valorAjusteDescontoMEFaixa2", valorAjusteDescontoMEFaixa2.formatado());
        tabelaProgressiva.put("valorAjusteDescontoMEFaixa3", valorAjusteDescontoMEFaixa3.formatado());
        tabelaProgressiva.put("valorAjusteDescontoMEFaixa4", valorAjusteDescontoMEFaixa4.formatado());
        return tabelaProgressiva;
    }

    public static Map<String, String> obterTabelaProgressivaRRA(Integer mesRecebimento) {
        HashMap<String, String> tabelaProgressiva = new HashMap<String, String>();
        Valor valorAjusteLimiteMEFaixa1 = new Valor();
        Valor valorAjusteLimiteMEFaixa2 = new Valor();
        Valor valorAjusteLimiteMEFaixa3 = new Valor();
        Valor valorAjusteLimiteMEFaixa4 = new Valor();
        Valor valorAjusteLimiteRRAFaixa1 = new Valor();
        Valor valorAjusteLimiteRRAFaixa2 = new Valor();
        Valor valorAjusteLimiteRRAFaixa3 = new Valor();
        Valor valorAjusteLimiteRRAFaixa4 = new Valor();
        valorAjusteLimiteRRAFaixa1.setCasasDecimais(6);
        valorAjusteLimiteRRAFaixa2.setCasasDecimais(6);
        valorAjusteLimiteRRAFaixa3.setCasasDecimais(6);
        valorAjusteLimiteRRAFaixa4.setCasasDecimais(6);
        valorAjusteLimiteMEFaixa1.setConteudo(ConstantesAliquotas.valueOf("valorAjusteLimiteMEFaixa1mes" + String.valueOf(mesRecebimento)).getValor());
        valorAjusteLimiteMEFaixa2.setConteudo(ConstantesAliquotas.valueOf("valorAjusteLimiteMEFaixa2mes" + String.valueOf(mesRecebimento)).getValor());
        valorAjusteLimiteMEFaixa3.setConteudo(ConstantesAliquotas.valueOf("valorAjusteLimiteMEFaixa3mes" + String.valueOf(mesRecebimento)).getValor());
        valorAjusteLimiteMEFaixa4.setConteudo(ConstantesAliquotas.valueOf("valorAjusteLimiteMEFaixa4mes" + String.valueOf(mesRecebimento)).getValor());
        valorAjusteLimiteRRAFaixa1.setConteudo(ConstantesAliquotas.valueOf("valorAjusteLimiteRRAFaixa1mes" + String.valueOf(mesRecebimento)).getValor());
        valorAjusteLimiteRRAFaixa2.setConteudo(ConstantesAliquotas.valueOf("valorAjusteLimiteRRAFaixa2mes" + String.valueOf(mesRecebimento)).getValor());
        valorAjusteLimiteRRAFaixa3.setConteudo(ConstantesAliquotas.valueOf("valorAjusteLimiteRRAFaixa3mes" + String.valueOf(mesRecebimento)).getValor());
        valorAjusteLimiteRRAFaixa4.setConteudo(ConstantesAliquotas.valueOf("valorAjusteLimiteRRAFaixa4mes" + String.valueOf(mesRecebimento)).getValor());
        tabelaProgressiva.put("valorAjusteLimiteMEFaixa1", valorAjusteLimiteMEFaixa1.formatado());
        tabelaProgressiva.put("valorAjusteLimiteMEFaixa2", valorAjusteLimiteMEFaixa2.formatado());
        tabelaProgressiva.put("valorAjusteLimiteMEFaixa3", valorAjusteLimiteMEFaixa3.formatado());
        tabelaProgressiva.put("valorAjusteLimiteMEFaixa4", valorAjusteLimiteMEFaixa4.formatado());
        tabelaProgressiva.put("valorAjusteLimiteRRAFaixa1", valorAjusteLimiteRRAFaixa1.formatado());
        tabelaProgressiva.put("valorAjusteLimiteRRAFaixa2", valorAjusteLimiteRRAFaixa2.formatado());
        tabelaProgressiva.put("valorAjusteLimiteRRAFaixa3", valorAjusteLimiteRRAFaixa3.formatado());
        tabelaProgressiva.put("valorAjusteLimiteRRAFaixa4", valorAjusteLimiteRRAFaixa4.formatado());
        return tabelaProgressiva;
    }

    public static Valor obterDeducaoMensalDependente(Integer mes) {
        Valor valorDedDependenteME = new Valor();
        valorDedDependenteME.setConteudo(ConstantesAliquotas.valorDedDependenteMEmes1.getValor());
        try {
            valorDedDependenteME.setConteudo(ConstantesAliquotas.valueOf("valorDedDependenteMEmes" + mes.toString()).getValor());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return valorDedDependenteME;
    }

    public static void main(String[] args) {
        System.out.println(ConstantesAliquotas.descontoPercentualDPadrao.getValor().formatado());
        System.out.println(ConstantesAliquotas.descontoPercentualDPadrao.getValorAsPercentual().formatado());
        System.out.println("--------------------------------------");
        System.out.println(CONST_CONTRIBUICAO_PATRONAL.length + CONST_DEDUCOES.length + CONST_DEPENDENTES.length + CONST_GERAIS.length + CONST_TABELA_PROGRESSIVA.length + CONST_TABELA_PROGRESSIVA_RRA.length + " contantes");
    }

    public static enum ConstantesAliquotas {
        anoCalendario(0),
        deducaoDependente(2),
        deducaoDespesaInstrucao(2),
        deducaoIncentivo(2),
        deducaoLimiteContribuicaoPatronal(2),
        deducaoPrevidenciaPrivada(2),
        deducoesIncECA(2),
        deducoesIncPronas(2),
        deducoesIncPronon(2),
        deducoesIncDesporto(2),
        deducoesIncIdoso(2),
        descontoLimiteDPadrao(2),
        descontoPercentualDPadrao(2),
        limiteBensDireitos(2),
        limiteIAP(2),
        limiteIsencao(2),
        limiteReceitaBrutaAtividadeRural(2),
        limiteRendimentosIsentosTributExclusiva(2),
        limiteRendimentoTributavel(2),
        peMultaParteBSuplementar(2),
        peMultaSuplementar(2),
        peMultaSuplementarReduzida(2),
        percentualFaixa1(2),
        percentualFaixa2(2),
        percentualFaixa3(2),
        percentualFaixa4(2),
        qtdDiasAcessoECAC(0),
        qtdMaxQuota(0),
        quantidadeMesesSemAumento(0),
        vaFolga1Mditec(2),
        vaFolga2Mditec(2),
        vaFolga3Mditec(2),
        valorAjusteDescontoAnualFaixa1(4),
        valorAjusteDescontoAnualFaixa2(4),
        valorAjusteDescontoAnualFaixa3(4),
        valorAjusteDescontoAnualFaixa4(4),
        valorAjusteDescontoMEFaixa1mes1(4),
        valorAjusteDescontoMEFaixa1mes2(4),
        valorAjusteDescontoMEFaixa1mes3(4),
        valorAjusteDescontoMEFaixa1mes4(4),
        valorAjusteDescontoMEFaixa1mes5(4),
        valorAjusteDescontoMEFaixa1mes6(4),
        valorAjusteDescontoMEFaixa1mes7(4),
        valorAjusteDescontoMEFaixa1mes8(4),
        valorAjusteDescontoMEFaixa1mes9(4),
        valorAjusteDescontoMEFaixa1mes10(4),
        valorAjusteDescontoMEFaixa1mes11(4),
        valorAjusteDescontoMEFaixa1mes12(4),
        valorAjusteDescontoMEFaixa2mes1(4),
        valorAjusteDescontoMEFaixa2mes2(4),
        valorAjusteDescontoMEFaixa2mes3(4),
        valorAjusteDescontoMEFaixa2mes4(4),
        valorAjusteDescontoMEFaixa2mes5(4),
        valorAjusteDescontoMEFaixa2mes6(4),
        valorAjusteDescontoMEFaixa2mes7(4),
        valorAjusteDescontoMEFaixa2mes8(4),
        valorAjusteDescontoMEFaixa2mes9(4),
        valorAjusteDescontoMEFaixa2mes10(4),
        valorAjusteDescontoMEFaixa2mes11(4),
        valorAjusteDescontoMEFaixa2mes12(4),
        valorAjusteDescontoMEFaixa3mes1(4),
        valorAjusteDescontoMEFaixa3mes2(4),
        valorAjusteDescontoMEFaixa3mes3(4),
        valorAjusteDescontoMEFaixa3mes4(4),
        valorAjusteDescontoMEFaixa3mes5(4),
        valorAjusteDescontoMEFaixa3mes6(4),
        valorAjusteDescontoMEFaixa3mes7(4),
        valorAjusteDescontoMEFaixa3mes8(4),
        valorAjusteDescontoMEFaixa3mes9(4),
        valorAjusteDescontoMEFaixa3mes10(4),
        valorAjusteDescontoMEFaixa3mes11(4),
        valorAjusteDescontoMEFaixa3mes12(4),
        valorAjusteDescontoMEFaixa4mes1(4),
        valorAjusteDescontoMEFaixa4mes2(4),
        valorAjusteDescontoMEFaixa4mes3(4),
        valorAjusteDescontoMEFaixa4mes4(4),
        valorAjusteDescontoMEFaixa4mes5(4),
        valorAjusteDescontoMEFaixa4mes6(4),
        valorAjusteDescontoMEFaixa4mes7(4),
        valorAjusteDescontoMEFaixa4mes8(4),
        valorAjusteDescontoMEFaixa4mes9(4),
        valorAjusteDescontoMEFaixa4mes10(4),
        valorAjusteDescontoMEFaixa4mes11(4),
        valorAjusteDescontoMEFaixa4mes12(4),
        valorAjusteLimiteAnualFaixa1(2),
        valorAjusteLimiteAnualFaixa2(2),
        valorAjusteLimiteAnualFaixa3(2),
        valorAjusteLimiteAnualFaixa4(2),
        valorAjusteLimiteMEFaixa1mes1(2),
        valorAjusteLimiteMEFaixa1mes2(2),
        valorAjusteLimiteMEFaixa1mes3(2),
        valorAjusteLimiteMEFaixa1mes4(2),
        valorAjusteLimiteMEFaixa1mes5(2),
        valorAjusteLimiteMEFaixa1mes6(2),
        valorAjusteLimiteMEFaixa1mes7(2),
        valorAjusteLimiteMEFaixa1mes8(2),
        valorAjusteLimiteMEFaixa1mes9(2),
        valorAjusteLimiteMEFaixa1mes10(2),
        valorAjusteLimiteMEFaixa1mes11(2),
        valorAjusteLimiteMEFaixa1mes12(2),
        valorAjusteLimiteMEFaixa2mes1(2),
        valorAjusteLimiteMEFaixa2mes2(2),
        valorAjusteLimiteMEFaixa2mes3(2),
        valorAjusteLimiteMEFaixa2mes4(2),
        valorAjusteLimiteMEFaixa2mes5(2),
        valorAjusteLimiteMEFaixa2mes6(2),
        valorAjusteLimiteMEFaixa2mes7(2),
        valorAjusteLimiteMEFaixa2mes8(2),
        valorAjusteLimiteMEFaixa2mes9(2),
        valorAjusteLimiteMEFaixa2mes10(2),
        valorAjusteLimiteMEFaixa2mes11(2),
        valorAjusteLimiteMEFaixa2mes12(2),
        valorAjusteLimiteMEFaixa3mes1(2),
        valorAjusteLimiteMEFaixa3mes2(2),
        valorAjusteLimiteMEFaixa3mes3(2),
        valorAjusteLimiteMEFaixa3mes4(2),
        valorAjusteLimiteMEFaixa3mes5(2),
        valorAjusteLimiteMEFaixa3mes6(2),
        valorAjusteLimiteMEFaixa3mes7(2),
        valorAjusteLimiteMEFaixa3mes8(2),
        valorAjusteLimiteMEFaixa3mes9(2),
        valorAjusteLimiteMEFaixa3mes10(2),
        valorAjusteLimiteMEFaixa3mes11(2),
        valorAjusteLimiteMEFaixa3mes12(2),
        valorAjusteLimiteMEFaixa4mes1(2),
        valorAjusteLimiteMEFaixa4mes2(2),
        valorAjusteLimiteMEFaixa4mes3(2),
        valorAjusteLimiteMEFaixa4mes4(2),
        valorAjusteLimiteMEFaixa4mes5(2),
        valorAjusteLimiteMEFaixa4mes6(2),
        valorAjusteLimiteMEFaixa4mes7(2),
        valorAjusteLimiteMEFaixa4mes8(2),
        valorAjusteLimiteMEFaixa4mes9(2),
        valorAjusteLimiteMEFaixa4mes10(2),
        valorAjusteLimiteMEFaixa4mes11(2),
        valorAjusteLimiteMEFaixa4mes12(2),
        valorAjusteLimiteRRAFaixa1mes1(6),
        valorAjusteLimiteRRAFaixa1mes2(6),
        valorAjusteLimiteRRAFaixa1mes3(6),
        valorAjusteLimiteRRAFaixa1mes4(6),
        valorAjusteLimiteRRAFaixa1mes5(6),
        valorAjusteLimiteRRAFaixa1mes6(6),
        valorAjusteLimiteRRAFaixa1mes7(6),
        valorAjusteLimiteRRAFaixa1mes8(6),
        valorAjusteLimiteRRAFaixa1mes9(6),
        valorAjusteLimiteRRAFaixa1mes10(6),
        valorAjusteLimiteRRAFaixa1mes11(6),
        valorAjusteLimiteRRAFaixa1mes12(6),
        valorAjusteLimiteRRAFaixa2mes1(6),
        valorAjusteLimiteRRAFaixa2mes2(6),
        valorAjusteLimiteRRAFaixa2mes3(6),
        valorAjusteLimiteRRAFaixa2mes4(6),
        valorAjusteLimiteRRAFaixa2mes5(6),
        valorAjusteLimiteRRAFaixa2mes6(6),
        valorAjusteLimiteRRAFaixa2mes7(6),
        valorAjusteLimiteRRAFaixa2mes8(6),
        valorAjusteLimiteRRAFaixa2mes9(6),
        valorAjusteLimiteRRAFaixa2mes10(6),
        valorAjusteLimiteRRAFaixa2mes11(6),
        valorAjusteLimiteRRAFaixa2mes12(6),
        valorAjusteLimiteRRAFaixa3mes1(6),
        valorAjusteLimiteRRAFaixa3mes2(6),
        valorAjusteLimiteRRAFaixa3mes3(6),
        valorAjusteLimiteRRAFaixa3mes4(6),
        valorAjusteLimiteRRAFaixa3mes5(6),
        valorAjusteLimiteRRAFaixa3mes6(6),
        valorAjusteLimiteRRAFaixa3mes7(6),
        valorAjusteLimiteRRAFaixa3mes8(6),
        valorAjusteLimiteRRAFaixa3mes9(6),
        valorAjusteLimiteRRAFaixa3mes10(6),
        valorAjusteLimiteRRAFaixa3mes11(6),
        valorAjusteLimiteRRAFaixa3mes12(6),
        valorAjusteLimiteRRAFaixa4mes1(6),
        valorAjusteLimiteRRAFaixa4mes2(6),
        valorAjusteLimiteRRAFaixa4mes3(6),
        valorAjusteLimiteRRAFaixa4mes4(6),
        valorAjusteLimiteRRAFaixa4mes5(6),
        valorAjusteLimiteRRAFaixa4mes6(6),
        valorAjusteLimiteRRAFaixa4mes7(6),
        valorAjusteLimiteRRAFaixa4mes8(6),
        valorAjusteLimiteRRAFaixa4mes9(6),
        valorAjusteLimiteRRAFaixa4mes10(6),
        valorAjusteLimiteRRAFaixa4mes11(6),
        valorAjusteLimiteRRAFaixa4mes12(6),
        valorCotaSalMinCPMEmes1(2),
        valorCotaSalMinCPMEmes2(2),
        valorCotaSalMinCPMEmes3(2),
        valorCotaSalMinCPMEmes4(2),
        valorCotaSalMinCPMEmes5(2),
        valorCotaSalMinCPMEmes6(2),
        valorCotaSalMinCPMEmes7(2),
        valorCotaSalMinCPMEmes8(2),
        valorCotaSalMinCPMEmes9(2),
        valorCotaSalMinCPMEmes10(2),
        valorCotaSalMinCPMEmes11(2),
        valorCotaSalMinCPMEmes12(2),
        valorCotaSalMinCPMEmes13(2),
        valorDedDependenteMEmes1(2),
        valorDedDependenteMEmes2(2),
        valorDedDependenteMEmes3(2),
        valorDedDependenteMEmes4(2),
        valorDedDependenteMEmes5(2),
        valorDedDependenteMEmes6(2),
        valorDedDependenteMEmes7(2),
        valorDedDependenteMEmes8(2),
        valorDedDependenteMEmes9(2),
        valorDedDependenteMEmes10(2),
        valorDedDependenteMEmes11(2),
        valorDedDependenteMEmes12(2),
        valorMensalComAumento(2),
        valorMensalSemAumento(2),
        valorMinDevImposto(2),
        valorMinIAP(2),
        valorMinQuota(2),
        vaMinMdIAR(2),
        vaTolerancia(2),
        cotacaoDolarAtividadeRural(2);

        private int casasDecimais;

        private ConstantesAliquotas() {
            this(0);
        }

        private ConstantesAliquotas(int casasDecimais) {
            this.casasDecimais = casasDecimais;
        }

        public Valor getValor() {
            String aliquota = TabelaAliquotasIRPF.getAliquotas().get(this.name());
            if (aliquota == null) {
                return new Valor();
            }
            StringBuilder conteudo = new StringBuilder(aliquota);
            int casasInteiras = conteudo.length() - this.casasDecimais;
            conteudo = conteudo.insert(casasInteiras, ',');
            Valor retorno = new Valor();
            retorno.setCasasDecimais(this.casasDecimais);
            retorno.setConteudo(conteudo.toString());
            return retorno;
        }

        public Valor getValorAsPercentual() {
            Valor retorno = this.getValor();
            retorno.append('/', "100,00");
            return retorno;
        }
    }
}

