/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.resumo;

import java.lang.ref.WeakReference;
import serpro.ppgd.irpf.resumo.CalculoImposto;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.irpf.tabelas.TabelaAliquotasIRPF;
import serpro.ppgd.negocio.Observador;

public class ObservadorDebitoAutomatico
extends Observador {
    private WeakReference<CalculoImposto> calculoImpostoRef = null;
    private Boolean eraImpostoRestituir = null;

    public ObservadorDebitoAutomatico(CalculoImposto calc) {
        this.calculoImpostoRef = new WeakReference<CalculoImposto>(calc);
    }

    public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
        if (!"habilitado".equals(nomePropriedade)) {
            this.habilitaDesabilitaDadosBancarios();
        }
    }

    public void habilitaDesabilitaDadosBancarios() {
        CalculoImposto calculoImposto = (CalculoImposto)((Object)this.calculoImpostoRef.get());
        if (calculoImposto != null) {
            boolean temDebitoAutomatico = calculoImposto.getDebitoAutomatico().naoFormatado().equals("autorizado");
            boolean impostoArestituir = calculoImposto.getImpostoRestituir().comparacao(">", "0,00");
            if (impostoArestituir) {
                calculoImposto.getIndicadorPrimeiraQuota().setReadOnly(true);
                if (this.eraImpostoRestituir != null && !this.eraImpostoRestituir.booleanValue()) {
                    calculoImposto.getBanco().clear();
                    calculoImposto.getAgencia().clear();
                    calculoImposto.getDvAgencia().clear();
                    calculoImposto.getContaCredito().clear();
                    calculoImposto.getDvContaCredito().clear();
                    calculoImposto.getIndicadorPrimeiraQuota().setConteudo("2");
                    calculoImposto.getTipoConta().clear();
                }
                if ("3".equals(calculoImposto.getTipoConta().naoFormatado())) {
                    calculoImposto.getBanco().setColecaoElementoTabela(CadastroTabelasIRPF.recuperarBancosContaPagamento());
                } else {
                    calculoImposto.getBanco().setColecaoElementoTabela(CadastroTabelasIRPF.recuperarBancosCredito());
                }
            } else {
                if (calculoImposto.getSaldoImpostoPagar().comparacao(">=", TabelaAliquotasIRPF.ConstantesAliquotas.valorMinIAP.getValor())) {
                    calculoImposto.getDebitoAutomatico().setHabilitado(true);
                }
                if (!temDebitoAutomatico) {
                    calculoImposto.getBanco().clear();
                    calculoImposto.getAgencia().clear();
                    calculoImposto.getDvAgencia().clear();
                    calculoImposto.getContaCredito().clear();
                    calculoImposto.getDvContaCredito().clear();
                    calculoImposto.getTipoConta().clear();
                    calculoImposto.getIndicadorPrimeiraQuota().setConteudo("2");
                } else {
                    calculoImposto.getBanco().setColecaoElementoTabela(CadastroTabelasIRPF.recuperarBancosDebito());
                }
                calculoImposto.getIndicadorPrimeiraQuota().setReadOnly(!temDebitoAutomatico);
            }
            this.eraImpostoRestituir = impostoArestituir;
        }
    }
}

