/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.resumo;

import serpro.ppgd.irpf.util.IRPFUtil;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Observador;

public class ObservadorContaCreditoCaixa
extends Observador {
    private Informacao banco;
    private Informacao conta;
    private Informacao contaCaixa;
    private Informacao operacao;

    public ObservadorContaCreditoCaixa(Codigo banco, Alfa contaCredito, Alfa contaCreditoCaixa, Alfa operacao) {
        this.banco = banco;
        this.conta = contaCredito;
        this.contaCaixa = contaCreditoCaixa;
        this.operacao = operacao;
    }

    public void notifica(Object arg0, String arg1, Object arg2, Object arg3) {
        if (this.banco.formatado().equals("104")) {
            String strConta = this.conta.isVazio() ? "" : IRPFUtil.formatarZerosEsquerda(this.conta.naoFormatado(), 8);
            String strOperacao = this.operacao.isVazio() ? "   " : IRPFUtil.formatarZerosEsquerda(this.operacao.naoFormatado(), 3);
            this.contaCaixa.setConteudo(strOperacao + strConta);
        } else {
            this.contaCaixa.clear();
        }
    }
}

