/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.resumo;

import serpro.ppgd.irpf.resumo.CalculoImposto;
import serpro.ppgd.irpf.tabelas.TabelaAliquotasIRPF;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class ObservadorCalcImpostoHabilitaDesabilita
extends Observador {
    private CalculoImposto calculoImposto = null;

    public ObservadorCalcImpostoHabilitaDesabilita(CalculoImposto calc) {
        this.calculoImposto = calc;
    }

    public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
        this.habilitadesabilitaDados();
    }

    public void habilitadesabilitaDados() {
        boolean impostoAPagar = this.calculoImposto.getSaldoImpostoPagar().comparacao(">", "0,00");
        this.calculoImposto.getNumQuotas().setHabilitado(impostoAPagar);
        this.calculoImposto.getDebitoAutomatico().setHabilitado(impostoAPagar);
        if (!impostoAPagar) {
            this.calculoImposto.getValorQuota().clear();
            this.calculoImposto.getNumQuotas().clear();
        }
        if (this.calculoImposto.getSaldoImpostoPagar().comparacao(">", "0,00")) {
            this.calculoImposto.getNumQuotas().setLimiteMinimo(1);
            if (this.calculoImposto.getSaldoImpostoPagar().comparacao("<", "100,00")) {
                this.calculoImposto.getNumQuotas().setConteudo(1);
                this.calculoImposto.getNumQuotas().setHabilitado(false);
            } else {
                String qtdeQuotas = "8";
                try {
                    qtdeQuotas = TabelaAliquotasIRPF.ConstantesAliquotas.qtdMaxQuota.getValor().naoFormatado();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Valor maxQuotas = this.calculoImposto.getSaldoImpostoPagar().operacao('/', TabelaAliquotasIRPF.ConstantesAliquotas.valorMinQuota.getValor());
                if (maxQuotas.comparacao(">", qtdeQuotas)) {
                    maxQuotas.setConteudo(qtdeQuotas);
                }
                if (this.calculoImposto.getNumQuotas().asInteger() == 0) {
                    this.calculoImposto.getNumQuotas().setConteudo(1);
                }
                this.calculoImposto.getNumQuotas().setHabilitado(true);
                this.calculoImposto.getNumQuotas().setLimiteMaximo(maxQuotas.getParteInteiraAsLong().intValue());
            }
        } else {
            this.calculoImposto.getNumQuotas().clear();
            this.calculoImposto.getNumQuotas().setLimiteMinimo(0);
            this.calculoImposto.getNumQuotas().setConteudo(0);
            this.calculoImposto.getValorQuota().clear();
            this.calculoImposto.getDebitoAutomatico().clear();
        }
    }
}

