/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.resumo;

import java.util.Map;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.tabelas.TabelaAliquotasIRPF;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Valor;

public abstract class ModeloDeclaracao
extends ObjetoNegocio {
    public static final String NOME_TOTAL_REND_RECEB_MAIS_EXTERIOR = "Total de Rendimentos Recebidos";
    public static final String NOME_TOTAL_LIVRO_CAIXA_TIT_DEP = "Total Livro Caixa - TIT + DEP";
    protected DeclaracaoIRPF declaracaoIRPF = null;
    protected Valor impostoDevido = new Valor((ObjetoNegocio)this, "");
    protected Valor impostoDevidoII = new Valor((ObjetoNegocio)this, "");
    protected Valor impostoDevidoI = new Valor((ObjetoNegocio)this, "");
    protected Valor impostoDevidoLei14754 = new Valor((ObjetoNegocio)this, "");
    protected Valor baseCalculo = new Valor((ObjetoNegocio)this, "");
    protected Valor saldoImpostoPagar = new Valor((ObjetoNegocio)this, "");
    protected Valor impostoRestituir = new Valor((ObjetoNegocio)this, "");
    protected Valor rendRecebidoExterior = new Valor((ObjetoNegocio)this, "");
    protected Valor impostoDevidoRRA = new Valor((ObjetoNegocio)this, "");
    protected Valor impostoRetidoRRA = new Valor((ObjetoNegocio)this, "");
    protected Valor totalRendRecebidosMaisExterior = new Valor((ObjetoNegocio)this, "Total de Rendimentos Recebidos");
    protected Valor totalLivroCaixa = new Valor((ObjetoNegocio)this, "Total Livro Caixa - TIT + DEP");
    protected Valor totalLimiteLivroCaixa = new Valor((ObjetoNegocio)this, "");
    protected Valor totalDoacoesCampanhasEleitorais = new Valor((ObjetoNegocio)this, "");

    public ModeloDeclaracao(DeclaracaoIRPF dec) {
        this.declaracaoIRPF = dec;
        this.totalRendRecebidosMaisExterior.setReadOnly(true);
    }

    public Valor getTotalRendRecebidosMaisExterior() {
        return this.totalRendRecebidosMaisExterior;
    }

    public Valor getTotalLivroCaixa() {
        return this.totalLivroCaixa;
    }

    public Valor getTotalLimiteLivroCaixa() {
        return this.totalLimiteLivroCaixa;
    }

    public Valor calculaImposto(Valor _baseCalculo) {
        Valor retorno = new Valor();
        if (this.declaracaoIRPF.getIdentificadorDeclaracao().isEspolio() || this.declaracaoIRPF.getIdentificadorDeclaracao().isSaida()) {
            Map<String, String> tabelaProgressiva = TabelaAliquotasIRPF.obterTabelaProgressivaMesesEspecificos(this.declaracaoIRPF.obterMesesTabelaProgressivaMensal());
            Valor valorAjusteLimiteMEFaixa1 = new Valor();
            Valor valorAjusteLimiteMEFaixa2 = new Valor();
            Valor valorAjusteLimiteMEFaixa3 = new Valor();
            Valor valorAjusteLimiteMEFaixa4 = new Valor();
            Valor valorAjusteDescontoMEFaixa1 = new Valor();
            Valor valorAjusteDescontoMEFaixa2 = new Valor();
            Valor valorAjusteDescontoMEFaixa3 = new Valor();
            Valor valorAjusteDescontoMEFaixa4 = new Valor();
            valorAjusteDescontoMEFaixa1.setCasasDecimais(4);
            valorAjusteDescontoMEFaixa2.setCasasDecimais(4);
            valorAjusteDescontoMEFaixa3.setCasasDecimais(4);
            valorAjusteDescontoMEFaixa4.setCasasDecimais(4);
            valorAjusteLimiteMEFaixa1.setConteudo(tabelaProgressiva.get("valorAjusteLimiteMEFaixa1"));
            valorAjusteLimiteMEFaixa2.setConteudo(tabelaProgressiva.get("valorAjusteLimiteMEFaixa2"));
            valorAjusteLimiteMEFaixa3.setConteudo(tabelaProgressiva.get("valorAjusteLimiteMEFaixa3"));
            valorAjusteLimiteMEFaixa4.setConteudo(tabelaProgressiva.get("valorAjusteLimiteMEFaixa4"));
            valorAjusteDescontoMEFaixa1.setConteudo(tabelaProgressiva.get("valorAjusteDescontoMEFaixa1"));
            valorAjusteDescontoMEFaixa2.setConteudo(tabelaProgressiva.get("valorAjusteDescontoMEFaixa2"));
            valorAjusteDescontoMEFaixa3.setConteudo(tabelaProgressiva.get("valorAjusteDescontoMEFaixa3"));
            valorAjusteDescontoMEFaixa4.setConteudo(tabelaProgressiva.get("valorAjusteDescontoMEFaixa4"));
            Valor imposto = new Valor();
            if (_baseCalculo.comparacao("<=", valorAjusteLimiteMEFaixa1)) {
                retorno.clear();
            } else if (_baseCalculo.comparacao("<=", valorAjusteLimiteMEFaixa2)) {
                Valor percentualFaixa1 = new Valor();
                percentualFaixa1.converteQtdCasasDecimais(4);
                percentualFaixa1.setConteudo(TabelaAliquotasIRPF.ConstantesAliquotas.percentualFaixa1.getValor());
                percentualFaixa1.append('/', "100,00");
                imposto.setConteudo(_baseCalculo);
                imposto.converteQtdCasasDecimais(4);
                imposto.setConteudo(imposto.operacao('*', percentualFaixa1));
                imposto.append('-', valorAjusteDescontoMEFaixa1);
                imposto.converteQtdCasasDecimais(2);
                retorno.setConteudo(imposto);
            } else if (_baseCalculo.comparacao("<=", valorAjusteLimiteMEFaixa3)) {
                Valor percentualFaixa2 = new Valor();
                percentualFaixa2.converteQtdCasasDecimais(4);
                percentualFaixa2.setConteudo(TabelaAliquotasIRPF.ConstantesAliquotas.percentualFaixa2.getValor());
                percentualFaixa2.append('/', "100,00");
                imposto.setConteudo(_baseCalculo);
                imposto.converteQtdCasasDecimais(4);
                imposto.setConteudo(imposto.operacao('*', percentualFaixa2));
                imposto.append('-', valorAjusteDescontoMEFaixa2);
                imposto.converteQtdCasasDecimais(2);
                retorno.setConteudo(imposto);
            } else if (_baseCalculo.comparacao("<=", valorAjusteLimiteMEFaixa4)) {
                Valor percentualFaixa3 = new Valor();
                percentualFaixa3.converteQtdCasasDecimais(4);
                percentualFaixa3.setConteudo(TabelaAliquotasIRPF.ConstantesAliquotas.percentualFaixa3.getValor());
                percentualFaixa3.append('/', "100,00");
                imposto.setConteudo(_baseCalculo);
                imposto.converteQtdCasasDecimais(4);
                imposto.setConteudo(imposto.operacao('*', percentualFaixa3));
                imposto.append('-', valorAjusteDescontoMEFaixa3);
                imposto.converteQtdCasasDecimais(2);
                retorno.setConteudo(imposto);
            } else {
                Valor percentualFaixa4 = new Valor();
                percentualFaixa4.converteQtdCasasDecimais(4);
                percentualFaixa4.setConteudo(TabelaAliquotasIRPF.ConstantesAliquotas.percentualFaixa4.getValor());
                percentualFaixa4.append('/', "100,00");
                imposto.setConteudo(_baseCalculo);
                imposto.converteQtdCasasDecimais(4);
                imposto.setConteudo(imposto.operacao('*', percentualFaixa4));
                imposto.append('-', valorAjusteDescontoMEFaixa4);
                imposto.converteQtdCasasDecimais(2);
                retorno.setConteudo(imposto);
            }
        } else if (_baseCalculo.comparacao("<=", TabelaAliquotasIRPF.ConstantesAliquotas.valorAjusteLimiteAnualFaixa1.getValor())) {
            retorno.clear();
        } else if (_baseCalculo.comparacao("<=", TabelaAliquotasIRPF.ConstantesAliquotas.valorAjusteLimiteAnualFaixa2.getValor())) {
            Valor percentualFaixa1 = new Valor();
            percentualFaixa1.converteQtdCasasDecimais(4);
            percentualFaixa1.setConteudo(TabelaAliquotasIRPF.ConstantesAliquotas.percentualFaixa1.getValor());
            percentualFaixa1.append('/', "100,00");
            Valor imposto = new Valor();
            imposto.setConteudo(_baseCalculo);
            imposto.converteQtdCasasDecimais(4);
            imposto.setConteudo(imposto.operacao('*', percentualFaixa1));
            imposto.append('-', TabelaAliquotasIRPF.ConstantesAliquotas.valorAjusteDescontoAnualFaixa1.getValor());
            imposto.converteQtdCasasDecimais(2);
            retorno.setConteudo(imposto);
        } else if (_baseCalculo.comparacao("<=", TabelaAliquotasIRPF.ConstantesAliquotas.valorAjusteLimiteAnualFaixa3.getValor())) {
            Valor percentualFaixa2 = new Valor();
            percentualFaixa2.converteQtdCasasDecimais(4);
            percentualFaixa2.setConteudo(TabelaAliquotasIRPF.ConstantesAliquotas.percentualFaixa2.getValor());
            percentualFaixa2.append('/', "100,00");
            Valor imposto = new Valor();
            imposto.setConteudo(_baseCalculo);
            imposto.converteQtdCasasDecimais(4);
            imposto.setConteudo(imposto.operacao('*', percentualFaixa2));
            imposto.append('-', TabelaAliquotasIRPF.ConstantesAliquotas.valorAjusteDescontoAnualFaixa2.getValor());
            imposto.converteQtdCasasDecimais(2);
            retorno.setConteudo(imposto);
        } else if (_baseCalculo.comparacao("<=", TabelaAliquotasIRPF.ConstantesAliquotas.valorAjusteLimiteAnualFaixa4.getValor())) {
            Valor percentualFaixa3 = new Valor();
            percentualFaixa3.converteQtdCasasDecimais(4);
            percentualFaixa3.setConteudo(TabelaAliquotasIRPF.ConstantesAliquotas.percentualFaixa3.getValor());
            percentualFaixa3.append('/', "100,00");
            Valor imposto = new Valor();
            imposto.setConteudo(_baseCalculo);
            imposto.converteQtdCasasDecimais(4);
            imposto.setConteudo(imposto.operacao('*', percentualFaixa3));
            imposto.append('-', TabelaAliquotasIRPF.ConstantesAliquotas.valorAjusteDescontoAnualFaixa3.getValor());
            imposto.converteQtdCasasDecimais(2);
            retorno.setConteudo(imposto);
        } else {
            Valor percentualFaixa4 = new Valor();
            percentualFaixa4.converteQtdCasasDecimais(4);
            percentualFaixa4.setConteudo(TabelaAliquotasIRPF.ConstantesAliquotas.percentualFaixa4.getValor());
            percentualFaixa4.append('/', "100,00");
            Valor imposto = new Valor();
            imposto.setConteudo(_baseCalculo);
            imposto.converteQtdCasasDecimais(4);
            imposto.setConteudo(imposto.operacao('*', percentualFaixa4));
            imposto.append('-', TabelaAliquotasIRPF.ConstantesAliquotas.valorAjusteDescontoAnualFaixa4.getValor());
            imposto.converteQtdCasasDecimais(2);
            retorno.setConteudo(imposto);
        }
        if (retorno.comparacao("<", "0,00")) {
            retorno.clear();
        }
        return retorno;
    }

    public Valor getImpostoDevido() {
        return this.impostoDevido;
    }

    public Valor getBaseCalculo() {
        return this.baseCalculo;
    }

    public Valor getSaldoImpostoPagar() {
        return this.saldoImpostoPagar;
    }

    public Valor getImpostoRestituir() {
        return this.impostoRestituir;
    }

    public Valor getImpostoDevidoRRA() {
        return this.impostoDevidoRRA;
    }

    public Valor getImpostoRetidoRRA() {
        return this.impostoRetidoRRA;
    }

    public abstract void resumoRendimentosTributaveis();

    public abstract void resumoCalculoImposto();

    public abstract void resumoOutrasInformacoes();

    public abstract void aplicaValoresNaDeclaracao();

    public abstract Valor recuperarTotalRendimentosTributaveis();

    public abstract Valor recuperarTotalImpostoPago();

    public abstract String recuperarCodInImpostoPago();

    public String recuperarCodInImpostoAntecipado() {
        String codStr = "0";
        if (!(this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoRetidoFonteTitular().isVazio() && this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoRetidoFonteDependentes().isVazio() && this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoComplementar().isVazio() && this.declaracaoIRPF.getResumo().getCalculoImposto().getCarneLeaoTitular().isVazio() && this.declaracaoIRPF.getResumo().getCalculoImposto().getCarneLeaoDependentes().isVazio() && this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoRetidoFonteLei11033().isVazio())) {
            codStr = "1";
        }
        return codStr;
    }

    public Valor getImpostoDevidoI() {
        return this.impostoDevidoI;
    }

    public Valor getImpostoDevidoII() {
        return this.impostoDevidoII;
    }

    public Valor getImpostoDevidoLei14754() {
        return this.impostoDevidoLei14754;
    }
}

