/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendpjexigibilidade;

import java.util.List;
import serpro.ppgd.cacheni.CacheNI;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.ObservadorEspacosDuplicados;
import serpro.ppgd.irpf.ValidadorNaoNuloIRPF;
import serpro.ppgd.irpf.ValorPositivo;
import serpro.ppgd.irpf.gui.rendpjexigsuspensa.PainelDadosRendPJComExigibilidade;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Pendencia;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.util.Validador;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNI;

public class RendPJComExigibilidadeTitular
extends ObjetoNegocio
implements ObjetoFicha {
    public static final String NOME_NI_FONTE_PAGADORA = "CPF/CNPJ da Fonte Pagadora";
    public static final String NOME_REND_EXIG_SUSP = "Rendimentos Tribut\u00e1veis (Imposto com Exigibilidade Suspensa)";
    public static final String NOME_DEPOSITO_JUDIC = "Dep\u00f3sito Judicial";
    protected transient IdentificadorDeclaracao identificadorDeclaracao = null;
    protected Alfa nomeFontePagadora = new Alfa((ObjetoNegocio)this, "Nome da Fonte Pagadora");
    protected NI NIFontePagadora = new NI((ObjetoNegocio)this, "CPF/CNPJ da Fonte Pagadora");
    protected ValorPositivo rendExigSuspensa = new ValorPositivo(this, "Rendimentos Tribut\u00e1veis (Imposto com Exigibilidade Suspensa)");
    protected ValorPositivo depositoJudicial = new ValorPositivo(this, "Dep\u00f3sito Judicial");

    public RendPJComExigibilidadeTitular(IdentificadorDeclaracao id) {
        this.identificadorDeclaracao = id;
        CacheNI.getInstancia().registrarNINome(this.NIFontePagadora, this.nomeFontePagadora);
        this.addValidadores();
    }

    public void addValidadores() {
        ValidadorNaoNuloIRPF validadorNaoNuloNomeFontePagadora = new ValidadorNaoNuloIRPF(3){

            @Override
            public RetornoValidacao validarImplementado() {
                RetornoValidacao retornoValidacao = Validador.validarNI((String)RendPJComExigibilidadeTitular.this.getNIFontePagadora().naoFormatado());
                if (retornoValidacao == null && RendPJComExigibilidadeTitular.this.getNomeFontePagadora().isVazio()) {
                    this.setSeveridade((byte)2);
                    return new RetornoValidacao(MensagemUtil.getMensagem("nome_fonte_pagadora_ausente"), 2);
                }
                if (retornoValidacao != null && RendPJComExigibilidadeTitular.this.getNomeFontePagadora().isVazio()) {
                    this.setSeveridade((byte)3);
                    return new RetornoValidacao(MensagemUtil.getMensagem("nome_fonte_pagadora_ausente"), 3);
                }
                return null;
            }
        };
        this.getNomeFontePagadora().addObservador((Observador)new ObservadorEspacosDuplicados());
        this.getNomeFontePagadora().addValidador((ValidadorIf)validadorNaoNuloNomeFontePagadora);
        ValidadorNaoNuloIRPF validadorNaoNuloNI = new ValidadorNaoNuloIRPF(3){

            @Override
            public RetornoValidacao validarImplementado() {
                if (RendPJComExigibilidadeTitular.this.getNIFontePagadora().naoFormatado().equals(RendPJComExigibilidadeTitular.this.identificadorDeclaracao.getCpf().naoFormatado())) {
                    this.setSeveridade((byte)3);
                    return new RetornoValidacao(MensagemUtil.getMensagem("ni_fonte_pagadora_igual_declarante"), 3);
                }
                if (!RendPJComExigibilidadeTitular.this.getNomeFontePagadora().isVazio() && RendPJComExigibilidadeTitular.this.getNIFontePagadora().isVazio()) {
                    this.setSeveridade((byte)2);
                    return new RetornoValidacao(MensagemUtil.getMensagem("ni_fonte_pagadora_branco"), 3);
                }
                return null;
            }
        };
        this.getNIFontePagadora().addValidador((ValidadorIf)new ValidadorNI(3, MensagemUtil.getMensagem("campo_invalido", new String[]{this.getNIFontePagadora().getNomeCampo()})));
        this.getNIFontePagadora().addValidador((ValidadorIf)validadorNaoNuloNI);
    }

    public void addObservador(Observador obs) {
        this.rendExigSuspensa.addObservador(obs);
        this.depositoJudicial.addObservador(obs);
        this.NIFontePagadora.addObservador(obs);
    }

    public void removeObservador(Observador obs) {
        this.rendExigSuspensa.removeObservador(obs);
        this.depositoJudicial.removeObservador(obs);
        this.NIFontePagadora.removeObservador(obs);
    }

    public NI getNIFontePagadora() {
        return this.NIFontePagadora;
    }

    public Alfa getNomeFontePagadora() {
        return this.nomeFontePagadora;
    }

    public ValorPositivo getDepositoJudicial() {
        return this.depositoJudicial;
    }

    public ValorPositivo getRendExigSuspensa() {
        return this.rendExigSuspensa;
    }

    public RendPJComExigibilidadeTitular obterCopia() {
        RendPJComExigibilidadeTitular copia = new RendPJComExigibilidadeTitular(IRPFFacade.getInstancia().getDeclaracao().getIdentificadorDeclaracao());
        copia.getNIFontePagadora().setConteudo(this.getNIFontePagadora());
        copia.getNomeFontePagadora().setConteudo(this.getNomeFontePagadora());
        copia.getRendExigSuspensa().setConteudo(this.getRendExigSuspensa());
        copia.getDepositoJudicial().setConteudo(this.getDepositoJudicial());
        return copia;
    }

    public Pendencia verificaValores(int numItem) {
        Pendencia retorno = null;
        if (this.getDepositoJudicial().isVazio() && this.getRendExigSuspensa().isVazio()) {
            retorno = new Pendencia(3, (Informacao)this.getRendExigSuspensa(), "Valores RendPJExigSusp", MensagemUtil.getMensagem("rendpjexigsusp_faltam_valores"), numItem);
        }
        return retorno;
    }

    public List<Pendencia> verificarPendencias(int numeroItem) {
        List retorno = super.verificarPendencias(numeroItem);
        Pendencia pendValores = this.verificaValores(numeroItem);
        if (pendValores != null) {
            pendValores.setClassePainel(this.getClasseFicha());
            retorno.add(pendValores);
        }
        return retorno;
    }

    protected List<Informacao> recuperarListaCamposPendencia() {
        List retorno = this.recuperarCamposInformacao();
        return retorno;
    }

    public boolean isVazio() {
        for (Informacao informacao : this.recuperarCamposInformacao()) {
            if (informacao.isVazio()) continue;
            return false;
        }
        return true;
    }

    public String getClasseFicha() {
        return PainelDadosRendPJComExigibilidade.class.getName();
    }

    public String getNomeAba() {
        return "Titular";
    }

    public String getTituloFichaDashboard() {
        return "Rendimentos Tribut\u00e1veis Recebidos de PJ com Exigibilidade Suspensa pelo Titular";
    }
}

