/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendpj;

import java.util.List;
import serpro.ppgd.cacheni.CacheNI;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.ObservadorEspacosDuplicados;
import serpro.ppgd.irpf.ValidadorNaoNuloIRPF;
import serpro.ppgd.irpf.ValorPositivo;
import serpro.ppgd.irpf.gui.rendpj.PainelDadosRendPJ;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.irpf.util.TipoDeclaracaoAES;
import serpro.ppgd.irpf.util.ValidadorIRPF;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Pendencia;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.util.Validador;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNI;

public class RendPJTitular
extends ObjetoNegocio
implements ObjetoFicha {
    public static final String NOME_NI_FONTE_PAGADORA = "CPF/CNPJ da Fonte Pagadora";
    public static final String NOME_REND_RECEB_PJ = "Rendimentos Recebidos de Pessoa Jur\u00eddica";
    public static final String NOME_CONTRIB_PREV = "Contribui\u00e7\u00e3o Previdenci\u00e1ria Oficial";
    public static final String NOME_IMPOSTO_RETIDO = "Imposto Retido na Fonte";
    public static final String NOME_DECIMO_TERCEIRO = "13\u00ba Sal\u00e1rio";
    public static final String NOME_IRRF_DECIMO_TERCEIRO = "IRRF sobre o 13\u00ba Sal\u00e1rio";
    public static final String NOME_DATA_COMUNICACAO_SAIDA = "Data de Comunica\u00e7\u00e3o da Condi\u00e7\u00e3o de N\u00e3o Residente \u00e0 Fonte Pagadora";
    protected transient IdentificadorDeclaracao identificadorDeclaracao = null;
    protected Alfa nomeFontePagadora = new Alfa((ObjetoNegocio)this, "Nome da Fonte Pagadora");
    protected NI NIFontePagadora = new NI((ObjetoNegocio)this, "CPF/CNPJ da Fonte Pagadora");
    protected ValorPositivo rendRecebidoPJ = new ValorPositivo(this, "Rendimentos Recebidos de Pessoa Jur\u00eddica");
    protected ValorPositivo contribuicaoPrevOficial = new ValorPositivo(this, "Contribui\u00e7\u00e3o Previdenci\u00e1ria Oficial");
    protected ValorPositivo impostoRetidoFonte = new ValorPositivo(this, "Imposto Retido na Fonte");
    protected ValorPositivo decimoTerceiro = new ValorPositivo(this, "13\u00ba Sal\u00e1rio");
    protected Data dataComunicacaoSaida = new Data((ObjetoNegocio)this, "Data de Comunica\u00e7\u00e3o da Condi\u00e7\u00e3o de N\u00e3o Residente \u00e0 Fonte Pagadora");
    protected ValorPositivo IRRFDecimoTerceiro = new ValorPositivo(this, "IRRF sobre o 13\u00ba Sal\u00e1rio");
    protected boolean isSaida = false;

    public RendPJTitular(IdentificadorDeclaracao id) {
        this.identificadorDeclaracao = id;
        this.isSaida = this.identificadorDeclaracao.getTipoDeclaracaoAES().formatado().equals(TipoDeclaracaoAES.SAIDA.getTipo());
        CacheNI.getInstancia().registrarNINome(this.NIFontePagadora, this.nomeFontePagadora);
        this.addValidadores();
    }

    public void addValidadores() {
        ValidadorNaoNuloIRPF validadorNaoNuloNomeFontePagadora = new ValidadorNaoNuloIRPF(3){

            @Override
            public RetornoValidacao validarImplementado() {
                RetornoValidacao retornoValidacao = Validador.validarNI((String)RendPJTitular.this.getNIFontePagadora().naoFormatado());
                if (retornoValidacao == null && RendPJTitular.this.getNomeFontePagadora().isVazio()) {
                    this.setSeveridade((byte)2);
                    return new RetornoValidacao(MensagemUtil.getMensagem("nome_fonte_pagadora_ausente"), 2);
                }
                if (retornoValidacao != null && RendPJTitular.this.getNomeFontePagadora().isVazio()) {
                    this.setSeveridade((byte)3);
                    return new RetornoValidacao(MensagemUtil.getMensagem("nome_fonte_pagadora_ausente"), 3);
                }
                return null;
            }
        };
        this.getNomeFontePagadora().addObservador((Observador)new ObservadorEspacosDuplicados());
        this.getNomeFontePagadora().addValidador((ValidadorIf)validadorNaoNuloNomeFontePagadora);
        ValidadorNaoNuloIRPF validadorNaoNuloNI = new ValidadorNaoNuloIRPF(3){

            @Override
            public RetornoValidacao validarImplementado() {
                RetornoValidacao retornoValidacao = Validador.validarNI((String)RendPJTitular.this.getNIFontePagadora().naoFormatado());
                if (RendPJTitular.this.getNIFontePagadora().naoFormatado().equals(RendPJTitular.this.identificadorDeclaracao.getCpf().naoFormatado())) {
                    this.setSeveridade((byte)3);
                    return new RetornoValidacao(MensagemUtil.getMensagem("ni_fonte_pagadora_igual_declarante"), 3);
                }
                if (retornoValidacao != null && !RendPJTitular.this.getImpostoRetidoFonte().isVazio()) {
                    this.setSeveridade((byte)3);
                    return new RetornoValidacao(MensagemUtil.getMensagem("ni_fonte_pagadora_branco"), 3);
                }
                if (retornoValidacao != null && RendPJTitular.this.getImpostoRetidoFonte().isVazio()) {
                    this.setSeveridade((byte)2);
                    return new RetornoValidacao(MensagemUtil.getMensagem("ni_fonte_pagadora_branco"), 3);
                }
                return null;
            }
        };
        this.getNIFontePagadora().addValidador((ValidadorIf)new ValidadorNI(3, MensagemUtil.getMensagem("campo_invalido", new String[]{this.getNIFontePagadora().getNomeCampo()})));
        this.getNIFontePagadora().addValidador((ValidadorIf)validadorNaoNuloNI);
        if (this.isSaida) {
            this.getDataComunicacaoSaida().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(2));
            this.getDataComunicacaoSaida().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

                @Override
                public RetornoValidacao validarImplementado() {
                    if (!this.getInformacao().isVazio()) {
                        return ValidadorIRPF.validarData(this.getInformacao(), 9999);
                    }
                    return null;
                }
            });
        }
    }

    public boolean todosValoresZerados() {
        return this.rendRecebidoPJ.isVazio() && this.contribuicaoPrevOficial.isVazio() && this.impostoRetidoFonte.isVazio() && this.decimoTerceiro.isVazio() && this.IRRFDecimoTerceiro.isVazio();
    }

    public void addObservador(Observador obs) {
        this.rendRecebidoPJ.addObservador(obs);
        this.contribuicaoPrevOficial.addObservador(obs);
        this.impostoRetidoFonte.addObservador(obs);
        this.decimoTerceiro.addObservador(obs);
        this.NIFontePagadora.addObservador(obs);
        this.IRRFDecimoTerceiro.addObservador(obs);
    }

    public void removeObservador(Observador obs) {
        this.rendRecebidoPJ.removeObservador(obs);
        this.contribuicaoPrevOficial.removeObservador(obs);
        this.impostoRetidoFonte.removeObservador(obs);
        this.decimoTerceiro.removeObservador(obs);
        this.NIFontePagadora.removeObservador(obs);
        this.IRRFDecimoTerceiro.removeObservador(obs);
    }

    public Valor getContribuicaoPrevOficial() {
        return this.contribuicaoPrevOficial;
    }

    public Valor getDecimoTerceiro() {
        return this.decimoTerceiro;
    }

    public ValorPositivo getIRRFDecimoTerceiro() {
        return this.IRRFDecimoTerceiro;
    }

    public Valor getImpostoRetidoFonte() {
        return this.impostoRetidoFonte;
    }

    public NI getNIFontePagadora() {
        return this.NIFontePagadora;
    }

    public Alfa getNomeFontePagadora() {
        return this.nomeFontePagadora;
    }

    public Valor getRendRecebidoPJ() {
        return this.rendRecebidoPJ;
    }

    public Data getDataComunicacaoSaida() {
        return this.dataComunicacaoSaida;
    }

    public RendPJTitular obterCopia() {
        RendPJTitular copia = new RendPJTitular(IRPFFacade.getInstancia().getDeclaracao().getIdentificadorDeclaracao());
        copia.getNIFontePagadora().setConteudo(this.getNIFontePagadora());
        copia.getNomeFontePagadora().setConteudo(this.getNomeFontePagadora());
        copia.getRendRecebidoPJ().setConteudo(this.getRendRecebidoPJ());
        copia.getContribuicaoPrevOficial().setConteudo(this.getContribuicaoPrevOficial());
        copia.getImpostoRetidoFonte().setConteudo(this.getImpostoRetidoFonte());
        copia.getDecimoTerceiro().setConteudo(this.getDecimoTerceiro());
        copia.getIRRFDecimoTerceiro().setConteudo(this.getIRRFDecimoTerceiro());
        copia.getDataComunicacaoSaida().setConteudo(this.getDataComunicacaoSaida());
        return copia;
    }

    public Pendencia verificaValores(int numItem) {
        Pendencia retorno = null;
        if (this.getImpostoRetidoFonte().isVazio() && this.getContribuicaoPrevOficial().isVazio() && this.getDecimoTerceiro().isVazio() && this.getRendRecebidoPJ().isVazio()) {
            retorno = new Pendencia(3, (Informacao)this.getRendRecebidoPJ(), "Valores RendPJ", MensagemUtil.getMensagem("rendpj_faltam_valores"), numItem);
            retorno.setNomeAba(this.getNomeAba());
        }
        return retorno;
    }

    public List<Pendencia> verificarPendencias(int numeroItem) {
        List retorno = super.verificarPendencias(numeroItem);
        Pendencia pendValores = this.verificaValores(numeroItem);
        if (pendValores != null) {
            pendValores.setClassePainel(this.getClasseFicha());
            retorno.add(pendValores);
        }
        return retorno;
    }

    protected List<Informacao> recuperarListaCamposPendencia() {
        List retorno = this.recuperarCamposInformacao();
        return retorno;
    }

    public boolean isVazio() {
        for (Informacao informacao : this.recuperarCamposInformacao()) {
            if (informacao.isVazio()) continue;
            return false;
        }
        return true;
    }

    public String getClasseFicha() {
        return PainelDadosRendPJ.class.getName();
    }

    public String getNomeAba() {
        return "Titular";
    }

    public String getTituloFichaDashboard() {
        return "Rendimentos Tribut\u00e1veis Recebidos de PJ pelo Titular";
    }
}

