/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendpj;

import java.lang.ref.WeakReference;
import java.util.List;
import serpro.ppgd.cacheni.CacheNI;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.ObservadorEspacosDuplicados;
import serpro.ppgd.irpf.ValidadorNaoNuloIRPF;
import serpro.ppgd.irpf.dependentes.Dependente;
import serpro.ppgd.irpf.rendpj.RendPJTitular;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.irpf.util.ValidadorIRPF;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Pendencia;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.util.Validador;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorCPF;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNI;

public class RendPJDependente
extends RendPJTitular
implements ObjetoFicha {
    private CPF cpfDependente = new CPF((ObjetoNegocio)this, "CPF");
    private Alfa nomeDependente = new Alfa((ObjetoNegocio)this, "Nome do dependente");
    private Alfa dependenteSaiuPaisMesmaDataDeclarante = new Alfa((ObjetoNegocio)this, "Dependente saiu do pa\u00eds na mesma data que o declarante?");
    private WeakReference<DeclaracaoIRPF> declaracaoRef = null;

    public RendPJDependente(DeclaracaoIRPF dec) {
        super(dec.getIdentificadorDeclaracao());
        this.declaracaoRef = new WeakReference<DeclaracaoIRPF>(dec);
        CacheNI.getInstancia().registrarNINome((NI)this.cpfDependente, this.nomeDependente);
        ValidadorNaoNuloIRPF validadorNaoNulo = new ValidadorNaoNuloIRPF(3);
        validadorNaoNulo.setMensagemValidacao(MensagemUtil.getMensagem("rendpjdep_cpf_branco"));
        this.getCpfDependente().addValidador((ValidadorIf)validadorNaoNulo);
        ValidadorCPF validadorCPF = new ValidadorCPF(3);
        validadorCPF.setMensagemValidacao(MensagemUtil.getMensagem("rendpjdep_cpf_invalido"));
        this.getCpfDependente().addValidador((ValidadorIf)validadorCPF);
        this.getCpfDependente().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                DeclaracaoIRPF declaracaoIRPF = (DeclaracaoIRPF)((Object)RendPJDependente.this.declaracaoRef.get());
                if (!declaracaoIRPF.getDependentes().isExisteCpf(RendPJDependente.this.getCpfDependente().naoFormatado())) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("rendpjdep_cpf_nao_existe"), 3);
                }
                return null;
            }
        });
        this.getCpfDependente().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (valorNovo == null || valorNovo.toString().trim().isEmpty()) {
                    RendPJDependente.this.nomeDependente.clear();
                    RendPJDependente.this.dependenteSaiuPaisMesmaDataDeclarante.clear();
                } else {
                    Dependente d = ((DeclaracaoIRPF)((Object)RendPJDependente.this.declaracaoRef.get())).getDependentes().getDependenteByCpf(RendPJDependente.this.getCpfDependente().naoFormatado());
                    if (d != null) {
                        RendPJDependente.this.nomeDependente.setConteudo(d.getNome());
                        RendPJDependente.this.dependenteSaiuPaisMesmaDataDeclarante.setConteudo(d.getIndSaidaPaisMesmaData());
                    }
                }
            }
        });
    }

    @Override
    public void addValidadores() {
        ValidadorNaoNuloIRPF validadorNaoNuloNomeFontePagadora = new ValidadorNaoNuloIRPF(3){

            @Override
            public RetornoValidacao validarImplementado() {
                RetornoValidacao retornoValidacao = Validador.validarNI((String)RendPJDependente.this.getNIFontePagadora().naoFormatado());
                if (retornoValidacao == null && RendPJDependente.this.getNomeFontePagadora().isVazio()) {
                    this.setSeveridade((byte)2);
                    return new RetornoValidacao(MensagemUtil.getMensagem("nome_fonte_pagadora_ausente"), 2);
                }
                if (retornoValidacao != null && RendPJDependente.this.getNomeFontePagadora().isVazio()) {
                    this.setSeveridade((byte)3);
                    return new RetornoValidacao(MensagemUtil.getMensagem("nome_fonte_pagadora_ausente"), 3);
                }
                return null;
            }
        };
        this.getNomeFontePagadora().addObservador((Observador)new ObservadorEspacosDuplicados());
        this.getNomeFontePagadora().addValidador((ValidadorIf)validadorNaoNuloNomeFontePagadora);
        ValidadorNaoNuloIRPF validadorNaoNuloNI = new ValidadorNaoNuloIRPF(3){

            @Override
            public RetornoValidacao validarImplementado() {
                RetornoValidacao retornoValidacao = Validador.validarNI((String)RendPJDependente.this.getNIFontePagadora().naoFormatado());
                if (!RendPJDependente.this.getNIFontePagadora().naoFormatado().isEmpty() && RendPJDependente.this.getNIFontePagadora().naoFormatado().equals(RendPJDependente.this.getCpfDependente().naoFormatado())) {
                    this.setSeveridade((byte)3);
                    return new RetornoValidacao(MensagemUtil.getMensagem("ni_fonte_pagadora_igual_dependente"), 3);
                }
                if (retornoValidacao != null && !RendPJDependente.this.getImpostoRetidoFonte().isVazio()) {
                    this.setSeveridade((byte)3);
                    return new RetornoValidacao(MensagemUtil.getMensagem("ni_fonte_pagadora_branco"), 3);
                }
                if (retornoValidacao != null && RendPJDependente.this.getImpostoRetidoFonte().isVazio()) {
                    this.setSeveridade((byte)2);
                    return new RetornoValidacao(MensagemUtil.getMensagem("ni_fonte_pagadora_branco"), 2);
                }
                return null;
            }
        };
        this.getNIFontePagadora().addValidador((ValidadorIf)new ValidadorNI(3, MensagemUtil.getMensagem("campo_invalido", new String[]{this.getNIFontePagadora().getNomeCampo()})));
        this.getNIFontePagadora().addValidador((ValidadorIf)validadorNaoNuloNI);
        if (this.isSaida) {
            this.getDataComunicacaoSaida().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(2){

                @Override
                public RetornoValidacao validarImplementado() {
                    Dependente dep = ((DeclaracaoIRPF)((Object)RendPJDependente.this.declaracaoRef.get())).getDependentes().getDependenteByCpf(RendPJDependente.this.cpfDependente.naoFormatado());
                    if (dep != null && dep.getIndSaidaPaisMesmaData().naoFormatado().equals(Logico.NAO)) {
                        return null;
                    }
                    return super.validarImplementado();
                }
            });
            this.getDataComunicacaoSaida().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

                @Override
                public RetornoValidacao validarImplementado() {
                    if (!this.getInformacao().isVazio()) {
                        return ValidadorIRPF.validarData(this.getInformacao(), Integer.valueOf(ConstantesGlobais.ANO_BASE_SEGUINTE));
                    }
                    return null;
                }
            });
            this.getDataComunicacaoSaida().addValidador((ValidadorIf)new ValidadorDefault(2){

                public RetornoValidacao validarImplementado() {
                    Dependente dep = ((DeclaracaoIRPF)((Object)RendPJDependente.this.declaracaoRef.get())).getDependentes().getDependenteByCpf(RendPJDependente.this.cpfDependente.naoFormatado());
                    if (dep != null && dep.getIndSaidaPaisMesmaData().naoFormatado().equals(Logico.SIM)) {
                        return null;
                    }
                    return new RetornoValidacao(MensagemUtil.getMensagem("rendpjdep_dt_comunicacao_saida_sem_sair"), this.getSeveridade());
                }
            });
        }
    }

    public CPF getCpfDependente() {
        return this.cpfDependente;
    }

    public Alfa getDependenteSaiuPaisMesmaDataDeclarante() {
        return this.dependenteSaiuPaisMesmaDataDeclarante;
    }

    @Override
    public RendPJDependente obterCopia() {
        RendPJDependente copia = new RendPJDependente(IRPFFacade.getInstancia().getDeclaracao());
        copia.getCpfDependente().setConteudo(this.getCpfDependente());
        copia.getDependenteSaiuPaisMesmaDataDeclarante().setConteudo(this.getDependenteSaiuPaisMesmaDataDeclarante());
        copia.getNIFontePagadora().setConteudo(this.getNIFontePagadora());
        copia.getNomeFontePagadora().setConteudo(this.getNomeFontePagadora());
        copia.getRendRecebidoPJ().setConteudo(this.getRendRecebidoPJ());
        copia.getContribuicaoPrevOficial().setConteudo(this.getContribuicaoPrevOficial());
        copia.getImpostoRetidoFonte().setConteudo(this.getImpostoRetidoFonte());
        copia.getDecimoTerceiro().setConteudo(this.getDecimoTerceiro());
        copia.getIRRFDecimoTerceiro().setConteudo(this.getIRRFDecimoTerceiro());
        copia.getDataComunicacaoSaida().setConteudo(this.getDataComunicacaoSaida());
        return copia;
    }

    @Override
    public List<Pendencia> verificarPendencias(int numeroItem) {
        List<Pendencia> retorno = super.verificarPendencias(numeroItem);
        return retorno;
    }

    @Override
    protected List<Informacao> recuperarListaCamposPendencia() {
        List retorno = this.recuperarCamposInformacao();
        return retorno;
    }

    @Override
    public String getNomeAba() {
        return "Dependentes";
    }
}

