/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendpj;

import java.util.List;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.gui.rendpj.PainelDadosRendPJ;
import serpro.ppgd.irpf.rendpj.RendPJTitular;
import serpro.ppgd.irpf.util.ConstantesGlobaisIRPF;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Valor;

public class ColecaoRendPJTitular
extends Colecao<RendPJTitular>
implements ObjetoFicha {
    public static final String NOME_TOTAIS_RENDPJ = "Totais Rend. Recebid";
    protected transient IdentificadorDeclaracao identificadorDeclaracao = null;
    protected NI niMaiorFontePagadora = new NI((ObjetoNegocio)this, "NI");
    protected Valor totaisRendRecebidoPJ = new Valor((ObjetoNegocio)this, "Totais Rend. Recebid");
    protected Valor totaisContribuicaoPrevOficial = new Valor((ObjetoNegocio)this, "Totais Contr. Prev. Oficial");
    protected Valor totaisImpostoRetidoFonte = new Valor((ObjetoNegocio)this, "Totais IR Retido na Fonte");
    protected Valor totaisDecimoTerceiro = new Valor((ObjetoNegocio)this, "Totais 13\u00ba Sal\u00e1rio");
    protected Valor totaisIRRFDecimoTerceiro = new Valor((ObjetoNegocio)this, "IRRF sobre o 13\u00ba Sal\u00e1rio");

    public Valor getTotaisIRRFDecimoTerceiro() {
        return this.totaisIRRFDecimoTerceiro;
    }

    public ColecaoRendPJTitular(IdentificadorDeclaracao id) {
        this.identificadorDeclaracao = id;
        this.totaisRendRecebidoPJ.setReadOnly(true);
        this.totaisContribuicaoPrevOficial.setReadOnly(true);
        this.totaisImpostoRetidoFonte.setReadOnly(true);
        this.totaisDecimoTerceiro.setReadOnly(true);
        this.totaisIRRFDecimoTerceiro.setReadOnly(true);
        this.niMaiorFontePagadora.setReadOnly(true);
        this.setFicha("Rendimentos Tribut\u00e1veis Recebidos de PJ pelo Titular");
    }

    public RendPJTitular obterRendimentoPorChave(String niFontePagadora) {
        for (RendPJTitular rend : this.itens()) {
            if (!rend.getNIFontePagadora().naoFormatado().equals(niFontePagadora)) continue;
            return rend;
        }
        return null;
    }

    public RendPJTitular getRendimentoVazioPorNIFontePagadora(NI niFonte) {
        for (RendPJTitular rend : this.itens()) {
            if (!rend.getNIFontePagadora().naoFormatado().equals(niFonte.naoFormatado()) || !rend.todosValoresZerados()) continue;
            return rend;
        }
        return null;
    }

    public boolean existeRendimentoPreenchidoComNIFontePagadora(NI niFonte) {
        for (RendPJTitular rend : this.itens()) {
            if (!rend.getNIFontePagadora().naoFormatado().equals(niFonte.naoFormatado()) || rend.todosValoresZerados()) continue;
            return true;
        }
        return false;
    }

    public boolean existeContribuicaoPrevidenciariaOficial() {
        for (RendPJTitular rend : this.itens()) {
            if (rend.getContribuicaoPrevOficial().isVazio()) continue;
            return true;
        }
        return false;
    }

    public void objetoInserido(RendPJTitular rendPJTitular) {
        rendPJTitular.setFicha(this.getFicha());
    }

    public RendPJTitular instanciaNovoObjeto() {
        return new RendPJTitular(this.identificadorDeclaracao);
    }

    public boolean existeRendimentoComDadosIncompletos() {
        boolean retorno = false;
        for (RendPJTitular rendPJ : this.itens()) {
            if (rendPJ.getNomeFontePagadora().isValido() && rendPJ.getNIFontePagadora().isValido() && !rendPJ.getNomeFontePagadora().isVazio() && !rendPJ.getNIFontePagadora().isVazio()) continue;
            retorno = true;
            break;
        }
        return retorno;
    }

    public Valor getTotaisContribuicaoPrevOficial() {
        return this.totaisContribuicaoPrevOficial;
    }

    public Valor getTotaisDecimoTerceiro() {
        return this.totaisDecimoTerceiro;
    }

    public Valor getTotaisImpostoRetidoFonte() {
        return this.totaisImpostoRetidoFonte;
    }

    public Valor getTotaisRendRecebidoPJ() {
        return this.totaisRendRecebidoPJ;
    }

    public NI getNiMaiorFontePagadora() {
        return this.niMaiorFontePagadora;
    }

    protected List<Informacao> recuperarListaCamposPendencia() {
        List listaCamposPendencia = super.recuperarListaCamposPendencia();
        listaCamposPendencia.add(this.totaisRendRecebidoPJ);
        return listaCamposPendencia;
    }

    public String getClasseFicha() {
        return PainelDadosRendPJ.class.getName();
    }

    public String getNomeAba() {
        return "Titular";
    }

    public String getTituloFichaDashboard() {
        return "Rendimentos Tribut\u00e1veis Recebidos de PJ pelo Titular";
    }

    public Valor obterTotalRendPJSemAuxilioEmergencial() {
        Valor total = new Valor();
        for (RendPJTitular rendPJ : this.itens()) {
            if (ConstantesGlobaisIRPF.CNPJ_AUXILIO_EMERGENCIAL.equals(rendPJ.getNIFontePagadora().naoFormatado())) continue;
            total.append('+', rendPJ.getRendRecebidoPJ());
        }
        return total;
    }
}

