/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendpf;

import java.util.Iterator;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.rendpf.Conta;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class ContasMes
extends Colecao<Conta> {
    public static final String NOME_ABA_JANEIRO = "Janeiro";
    public static final String NOME_ABA_FEVEREIRO = "Fevereiro";
    public static final String NOME_ABA_MARCO = "Mar\u00e7o";
    public static final String NOME_ABA_ABRIL = "Abril";
    public static final String NOME_ABA_MAIO = "Maio";
    public static final String NOME_ABA_JUNHO = "Junho";
    public static final String NOME_ABA_JULHO = "Julho";
    public static final String NOME_ABA_AGOSTO = "Agosto";
    public static final String NOME_ABA_SETEMBRO = "Setembro";
    public static final String NOME_ABA_OUTUBRO = "Outubro";
    public static final String NOME_ABA_NOVEMBRO = "Novembro";
    public static final String NOME_ABA_DEZEMBRO = "Dezembro";
    private int numMes = 0;
    private Alfa nomeMes = new Alfa((ObjetoNegocio)this, "");
    private Valor totalRendTrabNaoAssPF = new Valor((ObjetoNegocio)this, "C1");

    public ContasMes() {
        this.setFicha("Rendimentos Tribut\u00e1veis Recebidos de PF e do Exterior - Titular");
    }

    public Alfa getNomeMes() {
        return this.nomeMes;
    }

    public Valor getTotalRendTrabNaoAssPF() {
        return this.totalRendTrabNaoAssPF;
    }

    public int getNumMes() {
        return this.numMes;
    }

    public void setNumMes(int numMes) {
        this.numMes = numMes;
        this.nomeMes.setConteudo(String.valueOf(numMes));
    }

    public String getNumMesAsString() {
        Object strMes = String.valueOf(this.numMes);
        if (this.numMes < 10) {
            strMes = "0" + (String)strMes;
        }
        return strMes;
    }

    public static String obterNomeMesExtenso(String mes) {
        String nomeMes = null;
        nomeMes = mes.equals(NOME_ABA_JANEIRO) ? "janeiro" : (mes.equals(NOME_ABA_FEVEREIRO) ? "fevereiro" : (mes.equals(NOME_ABA_MARCO) ? "mar\u00e7o" : (mes.equals(NOME_ABA_ABRIL) ? "abril" : (mes.equals(NOME_ABA_MAIO) ? "maio" : (mes.equals(NOME_ABA_JUNHO) ? "junho" : (mes.equals(NOME_ABA_JULHO) ? "julho" : (mes.equals(NOME_ABA_AGOSTO) ? "agosto" : (mes.equals(NOME_ABA_SETEMBRO) ? "setembro" : (mes.equals(NOME_ABA_OUTUBRO) ? "outubro" : (mes.equals(NOME_ABA_NOVEMBRO) ? "novembro" : (mes.equals(NOME_ABA_DEZEMBRO) ? "dezembro" : "***")))))))))));
        return nomeMes;
    }

    public static String obterNomeMesExtenso(int mes) {
        String nomeMes = null;
        nomeMes = mes == 1 ? "janeiro" : (mes == 2 ? "fevereiro" : (mes == 3 ? "mar\u00e7o" : (mes == 4 ? "abril" : (mes == 5 ? "maio" : (mes == 6 ? "junho" : (mes == 7 ? "julho" : (mes == 8 ? "agosto" : (mes == 9 ? "setembro" : (mes == 10 ? "outubro" : (mes == 11 ? "novembro" : (mes == 12 ? "dezembro" : "***")))))))))));
        return nomeMes;
    }

    public static String obterSiglaMes(int mes) {
        String nomeMes = null;
        nomeMes = mes == 1 ? "JAN" : (mes == 2 ? "FEV" : (mes == 3 ? "MAR" : (mes == 4 ? "ABR" : (mes == 5 ? "MAI" : (mes == 6 ? "JUN" : (mes == 7 ? "JUL" : (mes == 8 ? "AGO" : (mes == 9 ? "SET" : (mes == 10 ? "OUT" : (mes == 11 ? "NOV" : (mes == 12 ? "DEZ" : "***")))))))))));
        return nomeMes;
    }

    public static String obterIndiceAsString(String siglaMes) {
        siglaMes = siglaMes.toUpperCase();
        String indiceMes = "";
        if (siglaMes.equals("JAN") || siglaMes.equals("JANEIRO")) {
            indiceMes = "01";
        } else if (siglaMes.equals("FEV") || siglaMes.equals("FEVEREIRO")) {
            indiceMes = "02";
        } else if (siglaMes.equals("MAR") || siglaMes.equals("MARCO") || siglaMes.equals("MAR\u00c7O")) {
            indiceMes = "03";
        } else if (siglaMes.equals("ABR") || siglaMes.equals("ABRIL")) {
            indiceMes = "04";
        } else if (siglaMes.equals("MAI") || siglaMes.equals("MAIO")) {
            indiceMes = "05";
        } else if (siglaMes.equals("JUN") || siglaMes.equals("JUNHO")) {
            indiceMes = "06";
        } else if (siglaMes.equals("JUL") || siglaMes.equals("JULHO")) {
            indiceMes = "07";
        } else if (siglaMes.equals("AGO") || siglaMes.equals("AGOSTO")) {
            indiceMes = "08";
        } else if (siglaMes.equals("SET") || siglaMes.equals("SETEMBRO")) {
            indiceMes = "09";
        } else if (siglaMes.equals("OUT") || siglaMes.equals("OUTUBRO")) {
            indiceMes = "10";
        } else if (siglaMes.equals("NOV") || siglaMes.equals("NOVEMBRO")) {
            indiceMes = "11";
        } else if (siglaMes.equals("DEZ") || siglaMes.equals("DEZEMBRO")) {
            indiceMes = "12";
        }
        return indiceMes;
    }

    public void removerContasEmBranco() {
        Iterator iterator = this.itens().iterator();
        while (iterator.hasNext()) {
            Conta conta = (Conta)((Object)iterator.next());
            if (!conta.isEmpty()) continue;
            iterator.remove();
        }
    }

    public Valor getSomaTrabalhoNaoAssalariadoMes() {
        Valor soma = new Valor("0,00");
        for (Conta conta : this.itens()) {
            soma.append('+', conta.getValor());
        }
        return soma;
    }

    public void objetoRemovido(Object o) {
        super.objetoRemovido(o);
        this.totalRendTrabNaoAssPF.setConteudo(this.getSomaTrabalhoNaoAssalariadoMes());
    }

    public void objetoInserido(Conta ct) {
        super.objetoInserido((ObjetoNegocio)ct);
        try {
            String cpfTitular = null;
            if (IRPFFacade.getInstancia().getIdDeclaracaoAberto() != null) {
                cpfTitular = IRPFFacade.getInstancia().getIdDeclaracaoAberto().getCpf().naoFormatado();
            } else if (IRPFFacade.getInstancia().getDeclaracaoEmGravacao() != null) {
                cpfTitular = IRPFFacade.getInstancia().getDeclaracaoEmGravacao().getIdentificadorDeclaracao().getCpf().naoFormatado();
            }
            if (cpfTitular != null) {
                if (ct.getCpfContribuinte().naoFormatado().equals(cpfTitular)) {
                    ct.setFicha("Rendimentos Tribut\u00e1veis Recebidos de PF e do Exterior - Titular");
                } else {
                    ct.setFicha("Rendimentos Tribut\u00e1veis Recebidos de PF e do Exterior - Dependentes");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.totalRendTrabNaoAssPF.setConteudo(this.getSomaTrabalhoNaoAssalariadoMes());
        ct.getValor().addObservador(new Observador(){

            public void notifica(Object o, String string, Object o1, Object o2) {
                ContasMes.this.totalRendTrabNaoAssPF.setConteudo(ContasMes.this.getSomaTrabalhoNaoAssalariadoMes());
            }
        });
    }
}

