/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendavariavel;

import java.util.HashMap;
import java.util.Map;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.ValorPositivo;
import serpro.ppgd.irpf.rendavariavel.GanhosLiquidosOuPerdas;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class RendaVariavel
extends ObjetoNegocio {
    public static final String TOTAL_BASE_CALCULO = "Total Base C\u00e1lculo";
    public static final String TOTAL_IR_FONTE_DAY_TRADE = "Total IR Fonte Day Trade";
    public static final String TOTAL_IR_FONTE_LEI_11033 = "Total IR Fonte Lei 11.033";
    public static final String TOTAL_IMPOSTO_A_PAGAR = "Total Imposto a Pagar";
    public static final String TOTAL_IMPOSTO_PAGO = "Total Imposto Pago";
    private GanhosLiquidosOuPerdas janeiro;
    private GanhosLiquidosOuPerdas fevereiro;
    private GanhosLiquidosOuPerdas marco;
    private GanhosLiquidosOuPerdas abril;
    private GanhosLiquidosOuPerdas maio;
    private GanhosLiquidosOuPerdas junho;
    private GanhosLiquidosOuPerdas julho;
    private GanhosLiquidosOuPerdas agosto;
    private GanhosLiquidosOuPerdas setembro;
    private GanhosLiquidosOuPerdas outubro;
    private GanhosLiquidosOuPerdas novembro;
    private GanhosLiquidosOuPerdas dezembro;
    private Valor totalBaseCalculo = new Valor((ObjetoNegocio)this, "Total Base C\u00e1lculo");
    private Valor totalIRFonteDayTrade = new Valor((ObjetoNegocio)this, "Total IR Fonte Day Trade");
    private Valor totalImpostoRetidoFonteLei11033 = new Valor((ObjetoNegocio)this, "Total IR Fonte Lei 11.033");
    private Valor totalImpostoAPagar = new Valor((ObjetoNegocio)this, "Total Imposto a Pagar");
    private Valor totalImpostoPago = new Valor((ObjetoNegocio)this, "Total Imposto Pago");

    public RendaVariavel(DeclaracaoIRPF dec, boolean ehDependente) {
        this.instanciarMeses(dec, ehDependente);
        this.getJaneiro().getOperacoesComuns().getResultadoNegativoMesAnterior().setHabilitado(true);
        this.getJaneiro().getOperacoesDayTrade().getResultadoNegativoMesAnterior().setHabilitado(true);
        this.addObservadorAtualizaIrFonteDayTradeProxMes(this.janeiro, this.fevereiro);
        this.addObservadorAtualizaIrFonteDayTradeProxMes(this.fevereiro, this.marco);
        this.addObservadorAtualizaIrFonteDayTradeProxMes(this.marco, this.abril);
        this.addObservadorAtualizaIrFonteDayTradeProxMes(this.abril, this.maio);
        this.addObservadorAtualizaIrFonteDayTradeProxMes(this.maio, this.junho);
        this.addObservadorAtualizaIrFonteDayTradeProxMes(this.junho, this.julho);
        this.addObservadorAtualizaIrFonteDayTradeProxMes(this.julho, this.agosto);
        this.addObservadorAtualizaIrFonteDayTradeProxMes(this.agosto, this.setembro);
        this.addObservadorAtualizaIrFonteDayTradeProxMes(this.setembro, this.outubro);
        this.addObservadorAtualizaIrFonteDayTradeProxMes(this.outubro, this.novembro);
        this.addObservadorAtualizaIrFonteDayTradeProxMes(this.novembro, this.dezembro);
        this.addObservadorAtualizaIrFonteLei11033ProxMes(this.janeiro, this.fevereiro);
        this.addObservadorAtualizaIrFonteLei11033ProxMes(this.fevereiro, this.marco);
        this.addObservadorAtualizaIrFonteLei11033ProxMes(this.marco, this.abril);
        this.addObservadorAtualizaIrFonteLei11033ProxMes(this.abril, this.maio);
        this.addObservadorAtualizaIrFonteLei11033ProxMes(this.maio, this.junho);
        this.addObservadorAtualizaIrFonteLei11033ProxMes(this.junho, this.julho);
        this.addObservadorAtualizaIrFonteLei11033ProxMes(this.julho, this.agosto);
        this.addObservadorAtualizaIrFonteLei11033ProxMes(this.agosto, this.setembro);
        this.addObservadorAtualizaIrFonteLei11033ProxMes(this.setembro, this.outubro);
        this.addObservadorAtualizaIrFonteLei11033ProxMes(this.outubro, this.novembro);
        this.addObservadorAtualizaIrFonteLei11033ProxMes(this.novembro, this.dezembro);
        this.addObservadorAtualizaResultadoNegativoProxMes(this.janeiro, this.fevereiro);
        this.addObservadorAtualizaResultadoNegativoProxMes(this.fevereiro, this.marco);
        this.addObservadorAtualizaResultadoNegativoProxMes(this.marco, this.abril);
        this.addObservadorAtualizaResultadoNegativoProxMes(this.abril, this.maio);
        this.addObservadorAtualizaResultadoNegativoProxMes(this.maio, this.junho);
        this.addObservadorAtualizaResultadoNegativoProxMes(this.junho, this.julho);
        this.addObservadorAtualizaResultadoNegativoProxMes(this.julho, this.agosto);
        this.addObservadorAtualizaResultadoNegativoProxMes(this.agosto, this.setembro);
        this.addObservadorAtualizaResultadoNegativoProxMes(this.setembro, this.outubro);
        this.addObservadorAtualizaResultadoNegativoProxMes(this.outubro, this.novembro);
        this.addObservadorAtualizaResultadoNegativoProxMes(this.novembro, this.dezembro);
    }

    private void instanciarMeses(DeclaracaoIRPF dec, boolean ehDependente) {
        this.janeiro = new GanhosLiquidosOuPerdas(dec, "Janeiro", ehDependente);
        this.fevereiro = new GanhosLiquidosOuPerdas(dec, "Fevereiro", ehDependente);
        this.marco = new GanhosLiquidosOuPerdas(dec, "Mar\u00e7o", ehDependente);
        this.abril = new GanhosLiquidosOuPerdas(dec, "Abril", ehDependente);
        this.maio = new GanhosLiquidosOuPerdas(dec, "Maio", ehDependente);
        this.junho = new GanhosLiquidosOuPerdas(dec, "Junho", ehDependente);
        this.julho = new GanhosLiquidosOuPerdas(dec, "Julho", ehDependente);
        this.agosto = new GanhosLiquidosOuPerdas(dec, "Agosto", ehDependente);
        this.setembro = new GanhosLiquidosOuPerdas(dec, "Setembro", ehDependente);
        this.outubro = new GanhosLiquidosOuPerdas(dec, "Outubro", ehDependente);
        this.novembro = new GanhosLiquidosOuPerdas(dec, "Novembro", ehDependente);
        this.dezembro = new GanhosLiquidosOuPerdas(dec, "Dezembro", ehDependente);
    }

    public void addObservador(Observador obs) {
        this.totalBaseCalculo.addObservador(obs);
        this.totalIRFonteDayTrade.addObservador(obs);
        this.totalImpostoRetidoFonteLei11033.addObservador(obs);
        this.totalImpostoPago.addObservador(obs);
        this.totalImpostoAPagar.addObservador(obs);
    }

    public void removeObservador(Observador obs) {
        this.totalBaseCalculo.removeObservador(obs);
        this.totalIRFonteDayTrade.removeObservador(obs);
        this.totalImpostoRetidoFonteLei11033.removeObservador(obs);
        this.totalImpostoPago.removeObservador(obs);
        this.totalImpostoAPagar.removeObservador(obs);
    }

    private void addObservadorAtualizaIrFonteDayTradeProxMes(GanhosLiquidosOuPerdas ganhosMesAnt, GanhosLiquidosOuPerdas ganhosMesPost) {
        class ObservadorAtualizaIRDayTradeProxMes
        extends Observador {
            GanhosLiquidosOuPerdas ganhoMesAnterior = null;
            GanhosLiquidosOuPerdas ganhoMesPosterior = null;

            public ObservadorAtualizaIRDayTradeProxMes(GanhosLiquidosOuPerdas _ganhoMesAnterior, GanhosLiquidosOuPerdas _ganhoMesPosterior) {
                this.ganhoMesAnterior = _ganhoMesAnterior;
                this.ganhoMesPosterior = _ganhoMesPosterior;
            }

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                this.ganhoMesPosterior.getIrFonteDayTradeMesesAnteriores().setConteudo(this.ganhoMesAnterior.getIrFonteDayTradeAcompensar());
            }
        }
        ganhosMesAnt.getIrFonteDayTradeAcompensar().addObservador((Observador)new ObservadorAtualizaIRDayTradeProxMes(ganhosMesAnt, ganhosMesPost));
    }

    private void addObservadorAtualizaIrFonteLei11033ProxMes(GanhosLiquidosOuPerdas ganhosMesAnt, GanhosLiquidosOuPerdas ganhosMesPost) {
        class ObservadorAtualizaIRLei11033ProxMes
        extends Observador {
            GanhosLiquidosOuPerdas ganhoMesAnterior = null;
            GanhosLiquidosOuPerdas ganhoMesPosterior = null;

            public ObservadorAtualizaIRLei11033ProxMes(GanhosLiquidosOuPerdas _ganhoMesAnterior, GanhosLiquidosOuPerdas _ganhoMesPosterior) {
                this.ganhoMesAnterior = _ganhoMesAnterior;
                this.ganhoMesPosterior = _ganhoMesPosterior;
            }

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                this.ganhoMesPosterior.getImpostoRetidoFonteLei11033MesesAnteriores().setConteudo(this.ganhoMesAnterior.getImpostoRetidoFonteLei11033MesesCompensar());
            }
        }
        ganhosMesAnt.getImpostoRetidoFonteLei11033MesesCompensar().addObservador(new ObservadorAtualizaIRLei11033ProxMes(ganhosMesAnt, ganhosMesPost));
    }

    public String obterMesFormatoNumerico(GanhosLiquidosOuPerdas ganhos) {
        if (((Object)((Object)ganhos)).equals((Object)this.janeiro)) {
            return "01";
        }
        if (((Object)((Object)ganhos)).equals((Object)this.fevereiro)) {
            return "02";
        }
        if (((Object)((Object)ganhos)).equals((Object)this.marco)) {
            return "03";
        }
        if (((Object)((Object)ganhos)).equals((Object)this.abril)) {
            return "04";
        }
        if (((Object)((Object)ganhos)).equals((Object)this.maio)) {
            return "05";
        }
        if (((Object)((Object)ganhos)).equals((Object)this.junho)) {
            return "06";
        }
        if (((Object)((Object)ganhos)).equals((Object)this.julho)) {
            return "07";
        }
        if (((Object)((Object)ganhos)).equals((Object)this.agosto)) {
            return "08";
        }
        if (((Object)((Object)ganhos)).equals((Object)this.setembro)) {
            return "09";
        }
        if (((Object)((Object)ganhos)).equals((Object)this.outubro)) {
            return "10";
        }
        if (((Object)((Object)ganhos)).equals((Object)this.novembro)) {
            return "11";
        }
        if (((Object)((Object)ganhos)).equals((Object)this.dezembro)) {
            return "12";
        }
        return null;
    }

    private void addObservadorAtualizaResultadoNegativoProxMes(GanhosLiquidosOuPerdas ganhosMesAnt, GanhosLiquidosOuPerdas ganhosMesPost) {
        class ObservadorAtualizaResultadoNegProxMes
        extends Observador {
            GanhosLiquidosOuPerdas ganhoMesAnterior = null;
            GanhosLiquidosOuPerdas ganhoMesPosterior = null;

            public ObservadorAtualizaResultadoNegProxMes(GanhosLiquidosOuPerdas _ganhoMesAnterior, GanhosLiquidosOuPerdas _ganhoMesPosterior) {
                this.ganhoMesAnterior = _ganhoMesAnterior;
                this.ganhoMesPosterior = _ganhoMesPosterior;
            }

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (((Informacao)observado).getOwner().equals((Object)this.ganhoMesAnterior.getOperacoesComuns())) {
                    this.ganhoMesPosterior.getOperacoesComuns().getResultadoNegativoMesAnterior().setConteudo(this.ganhoMesAnterior.getOperacoesComuns().getPrejuizoCompensar());
                } else {
                    this.ganhoMesPosterior.getOperacoesDayTrade().getResultadoNegativoMesAnterior().setConteudo(this.ganhoMesAnterior.getOperacoesDayTrade().getPrejuizoCompensar());
                }
            }
        }
        ganhosMesAnt.getOperacoesComuns().getPrejuizoCompensar().addObservador((Observador)new ObservadorAtualizaResultadoNegProxMes(ganhosMesAnt, ganhosMesPost));
        ganhosMesAnt.getOperacoesDayTrade().getPrejuizoCompensar().addObservador((Observador)new ObservadorAtualizaResultadoNegProxMes(ganhosMesAnt, ganhosMesPost));
    }

    public void adicionarObservadorCalculosTotaisRendaVariavel(Observador pObservador) {
        this.janeiro.adicionarObservadorCalculosRendaVariavel(pObservador);
        this.fevereiro.adicionarObservadorCalculosRendaVariavel(pObservador);
        this.marco.adicionarObservadorCalculosRendaVariavel(pObservador);
        this.abril.adicionarObservadorCalculosRendaVariavel(pObservador);
        this.maio.adicionarObservadorCalculosRendaVariavel(pObservador);
        this.junho.adicionarObservadorCalculosRendaVariavel(pObservador);
        this.julho.adicionarObservadorCalculosRendaVariavel(pObservador);
        this.agosto.adicionarObservadorCalculosRendaVariavel(pObservador);
        this.setembro.adicionarObservadorCalculosRendaVariavel(pObservador);
        this.outubro.adicionarObservadorCalculosRendaVariavel(pObservador);
        this.novembro.adicionarObservadorCalculosRendaVariavel(pObservador);
        this.dezembro.adicionarObservadorCalculosRendaVariavel(pObservador);
    }

    public void removerObservadorCalculosTotaisRendaVariavel(Observador pObservador) {
        this.janeiro.removerObservadorCalculosRendaVariavel(pObservador);
        this.fevereiro.removerObservadorCalculosRendaVariavel(pObservador);
        this.marco.removerObservadorCalculosRendaVariavel(pObservador);
        this.abril.removerObservadorCalculosRendaVariavel(pObservador);
        this.maio.removerObservadorCalculosRendaVariavel(pObservador);
        this.junho.removerObservadorCalculosRendaVariavel(pObservador);
        this.julho.removerObservadorCalculosRendaVariavel(pObservador);
        this.agosto.removerObservadorCalculosRendaVariavel(pObservador);
        this.setembro.removerObservadorCalculosRendaVariavel(pObservador);
        this.outubro.removerObservadorCalculosRendaVariavel(pObservador);
        this.novembro.removerObservadorCalculosRendaVariavel(pObservador);
        this.dezembro.removerObservadorCalculosRendaVariavel(pObservador);
    }

    public void adicionarObservGanhosRendaVar(Observador pObservador) {
        this.getTotalBaseCalculo().addObservador(pObservador);
        this.getTotalIRFonteDayTrade().addObservador(pObservador);
        this.getTotalImpostoAPagar().addObservador(pObservador);
        this.getTotalImpostoPago().addObservador(pObservador);
        this.getTotalImpostoRetidoFonteLei11033().addObservador(pObservador);
    }

    public Valor getTotalBaseCalculo() {
        return this.totalBaseCalculo;
    }

    public Valor getTotalIRFonteDayTrade() {
        return this.totalIRFonteDayTrade;
    }

    public GanhosLiquidosOuPerdas getAbril() {
        return this.abril;
    }

    public GanhosLiquidosOuPerdas getAgosto() {
        return this.agosto;
    }

    public GanhosLiquidosOuPerdas getDezembro() {
        return this.dezembro;
    }

    public GanhosLiquidosOuPerdas getFevereiro() {
        return this.fevereiro;
    }

    public GanhosLiquidosOuPerdas getJaneiro() {
        return this.janeiro;
    }

    public GanhosLiquidosOuPerdas getJulho() {
        return this.julho;
    }

    public GanhosLiquidosOuPerdas getJunho() {
        return this.junho;
    }

    public GanhosLiquidosOuPerdas getMaio() {
        return this.maio;
    }

    public GanhosLiquidosOuPerdas getMarco() {
        return this.marco;
    }

    public GanhosLiquidosOuPerdas getNovembro() {
        return this.novembro;
    }

    public GanhosLiquidosOuPerdas getOutubro() {
        return this.outubro;
    }

    public GanhosLiquidosOuPerdas getSetembro() {
        return this.setembro;
    }

    public GanhosLiquidosOuPerdas getGanhosPorIndice(int mes) {
        if (mes == 0) {
            return this.janeiro;
        }
        if (mes == 1) {
            return this.fevereiro;
        }
        if (mes == 2) {
            return this.marco;
        }
        if (mes == 3) {
            return this.abril;
        }
        if (mes == 4) {
            return this.maio;
        }
        if (mes == 5) {
            return this.junho;
        }
        if (mes == 6) {
            return this.julho;
        }
        if (mes == 7) {
            return this.agosto;
        }
        if (mes == 8) {
            return this.setembro;
        }
        if (mes == 9) {
            return this.outubro;
        }
        if (mes == 10) {
            return this.novembro;
        }
        if (mes == 11) {
            return this.dezembro;
        }
        return null;
    }

    public Valor getTotalImpostoRetidoFonteLei11033() {
        return this.totalImpostoRetidoFonteLei11033;
    }

    public Valor getTotalImpostoAPagar() {
        return this.totalImpostoAPagar;
    }

    public Valor getTotalImpostoPago() {
        return this.totalImpostoPago;
    }

    public boolean temResultadoLiquido() {
        for (int i = 0; i < 12; ++i) {
            if (this.getGanhosPorIndice(i).getOperacoesComuns().getResultadoLiquidoMes().isVazio() && this.getGanhosPorIndice(i).getOperacoesDayTrade().getResultadoLiquidoMes().isVazio()) continue;
            return true;
        }
        return false;
    }

    public boolean temIRRF() {
        for (int i = 0; i < 12; ++i) {
            if (this.getGanhosPorIndice(i).getIrFonteDayTradeMesAtual().isVazio() && this.getGanhosPorIndice(i).getImpostoRetidoFonteLei11033().isVazio()) continue;
            return true;
        }
        return false;
    }

    public Map<String, Valor> obterTotalAnual() {
        HashMap<String, Valor> retorno = new HashMap<String, Valor>();
        Valor valTotalResLiquidos = new Valor();
        Valor valTotalBaseCalcImposto = new Valor();
        Valor valTotalImpostoDevidoOp = new Valor();
        Valor valTotalImpostoDevidoConsolidacao = new Valor();
        Valor valTotalIRDayTradeMesesAnt = new Valor();
        Valor valTotalIRDayTradeCompensar = new Valor();
        Valor valTotalImpostoPagar = new Valor();
        ValorPositivo valTotalResNegativo = new ValorPositivo();
        ValorPositivo valTotalPrejuizoCompensar = new ValorPositivo();
        GanhosLiquidosOuPerdas mesAtual = null;
        for (int i = 0; i <= 11; ++i) {
            mesAtual = this.getGanhosPorIndice(i);
            valTotalResLiquidos.append('+', mesAtual.getOperacoesComuns().getResultadoLiquidoMes());
            valTotalResLiquidos.append('+', mesAtual.getOperacoesDayTrade().getResultadoLiquidoMes());
            valTotalBaseCalcImposto.append('+', mesAtual.getOperacoesComuns().getBaseCalculoImposto());
            valTotalBaseCalcImposto.append('+', mesAtual.getOperacoesDayTrade().getBaseCalculoImposto());
            valTotalImpostoDevidoOp.append('+', mesAtual.getOperacoesComuns().getImpostoDevido());
            valTotalImpostoDevidoOp.append('+', mesAtual.getOperacoesDayTrade().getImpostoDevido());
            valTotalImpostoDevidoConsolidacao.append('+', mesAtual.getTotalImpostoDevido());
            valTotalImpostoPagar.append('+', (Valor)mesAtual.getImpostoApagar());
            if (!((Object)((Object)mesAtual)).equals((Object)this.dezembro)) continue;
            valTotalResNegativo.setConteudo(mesAtual.getOperacoesComuns().getResultadoNegativoMesAnterior());
            valTotalResNegativo.append('+', mesAtual.getOperacoesDayTrade().getResultadoNegativoMesAnterior());
            valTotalPrejuizoCompensar.setConteudo(mesAtual.getOperacoesComuns().getPrejuizoCompensar());
            valTotalPrejuizoCompensar.append('+', mesAtual.getOperacoesDayTrade().getPrejuizoCompensar());
            valTotalIRDayTradeMesesAnt.setConteudo(mesAtual.getIrFonteDayTradeMesesAnteriores());
            valTotalIRDayTradeCompensar.setConteudo(mesAtual.getIrFonteDayTradeAcompensar());
        }
        retorno.put("TotalResultadosLiquidos", valTotalResLiquidos);
        retorno.put("TotalResultadosNegativos", valTotalResNegativo);
        retorno.put("BaseCalculoImposto", valTotalBaseCalcImposto);
        retorno.put("PrejuizoCompensar", valTotalPrejuizoCompensar);
        retorno.put("ImpostoDevido", valTotalImpostoDevidoOp);
        retorno.put("ImpostoDevidoConsolidacao", valTotalImpostoDevidoConsolidacao);
        retorno.put("IRDayTradeMesesAnteriores", valTotalIRDayTradeMesesAnt);
        retorno.put("IRDayTradeCompensar", valTotalIRDayTradeCompensar);
        retorno.put("TotalImpostoAPagar", valTotalImpostoPagar);
        return retorno;
    }

    public static void somarTotalAnual(Map<String, Valor> mapAtual, Map<String, Valor> mapAdicionado) {
        if (mapAtual != null && mapAdicionado != null) {
            for (String s : mapAtual.keySet()) {
                mapAtual.get(s).append('+', mapAdicionado.get(s));
            }
        }
    }

    public void clear() {
        this.janeiro.clear();
        this.fevereiro.clear();
        this.marco.clear();
        this.abril.clear();
        this.maio.clear();
        this.junho.clear();
        this.julho.clear();
        this.agosto.clear();
        this.setembro.clear();
        this.outubro.clear();
        this.novembro.clear();
        this.dezembro.clear();
    }

    public boolean isVazio() {
        boolean ret = this.totalBaseCalculo.isVazio();
        ret = ret && this.totalImpostoPago.isVazio();
        ret = ret && this.totalImpostoRetidoFonteLei11033.isVazio();
        ret = ret && this.totalIRFonteDayTrade.isVazio();
        for (int i = 0; i < 12 && ret; ++i) {
            ret = this.getGanhosPorIndice(i).isVazio();
        }
        return ret;
    }
}

