/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendavariavel;

import java.lang.ref.WeakReference;
import java.util.List;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.ValidadorNaoNuloIRPF;
import serpro.ppgd.irpf.gui.rendavariavel.PainelDadosRendaVariavelOpComunsDayTrade;
import serpro.ppgd.irpf.rendavariavel.GanhosLiquidosOuPerdas;
import serpro.ppgd.irpf.rendavariavel.RendaVariavel;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorCPF;

public class ItemRendaVariavelDependente
extends ObjetoNegocio
implements ObjetoFicha {
    private RendaVariavel rendaVariavel;
    private CPF cpf = new CPF((ObjetoNegocio)this, "CPF dependente");
    private WeakReference<DeclaracaoIRPF> declaracaoRef = null;

    public ItemRendaVariavelDependente(DeclaracaoIRPF dec) {
        this.declaracaoRef = new WeakReference<DeclaracaoIRPF>(dec);
        this.rendaVariavel = new RendaVariavel(dec, true);
        this.addValidador();
    }

    public void addValidador() {
        this.getCpf().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3));
        ValidadorCPF validadorCPF = new ValidadorCPF(3);
        validadorCPF.setMensagemValidacao(MensagemUtil.getMensagem("rendpjdep_cpf_invalido"));
        this.getCpf().addValidador((ValidadorIf)validadorCPF);
        this.getCpf().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                DeclaracaoIRPF declaracaoIRPF = (DeclaracaoIRPF)((Object)ItemRendaVariavelDependente.this.declaracaoRef.get());
                if (!declaracaoIRPF.getDependentes().isExisteCpf(ItemRendaVariavelDependente.this.getCpf().naoFormatado())) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("rendpjdep_cpf_nao_existe"), 3);
                }
                return null;
            }
        });
        this.getCpf().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                DeclaracaoIRPF declaracaoIRPF = (DeclaracaoIRPF)((Object)ItemRendaVariavelDependente.this.declaracaoRef.get());
                int qtdCpfs = 0;
                for (ItemRendaVariavelDependente item : declaracaoIRPF.getRendaVariavelDependente().itens()) {
                    if (!item.getCpf().naoFormatado().equals(ItemRendaVariavelDependente.this.getCpf().naoFormatado())) continue;
                    ++qtdCpfs;
                }
                if (qtdCpfs > 1) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("rendpf_dependente_duplicado"), 3);
                }
                return null;
            }
        });
    }

    protected List<Informacao> recuperarListaCamposPendencia() {
        List lista = super.recuperarListaCamposPendencia();
        lista.add(this.cpf);
        return lista;
    }

    public CPF getCpf() {
        return this.cpf;
    }

    public RendaVariavel getRendaVariavel() {
        return this.rendaVariavel;
    }

    public String getClasseFicha() {
        return PainelDadosRendaVariavelOpComunsDayTrade.class.getName();
    }

    public String getNomeAba() {
        return "Dependentes";
    }

    public String getTituloFichaDashboard() {
        return "Renda Vari\u00e1vel - Opera\u00e7\u00f5es Comuns/Day-Trade - Dependentes";
    }

    public ItemRendaVariavelDependente obterCopia() {
        ItemRendaVariavelDependente copia = new ItemRendaVariavelDependente((DeclaracaoIRPF)((Object)this.declaracaoRef.get()));
        copia.getCpf().setConteudo(this.getCpf());
        copia.getRendaVariavel().getTotalBaseCalculo().setConteudo(this.getRendaVariavel().getTotalBaseCalculo());
        copia.getRendaVariavel().getTotalIRFonteDayTrade().setConteudo(this.getRendaVariavel().getTotalIRFonteDayTrade());
        copia.getRendaVariavel().getTotalImpostoRetidoFonteLei11033().setConteudo(this.getRendaVariavel().getTotalImpostoRetidoFonteLei11033());
        copia.getRendaVariavel().getTotalImpostoAPagar().setConteudo(this.getRendaVariavel().getTotalImpostoAPagar());
        copia.getRendaVariavel().getTotalImpostoPago().setConteudo(this.getRendaVariavel().getTotalImpostoPago());
        for (int i = 0; i < 12; ++i) {
            GanhosLiquidosOuPerdas mesDestino = copia.getRendaVariavel().getGanhosPorIndice(i);
            GanhosLiquidosOuPerdas mesOrigem = this.getRendaVariavel().getGanhosPorIndice(i);
            mesDestino.getTotalImpostoDevido().setConteudo(mesOrigem.getTotalImpostoDevido());
            mesDestino.getIrFonteDayTradeMesAtual().setConteudo(mesOrigem.getIrFonteDayTradeMesAtual());
            mesDestino.getIrFonteDayTradeMesesAnteriores().setConteudo(mesOrigem.getIrFonteDayTradeMesesAnteriores());
            mesDestino.getIrFonteDayTradeAcompensar().setConteudo(mesOrigem.getIrFonteDayTradeAcompensar());
            mesDestino.getImpostoApagar().setConteudo(mesOrigem.getImpostoApagar());
            mesDestino.getImpostoPago().setConteudo(mesOrigem.getImpostoPago());
            mesDestino.getImpostoRetidoFonteLei11033().setConteudo(mesOrigem.getImpostoRetidoFonteLei11033());
            mesDestino.getImpostoRetidoFonteLei11033MesesAnteriores().setConteudo(mesOrigem.getImpostoRetidoFonteLei11033MesesAnteriores());
            mesDestino.getImpostoRetidoFonteLei11033MesesCompensar().setConteudo(mesOrigem.getImpostoRetidoFonteLei11033MesesCompensar());
            mesOrigem.getOperacoesComuns().obterCopia(mesDestino.getOperacoesComuns());
            mesOrigem.getOperacoesDayTrade().obterCopia(mesDestino.getOperacoesDayTrade());
        }
        return copia;
    }
}

