/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendavariavel;

import java.util.List;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.ValorPositivo;
import serpro.ppgd.irpf.gui.rendavariavel.PainelDadosRendaVariavelOpComunsDayTrade;
import serpro.ppgd.irpf.rendavariavel.ObservadorHabDesabIrRetidoFonteLei11033;
import serpro.ppgd.irpf.rendavariavel.Operacoes;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class GanhosLiquidosOuPerdas
extends ObjetoNegocio
implements ObjetoFicha {
    public static final String PROP_IMP_DEVIDO = "Total do Imposto Devido";
    public static final String PROP_IR_FONTE_DAYTRADE = "IRFONTEDAYTRADE";
    public static final String PROP_IR_FONTE_DAYTRADE_MESES_ANTERIORES = "IRFONTEDAYTRADEANTERIOR";
    public static final String PROP_IR_FONTE_DAYTRADE_MESES_COMPENSAR = "IRFONTEDAYTRADECOMPENSAR";
    public static final String PROP_IMP_PAGAR = "Imposto a Pagar";
    public static final String PROP_IMP_RETIDO_LEI_11033 = "IR LEI 11033";
    public static final String PROP_IMP_RETIDO_LEI_11033_MESES_ANTERIORES = "IR LEI 11033 Meses Anteriores";
    public static final String PROP_IMP_RETIDO_LEI_11033_MESES_COMPENSAR = "IR LEI 11033 Meses Compensar";
    public static final String PROP_IMP_PAGO = "IMP PAGO";
    private Operacoes operacoesComuns = new Operacoes("15");
    private Operacoes operacoesDayTrade = new Operacoes("20");
    private Valor totalImpostoDevido = new Valor((ObjetoNegocio)this, "Total do Imposto Devido");
    private ValorPositivo irFonteDayTradeMesAtual = new ValorPositivo(this, "IRFONTEDAYTRADE");
    private Valor irFonteDayTradeMesesAnteriores = new Valor((ObjetoNegocio)this, "IRFONTEDAYTRADEANTERIOR");
    private Valor irFonteDayTradeAcompensar = new Valor((ObjetoNegocio)this, "IRFONTEDAYTRADECOMPENSAR");
    private ValorPositivo impostoApagar = new ValorPositivo(this, "Imposto a Pagar");
    private ValorPositivo impostoPago = new ValorPositivo(this, "IMP PAGO");
    private ValorPositivo impostoRetidoFonteLei11033 = new ValorPositivo(this, "IR LEI 11033");
    private ValorPositivo impostoRetidoFonteLei11033MesesAnteriores = new ValorPositivo(this, "IR LEI 11033 Meses Anteriores");
    private ValorPositivo impostoRetidoFonteLei11033MesesCompensar = new ValorPositivo(this, "IR LEI 11033 Meses Compensar");
    private boolean ehDependente = false;
    public static final String ALIQUOTA_DAYTRADE = "20";
    public static final String ALIQUOTA_COMUM = "15";
    public static final String TITULO_FICHA_SEM_MES = "Renda Vari\u00e1vel - Opera\u00e7\u00f5es Comuns/Day-Trade";

    public GanhosLiquidosOuPerdas(DeclaracaoIRPF dec, String mes, boolean ehDependente) {
        this.setFicha("Renda Vari\u00e1vel - Opera\u00e7\u00f5es Comuns/Day-Trade - " + mes);
        this.getOperacoesComuns().setFicha("Renda Vari\u00e1vel - Opera\u00e7\u00f5es Comuns/Day-Trade - " + (ehDependente ? "Dependentes" : "Titular") + " - " + mes);
        this.getOperacoesDayTrade().setFicha("Renda Vari\u00e1vel - Opera\u00e7\u00f5es Comuns/Day-Trade - " + (ehDependente ? "Dependentes" : "Titular") + " - " + mes);
        this.getOperacoesComuns().getAliquotaDoImposto().setConteudo("15%");
        this.getOperacoesDayTrade().getAliquotaDoImposto().setConteudo("20%");
        this.getOperacoesComuns().getResultadoLiquidoMes().setReadOnly(true);
        this.getOperacoesDayTrade().getResultadoLiquidoMes().setReadOnly(true);
        this.getOperacoesComuns().getBaseCalculoImposto().setReadOnly(true);
        this.getOperacoesDayTrade().getBaseCalculoImposto().setReadOnly(true);
        this.getOperacoesComuns().getPrejuizoCompensar().setReadOnly(true);
        this.getOperacoesDayTrade().getPrejuizoCompensar().setReadOnly(true);
        this.getOperacoesComuns().getAliquotaDoImposto().setReadOnly(false);
        this.getOperacoesDayTrade().getAliquotaDoImposto().setReadOnly(false);
        this.getOperacoesComuns().getImpostoDevido().setReadOnly(true);
        this.getOperacoesDayTrade().getImpostoDevido().setReadOnly(true);
        if (!mes.equals("Janeiro")) {
            this.getOperacoesComuns().getResultadoNegativoMesAnterior().setReadOnly(true);
            this.getOperacoesDayTrade().getResultadoNegativoMesAnterior().setReadOnly(true);
        }
        this.getTotalImpostoDevido().setReadOnly(true);
        this.getIrFonteDayTradeMesesAnteriores().setReadOnly(true);
        this.getIrFonteDayTradeAcompensar().setReadOnly(true);
        this.getImpostoRetidoFonteLei11033MesesAnteriores().setReadOnly(true);
        this.getImpostoRetidoFonteLei11033MesesCompensar().setReadOnly(true);
        this.getImpostoApagar().setReadOnly(true);
        ObservadorHabDesabIrRetidoFonteLei11033 observadorHabDesabIrRetidoFonteLei11033 = new ObservadorHabDesabIrRetidoFonteLei11033(this);
        this.getTotalImpostoDevido().addObservador((Observador)observadorHabDesabIrRetidoFonteLei11033);
        this.getIrFonteDayTradeMesAtual().addObservador(observadorHabDesabIrRetidoFonteLei11033);
        this.getIrFonteDayTradeMesesAnteriores().addObservador((Observador)observadorHabDesabIrRetidoFonteLei11033);
        this.getImpostoRetidoFonteLei11033().addObservador(observadorHabDesabIrRetidoFonteLei11033);
        this.getImpostoRetidoFonteLei11033MesesAnteriores().addObservador(observadorHabDesabIrRetidoFonteLei11033);
        this.getOperacoesComuns().getImpostoDevido().addObservador((Observador)this);
        this.getOperacoesDayTrade().getImpostoDevido().addObservador((Observador)this);
        this.getIrFonteDayTradeMesAtual().addObservador((Observador)this);
        this.getIrFonteDayTradeMesesAnteriores().addObservador((Observador)this);
        this.getImpostoRetidoFonteLei11033().addObservador((Observador)this);
        this.getImpostoRetidoFonteLei11033MesesAnteriores().addObservador((Observador)this);
        this.ehDependente = ehDependente;
    }

    public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
        this.totalImpostoDevido.setConteudo(this.getOperacoesComuns().getImpostoDevido().operacao('+', this.getOperacoesDayTrade().getImpostoDevido()));
        Valor irDayTradeMesMaisIRDayTradeMesAnteriores = new Valor();
        irDayTradeMesMaisIRDayTradeMesAnteriores.append('+', (Valor)this.getIrFonteDayTradeMesAtual());
        irDayTradeMesMaisIRDayTradeMesAnteriores.append('+', this.getIrFonteDayTradeMesesAnteriores());
        Valor irfMesMaisIRFMesAnteriores = new Valor();
        irfMesMaisIRFMesAnteriores.append('+', (Valor)this.getImpostoRetidoFonteLei11033());
        irfMesMaisIRFMesAnteriores.append('+', (Valor)this.getImpostoRetidoFonteLei11033MesesAnteriores());
        Valor irfDayTradeEComunsMesMaisMesesAnteriores = new Valor();
        irfDayTradeEComunsMesMaisMesesAnteriores.append('+', irDayTradeMesMaisIRDayTradeMesAnteriores);
        irfDayTradeEComunsMesMaisMesesAnteriores.append('+', irfMesMaisIRFMesAnteriores);
        if (irfDayTradeEComunsMesMaisMesesAnteriores.comparacao(">", this.getTotalImpostoDevido())) {
            Valor irDayTradeComp = new Valor();
            Valor irfComunsComp = new Valor();
            Valor impostoDevidoAbatidoDayTrade = new Valor(this.totalImpostoDevido.formatado());
            impostoDevidoAbatidoDayTrade.append('-', irDayTradeMesMaisIRDayTradeMesAnteriores);
            if (irDayTradeMesMaisIRDayTradeMesAnteriores.comparacao("=", this.totalImpostoDevido)) {
                this.getIrFonteDayTradeAcompensar().clear();
                this.getImpostoRetidoFonteLei11033MesesCompensar().setConteudo(irfMesMaisIRFMesAnteriores);
            } else if (irDayTradeMesMaisIRDayTradeMesAnteriores.comparacao(">", this.totalImpostoDevido)) {
                irDayTradeComp.append('+', irDayTradeMesMaisIRDayTradeMesAnteriores);
                irDayTradeComp.append('-', this.getTotalImpostoDevido());
                this.getIrFonteDayTradeAcompensar().setConteudo(irDayTradeComp);
                this.getImpostoRetidoFonteLei11033MesesCompensar().setConteudo(irfMesMaisIRFMesAnteriores);
            } else if (impostoDevidoAbatidoDayTrade.comparacao("=", irfMesMaisIRFMesAnteriores)) {
                this.getIrFonteDayTradeAcompensar().clear();
                this.getImpostoRetidoFonteLei11033MesesCompensar().clear();
            } else {
                this.getIrFonteDayTradeAcompensar().clear();
                irfComunsComp.append('+', irfMesMaisIRFMesAnteriores);
                irfComunsComp.append('-', impostoDevidoAbatidoDayTrade);
                this.getImpostoRetidoFonteLei11033MesesCompensar().setConteudo(irfComunsComp);
            }
            this.getImpostoApagar().clear();
        } else {
            this.getIrFonteDayTradeAcompensar().clear();
            this.getImpostoRetidoFonteLei11033MesesCompensar().clear();
            Valor impAPag = new Valor();
            impAPag.append('+', this.getTotalImpostoDevido());
            impAPag.append('-', irfDayTradeEComunsMesMaisMesesAnteriores);
            this.getImpostoApagar().setConteudo(impAPag);
        }
    }

    public void adicionarObservadorCalculosRendaVariavel(Observador pObservador) {
        this.operacoesComuns.getBaseCalculoImposto().addObservador(pObservador);
        this.operacoesDayTrade.getBaseCalculoImposto().addObservador(pObservador);
        this.irFonteDayTradeMesAtual.addObservador(pObservador);
        this.impostoPago.addObservador(pObservador);
        this.impostoRetidoFonteLei11033.addObservador(pObservador);
        this.impostoRetidoFonteLei11033MesesAnteriores.addObservador(pObservador);
        this.impostoRetidoFonteLei11033MesesCompensar.addObservador(pObservador);
        this.impostoApagar.addObservador(pObservador);
    }

    public void removerObservadorCalculosRendaVariavel(Observador pObservador) {
        this.operacoesComuns.getBaseCalculoImposto().removeObservador(pObservador);
        this.operacoesDayTrade.getBaseCalculoImposto().removeObservador(pObservador);
        this.irFonteDayTradeMesAtual.removeObservador(pObservador);
        this.impostoPago.removeObservador(pObservador);
        this.impostoRetidoFonteLei11033.removeObservador(pObservador);
        this.impostoRetidoFonteLei11033MesesAnteriores.removeObservador(pObservador);
        this.impostoRetidoFonteLei11033MesesCompensar.removeObservador(pObservador);
        this.impostoApagar.removeObservador(pObservador);
    }

    public Operacoes getOperacoesComuns() {
        return this.operacoesComuns;
    }

    public Operacoes getOperacoesDayTrade() {
        return this.operacoesDayTrade;
    }

    public ValorPositivo getImpostoApagar() {
        return this.impostoApagar;
    }

    public ValorPositivo getImpostoPago() {
        return this.impostoPago;
    }

    public Valor getIrFonteDayTradeAcompensar() {
        return this.irFonteDayTradeAcompensar;
    }

    public ValorPositivo getIrFonteDayTradeMesAtual() {
        return this.irFonteDayTradeMesAtual;
    }

    public Valor getIrFonteDayTradeMesesAnteriores() {
        return this.irFonteDayTradeMesesAnteriores;
    }

    public Valor getTotalImpostoDevido() {
        return this.totalImpostoDevido;
    }

    protected List<Informacao> recuperarListaCamposPendencia() {
        List listaCamposPendencia = super.recuperarCamposInformacao();
        listaCamposPendencia.add(this.getImpostoRetidoFonteLei11033());
        return listaCamposPendencia;
    }

    public boolean isVazio() {
        boolean retorno = this.operacoesComuns.isVazio();
        retorno = retorno && this.operacoesDayTrade.isVazio();
        retorno = retorno && this.irFonteDayTradeMesAtual.isVazio();
        retorno = retorno && this.impostoPago.isVazio();
        retorno = retorno && this.impostoRetidoFonteLei11033.isVazio();
        retorno = retorno && this.operacoesComuns.getResultadoLiquidoMes().isVazio();
        retorno = retorno && this.operacoesComuns.getResultadoNegativoMesAnterior().isVazio();
        retorno = retorno && this.operacoesDayTrade.getResultadoLiquidoMes().isVazio();
        retorno = retorno && this.operacoesDayTrade.getResultadoNegativoMesAnterior().isVazio();
        return retorno;
    }

    public ValorPositivo getImpostoRetidoFonteLei11033() {
        return this.impostoRetidoFonteLei11033;
    }

    public void clear() {
        this.operacoesComuns.clear();
        this.operacoesDayTrade.clear();
        this.irFonteDayTradeMesAtual.clear();
        this.impostoRetidoFonteLei11033.clear();
        this.impostoPago.clear();
    }

    public String getClasseFicha() {
        return PainelDadosRendaVariavelOpComunsDayTrade.class.getName();
    }

    public String getNomeAba() {
        return this.ehDependente ? "Dependentes" : "Titular";
    }

    public ValorPositivo getImpostoRetidoFonteLei11033MesesAnteriores() {
        return this.impostoRetidoFonteLei11033MesesAnteriores;
    }

    public ValorPositivo getImpostoRetidoFonteLei11033MesesCompensar() {
        return this.impostoRetidoFonteLei11033MesesCompensar;
    }

    public String getTituloFichaDashboard() {
        return TITULO_FICHA_SEM_MES;
    }
}

