/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendacm;

import java.lang.ref.WeakReference;
import java.util.List;
import serpro.ppgd.cacheni.CacheNI;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.ObservadorEspacosDuplicados;
import serpro.ppgd.irpf.ValidadorNaoNuloIRPF;
import serpro.ppgd.irpf.ValorPositivo;
import serpro.ppgd.irpf.alimentandos.Alimentandos;
import serpro.ppgd.irpf.calculos.CalculosRendAcmImpostoDevido;
import serpro.ppgd.irpf.espolio.Espolio;
import serpro.ppgd.irpf.gui.rendacm.PainelDadosRendAcm;
import serpro.ppgd.irpf.rendIsentos.ColecaoItemQuadroPensaoAlimenticia;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroPensaoAlimenticia;
import serpro.ppgd.irpf.rendacm.ObservadorRendimentosTributaveisCalculado;
import serpro.ppgd.irpf.rendacm.RendAcmDependente;
import serpro.ppgd.irpf.saida.Saida;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Pendencia;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.util.Validador;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNI;

public class RendAcmTitular
extends ObjetoNegocio
implements ObjetoFicha {
    public static final String NOME_OPCAO_TRIBUTACAO = "Op\u00e7\u00e3o pela Forma de Tributa\u00e7\u00e3o";
    public static final String NOME_NOME_FONTE_PAGADORA = "Nome da Fonte Pagadora";
    public static final String NOME_NI_FONTE_PAGADORA = "CPF/CNPJ da Fonte Pagadora";
    public static final String NOME_REND_RECEB = "Rendimentos Tribut\u00e1veis";
    public static final String NOME_PARC_ISENTA_65_ANOS = "Parcela isenta 65 anos";
    public static final String NOME_REND_RECEB_TRIBUT = "Rendimentos recebidos tribut\u00e1veis";
    public static final String NOME_CONTRIB_PREV = "Contribui\u00e7\u00e3o Previdenci\u00e1ria Oficial";
    public static final String NOME_IMPOSTO_RETIDO = "Imposto Retido na Fonte";
    public static final String NOME_PENSAO_ALIMENTICIA = "Pens\u00e3o Aliment\u00edcia";
    public static final String NOME_MES_RECEBIMENTO = "M\u00eas do Recebimento";
    public static final String NOME_NUM_MESES = "N\u00famero de Meses";
    public static final String NOME_IMPOSTO_DEVIDO_RRA = "Imposto Devido RRA";
    public static final String NOME_VALOR_JUROS_ = "Valor recebido referente a juros";
    protected Alfa opcaoTributacao = new Alfa((ObjetoNegocio)this, "Op\u00e7\u00e3o pela Forma de Tributa\u00e7\u00e3o", 1);
    protected Alfa nomeFontePagadora = new Alfa((ObjetoNegocio)this, "Nome da Fonte Pagadora", 60);
    protected NI niFontePagadora = new NI((ObjetoNegocio)this, "CPF/CNPJ da Fonte Pagadora");
    protected ValorPositivo rendRecebidosInformado = new ValorPositivo(this, "Rendimentos Tribut\u00e1veis");
    protected ValorPositivo parcIsenta65Anos = new ValorPositivo(this, "Parcela isenta 65 anos");
    protected ValorPositivo rendRecebidos = new ValorPositivo(this, "Rendimentos recebidos tribut\u00e1veis");
    protected ValorPositivo contribuicaoPrevOficial = new ValorPositivo(this, "Contribui\u00e7\u00e3o Previdenci\u00e1ria Oficial");
    protected ValorPositivo impostoRetidoFonte = new ValorPositivo(this, "Imposto Retido na Fonte");
    protected ValorPositivo pensaoAlimenticia = new ValorPositivo(this, "Pens\u00e3o Aliment\u00edcia");
    protected ColecaoItemQuadroPensaoAlimenticia pensaoAlimenticiaQuadroAuxiliar = new ColecaoItemQuadroPensaoAlimenticia(this);
    protected Codigo mesRecebimento = new Codigo((ObjetoNegocio)this, "M\u00eas do Recebimento", CadastroTabelasIRPF.recuperarMeses());
    protected ValorPositivo numMeses = new ValorPositivo(this, "N\u00famero de Meses", 3, 1);
    protected ValorPositivo impostoDevidoRRA = new ValorPositivo(this, "Imposto Devido RRA");
    protected ValorPositivo valorJuros = new ValorPositivo(this, "Valor recebido referente a juros");
    private String numeroProcesso = new String();
    protected String chave = null;
    protected WeakReference<DeclaracaoIRPF> weakDec = null;
    protected WeakReference<? extends Colecao<RendAcmTitular>> weakColecao = null;

    public RendAcmTitular(DeclaracaoIRPF dec, Colecao<RendAcmTitular> colecao) {
        this.weakDec = new WeakReference<DeclaracaoIRPF>(dec);
        this.weakColecao = new WeakReference<Colecao<RendAcmTitular>>(colecao);
        CacheNI.getInstancia().registrarNINome(this.niFontePagadora, this.nomeFontePagadora);
        if (this.opcaoTributacao.isVazio()) {
            this.opcaoTributacao.setConteudo("V");
        }
        this.getRendRecebidos().setReadOnly(true);
        this.getPensaoAlimenticia().setReadOnly(true);
        this.getImpostoDevidoRRA().setReadOnly(true);
        this.adicionaValidadoresTitular();
        this.adicionaValidadores();
        this.adicionaObservadores();
    }

    private void adicionaValidadoresTitular() {
        if (!(this instanceof RendAcmDependente)) {
            this.getParcIsenta65Anos().addValidador((ValidadorIf)new ValidadorDefault(3){

                public RetornoValidacao validarImplementado() {
                    this.setMensagemValidacao(MensagemUtil.getMensagem("rendisentos_quadro_auxiliar_parc_isenta_aposentadoria_idade_beneficiario"));
                    Data dataNascimento = ((DeclaracaoIRPF)((Object)RendAcmTitular.this.weakDec.get())).getContribuinte().getDataNascimento();
                    if (dataNascimento != null) {
                        String DATA_NASCIMENTO_65_ANOS = "31/12/" + (Integer.parseInt(ConstantesGlobais.EXERCICIO_ANTERIOR) - 65);
                        Data data65Anos = new Data();
                        data65Anos.setConteudo(DATA_NASCIMENTO_65_ANOS);
                        if (dataNascimento.maisNova(data65Anos)) {
                            return new RetornoValidacao(this.getMensagemValidacao(), this.getSeveridade());
                        }
                    }
                    return null;
                }
            });
        }
    }

    private void adicionaObservadores() {
        CalculosRendAcmImpostoDevido calc = new CalculosRendAcmImpostoDevido(this);
        this.getOpcaoTributacao().addObservador((Observador)calc);
        this.getRendRecebidos().addObservador((Observador)calc);
        this.getContribuicaoPrevOficial().addObservador((Observador)calc);
        this.getPensaoAlimenticia().addObservador((Observador)calc);
        this.getNumMeses().addObservador((Observador)calc);
        this.getMesRecebimento().addObservador((Observador)calc);
        this.getNiFontePagadora().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (RendAcmTitular.this.getNiFontePagadora().naoFormatado().length() < 12) {
                    RendAcmTitular.this.parcIsenta65Anos.clear();
                    RendAcmTitular.this.parcIsenta65Anos.setReadOnly(true);
                } else {
                    RendAcmTitular.this.parcIsenta65Anos.setReadOnly(false);
                }
            }
        });
        this.getOpcaoTributacao().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (valorNovo.equals("A")) {
                    RendAcmTitular.this.numMeses.clear();
                    RendAcmTitular.this.impostoDevidoRRA.clear();
                } else if (valorNovo.equals("E") && valorAntigo.equals("A") && !"0,0".equals(RendAcmTitular.this.getNumMeses().getConteudoAntigo())) {
                    RendAcmTitular.this.getNumMeses().setConteudo(RendAcmTitular.this.getNumMeses().getConteudoAntigo());
                }
            }
        });
        ObservadorRendimentosTributaveisCalculado obsRendTributavelCalculado = new ObservadorRendimentosTributaveisCalculado(this, (DeclaracaoIRPF)((Object)this.weakDec.get()), (Colecao<RendAcmTitular>)((Colecao)this.weakColecao.get()));
        this.getRendRecebidosInformado().addObservador(obsRendTributavelCalculado);
        this.getParcIsenta65Anos().addObservador(obsRendTributavelCalculado);
        this.getOpcaoTributacao().addObservador((Observador)obsRendTributavelCalculado);
        Observador obsTotalParcelaAposentadoria65Anos = new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                ((DeclaracaoIRPF)((Object)RendAcmTitular.this.weakDec.get())).getColecaoRendAcmTitular().atualizarParcelaIsenta65Anos();
            }
        };
        this.getParcIsenta65Anos().addObservador(obsTotalParcelaAposentadoria65Anos);
        this.getOpcaoTributacao().addObservador(obsTotalParcelaAposentadoria65Anos);
        this.getNomeFontePagadora().addObservador((Observador)new ObservadorEspacosDuplicados());
        this.getPensaoAlimenticiaQuadroAuxiliar().getTotais().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                RendAcmTitular.this.getPensaoAlimenticia().setConteudo((String)valorNovo);
            }
        });
    }

    protected void adicionaValidadores() {
        this.getOpcaoTributacao().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3, MensagemUtil.getMensagem("rendacm_opcao_tributacao_nao_informada")){

            @Override
            public RetornoValidacao validarImplementado() {
                if (RendAcmTitular.this.getOpcaoTributacao().isVazio() || this.getInformacao().naoFormatado().equals("V")) {
                    return new RetornoValidacao(this.getMensagemValidacao(), this.getSeveridade());
                }
                return null;
            }
        });
        this.getOpcaoTributacao().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                this.setMensagemValidacao(MensagemUtil.getMensagem("rendacm_opcao_tributacao_diferente_fontes_diferentes"));
                String ni = RendAcmTitular.this.getNiFontePagadora().naoFormatado();
                String opcaoTributacao = this.getInformacao().naoFormatado();
                if (!(ni == null || ni.trim().isEmpty() || opcaoTributacao == null || opcaoTributacao.trim().isEmpty() || opcaoTributacao.equals("V"))) {
                    for (ObjetoNegocio objetoNegocio : ((Colecao)RendAcmTitular.this.weakColecao.get()).itens()) {
                        String outroNi = ((RendAcmTitular)objetoNegocio).getNiFontePagadora().naoFormatado();
                        String outraOpcaoTributacao = ((RendAcmTitular)objetoNegocio).getOpcaoTributacao().naoFormatado();
                        if (outroNi == null || outroNi.trim().isEmpty() || outraOpcaoTributacao == null || outraOpcaoTributacao.trim().isEmpty() || outraOpcaoTributacao.equals("V")) continue;
                        boolean mesmoCpf = true;
                        if (RendAcmTitular.this instanceof RendAcmDependente) {
                            RendAcmDependente esteDep = (RendAcmDependente)RendAcmTitular.this;
                            RendAcmDependente outroDep = (RendAcmDependente)objetoNegocio;
                            mesmoCpf = esteDep.getCpfDependente().naoFormatado().equals(outroDep.getCpfDependente().naoFormatado());
                        }
                        if (!mesmoCpf || opcaoTributacao.equals(outraOpcaoTributacao)) continue;
                        return new RetornoValidacao(this.getMensagemValidacao(), this.getSeveridade());
                    }
                }
                return null;
            }
        });
        this.getNomeFontePagadora().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

            @Override
            public RetornoValidacao validarImplementado() {
                if (RendAcmTitular.this.getNomeFontePagadora().isVazio()) {
                    RetornoValidacao niValido = Validador.validarNI((String)RendAcmTitular.this.getNiFontePagadora().naoFormatado());
                    if (niValido != null) {
                        this.setSeveridade((byte)3);
                        return new RetornoValidacao(MensagemUtil.getMensagem("rendacm_nome_ausente_ni_invalido"), 3);
                    }
                    this.setSeveridade((byte)2);
                    return new RetornoValidacao(MensagemUtil.getMensagem("rendacm_nome_ausente"), 2);
                }
                return null;
            }
        });
        this.getNiFontePagadora().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

            @Override
            public RetornoValidacao validarImplementado() {
                if (this.getInformacao().isVazio()) {
                    this.setSeveridade((byte)3);
                    return new RetornoValidacao(MensagemUtil.getMensagem("rendacm_cpf_cnpj_fonte_pagadora_branco"), this.getSeveridade());
                }
                return null;
            }
        });
        this.getNiFontePagadora().addValidador((ValidadorIf)new ValidadorNI(3, MensagemUtil.getMensagem("campo_invalido", new String[]{this.getNiFontePagadora().getNomeCampo()})));
        if (!(this instanceof RendAcmDependente)) {
            this.getNiFontePagadora().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

                @Override
                public RetornoValidacao validarImplementado() {
                    if (RendAcmTitular.this.getNiFontePagadora().naoFormatado().equals(((DeclaracaoIRPF)((Object)RendAcmTitular.this.weakDec.get())).getIdentificadorDeclaracao().getCpf().naoFormatado())) {
                        return new RetornoValidacao(MensagemUtil.getMensagem("ni_fonte_pagadora_igual_declarante"), this.getSeveridade());
                    }
                    return null;
                }
            });
        }
        this.getMesRecebimento().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3));
        this.getMesRecebimento().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                RetornoValidacao retornoValidacao = null;
                if (!RendAcmTitular.this.getMesRecebimento().isVazio()) {
                    try {
                        int numMes = RendAcmTitular.this.getMesRecebimento().asInteger();
                        if (numMes < 1 || numMes > 12) {
                            throw new Exception();
                        }
                    }
                    catch (Exception ex) {
                        retornoValidacao = new RetornoValidacao(MensagemUtil.getMensagem("rendacm_mes_recebimento_ausente"), this.getSeveridade());
                    }
                }
                if (retornoValidacao == null) {
                    if (((DeclaracaoIRPF)((Object)RendAcmTitular.this.weakDec.get())).getIdentificadorDeclaracao().isEspolio()) {
                        Espolio espolio = ((DeclaracaoIRPF)((Object)RendAcmTitular.this.weakDec.get())).getEspolio();
                        Alfa tipoJudicial = espolio.obterInformacoEspolioParaCalculos().getTipoJudicial();
                        String mesLimite = espolio.obterDataLimiteParaCalculos().getMes();
                        String complementoMensagem = null;
                        if (tipoJudicial.naoFormatado().equals(Logico.SIM)) {
                            complementoMensagem = "data da decis\u00e3o judicial da partilha ou sobrepartilha";
                        } else if (tipoJudicial.naoFormatado().equals(Logico.NAO)) {
                            complementoMensagem = "data da lavratura";
                        }
                        if (mesLimite != null && !mesLimite.trim().isEmpty() && !this.getInformacao().isVazio() && ((Codigo)this.getInformacao()).asInteger() > Integer.valueOf(mesLimite)) {
                            retornoValidacao = new RetornoValidacao(MensagemUtil.getMensagem("rendacm_mes_recebimento_posterior_espolio", new String[]{complementoMensagem}), this.getSeveridade());
                        }
                    } else if (((DeclaracaoIRPF)((Object)RendAcmTitular.this.weakDec.get())).getIdentificadorDeclaracao().isSaida()) {
                        String mesCondicaoNaoResidente;
                        Saida saida = ((DeclaracaoIRPF)((Object)RendAcmTitular.this.weakDec.get())).getSaida();
                        String mesCondicaoResidente = saida.getDtCondicaoResidente().isVazio() ? "1" : saida.getDtCondicaoResidente().getMes();
                        String string = mesCondicaoNaoResidente = saida.getDtCondicaoNaoResidente().isVazio() ? "12" : saida.getDtCondicaoNaoResidente().getMes();
                        if (!(this.getInformacao().isVazio() || ((Codigo)this.getInformacao()).asInteger() <= Integer.valueOf(mesCondicaoNaoResidente) && ((Codigo)this.getInformacao()).asInteger() >= Integer.valueOf(mesCondicaoResidente))) {
                            retornoValidacao = new RetornoValidacao(MensagemUtil.getMensagem("rendacm_mes_recebimento_saida"), this.getSeveridade());
                        }
                    }
                }
                return retornoValidacao;
            }
        });
        this.getNumMeses().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3, MensagemUtil.getMensagem("rendacm_num_meses_branco")){

            @Override
            public RetornoValidacao validarImplementado() {
                if (RendAcmTitular.this.getOpcaoTributacao().naoFormatado().equals("E")) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.getPensaoAlimenticia().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if (!RendAcmTitular.this.getPensaoAlimenticia().isVazio() && RendAcmTitular.this.getPensaoAlimenticiaQuadroAuxiliar().itens().isEmpty()) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("rendacm_pensao_alimenticia_sem_quadro"), this.getSeveridade());
                }
                return null;
            }
        });
        this.getPensaoAlimenticia().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                for (ItemQuadroPensaoAlimenticia item : RendAcmTitular.this.getPensaoAlimenticiaQuadroAuxiliar().itens()) {
                    if (!item.getAlimentando().isVazio() && !item.getAlimentando().naoFormatado().equals("-1")) continue;
                    return new RetornoValidacao(MensagemUtil.getMensagem("rendacm_alimentando_nao_informado"), this.getSeveridade());
                }
                return null;
            }
        });
        this.getPensaoAlimenticia().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                Alimentandos alimentandos = ((DeclaracaoIRPF)((Object)RendAcmTitular.this.weakDec.get())).getAlimentandos();
                for (ItemQuadroPensaoAlimenticia item : RendAcmTitular.this.getPensaoAlimenticiaQuadroAuxiliar().itens()) {
                    if (item.getAlimentando().isVazio() || item.getAlimentando().naoFormatado().equals("-1") || alimentandos.isExisteNome(item.getAlimentando().naoFormatado())) continue;
                    return new RetornoValidacao(MensagemUtil.getMensagem("rendacm_alimentando_nao_existe"), this.getSeveridade());
                }
                return null;
            }
        });
        this.getPensaoAlimenticia().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                for (ItemQuadroPensaoAlimenticia item : RendAcmTitular.this.getPensaoAlimenticiaQuadroAuxiliar().itens()) {
                    if (!item.getValor().isVazio()) continue;
                    return new RetornoValidacao(MensagemUtil.getMensagem("rendacm_valor_nao_informado"), this.getSeveridade());
                }
                return null;
            }
        });
        this.getParcIsenta65Anos().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                ValorPositivo limiteMensal = new ValorPositivo();
                limiteMensal.setConteudo("1.903,98");
                if (RendAcmTitular.this.getOpcaoTributacao().naoFormatado().equals("A") && RendAcmTitular.this.getParcIsenta65Anos().comparacao(">", limiteMensal)) {
                    if (RendAcmTitular.this instanceof RendAcmDependente) {
                        RendAcmDependente dependente = (RendAcmDependente)RendAcmTitular.this;
                        return new RetornoValidacao(MensagemUtil.getMensagem("rend_acm_msg_parcela_isenta_65_acima_limite", new String[]{dependente.getCpfDependente().formatado()}), this.getSeveridade());
                    }
                    return new RetornoValidacao(MensagemUtil.getMensagem("rend_acm_msg_parcela_isenta_65_acima_limite", new String[]{((DeclaracaoIRPF)((Object)RendAcmTitular.this.weakDec.get())).getIdentificadorDeclaracao().getCpf().formatado()}), this.getSeveridade());
                }
                return null;
            }
        });
    }

    public void addObservador(Observador obs) {
        this.opcaoTributacao.addObservador(obs);
        this.rendRecebidos.addObservador(obs);
        this.contribuicaoPrevOficial.addObservador(obs);
        this.impostoRetidoFonte.addObservador(obs);
        this.pensaoAlimenticia.addObservador(obs);
        this.impostoDevidoRRA.addObservador(obs);
        this.valorJuros.addObservador(obs);
    }

    public void removeObservador(Observador obs) {
        this.opcaoTributacao.addObservador(obs);
        this.rendRecebidos.removeObservador(obs);
        this.contribuicaoPrevOficial.removeObservador(obs);
        this.impostoRetidoFonte.removeObservador(obs);
        this.pensaoAlimenticia.removeObservador(obs);
        this.impostoDevidoRRA.removeObservador(obs);
        this.valorJuros.removeObservador(obs);
    }

    public Pendencia verificaValores(int numItem) {
        Pendencia retorno = null;
        if (this.getImpostoRetidoFonte().isVazio() && this.getContribuicaoPrevOficial().isVazio() && this.getPensaoAlimenticia().isVazio() && this.getRendRecebidosInformado().isVazio() && this.getParcIsenta65Anos().isVazio()) {
            retorno = new Pendencia(3, (Informacao)this.getRendRecebidosInformado(), "Valores Rend. Receb. Acum.", MensagemUtil.getMensagem("rendacm_faltam_valores"), numItem);
            retorno.setNomeAba(this.getNomeAba());
        }
        return retorno;
    }

    public List<Pendencia> verificarPendencias(int numeroItem) {
        List retorno = super.verificarPendencias(numeroItem);
        Pendencia pendValores = this.verificaValores(numeroItem);
        if (pendValores != null) {
            pendValores.setClassePainel(this.getClasseFicha());
            retorno.add(pendValores);
        }
        return retorno;
    }

    protected List<Informacao> recuperarListaCamposPendencia() {
        List retorno = this.recuperarCamposInformacao();
        return retorno;
    }

    public boolean isVazio() {
        boolean retorno;
        boolean bl = retorno = this.getNomeFontePagadora().isVazio() && this.getNiFontePagadora().isVazio() && this.getRendRecebidos().isVazio() && this.getContribuicaoPrevOficial().isVazio() && this.getPensaoAlimenticia().isVazio() && this.getImpostoRetidoFonte().isVazio() && this.getMesRecebimento().isVazio();
        if (this.opcaoTributacao.naoFormatado().equals("E")) {
            retorno = retorno && this.getNumMeses().isVazio() && this.getImpostoDevidoRRA().isVazio();
        }
        return retorno;
    }

    public Alfa getOpcaoTributacao() {
        return this.opcaoTributacao;
    }

    public Alfa getNomeFontePagadora() {
        return this.nomeFontePagadora;
    }

    public NI getNiFontePagadora() {
        return this.niFontePagadora;
    }

    public ValorPositivo getRendRecebidos() {
        return this.rendRecebidos;
    }

    public ValorPositivo getContribuicaoPrevOficial() {
        return this.contribuicaoPrevOficial;
    }

    public ValorPositivo getImpostoRetidoFonte() {
        return this.impostoRetidoFonte;
    }

    public ValorPositivo getPensaoAlimenticia() {
        return this.pensaoAlimenticia;
    }

    public ColecaoItemQuadroPensaoAlimenticia getPensaoAlimenticiaQuadroAuxiliar() {
        return this.pensaoAlimenticiaQuadroAuxiliar;
    }

    public Codigo getMesRecebimento() {
        return this.mesRecebimento;
    }

    public ValorPositivo getNumMeses() {
        return this.numMeses;
    }

    public ValorPositivo getImpostoDevidoRRA() {
        return this.impostoDevidoRRA;
    }

    public String getClasseFicha() {
        return PainelDadosRendAcm.class.getName();
    }

    public String getNomeAba() {
        return "Titular";
    }

    public String getChave() {
        return this.chave;
    }

    public void setChave(String chave) {
        this.chave = chave;
    }

    public String getTituloFichaDashboard() {
        return "Rendimentos Recebidos Acumuladamente pelo Titular";
    }

    public ValorPositivo getParcIsenta65Anos() {
        return this.parcIsenta65Anos;
    }

    public ValorPositivo getRendRecebidosInformado() {
        return this.rendRecebidosInformado;
    }

    public ValorPositivo getValorJuros() {
        return this.valorJuros;
    }

    public String getNumeroProcesso() {
        return this.numeroProcesso;
    }

    public void setNumeroProcesso(String numeroProcesso) {
        this.numeroProcesso = numeroProcesso;
    }

    public RendAcmTitular obterCopia() {
        RendAcmTitular copia = new RendAcmTitular(IRPFFacade.getInstancia().getDeclaracao(), IRPFFacade.getInstancia().getDeclaracao().getColecaoRendAcmTitular());
        copia.getOpcaoTributacao().setConteudo(this.getOpcaoTributacao());
        copia.getNomeFontePagadora().setConteudo(this.getNomeFontePagadora());
        copia.getNiFontePagadora().setConteudo(this.getNiFontePagadora());
        copia.getRendRecebidosInformado().setConteudo(this.getRendRecebidosInformado());
        copia.getParcIsenta65Anos().setConteudo(this.getParcIsenta65Anos());
        copia.getRendRecebidos().setConteudo(this.getRendRecebidos());
        copia.getContribuicaoPrevOficial().setConteudo(this.getContribuicaoPrevOficial());
        copia.getImpostoRetidoFonte().setConteudo(this.getImpostoRetidoFonte());
        copia.getPensaoAlimenticia().setConteudo(this.getPensaoAlimenticia());
        copia.getMesRecebimento().setConteudo(this.getMesRecebimento());
        copia.getNumMeses().setConteudo(this.getNumMeses());
        copia.getImpostoDevidoRRA().setConteudo(this.getImpostoDevidoRRA());
        copia.getValorJuros().setConteudo(this.getValorJuros());
        for (ItemQuadroPensaoAlimenticia item : this.getPensaoAlimenticiaQuadroAuxiliar().itens()) {
            ItemQuadroPensaoAlimenticia itemQuadro = new ItemQuadroPensaoAlimenticia();
            itemQuadro.getAlimentando().setConteudo(item.getAlimentando());
            itemQuadro.getValor().setConteudo(item.getValor());
            copia.getPensaoAlimenticiaQuadroAuxiliar().add(item);
        }
        return copia;
    }
}

