/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendacm;

import java.util.List;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.ObservadorEspacosDuplicados;
import serpro.ppgd.irpf.ValidadorNaoNuloIRPF;
import serpro.ppgd.irpf.dependentes.Dependente;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroPensaoAlimenticia;
import serpro.ppgd.irpf.rendacm.ObservadorRendimentosTributaveisCalculado;
import serpro.ppgd.irpf.rendacm.RendAcmTitular;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Pendencia;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorCPF;

public class RendAcmDependente
extends RendAcmTitular
implements ObjetoFicha {
    public static final String NOME_DEPENDENTE = "Dependente";
    protected CPF cpfDependente = new CPF((ObjetoNegocio)this, "Dependente");

    public RendAcmDependente(DeclaracaoIRPF dec, Colecao colecao) {
        super(dec, (Colecao<RendAcmTitular>)colecao);
        this.adicionarObservadores();
        this.addValidadoresDependente();
    }

    private void adicionarObservadores() {
        this.getCpfDependente().addObservador((Observador)new ObservadorRendimentosTributaveisCalculado(this, (DeclaracaoIRPF)((Object)this.weakDec.get()), (Colecao<RendAcmTitular>)((Colecao)this.weakColecao.get())));
    }

    private void addValidadoresDependente() {
        super.adicionaValidadores();
        this.getCpfDependente().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3, MensagemUtil.getMensagem("msg_validador_nao_nulo", new String[]{this.cpfDependente.getNomeCampo()})));
        this.getCpfDependente().addValidador((ValidadorIf)new ValidadorCPF(3));
        this.getCpfDependente().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                DeclaracaoIRPF declaracaoIRPF = (DeclaracaoIRPF)((Object)RendAcmDependente.this.weakDec.get());
                if (!declaracaoIRPF.getDependentes().isExisteCpf(RendAcmDependente.this.getCpfDependente().naoFormatado())) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("rendacm_dep_cpf_nao_existe"), this.getSeveridade());
                }
                return null;
            }
        });
        this.getParcIsenta65Anos().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                this.setMensagemValidacao(MensagemUtil.getMensagem("rendisentos_quadro_auxiliar_parc_isenta_aposentadoria_idade_beneficiario"));
                Data dataNascimento = null;
                Dependente d = ((DeclaracaoIRPF)((Object)RendAcmDependente.this.weakDec.get())).getDependentes().getDependenteByCpf(RendAcmDependente.this.getCpfDependente().naoFormatado());
                if (d != null) {
                    dataNascimento = d.getDataNascimento();
                }
                if (dataNascimento != null) {
                    String DATA_NASCIMENTO_65_ANOS = "31/12/" + (Integer.parseInt(ConstantesGlobais.EXERCICIO_ANTERIOR) - 65);
                    Data data65Anos = new Data();
                    data65Anos.setConteudo(DATA_NASCIMENTO_65_ANOS);
                    if (dataNascimento.maisNova(data65Anos)) {
                        return new RetornoValidacao(this.getMensagemValidacao(), this.getSeveridade());
                    }
                }
                return null;
            }
        });
        this.getNomeFontePagadora().addObservador((Observador)new ObservadorEspacosDuplicados());
        this.getNiFontePagadora().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

            @Override
            public RetornoValidacao validarImplementado() {
                if (!RendAcmDependente.this.getNiFontePagadora().isVazio() && RendAcmDependente.this.getNiFontePagadora().naoFormatado().equals(RendAcmDependente.this.cpfDependente.naoFormatado())) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("ni_fonte_pagadora_igual_dependente"), this.getSeveridade());
                }
                return null;
            }
        });
    }

    public CPF getCpfDependente() {
        return this.cpfDependente;
    }

    @Override
    public List<Pendencia> verificarPendencias(int numeroItem) {
        List<Pendencia> retorno = super.verificarPendencias(numeroItem);
        return retorno;
    }

    @Override
    protected List<Informacao> recuperarListaCamposPendencia() {
        List retorno = this.recuperarCamposInformacao();
        return retorno;
    }

    @Override
    public String getNomeAba() {
        return "Dependentes";
    }

    @Override
    public String getTituloFichaDashboard() {
        return "Rendimentos Recebidos Acumuladamente pelo Dependente";
    }

    @Override
    public RendAcmDependente obterCopia() {
        RendAcmDependente copia = new RendAcmDependente(IRPFFacade.getInstancia().getDeclaracao(), IRPFFacade.getInstancia().getDeclaracao().getColecaoRendAcmDependente());
        copia.getCpfDependente().setConteudo(this.getCpfDependente());
        copia.getOpcaoTributacao().setConteudo(this.getOpcaoTributacao());
        copia.getNomeFontePagadora().setConteudo(this.getNomeFontePagadora());
        copia.getNiFontePagadora().setConteudo(this.getNiFontePagadora());
        copia.getRendRecebidosInformado().setConteudo(this.getRendRecebidosInformado());
        copia.getParcIsenta65Anos().setConteudo(this.getParcIsenta65Anos());
        copia.getRendRecebidos().setConteudo(this.getRendRecebidos());
        copia.getContribuicaoPrevOficial().setConteudo(this.getContribuicaoPrevOficial());
        copia.getImpostoRetidoFonte().setConteudo(this.getImpostoRetidoFonte());
        copia.getPensaoAlimenticia().setConteudo(this.getPensaoAlimenticia());
        copia.getMesRecebimento().setConteudo(this.getMesRecebimento());
        copia.getNumMeses().setConteudo(this.getNumMeses());
        copia.getImpostoDevidoRRA().setConteudo(this.getImpostoDevidoRRA());
        copia.getValorJuros().setConteudo(this.getValorJuros());
        for (ItemQuadroPensaoAlimenticia item : this.getPensaoAlimenticiaQuadroAuxiliar().itens()) {
            ItemQuadroPensaoAlimenticia itemQuadro = new ItemQuadroPensaoAlimenticia();
            itemQuadro.getAlimentando().setConteudo(item.getAlimentando());
            itemQuadro.getValor().setConteudo(item.getValor());
            copia.getPensaoAlimenticiaQuadroAuxiliar().add(item);
        }
        return copia;
    }
}

