/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendIsentos;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import serpro.ppgd.cacheni.CacheNI;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.ValorPositivo;
import serpro.ppgd.irpf.bens.Bem;
import serpro.ppgd.irpf.calculos.CalculosRendIsentos;
import serpro.ppgd.irpf.gui.rendIsentos.PainelDadosRendIsentos;
import serpro.ppgd.irpf.rendIsentos.ColecaoItemQuadroGanhosAcoesOuro;
import serpro.ppgd.irpf.rendIsentos.ColecaoItemQuadroMeacaoDissolucao;
import serpro.ppgd.irpf.rendIsentos.ColecaoItemQuadroOutrosRendimentos;
import serpro.ppgd.irpf.rendIsentos.ColecaoItemQuadroPensaoAlimenticiaRendIsentos;
import serpro.ppgd.irpf.rendIsentos.ColecaoItemQuadroPensaoMolestiaGrave;
import serpro.ppgd.irpf.rendIsentos.ColecaoItemQuadroRendimentosNI;
import serpro.ppgd.irpf.rendIsentos.ColecaoItemQuadroTransferenciaPatrimonial;
import serpro.ppgd.irpf.rendIsentos.ColecaoItemQuadroTransporteDetalhado;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroAuxiliarAb;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroAuxiliarValor;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroAuxiliarValorTransportado;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroGanhosAcoesOuro;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroMeacaoDissolucao;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroOutrosRendimentos;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroPensaoMolestiaGrave;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroRendimentosNI;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroTransferenciaPatrimonial;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroTransporteDetalhado;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.irpf.util.QuadroAuxiliarUtil;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ElementoTabela;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Pendencia;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.Valor;

public class RendIsentos
extends ObjetoNegocio
implements ObjetoFicha {
    public static String TIPO_RENDISENTO_01 = "01";
    public static String TIPO_RENDISENTO_02 = "02";
    public static String TIPO_RENDISENTO_03 = "03";
    public static String TIPO_RENDISENTO_04 = "04";
    public static String TIPO_RENDISENTO_05 = "05";
    public static String TIPO_RENDISENTO_06 = "06";
    public static String TIPO_RENDISENTO_07 = "07";
    public static String TIPO_RENDISENTO_08 = "08";
    public static String TIPO_RENDISENTO_09 = "09";
    public static String TIPO_RENDISENTO_10 = "10";
    public static String TIPO_RENDISENTO_11 = "11";
    public static String TIPO_RENDISENTO_12 = "12";
    public static String TIPO_RENDISENTO_13 = "13";
    public static String TIPO_RENDISENTO_14 = "14";
    public static String TIPO_RENDISENTO_15 = "15";
    public static String TIPO_RENDISENTO_16 = "16";
    public static String TIPO_RENDISENTO_17 = "17";
    public static String TIPO_RENDISENTO_18 = "18";
    public static String TIPO_RENDISENTO_19 = "19";
    public static String TIPO_RENDISENTO_20 = "20";
    public static String TIPO_RENDISENTO_21 = "21";
    public static String TIPO_RENDISENTO_22 = "22";
    public static String TIPO_RENDISENTO_23 = "23";
    public static String TIPO_RENDISENTO_24 = "24";
    public static String TIPO_RENDISENTO_25 = "25";
    public static String TIPO_RENDISENTO_26 = "26";
    public static String TIPO_RENDISENTO_27 = "27";
    public static String TIPO_RENDISENTO_28 = "28";
    public static String TIPO_RENDISENTO_RRA_TELA = "27";
    public static String TIPO_RENDISENTO_PENSAO_ALIMENTICIA_TELA = "28";
    public static String TIPO_RENDISENTO_OUTROS_TELA = "99";
    public static final String COD_OUTROS_RENDIMENTOS_ISENTOS = "1";
    private ValorPositivo bolsaEstudos = new ValorPositivo(this, "bolsa Estudos");
    private ColecaoItemQuadroTransporteDetalhado bolsaEstudosQuadroAuxiliar = new ColecaoItemQuadroTransporteDetalhado();
    private ValorPositivo capitalApolices = new ValorPositivo(this, "capital Apolices");
    private ValorPositivo indenizacoes = new ValorPositivo(this, "indenizacoes");
    private ColecaoItemQuadroRendimentosNI indenizacoesQuadroAuxiliar = new ColecaoItemQuadroRendimentosNI();
    private ValorPositivo lucroAlienacao = new ValorPositivo(this, "lucro Alienacao");
    private ValorPositivo lucroRecebido = new ValorPositivo(this, "Lucro recebido");
    private ColecaoItemQuadroTransporteDetalhado lucroRecebidoQuadroAuxiliar = new ColecaoItemQuadroTransporteDetalhado();
    private ValorPositivo parcIsentaAtivRural = new ValorPositivo(this, "parcIsenta Ativ Rural");
    private ValorPositivo parcIsentaAposentadoria = new ValorPositivo(this, "Parcela isenta de proventos");
    private ColecaoItemQuadroTransporteDetalhado parcIsentaAposentadoriaQuadroAuxiliar = new ColecaoItemQuadroTransporteDetalhado(true);
    private ValorPositivo pensao = new ValorPositivo(this, "pensao");
    private ColecaoItemQuadroPensaoMolestiaGrave pensaoQuadroAuxiliar = new ColecaoItemQuadroPensaoMolestiaGrave();
    private ValorPositivo poupanca = new ValorPositivo(this, "poupanca");
    private ColecaoItemQuadroTransporteDetalhado poupancaQuadroAuxiliar = new ColecaoItemQuadroTransporteDetalhado();
    private ValorPositivo rendSocio = new ValorPositivo(this, "rend Socio");
    private ColecaoItemQuadroTransporteDetalhado rendSocioQuadroAuxiliar = new ColecaoItemQuadroTransporteDetalhado();
    private ValorPositivo transferencias = new ValorPositivo(this, "transferencias");
    private ColecaoItemQuadroTransferenciaPatrimonial transferenciasQuadroAuxiliar = new ColecaoItemQuadroTransferenciaPatrimonial();
    private ValorPositivo impostoRendasAnterioresCompensadoJudicialmente = new ValorPositivo(this, "imposto Rendas Anteriores Compensado Judicialmente");
    private ColecaoItemQuadroRendimentosNI impostoRendasAnterioresCompensadoJudicialmenteQuadroAuxiliar = new ColecaoItemQuadroRendimentosNI();
    private ValorPositivo rendAssalariadosMoedaEstrangeira = new ValorPositivo(this, "Rendimentos assalariados recebidos em moeda estrangeira");
    private ColecaoItemQuadroTransporteDetalhado rendAssalariadoMoedaEstrangeiraQuadroAuxiliar = new ColecaoItemQuadroTransporteDetalhado();
    private ValorPositivo incorporacaoReservaCapital = new ValorPositivo(this, "incorporacao Reserva Capital");
    private ColecaoItemQuadroTransporteDetalhado incorporacaoReservaCapitalQuadroAuxiliar = new ColecaoItemQuadroTransporteDetalhado();
    private ValorPositivo medicosResidentes = new ValorPositivo(this, "M\u00e9dicos Residentes");
    private ColecaoItemQuadroTransporteDetalhado medicosResidentesQuadroAuxiliar = new ColecaoItemQuadroTransporteDetalhado();
    private ValorPositivo voluntariosCopa = new ValorPositivo(this, "Volunt\u00e1rios da Copa");
    private ColecaoItemQuadroTransporteDetalhado voluntariosCopaQuadroAuxiliar = new ColecaoItemQuadroTransporteDetalhado();
    private ValorPositivo meacaoDissolucao = new ValorPositivo(this, "Mea\u00e7\u00e3o e Dissolu\u00e7\u00e3o");
    private ColecaoItemQuadroMeacaoDissolucao meacaoDissolucaoQuadroAuxiliar = new ColecaoItemQuadroMeacaoDissolucao();
    private ValorPositivo ganhosLiquidosAcoes = new ValorPositivo(this, "Ganhos L\u00edquidos com A\u00e7\u00f5es");
    private ColecaoItemQuadroGanhosAcoesOuro ganhosLiquidosAcoesQuadroAuxiliar = new ColecaoItemQuadroGanhosAcoesOuro();
    private ValorPositivo ganhosCapitalOuro = new ValorPositivo(this, "Ganhos de Capital com Ouro");
    private ColecaoItemQuadroGanhosAcoesOuro ganhosCapitalOuroQuadroAuxiliar = new ColecaoItemQuadroGanhosAcoesOuro();
    private ValorPositivo recuperacaoPrejuizosBolsaValores = new ValorPositivo(this, "Recupera\u00e7\u00e3o de Preju\u00edzos na Bolsa de Valores");
    private ValorPositivo transportadorCargas = new ValorPositivo(this, "Transportador de Cargas");
    private ValorPositivo transportadorPassageiros = new ValorPositivo(this, "Transportador de Passageiros");
    private ValorPositivo restituicaoImpostoRendaAnosAnteriores = new ValorPositivo(this, "Restitui\u00e7\u00e3o do Imposto sobre a Renda de Anos-Calend\u00e1rio Anteriores");
    private ValorPositivo jurosRra = new ValorPositivo(this, "rra");
    private ValorPositivo pensaoAlimenticia = new ValorPositivo(this, "pensaoAlimenticia");
    private ColecaoItemQuadroPensaoAlimenticiaRendIsentos pensaoAlimenticiaQuadroAuxiliar = new ColecaoItemQuadroPensaoAlimenticiaRendIsentos();
    private ValorPositivo outros = new ValorPositivo(this, "outros");
    private ColecaoItemQuadroOutrosRendimentos outrosQuadroAuxiliar = new ColecaoItemQuadroOutrosRendimentos();
    private Valor total = new Valor((ObjetoNegocio)this, "Total Rend Isentos");
    private ValorPositivo bensPequenoValorInformado = new ValorPositivo(this, "bens Pequeno Valor Informado");
    private ValorPositivo unicoImovelInformado = new ValorPositivo(this, "unico Imovel Informado");
    private ValorPositivo outrosBensImoveisInformado = new ValorPositivo(this, "outros Bens Imoveis Informado");
    private ValorPositivo moedaEstrangeiraEspecieInformado = new ValorPositivo(this, "moeda Estrangeira Especie Informado");
    private ValorPositivo totalInformado = new ValorPositivo(this, "total Informado");
    private ValorPositivo bensPequenoValorTransportado = new ValorPositivo(this, "bens Pequeno Valor Transportado");
    private ValorPositivo unicoImovelTransportado = new ValorPositivo(this, "unico Imovel Transportado");
    private ValorPositivo outrosBensImoveisTransportado = new ValorPositivo(this, "outros Bens Imoveis Transportado");
    private ValorPositivo totalTransportado = new ValorPositivo(this, "total Transportado");
    private ValorPositivo somaBensPequenoValor = new ValorPositivo(this, "soma bens Pequeno Valor");
    private ValorPositivo somaUnicoImovel = new ValorPositivo(this, "soma unico Imovel");
    private ValorPositivo somaOutrosBensImoveis = new ValorPositivo(this, "soma ");
    private String cpfTitular;
    WeakReference<DeclaracaoIRPF> weakDec = null;

    public RendIsentos(final DeclaracaoIRPF dec) {
        this.weakDec = new WeakReference<DeclaracaoIRPF>(dec);
        this.cpfTitular = dec.getIdentificadorDeclaracao().getCpf().formatado();
        this.getTotal().setReadOnly(true);
        this.getBolsaEstudos().setReadOnly(true);
        this.getIndenizacoes().setReadOnly(true);
        this.getParcIsentaAtivRural().setReadOnly(true);
        this.getParcIsentaAposentadoria().setReadOnly(true);
        this.getLucroRecebido().setReadOnly(true);
        this.getPensao().setReadOnly(true);
        this.getPoupanca().setReadOnly(true);
        this.getRendSocio().setReadOnly(true);
        this.getLucroAlienacao().setReadOnly(true);
        this.getBensPequenoValorTransportado().setReadOnly(true);
        this.getUnicoImovelTransportado().setReadOnly(true);
        this.getOutrosBensImoveisTransportado().setReadOnly(true);
        this.getSomaBensPequenoValor().setReadOnly(true);
        this.getSomaUnicoImovel().setReadOnly(true);
        this.getSomaOutrosBensImoveis().setReadOnly(true);
        this.getTransferencias().setReadOnly(true);
        this.getImpostoRendasAnterioresCompensadoJudicialmente().setReadOnly(true);
        this.getRendAssalariadosMoedaEstrangeira().setReadOnly(true);
        this.getIncorporacaoReservaCapital().setReadOnly(true);
        this.getMedicosResidentes().setReadOnly(true);
        this.getVoluntariosCopa().setReadOnly(true);
        this.getMeacaoDissolucao().setReadOnly(true);
        this.getGanhosLiquidosAcoes().setReadOnly(true);
        this.getGanhosCapitalOuro().setReadOnly(true);
        this.getRecuperacaoPrejuizosBolsaValores().setReadOnly(true);
        this.getJurosRra().setReadOnly(true);
        this.getPensaoAlimenticia().setReadOnly(true);
        this.getOutros().setReadOnly(true);
        this.getTotalInformado().setReadOnly(true);
        this.getTotalTransportado().setReadOnly(true);
        final WeakReference<DeclaracaoIRPF> weakDec = new WeakReference<DeclaracaoIRPF>(dec);
        this.getBolsaEstudosQuadroAuxiliar().setDec(weakDec);
        this.getIndenizacoesQuadroAuxiliar().setDec(weakDec);
        this.getLucroRecebidoQuadroAuxiliar().setDec(weakDec);
        this.getParcIsentaAposentadoriaQuadroAuxiliar().setDec(weakDec);
        this.getPensaoQuadroAuxiliar().setDec(weakDec);
        this.getPoupancaQuadroAuxiliar().setDec(weakDec);
        this.getRendSocioQuadroAuxiliar().setDec(weakDec);
        this.getTransferenciasQuadroAuxiliar().setDec(weakDec);
        this.getImpostoRendasAnterioresCompensadoJudicialmenteQuadroAuxiliar().setDec(weakDec);
        this.getRendAssalariadoMoedaEstrangeiraQuadroAuxiliar().setDec(weakDec);
        this.getIncorporacaoReservaCapitalQuadroAuxiliar().setDec(weakDec);
        this.getMedicosResidentesQuadroAuxiliar().setDec(weakDec);
        this.getVoluntariosCopaQuadroAuxiliar().setDec(weakDec);
        this.getMeacaoDissolucaoQuadroAuxiliar().setDec(weakDec);
        this.getGanhosLiquidosAcoesQuadroAuxiliar().setDec(weakDec);
        this.getGanhosCapitalOuroQuadroAuxiliar().setDec(weakDec);
        this.getOutrosQuadroAuxiliar().setDec(weakDec);
        this.getPensaoAlimenticiaQuadroAuxiliar().setDec(weakDec);
        this.parcIsentaAposentadoria.addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                String msg;
                StringBuffer listaCpfs = new StringBuffer();
                HashMap<String, Valor> valoresPorCPF = new HashMap<String, Valor>();
                for (Object obj : RendIsentos.this.parcIsentaAposentadoriaQuadroAuxiliar.itens()) {
                    ItemQuadroTransporteDetalhado item = (ItemQuadroTransporteDetalhado)((Object)obj);
                    if (!valoresPorCPF.containsKey(item.getCpfBeneficiario().formatado())) {
                        valoresPorCPF.put(item.getCpfBeneficiario().formatado(), new Valor());
                    }
                    Valor total = (Valor)valoresPorCPF.get(item.getCpfBeneficiario().formatado());
                    total.append('+', item.getValor());
                    total.append('+', (Valor)item.getValor13Salario());
                }
                Map<String, Valor> rendAcmCPFs = ((DeclaracaoIRPF)((Object)weakDec.get())).getRendAcm().obterTotalParcelaIsenta65AnosPorCPF();
                for (String cpf : rendAcmCPFs.keySet()) {
                    Valor rendAcmPorCPF = rendAcmCPFs.get(cpf);
                    if (!valoresPorCPF.containsKey(cpf)) {
                        valoresPorCPF.put(cpf, new Valor());
                    }
                    Valor total = (Valor)valoresPorCPF.get(cpf);
                    total.append('+', rendAcmPorCPF);
                }
                for (String cpf : valoresPorCPF.keySet()) {
                    if (!((Valor)valoresPorCPF.get(cpf)).comparacao(">", "24.751,74")) continue;
                    if (listaCpfs.length() > 0) {
                        listaCpfs.append(", ");
                    }
                    listaCpfs.append(cpf);
                }
                String[] arrListaCpfs = listaCpfs.toString().split(",");
                if (arrListaCpfs.length > 1) {
                    msg = MensagemUtil.getMensagem("rendisentos_aposentadoria_limite_cpfs", new String[]{listaCpfs.toString()});
                    return new RetornoValidacao(msg, this.getSeveridade());
                }
                if (arrListaCpfs.length == 1 && !arrListaCpfs[0].equals("")) {
                    msg = MensagemUtil.getMensagem("rendisentos_aposentadoria_limite_cpf", new String[]{listaCpfs.toString()});
                    return new RetornoValidacao(msg, this.getSeveridade());
                }
                return null;
            }
        });
        this.parcIsentaAposentadoria.addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                for (ItemQuadroTransporteDetalhado item : RendIsentos.this.parcIsentaAposentadoriaQuadroAuxiliar.itens()) {
                    if (!item.getTipoBeneficiario().formatado().equals("Dependente") || !item.getCpfBeneficiario().formatado().equals(dec.getIdentificadorDeclaracao().getCpf().formatado())) continue;
                    return new RetornoValidacao(MensagemUtil.getMensagem("rendisentos_beneficiario_nao_dependente"), this.getSeveridade());
                }
                return null;
            }
        });
        this.bolsaEstudos.addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                for (ItemQuadroTransporteDetalhado item : RendIsentos.this.bolsaEstudosQuadroAuxiliar.itens()) {
                    if (!item.getTipoBeneficiario().formatado().equals("Dependente") || !item.getCpfBeneficiario().formatado().equals(dec.getIdentificadorDeclaracao().getCpf().formatado())) continue;
                    return new RetornoValidacao(MensagemUtil.getMensagem("rendisentos_beneficiario_nao_dependente"), this.getSeveridade());
                }
                return null;
            }
        });
        this.indenizacoes.addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                for (ItemQuadroRendimentosNI item : RendIsentos.this.indenizacoesQuadroAuxiliar.itens()) {
                    if (!item.getTipoBeneficiario().formatado().equals("Dependente") || !item.getCpfBeneficiario().formatado().equals(dec.getIdentificadorDeclaracao().getCpf().formatado())) continue;
                    return new RetornoValidacao(MensagemUtil.getMensagem("rendisentos_beneficiario_nao_dependente"), this.getSeveridade());
                }
                return null;
            }
        });
        this.lucroRecebido.addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                for (ItemQuadroTransporteDetalhado item : RendIsentos.this.lucroRecebidoQuadroAuxiliar.itens()) {
                    if (!item.getTipoBeneficiario().formatado().equals("Dependente") || !item.getCpfBeneficiario().formatado().equals(dec.getIdentificadorDeclaracao().getCpf().formatado())) continue;
                    return new RetornoValidacao(MensagemUtil.getMensagem("rendisentos_beneficiario_nao_dependente"), this.getSeveridade());
                }
                return null;
            }
        });
        this.pensao.addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                for (ItemQuadroPensaoMolestiaGrave item : RendIsentos.this.pensaoQuadroAuxiliar.itens()) {
                    if (!item.getTipoBeneficiario().formatado().equals("Dependente") || !item.getCpfBeneficiario().formatado().equals(dec.getIdentificadorDeclaracao().getCpf().formatado())) continue;
                    return new RetornoValidacao(MensagemUtil.getMensagem("rendisentos_beneficiario_nao_dependente"), this.getSeveridade());
                }
                return null;
            }
        });
        this.poupanca.addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                for (ItemQuadroTransporteDetalhado item : RendIsentos.this.poupancaQuadroAuxiliar.itens()) {
                    if (!item.getTipoBeneficiario().formatado().equals("Dependente") || !item.getCpfBeneficiario().formatado().equals(dec.getIdentificadorDeclaracao().getCpf().formatado())) continue;
                    return new RetornoValidacao(MensagemUtil.getMensagem("rendisentos_beneficiario_nao_dependente"), this.getSeveridade());
                }
                return null;
            }
        });
        this.rendSocio.addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                for (ItemQuadroTransporteDetalhado item : RendIsentos.this.rendSocioQuadroAuxiliar.itens()) {
                    if (!item.getTipoBeneficiario().formatado().equals("Dependente") || !item.getCpfBeneficiario().formatado().equals(dec.getIdentificadorDeclaracao().getCpf().formatado())) continue;
                    return new RetornoValidacao(MensagemUtil.getMensagem("rendisentos_beneficiario_nao_dependente"), this.getSeveridade());
                }
                return null;
            }
        });
        this.transferencias.addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                for (ItemQuadroTransferenciaPatrimonial item : RendIsentos.this.transferenciasQuadroAuxiliar.itens()) {
                    if (!item.getTipoBeneficiario().formatado().equals("Dependente") || !item.getCpfBeneficiario().formatado().equals(dec.getIdentificadorDeclaracao().getCpf().formatado())) continue;
                    return new RetornoValidacao(MensagemUtil.getMensagem("rendisentos_beneficiario_nao_dependente"), this.getSeveridade());
                }
                return null;
            }
        });
        this.impostoRendasAnterioresCompensadoJudicialmente.addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                for (ItemQuadroRendimentosNI item : RendIsentos.this.impostoRendasAnterioresCompensadoJudicialmenteQuadroAuxiliar.itens()) {
                    if (!item.getTipoBeneficiario().formatado().equals("Dependente") || !item.getCpfBeneficiario().formatado().equals(dec.getIdentificadorDeclaracao().getCpf().formatado())) continue;
                    return new RetornoValidacao(MensagemUtil.getMensagem("rendisentos_beneficiario_nao_dependente"), this.getSeveridade());
                }
                return null;
            }
        });
        this.rendAssalariadosMoedaEstrangeira.addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                for (ItemQuadroTransporteDetalhado item : RendIsentos.this.rendAssalariadoMoedaEstrangeiraQuadroAuxiliar.itens()) {
                    if (!item.getTipoBeneficiario().formatado().equals("Dependente") || !item.getCpfBeneficiario().formatado().equals(dec.getIdentificadorDeclaracao().getCpf().formatado())) continue;
                    return new RetornoValidacao(MensagemUtil.getMensagem("rendisentos_beneficiario_nao_dependente"), this.getSeveridade());
                }
                return null;
            }
        });
        this.incorporacaoReservaCapital.addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                for (ItemQuadroTransporteDetalhado item : RendIsentos.this.incorporacaoReservaCapitalQuadroAuxiliar.itens()) {
                    if (!item.getTipoBeneficiario().formatado().equals("Dependente") || !item.getCpfBeneficiario().formatado().equals(dec.getIdentificadorDeclaracao().getCpf().formatado())) continue;
                    return new RetornoValidacao(MensagemUtil.getMensagem("rendisentos_beneficiario_nao_dependente"), this.getSeveridade());
                }
                return null;
            }
        });
        this.medicosResidentes.addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                for (ItemQuadroTransporteDetalhado item : RendIsentos.this.medicosResidentesQuadroAuxiliar.itens()) {
                    if (!item.getTipoBeneficiario().formatado().equals("Dependente") || !item.getCpfBeneficiario().formatado().equals(dec.getIdentificadorDeclaracao().getCpf().formatado())) continue;
                    return new RetornoValidacao(MensagemUtil.getMensagem("rendisentos_beneficiario_nao_dependente"), this.getSeveridade());
                }
                return null;
            }
        });
        this.voluntariosCopa.addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                StringBuffer listaCpfs = new StringBuffer();
                HashMap<String, Valor> valoresPorCPF = new HashMap<String, Valor>();
                for (ObjetoNegocio obj : RendIsentos.this.voluntariosCopaQuadroAuxiliar.itens()) {
                    ItemQuadroTransporteDetalhado item = (ItemQuadroTransporteDetalhado)obj;
                    if (!valoresPorCPF.containsKey(item.getCpfBeneficiario().formatado())) {
                        valoresPorCPF.put(item.getCpfBeneficiario().formatado(), new Valor());
                    }
                    Valor total = (Valor)valoresPorCPF.get(item.getCpfBeneficiario().formatado());
                    total.append('+', item.getValor());
                }
                for (String cpf : valoresPorCPF.keySet()) {
                    if (!((Valor)valoresPorCPF.get(cpf)).comparacao(">", "47.280,00")) continue;
                    if (listaCpfs.length() > 0) {
                        listaCpfs.append(", ");
                    }
                    listaCpfs.append(cpf);
                }
                if (listaCpfs.length() > 0) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("rendisentos_voluntarios_copa_limite", new String[]{"47.280,00", listaCpfs.toString()}), this.getSeveridade());
                }
                return null;
            }
        });
        this.voluntariosCopa.addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                for (ItemQuadroTransporteDetalhado item : RendIsentos.this.voluntariosCopaQuadroAuxiliar.itens()) {
                    if (!item.getTipoBeneficiario().formatado().equals("Dependente") || !item.getCpfBeneficiario().formatado().equals(dec.getIdentificadorDeclaracao().getCpf().formatado())) continue;
                    return new RetornoValidacao(MensagemUtil.getMensagem("rendisentos_beneficiario_nao_dependente"), this.getSeveridade());
                }
                return null;
            }
        });
        this.meacaoDissolucao.addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                for (ItemQuadroMeacaoDissolucao item : RendIsentos.this.meacaoDissolucaoQuadroAuxiliar.itens()) {
                    if (!item.getTipoBeneficiario().formatado().equals("Dependente") || !item.getCpfBeneficiario().formatado().equals(dec.getIdentificadorDeclaracao().getCpf().formatado())) continue;
                    return new RetornoValidacao(MensagemUtil.getMensagem("rendisentos_beneficiario_nao_dependente"), this.getSeveridade());
                }
                return null;
            }
        });
        this.ganhosLiquidosAcoes.addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                for (ItemQuadroGanhosAcoesOuro item : RendIsentos.this.ganhosLiquidosAcoesQuadroAuxiliar.itens()) {
                    if (!item.getTipoBeneficiario().formatado().equals("Dependente") || !item.getCpfBeneficiario().formatado().equals(dec.getIdentificadorDeclaracao().getCpf().formatado())) continue;
                    return new RetornoValidacao(MensagemUtil.getMensagem("rendisentos_beneficiario_nao_dependente"), this.getSeveridade());
                }
                return null;
            }
        });
        this.ganhosLiquidosAcoes.addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                Set<String> cpfsArray = RendIsentos.this.ganhosLiquidosAcoesQuadroAuxiliar.obterCPFsQueExcederamLimite();
                if (cpfsArray != null && !cpfsArray.isEmpty()) {
                    StringBuilder cpfs = new StringBuilder();
                    Iterator<String> iterator = cpfsArray.iterator();
                    while (iterator.hasNext()) {
                        cpfs.append(iterator.next());
                        if (!iterator.hasNext()) continue;
                        cpfs.append(", ");
                    }
                    return new RetornoValidacao(MensagemUtil.getMensagem("rendisentos_ganhos_acoes_ouro_valor_limite", new String[]{cpfs.toString(), RendIsentos.this.ganhosLiquidosAcoes.getNomeCampo()}), this.getSeveridade());
                }
                return null;
            }
        });
        this.ganhosCapitalOuro.addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                for (ItemQuadroGanhosAcoesOuro item : RendIsentos.this.ganhosCapitalOuroQuadroAuxiliar.itens()) {
                    if (!item.getTipoBeneficiario().formatado().equals("Dependente") || !item.getCpfBeneficiario().formatado().equals(dec.getIdentificadorDeclaracao().getCpf().formatado())) continue;
                    return new RetornoValidacao(MensagemUtil.getMensagem("rendisentos_beneficiario_nao_dependente"), this.getSeveridade());
                }
                return null;
            }
        });
        this.ganhosCapitalOuro.addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                Set<String> cpfsArray = RendIsentos.this.ganhosCapitalOuroQuadroAuxiliar.obterCPFsQueExcederamLimite();
                if (cpfsArray != null && !cpfsArray.isEmpty()) {
                    StringBuilder cpfs = new StringBuilder();
                    Iterator<String> iterator = cpfsArray.iterator();
                    while (iterator.hasNext()) {
                        cpfs.append(iterator.next());
                        if (!iterator.hasNext()) continue;
                        cpfs.append(", ");
                    }
                    return new RetornoValidacao(MensagemUtil.getMensagem("rendisentos_ganhos_acoes_ouro_valor_limite", new String[]{cpfs.toString(), RendIsentos.this.ganhosCapitalOuro.getNomeCampo()}), this.getSeveridade());
                }
                return null;
            }
        });
        this.outros.addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                for (ItemQuadroOutrosRendimentos item : RendIsentos.this.outrosQuadroAuxiliar.itens()) {
                    if (!item.getTipoBeneficiario().formatado().equals("Dependente") || !item.getCpfBeneficiario().formatado().equals(dec.getIdentificadorDeclaracao().getCpf().formatado())) continue;
                    return new RetornoValidacao(MensagemUtil.getMensagem("rendisentos_beneficiario_nao_dependente"), this.getSeveridade());
                }
                return null;
            }
        });
        this.setFicha("Rendimentos Isentos e N\u00e3o Tribut\u00e1veis");
    }

    public void addObservador(CalculosRendIsentos calculosRendIsentos) {
        this.bolsaEstudos.addObservador((Observador)calculosRendIsentos);
        this.capitalApolices.addObservador((Observador)calculosRendIsentos);
        this.indenizacoes.addObservador((Observador)calculosRendIsentos);
        this.bensPequenoValorInformado.addObservador((Observador)calculosRendIsentos);
        this.unicoImovelInformado.addObservador((Observador)calculosRendIsentos);
        this.outrosBensImoveisInformado.addObservador((Observador)calculosRendIsentos);
        this.moedaEstrangeiraEspecieInformado.addObservador((Observador)calculosRendIsentos);
        this.bensPequenoValorTransportado.addObservador((Observador)calculosRendIsentos);
        this.unicoImovelTransportado.addObservador((Observador)calculosRendIsentos);
        this.outrosBensImoveisTransportado.addObservador((Observador)calculosRendIsentos);
        this.lucroAlienacao.addObservador((Observador)calculosRendIsentos);
        this.lucroRecebido.addObservador((Observador)calculosRendIsentos);
        this.parcIsentaAtivRural.addObservador((Observador)calculosRendIsentos);
        this.parcIsentaAposentadoria.addObservador((Observador)calculosRendIsentos);
        this.pensao.addObservador((Observador)calculosRendIsentos);
        this.poupanca.addObservador((Observador)calculosRendIsentos);
        this.rendSocio.addObservador((Observador)calculosRendIsentos);
        this.transferencias.addObservador((Observador)calculosRendIsentos);
        this.impostoRendasAnterioresCompensadoJudicialmente.addObservador((Observador)calculosRendIsentos);
        this.rendAssalariadosMoedaEstrangeira.addObservador((Observador)calculosRendIsentos);
        this.incorporacaoReservaCapital.addObservador((Observador)calculosRendIsentos);
        this.medicosResidentes.addObservador((Observador)calculosRendIsentos);
        this.voluntariosCopa.addObservador((Observador)calculosRendIsentos);
        this.meacaoDissolucao.addObservador((Observador)calculosRendIsentos);
        this.ganhosLiquidosAcoes.addObservador((Observador)calculosRendIsentos);
        this.ganhosCapitalOuro.addObservador((Observador)calculosRendIsentos);
        this.recuperacaoPrejuizosBolsaValores.addObservador((Observador)calculosRendIsentos);
        this.transportadorCargas.addObservador((Observador)calculosRendIsentos);
        this.transportadorPassageiros.addObservador((Observador)calculosRendIsentos);
        this.restituicaoImpostoRendaAnosAnteriores.addObservador((Observador)calculosRendIsentos);
        this.outros.addObservador((Observador)calculosRendIsentos);
        this.jurosRra.addObservador((Observador)calculosRendIsentos);
        this.pensaoAlimenticia.addObservador((Observador)calculosRendIsentos);
    }

    public boolean totalAlto() {
        return this.total.comparacao(">", "1.000.000,00");
    }

    public Valor recuperarTotalTitularExcetoAtividadeRuraleGC() {
        DeclaracaoIRPF dec;
        Valor result = new Valor();
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarTitular(this.indenizacoesQuadroAuxiliar));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarTitular(this.lucroRecebidoQuadroAuxiliar));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarTitular(this.parcIsentaAposentadoriaQuadroAuxiliar));
        result.append('+', this.getCapitalApolices());
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarTitular(this.poupancaQuadroAuxiliar));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarTitular(this.pensaoQuadroAuxiliar));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarTitular(this.transferenciasQuadroAuxiliar));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarTitular(this.impostoRendasAnterioresCompensadoJudicialmenteQuadroAuxiliar));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarTitular(this.outrosQuadroAuxiliar));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarTitular(this.bolsaEstudosQuadroAuxiliar));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarTitular(this.rendSocioQuadroAuxiliar));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarTitular(this.incorporacaoReservaCapitalQuadroAuxiliar));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarTitular(this.rendAssalariadoMoedaEstrangeiraQuadroAuxiliar));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarTitular(this.medicosResidentesQuadroAuxiliar));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarTitular(this.voluntariosCopaQuadroAuxiliar));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarTitular(this.meacaoDissolucaoQuadroAuxiliar));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarTitular(this.ganhosLiquidosAcoesQuadroAuxiliar));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarTitular(this.ganhosCapitalOuroQuadroAuxiliar));
        result.append('+', (Valor)this.getRecuperacaoPrejuizosBolsaValores());
        result.append('+', (Valor)this.getTransportadorCargas());
        result.append('+', (Valor)this.getTransportadorPassageiros());
        result.append('+', (Valor)this.getRestituicaoImpostoRendaAnosAnteriores());
        if (this.weakDec != null && (dec = (DeclaracaoIRPF)((Object)this.weakDec.get())) != null) {
            result.append('+', dec.getColecaoRendAcmTitular().getTotaisJuros());
        }
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarTitular(this.pensaoAlimenticiaQuadroAuxiliar));
        if (result.getParteInteira().length() > result.getMaximoDigitosParteInteira()) {
            result.setConteudo(Long.valueOf(0L));
        }
        return result;
    }

    public Valor recuperarTotalTitular() {
        Valor result = new Valor();
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarTitular(this.bolsaEstudosQuadroAuxiliar));
        result.append('+', this.getCapitalApolices());
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarTitular(this.indenizacoesQuadroAuxiliar));
        result.append('+', this.getLucroAlienacao());
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarTitular(this.lucroRecebidoQuadroAuxiliar));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarTitular(this.parcIsentaAposentadoriaQuadroAuxiliar));
        result.append('+', ((DeclaracaoIRPF)((Object)this.parcIsentaAposentadoriaQuadroAuxiliar.getDec().get())).getRendAcm().getColecaoRendAcmTitular().obterSomatorioParcelaIsenta65Anos());
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarTitular(this.pensaoQuadroAuxiliar));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarTitular(this.poupancaQuadroAuxiliar));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarTitular(this.rendSocioQuadroAuxiliar));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarTitular(this.transferenciasQuadroAuxiliar));
        result.append('+', this.getParcIsentaAtivRural());
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarTitular(this.impostoRendasAnterioresCompensadoJudicialmenteQuadroAuxiliar));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarTitular(this.rendAssalariadoMoedaEstrangeiraQuadroAuxiliar));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarTitular(this.incorporacaoReservaCapitalQuadroAuxiliar));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarTitular(this.medicosResidentesQuadroAuxiliar));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarTitular(this.voluntariosCopaQuadroAuxiliar));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarTitular(this.meacaoDissolucaoQuadroAuxiliar));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarTitular(this.ganhosLiquidosAcoesQuadroAuxiliar));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarTitular(this.ganhosCapitalOuroQuadroAuxiliar));
        result.append('+', (Valor)this.getRecuperacaoPrejuizosBolsaValores());
        result.append('+', (Valor)this.getTransportadorCargas());
        result.append('+', (Valor)this.getTransportadorPassageiros());
        result.append('+', (Valor)this.getRestituicaoImpostoRendaAnosAnteriores());
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarTitular(this.outrosQuadroAuxiliar));
        result.append('+', ((DeclaracaoIRPF)((Object)this.parcIsentaAposentadoriaQuadroAuxiliar.getDec().get())).getRendAcm().getColecaoRendAcmTitular().obterSomatorioJurosRRA());
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarTitular(this.pensaoAlimenticiaQuadroAuxiliar));
        return result;
    }

    public Valor recuperarTotalDependentes() {
        Valor result = new Valor();
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarDependente(this.indenizacoesQuadroAuxiliar));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarDependente(this.lucroRecebidoQuadroAuxiliar));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarDependente(this.parcIsentaAposentadoriaQuadroAuxiliar));
        result.append('+', ((DeclaracaoIRPF)((Object)this.parcIsentaAposentadoriaQuadroAuxiliar.getDec().get())).getRendAcm().getColecaoRendAcmDependente().obterSomatorioParcelaIsenta65Anos());
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarDependente(this.pensaoQuadroAuxiliar));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarDependente(this.poupancaQuadroAuxiliar));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarDependente(this.bolsaEstudosQuadroAuxiliar));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarDependente(this.rendSocioQuadroAuxiliar));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarDependente(this.transferenciasQuadroAuxiliar));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarDependente(this.impostoRendasAnterioresCompensadoJudicialmenteQuadroAuxiliar));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarDependente(this.rendAssalariadoMoedaEstrangeiraQuadroAuxiliar));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarDependente(this.incorporacaoReservaCapitalQuadroAuxiliar));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarDependente(this.medicosResidentesQuadroAuxiliar));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarDependente(this.voluntariosCopaQuadroAuxiliar));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarDependente(this.meacaoDissolucaoQuadroAuxiliar));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarDependente(this.ganhosLiquidosAcoesQuadroAuxiliar));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarDependente(this.ganhosCapitalOuroQuadroAuxiliar));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarDependente(this.outrosQuadroAuxiliar));
        result.append('+', ((DeclaracaoIRPF)((Object)this.parcIsentaAposentadoriaQuadroAuxiliar.getDec().get())).getRendAcm().getColecaoRendAcmDependente().obterSomatorioJurosRRA());
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarDependente(this.pensaoAlimenticiaQuadroAuxiliar));
        return result;
    }

    public Valor recuperarTotalPorBeneficiario(CPF cpfBeneficiario) {
        Valor result = new Valor();
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarPorBeneficiario(this.indenizacoesQuadroAuxiliar, cpfBeneficiario, false));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarPorBeneficiario(this.lucroRecebidoQuadroAuxiliar, cpfBeneficiario, false));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarPorBeneficiario(this.parcIsentaAposentadoriaQuadroAuxiliar, cpfBeneficiario, true));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarPorBeneficiario(this.pensaoQuadroAuxiliar, cpfBeneficiario, true));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarPorBeneficiario(this.poupancaQuadroAuxiliar, cpfBeneficiario, false));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarPorBeneficiario(this.bolsaEstudosQuadroAuxiliar, cpfBeneficiario, false));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarPorBeneficiario(this.rendSocioQuadroAuxiliar, cpfBeneficiario, false));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarPorBeneficiario(this.transferenciasQuadroAuxiliar, cpfBeneficiario, false));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarPorBeneficiario(this.impostoRendasAnterioresCompensadoJudicialmenteQuadroAuxiliar, cpfBeneficiario, false));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarPorBeneficiario(this.rendAssalariadoMoedaEstrangeiraQuadroAuxiliar, cpfBeneficiario, false));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarPorBeneficiario(this.incorporacaoReservaCapitalQuadroAuxiliar, cpfBeneficiario, false));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarPorBeneficiario(this.medicosResidentesQuadroAuxiliar, cpfBeneficiario, false));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarPorBeneficiario(this.voluntariosCopaQuadroAuxiliar, cpfBeneficiario, false));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarPorBeneficiario(this.meacaoDissolucaoQuadroAuxiliar, cpfBeneficiario, false));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarPorBeneficiario(this.ganhosLiquidosAcoesQuadroAuxiliar, cpfBeneficiario, false));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarPorBeneficiario(this.ganhosCapitalOuroQuadroAuxiliar, cpfBeneficiario, false));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarPorBeneficiario(this.outrosQuadroAuxiliar, cpfBeneficiario, false));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarPorBeneficiario(this.pensaoAlimenticiaQuadroAuxiliar, cpfBeneficiario, false));
        return result;
    }

    public Valor recuperarSubTotalRendIsentoTransportado() {
        Valor result = new Valor();
        result.append('+', this.getParcIsentaAtivRural());
        result.append('+', this.getLucroAlienacao());
        return result;
    }

    protected List<Informacao> recuperarListaCamposPendencia() {
        List lista = super.recuperarListaCamposPendencia();
        lista.add(this.bolsaEstudos);
        lista.add(this.indenizacoes);
        lista.add(this.lucroAlienacao);
        lista.add(this.lucroRecebido);
        lista.add(this.parcIsentaAposentadoria);
        lista.add(this.pensao);
        lista.add(this.poupanca);
        lista.add(this.transferencias);
        lista.add(this.rendSocio);
        lista.add(this.poupanca);
        lista.add(this.impostoRendasAnterioresCompensadoJudicialmente);
        lista.add(this.rendAssalariadosMoedaEstrangeira);
        lista.add(this.incorporacaoReservaCapital);
        lista.add(this.medicosResidentes);
        lista.add(this.voluntariosCopa);
        lista.add(this.meacaoDissolucao);
        lista.add(this.ganhosLiquidosAcoes);
        lista.add(this.ganhosCapitalOuro);
        lista.add(this.outros);
        lista.add(this.total);
        return lista;
    }

    private Colecao<ItemQuadroAuxiliarAb> getColecaoRendimentoValorTransportado(final Valor val, final Valor ValTransportado) {
        Colecao<ItemQuadroAuxiliarAb> col = new Colecao<ItemQuadroAuxiliarAb>(){

            public ItemQuadroAuxiliarAb instanciaNovoObjeto() {
                return new ItemQuadroAuxiliarValorTransportado(val, ValTransportado);
            }

            public int novoObjeto() {
                if (this.itens().size() > 0) {
                    return 0;
                }
                return super.novoObjeto();
            }

            public void objetoRemovido(Object o) {
                val.clear();
            }
        };
        if (!val.isVazio()) {
            col.novoObjeto();
        }
        return col;
    }

    private Colecao<ItemQuadroAuxiliarAb> getColecaoRendimentoValor(final Valor val) {
        Colecao<ItemQuadroAuxiliarAb> col = new Colecao<ItemQuadroAuxiliarAb>(){

            public ItemQuadroAuxiliarAb instanciaNovoObjeto() {
                return new ItemQuadroAuxiliarValor(val);
            }

            public int novoObjeto() {
                if (this.itens().size() > 0) {
                    return 0;
                }
                return super.novoObjeto();
            }

            public void objetoRemovido(Object o) {
                val.clear();
            }
        };
        if (!val.isVazio()) {
            col.novoObjeto();
        }
        return col;
    }

    public List<Colecao<? extends ItemQuadroAuxiliarAb>> getColecoesRendimentos() {
        ArrayList<Colecao<? extends ItemQuadroAuxiliarAb>> colecoes = new ArrayList<Colecao<? extends ItemQuadroAuxiliarAb>>();
        colecoes.add(this.getBolsaEstudosQuadroAuxiliar());
        colecoes.add(this.getMedicosResidentesQuadroAuxiliar());
        colecoes.add(this.getColecaoRendimentoValor(this.getCapitalApolices()));
        colecoes.add(this.getIndenizacoesQuadroAuxiliar());
        colecoes.add(this.getColecaoRendimentoValorTransportado(this.getBensPequenoValorInformado(), this.getBensPequenoValorTransportado()));
        colecoes.add(this.getColecaoRendimentoValorTransportado(this.getUnicoImovelInformado(), this.getUnicoImovelTransportado()));
        colecoes.add(this.getColecaoRendimentoValorTransportado(this.getOutrosBensImoveisInformado(), this.getOutrosBensImoveisTransportado()));
        colecoes.add(this.getColecaoRendimentoValor(this.getMoedaEstrangeiraEspecieInformado()));
        colecoes.add(this.getLucroRecebidoQuadroAuxiliar());
        colecoes.add(this.getParcIsentaAposentadoriaQuadroAuxiliar());
        colecoes.add(this.getPensaoQuadroAuxiliar());
        colecoes.add(this.getPoupancaQuadroAuxiliar());
        colecoes.add(this.getRendSocioQuadroAuxiliar());
        colecoes.add(this.getTransferenciasQuadroAuxiliar());
        colecoes.add(this.getImpostoRendasAnterioresCompensadoJudicialmenteQuadroAuxiliar());
        colecoes.add(this.getRendAssalariadoMoedaEstrangeiraQuadroAuxiliar());
        colecoes.add(this.getIncorporacaoReservaCapitalQuadroAuxiliar());
        colecoes.add(this.getMeacaoDissolucaoQuadroAuxiliar());
        colecoes.add(this.getGanhosLiquidosAcoesQuadroAuxiliar());
        colecoes.add(this.getGanhosCapitalOuroQuadroAuxiliar());
        colecoes.add(this.getColecaoRendimentoValor(this.getTransportadorCargas()));
        colecoes.add(this.getColecaoRendimentoValor(this.getTransportadorPassageiros()));
        colecoes.add(this.getColecaoRendimentoValor(this.getRestituicaoImpostoRendaAnosAnteriores()));
        colecoes.add(this.getPensaoAlimenticiaQuadroAuxiliar());
        colecoes.add(this.getOutrosQuadroAuxiliar());
        return colecoes;
    }

    public List<Pendencia> verificarPendencias(int index) {
        List listPendencias = super.verificarPendencias(index);
        List<ElementoTabela> tiposRendimentos = CadastroTabelasIRPF.recuperarTiposRendimentosIsentos();
        List<Colecao<? extends ItemQuadroAuxiliarAb>> lista = this.getColecoesRendimentos();
        int indice = 0;
        int offset = 1;
        for (Colecao<? extends ItemQuadroAuxiliarAb> itens : lista) {
            listPendencias.addAll(QuadroAuxiliarUtil.validarQuadroAuxiliarAb(itens, offset, tiposRendimentos.get(indice).getConteudo(1), true));
            offset += itens.itens().size();
            ++indice;
        }
        return listPendencias;
    }

    private Pendencia getPendenciaParcelaIsentaAposentadoria() {
        Pendencia pendencia = null;
        RetornoValidacao retorno = this.parcIsentaAposentadoria.validar().getPrimeiroRetornoValidacaoMaisSevero();
        if (retorno.getSeveridade() == 3) {
            pendencia = new Pendencia(retorno.getSeveridade(), (Informacao)this.parcIsentaAposentadoria, this.parcIsentaAposentadoria.getNomeCampo(), retorno.getMensagemValidacao(), -1);
            pendencia.getCampoInformacao().setFicha("Rendimentos Isentos e N\u00e3o Tribut\u00e1veis");
            pendencia.setNomeAba("Totais");
            pendencia.setCampo(this.parcIsentaAposentadoria.getNomeCampo());
            pendencia.setClassePainel(PainelDadosRendIsentos.class.getName());
        }
        return pendencia;
    }

    public boolean isParcelaIsentaAposentadoriaCaso1(Valor valor, Valor salario13) {
        boolean retorno = false;
        if (!valor.isVazio() && salario13.isVazio()) {
            retorno = true;
        }
        return retorno;
    }

    public boolean isParcelaIsentaAposentadoriaCaso2(Valor valor, Valor salario13) {
        boolean retorno = false;
        if (valor.comparacao("=", "24.751,74") && salario13.comparacao(">", "0,00")) {
            retorno = true;
        }
        return retorno;
    }

    public String getClasseFicha() {
        return PainelDadosRendIsentos.class.getName();
    }

    public boolean isVazio() {
        return this.bolsaEstudos.isVazio() && this.capitalApolices.isVazio() && this.indenizacoes.isVazio() && this.lucroAlienacao.isVazio() && this.lucroRecebido.isVazio() && this.parcIsentaAposentadoria.isVazio() && this.pensao.isVazio() && this.poupanca.isVazio() && this.rendSocio.isVazio() && this.transferencias.isVazio() && this.parcIsentaAtivRural.isVazio() && this.impostoRendasAnterioresCompensadoJudicialmente.isVazio() && this.rendAssalariadosMoedaEstrangeira.isVazio() && this.incorporacaoReservaCapital.isVazio() && this.medicosResidentes.isVazio() && this.voluntariosCopa.isVazio() && this.meacaoDissolucao.isVazio() && this.ganhosLiquidosAcoes.isVazio() && this.ganhosCapitalOuro.isVazio() && this.recuperacaoPrejuizosBolsaValores.isVazio() && this.outros.isVazio() && this.transportadorCargas.isVazio() && this.transportadorPassageiros.isVazio() && this.restituicaoImpostoRendaAnosAnteriores.isVazio() && this.jurosRra.isVazio() && this.pensaoAlimenticia.isVazio();
    }

    public String getNomeAba() {
        return "Rendimentos";
    }

    public boolean possuiDependenteComCPF(String cpf) {
        if (cpf == null || cpf.trim().isEmpty()) {
            return false;
        }
        return this.getBolsaEstudosQuadroAuxiliar().possuiDependenteComCPF(cpf) || this.getIndenizacoesQuadroAuxiliar().possuiDependenteComCPF(cpf) || this.getLucroRecebidoQuadroAuxiliar().possuiDependenteComCPF(cpf) || this.getParcIsentaAposentadoriaQuadroAuxiliar().possuiDependenteComCPF(cpf) || this.getPensaoQuadroAuxiliar().possuiDependenteComCPF(cpf) || this.getPoupancaQuadroAuxiliar().possuiDependenteComCPF(cpf) || this.getRendSocioQuadroAuxiliar().possuiDependenteComCPF(cpf) || this.getRendAssalariadoMoedaEstrangeiraQuadroAuxiliar().possuiDependenteComCPF(cpf) || this.getImpostoRendasAnterioresCompensadoJudicialmenteQuadroAuxiliar().possuiDependenteComCPF(cpf) || this.getTransferenciasQuadroAuxiliar().possuiDependenteComCPF(cpf) || this.getIncorporacaoReservaCapitalQuadroAuxiliar().possuiDependenteComCPF(cpf) || this.getMedicosResidentesQuadroAuxiliar().possuiDependenteComCPF(cpf) || this.getVoluntariosCopaQuadroAuxiliar().possuiDependenteComCPF(cpf) || this.getMeacaoDissolucaoQuadroAuxiliar().possuiDependenteComCPF(cpf) || this.getGanhosLiquidosAcoesQuadroAuxiliar().possuiDependenteComCPF(cpf) || this.getGanhosCapitalOuroQuadroAuxiliar().possuiDependenteComCPF(cpf) || this.getOutrosQuadroAuxiliar().possuiDependenteComCPF(cpf) || this.getPensaoAlimenticiaQuadroAuxiliar().possuiDependenteComCPF(cpf);
    }

    public void excluirDependentesComCPF(String cpf) {
        this.getBolsaEstudosQuadroAuxiliar().excluirDependentesComCPF(cpf);
        this.getIndenizacoesQuadroAuxiliar().excluirDependentesComCPF(cpf);
        this.getLucroRecebidoQuadroAuxiliar().excluirDependentesComCPF(cpf);
        this.getParcIsentaAposentadoriaQuadroAuxiliar().excluirDependentesComCPF(cpf);
        this.getPensaoQuadroAuxiliar().excluirDependentesComCPF(cpf);
        this.getPoupancaQuadroAuxiliar().excluirDependentesComCPF(cpf);
        this.getRendSocioQuadroAuxiliar().excluirDependentesComCPF(cpf);
        this.getRendAssalariadoMoedaEstrangeiraQuadroAuxiliar().excluirDependentesComCPF(cpf);
        this.getImpostoRendasAnterioresCompensadoJudicialmenteQuadroAuxiliar().excluirDependentesComCPF(cpf);
        this.getTransferenciasQuadroAuxiliar().excluirDependentesComCPF(cpf);
        this.getIncorporacaoReservaCapitalQuadroAuxiliar().excluirDependentesComCPF(cpf);
        this.getMedicosResidentesQuadroAuxiliar().excluirDependentesComCPF(cpf);
        this.getVoluntariosCopaQuadroAuxiliar().excluirDependentesComCPF(cpf);
        this.getMeacaoDissolucaoQuadroAuxiliar().excluirDependentesComCPF(cpf);
        this.getGanhosLiquidosAcoesQuadroAuxiliar().excluirDependentesComCPF(cpf);
        this.getGanhosCapitalOuroQuadroAuxiliar().excluirDependentesComCPF(cpf);
        this.getOutrosQuadroAuxiliar().excluirDependentesComCPF(cpf);
        this.getPensaoAlimenticiaQuadroAuxiliar().excluirDependentesComCPF(cpf);
    }

    private void preencherNomeComCache(String key, Informacao informacao) {
        String valor = CacheNI.getInstancia().getCachedKey(key);
        if (valor != null) {
            informacao.setConteudo(valor);
        }
    }

    public void atualizarRendIsento(Bem bem, String codigoRendimento) {
        block9: {
            block11: {
                block10: {
                    if (!TIPO_RENDISENTO_09.equals(codigoRendimento)) break block10;
                    for (ItemQuadroTransporteDetalhado item : this.getLucroRecebidoQuadroAuxiliar().itens()) {
                        if (!item.getCodBem().naoFormatado().equals(bem.getIndice().naoFormatado())) continue;
                        if (bem.getCPFBeneficiario().naoFormatado().equals(((DeclaracaoIRPF)((Object)this.weakDec.get())).getIdentificadorDeclaracao().getCpf().naoFormatado())) {
                            item.getTipoBeneficiario().setConteudo("Titular");
                        } else {
                            item.getTipoBeneficiario().setConteudo("Dependente");
                        }
                        item.getCpfBeneficiario().setConteudo(bem.getCPFBeneficiario());
                        item.getCnpjEmpresa().setConteudo(bem.getNiEmpresa());
                        this.preencherNomeComCache(item.getCnpjEmpresa().naoFormatado(), (Informacao)item.getNomeFontePagadora());
                        break block9;
                    }
                    break block9;
                }
                if (!TIPO_RENDISENTO_12.equals(codigoRendimento)) break block11;
                for (ItemQuadroTransporteDetalhado item : this.getPoupancaQuadroAuxiliar().itens()) {
                    if (!item.getCodBem().naoFormatado().equals(bem.getIndice().naoFormatado())) continue;
                    if (bem.getCPFBeneficiario().naoFormatado().equals(((DeclaracaoIRPF)((Object)this.weakDec.get())).getIdentificadorDeclaracao().getCpf().naoFormatado())) {
                        item.getTipoBeneficiario().setConteudo("Titular");
                    } else {
                        item.getTipoBeneficiario().setConteudo("Dependente");
                    }
                    item.getCpfBeneficiario().setConteudo(bem.getCPFBeneficiario());
                    item.getCnpjEmpresa().setConteudo(bem.getNiEmpresa());
                    this.preencherNomeComCache(item.getCnpjEmpresa().naoFormatado(), (Informacao)item.getNomeFontePagadora());
                    break block9;
                }
                break block9;
            }
            if (!TIPO_RENDISENTO_26.equals(codigoRendimento)) break block9;
            for (ItemQuadroOutrosRendimentos item : this.getOutrosQuadroAuxiliar().itens()) {
                if (!item.getCodBem().naoFormatado().equals(bem.getIndice().naoFormatado())) continue;
                if (bem.getCPFBeneficiario().naoFormatado().equals(((DeclaracaoIRPF)((Object)this.weakDec.get())).getIdentificadorDeclaracao().getCpf().naoFormatado())) {
                    item.getTipoBeneficiario().setConteudo("Titular");
                } else {
                    item.getTipoBeneficiario().setConteudo("Dependente");
                }
                item.getCpfBeneficiario().setConteudo(bem.getCPFBeneficiario());
                item.getCnpjEmpresa().setConteudo(bem.getNiEmpresa());
                this.preencherNomeComCache(item.getCnpjEmpresa().naoFormatado(), (Informacao)item.getNomeFonte());
                break;
            }
        }
    }

    public ItemQuadroAuxiliarAb criarNovoRendimentoIsento(Bem bem, String codigoRendimento) {
        ItemQuadroAuxiliarAb itemRetorno = null;
        if (TIPO_RENDISENTO_09.equals(codigoRendimento)) {
            itemRetorno = this.adicionarNovoRendimentoExclusivo(bem, this.getLucroRecebidoQuadroAuxiliar());
        } else if (TIPO_RENDISENTO_12.equals(codigoRendimento)) {
            itemRetorno = this.adicionarNovoRendimentoExclusivo(bem, this.getPoupancaQuadroAuxiliar());
        } else if (TIPO_RENDISENTO_26.equals(codigoRendimento)) {
            ItemQuadroOutrosRendimentos item = new ItemQuadroOutrosRendimentos((DeclaracaoIRPF)((Object)this.weakDec.get()));
            item.getCodBem().setConteudo(bem.getIndice());
            if (bem.getCPFBeneficiario().naoFormatado().equals(((DeclaracaoIRPF)((Object)this.weakDec.get())).getIdentificadorDeclaracao().getCpf().naoFormatado())) {
                item.getTipoBeneficiario().setConteudo("Titular");
            } else {
                item.getTipoBeneficiario().setConteudo("Dependente");
            }
            item.getCpfBeneficiario().setConteudo(bem.getCPFBeneficiario());
            item.getCnpjEmpresa().setConteudo(bem.getNiEmpresa());
            this.preencherNomeComCache(item.getCnpjEmpresa().naoFormatado(), (Informacao)item.getNomeFonte());
            Object descricao = bem.getGrupo().getConteudoAtual(0) + bem.getCodigo().getConteudoAtual(1);
            descricao = StringUtils.left((String)descricao, (int)60);
            item.getDescricaoRendimento().setConteudo((String)descricao);
            this.getOutrosQuadroAuxiliar().add(item);
            itemRetorno = item;
        }
        return itemRetorno;
    }

    private ItemQuadroAuxiliarAb adicionarNovoRendimentoExclusivo(Bem bem, Colecao colecao) {
        ItemQuadroTransporteDetalhado item = new ItemQuadroTransporteDetalhado((DeclaracaoIRPF)((Object)this.weakDec.get()));
        item.getCodBem().setConteudo(bem.getIndice());
        if (bem.getCPFBeneficiario().naoFormatado().equals(((DeclaracaoIRPF)((Object)this.weakDec.get())).getIdentificadorDeclaracao().getCpf().naoFormatado())) {
            item.getTipoBeneficiario().setConteudo("Titular");
        } else {
            item.getTipoBeneficiario().setConteudo("Dependente");
        }
        item.getCpfBeneficiario().setConteudo(bem.getCPFBeneficiario());
        item.getCnpjEmpresa().setConteudo(bem.getNiEmpresa());
        this.preencherNomeComCache(item.getCnpjEmpresa().naoFormatado(), (Informacao)item.getNomeFontePagadora());
        colecao.add((ObjetoNegocio)item);
        return item;
    }

    public void excluirRendimento(String tipoRendimento, ItemQuadroAuxiliarAb item) {
        if (TIPO_RENDISENTO_09.equals(tipoRendimento)) {
            this.getLucroRecebidoQuadroAuxiliar().remove((ItemQuadroTransporteDetalhado)item);
        } else if (TIPO_RENDISENTO_12.equals(tipoRendimento)) {
            this.getPoupancaQuadroAuxiliar().remove((ItemQuadroTransporteDetalhado)item);
        } else if (TIPO_RENDISENTO_26.equals(tipoRendimento)) {
            this.getOutrosQuadroAuxiliar().remove((ItemQuadroOutrosRendimentos)item);
        }
    }

    public static boolean heRendIsentoTipo01X(int codTipo) {
        boolean retorno = false;
        if (codTipo == 3 || codTipo == 8 || codTipo == 23 || codTipo == 24 || codTipo == 25) {
            retorno = true;
        }
        return retorno;
    }

    public static boolean heRendIsentoTipo02X(int codTipo) {
        boolean retorno = false;
        if (codTipo == 19 || codTipo == 20 || codTipo == 21) {
            retorno = true;
        }
        return retorno;
    }

    public static boolean heRendIsentoTipo03X(int codTipo) {
        boolean retorno = false;
        if (codTipo == 1 || codTipo == 2 || codTipo == 4 || codTipo == 9 || codTipo == 10 || codTipo == 12 || codTipo == 13 || codTipo == 14 || codTipo == 16 || codTipo == 17 || codTipo == 18) {
            retorno = true;
        }
        return retorno;
    }

    public static boolean heRendIsentoTipo03XPensaoAlimenticia(int codTipo) {
        return codTipo == 28;
    }

    public static boolean heRendIsentoTipo04X(int codTipo) {
        boolean retorno = false;
        if (codTipo == 11) {
            retorno = true;
        }
        return retorno;
    }

    public static boolean heRendIsentoTipo05X(int codTipo) {
        boolean retorno = false;
        if (codTipo == 99) {
            retorno = true;
        }
        return retorno;
    }

    public static boolean heRendIsentoTipo06X(int codTipo) {
        boolean retorno = false;
        if (codTipo == 5 || codTipo == 6 || codTipo == 7) {
            retorno = true;
        }
        return retorno;
    }

    public Valor getBolsaEstudos() {
        return this.bolsaEstudos;
    }

    public ColecaoItemQuadroTransporteDetalhado getBolsaEstudosQuadroAuxiliar() {
        return this.bolsaEstudosQuadroAuxiliar;
    }

    public Valor getCapitalApolices() {
        return this.capitalApolices;
    }

    public Valor getIndenizacoes() {
        return this.indenizacoes;
    }

    public ColecaoItemQuadroRendimentosNI getIndenizacoesQuadroAuxiliar() {
        return this.indenizacoesQuadroAuxiliar;
    }

    public Valor getLucroAlienacao() {
        return this.lucroAlienacao;
    }

    public Valor getLucroRecebido() {
        return this.lucroRecebido;
    }

    public Valor getJurosRra() {
        return this.jurosRra;
    }

    public Valor getPensaoAlimenticia() {
        return this.pensaoAlimenticia;
    }

    public Valor getOutros() {
        return this.outros;
    }

    public Valor getParcIsentaAposentadoria() {
        return this.parcIsentaAposentadoria;
    }

    public Valor getParcIsentaAtivRural() {
        return this.parcIsentaAtivRural;
    }

    public Valor getPensao() {
        return this.pensao;
    }

    public Valor getPoupanca() {
        return this.poupanca;
    }

    public Valor getRendSocio() {
        return this.rendSocio;
    }

    public Valor getTotal() {
        return this.total;
    }

    public Valor getTransferencias() {
        return this.transferencias;
    }

    public ColecaoItemQuadroTransporteDetalhado getLucroRecebidoQuadroAuxiliar() {
        return this.lucroRecebidoQuadroAuxiliar;
    }

    public ColecaoItemQuadroPensaoAlimenticiaRendIsentos getPensaoAlimenticiaQuadroAuxiliar() {
        return this.pensaoAlimenticiaQuadroAuxiliar;
    }

    public ColecaoItemQuadroOutrosRendimentos getOutrosQuadroAuxiliar() {
        return this.outrosQuadroAuxiliar;
    }

    public ColecaoItemQuadroTransporteDetalhado getPoupancaQuadroAuxiliar() {
        return this.poupancaQuadroAuxiliar;
    }

    public ColecaoItemQuadroTransporteDetalhado getRendSocioQuadroAuxiliar() {
        return this.rendSocioQuadroAuxiliar;
    }

    public ColecaoItemQuadroTransferenciaPatrimonial getTransferenciasQuadroAuxiliar() {
        return this.transferenciasQuadroAuxiliar;
    }

    public Valor getBensPequenoValorInformado() {
        return this.bensPequenoValorInformado;
    }

    public Valor getBensPequenoValorTransportado() {
        return this.bensPequenoValorTransportado;
    }

    public Valor getMoedaEstrangeiraEspecieInformado() {
        return this.moedaEstrangeiraEspecieInformado;
    }

    public Valor getOutrosBensImoveisInformado() {
        return this.outrosBensImoveisInformado;
    }

    public Valor getOutrosBensImoveisTransportado() {
        return this.outrosBensImoveisTransportado;
    }

    public Valor getUnicoImovelInformado() {
        return this.unicoImovelInformado;
    }

    public ValorPositivo getUnicoImovelTransportado() {
        return this.unicoImovelTransportado;
    }

    public Valor getTotalInformado() {
        return this.totalInformado;
    }

    public ValorPositivo getTotalTransportado() {
        return this.totalTransportado;
    }

    public ValorPositivo getImpostoRendasAnterioresCompensadoJudicialmente() {
        return this.impostoRendasAnterioresCompensadoJudicialmente;
    }

    public ColecaoItemQuadroRendimentosNI getImpostoRendasAnterioresCompensadoJudicialmenteQuadroAuxiliar() {
        return this.impostoRendasAnterioresCompensadoJudicialmenteQuadroAuxiliar;
    }

    public ValorPositivo getRendAssalariadosMoedaEstrangeira() {
        return this.rendAssalariadosMoedaEstrangeira;
    }

    public ColecaoItemQuadroTransporteDetalhado getRendAssalariadoMoedaEstrangeiraQuadroAuxiliar() {
        return this.rendAssalariadoMoedaEstrangeiraQuadroAuxiliar;
    }

    public ValorPositivo getIncorporacaoReservaCapital() {
        return this.incorporacaoReservaCapital;
    }

    public ColecaoItemQuadroTransporteDetalhado getIncorporacaoReservaCapitalQuadroAuxiliar() {
        return this.incorporacaoReservaCapitalQuadroAuxiliar;
    }

    public ColecaoItemQuadroPensaoMolestiaGrave getPensaoQuadroAuxiliar() {
        return this.pensaoQuadroAuxiliar;
    }

    public ValorPositivo getMedicosResidentes() {
        return this.medicosResidentes;
    }

    public ValorPositivo getVoluntariosCopa() {
        return this.voluntariosCopa;
    }

    public ValorPositivo getMeacaoDissolucao() {
        return this.meacaoDissolucao;
    }

    public ValorPositivo getGanhosLiquidosAcoes() {
        return this.ganhosLiquidosAcoes;
    }

    public ValorPositivo getGanhosCapitalOuro() {
        return this.ganhosCapitalOuro;
    }

    public ValorPositivo getRecuperacaoPrejuizosBolsaValores() {
        return this.recuperacaoPrejuizosBolsaValores;
    }

    public ValorPositivo getTransportadorCargas() {
        return this.transportadorCargas;
    }

    public ValorPositivo getTransportadorPassageiros() {
        return this.transportadorPassageiros;
    }

    public ValorPositivo getRestituicaoImpostoRendaAnosAnteriores() {
        return this.restituicaoImpostoRendaAnosAnteriores;
    }

    public ColecaoItemQuadroTransporteDetalhado getMedicosResidentesQuadroAuxiliar() {
        return this.medicosResidentesQuadroAuxiliar;
    }

    public ColecaoItemQuadroTransporteDetalhado getVoluntariosCopaQuadroAuxiliar() {
        return this.voluntariosCopaQuadroAuxiliar;
    }

    public ColecaoItemQuadroMeacaoDissolucao getMeacaoDissolucaoQuadroAuxiliar() {
        return this.meacaoDissolucaoQuadroAuxiliar;
    }

    public ColecaoItemQuadroGanhosAcoesOuro getGanhosLiquidosAcoesQuadroAuxiliar() {
        return this.ganhosLiquidosAcoesQuadroAuxiliar;
    }

    public ColecaoItemQuadroGanhosAcoesOuro getGanhosCapitalOuroQuadroAuxiliar() {
        return this.ganhosCapitalOuroQuadroAuxiliar;
    }

    public ColecaoItemQuadroTransporteDetalhado getParcIsentaAposentadoriaQuadroAuxiliar() {
        return this.parcIsentaAposentadoriaQuadroAuxiliar;
    }

    public ValorPositivo getSomaBensPequenoValor() {
        return this.somaBensPequenoValor;
    }

    public ValorPositivo getSomaUnicoImovel() {
        return this.somaUnicoImovel;
    }

    public ValorPositivo getSomaOutrosBensImoveis() {
        return this.somaOutrosBensImoveis;
    }

    public String getTituloFichaDashboard() {
        return "Rendimentos Isentos e N\u00e3o Tribut\u00e1veis";
    }

    public static void main(String[] args) {
        for (int i = 1; i < 10001; ++i) {
            Object a = "0000000000" + i;
            a = ((String)a).substring(((String)a).length() - 10);
            System.out.println((String)a + "=" + (String)a);
        }
    }

    public void atualizarIndiceBem(String indiceAnterior, String novoIndice) {
        for (Colecao<? extends ItemQuadroAuxiliarAb> colecao : this.getColecoesRendimentos()) {
            for (Object object : colecao.itens()) {
                String indiceAtual;
                if (!(object instanceof ItemQuadroAuxiliarAb) || !(indiceAtual = ((ItemQuadroAuxiliarAb)((Object)object)).getCodBem().naoFormatado()).equals(indiceAnterior)) continue;
                ((ItemQuadroAuxiliarAb)((Object)object)).getCodBem().setConteudo(novoIndice);
            }
        }
    }
}

