/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendIsentos;

import serpro.ppgd.cacheni.CacheNI;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.ObservadorEspacosDuplicados;
import serpro.ppgd.irpf.ValidadorNaoNuloIRPF;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroAuxiliar;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNI;

public class ItemQuadroTransferenciaPatrimonial
extends ItemQuadroAuxiliar {
    private NI niDoadorEspolio = new NI((ObjetoNegocio)this, "CPF/CNPJ do doador/esp\u00f3lio");
    private Alfa nomeDoadorEspolio = new Alfa((ObjetoNegocio)this, "Nome do doador/esp\u00f3lio", 60);

    public ItemQuadroTransferenciaPatrimonial(DeclaracaoIRPF dec) {
        super(dec);
        CacheNI.getInstancia().registrarNINome(this.niDoadorEspolio, this.nomeDoadorEspolio);
        this.getNiDoadorEspolio().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3));
        this.getNiDoadorEspolio().addValidador((ValidadorIf)new ValidadorNI(3){

            public RetornoValidacao validarImplementado() {
                super.setMensagemValidacao(MensagemUtil.getMensagem("campo_invalido", new String[]{this.getInformacao().getNomeCampo()}));
                return super.validarImplementado();
            }
        });
        this.getNiDoadorEspolio().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if (ItemQuadroTransferenciaPatrimonial.this.getCpfBeneficiario().formatado().equals(this.getInformacao().formatado())) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("rendisentos_cpf_doador_espolio_igual_fonte_pagadora"), this.getSeveridade());
                }
                return null;
            }
        });
        this.getNomeDoadorEspolio().addObservador((Observador)new ObservadorEspacosDuplicados());
        this.getNomeDoadorEspolio().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(2));
    }

    public Alfa getNomeDoadorEspolio() {
        return this.nomeDoadorEspolio;
    }

    public NI getNiDoadorEspolio() {
        return this.niDoadorEspolio;
    }

    @Override
    public void adicionaCamposParaPendencia() {
        super.adicionaCamposParaPendencia();
        this.camposPendencia.add(this.niDoadorEspolio);
        this.camposPendencia.add(this.nomeDoadorEspolio);
    }

    @Override
    public NI getNIFontePagadora() {
        return this.getNiDoadorEspolio();
    }

    @Override
    public Alfa getNomeFontePagadora() {
        return this.getNomeDoadorEspolio();
    }

    @Override
    public String getTituloFichaDashboard() {
        return null;
    }
}

