/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendIsentos;

import serpro.ppgd.cacheni.CacheNI;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.ObservadorEspacosDuplicados;
import serpro.ppgd.irpf.ValidadorNaoNuloIRPF;
import serpro.ppgd.irpf.ValorPositivo;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroAuxiliar;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNI;

public class ItemQuadroPensaoMolestiaGrave
extends ItemQuadroAuxiliar {
    public static final String NOME_VALOR_TOTAL = "Total do Rendimento";
    public static final String NOME_VALOR_IRRF = "IRRF";
    public static final String NOME_VALOR_IRRF_13SALARIO = "IRRF sobre o 13\u00ba Sal\u00e1rio";
    public static final String NOME_VALOR_PREVIDENCIA_OFICIAL = "Previd\u00eancia Oficial";
    public static final String NOME_VALOR_RENDIMENTO = "Rendimento";
    private NI niEmpresa = new NI((ObjetoNegocio)this, "CPF/CNPJ da fonte pagadora");
    private Alfa nomeFonte = new Alfa((ObjetoNegocio)this, "Nome da fonte pagadora", 60);
    protected ValorPositivo valorTotal = new ValorPositivo(this, "Total do Rendimento");
    protected ValorPositivo valorIRRF = new ValorPositivo(this, "IRRF");
    protected ValorPositivo valorIRRF13Salario = new ValorPositivo(this, "IRRF sobre o 13\u00ba Sal\u00e1rio");
    protected ValorPositivo valorPrevidenciaOficial = new ValorPositivo(this, "Previd\u00eancia Oficial");

    public ItemQuadroPensaoMolestiaGrave(DeclaracaoIRPF dec) {
        super(dec);
        CacheNI.getInstancia().registrarNINome(this.niEmpresa, this.nomeFonte);
        this.getNiEmpresa().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3));
        this.getNiEmpresa().addValidador((ValidadorIf)new ValidadorNI(3){

            public RetornoValidacao validarImplementado() {
                super.setMensagemValidacao(MensagemUtil.getMensagem("campo_invalido", new String[]{this.getInformacao().getNomeCampo()}));
                return super.validarImplementado();
            }
        });
        this.getNiEmpresa().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if (ItemQuadroPensaoMolestiaGrave.this.getCpfBeneficiario().formatado().equals(this.getInformacao().formatado())) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("rendisentos_pensao_cpf_beneficiario_igual_fonte_pagadora"), this.getSeveridade());
                }
                return null;
            }
        });
        this.getNomeFonte().addObservador((Observador)new ObservadorEspacosDuplicados());
        this.getNomeFonte().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(2));
        this.getValor().getListaValidadores().clear();
        this.getValor().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

            @Override
            public RetornoValidacao validarImplementado() {
                if (ItemQuadroPensaoMolestiaGrave.this.getValor13Salario().isVazio()) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.getValor().setNomeCampo(NOME_VALOR_RENDIMENTO);
        this.getValor13Salario().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

            @Override
            public RetornoValidacao validarImplementado() {
                if (ItemQuadroPensaoMolestiaGrave.this.getValor().isVazio()) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
        CalculaValorRend calculaValorRend = new CalculaValorRend();
        this.getValor().addObservador((Observador)calculaValorRend);
        this.getValor13Salario().addObservador(calculaValorRend);
    }

    public Alfa getNomeFonte() {
        return this.nomeFonte;
    }

    public NI getNiEmpresa() {
        return this.niEmpresa;
    }

    public ValorPositivo getValorIRRF() {
        return this.valorIRRF;
    }

    public ValorPositivo getValorTotal() {
        return this.valorTotal;
    }

    public ValorPositivo getValorIRRF13Salario() {
        return this.valorIRRF13Salario;
    }

    public ValorPositivo getValorPrevidenciaOficial() {
        return this.valorPrevidenciaOficial;
    }

    @Override
    public void adicionaCamposParaPendencia() {
        super.adicionaCamposParaPendencia();
        this.camposPendencia.add(this.niEmpresa);
        this.camposPendencia.add(this.nomeFonte);
        this.camposPendencia.add(this.valorIRRF);
        this.camposPendencia.add(this.valor13Salario);
        this.camposPendencia.add(this.valorIRRF13Salario);
        this.camposPendencia.add(this.valorPrevidenciaOficial);
    }

    @Override
    public NI getNIFontePagadora() {
        return this.getNiEmpresa();
    }

    @Override
    public Valor getValorRendimento() {
        return this.getValorTotal();
    }

    @Override
    public Alfa getNomeFontePagadora() {
        return this.getNomeFonte();
    }

    @Override
    public String getTituloFichaDashboard() {
        return null;
    }

    private class CalculaValorRend
    extends Observador {
        private CalculaValorRend() {
        }

        public void notifica(Object arg0, String arg1, Object arg2, Object arg3) {
            Valor total = new Valor();
            total.append('+', ItemQuadroPensaoMolestiaGrave.this.getValor());
            total.append('+', (Valor)ItemQuadroPensaoMolestiaGrave.this.getValor13Salario());
            ItemQuadroPensaoMolestiaGrave.this.getValorTotal().setConteudo(total);
        }
    }
}

