/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendIsentos;

import java.lang.ref.WeakReference;
import java.util.List;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.ValidadorNaoNuloIRPF;
import serpro.ppgd.irpf.gui.rendIsentos.PainelDadosRendIsentos;
import serpro.ppgd.irpf.gui.rendTributacaoExclusiva.PainelDadosRendTributExclusiva;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroAuxiliarAb;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroTransporteDetalhado;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.util.PreenchedorCodigo;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorCPF;

public abstract class ItemQuadroAuxiliar
extends ItemQuadroAuxiliarAb
implements ObjetoFicha {
    protected WeakReference<ObjetoNegocio> parent;

    public ItemQuadroAuxiliar(final DeclaracaoIRPF dec) {
        PreenchedorCodigo preencheCodigo = new PreenchedorCodigo(this.tipoBeneficiario);
        preencheCodigo.add("Titular").add("Titular").EOL();
        preencheCodigo.add("Dependente").add("Dependente").EOL();
        preencheCodigo.aplicaAlteracoes();
        this.getTipoBeneficiario().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3, "Informe o tipo do benefici\u00e1rio"));
        this.getTipoBeneficiario().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if (("00000".equals(ItemQuadroAuxiliar.this.getCodBem().naoFormatado()) || ItemQuadroAuxiliar.this.getCodBem().isVazio()) && ItemQuadroAuxiliar.this.getTipoBeneficiario().naoFormatado().equals("Dependente") && dec.getDependentes().itens().isEmpty()) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("rendisentos_quadro_auxiliar_dep_sem_dep"));
                }
                return null;
            }
        });
        this.getCpfBeneficiario().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

            @Override
            public RetornoValidacao validarImplementado() {
                if ("00000".equals(ItemQuadroAuxiliar.this.getCodBem().naoFormatado()) || ItemQuadroAuxiliar.this.getCodBem().isVazio()) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.getCpfBeneficiario().addValidador((ValidadorIf)new ValidadorCPF(3){

            public RetornoValidacao validarImplementado() {
                if ("00000".equals(ItemQuadroAuxiliar.this.getCodBem().naoFormatado()) || ItemQuadroAuxiliar.this.getCodBem().isVazio()) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.getValor().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

            @Override
            public RetornoValidacao validarImplementado() {
                if (ItemQuadroAuxiliar.this.getValor().isVazio()) {
                    ItemQuadroTransporteDetalhado item;
                    if (ItemQuadroAuxiliar.this instanceof ItemQuadroTransporteDetalhado && (item = (ItemQuadroTransporteDetalhado)ItemQuadroAuxiliar.this).isParcIsentaAposentadoria()) {
                        if (item.getValor13Salario().isVazio()) {
                            return new RetornoValidacao(MensagemUtil.getMensagem("rendisentos_rendimento_tipo_10_valor_nao_informadao"));
                        }
                        return new RetornoValidacao(0);
                    }
                    return super.validarImplementado();
                }
                return super.validarImplementado();
            }
        });
        if (dec.apenasTitular()) {
            this.getTipoBeneficiario().setConteudo("Titular");
            this.getCpfBeneficiario().setConteudo(dec.getIdentificadorDeclaracao().getCpf());
        }
        this.getTipoBeneficiario().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (ItemQuadroAuxiliar.this.getCodBem().isVazio() && ItemQuadroAuxiliar.this.getTipoBeneficiario().getNomeCampo().equals(nomePropriedade)) {
                    if (valorNovo.equals("Dependente")) {
                        ItemQuadroAuxiliar.this.getCpfBeneficiario().clear();
                        ItemQuadroAuxiliar.this.getCpfBeneficiario().setReadOnly(false);
                        ItemQuadroAuxiliar.this.getCpfBeneficiario().setHabilitado(true);
                    } else {
                        ItemQuadroAuxiliar.this.getCpfBeneficiario().setConteudo(dec.getIdentificadorDeclaracao().getCpf());
                        ItemQuadroAuxiliar.this.getCpfBeneficiario().setReadOnly(true);
                        ItemQuadroAuxiliar.this.getCpfBeneficiario().setHabilitado(false);
                    }
                }
            }
        });
    }

    public ItemQuadroAuxiliar(DeclaracaoIRPF dec, ObjetoNegocio parent) {
        this(dec);
        this.parent = new WeakReference<ObjetoNegocio>(parent);
    }

    protected List<Informacao> recuperarListaCamposPendencia() {
        List lista = this.camposPendencia;
        return lista;
    }

    public String getClasseFicha() {
        return this.parent == null ? PainelDadosRendIsentos.class.getName() : PainelDadosRendTributExclusiva.class.getName();
    }

    public String getTituloFichaDashboard() {
        return this.parent == null ? "Rendimentos Isentos e N\u00e3o Tribut\u00e1veis" : "Rendimentos Sujeitos \u00e0 Tributa\u00e7\u00e3o Exclusiva/Definitiva";
    }

    public String getNomeAba() {
        return this.parent == null ? "Rendimentos" : "Rendimentos";
    }
}

